// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    AccelGroup, Align, Buildable, Container, MenuItem, MenuShell, ResizeMode, ScrollType, Widget,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkMenu")]
    pub struct Menu(Object<ffi::GtkMenu, ffi::GtkMenuClass>) @extends MenuShell, Container, Widget, @implements Buildable;

    match fn {
        type_ => || ffi::gtk_menu_get_type(),
    }
}

impl Menu {
    pub const NONE: Option<&'static Menu> = None;

    #[doc(alias = "gtk_menu_new")]
    pub fn new() -> Menu {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_menu_new()).unsafe_cast() }
    }

    #[doc(alias = "gtk_menu_new_from_model")]
    #[doc(alias = "new_from_model")]
    pub fn from_model(model: &impl IsA<gio::MenuModel>) -> Menu {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_menu_new_from_model(
                model.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Menu`] objects.
    ///
    /// This method returns an instance of [`MenuBuilder`](crate::builders::MenuBuilder) which can be used to create [`Menu`] objects.
    pub fn builder() -> MenuBuilder {
        MenuBuilder::new()
    }

    #[doc(alias = "gtk_menu_get_for_attach_widget")]
    #[doc(alias = "get_for_attach_widget")]
    pub fn for_attach_widget(widget: &impl IsA<Widget>) -> Vec<Widget> {
        skip_assert_initialized!();
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::gtk_menu_get_for_attach_widget(
                widget.as_ref().to_glib_none().0,
            ))
        }
    }
}

impl Default for Menu {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Menu`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct MenuBuilder {
    builder: glib::object::ObjectBuilder<'static, Menu>,
}

impl MenuBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn accel_group(self, accel_group: &impl IsA<AccelGroup>) -> Self {
        Self {
            builder: self
                .builder
                .property("accel-group", accel_group.clone().upcast()),
        }
    }

    pub fn accel_path(self, accel_path: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("accel-path", accel_path.into()),
        }
    }

    pub fn active(self, active: i32) -> Self {
        Self {
            builder: self.builder.property("active", active),
        }
    }

    pub fn anchor_hints(self, anchor_hints: gdk::AnchorHints) -> Self {
        Self {
            builder: self.builder.property("anchor-hints", anchor_hints),
        }
    }

    pub fn attach_widget(self, attach_widget: &impl IsA<Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("attach-widget", attach_widget.clone().upcast()),
        }
    }

    pub fn menu_type_hint(self, menu_type_hint: gdk::WindowTypeHint) -> Self {
        Self {
            builder: self.builder.property("menu-type-hint", menu_type_hint),
        }
    }

    pub fn monitor(self, monitor: i32) -> Self {
        Self {
            builder: self.builder.property("monitor", monitor),
        }
    }

    pub fn rect_anchor_dx(self, rect_anchor_dx: i32) -> Self {
        Self {
            builder: self.builder.property("rect-anchor-dx", rect_anchor_dx),
        }
    }

    pub fn rect_anchor_dy(self, rect_anchor_dy: i32) -> Self {
        Self {
            builder: self.builder.property("rect-anchor-dy", rect_anchor_dy),
        }
    }

    pub fn reserve_toggle_size(self, reserve_toggle_size: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("reserve-toggle-size", reserve_toggle_size),
        }
    }

    pub fn take_focus(self, take_focus: bool) -> Self {
        Self {
            builder: self.builder.property("take-focus", take_focus),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Menu`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Menu {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Menu>> Sealed for T {}
}

pub trait GtkMenuExt: IsA<Menu> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_menu_attach")]
    fn attach(
        &self,
        child: &impl IsA<Widget>,
        left_attach: u32,
        right_attach: u32,
        top_attach: u32,
        bottom_attach: u32,
    ) {
        unsafe {
            ffi::gtk_menu_attach(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                left_attach,
                right_attach,
                top_attach,
                bottom_attach,
            );
        }
    }

    #[doc(alias = "gtk_menu_detach")]
    fn detach(&self) {
        unsafe {
            ffi::gtk_menu_detach(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_menu_get_accel_group")]
    #[doc(alias = "get_accel_group")]
    fn accel_group(&self) -> Option<AccelGroup> {
        unsafe {
            from_glib_none(ffi::gtk_menu_get_accel_group(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_menu_get_accel_path")]
    #[doc(alias = "get_accel_path")]
    fn accel_path(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gtk_menu_get_accel_path(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_menu_get_active")]
    #[doc(alias = "get_active")]
    fn active(&self) -> Option<Widget> {
        unsafe { from_glib_none(ffi::gtk_menu_get_active(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_menu_get_attach_widget")]
    #[doc(alias = "get_attach_widget")]
    fn attach_widget(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_menu_get_attach_widget(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_menu_get_monitor")]
    #[doc(alias = "get_monitor")]
    fn monitor(&self) -> i32 {
        unsafe { ffi::gtk_menu_get_monitor(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_menu_get_reserve_toggle_size")]
    #[doc(alias = "get_reserve_toggle_size")]
    fn must_reserve_toggle_size(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_menu_get_reserve_toggle_size(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_menu_place_on_monitor")]
    fn place_on_monitor(&self, monitor: &gdk::Monitor) {
        unsafe {
            ffi::gtk_menu_place_on_monitor(
                self.as_ref().to_glib_none().0,
                monitor.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_menu_popdown")]
    fn popdown(&self) {
        unsafe {
            ffi::gtk_menu_popdown(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_menu_popup_at_pointer")]
    fn popup_at_pointer(&self, trigger_event: Option<&gdk::Event>) {
        unsafe {
            ffi::gtk_menu_popup_at_pointer(
                self.as_ref().to_glib_none().0,
                trigger_event.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_menu_popup_at_rect")]
    fn popup_at_rect(
        &self,
        rect_window: &gdk::Window,
        rect: &gdk::Rectangle,
        rect_anchor: gdk::Gravity,
        menu_anchor: gdk::Gravity,
        trigger_event: Option<&gdk::Event>,
    ) {
        unsafe {
            ffi::gtk_menu_popup_at_rect(
                self.as_ref().to_glib_none().0,
                rect_window.to_glib_none().0,
                rect.to_glib_none().0,
                rect_anchor.into_glib(),
                menu_anchor.into_glib(),
                trigger_event.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_menu_popup_at_widget")]
    fn popup_at_widget(
        &self,
        widget: &impl IsA<Widget>,
        widget_anchor: gdk::Gravity,
        menu_anchor: gdk::Gravity,
        trigger_event: Option<&gdk::Event>,
    ) {
        unsafe {
            ffi::gtk_menu_popup_at_widget(
                self.as_ref().to_glib_none().0,
                widget.as_ref().to_glib_none().0,
                widget_anchor.into_glib(),
                menu_anchor.into_glib(),
                trigger_event.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_menu_reorder_child")]
    fn reorder_child(&self, child: &impl IsA<Widget>, position: i32) {
        unsafe {
            ffi::gtk_menu_reorder_child(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                position,
            );
        }
    }

    #[doc(alias = "gtk_menu_reposition")]
    fn reposition(&self) {
        unsafe {
            ffi::gtk_menu_reposition(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_menu_set_accel_group")]
    fn set_accel_group(&self, accel_group: Option<&impl IsA<AccelGroup>>) {
        unsafe {
            ffi::gtk_menu_set_accel_group(
                self.as_ref().to_glib_none().0,
                accel_group.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_menu_set_accel_path")]
    fn set_accel_path(&self, accel_path: Option<&str>) {
        unsafe {
            ffi::gtk_menu_set_accel_path(
                self.as_ref().to_glib_none().0,
                accel_path.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_menu_set_active")]
    fn set_active(&self, index: u32) {
        unsafe {
            ffi::gtk_menu_set_active(self.as_ref().to_glib_none().0, index);
        }
    }

    #[doc(alias = "gtk_menu_set_monitor")]
    fn set_monitor(&self, monitor_num: i32) {
        unsafe {
            ffi::gtk_menu_set_monitor(self.as_ref().to_glib_none().0, monitor_num);
        }
    }

    #[doc(alias = "gtk_menu_set_reserve_toggle_size")]
    fn set_reserve_toggle_size(&self, reserve_toggle_size: bool) {
        unsafe {
            ffi::gtk_menu_set_reserve_toggle_size(
                self.as_ref().to_glib_none().0,
                reserve_toggle_size.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_menu_set_screen")]
    fn set_screen(&self, screen: Option<&gdk::Screen>) {
        unsafe {
            ffi::gtk_menu_set_screen(self.as_ref().to_glib_none().0, screen.to_glib_none().0);
        }
    }

    #[doc(alias = "anchor-hints")]
    fn anchor_hints(&self) -> gdk::AnchorHints {
        ObjectExt::property(self.as_ref(), "anchor-hints")
    }

    #[doc(alias = "anchor-hints")]
    fn set_anchor_hints(&self, anchor_hints: gdk::AnchorHints) {
        ObjectExt::set_property(self.as_ref(), "anchor-hints", anchor_hints)
    }

    #[doc(alias = "attach-widget")]
    fn set_attach_widget<P: IsA<Widget>>(&self, attach_widget: Option<&P>) {
        ObjectExt::set_property(self.as_ref(), "attach-widget", attach_widget)
    }

    #[doc(alias = "menu-type-hint")]
    fn menu_type_hint(&self) -> gdk::WindowTypeHint {
        ObjectExt::property(self.as_ref(), "menu-type-hint")
    }

    #[doc(alias = "menu-type-hint")]
    fn set_menu_type_hint(&self, menu_type_hint: gdk::WindowTypeHint) {
        ObjectExt::set_property(self.as_ref(), "menu-type-hint", menu_type_hint)
    }

    #[doc(alias = "rect-anchor-dx")]
    fn rect_anchor_dx(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "rect-anchor-dx")
    }

    #[doc(alias = "rect-anchor-dx")]
    fn set_rect_anchor_dx(&self, rect_anchor_dx: i32) {
        ObjectExt::set_property(self.as_ref(), "rect-anchor-dx", rect_anchor_dx)
    }

    #[doc(alias = "rect-anchor-dy")]
    fn rect_anchor_dy(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "rect-anchor-dy")
    }

    #[doc(alias = "rect-anchor-dy")]
    fn set_rect_anchor_dy(&self, rect_anchor_dy: i32) {
        ObjectExt::set_property(self.as_ref(), "rect-anchor-dy", rect_anchor_dy)
    }

    #[doc(alias = "item.bottom-attach")]
    fn item_bottom_attach<T: IsA<MenuItem>>(&self, item: &T) -> i32 {
        crate::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "bottom-attach",
        )
    }

    #[doc(alias = "item.bottom-attach")]
    fn set_item_bottom_attach<T: IsA<MenuItem>>(&self, item: &T, bottom_attach: i32) {
        crate::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "bottom-attach",
            &bottom_attach,
        )
    }

    #[doc(alias = "item.left-attach")]
    fn item_left_attach<T: IsA<MenuItem>>(&self, item: &T) -> i32 {
        crate::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "left-attach",
        )
    }

    #[doc(alias = "item.left-attach")]
    fn set_item_left_attach<T: IsA<MenuItem>>(&self, item: &T, left_attach: i32) {
        crate::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "left-attach",
            &left_attach,
        )
    }

    #[doc(alias = "item.right-attach")]
    fn item_right_attach<T: IsA<MenuItem>>(&self, item: &T) -> i32 {
        crate::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "right-attach",
        )
    }

    #[doc(alias = "item.right-attach")]
    fn set_item_right_attach<T: IsA<MenuItem>>(&self, item: &T, right_attach: i32) {
        crate::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "right-attach",
            &right_attach,
        )
    }

    #[doc(alias = "item.top-attach")]
    fn item_top_attach<T: IsA<MenuItem>>(&self, item: &T) -> i32 {
        crate::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "top-attach",
        )
    }

    #[doc(alias = "item.top-attach")]
    fn set_item_top_attach<T: IsA<MenuItem>>(&self, item: &T, top_attach: i32) {
        crate::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "top-attach",
            &top_attach,
        )
    }

    #[doc(alias = "move-scroll")]
    fn connect_move_scroll<F: Fn(&Self, ScrollType) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn move_scroll_trampoline<
            P: IsA<Menu>,
            F: Fn(&P, ScrollType) + 'static,
        >(
            this: *mut ffi::GtkMenu,
            scroll_type: ffi::GtkScrollType,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Menu::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(scroll_type),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-scroll\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_scroll_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_scroll(&self, scroll_type: ScrollType) {
        self.emit_by_name::<()>("move-scroll", &[&scroll_type]);
    }

    //#[doc(alias = "popped-up")]
    //fn connect_popped_up<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId {
    //    Unimplemented flipped_rect: *.Pointer
    //    Unimplemented final_rect: *.Pointer
    //}

    #[doc(alias = "accel-group")]
    fn connect_accel_group_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_accel_group_trampoline<P: IsA<Menu>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkMenu,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Menu::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::accel-group\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_accel_group_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "accel-path")]
    fn connect_accel_path_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_accel_path_trampoline<P: IsA<Menu>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkMenu,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Menu::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::accel-path\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_accel_path_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "active")]
    fn connect_active_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_active_trampoline<P: IsA<Menu>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkMenu,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Menu::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::active\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_active_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "anchor-hints")]
    fn connect_anchor_hints_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_anchor_hints_trampoline<P: IsA<Menu>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkMenu,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Menu::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::anchor-hints\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_anchor_hints_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "attach-widget")]
    fn connect_attach_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attach_widget_trampoline<P: IsA<Menu>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkMenu,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Menu::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::attach-widget\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_attach_widget_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "menu-type-hint")]
    fn connect_menu_type_hint_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_menu_type_hint_trampoline<P: IsA<Menu>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkMenu,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Menu::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::menu-type-hint\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_menu_type_hint_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "monitor")]
    fn connect_monitor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_monitor_trampoline<P: IsA<Menu>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkMenu,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Menu::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::monitor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_monitor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "rect-anchor-dx")]
    fn connect_rect_anchor_dx_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_rect_anchor_dx_trampoline<P: IsA<Menu>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkMenu,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Menu::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::rect-anchor-dx\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_rect_anchor_dx_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "rect-anchor-dy")]
    fn connect_rect_anchor_dy_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_rect_anchor_dy_trampoline<P: IsA<Menu>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkMenu,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Menu::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::rect-anchor-dy\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_rect_anchor_dy_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "reserve-toggle-size")]
    fn connect_reserve_toggle_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reserve_toggle_size_trampoline<
            P: IsA<Menu>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkMenu,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Menu::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::reserve-toggle-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_reserve_toggle_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Menu>> GtkMenuExt for O {}

impl fmt::Display for Menu {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Menu")
    }
}
