/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.KeepMarker;

public class DuplicateInitializerFixer
extends SimplifiedVisitor
implements MemberVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private static final char[] TYPES = new char[]{'B', 'C', 'S', 'I', 'Z'};
    private final MemberVisitor extraFixedInitializerVisitor;

    public DuplicateInitializerFixer() {
        this(null);
    }

    public DuplicateInitializerFixer(MemberVisitor memberVisitor) {
        this.extraFixedInitializerVisitor = memberVisitor;
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String string;
        Method method;
        String string2 = programMethod.getName(programClass);
        if (string2.equals("<init>") && !programMethod.equals(method = programClass.findMethod(string2, string = programMethod.getDescriptor(programClass)))) {
            if (KeepMarker.isKept(programMethod)) {
                programMethod = (ProgramMethod)method;
            }
            int n = string.indexOf(41);
            int n2 = 0;
            while (true) {
                StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
                for (int i = 0; i < n2 / TYPES.length; ++i) {
                    stringBuffer.append('[');
                }
                stringBuffer.append(TYPES[n2 % TYPES.length]);
                stringBuffer.append(string.substring(n));
                String string3 = stringBuffer.toString();
                if (programClass.findMethod(string2, string3) == null) {
                    programMethod.u2descriptorIndex = new ConstantPoolEditor(programClass).addUtf8Constant(string3);
                    programMethod.attributesAccept(programClass, this);
                    if (this.extraFixedInitializerVisitor != null) {
                        this.extraFixedInitializerVisitor.visitProgramMethod(programClass, programMethod);
                    }
                    return;
                }
                ++n2;
            }
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int n = ClassUtil.internalMethodParameterSize(method.getDescriptor(clazz), method.getAccessFlags());
        if (codeAttribute.u2maxLocals < n) {
            codeAttribute.u2maxLocals = n;
        }
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, Method method, SignatureAttribute signatureAttribute) {
        String string = method.getDescriptor(clazz);
        int n = string.indexOf(41);
        String string2 = signatureAttribute.getSignature(clazz);
        int n2 = string2.indexOf(41);
        String string3 = string2.substring(0, n2) + string.charAt(n - 1) + string2.substring(n2);
        signatureAttribute.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string3);
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        int n = parameterAnnotationsAttribute.u1parametersCount++;
        if (parameterAnnotationsAttribute.u2parameterAnnotationsCount == null || parameterAnnotationsAttribute.u2parameterAnnotationsCount.length < parameterAnnotationsAttribute.u1parametersCount) {
            int[] nArray = new int[parameterAnnotationsAttribute.u1parametersCount];
            Annotation[][] annotationArrayArray = new Annotation[parameterAnnotationsAttribute.u1parametersCount][];
            System.arraycopy(parameterAnnotationsAttribute.u2parameterAnnotationsCount, 0, nArray, 0, n);
            System.arraycopy(parameterAnnotationsAttribute.parameterAnnotations, 0, annotationArrayArray, 0, n);
            parameterAnnotationsAttribute.u2parameterAnnotationsCount = nArray;
            parameterAnnotationsAttribute.parameterAnnotations = annotationArrayArray;
        }
    }
}

