/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.collect;

import com.squareup.haha.guava.base.Ascii;
import com.squareup.haha.guava.collect.AbstractIndexedListIterator;
import com.squareup.haha.guava.collect.ImmutableCollection;
import com.squareup.haha.guava.collect.Iterators;
import com.squareup.haha.guava.collect.ObjectArrays;
import com.squareup.haha.guava.collect.RegularImmutableList;
import com.squareup.haha.guava.collect.SingletonImmutableList;
import com.squareup.haha.guava.collect.UnmodifiableIterator;
import com.squareup.haha.guava.collect.UnmodifiableListIterator;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import javax.annotation.Nullable;

public abstract class ImmutableList<E>
extends ImmutableCollection<E>
implements List<E>,
RandomAccess {
    static final ImmutableList<Object> EMPTY = new RegularImmutableList<Object>(ObjectArrays.EMPTY_ARRAY);

    public static <E> ImmutableList<E> of() {
        return EMPTY;
    }

    public static <E> ImmutableList<E> of(E element) {
        return new SingletonImmutableList<E>(element);
    }

    public static <E> ImmutableList<E> of(E e1, E e2) {
        Object[] objectArray = new Object[]{e1, e2};
        return ImmutableList.asImmutableList(ObjectArrays.checkElementsNotNull(objectArray));
    }

    public static <E> ImmutableList<E> copyOf(Collection<? extends E> elements) {
        if (elements instanceof ImmutableCollection) {
            ImmutableList list = ((ImmutableCollection)elements).asList();
            if (list.isPartialView()) {
                return ImmutableList.asImmutableList(list.toArray());
            }
            return list;
        }
        Object[] objectArray = elements.toArray();
        return ImmutableList.asImmutableList(ObjectArrays.checkElementsNotNull(objectArray));
    }

    static <E> ImmutableList<E> asImmutableList(Object[] elements) {
        int n = elements.length;
        Object[] objectArray = elements;
        switch (n) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                SingletonImmutableList<Object> singletonImmutableList = new SingletonImmutableList<Object>(objectArray[0]);
                return singletonImmutableList;
            }
        }
        if (n < objectArray.length) {
            objectArray = ObjectArrays.arraysCopyOf(objectArray, n);
        }
        return new RegularImmutableList(objectArray);
    }

    ImmutableList() {
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        ImmutableList immutableList = this;
        return immutableList.listIterator(0);
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return new AbstractIndexedListIterator<E>(this, this.size(), index){
            private /* synthetic */ ImmutableList this$0;
            {
                this.this$0 = immutableList;
                super(x0, x1);
            }

            @Override
            protected final E get(int index) {
                return this.this$0.get(index);
            }
        };
    }

    @Override
    public int indexOf(@Nullable Object object) {
        if (object != null) {
            Object object2 = object;
            ImmutableList immutableList = this;
            ListIterator listIterator = immutableList.listIterator();
            while (listIterator.hasNext()) {
                if (!Ascii.equal(object2, listIterator.next())) continue;
                return listIterator.previousIndex();
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object object) {
        if (object != null) {
            Object object2 = object;
            ImmutableList immutableList = this;
            ListIterator listIterator = immutableList.listIterator(immutableList.size());
            while (listIterator.hasPrevious()) {
                if (!Ascii.equal(object2, listIterator.previous())) continue;
                return listIterator.nextIndex();
            }
        }
        return -1;
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        Ascii.checkPositionIndexes(fromIndex, toIndex, this.size());
        int length = toIndex - fromIndex;
        switch (length) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return ImmutableList.of(this.get(fromIndex));
            }
        }
        return this.subListUnchecked(fromIndex, toIndex);
    }

    ImmutableList<E> subListUnchecked(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex - fromIndex);
    }

    @Override
    @Deprecated
    public final boolean addAll(int index, Collection<? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ImmutableList<E> asList() {
        return this;
    }

    @Override
    int copyIntoArray(Object[] dst, int offset) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            dst[offset + i] = this.get(i);
        }
        return offset + size;
    }

    public ImmutableList<E> reverse() {
        return new ReverseImmutableList(this);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        Object object = obj;
        ImmutableList immutableList = this;
        if (object == Ascii.checkNotNull(immutableList)) {
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (immutableList.size() == list.size() && Iterators.elementsEqual(immutableList.iterator(), list.iterator())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            hashCode = hashCode * 31 + this.get(i).hashCode();
            hashCode = ~(~hashCode);
        }
        return hashCode;
    }

    static final class ReverseImmutableList<E>
    extends ImmutableList<E> {
        private final transient ImmutableList<E> forwardList;

        ReverseImmutableList(ImmutableList<E> backingList) {
            this.forwardList = backingList;
        }

        private int reverseIndex(int index) {
            return this.size() - 1 - index;
        }

        @Override
        public final ImmutableList<E> reverse() {
            return this.forwardList;
        }

        @Override
        public final boolean contains(@Nullable Object object) {
            return this.forwardList.contains(object);
        }

        @Override
        public final int indexOf(@Nullable Object object) {
            int index = this.forwardList.lastIndexOf(object);
            if (index >= 0) {
                return this.reverseIndex(index);
            }
            return -1;
        }

        @Override
        public final int lastIndexOf(@Nullable Object object) {
            int index = this.forwardList.indexOf(object);
            if (index >= 0) {
                return this.reverseIndex(index);
            }
            return -1;
        }

        @Override
        public final ImmutableList<E> subList(int fromIndex, int toIndex) {
            Ascii.checkPositionIndexes(fromIndex, toIndex, this.size());
            int n = toIndex;
            ReverseImmutableList reverseImmutableList = this;
            int n2 = reverseImmutableList.size() - n;
            n = fromIndex;
            reverseImmutableList = this;
            return ((ImmutableList)this.forwardList.subList(n2, reverseImmutableList.size() - n)).reverse();
        }

        @Override
        public final E get(int index) {
            Ascii.checkElementIndex(index, this.size());
            return this.forwardList.get(this.reverseIndex(index));
        }

        @Override
        public final int size() {
            return this.forwardList.size();
        }

        @Override
        final boolean isPartialView() {
            return this.forwardList.isPartialView();
        }
    }

    final class SubList
    extends ImmutableList<E> {
        private transient int offset;
        private transient int length;
        private /* synthetic */ ImmutableList this$0;

        SubList(ImmutableList immutableList, int offset, int length) {
            this.this$0 = immutableList;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public final int size() {
            return this.length;
        }

        @Override
        public final E get(int index) {
            Ascii.checkElementIndex(index, this.length);
            return this.this$0.get(index + this.offset);
        }

        @Override
        public final ImmutableList<E> subList(int fromIndex, int toIndex) {
            Ascii.checkPositionIndexes(fromIndex, toIndex, this.length);
            return this.this$0.subList(fromIndex + this.offset, toIndex + this.offset);
        }

        @Override
        final boolean isPartialView() {
            return true;
        }
    }
}

