/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.collect;

import com.squareup.haha.guava.collect.ImmutableSortedSet;
import com.squareup.haha.guava.collect.Ordering;
import com.squareup.haha.guava.collect.UnmodifiableIterator;

final class DescendingImmutableSortedSet<E>
extends ImmutableSortedSet<E> {
    private final ImmutableSortedSet<E> forward;

    DescendingImmutableSortedSet(ImmutableSortedSet<E> forward) {
        super(Ordering.from(forward.comparator()).reverse());
        this.forward = forward;
    }

    @Override
    public final int size() {
        return this.forward.size();
    }

    @Override
    public final UnmodifiableIterator<E> iterator() {
        return this.forward.descendingIterator();
    }

    @Override
    final ImmutableSortedSet<E> headSetImpl(E toElement, boolean inclusive) {
        return ((ImmutableSortedSet)this.forward.tailSet((Object)toElement, inclusive)).descendingSet();
    }

    @Override
    final ImmutableSortedSet<E> subSetImpl(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return ((ImmutableSortedSet)this.forward.subSet((Object)toElement, toInclusive, (Object)fromElement, fromInclusive)).descendingSet();
    }

    @Override
    final ImmutableSortedSet<E> tailSetImpl(E fromElement, boolean inclusive) {
        return ((ImmutableSortedSet)this.forward.headSet((Object)fromElement, inclusive)).descendingSet();
    }

    @Override
    public final ImmutableSortedSet<E> descendingSet() {
        return this.forward;
    }

    @Override
    public final UnmodifiableIterator<E> descendingIterator() {
        return this.forward.iterator();
    }

    @Override
    final ImmutableSortedSet<E> createDescendingSet() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public final E lower(E element) {
        return this.forward.higher(element);
    }

    @Override
    public final E floor(E element) {
        return this.forward.ceiling(element);
    }

    @Override
    public final E ceiling(E element) {
        return this.forward.floor(element);
    }

    @Override
    public final E higher(E element) {
        return this.forward.lower(element);
    }

    @Override
    final boolean isPartialView() {
        return this.forward.isPartialView();
    }
}

