/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.base;

import com.squareup.haha.guava.base.Ascii;
import com.squareup.haha.guava.base.Predicate;
import java.util.Arrays;

public abstract class CharMatcher
implements Predicate<Character> {
    private static final String NINES;
    private String description;
    static final int WHITESPACE_SHIFT;

    private static String showCharacter(char c) {
        String hex = "0123456789ABCDEF";
        char[] tmp = new char[]{'\\', 'u', '\u0000', '\u0000', '\u0000', '\u0000'};
        for (int i = 0; i < 4; ++i) {
            tmp[5 - i] = hex.charAt(c & 0xF);
            c = (char)(c >> 4);
        }
        return String.copyValueOf(tmp);
    }

    private static CharMatcher inRange(char startInclusive, char endInclusive) {
        Ascii.checkArgument(endInclusive >= startInclusive);
        String description = "CharMatcher.inRange('" + CharMatcher.showCharacter(startInclusive) + "', '" + CharMatcher.showCharacter(endInclusive) + "')";
        return CharMatcher.inRange(startInclusive, endInclusive, description);
    }

    private static CharMatcher inRange(char startInclusive, char endInclusive, String description) {
        return new FastMatcher(description, startInclusive, endInclusive){
            private /* synthetic */ char val$startInclusive;
            private /* synthetic */ char val$endInclusive;
            {
                this.val$startInclusive = c;
                this.val$endInclusive = c2;
                super(x0);
            }

            @Override
            public final boolean matches(char c) {
                return this.val$startInclusive <= c && c <= this.val$endInclusive;
            }
        };
    }

    CharMatcher(String description) {
        this.description = description;
    }

    protected CharMatcher() {
        this.description = super.toString();
    }

    public abstract boolean matches(char var1);

    public CharMatcher or(CharMatcher other) {
        return new Or(this, Ascii.checkNotNull(other));
    }

    CharMatcher withToString(String description) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean apply(Character character) {
        return this.matches(character.charValue());
    }

    public String toString() {
        return this.description;
    }

    static {
        new CharMatcher(){

            @Override
            public final boolean matches(char c) {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\u0085': 
                    case '\u1680': 
                    case '\u2028': 
                    case '\u2029': 
                    case '\u205f': 
                    case '\u3000': {
                        return true;
                    }
                    case '\u2007': {
                        return false;
                    }
                }
                return c >= '\u2000' && c <= '\u200a';
            }

            @Override
            public final String toString() {
                return "CharMatcher.BREAKING_WHITESPACE";
            }
        };
        CharMatcher.inRange('\u0000', '\u007f', "CharMatcher.ASCII");
        StringBuilder builder = new StringBuilder(31);
        for (int i = 0; i < 31; ++i) {
            builder.append((char)("0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10".charAt(i) + 9));
        }
        NINES = builder.toString();
        new RangesMatcher("CharMatcher.DIGIT", "0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10".toCharArray(), NINES.toCharArray());
        new CharMatcher("CharMatcher.JAVA_DIGIT"){

            @Override
            public final boolean matches(char c) {
                return Character.isDigit(c);
            }
        };
        new CharMatcher("CharMatcher.JAVA_LETTER"){

            @Override
            public final boolean matches(char c) {
                return Character.isLetter(c);
            }
        };
        new CharMatcher("CharMatcher.JAVA_LETTER_OR_DIGIT"){

            @Override
            public final boolean matches(char c) {
                return Character.isLetterOrDigit(c);
            }
        };
        new CharMatcher("CharMatcher.JAVA_UPPER_CASE"){

            @Override
            public final boolean matches(char c) {
                return Character.isUpperCase(c);
            }
        };
        new CharMatcher("CharMatcher.JAVA_LOWER_CASE"){

            @Override
            public final boolean matches(char c) {
                return Character.isLowerCase(c);
            }
        };
        CharMatcher.inRange('\u0000', '\u001f').or(CharMatcher.inRange('\u007f', '\u009f')).withToString("CharMatcher.JAVA_ISO_CONTROL");
        new RangesMatcher("CharMatcher.INVISIBLE", "\u0000\u007f\u00ad\u0600\u061c\u06dd\u070f\u1680\u180e\u2000\u2028\u205f\u2066\u2067\u2068\u2069\u206a\u3000\ud800\ufeff\ufff9\ufffa".toCharArray(), " \u00a0\u00ad\u0604\u061c\u06dd\u070f\u1680\u180e\u200f\u202f\u2064\u2066\u2067\u2068\u2069\u206f\u3000\uf8ff\ufeff\ufff9\ufffb".toCharArray());
        new RangesMatcher("CharMatcher.SINGLE_WIDTH", "\u0000\u05be\u05d0\u05f3\u0600\u0750\u0e00\u1e00\u2100\ufb50\ufe70\uff61".toCharArray(), "\u04f9\u05be\u05ea\u05f4\u06ff\u077f\u0e7f\u20af\u213a\ufdff\ufeff\uffdc".toCharArray());
        new FastMatcher("CharMatcher.ANY"){

            @Override
            public final boolean matches(char c) {
                return true;
            }

            @Override
            public final CharMatcher or(CharMatcher other) {
                Ascii.checkNotNull(other);
                return this;
            }
        };
        new FastMatcher("CharMatcher.NONE"){

            @Override
            public final boolean matches(char c) {
                return false;
            }

            @Override
            public final CharMatcher or(CharMatcher other) {
                return Ascii.checkNotNull(other);
            }
        };
        WHITESPACE_SHIFT = Integer.numberOfLeadingZeros(32 - 1);
        new FastMatcher("WHITESPACE"){

            @Override
            public final boolean matches(char c) {
                return "\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".charAt(c * 1682554634 >>> WHITESPACE_SHIFT) == c;
            }
        };
    }

    static abstract class FastMatcher
    extends CharMatcher {
        FastMatcher(String description) {
            super(description);
        }
    }

    static final class Or
    extends CharMatcher {
        private CharMatcher first;
        private CharMatcher second;

        private Or(CharMatcher a, CharMatcher b, String description) {
            super(description);
            this.first = Ascii.checkNotNull(a);
            this.second = Ascii.checkNotNull(b);
        }

        Or(CharMatcher a, CharMatcher b) {
            this(a, b, "CharMatcher.or(" + a + ", " + b + ")");
        }

        @Override
        public final boolean matches(char c) {
            return this.first.matches(c) || this.second.matches(c);
        }

        @Override
        final CharMatcher withToString(String description) {
            return new Or(this.first, this.second, description);
        }
    }

    static final class RangesMatcher
    extends CharMatcher {
        private final char[] rangeStarts;
        private final char[] rangeEnds;

        RangesMatcher(String description, char[] rangeStarts, char[] rangeEnds) {
            super(description);
            this.rangeStarts = rangeStarts;
            this.rangeEnds = rangeEnds;
            Ascii.checkArgument(rangeStarts.length == rangeEnds.length);
            for (int i = 0; i < rangeStarts.length; ++i) {
                Ascii.checkArgument(rangeStarts[i] <= rangeEnds[i]);
                if (i + 1 >= rangeStarts.length) continue;
                Ascii.checkArgument(rangeEnds[i] < rangeStarts[i + 1]);
            }
        }

        @Override
        public final boolean matches(char c) {
            int index = Arrays.binarySearch(this.rangeStarts, c);
            if (index >= 0) {
                return true;
            }
            return (index = ~index - 1) >= 0 && c <= this.rangeEnds[index];
        }
    }
}

