// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0
#pragma once

#include "formeditorview.h"

#include <QPointF>

namespace QmlDesigner {

class SingleSelectionManipulator
{
public:
    SingleSelectionManipulator(FormEditorView *editorView);

//    void setItems(const QList<FormEditorItem*> &itemList);

    enum SelectionType {
        ReplaceSelection,
        AddToSelection,
        RemoveFromSelection,
        InvertSelection
    };

    void begin(const QPointF& beginPoint);
    void update(const QPointF& updatePoint);
    void end(const QPointF& updatePoint);

    void select(SelectionType selectionType);

    void clear();

    QPointF beginPoint() const;

    bool isActive() const;

private:
    QList<QmlItemNode> m_oldSelectionList;
    QPointF m_beginPoint;
    FormEditorView *m_editorView;
    bool m_isActive;
};

} // namespace QmlDesigner
