#include "txwidget.h"
#include <rxwidget.h>
#include "ui_txwidget.h"
#include <QTimer>
#include "configparams.h"
#include "dispatcher.h"
#include "utils/supportfunctions.h"
#include "gallerywidget.h"

#include "ui_freqform.h"
#include "ui_sweepform.h"
#include "widgets/cameracontrol.h"
#include "videocapt/videocapture.h"
#include "sound/soundio.h"
#include "widgets/waterfallform.h"
#include "drmtx/bsrform.h"
#include "drmrx/fixform.h"
#include "mainwindow.h"




txWidget *txWidgetPtr;

txWidget::txWidget(QWidget *parent) :
  QWidget(parent),
  ui(new Ui::txWidget)
{
  int i;
  QString tmp;
  ui->setupUi(this);
  txFunctionsPtr=new txFunctions();
  imageViewerPtr=ui->imageFrame;
  imageViewerPtr->createImage(QSize(320,256),QColor(0,0,128));
  imageViewerPtr->displayImage(false);
  readSettings();
  setProfileNames();

  for(i=0;i<NUMSSTVMODES-1;i++) // exclude Calibrate
    {
      ui->sstvModeComboBox->addItem(getSSTVModeNameLong((esstvMode)i));
    }
  connect(ui->sstvModeComboBox,SIGNAL(activated(int)),SLOT(slotModeChanged(int )));
  connect(ui->templatesComboBox,SIGNAL(currentIndexChanged(int)),SLOT(slotGetParams()));
  connect(ui->templateCheckBox,SIGNAL(toggled(bool)),SLOT(slotGetParams()));
  connect(ui->cwCheckBox,SIGNAL(toggled(bool)),SLOT(slotGetParams()));
  connect(ui->voxCheckBox,SIGNAL(toggled(bool)),SLOT(slotGetParams()));
  connect(ui->toCallLineEdit,SIGNAL(editingFinished ()),SLOT(slotGetParams()));
  connect(ui->operatorLineEdit,SIGNAL(editingFinished ()),SLOT(slotGetParams()));
  connect(ui->rsvLineEdit,SIGNAL(editingFinished ()),SLOT(slotGetParams()));
  connect(ui->comment1LineEdit,SIGNAL(editingFinished ()),SLOT(slotGetParams()));
  connect(ui->comment2LineEdit,SIGNAL(editingFinished ()),SLOT(slotGetParams()));
  connect(ui->comment3LineEdit,SIGNAL(editingFinished ()),SLOT(slotGetParams()));
  connect(ui->startToolButton, SIGNAL(clicked()), this, SLOT(slotStart()));
//  connect(ui->hybridCheckBox, SIGNAL(toggled(bool)), this, SLOT(slotHybridStart(bool)));
  connect(ui->stopToolButton, SIGNAL(clicked()), this, SLOT(slotStop()));
  connect(ui->drmProfileComboBox,SIGNAL(activated(int)),SLOT(slotProfileChanged(int )));

  connect(ui->generateToneToolButton, SIGNAL(clicked()), this, SLOT(slotGenerateSignal()));
  connect(ui->sweepToneToolButton, SIGNAL(clicked()), this, SLOT(slotSweepSignal()));
  connect(ui->repeaterToneToolButton, SIGNAL(clicked()), this, SLOT(slotGenerateRepeaterTone()));
  connect(ui->openToolButton, SIGNAL(clicked()), this, SLOT(slotFileOpen()));
  //   connect(ui->actionAlignement, SIGNAL(triggered()), this, SLOT(slotAlignementSignal()));
  connect(ui->editToolButton, SIGNAL(clicked()), this, SLOT(slotEdit()));
  //   connect(ui->actionReplay, SIGNAL(triggered()), this, SLOT(slotReplay()));
  connect(ui->snapshotToolButton, SIGNAL(clicked()), this, SLOT(slotSnapshot()));
  connect(imageViewerPtr, SIGNAL(imageChanged()), this, SLOT(slotGetParams()));
  connect(ui->sizeSlider,SIGNAL(valueChanged(int)),SLOT(slotSize(int)));
  connect(ui->sizeSlider,SIGNAL(sliderReleased()),SLOT(slotSizeApply()));
  connect(ui->settingsTableWidget,SIGNAL(currentChanged(int)),this, SLOT(slotTransmissionMode(int)));
  connect(ui->imageFrame,SIGNAL(imageChanged()),SLOT(slotImageChanged()));


  currentTXMode=NOMODE;
}

txWidget::~txWidget()
{
    delete ui;
}

void txWidget::init()
{
  splashStr+=QString( "Setting up TX" ).rightJustified(25,' ')+"\n";
  splashPtr->showMessage ( splashStr ,Qt::AlignLeft,Qt::white);
  qApp->processEvents();
  ed=NULL;
  repeaterIndex=0;
  initView();
  repeaterTimer=new QTimer(this);
  connect(repeaterTimer,SIGNAL(timeout()),SLOT(slotRepeaterTimer()));
  repeaterTimer->start(60000*repeaterImageInterval);
  imageViewerPtr->setType(imageViewer::TXIMG);
  slotModeChanged(modeIndexTx);
  slotSize(sizeRatio);
  txFunctionsPtr->start();

}

void txWidget::readSettings()
{
  QSettings qSettings;
  qSettings.beginGroup("TX");
  modeIndexTx=((esstvMode)qSettings.value("modeIndexTx",0).toInt());
  templateIndex=qSettings.value("templateIndex",0).toInt();
  useTemplate=qSettings.value("useTemplate",false).toBool();
  useCW=qSettings.value("useCW",false).toBool();
  useVOX=qSettings.value("useVOX",false).toBool();
  useHybrid=qSettings.value("useHybrid",false).toBool();
  sizeRatio=qSettings.value("sizeRatio",25).toInt();
  drmParams.bandwith=qSettings.value("drmBandWith",0).toInt();
  drmParams.interleaver=qSettings.value("drmInterLeaver",0).toInt();
  drmParams.protection=qSettings.value("drmProtection",0).toInt();
  drmParams.qam=qSettings.value("drmQAM",0).toInt();
  drmParams.robMode=qSettings.value("drmRobMode",0).toInt();
  drmParams.reedSolomon=qSettings.value("drmReedSolomon",0).toInt();
  qSettings.endGroup();
  setParams();
}

void txWidget::writeSettings()
{
  QSettings qSettings;
  slotGetParams();
  qSettings.beginGroup("TX");
  qSettings.setValue( "modeIndexTx", modeIndexTx);
  qSettings.setValue( "templateIndex", templateIndex);
  qSettings.setValue( "useTemplate", useTemplate);
  qSettings.setValue( "useVOX", useVOX);
  qSettings.setValue( "useCW", useCW);
  qSettings.setValue( "useHybrid", useHybrid);
  qSettings.setValue("drmBandWith",drmParams.bandwith);
  qSettings.setValue("drmInterLeaver",drmParams.interleaver);
  qSettings.setValue("drmProtection",drmParams.protection);
  qSettings.setValue("drmQAM",drmParams.qam);
  qSettings.setValue("drmRobMode",drmParams.robMode);
  qSettings.setValue("drmReedSolomon",drmParams.reedSolomon);
  qSettings.setValue("sizeRatio",sizeRatio);
  qSettings.endGroup();
}

void txWidget::slotGetParams()
{
  int temp=modeIndexTx;
  getIndex(temp,ui->sstvModeComboBox);
  modeIndexTx=esstvMode(temp);
  getIndex(templateIndex,ui->templatesComboBox);
  getValue(useTemplate,ui->templateCheckBox);
  getValue(useVOX,ui->voxCheckBox);
  getValue(useCW,ui->cwCheckBox);
  getValue(useHybrid,ui->hybridCheckBox);
  getValue(imageViewerPtr->toCall,ui->toCallLineEdit);
  getValue(imageViewerPtr->toOperator,ui->operatorLineEdit);
  getValue(imageViewerPtr->rsv,ui->rsvLineEdit);
  getValue(imageViewerPtr->comment1,ui->comment1LineEdit);
  getValue(imageViewerPtr->comment2,ui->comment2LineEdit);
  getValue(imageViewerPtr->comment3,ui->comment3LineEdit);
  getIndex(drmParams.bandwith,ui->drmTxBandwidthComboBox);
  getIndex(drmParams.interleaver,ui->drmTxInterleaveComboBox);
  getIndex(drmParams.protection,ui->drmTxProtectionComboBox);
  getIndex(drmParams.qam,ui->drmTxQAMComboBox);
  getIndex(drmParams.robMode,ui->drmTxModeComboBox);
  getIndex(drmParams.reedSolomon,ui->drmTxReedSolomonComboBox);
  getValue(sizeRatio,ui->sizeSlider);
  drmParams.callsign=myCallsign;
//  if(!txFunctionsPtr->isRunning())
  if(txFunctionsPtr->getTXState()==txFunctions::TXIDLE)
    {
      applyTemplate();
    }
}

void txWidget::setParams()
{
  setIndex(((int)modeIndexTx),ui->sstvModeComboBox);
  setIndex(templateIndex,ui->templatesComboBox);
  setValue(useTemplate,ui->templateCheckBox);
  setValue(useVOX,ui->voxCheckBox);
  setValue(useCW,ui->cwCheckBox);
  setValue(useHybrid,ui->hybridCheckBox);
  setIndex(drmParams.bandwith,ui->drmTxBandwidthComboBox);
  setIndex(drmParams.interleaver,ui->drmTxInterleaveComboBox);
  setIndex(drmParams.protection,ui->drmTxProtectionComboBox);
  setIndex(drmParams.qam,ui->drmTxQAMComboBox);
  setIndex(drmParams.robMode,ui->drmTxModeComboBox);
  setIndex(drmParams.reedSolomon,ui->drmTxReedSolomonComboBox);
  setValue(sizeRatio,ui->sizeSlider);
}

void txWidget::copyProfile(drmTxParams d)
{
  drmParams=d;
  setIndex(drmParams.bandwith,ui->drmTxBandwidthComboBox);
  setIndex(drmParams.interleaver,ui->drmTxInterleaveComboBox);
  setIndex(drmParams.protection,ui->drmTxProtectionComboBox);
  setIndex(drmParams.qam,ui->drmTxQAMComboBox);
  setIndex(drmParams.robMode,ui->drmTxModeComboBox);
  setIndex(drmParams.reedSolomon,ui->drmTxReedSolomonComboBox);
}

void txWidget::initView()
{
  ui->sstvModeComboBox->setCurrentIndex((int)modeIndexTx);
  setupTemplatesComboBox();
  ui->progressBar->setRange(0,100);
}

void txWidget::setupTemplatesComboBox()
{
  QStringList sl;
   int i;
  ui->templatesComboBox->clear();
  sl=galleryWidgetPtr->getFilenames();
  for(i=0;i<sl.count();i++)
  {
    ui->templatesComboBox->insertItem(i,sl.at(i));
  }
   ui->templatesComboBox->setCurrentIndex(templateIndex);
}

void  txWidget::setPreviewWidget(QString fn)
{
   ui->previewWidget->openImage(fn,false,false);
}

void txWidget::start(bool st,bool check)
{
  if(st)
    {
      slotGetParams();
      if(check)
        {
          if(!imageViewerPtr->hasValidImage())
            {
              QMessageBox::warning(this,"TX Error","No image loaded");
              return;
            }
        }
      soundIOPtr->startPlayback();
    }
  else
    {
      writeSettings();
      txFunctionsPtr->stopAndWait();
    }
}

void txWidget::slotStart()
{
//  start(true);
  QFileInfo finf;
  QString fn;
  slotGetParams();
  switch(currentTXMode)
    {
    case SSTV:
       dispatcherPtr->startSSTVTx();
    break;
    case DRM:
      txFunctionsPtr->setDRMTxParams(drmParams);
      if(ui->hybridCheckBox->isChecked())
        {
          finf.setFile(txWidgetPtr->getImageViewerPtr()->getFilename());

          fn="de_"+myCallsign+"-1-"+finf.baseName()+"."+finf.suffix();
          txFunctionsPtr->setHybrid(true,fn);
          dispatcherPtr->startDRMHybridTx(fn);
        }
      else
        {
          txFunctionsPtr->setHybrid(false);
          dispatcherPtr->startDRMTx();
        }


    break;
//    case FAX:
//    break;
    case NOMODE:
      break;
    }
}


void txWidget::sendBSR()
{
  QByteArray *p;
  bsrForm::eResult res;
  bsrForm bsrf;
  bsrf.init();
  res=(bsrForm::eResult)bsrf.exec();
  if(res==bsrForm::CANCEL) return;
  p=bsrf.getBA(res==bsrForm::COMPAT);
  drmParams=bsrf.getDRMParams();
  txFunctionsPtr->setDRMTxParams(drmParams);
  dispatcherPtr->startDRMBSRTx(p);
}


void txWidget::sendID()
{
  dispatcherPtr->sendWF(myCallsign);
}

void txWidget::sendWfText()
{
  waterfallForm wf;
  if((wf.exec()==QDialog::Accepted)&&(!wf.text().isEmpty()))
    {
      dispatcherPtr->sendWF(wf.text());
    }
}

void txWidget::slotStop()
{
//  qDebug() << "slotStop tx";
  soundIOPtr->abortPlayback();
  start(false);
  dispatcherPtr->restartRX();
}


void txWidget::slotDisplayStatusMessage(QString s)
{
    statusBarPtr->showMessage(s);
}


//void txWidget::slotReplay()
//{
//  QString fn;
//  QImage *im=NULL;
//  fn=galleryWidgetPtr->getLastRxImage();
//  editorScene scene(0);
//  QFile f(fn);
//  if(!scene.load(f))
//    {
//      QMessageBox::warning(this,"Image Properties","Error while loading\n" + fn);
//      return;
//    }
//  im=scene.renderImage();
//  dispatcherPtr->setTXImage(im);
//  slotStartTX();
//}


void txWidget::slotFileOpen()
{
  QString fileName;
  imageViewerPtr->openImage(fileName,txImagesPath,true,true,true);
}

void txWidget::slotGenerateSignal()
{
  QDialog qd;
   Ui::freqForm *ff=new Ui::freqForm;

  ff->setupUi(&qd);
  int freq;
  int  duration;
  if(qd.exec())
    {
      getValue(freq,ff->frequencySpinBox);
      getValue(duration,ff->durationSpinBox);
      dispatcherPtr->sendTone((double)duration,(double)freq);
    }
}

void txWidget::slotSweepSignal()
{
  QDialog qd;
 Ui::sweepForm *ff=new Ui::sweepForm;
  ff->setupUi(&qd);
  int upperFreq;
  int lowerFreq;
  int  duration;
  if(qd.exec())
    {
      getValue(lowerFreq,ff->lowerFrequencySpinBox);
      getValue(upperFreq,ff->upperFrequencySpinBox);
      getValue(duration,ff->durationSpinBox);
      dispatcherPtr->sendSweepTone((double)duration,(double)lowerFreq,(double)upperFreq);
    }
}


void txWidget::slotGenerateRepeaterTone()
{
  addToLog(QString("start of buffer %1").arg(soundIOPtr->txBuffer.count()),LOGTXMAIN);
  dispatcherPtr->sendTone(3.,1750);
}



void txWidget::slotEdit()
{
  if (ed!=NULL) delete ed;
  ed=new editor(this);
  if(txFunctionsPtr->isRunning())
    {
      QMessageBox::warning(this,"Editor","Transmission busy, editor not available");
      return;
    }
  connect(ed,SIGNAL(imageAvailable(QImage *)),SLOT(setImage(QImage *)));
  ed->setImage(imageViewerPtr->getImagePtr());
  ed->show();
}


void txWidget::slotModeChanged(int m)
{
  addToLog("slotModeChange",LOGTXMAIN);
  modeIndexTx=(esstvMode)m;
//  txFunctionsPtr->create(modeIndexTx,txClock/SUBSAMPLINGRATIO);
  applyTemplate();
}




/** \todo implement repeater */
void txWidget::applyTemplate()
{
  if(currentTXMode!=DRM)
    {
      txFunctionsPtr->create(modeIndexTx,txClock/SUBSAMPLINGRATIO);
      imageViewerPtr->applyTemplate(galleryWidgetPtr->getTemplateFileName(ui->templatesComboBox->currentIndex()),useTemplate, txSSTVParam.numberOfPixels,txSSTVParam.numberOfDisplayLines);
    }
  else
    {
      slotSize(sizeRatio);
      imageViewerPtr->applyTemplate(galleryWidgetPtr->getTemplateFileName(ui->templatesComboBox->currentIndex()),useTemplate);
    }
}

void 	txWidget::setImage(QImage *im)
{
  if(imageViewerPtr->openImage(*im))
    {
      applyTemplate();
    }
}

void 	txWidget::setImage(QString fn)
{
  imageViewerPtr->openImage(fn,true,true);
}


void txWidget::setProgress(uint prg)
{
  ui->progressBar->setValue(prg);
}


/** \todo implement repeater */

// void txWidget::repeat(QImage *im,esstvMode sm)
void txWidget::repeat(QImage *,esstvMode )
{
/*	setValue((int)sm,ui->modeComboBox);
  txf->setModeIndex((sstvMode)sm);
//	slotModeChanged(sm);

  txf->setImage(im);
  dsp->setCaptureSource(true,NULL,false);
  txf->process();*/
}

void txWidget::slotRepeaterTimer()
{
  QString fn;
  QFile fi;
  if(txFunctionsPtr->isRunning()) repeaterTimer->start(60000*repeaterImageInterval);

  else if ((rxWidgetPtr->functionsPtr()->isRunning()) || (!repeaterEnable))
    {
      // wait 10 seconds and check if busy or repeaterEnable has changed
      repeaterTimer->start(10000);
    }
  else
    {
      switch(repeaterIndex)
        {
          case 0:
            fn=repeaterImage1;
          break;
          case 1:
            fn=repeaterImage2;
          break;
          case 2:
            fn=repeaterImage3;
          break;
          case 3:
            fn=repeaterImage4;
          break;
          default:
            fn=repeaterImage1;
          break;
        }
      fi.setFileName(fn);
      if (fi.exists())
        {
          slotModeChanged(repeaterTxMode);
          setImage(fn);
        }
      repeaterIndex++;
      if(repeaterIndex>3) repeaterIndex=0;
      repeaterTimer->start(60000*repeaterImageInterval);
      //QApplication::processEvents();
      startAutoRepeaterEvent* ce = new startAutoRepeaterEvent();
      QApplication::postEvent(dispatcherPtr, ce );
    }
}



void txWidget::slotSnapshot()
{
  cameraControl cc(this);
  if(cc.exec())
    {
      setImage(cc.getImage());
    }
}





//void txWidget::test()
//{

//}

void txWidget::setSettingsTab()
{
  int i;
  currentTXMode=transmissionModeIndex;
  {
    if(currentTXMode==DRM)
      {
        ui->hybridCheckBox->setEnabled(true);
      }
    else
      {
        ui->hybridCheckBox->setEnabled(false);
      }

  }

  if((transmissionModeIndex>=0)&&(transmissionModeIndex<NOMODE))
    {
      for(i=0;i<NOMODE;i++)
        {
          if(i!=transmissionModeIndex) ui->settingsTableWidget->widget(i)->setEnabled(false);
        }
      ui->settingsTableWidget->widget(transmissionModeIndex)->setEnabled(true);
      ui->settingsTableWidget->setCurrentIndex(transmissionModeIndex);
    }
  applyTemplate();
}

bool txWidget::prepareFIX(QByteArray bsrByteArray)
{
  int i,j;
  displayMBoxEvent *stce;
//  unsigned int mode=0;
//  eRSType rsType;
  bool inSeries;
  QString fileName,extension;
  txSession *sessionPtr;
  bool extended,done;
  int block;
  unsigned short trID,lastBlock;

  fixBlockList.clear();
  txFunctionsPtr->setHybrid(true);
  QString str(bsrByteArray);
  str.replace("\r","");
  //  information is in the QByteArray ba
  QStringList sl;
  sl=str.split("\n",QString::SkipEmptyParts);

  if(sl.at(1)!="H_OK")
    {
      return false;
    }
  trID=sl.at(0).toUInt();
  lastBlock=sl.at(3).toUInt();
  fixBlockList.append(lastBlock++);
  inSeries=false;
  done=false;
  extended=false;
  for(i=4;(!done)&&i<sl.count();i++)
    {
      block=sl.at(i).toInt();
      if(block==-99)
        {
          done=true;
          i++;
          break;
        }
      if(block<0) inSeries=true;
      else
        {
          if(inSeries)
            {
              inSeries=false;
              for(j=lastBlock;j<block;j++) fixBlockList.append(j);
            }
          fixBlockList.append(block);
          lastBlock=block+1;
        }
    }
  // check if we have a filename beyond -99
  if((i+1)<sl.count()) // we need an additional 2 entries (filename and mode)
    {
      extended=true;
      fileName=sl.at(i++);
//      mode=sl.at(i).toUInt();
//      qDebug() << " bsr received with " << fileName << mode;
    }
  fixForm fx(mainWindowPtr);
  sessionPtr=txFunctionsPtr->getSessionPtr(trID);
  if ((sessionPtr==NULL) && (!extended))
    {
      stce= new displayMBoxEvent("BSR Received","This BSR is not for you");
      QApplication::postEvent( dispatcherPtr, stce );  // Qt will delete it when done

      return false;
    }
  else if (sessionPtr!=NULL)
    {
      // take it from the transmitlist

      fx.setInfoInternal(paramsToMode(sessionPtr->drmParams),sessionPtr->filename,fixBlockList.count(),&sessionPtr->ba);
      if(fx.exec()==QDialog::Rejected) return false;
      txFunctionsPtr->initDRMFIX(sessionPtr);
     }
  else
    {
      QMessageBox *mbox = new QMessageBox(this);
      mbox->setWindowTitle(tr("BSR Received"));
      mbox->setText("This BSR is not for you");
      mbox->show();
      QTimer::singleShot(4000, mbox, SLOT(hide()));
      return false;
    }
  return true;
}

//bool txWidget::prepareHybrid(QString fn)
//{
//  txFunctionsPtr->setHybrid(true);
//  return true;
//}

bool txWidget::prepareText(QString )
{
  txFunctionsPtr->setHybrid(false);
//  QString fn;
//  QDateTime dt(QDateTime::currentDateTime().toUTC()); //this is compatible with QT 4.6
//  dt.setTimeSpec(Qt::UTC);
//  dt
//  int intdate=dt.date().year()*10000+dt.date().month()*100+dt.date().day();
//  int inttime=dt.time().hour()*10000+100*dt.time().minute()+dt.time().second();
//  s.sprintf("%s_%d_%d",rxWidgetPtr->functionsPtr()->getModeString().toLatin1().data(),intdate,inttime);
//  fileName=rxImagesPath+"/"+s+"."+defaultImageFormat;
//  QFile fo("de ON4QZ")
  return true;
}


void txWidget::slotSize(int v)
{
  QString t;
  if(sizeRatio!=v)
    {
      sizeRatioChanged=true;
      sizeRatio=v;
      ui->sizeKbLabel->setText( QString::number(imageViewerPtr->calcSize(v))+ "kB");
    }
}

void txWidget::slotSizeApply()
{
  QApplication::setOverrideCursor(Qt::WaitCursor);
  sizeRatioChanged=false;
  imageViewerPtr->setSizeRatio(sizeRatio);
  imageViewerPtr->displayImage(currentTXMode==DRM);
  QApplication::restoreOverrideCursor();
}

void txWidget::slotTransmissionMode(int rxtxMode)
{
  transmissionModeIndex=(etransmissionMode)rxtxMode;
  start(false);
  rxWidgetPtr->setSettingsTab();
  setSettingsTab();
  if(transmissionModeIndex==DRM)
    {
      ui->sizeLabel->setEnabled(true);
      ui->sizeSlider->setEnabled(true);
      ui->sizeKbLabel->setEnabled(true);
//      ui->sizeApplyPushButton->setEnabled(true);
      mainWindowPtr->setBSRPushButton(true);
    }
  else
    {
      ui->sizeLabel->setEnabled(false);
      ui->sizeSlider->setEnabled(false);
      ui->sizeKbLabel->setEnabled(false);
//      ui->sizeApplyPushButton->setEnabled(false);
      mainWindowPtr->setBSRPushButton(false);
    }
}

void txWidget::slotProfileChanged(int i)
{
    drmProfilePtr->getDRMParams(i,drmParams);
    setParams();
}

void txWidget::setProfileNames()
{
    QString tmp;
    ui->drmProfileComboBox->clear();
    if(drmProfilePtr->getName(0,tmp))
    {
      ui->drmProfileComboBox->addItem(tmp);
    }
    if(drmProfilePtr->getName(1,tmp))
    {
      ui->drmProfileComboBox->addItem(tmp);
    }
    if(drmProfilePtr->getName(2,tmp))
    {
      ui->drmProfileComboBox->addItem(tmp);
    }
}

void txWidget::slotImageChanged()
{
    int sz=sizeRatio;
    sizeRatio=0;
    slotSize(sz);
    slotSizeApply();
}
