/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SSTVGLOBAL_H
#define SSTVGLOBAL_H
#include <QString>
#include <QCursor>
#include "logging.h"

#define RXSTRIPE 1024
#define TXSTRIPE 1024

//typedef double DSPFLOAT;
typedef float DSPFLOAT;

class QSplashScreen;
class QStatusBar;
class logFile;
class galleryWidget ;
class configDialog;
class dispatcher;
class rxWidget;
class txWidget;
class imageViewer;
class mainWindow;
#ifndef QT_NO_DEBUG
class scopeView;
#endif
class synthesizer;

extern const QString MAJORVERSION;
extern const QString CONFIGVERSION;
extern const QString MINORVERSION;
extern  const QString ORGANIZATION;
extern const QString APPLICATION;
extern const QString qsstv_version;
#define MAGICNUMBER   (('4'<<24)+('Q'<<16)+('Z'<<8)+'S')

extern QSplashScreen    *splash;
extern configDialog     *confDiag;
extern galleryWidget *galMW;
extern rxWidget *rxMW;
extern txWidget *txMW;
extern mainWindow *mw;
extern imageViewer *rxViewer;
extern imageViewer *txViewer;
extern synthesizer *synthesPtr;
extern dispatcher *dispatchPtr;
extern QStatusBar *statusBarPtr;

#ifndef QT_NO_DEBUG
extern scopeView *scopeViewer;
#endif

extern QCursor *cpCursor;
void globalInit(void);
void globalEnd(void);

extern logFile *logfile;



#endif
