/*
 * Copyright (C) 2009  Lorenzo Bettini <http://www.lorenzobettini.it>
 * See COPYING file that comes with this distribution
 */


#ifndef FILECHOOSERFRAME_H
#define FILECHOOSERFRAME_H

#include <QFrame>

namespace Ui {
    class FileChooserFrame;
}

class FileChooserFrame : public QFrame {
    Q_OBJECT
public:
    FileChooserFrame(QWidget *parent = 0);
    ~FileChooserFrame();

    /**
      * Sets the description representing the file name
      * we must choose.
      * @param desc the description for the label
      */
    void setFileDescription(const QString &desc);

    /**
      * @return the inserted (or chosen) file path
      */
    QString getFilePath() const;

protected:
    void changeEvent(QEvent *e);

protected slots:
    void chooseFile();

private:
    Ui::FileChooserFrame *m_ui;
};

#endif // FILECHOOSERFRAME_H
