#
# PySNMP MIB module OSPF-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/OSPF-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:23:03 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( Integer, OctetString, ObjectIdentifier, ) = mibBuilder.importSymbols("ASN1", "Integer", "OctetString", "ObjectIdentifier")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ValueSizeConstraint, SingleValueConstraint, ConstraintsUnion, ValueRangeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ValueSizeConstraint", "SingleValueConstraint", "ConstraintsUnion", "ValueRangeConstraint")
( InterfaceIndexOrZero, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero")
( ObjectGroup, NotificationGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "NotificationGroup", "ModuleCompliance")
( iso, Gauge32, mib_2, ObjectIdentity, IpAddress, NotificationType, Unsigned32, Counter32, Integer32, Bits, Counter64, TimeTicks, ModuleIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, MibIdentifier, ) = mibBuilder.importSymbols("SNMPv2-SMI", "iso", "Gauge32", "mib-2", "ObjectIdentity", "IpAddress", "NotificationType", "Unsigned32", "Counter32", "Integer32", "Bits", "Counter64", "TimeTicks", "ModuleIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "MibIdentifier")
( DisplayString, TimeStamp, TextualConvention, RowStatus, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "TimeStamp", "TextualConvention", "RowStatus", "TruthValue")
ospf = ModuleIdentity((1, 3, 6, 1, 2, 1, 14)).setRevisions(("2006-11-10 00:00", "1995-01-20 12:25",))
if mibBuilder.loadTexts: ospf.setLastUpdated('200611100000Z')
if mibBuilder.loadTexts: ospf.setOrganization('IETF OSPF Working Group')
if mibBuilder.loadTexts: ospf.setContactInfo('WG E-Mail: ospf@ietf.org\n\n        WG Chairs: acee@cisco.com\n                   rohit@gmail.com\n\n        Editors:   Dan Joyal\n                   Nortel\n                   600 Technology Park Drive\n                   Billerica, MA  01821\n                   djoyal@nortel.com\n\n                   Piotr Galecki\n                   Airvana\n                   19 Alpha Road\n                   Chelmsford, MA 01824\n                   pgalecki@airvana.com\n\n                   Spencer Giacalone\n                   CSFB\n                   Eleven Madison Ave\n                   New York, NY 10010-3629\n                   spencer.giacalone@gmail.com')
if mibBuilder.loadTexts: ospf.setDescription('The MIB module to describe the OSPF Version 2\n          Protocol.  Note that some objects in this MIB\n          module may pose a significant security risk.\n          Refer to the Security Considerations section\n          in RFC 4750 for more information.\n          Copyright (C) The IETF Trust (2006).\n          This version of this MIB module is part of\n          RFC 4750;  see the RFC itself for full legal\n          notices.')
class AreaID(IpAddress, TextualConvention):
    pass

class RouterID(IpAddress, TextualConvention):
    pass

class Metric(Integer32, TextualConvention):
    displayHint = 'd-0'
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,65535)

class BigMetric(Integer32, TextualConvention):
    displayHint = 'd-0'
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,16777215)

class Status(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2,))
    namedValues = NamedValues(("enabled", 1), ("disabled", 2),)

class PositiveInteger(Integer32, TextualConvention):
    displayHint = 'd-0'
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,2147483647)

class HelloRange(Integer32, TextualConvention):
    displayHint = 'd-0'
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(1,65535)

class UpToMaxAge(Integer32, TextualConvention):
    displayHint = 'd-0'
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,3600)

class DesignatedRouterPriority(Integer32, TextualConvention):
    displayHint = 'd-0'
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,255)

class TOSType(Integer32, TextualConvention):
    displayHint = 'd-0'
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,30)

class OspfAuthenticationType(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(0, 1, 2,))
    namedValues = NamedValues(("none", 0), ("simplePassword", 1), ("md5", 2),)

ospfGeneralGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 1))
ospfRouterId = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 1), RouterID()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfRouterId.setDescription("A 32-bit integer uniquely identifying the\n          router in the Autonomous System.\n          By convention, to ensure uniqueness, this\n          should default to the value of one of the\n          router's IP interface addresses.\n\n          This object is persistent and when written\n          the entity SHOULD save the change to non-volatile storage.")
ospfAdminStat = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 2), Status()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfAdminStat.setDescription("The administrative status of OSPF in the\n          router.  The value 'enabled' denotes that the\n          OSPF Process is active on at least one interface;\n          'disabled' disables it on all interfaces.\n\n          This object is persistent and when written\n          the entity SHOULD save the change to non-volatile storage.")
ospfVersionNumber = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(2,))).clone(namedValues=NamedValues(("version2", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVersionNumber.setDescription('The current version number of the OSPF protocol is 2.')
ospfAreaBdrRtrStatus = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 4), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaBdrRtrStatus.setDescription('A flag to note whether this router is an Area\n          Border Router.')
ospfASBdrRtrStatus = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 5), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfASBdrRtrStatus.setDescription('A flag to note whether this router is configured as\n           an Autonomous System Border Router.\n\n           This object is persistent and when written the\n           entity SHOULD save the change to non-volatile storage.')
ospfExternLsaCount = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 6), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExternLsaCount.setDescription('The number of external (LS type-5) link state\n           advertisements in the link state database.')
ospfExternLsaCksumSum = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExternLsaCksumSum.setDescription("The 32-bit sum of the LS checksums of\n           the external link state advertisements\n           contained in the link state database.  This sum\n           can be used to determine if there has been a\n           change in a router's link state database and\n           to compare the link state database of two\n           routers.  The value should be treated as unsigned\n           when comparing two sums of checksums.")
ospfTOSSupport = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 8), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfTOSSupport.setDescription("The router's support for type-of-service routing.\n\n           This object is persistent and when written\n           the entity SHOULD save the change to non-volatile\n           storage.")
ospfOriginateNewLsas = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfOriginateNewLsas.setDescription('The number of new link state advertisements\n          that have been originated.  This number is\n          incremented each time the router originates a new\n          LSA.\n\n          Discontinuities in the value of this counter can\n          occur at re-initialization of the management system,\n          and at other times as indicated by the value of\n          ospfDiscontinuityTime.')
ospfRxNewLsas = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfRxNewLsas.setDescription('The number of link state advertisements received\n          that are determined to be new instantiations.\n          This number does not include newer instantiations\n          of self-originated link state advertisements.\n\n          Discontinuities in the value of this counter can\n          occur at re-initialization of the management system,\n          and at other times as indicated by the value of\n          ospfDiscontinuityTime.')
ospfExtLsdbLimit = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1,2147483647)).clone(-1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfExtLsdbLimit.setDescription("The maximum number of non-default\n          AS-external LSAs entries that can be stored in the\n          link state database.  If the value is -1, then\n          there is no limit.\n\n          When the number of non-default AS-external LSAs\n          in a router's link state database reaches\n          ospfExtLsdbLimit, the router enters\n          overflow state.  The router never holds more than\n          ospfExtLsdbLimit non-default AS-external LSAs\n          in its database.  OspfExtLsdbLimit MUST be set\n          identically in all routers attached to the OSPF\n          backbone and/or any regular OSPF area (i.e.,\n          OSPF stub areas and NSSAs are excluded).\n\n          This object is persistent and when written\n          the entity SHOULD save the change to non-volatile\n          storage.")
ospfMulticastExtensions = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 12), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfMulticastExtensions.setDescription("A bit mask indicating whether the router is\n          forwarding IP multicast (Class D) datagrams\n          based on the algorithms defined in the\n          multicast extensions to OSPF.\n\n          Bit 0, if set, indicates that the router can\n          forward IP multicast datagrams in the router's\n          directly attached areas (called intra-area\n          multicast routing).\n\n          Bit 1, if set, indicates that the router can\n          forward IP multicast datagrams between OSPF\n          areas (called inter-area multicast routing).\n\n          Bit 2, if set, indicates that the router can\n          forward IP multicast datagrams between\n          Autonomous Systems (called inter-AS multicast\n          routing).\n\n          Only certain combinations of bit settings are\n          allowed, namely: 0 (no multicast forwarding is\n          enabled), 1 (intra-area multicasting only), 3\n          (intra-area and inter-area multicasting), 5\n          (intra-area and inter-AS multicasting), and 7\n          (multicasting everywhere).  By default, no\n          multicast forwarding is enabled.\n\n          This object is persistent and when written\n          the entity SHOULD save the change to non-volatile\n          storage.")
ospfExitOverflowInterval = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 13), PositiveInteger()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfExitOverflowInterval.setDescription('The number of seconds that, after entering\n          OverflowState, a router will attempt to leave\n          OverflowState.  This allows the router to again\n          originate non-default AS-external LSAs.  When\n          set to 0, the router will not leave\n          overflow state until restarted.\n\n          This object is persistent and when written\n          the entity SHOULD save the change to non-volatile\n          storage.')
ospfDemandExtensions = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 14), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfDemandExtensions.setDescription("The router's support for demand routing.\n           This object is persistent and when written\n           the entity SHOULD save the change to non-volatile\n           storage.")
ospfRFC1583Compatibility = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 15), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfRFC1583Compatibility.setDescription('Indicates metrics used to choose among multiple\n          AS-external LSAs.  When RFC1583Compatibility is set to\n          enabled, only cost will be used when choosing among\n          multiple AS-external LSAs advertising the same\n          destination.  When RFC1583Compatibility is set to\n          disabled, preference will be driven first by type of\n          path using cost only to break ties.\n\n          This object is persistent and when written\n          the entity SHOULD save the change to non-volatile\n          storage.')
ospfOpaqueLsaSupport = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 16), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfOpaqueLsaSupport.setDescription("The router's support for Opaque LSA types.")
ospfReferenceBandwidth = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 17), Unsigned32()).setUnits('kilobits per second').setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfReferenceBandwidth.setDescription('Reference bandwidth in kilobits/second for\n          calculating default interface metrics.  The\n          default value is 100,000 KBPS (100 MBPS).\n\n          This object is persistent and when written\n          the entity SHOULD save the change to non-volatile\n          storage.')
ospfRestartSupport = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 18), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("none", 1), ("plannedOnly", 2), ("plannedAndUnplanned", 3),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfRestartSupport.setDescription("The router's support for OSPF graceful restart.\n          Options include: no restart support, only planned\n          restarts, or both planned and unplanned restarts.\n\n          This object is persistent and when written\n          the entity SHOULD save the change to non-volatile\n          storage.")
ospfRestartInterval = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,1800))).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfRestartInterval.setDescription('Configured OSPF graceful restart timeout interval.\n\n           This object is persistent and when written\n           the entity SHOULD save the change to non-volatile\n           storage.')
ospfRestartStrictLsaChecking = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 20), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfRestartStrictLsaChecking.setDescription('Indicates if strict LSA checking is enabled for\n           graceful restart.\n\n           This object is persistent and when written\n           the entity SHOULD save the change to non-volatile\n           storage.')
ospfRestartStatus = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 21), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("notRestarting", 1), ("plannedRestart", 2), ("unplannedRestart", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfRestartStatus.setDescription('Current status of OSPF graceful restart.')
ospfRestartAge = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 22), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfRestartAge.setDescription('Remaining time in current OSPF graceful restart\n          interval.')
ospfRestartExitReason = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 23), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("none", 1), ("inProgress", 2), ("completed", 3), ("timedOut", 4), ("topologyChanged", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfRestartExitReason.setDescription("Describes the outcome of the last attempt at a\n          graceful restart.  If the value is 'none', no restart\n          has yet been attempted.  If the value is 'inProgress',\n          a restart attempt is currently underway.")
ospfAsLsaCount = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 24), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAsLsaCount.setDescription('The number of AS-scope link state\n           advertisements in the AS-scope link state database.')
ospfAsLsaCksumSum = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 25), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAsLsaCksumSum.setDescription("The 32-bit unsigned sum of the LS checksums of\n           the AS link state advertisements contained in the AS-scope\n           link state database.  This sum can be used to determine\n           if there has been a change in a router's AS-scope link\n           state database, and to compare the AS-scope link state\n           database of two routers.")
ospfStubRouterSupport = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 26), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfStubRouterSupport.setDescription("The router's support for stub router functionality.")
ospfStubRouterAdvertisement = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 27), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("doNotAdvertise", 1), ("advertise", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfStubRouterAdvertisement.setDescription('This object controls the advertisement of\n           stub router LSAs by the router.  The value\n           doNotAdvertise will result in the advertisement\n           of a standard router LSA and is the default value.\n\n           This object is persistent and when written\n           the entity SHOULD save the change to non-volatile\n           storage.')
ospfDiscontinuityTime = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 28), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion\n          at which any one of this MIB's counters suffered\n          a discontinuity.\n\n          If no such discontinuities have occurred since the last\n          re-initialization of the local management subsystem,\n          then this object contains a zero value.")
ospfAreaTable = MibTable((1, 3, 6, 1, 2, 1, 14, 2), )
if mibBuilder.loadTexts: ospfAreaTable.setDescription("Information describing the configured parameters and\n          cumulative statistics of the router's attached areas.\n          The interfaces and virtual links are configured\n          as part of these areas.  Area 0.0.0.0, by definition,\n          is the backbone area.")
ospfAreaEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 2, 1), ).setIndexNames((0, "OSPF-MIB", "ospfAreaId"))
if mibBuilder.loadTexts: ospfAreaEntry.setDescription("Information describing the configured parameters and\n          cumulative statistics of one of the router's attached areas.\n          The interfaces and virtual links are configured as part of\n          these areas.  Area 0.0.0.0, by definition, is the backbone\n          area.\n\n          Information in this table is persistent and when this object\n          is written the entity SHOULD save the change to non-volatile\n          storage.")
ospfAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 1), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaId.setDescription('A 32-bit integer uniquely identifying an area.\n          Area ID 0.0.0.0 is used for the OSPF backbone.')
ospfAuthType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 2), OspfAuthenticationType().clone('none')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAuthType.setDescription('The authentication type specified for an area.')
ospfImportAsExtern = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("importExternal", 1), ("importNoExternal", 2), ("importNssa", 3),)).clone('importExternal')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfImportAsExtern.setDescription('Indicates if an area is a stub area, NSSA, or standard\n          area.  Type-5 AS-external LSAs and type-11 Opaque LSAs are\n          not imported into stub areas or NSSAs.  NSSAs import\n          AS-external data as type-7 LSAs')
ospfSpfRuns = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfSpfRuns.setDescription("The number of times that the intra-area route\n          table has been calculated using this area's\n          link state database.  This is typically done\n          using Dijkstra's algorithm.\n\n          Discontinuities in the value of this counter can occur\n          at re-initialization of the management system, and at other\n          times as indicated by the value of ospfDiscontinuityTime.")
ospfAreaBdrRtrCount = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaBdrRtrCount.setDescription('The total number of Area Border Routers reachable\n          within this area.  This is initially zero and is\n          calculated in each Shortest Path First (SPF) pass.')
ospfAsBdrRtrCount = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 6), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAsBdrRtrCount.setDescription('The total number of Autonomous System Border\n          Routers reachable within this area.  This is\n          initially zero and is calculated in each SPF\n          pass.')
ospfAreaLsaCount = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaLsaCount.setDescription("The total number of link state advertisements\n          in this area's link state database, excluding\n          AS-external LSAs.")
ospfAreaLsaCksumSum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaLsaCksumSum.setDescription("The 32-bit sum of the link state\n          advertisements' LS checksums contained in this\n          area's link state database.  This sum excludes\n          external (LS type-5) link state advertisements.\n          The sum can be used to determine if there has\n          been a change in a router's link state\n          database, and to compare the link state database of\n          two routers.  The value should be treated as unsigned\n          when comparing two sums of checksums.")
ospfAreaSummary = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 9), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("noAreaSummary", 1), ("sendAreaSummary", 2),)).clone('noAreaSummary')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaSummary.setDescription('The variable ospfAreaSummary controls the\n          import of summary LSAs into stub and NSSA areas.\n          It has no effect on other areas.\n\n          If it is noAreaSummary, the router will not\n          originate summary LSAs into the stub or NSSA area.\n          It will rely entirely on its default route.\n\n          If it is sendAreaSummary, the router will both\n          summarize and propagate summary LSAs.')
ospfAreaStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 10), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaStatus.setDescription('This object permits management of the table by\n          facilitating actions such as row creation,\n          construction, and destruction.\n\n          The value of this object has no effect on\n          whether other objects in this conceptual row can be\n          modified.')
ospfAreaNssaTranslatorRole = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 11), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("always", 1), ("candidate", 2),)).clone('candidate')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaNssaTranslatorRole.setDescription("Indicates an NSSA border router's ability to\n          perform NSSA translation of type-7 LSAs into\n          type-5 LSAs.")
ospfAreaNssaTranslatorState = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 12), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("enabled", 1), ("elected", 2), ("disabled", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaNssaTranslatorState.setDescription("Indicates if and how an NSSA border router is\n          performing NSSA translation of type-7 LSAs into type-5\n          LSAs.  When this object is set to enabled, the NSSA Border\n          router's OspfAreaNssaExtTranslatorRole has been set to\n          always.  When this object is set to elected, a candidate\n          NSSA Border router is Translating type-7 LSAs into type-5.\n          When this object is set to disabled, a candidate NSSA\n          border router is NOT translating type-7 LSAs into type-5.")
ospfAreaNssaTranslatorStabilityInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 13), PositiveInteger().clone(40)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaNssaTranslatorStabilityInterval.setDescription('The number of seconds after an elected translator\n          determines its services are no longer required, that\n          it should continue to perform its translation duties.')
ospfAreaNssaTranslatorEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaNssaTranslatorEvents.setDescription('Indicates the number of translator state changes\n          that have occurred since the last boot-up.\n\n          Discontinuities in the value of this counter can occur\n          at re-initialization of the management system, and at other\n          times as indicated by the value of ospfDiscontinuityTime.')
ospfStubAreaTable = MibTable((1, 3, 6, 1, 2, 1, 14, 3), )
if mibBuilder.loadTexts: ospfStubAreaTable.setDescription('The set of metrics that will be advertised\n          by a default Area Border Router into a stub area.')
ospfStubAreaEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 3, 1), ).setIndexNames((0, "OSPF-MIB", "ospfStubAreaId"), (0, "OSPF-MIB", "ospfStubTOS"))
if mibBuilder.loadTexts: ospfStubAreaEntry.setDescription('The metric for a given Type of Service that\n          will be advertised by a default Area Border\n          Router into a stub area.\n\n          Information in this table is persistent and when this object\n          is written the entity SHOULD save the change to non-volatile\n          storage.')
ospfStubAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 3, 1, 1), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfStubAreaId.setDescription('The 32-bit identifier for the stub area.  On\n          creation, this can be derived from the\n          instance.')
ospfStubTOS = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 3, 1, 2), TOSType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfStubTOS.setDescription('The Type of Service associated with the\n          metric.  On creation, this can be derived from\n          the instance.')
ospfStubMetric = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 3, 1, 3), BigMetric()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfStubMetric.setDescription('The metric value applied at the indicated Type\n          of Service.  By default, this equals the least\n          metric at the Type of Service among the\n          interfaces to other areas.')
ospfStubStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 3, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfStubStatus.setDescription('This object permits management of the table by\n          facilitating actions such as row creation,\n          construction, and destruction.\n\n          The value of this object has no effect on\n          whether other objects in this conceptual row can be\n          modified.')
ospfStubMetricType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 3, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("ospfMetric", 1), ("comparableCost", 2), ("nonComparable", 3),)).clone('ospfMetric')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfStubMetricType.setDescription('This variable displays the type of metric\n          advertised as a default route.')
ospfLsdbTable = MibTable((1, 3, 6, 1, 2, 1, 14, 4), )
if mibBuilder.loadTexts: ospfLsdbTable.setDescription("The OSPF Process's link state database (LSDB).\n           The LSDB contains the link state advertisements\n           from throughout the areas that the device is attached to.")
ospfLsdbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 4, 1), ).setIndexNames((0, "OSPF-MIB", "ospfLsdbAreaId"), (0, "OSPF-MIB", "ospfLsdbType"), (0, "OSPF-MIB", "ospfLsdbLsid"), (0, "OSPF-MIB", "ospfLsdbRouterId"))
if mibBuilder.loadTexts: ospfLsdbEntry.setDescription('A single link state advertisement.')
ospfLsdbAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 1), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbAreaId.setDescription('The 32-bit identifier of the area from which\n          the LSA was received.')
ospfLsdbType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 10,))).clone(namedValues=NamedValues(("routerLink", 1), ("networkLink", 2), ("summaryLink", 3), ("asSummaryLink", 4), ("asExternalLink", 5), ("multicastLink", 6), ("nssaExternalLink", 7), ("areaOpaqueLink", 10),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbType.setDescription('The type of the link state advertisement.\n          Each link state type has a separate advertisement\n          format.\n\n          Note: External link state advertisements are permitted\n          for backward compatibility, but should be displayed\n          in the ospfAsLsdbTable rather than here.')
ospfLsdbLsid = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbLsid.setDescription('The Link State ID is an LS Type Specific field\n          containing either a Router ID or an IP address;\n          it identifies the piece of the routing domain\n          that is being described by the advertisement.')
ospfLsdbRouterId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 4), RouterID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbRouterId.setDescription('The 32-bit number that uniquely identifies the\n          originating router in the Autonomous System.')
ospfLsdbSequence = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbSequence.setDescription("The sequence number field is a signed 32-bit\n          integer.  It starts with the value '80000001'h,\n          or -'7FFFFFFF'h, and increments until '7FFFFFFF'h.\n          Thus, a typical sequence number will be very negative.\n          It is used to detect old and duplicate Link State\n          Advertisements.  The space of sequence numbers is linearly\n          ordered.  The larger the sequence number, the more recent\n          the advertisement.")
ospfLsdbAge = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 6), Integer32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbAge.setDescription('This field is the age of the link state advertisement\n          in seconds.')
ospfLsdbChecksum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbChecksum.setDescription("This field is the checksum of the complete contents of\n          the advertisement, excepting the age field.  The age field\n          is excepted so that an advertisement's age can be\n          incremented without updating the checksum.  The checksum\n          used is the same that is used for ISO connectionless\n          datagrams; it is commonly referred to as the\n          Fletcher checksum.")
ospfLsdbAdvertisement = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 8), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbAdvertisement.setDescription('The entire link state advertisement, including\n          its header.\n\n          Note that for variable length LSAs, SNMP agents\n          may not be able to return the largest string size.')
ospfAreaRangeTable = MibTable((1, 3, 6, 1, 2, 1, 14, 5), )
if mibBuilder.loadTexts: ospfAreaRangeTable.setDescription('The Address Range Table acts as an adjunct to the Area\n           Table.  It describes those Address Range Summaries that\n           are configured to be propagated from an Area to reduce\n           the amount of information about it that is known beyond\n           its borders.  It contains a set of IP address ranges\n           specified by an IP address/IP network mask pair.\n           For example, class B address range of X.X.X.X\n           with a network mask of 255.255.0.0 includes all IP\n           addresses from X.X.0.0 to X.X.255.255.\n\n           Note that this table is obsoleted and is replaced\n           by the Area Aggregate Table.')
ospfAreaRangeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 5, 1), ).setIndexNames((0, "OSPF-MIB", "ospfAreaRangeAreaId"), (0, "OSPF-MIB", "ospfAreaRangeNet"))
if mibBuilder.loadTexts: ospfAreaRangeEntry.setDescription('A single area address range.\n\n          Information in this table is persistent and when this object\n          is written the entity SHOULD save the change to non-volatile\n          storage.')
ospfAreaRangeAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 5, 1, 1), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaRangeAreaId.setDescription('The area that the address range is to be found\n          within.')
ospfAreaRangeNet = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 5, 1, 2), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaRangeNet.setDescription('The IP address of the net or subnet indicated\n          by the range.')
ospfAreaRangeMask = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 5, 1, 3), IpAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaRangeMask.setDescription('The subnet mask that pertains to the net or\n          subnet.')
ospfAreaRangeStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 5, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaRangeStatus.setDescription('This object permits management of the table by\n          facilitating actions such as row creation,\n          construction, and destruction.\n\n          The value of this object has no effect on\n          whether other objects in this conceptual row can be\n          modified.')
ospfAreaRangeEffect = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 5, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("advertiseMatching", 1), ("doNotAdvertiseMatching", 2),)).clone('advertiseMatching')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaRangeEffect.setDescription("Subnets subsumed by ranges either trigger the\n          advertisement of the indicated summary\n         (advertiseMatching) or result in the subnet's not\n          being advertised at all outside the area.")
ospfHostTable = MibTable((1, 3, 6, 1, 2, 1, 14, 6), )
if mibBuilder.loadTexts: ospfHostTable.setDescription('The Host/Metric Table indicates what hosts are directly\n          attached to the router, what metrics and types\n          of service should be advertised for them,\n          and what areas they are found within.')
ospfHostEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 6, 1), ).setIndexNames((0, "OSPF-MIB", "ospfHostIpAddress"), (0, "OSPF-MIB", "ospfHostTOS"))
if mibBuilder.loadTexts: ospfHostEntry.setDescription('A metric to be advertised, for a given type of\n          service, when a given host is reachable.\n\n          Information in this table is persistent and when this object\n          is written the entity SHOULD save the change to non-volatile\n          storage.')
ospfHostIpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 6, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfHostIpAddress.setDescription('The IP address of the host.')
ospfHostTOS = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 6, 1, 2), TOSType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfHostTOS.setDescription('The Type of Service of the route being configured.')
ospfHostMetric = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 6, 1, 3), Metric()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfHostMetric.setDescription('The metric to be advertised.')
ospfHostStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 6, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfHostStatus.setDescription('This object permits management of the table by\n          facilitating actions such as row creation,\n          construction, and destruction.\n\n          The value of this object has no effect on\n          whether other objects in this conceptual row can be\n          modified.')
ospfHostAreaID = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 6, 1, 5), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfHostAreaID.setDescription('The OSPF area to which the host belongs.\n          Deprecated by ospfHostCfgAreaID.')
ospfHostCfgAreaID = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 6, 1, 6), AreaID()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfHostCfgAreaID.setDescription('To configure the OSPF area to which the host belongs.')
ospfIfTable = MibTable((1, 3, 6, 1, 2, 1, 14, 7), )
if mibBuilder.loadTexts: ospfIfTable.setDescription('The OSPF Interface Table describes the interfaces\n          from the viewpoint of OSPF.\n          It augments the ipAddrTable with OSPF specific information.')
ospfIfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 7, 1), ).setIndexNames((0, "OSPF-MIB", "ospfIfIpAddress"), (0, "OSPF-MIB", "ospfAddressLessIf"))
if mibBuilder.loadTexts: ospfIfEntry.setDescription('The OSPF interface entry describes one interface\n          from the viewpoint of OSPF.\n\n          Information in this table is persistent and when this object\n          is written the entity SHOULD save the change to non-volatile\n          storage.')
ospfIfIpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfIpAddress.setDescription('The IP address of this OSPF interface.')
ospfAddressLessIf = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 2), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAddressLessIf.setDescription('For the purpose of easing the instancing of\n          addressed and addressless interfaces; this\n          variable takes the value 0 on interfaces with\n          IP addresses and the corresponding value of\n          ifIndex for interfaces having no IP address.')
ospfIfAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 3), AreaID().clone(hexValue="00000000")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfAreaId.setDescription('A 32-bit integer uniquely identifying the area\n          to which the interface connects.  Area ID\n          0.0.0.0 is used for the OSPF backbone.')
ospfIfType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 5,))).clone(namedValues=NamedValues(("broadcast", 1), ("nbma", 2), ("pointToPoint", 3), ("pointToMultipoint", 5),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfType.setDescription("The OSPF interface type.\n          By way of a default, this field may be intuited\n          from the corresponding value of ifType.\n          Broadcast LANs, such as Ethernet and IEEE 802.5,\n          take the value 'broadcast', X.25 and similar\n          technologies take the value 'nbma', and links\n          that are definitively point to point take the\n          value 'pointToPoint'.")
ospfIfAdminStat = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 5), Status().clone('enabled')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfAdminStat.setDescription("The OSPF interface's administrative status.\n          The value formed on the interface, and the interface\n          will be advertised as an internal route to some area.\n          The value 'disabled' denotes that the interface is\n          external to OSPF.")
ospfIfRtrPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 6), DesignatedRouterPriority().clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfRtrPriority.setDescription('The priority of this interface.  Used in\n          multi-access networks, this field is used in\n          the designated router election algorithm.  The\n          value 0 signifies that the router is not eligible\n          to become the designated router on this particular\n          network.  In the event of a tie in this value,\n          routers will use their Router ID as a tie breaker.')
ospfIfTransitDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 7), UpToMaxAge().clone(1)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfTransitDelay.setDescription('The estimated number of seconds it takes to\n           transmit a link state update packet over this\n           interface.  Note that the minimal value SHOULD be\n           1 second.')
ospfIfRetransInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 8), UpToMaxAge().clone(5)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfRetransInterval.setDescription('The number of seconds between link state advertisement\n          retransmissions, for adjacencies belonging to this\n          interface.  This value is also used when retransmitting\n          database description and Link State request packets.\n          Note that minimal value SHOULD be 1 second.')
ospfIfHelloInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 9), HelloRange().clone(10)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfHelloInterval.setDescription('The length of time, in seconds, between the Hello packets\n          that the router sends on the interface.  This value must be\n          the same for all routers attached to a common network.')
ospfIfRtrDeadInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 10), PositiveInteger().clone(40)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfRtrDeadInterval.setDescription("The number of seconds that a router's Hello packets have\n          not been seen before its neighbors declare the router down.\n          This should be some multiple of the Hello interval.  This\n          value must be the same for all routers attached to a common\n          network.")
ospfIfPollInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 11), PositiveInteger().clone(120)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfPollInterval.setDescription('The larger time interval, in seconds, between the Hello\n          packets sent to an inactive non-broadcast multi-access\n          neighbor.')
ospfIfState = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 12), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7,))).clone(namedValues=NamedValues(("down", 1), ("loopback", 2), ("waiting", 3), ("pointToPoint", 4), ("designatedRouter", 5), ("backupDesignatedRouter", 6), ("otherDesignatedRouter", 7),)).clone('down')).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfState.setDescription('The OSPF Interface State.')
ospfIfDesignatedRouter = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 13), IpAddress().clone(hexValue="00000000")).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfDesignatedRouter.setDescription('The IP address of the designated router.')
ospfIfBackupDesignatedRouter = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 14), IpAddress().clone(hexValue="00000000")).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfBackupDesignatedRouter.setDescription('The IP address of the backup designated\n          router.')
ospfIfEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfEvents.setDescription('The number of times this OSPF interface has\n          changed its state or an error has occurred.\n\n          Discontinuities in the value of this counter can occur\n          at re-initialization of the management system, and at other\n          times as indicated by the value of ospfDiscontinuityTime.')
ospfIfAuthKey = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 16), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,256)).clone(hexValue="0000000000000000")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfAuthKey.setDescription('The cleartext password used as an OSPF\n          authentication key when simplePassword security\n          is enabled.  This object does not access any OSPF\n          cryptogaphic (e.g., MD5) authentication key under\n          any circumstance.\n\n          If the key length is shorter than 8 octets, the\n          agent will left adjust and zero fill to 8 octets.\n\n          Unauthenticated interfaces need no authentication\n          key, and simple password authentication cannot use\n          a key of more than 8 octets.\n\n          Note that the use of simplePassword authentication\n          is NOT recommended when there is concern regarding\n          attack upon the OSPF system.  SimplePassword\n          authentication is only sufficient to protect against\n          accidental misconfigurations because it re-uses\n          cleartext passwords [RFC1704].\n\n          When read, ospfIfAuthKey always returns an octet\n          string of length zero.')
ospfIfStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 17), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfStatus.setDescription('This object permits management of the table by\n          facilitating actions such as row creation,\n          construction, and destruction.\n\n          The value of this object has no effect on\n          whether other objects in this conceptual row can be\n          modified.')
ospfIfMulticastForwarding = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 18), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("blocked", 1), ("multicast", 2), ("unicast", 3),)).clone('blocked')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfMulticastForwarding.setDescription('The way multicasts should be forwarded on this\n          interface: not forwarded, forwarded as data\n          link multicasts, or forwarded as data link\n          unicasts.  Data link multicasting is not\n          meaningful on point-to-point and NBMA interfaces,\n          and setting ospfMulticastForwarding to 0 effectively\n          disables all multicast forwarding.')
ospfIfDemand = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 19), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfDemand.setDescription('Indicates whether Demand OSPF procedures (hello\n          suppression to FULL neighbors and setting the\n          DoNotAge flag on propagated LSAs) should be\n          performed on this interface.')
ospfIfAuthType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 20), OspfAuthenticationType().clone('none')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfAuthType.setDescription('The authentication type specified for an interface.\n\n          Note that this object can be used to engage\n          in significant attacks against an OSPF router.')
ospfIfLsaCount = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 21), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfLsaCount.setDescription("The total number of link-local link state advertisements\n          in this interface's link-local link state database.")
ospfIfLsaCksumSum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 22), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfLsaCksumSum.setDescription("The 32-bit unsigned sum of the Link State\n          Advertisements' LS checksums contained in this\n          interface's link-local link state database.\n          The sum can be used to determine if there has\n          been a change in the interface's link state\n          database and to compare the interface link state\n          database of routers attached to the same subnet.")
ospfIfDesignatedRouterId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 23), RouterID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfDesignatedRouterId.setDescription('The Router ID of the designated router.')
ospfIfBackupDesignatedRouterId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 24), RouterID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfBackupDesignatedRouterId.setDescription('The Router ID of the backup designated router.')
ospfIfMetricTable = MibTable((1, 3, 6, 1, 2, 1, 14, 8), )
if mibBuilder.loadTexts: ospfIfMetricTable.setDescription('The Metric Table describes the metrics to be advertised\n          for a specified interface at the various types of service.\n          As such, this table is an adjunct of the OSPF Interface\n          Table.\n\n          Types of service, as defined by RFC 791, have the ability\n          to request low delay, high bandwidth, or reliable linkage.\n\n          For the purposes of this specification, the measure of\n          bandwidth:\n          Metric = referenceBandwidth / ifSpeed\n\n          is the default value.\n          The default reference bandwidth is 10^8.\n          For multiple link interfaces, note that ifSpeed is the sum\n          of the individual link speeds.  This yields a number having\n          the following typical values:\n\n          Network Type/bit rate   Metric\n\n          >= 100 MBPS                 1\n          Ethernet/802.3             10\n          E1                         48\n          T1 (ESF)                   65\n          64 KBPS                    1562\n          56 KBPS                    1785\n          19.2 KBPS                  5208\n          9.6 KBPS                   10416\n\n          Routes that are not specified use the default\n          (TOS 0) metric.\n\n          Note that the default reference bandwidth can be configured\n          using the general group object ospfReferenceBandwidth.')
ospfIfMetricEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 8, 1), ).setIndexNames((0, "OSPF-MIB", "ospfIfMetricIpAddress"), (0, "OSPF-MIB", "ospfIfMetricAddressLessIf"), (0, "OSPF-MIB", "ospfIfMetricTOS"))
if mibBuilder.loadTexts: ospfIfMetricEntry.setDescription('A particular TOS metric for a non-virtual interface\n          identified by the interface index.\n\n          Information in this table is persistent and when this object\n          is written the entity SHOULD save the change to non-volatile\n          storage.')
ospfIfMetricIpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 8, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfMetricIpAddress.setDescription('The IP address of this OSPF interface.  On row\n          creation, this can be derived from the instance.')
ospfIfMetricAddressLessIf = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 8, 1, 2), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfMetricAddressLessIf.setDescription('For the purpose of easing the instancing of\n          addressed and addressless interfaces; this\n          variable takes the value 0 on interfaces with\n          IP addresses and the value of ifIndex for\n          interfaces having no IP address.  On row\n          creation, this can be derived from the instance.')
ospfIfMetricTOS = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 8, 1, 3), TOSType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfMetricTOS.setDescription('The Type of Service metric being referenced.\n          On row creation, this can be derived from the\n          instance.')
ospfIfMetricValue = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 8, 1, 4), Metric()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfMetricValue.setDescription('The metric of using this Type of Service on\n          this interface.  The default value of the TOS 0\n          metric is 10^8 / ifSpeed.')
ospfIfMetricStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 8, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfMetricStatus.setDescription('This object permits management of the table by\n          facilitating actions such as row creation,\n          construction, and destruction.\n\n          The value of this object has no effect on\n          whether other objects in this conceptual row can be\n          modified.')
ospfVirtIfTable = MibTable((1, 3, 6, 1, 2, 1, 14, 9), )
if mibBuilder.loadTexts: ospfVirtIfTable.setDescription("Information about this router's virtual interfaces\n          that the OSPF Process is configured to carry on.")
ospfVirtIfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 9, 1), ).setIndexNames((0, "OSPF-MIB", "ospfVirtIfAreaId"), (0, "OSPF-MIB", "ospfVirtIfNeighbor"))
if mibBuilder.loadTexts: ospfVirtIfEntry.setDescription('Information about a single virtual interface.\n\n          Information in this table is persistent and when this object\n          is written the entity SHOULD save the change to non-volatile\n          storage.')
ospfVirtIfAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 1), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtIfAreaId.setDescription('The transit area that the virtual link\n          traverses.  By definition, this is not 0.0.0.0.')
ospfVirtIfNeighbor = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 2), RouterID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtIfNeighbor.setDescription('The Router ID of the virtual neighbor.')
ospfVirtIfTransitDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 3), UpToMaxAge().clone(1)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfVirtIfTransitDelay.setDescription('The estimated number of seconds it takes to\n          transmit a Link State update packet over this\n          interface.  Note that the minimal value SHOULD be\n          1 second.')
ospfVirtIfRetransInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 4), UpToMaxAge().clone(5)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfVirtIfRetransInterval.setDescription('The number of seconds between link state\n          avertisement retransmissions, for adjacencies\n          belonging to this interface.  This value is\n          also used when retransmitting database\n          description and Link State request packets.  This\n          value should be well over the expected\n          round-trip time.  Note that the minimal value SHOULD be\n          1 second.')
ospfVirtIfHelloInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 5), HelloRange().clone(10)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfVirtIfHelloInterval.setDescription('The length of time, in seconds, between the\n          Hello packets that the router sends on the\n          interface.  This value must be the same for the\n          virtual neighbor.')
ospfVirtIfRtrDeadInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 6), PositiveInteger().clone(60)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfVirtIfRtrDeadInterval.setDescription("The number of seconds that a router's Hello\n          packets have not been seen before its\n          neighbors declare the router down.  This should be\n          some multiple of the Hello interval.  This\n          value must be the same for the virtual neighbor.")
ospfVirtIfState = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 4,))).clone(namedValues=NamedValues(("down", 1), ("pointToPoint", 4),)).clone('down')).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtIfState.setDescription('OSPF virtual interface states.')
ospfVirtIfEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtIfEvents.setDescription('The number of state changes or error events on\n          this virtual link.\n\n          Discontinuities in the value of this counter can occur\n          at re-initialization of the management system, and at other\n          times as indicated by the value of ospfDiscontinuityTime.')
ospfVirtIfAuthKey = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,256)).clone(hexValue="0000000000000000")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfVirtIfAuthKey.setDescription('The cleartext password used as an OSPF\n          authentication key when simplePassword security\n          is enabled.  This object does not access any OSPF\n          cryptogaphic (e.g., MD5) authentication key under\n          any circumstance.\n          If the key length is shorter than 8 octets, the\n          agent will left adjust and zero fill to 8 octets.\n\n          Unauthenticated interfaces need no authentication\n          key, and simple password authentication cannot use\n          a key of more than 8 octets.\n\n          Note that the use of simplePassword authentication\n          is NOT recommended when there is concern regarding\n          attack upon the OSPF system.  SimplePassword\n          authentication is only sufficient to protect against\n          accidental misconfigurations because it re-uses\n          cleartext passwords.  [RFC1704]\n\n          When read, ospfIfAuthKey always returns an octet\n          string of length zero.')
ospfVirtIfStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 10), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfVirtIfStatus.setDescription('This object permits management of the table by\n          facilitating actions such as row creation,\n          construction, and destruction.\n\n          The value of this object has no effect on\n          whether other objects in this conceptual row can be\n          modified.')
ospfVirtIfAuthType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 11), OspfAuthenticationType().clone('none')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfVirtIfAuthType.setDescription('The authentication type specified for a virtual interface.\n\n          Note that this object can be used to engage\n          in significant attacks against an OSPF router.')
ospfVirtIfLsaCount = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 12), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtIfLsaCount.setDescription("The total number of link-local link state advertisements\n          in this virtual interface's link-local link state database.")
ospfVirtIfLsaCksumSum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 13), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtIfLsaCksumSum.setDescription("The 32-bit unsigned sum of the link state\n          advertisements' LS checksums contained in this\n          virtual interface's link-local link state database.\n          The sum can be used to determine if there has\n          been a change in the virtual interface's link state\n          database, and to compare the virtual interface\n          link state database of the virtual neighbors.")
ospfNbrTable = MibTable((1, 3, 6, 1, 2, 1, 14, 10), )
if mibBuilder.loadTexts: ospfNbrTable.setDescription('A table describing all non-virtual neighbors\n          in the locality of the OSPF router.')
ospfNbrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 10, 1), ).setIndexNames((0, "OSPF-MIB", "ospfNbrIpAddr"), (0, "OSPF-MIB", "ospfNbrAddressLessIndex"))
if mibBuilder.loadTexts: ospfNbrEntry.setDescription('The information regarding a single neighbor.\n\n          Information in this table is persistent and when this object\n          is written the entity SHOULD save the change to non-volatile\n          storage.')
ospfNbrIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrIpAddr.setDescription("The IP address this neighbor is using in its\n          IP source address.  Note that, on addressless\n          links, this will not be 0.0.0.0 but the\n          address of another of the neighbor's interfaces.")
ospfNbrAddressLessIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 2), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrAddressLessIndex.setDescription('On an interface having an IP address, zero.\n          On addressless interfaces, the corresponding\n          value of ifIndex in the Internet Standard MIB.\n          On row creation, this can be derived from the\n          instance.')
ospfNbrRtrId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 3), RouterID().clone(hexValue="00000000")).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrRtrId.setDescription('A 32-bit integer (represented as a type\n          IpAddress) uniquely identifying the neighboring\n          router in the Autonomous System.')
ospfNbrOptions = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrOptions.setDescription("A bit mask corresponding to the neighbor's\n          options field.\n\n          Bit 0, if set, indicates that the system will\n          operate on Type of Service metrics other than\n          TOS 0.  If zero, the neighbor will ignore all\n          metrics except the TOS 0 metric.\n\n          Bit 1, if set, indicates that the associated\n          area accepts and operates on external\n          information; if zero, it is a stub area.\n\n          Bit 2, if set, indicates that the system is\n          capable of routing IP multicast datagrams, that is\n          that it implements the multicast extensions to\n          OSPF.\n          Bit 3, if set, indicates that the associated\n          area is an NSSA.  These areas are capable of\n          carrying type-7 external advertisements, which\n          are translated into type-5 external advertisements\n          at NSSA borders.")
ospfNbrPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 5), DesignatedRouterPriority().clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfNbrPriority.setDescription('The priority of this neighbor in the designated\n          router election algorithm.  The value 0 signifies\n          that the neighbor is not eligible to become\n          the designated router on this particular network.')
ospfNbrState = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8,))).clone(namedValues=NamedValues(("down", 1), ("attempt", 2), ("init", 3), ("twoWay", 4), ("exchangeStart", 5), ("exchange", 6), ("loading", 7), ("full", 8),)).clone('down')).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrState.setDescription('The state of the relationship with this neighbor.')
ospfNbrEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrEvents.setDescription('The number of times this neighbor relationship\n          has changed state or an error has occurred.\n\n          Discontinuities in the value of this counter can occur\n          at re-initialization of the management system, and at other\n          times as indicated by the value of ospfDiscontinuityTime.')
ospfNbrLsRetransQLen = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 8), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrLsRetransQLen.setDescription('The current length of the retransmission\n          queue.')
ospfNbmaNbrStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfNbmaNbrStatus.setDescription('This object permits management of the table by\n          facilitating actions such as row creation,\n          construction, and destruction.\n\n          The value of this object has no effect on\n          whether other objects in this conceptual row can be\n          modified.')
ospfNbmaNbrPermanence = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 10), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("dynamic", 1), ("permanent", 2),)).clone('permanent')).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbmaNbrPermanence.setDescription("This variable displays the status of the entry;\n          'dynamic' and 'permanent' refer to how the neighbor\n          became known.")
ospfNbrHelloSuppressed = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 11), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrHelloSuppressed.setDescription('Indicates whether Hellos are being suppressed\n          to the neighbor.')
ospfNbrRestartHelperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 12), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("notHelping", 1), ("helping", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrRestartHelperStatus.setDescription('Indicates whether the router is acting\n          as a graceful restart helper for the neighbor.')
ospfNbrRestartHelperAge = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 13), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrRestartHelperAge.setDescription('Remaining time in current OSPF graceful restart\n          interval, if the router is acting as a restart\n          helper for the neighbor.')
ospfNbrRestartHelperExitReason = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 14), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("none", 1), ("inProgress", 2), ("completed", 3), ("timedOut", 4), ("topologyChanged", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrRestartHelperExitReason.setDescription('Describes the outcome of the last attempt at acting\n           as a graceful restart helper for the neighbor.')
ospfVirtNbrTable = MibTable((1, 3, 6, 1, 2, 1, 14, 11), )
if mibBuilder.loadTexts: ospfVirtNbrTable.setDescription('This table describes all virtual neighbors.\n          Since virtual links are configured\n          in the Virtual Interface Table, this table is read-only.')
ospfVirtNbrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 11, 1), ).setIndexNames((0, "OSPF-MIB", "ospfVirtNbrArea"), (0, "OSPF-MIB", "ospfVirtNbrRtrId"))
if mibBuilder.loadTexts: ospfVirtNbrEntry.setDescription('Virtual neighbor information.')
ospfVirtNbrArea = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 1), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrArea.setDescription('The Transit Area Identifier.')
ospfVirtNbrRtrId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 2), RouterID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrRtrId.setDescription('A 32-bit integer uniquely identifying the\n          neighboring router in the Autonomous System.')
ospfVirtNbrIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrIpAddr.setDescription('The IP address this virtual neighbor is using.')
ospfVirtNbrOptions = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrOptions.setDescription("A bit mask corresponding to the neighbor's\n          options field.\n\n          Bit 1, if set, indicates that the system will\n          operate on Type of Service metrics other than\n          TOS 0.  If zero, the neighbor will ignore all\n          metrics except the TOS 0 metric.\n\n          Bit 2, if set, indicates that the system is\n          network multicast capable, i.e., that it\n          implements OSPF multicast routing.")
ospfVirtNbrState = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8,))).clone(namedValues=NamedValues(("down", 1), ("attempt", 2), ("init", 3), ("twoWay", 4), ("exchangeStart", 5), ("exchange", 6), ("loading", 7), ("full", 8),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrState.setDescription('The state of the virtual neighbor relationship.')
ospfVirtNbrEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrEvents.setDescription('The number of times this virtual link has\n          changed its state or an error has occurred.\n\n          Discontinuities in the value of this counter can occur\n          at re-initialization of the management system, and at other\n          times as indicated by the value of ospfDiscontinuityTime.')
ospfVirtNbrLsRetransQLen = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrLsRetransQLen.setDescription('The current length of the retransmission\n          queue.')
ospfVirtNbrHelloSuppressed = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrHelloSuppressed.setDescription('Indicates whether Hellos are being suppressed\n          to the neighbor.')
ospfVirtNbrRestartHelperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 9), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("notHelping", 1), ("helping", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrRestartHelperStatus.setDescription('Indicates whether the router is acting\n          as a graceful restart helper for the neighbor.')
ospfVirtNbrRestartHelperAge = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 10), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrRestartHelperAge.setDescription('Remaining time in current OSPF graceful restart\n          interval, if the router is acting as a restart\n          helper for the neighbor.')
ospfVirtNbrRestartHelperExitReason = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 11), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("none", 1), ("inProgress", 2), ("completed", 3), ("timedOut", 4), ("topologyChanged", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrRestartHelperExitReason.setDescription('Describes the outcome of the last attempt at acting\n           as a graceful restart helper for the neighbor.')
ospfExtLsdbTable = MibTable((1, 3, 6, 1, 2, 1, 14, 12), )
if mibBuilder.loadTexts: ospfExtLsdbTable.setDescription("The OSPF Process's external LSA link state database.\n\n          This table is identical to the OSPF LSDB Table\n          in format, but contains only external link state\n          advertisements.  The purpose is to allow external\n          LSAs to be displayed once for the router rather\n          than once in each non-stub area.\n\n          Note that external LSAs are also in the AS-scope link state\n          database.")
ospfExtLsdbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 12, 1), ).setIndexNames((0, "OSPF-MIB", "ospfExtLsdbType"), (0, "OSPF-MIB", "ospfExtLsdbLsid"), (0, "OSPF-MIB", "ospfExtLsdbRouterId"))
if mibBuilder.loadTexts: ospfExtLsdbEntry.setDescription('A single link state advertisement.')
ospfExtLsdbType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 12, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(5,))).clone(namedValues=NamedValues(("asExternalLink", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExtLsdbType.setDescription('The type of the link state advertisement.\n          Each link state type has a separate advertisement\n          format.')
ospfExtLsdbLsid = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 12, 1, 2), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExtLsdbLsid.setDescription('The Link State ID is an LS Type Specific field\n          containing either a Router ID or an IP address;\n          it identifies the piece of the routing domain\n          that is being described by the advertisement.')
ospfExtLsdbRouterId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 12, 1, 3), RouterID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExtLsdbRouterId.setDescription('The 32-bit number that uniquely identifies the\n          originating router in the Autonomous System.')
ospfExtLsdbSequence = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 12, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExtLsdbSequence.setDescription("The sequence number field is a signed 32-bit\n          integer.  It starts with the value '80000001'h,\n          or -'7FFFFFFF'h, and increments until '7FFFFFFF'h.\n          Thus, a typical sequence number will be very negative.\n          It is used to detect old and duplicate link state\n          advertisements.  The space of sequence numbers is linearly\n          ordered.  The larger the sequence number, the more recent\n          the advertisement.")
ospfExtLsdbAge = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 12, 1, 5), Integer32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExtLsdbAge.setDescription('This field is the age of the link state\n          advertisement in seconds.')
ospfExtLsdbChecksum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 12, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExtLsdbChecksum.setDescription("This field is the checksum of the complete\n          contents of the advertisement, excepting the\n          age field.  The age field is excepted so that\n          an advertisement's age can be incremented\n          without updating the checksum.  The checksum\n          used is the same that is used for ISO\n          connectionless datagrams; it is commonly referred\n          to as the Fletcher checksum.")
ospfExtLsdbAdvertisement = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 12, 1, 7), OctetString().subtype(subtypeSpec=ValueSizeConstraint(36,36)).setFixedLength(36)).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExtLsdbAdvertisement.setDescription('The entire link state advertisement, including\n          its header.')
ospfRouteGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 13))
ospfIntraArea = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 13, 1))
ospfInterArea = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 13, 2))
ospfExternalType1 = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 13, 3))
ospfExternalType2 = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 13, 4))
ospfAreaAggregateTable = MibTable((1, 3, 6, 1, 2, 1, 14, 14), )
if mibBuilder.loadTexts: ospfAreaAggregateTable.setDescription("The Area Aggregate Table acts as an adjunct\n           to the Area Table.  It describes those address aggregates\n           that are configured to be propagated from an area.\n           Its purpose is to reduce the amount of information\n           that is known beyond an Area's borders.\n\n           It contains a set of IP address ranges\n           specified by an IP address/IP network mask pair.\n           For example, a class B address range of X.X.X.X\n           with a network mask of 255.255.0.0 includes all IP\n           addresses from X.X.0.0 to X.X.255.255.\n\n           Note that if ranges are configured such that one range\n           subsumes another range (e.g., 10.0.0.0 mask 255.0.0.0\n           and 10.1.0.0 mask 255.255.0.0),\n           the most specific match is the preferred one.")
ospfAreaAggregateEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 14, 1), ).setIndexNames((0, "OSPF-MIB", "ospfAreaAggregateAreaID"), (0, "OSPF-MIB", "ospfAreaAggregateLsdbType"), (0, "OSPF-MIB", "ospfAreaAggregateNet"), (0, "OSPF-MIB", "ospfAreaAggregateMask"))
if mibBuilder.loadTexts: ospfAreaAggregateEntry.setDescription('A single area aggregate entry.\n\n          Information in this table is persistent and when this object\n          is written the entity SHOULD save the change to non-volatile\n          storage.')
ospfAreaAggregateAreaID = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 14, 1, 1), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaAggregateAreaID.setDescription('The area within which the address aggregate is to be\n          found.')
ospfAreaAggregateLsdbType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 14, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(3, 7,))).clone(namedValues=NamedValues(("summaryLink", 3), ("nssaExternalLink", 7),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaAggregateLsdbType.setDescription('The type of the address aggregate.  This field\n          specifies the Lsdb type that this address\n          aggregate applies to.')
ospfAreaAggregateNet = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 14, 1, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaAggregateNet.setDescription('The IP address of the net or subnet indicated\n          by the range.')
ospfAreaAggregateMask = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 14, 1, 4), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaAggregateMask.setDescription('The subnet mask that pertains to the net or\n          subnet.')
ospfAreaAggregateStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 14, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaAggregateStatus.setDescription('This object permits management of the table by\n          facilitating actions such as row creation,\n          construction, and destruction.\n\n          The value of this object has no effect on\n          whether other objects in this conceptual row can be\n          modified.')
ospfAreaAggregateEffect = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 14, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("advertiseMatching", 1), ("doNotAdvertiseMatching", 2),)).clone('advertiseMatching')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaAggregateEffect.setDescription("Subnets subsumed by ranges either trigger the\n          advertisement of the indicated aggregate\n         (advertiseMatching) or result in the subnet's not\n          being advertised at all outside the area.")
ospfAreaAggregateExtRouteTag = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 14, 1, 7), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaAggregateExtRouteTag.setDescription('External route tag to be included in NSSA (type-7)\n           LSAs.')
ospfLocalLsdbTable = MibTable((1, 3, 6, 1, 2, 1, 14, 17), )
if mibBuilder.loadTexts: ospfLocalLsdbTable.setDescription("The OSPF Process's link-local link state database\n          for non-virtual links.\n          This table is identical to the OSPF LSDB Table\n          in format, but contains only link-local Link State\n          Advertisements for non-virtual links.  The purpose is\n          to allow link-local LSAs to be displayed for each\n          non-virtual interface.  This table is implemented to\n          support type-9 LSAs that are defined\n          in 'The OSPF Opaque LSA Option'.")
ospfLocalLsdbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 17, 1), ).setIndexNames((0, "OSPF-MIB", "ospfLocalLsdbIpAddress"), (0, "OSPF-MIB", "ospfLocalLsdbAddressLessIf"), (0, "OSPF-MIB", "ospfLocalLsdbType"), (0, "OSPF-MIB", "ospfLocalLsdbLsid"), (0, "OSPF-MIB", "ospfLocalLsdbRouterId"))
if mibBuilder.loadTexts: ospfLocalLsdbEntry.setDescription('A single link state advertisement.')
ospfLocalLsdbIpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 1), IpAddress())
if mibBuilder.loadTexts: ospfLocalLsdbIpAddress.setDescription('The IP address of the interface from\n          which the LSA was received if the interface is\n          numbered.')
ospfLocalLsdbAddressLessIf = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 2), InterfaceIndexOrZero())
if mibBuilder.loadTexts: ospfLocalLsdbAddressLessIf.setDescription('The interface index of the interface from\n          which the LSA was received if the interface is\n          unnumbered.')
ospfLocalLsdbType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(9,))).clone(namedValues=NamedValues(("localOpaqueLink", 9),)))
if mibBuilder.loadTexts: ospfLocalLsdbType.setDescription('The type of the link state advertisement.\n          Each link state type has a separate\n          advertisement format.')
ospfLocalLsdbLsid = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 4), IpAddress())
if mibBuilder.loadTexts: ospfLocalLsdbLsid.setDescription('The Link State ID is an LS Type Specific field\n          containing a 32-bit identifier in IP address format;\n          it identifies the piece of the routing domain\n          that is being described by the advertisement.')
ospfLocalLsdbRouterId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 5), RouterID())
if mibBuilder.loadTexts: ospfLocalLsdbRouterId.setDescription('The 32-bit number that uniquely identifies the\n          originating router in the Autonomous System.')
ospfLocalLsdbSequence = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLocalLsdbSequence.setDescription("The sequence number field is a signed 32-bit\n          integer.  It starts with the value '80000001'h,\n          or -'7FFFFFFF'h, and increments until '7FFFFFFF'h.\n          Thus, a typical sequence number will be very negative.\n          It is used to detect old and duplicate link state\n          advertisements.  The space of sequence numbers is linearly\n          ordered.  The larger the sequence number, the more recent\n          the advertisement.")
ospfLocalLsdbAge = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 7), Integer32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLocalLsdbAge.setDescription('This field is the age of the link state\n          advertisement in seconds.')
ospfLocalLsdbChecksum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLocalLsdbChecksum.setDescription("This field is the checksum of the complete\n          contents of the advertisement, excepting the\n          age field.  The age field is excepted so that\n          an advertisement's age can be incremented\n          without updating the checksum.  The checksum\n          used is the same that is used for ISO\n          connectionless datagrams; it is commonly referred\n          to as the Fletcher checksum.")
ospfLocalLsdbAdvertisement = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLocalLsdbAdvertisement.setDescription('The entire link state advertisement, including\n          its header.\n\n          Note that for variable length LSAs, SNMP agents\n          may not be able to return the largest string size.')
ospfVirtLocalLsdbTable = MibTable((1, 3, 6, 1, 2, 1, 14, 18), )
if mibBuilder.loadTexts: ospfVirtLocalLsdbTable.setDescription("The OSPF Process's link-local link state database\n          for virtual links.\n          This table is identical to the OSPF LSDB Table\n          in format, but contains only link-local Link State\n          Advertisements for virtual links.  The purpose is to\n          allow link-local LSAs to be displayed for each virtual\n          interface.  This table is implemented to support type-9 LSAs\n          that are defined in 'The OSPF Opaque LSA Option'.")
ospfVirtLocalLsdbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 18, 1), ).setIndexNames((0, "OSPF-MIB", "ospfVirtLocalLsdbTransitArea"), (0, "OSPF-MIB", "ospfVirtLocalLsdbNeighbor"), (0, "OSPF-MIB", "ospfVirtLocalLsdbType"), (0, "OSPF-MIB", "ospfVirtLocalLsdbLsid"), (0, "OSPF-MIB", "ospfVirtLocalLsdbRouterId"))
if mibBuilder.loadTexts: ospfVirtLocalLsdbEntry.setDescription('A single link state advertisement.')
ospfVirtLocalLsdbTransitArea = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 1), AreaID())
if mibBuilder.loadTexts: ospfVirtLocalLsdbTransitArea.setDescription('The transit area that the virtual link\n          traverses.  By definition, this is not 0.0.0.0.')
ospfVirtLocalLsdbNeighbor = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 2), RouterID())
if mibBuilder.loadTexts: ospfVirtLocalLsdbNeighbor.setDescription('The Router ID of the virtual neighbor.')
ospfVirtLocalLsdbType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(9,))).clone(namedValues=NamedValues(("localOpaqueLink", 9),)))
if mibBuilder.loadTexts: ospfVirtLocalLsdbType.setDescription('The type of the link state advertisement.\n          Each link state type has a separate\n          advertisement format.')
ospfVirtLocalLsdbLsid = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 4), IpAddress())
if mibBuilder.loadTexts: ospfVirtLocalLsdbLsid.setDescription('The Link State ID is an LS Type Specific field\n          containing a 32-bit identifier in IP address format;\n          it identifies the piece of the routing domain\n          that is being described by the advertisement.')
ospfVirtLocalLsdbRouterId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 5), RouterID())
if mibBuilder.loadTexts: ospfVirtLocalLsdbRouterId.setDescription('The 32-bit number that uniquely identifies the\n          originating router in the Autonomous System.')
ospfVirtLocalLsdbSequence = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtLocalLsdbSequence.setDescription("The sequence number field is a signed 32-bit\n          integer.  It starts with the value '80000001'h,\n          or -'7FFFFFFF'h, and increments until '7FFFFFFF'h.\n          Thus, a typical sequence number will be very negative.\n          It is used to detect old and duplicate link state\n          advertisements.  The space of sequence numbers is linearly\n          ordered.  The larger the sequence number, the more recent\n          the advertisement.")
ospfVirtLocalLsdbAge = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 7), Integer32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtLocalLsdbAge.setDescription('This field is the age of the link state\n          advertisement in seconds.')
ospfVirtLocalLsdbChecksum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtLocalLsdbChecksum.setDescription("This field is the checksum of the complete\n          contents of the advertisement, excepting the\n          age field.  The age field is excepted so that\n          an advertisement's age can be incremented\n          without updating the checksum.  The checksum\n          used is the same that is used for ISO\n          connectionless datagrams; it is commonly\n          referred to as the Fletcher checksum.")
ospfVirtLocalLsdbAdvertisement = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtLocalLsdbAdvertisement.setDescription('The entire link state advertisement, including\n          its header.')
ospfAsLsdbTable = MibTable((1, 3, 6, 1, 2, 1, 14, 19), )
if mibBuilder.loadTexts: ospfAsLsdbTable.setDescription("The OSPF Process's AS-scope LSA link state database.\n           The database contains the AS-scope Link State\n           Advertisements from throughout the areas that\n           the device is attached to.\n\n           This table is identical to the OSPF LSDB Table\n           in format, but contains only AS-scope Link State\n           Advertisements.  The purpose is to allow AS-scope\n           LSAs to be displayed once for the router rather\n           than once in each non-stub area.")
ospfAsLsdbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 19, 1), ).setIndexNames((0, "OSPF-MIB", "ospfAsLsdbType"), (0, "OSPF-MIB", "ospfAsLsdbLsid"), (0, "OSPF-MIB", "ospfAsLsdbRouterId"))
if mibBuilder.loadTexts: ospfAsLsdbEntry.setDescription('A single link state advertisement.')
ospfAsLsdbType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 19, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(5, 11,))).clone(namedValues=NamedValues(("asExternalLink", 5), ("asOpaqueLink", 11),)))
if mibBuilder.loadTexts: ospfAsLsdbType.setDescription('The type of the link state advertisement.\n          Each link state type has a separate\n          advertisement format.')
ospfAsLsdbLsid = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 19, 1, 2), IpAddress())
if mibBuilder.loadTexts: ospfAsLsdbLsid.setDescription('The Link State ID is an LS Type Specific field\n          containing either a Router ID or an IP address;\n          it identifies the piece of the routing domain\n          that is being described by the advertisement.')
ospfAsLsdbRouterId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 19, 1, 3), RouterID())
if mibBuilder.loadTexts: ospfAsLsdbRouterId.setDescription('The 32-bit number that uniquely identifies the\n          originating router in the Autonomous System.')
ospfAsLsdbSequence = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 19, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAsLsdbSequence.setDescription("The sequence number field is a signed 32-bit\n          integer.  It starts with the value '80000001'h,\n          or -'7FFFFFFF'h, and increments until '7FFFFFFF'h.\n          Thus, a typical sequence number will be very negative.\n          It is used to detect old and duplicate link state\n          advertisements.  The space of sequence numbers is linearly\n          ordered.  The larger the sequence number, the more recent\n          the advertisement.")
ospfAsLsdbAge = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 19, 1, 5), Integer32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAsLsdbAge.setDescription('This field is the age of the link state\n          advertisement in seconds.')
ospfAsLsdbChecksum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 19, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAsLsdbChecksum.setDescription("This field is the checksum of the complete\n          contents of the advertisement, excepting the\n          age field.  The age field is excepted so that\n          an advertisement's age can be incremented\n          without updating the checksum.  The checksum\n          used is the same that is used for ISO\n          connectionless datagrams; it is commonly referred\n          to as the Fletcher checksum.")
ospfAsLsdbAdvertisement = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 19, 1, 7), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAsLsdbAdvertisement.setDescription('The entire link state advertisement, including\n          its header.')
ospfAreaLsaCountTable = MibTable((1, 3, 6, 1, 2, 1, 14, 20), )
if mibBuilder.loadTexts: ospfAreaLsaCountTable.setDescription('This table maintains per-area, per-LSA-type counters')
ospfAreaLsaCountEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 20, 1), ).setIndexNames((0, "OSPF-MIB", "ospfAreaLsaCountAreaId"), (0, "OSPF-MIB", "ospfAreaLsaCountLsaType"))
if mibBuilder.loadTexts: ospfAreaLsaCountEntry.setDescription('An entry with a number of link advertisements\n              of a given type for a given area.')
ospfAreaLsaCountAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 20, 1, 1), AreaID())
if mibBuilder.loadTexts: ospfAreaLsaCountAreaId.setDescription('This entry Area ID.')
ospfAreaLsaCountLsaType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 20, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 6, 7, 10,))).clone(namedValues=NamedValues(("routerLink", 1), ("networkLink", 2), ("summaryLink", 3), ("asSummaryLink", 4), ("multicastLink", 6), ("nssaExternalLink", 7), ("areaOpaqueLink", 10),)))
if mibBuilder.loadTexts: ospfAreaLsaCountLsaType.setDescription('This entry LSA type.')
ospfAreaLsaCountNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 20, 1, 3), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaLsaCountNumber.setDescription('Number of LSAs of a given type for a given area.')
ospfConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 15))
ospfGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 15, 1))
ospfCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 15, 2))
ospfCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 14, 15, 2, 1)).setObjects(*(("OSPF-MIB", "ospfBasicGroup"), ("OSPF-MIB", "ospfAreaGroup"), ("OSPF-MIB", "ospfStubAreaGroup"), ("OSPF-MIB", "ospfIfGroup"), ("OSPF-MIB", "ospfIfMetricGroup"), ("OSPF-MIB", "ospfVirtIfGroup"), ("OSPF-MIB", "ospfNbrGroup"), ("OSPF-MIB", "ospfVirtNbrGroup"), ("OSPF-MIB", "ospfAreaAggregateGroup"), ("OSPF-MIB", "ospfHostGroup"), ("OSPF-MIB", "ospfLsdbGroup"), ("OSPF-MIB", "ospfExtLsdbGroup"),))
if mibBuilder.loadTexts: ospfCompliance.setDescription('The compliance statement for OSPF systems\n          conforming to RFC 1850.')
ospfCompliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 14, 15, 2, 2)).setObjects(*(("OSPF-MIB", "ospfBasicGroup2"), ("OSPF-MIB", "ospfAreaGroup2"), ("OSPF-MIB", "ospfStubAreaGroup"), ("OSPF-MIB", "ospfIfGroup2"), ("OSPF-MIB", "ospfIfMetricGroup"), ("OSPF-MIB", "ospfVirtIfGroup2"), ("OSPF-MIB", "ospfNbrGroup2"), ("OSPF-MIB", "ospfVirtNbrGroup2"), ("OSPF-MIB", "ospfAreaAggregateGroup2"), ("OSPF-MIB", "ospfHostGroup2"), ("OSPF-MIB", "ospfLsdbGroup"), ("OSPF-MIB", "ospfAsLsdbGroup"), ("OSPF-MIB", "ospfLocalLsdbGroup"), ("OSPF-MIB", "ospfVirtLocalLsdbGroup"), ("OSPF-MIB", "ospfAreaLsaCountGroup"),))
if mibBuilder.loadTexts: ospfCompliance2.setDescription('The compliance statement.')
ospfComplianceObsolete = ModuleCompliance((1, 3, 6, 1, 2, 1, 14, 15, 2, 3)).setObjects(*(("OSPF-MIB", "ospfAreaRangeGroup"), ("OSPF-MIB", "ospfObsoleteGroup"),))
if mibBuilder.loadTexts: ospfComplianceObsolete.setDescription('Contains obsolete object groups.')
ospfBasicGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 1)).setObjects(*(("OSPF-MIB", "ospfRouterId"), ("OSPF-MIB", "ospfAdminStat"), ("OSPF-MIB", "ospfVersionNumber"), ("OSPF-MIB", "ospfAreaBdrRtrStatus"), ("OSPF-MIB", "ospfASBdrRtrStatus"), ("OSPF-MIB", "ospfExternLsaCount"), ("OSPF-MIB", "ospfExternLsaCksumSum"), ("OSPF-MIB", "ospfTOSSupport"), ("OSPF-MIB", "ospfOriginateNewLsas"), ("OSPF-MIB", "ospfRxNewLsas"), ("OSPF-MIB", "ospfExtLsdbLimit"), ("OSPF-MIB", "ospfMulticastExtensions"), ("OSPF-MIB", "ospfExitOverflowInterval"), ("OSPF-MIB", "ospfDemandExtensions"),))
if mibBuilder.loadTexts: ospfBasicGroup.setDescription('These objects are used to monitor/manage\n          global OSPF parameters.  This object group\n          conforms to RFC 1850.')
ospfAreaGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 2)).setObjects(*(("OSPF-MIB", "ospfAreaId"), ("OSPF-MIB", "ospfImportAsExtern"), ("OSPF-MIB", "ospfSpfRuns"), ("OSPF-MIB", "ospfAreaBdrRtrCount"), ("OSPF-MIB", "ospfAsBdrRtrCount"), ("OSPF-MIB", "ospfAreaLsaCount"), ("OSPF-MIB", "ospfAreaLsaCksumSum"), ("OSPF-MIB", "ospfAreaSummary"), ("OSPF-MIB", "ospfAreaStatus"),))
if mibBuilder.loadTexts: ospfAreaGroup.setDescription('These objects are used for OSPF systems\n          supporting areas per RFC 1850.')
ospfStubAreaGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 3)).setObjects(*(("OSPF-MIB", "ospfStubAreaId"), ("OSPF-MIB", "ospfStubTOS"), ("OSPF-MIB", "ospfStubMetric"), ("OSPF-MIB", "ospfStubStatus"), ("OSPF-MIB", "ospfStubMetricType"),))
if mibBuilder.loadTexts: ospfStubAreaGroup.setDescription('These objects are used for OSPF systems\n          supporting stub areas.')
ospfLsdbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 4)).setObjects(*(("OSPF-MIB", "ospfLsdbAreaId"), ("OSPF-MIB", "ospfLsdbType"), ("OSPF-MIB", "ospfLsdbLsid"), ("OSPF-MIB", "ospfLsdbRouterId"), ("OSPF-MIB", "ospfLsdbSequence"), ("OSPF-MIB", "ospfLsdbAge"), ("OSPF-MIB", "ospfLsdbChecksum"), ("OSPF-MIB", "ospfLsdbAdvertisement"),))
if mibBuilder.loadTexts: ospfLsdbGroup.setDescription('These objects are used for OSPF systems\n          that display their link state database.')
ospfAreaRangeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 5)).setObjects(*(("OSPF-MIB", "ospfAreaRangeAreaId"), ("OSPF-MIB", "ospfAreaRangeNet"), ("OSPF-MIB", "ospfAreaRangeMask"), ("OSPF-MIB", "ospfAreaRangeStatus"), ("OSPF-MIB", "ospfAreaRangeEffect"),))
if mibBuilder.loadTexts: ospfAreaRangeGroup.setDescription('These objects are used for non-CIDR OSPF\n          systems that support multiple areas.  This\n          object group is obsolete.')
ospfHostGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 6)).setObjects(*(("OSPF-MIB", "ospfHostIpAddress"), ("OSPF-MIB", "ospfHostTOS"), ("OSPF-MIB", "ospfHostMetric"), ("OSPF-MIB", "ospfHostStatus"), ("OSPF-MIB", "ospfHostAreaID"),))
if mibBuilder.loadTexts: ospfHostGroup.setDescription('These objects are used for OSPF systems\n          that support attached hosts.')
ospfIfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 7)).setObjects(*(("OSPF-MIB", "ospfIfIpAddress"), ("OSPF-MIB", "ospfAddressLessIf"), ("OSPF-MIB", "ospfIfAreaId"), ("OSPF-MIB", "ospfIfType"), ("OSPF-MIB", "ospfIfAdminStat"), ("OSPF-MIB", "ospfIfRtrPriority"), ("OSPF-MIB", "ospfIfTransitDelay"), ("OSPF-MIB", "ospfIfRetransInterval"), ("OSPF-MIB", "ospfIfHelloInterval"), ("OSPF-MIB", "ospfIfRtrDeadInterval"), ("OSPF-MIB", "ospfIfPollInterval"), ("OSPF-MIB", "ospfIfState"), ("OSPF-MIB", "ospfIfDesignatedRouter"), ("OSPF-MIB", "ospfIfBackupDesignatedRouter"), ("OSPF-MIB", "ospfIfEvents"), ("OSPF-MIB", "ospfIfAuthType"), ("OSPF-MIB", "ospfIfAuthKey"), ("OSPF-MIB", "ospfIfStatus"), ("OSPF-MIB", "ospfIfMulticastForwarding"), ("OSPF-MIB", "ospfIfDemand"),))
if mibBuilder.loadTexts: ospfIfGroup.setDescription('These objects are used to monitor/manage OSPF\n          interfaces.  This object group conforms to RFC 1850.')
ospfIfMetricGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 8)).setObjects(*(("OSPF-MIB", "ospfIfMetricIpAddress"), ("OSPF-MIB", "ospfIfMetricAddressLessIf"), ("OSPF-MIB", "ospfIfMetricTOS"), ("OSPF-MIB", "ospfIfMetricValue"), ("OSPF-MIB", "ospfIfMetricStatus"),))
if mibBuilder.loadTexts: ospfIfMetricGroup.setDescription('These objects are used for OSPF systems for supporting\n          interface metrics.')
ospfVirtIfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 9)).setObjects(*(("OSPF-MIB", "ospfVirtIfAreaId"), ("OSPF-MIB", "ospfVirtIfNeighbor"), ("OSPF-MIB", "ospfVirtIfTransitDelay"), ("OSPF-MIB", "ospfVirtIfRetransInterval"), ("OSPF-MIB", "ospfVirtIfHelloInterval"), ("OSPF-MIB", "ospfVirtIfRtrDeadInterval"), ("OSPF-MIB", "ospfVirtIfState"), ("OSPF-MIB", "ospfVirtIfEvents"), ("OSPF-MIB", "ospfVirtIfAuthType"), ("OSPF-MIB", "ospfVirtIfAuthKey"), ("OSPF-MIB", "ospfVirtIfStatus"),))
if mibBuilder.loadTexts: ospfVirtIfGroup.setDescription('These objects are used for OSPF systems for supporting\n          virtual interfaces.  This object group conforms\n          to RFC 1850.')
ospfNbrGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 10)).setObjects(*(("OSPF-MIB", "ospfNbrIpAddr"), ("OSPF-MIB", "ospfNbrAddressLessIndex"), ("OSPF-MIB", "ospfNbrRtrId"), ("OSPF-MIB", "ospfNbrOptions"), ("OSPF-MIB", "ospfNbrPriority"), ("OSPF-MIB", "ospfNbrState"), ("OSPF-MIB", "ospfNbrEvents"), ("OSPF-MIB", "ospfNbrLsRetransQLen"), ("OSPF-MIB", "ospfNbmaNbrStatus"), ("OSPF-MIB", "ospfNbmaNbrPermanence"), ("OSPF-MIB", "ospfNbrHelloSuppressed"),))
if mibBuilder.loadTexts: ospfNbrGroup.setDescription('These objects are used to monitor/manage OSPF neighbors.\n          This object group conforms to RFC 1850.')
ospfVirtNbrGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 11)).setObjects(*(("OSPF-MIB", "ospfVirtNbrArea"), ("OSPF-MIB", "ospfVirtNbrRtrId"), ("OSPF-MIB", "ospfVirtNbrIpAddr"), ("OSPF-MIB", "ospfVirtNbrOptions"), ("OSPF-MIB", "ospfVirtNbrState"), ("OSPF-MIB", "ospfVirtNbrEvents"), ("OSPF-MIB", "ospfVirtNbrLsRetransQLen"), ("OSPF-MIB", "ospfVirtNbrHelloSuppressed"),))
if mibBuilder.loadTexts: ospfVirtNbrGroup.setDescription('These objects are used to monitor/manage OSPF virtual\n          neighbors.  This object group conforms to RFC 1850.')
ospfExtLsdbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 12)).setObjects(*(("OSPF-MIB", "ospfExtLsdbType"), ("OSPF-MIB", "ospfExtLsdbLsid"), ("OSPF-MIB", "ospfExtLsdbRouterId"), ("OSPF-MIB", "ospfExtLsdbSequence"), ("OSPF-MIB", "ospfExtLsdbAge"), ("OSPF-MIB", "ospfExtLsdbChecksum"), ("OSPF-MIB", "ospfExtLsdbAdvertisement"),))
if mibBuilder.loadTexts: ospfExtLsdbGroup.setDescription('These objects are used for OSPF systems that display\n          their link state database.  This object group\n          conforms to RFC 1850.\n\n          This object group is replaced by the ospfAsLsdbGroup\n          in order to support any AS-scope LSA type in a single\n          table.')
ospfAreaAggregateGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 13)).setObjects(*(("OSPF-MIB", "ospfAreaAggregateAreaID"), ("OSPF-MIB", "ospfAreaAggregateLsdbType"), ("OSPF-MIB", "ospfAreaAggregateNet"), ("OSPF-MIB", "ospfAreaAggregateMask"), ("OSPF-MIB", "ospfAreaAggregateStatus"), ("OSPF-MIB", "ospfAreaAggregateEffect"),))
if mibBuilder.loadTexts: ospfAreaAggregateGroup.setDescription('These objects are used for OSPF systems to support\n          network prefix aggregation across areas.')
ospfLocalLsdbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 14)).setObjects(*(("OSPF-MIB", "ospfLocalLsdbSequence"), ("OSPF-MIB", "ospfLocalLsdbAge"), ("OSPF-MIB", "ospfLocalLsdbChecksum"), ("OSPF-MIB", "ospfLocalLsdbAdvertisement"),))
if mibBuilder.loadTexts: ospfLocalLsdbGroup.setDescription('These objects are used for OSPF systems\n          that display their link-local link state databases\n          for non-virtual links.')
ospfVirtLocalLsdbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 15)).setObjects(*(("OSPF-MIB", "ospfVirtLocalLsdbSequence"), ("OSPF-MIB", "ospfVirtLocalLsdbAge"), ("OSPF-MIB", "ospfVirtLocalLsdbChecksum"), ("OSPF-MIB", "ospfVirtLocalLsdbAdvertisement"),))
if mibBuilder.loadTexts: ospfVirtLocalLsdbGroup.setDescription('These objects are used for OSPF systems\n           that display their link-local link state databases\n           for virtual links.')
ospfAsLsdbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 16)).setObjects(*(("OSPF-MIB", "ospfAsLsdbSequence"), ("OSPF-MIB", "ospfAsLsdbAge"), ("OSPF-MIB", "ospfAsLsdbChecksum"), ("OSPF-MIB", "ospfAsLsdbAdvertisement"),))
if mibBuilder.loadTexts: ospfAsLsdbGroup.setDescription('These objects are used for OSPF systems\n           that display their AS-scope link state database.')
ospfBasicGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 17)).setObjects(*(("OSPF-MIB", "ospfRouterId"), ("OSPF-MIB", "ospfAdminStat"), ("OSPF-MIB", "ospfVersionNumber"), ("OSPF-MIB", "ospfAreaBdrRtrStatus"), ("OSPF-MIB", "ospfASBdrRtrStatus"), ("OSPF-MIB", "ospfExternLsaCount"), ("OSPF-MIB", "ospfExternLsaCksumSum"), ("OSPF-MIB", "ospfTOSSupport"), ("OSPF-MIB", "ospfOriginateNewLsas"), ("OSPF-MIB", "ospfRxNewLsas"), ("OSPF-MIB", "ospfExtLsdbLimit"), ("OSPF-MIB", "ospfMulticastExtensions"), ("OSPF-MIB", "ospfExitOverflowInterval"), ("OSPF-MIB", "ospfDemandExtensions"), ("OSPF-MIB", "ospfRFC1583Compatibility"), ("OSPF-MIB", "ospfOpaqueLsaSupport"), ("OSPF-MIB", "ospfReferenceBandwidth"), ("OSPF-MIB", "ospfRestartSupport"), ("OSPF-MIB", "ospfRestartInterval"), ("OSPF-MIB", "ospfRestartStrictLsaChecking"), ("OSPF-MIB", "ospfRestartStatus"), ("OSPF-MIB", "ospfRestartAge"), ("OSPF-MIB", "ospfRestartExitReason"), ("OSPF-MIB", "ospfAsLsaCount"), ("OSPF-MIB", "ospfAsLsaCksumSum"), ("OSPF-MIB", "ospfStubRouterSupport"), ("OSPF-MIB", "ospfStubRouterAdvertisement"), ("OSPF-MIB", "ospfDiscontinuityTime"),))
if mibBuilder.loadTexts: ospfBasicGroup2.setDescription('These objects are used to monitor/manage OSPF global\n          parameters.')
ospfAreaGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 18)).setObjects(*(("OSPF-MIB", "ospfAreaId"), ("OSPF-MIB", "ospfImportAsExtern"), ("OSPF-MIB", "ospfSpfRuns"), ("OSPF-MIB", "ospfAreaBdrRtrCount"), ("OSPF-MIB", "ospfAsBdrRtrCount"), ("OSPF-MIB", "ospfAreaLsaCount"), ("OSPF-MIB", "ospfAreaLsaCksumSum"), ("OSPF-MIB", "ospfAreaSummary"), ("OSPF-MIB", "ospfAreaStatus"), ("OSPF-MIB", "ospfAreaNssaTranslatorRole"), ("OSPF-MIB", "ospfAreaNssaTranslatorState"), ("OSPF-MIB", "ospfAreaNssaTranslatorStabilityInterval"), ("OSPF-MIB", "ospfAreaNssaTranslatorEvents"),))
if mibBuilder.loadTexts: ospfAreaGroup2.setDescription('These objects are used by OSPF systems\n            to support areas.')
ospfIfGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 19)).setObjects(*(("OSPF-MIB", "ospfIfIpAddress"), ("OSPF-MIB", "ospfAddressLessIf"), ("OSPF-MIB", "ospfIfAreaId"), ("OSPF-MIB", "ospfIfType"), ("OSPF-MIB", "ospfIfAdminStat"), ("OSPF-MIB", "ospfIfRtrPriority"), ("OSPF-MIB", "ospfIfTransitDelay"), ("OSPF-MIB", "ospfIfRetransInterval"), ("OSPF-MIB", "ospfIfHelloInterval"), ("OSPF-MIB", "ospfIfRtrDeadInterval"), ("OSPF-MIB", "ospfIfPollInterval"), ("OSPF-MIB", "ospfIfState"), ("OSPF-MIB", "ospfIfDesignatedRouter"), ("OSPF-MIB", "ospfIfBackupDesignatedRouter"), ("OSPF-MIB", "ospfIfEvents"), ("OSPF-MIB", "ospfIfAuthType"), ("OSPF-MIB", "ospfIfAuthKey"), ("OSPF-MIB", "ospfIfStatus"), ("OSPF-MIB", "ospfIfMulticastForwarding"), ("OSPF-MIB", "ospfIfDemand"), ("OSPF-MIB", "ospfIfLsaCount"), ("OSPF-MIB", "ospfIfLsaCksumSum"),))
if mibBuilder.loadTexts: ospfIfGroup2.setDescription('These objects are used to monitor/manage OSPF interfaces.')
ospfVirtIfGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 20)).setObjects(*(("OSPF-MIB", "ospfVirtIfAreaId"), ("OSPF-MIB", "ospfVirtIfNeighbor"), ("OSPF-MIB", "ospfVirtIfTransitDelay"), ("OSPF-MIB", "ospfVirtIfRetransInterval"), ("OSPF-MIB", "ospfVirtIfHelloInterval"), ("OSPF-MIB", "ospfVirtIfRtrDeadInterval"), ("OSPF-MIB", "ospfVirtIfState"), ("OSPF-MIB", "ospfVirtIfEvents"), ("OSPF-MIB", "ospfVirtIfAuthType"), ("OSPF-MIB", "ospfVirtIfAuthKey"), ("OSPF-MIB", "ospfVirtIfStatus"), ("OSPF-MIB", "ospfVirtIfLsaCount"), ("OSPF-MIB", "ospfVirtIfLsaCksumSum"), ("OSPF-MIB", "ospfIfDesignatedRouterId"), ("OSPF-MIB", "ospfIfBackupDesignatedRouterId"),))
if mibBuilder.loadTexts: ospfVirtIfGroup2.setDescription('These objects are used to monitor/manage OSPF\n          virtual interfaces.')
ospfNbrGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 21)).setObjects(*(("OSPF-MIB", "ospfNbrIpAddr"), ("OSPF-MIB", "ospfNbrAddressLessIndex"), ("OSPF-MIB", "ospfNbrRtrId"), ("OSPF-MIB", "ospfNbrOptions"), ("OSPF-MIB", "ospfNbrPriority"), ("OSPF-MIB", "ospfNbrState"), ("OSPF-MIB", "ospfNbrEvents"), ("OSPF-MIB", "ospfNbrLsRetransQLen"), ("OSPF-MIB", "ospfNbmaNbrStatus"), ("OSPF-MIB", "ospfNbmaNbrPermanence"), ("OSPF-MIB", "ospfNbrHelloSuppressed"), ("OSPF-MIB", "ospfNbrRestartHelperStatus"), ("OSPF-MIB", "ospfNbrRestartHelperAge"), ("OSPF-MIB", "ospfNbrRestartHelperExitReason"),))
if mibBuilder.loadTexts: ospfNbrGroup2.setDescription('These objects are used to monitor/manage OSPF\n          neighbors.')
ospfVirtNbrGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 22)).setObjects(*(("OSPF-MIB", "ospfVirtNbrArea"), ("OSPF-MIB", "ospfVirtNbrRtrId"), ("OSPF-MIB", "ospfVirtNbrIpAddr"), ("OSPF-MIB", "ospfVirtNbrOptions"), ("OSPF-MIB", "ospfVirtNbrState"), ("OSPF-MIB", "ospfVirtNbrEvents"), ("OSPF-MIB", "ospfVirtNbrLsRetransQLen"), ("OSPF-MIB", "ospfVirtNbrHelloSuppressed"), ("OSPF-MIB", "ospfVirtNbrRestartHelperStatus"), ("OSPF-MIB", "ospfVirtNbrRestartHelperAge"), ("OSPF-MIB", "ospfVirtNbrRestartHelperExitReason"),))
if mibBuilder.loadTexts: ospfVirtNbrGroup2.setDescription('These objects are used to monitor/manage OSPF\n          virtual neighbors.')
ospfAreaAggregateGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 23)).setObjects(*(("OSPF-MIB", "ospfAreaAggregateAreaID"), ("OSPF-MIB", "ospfAreaAggregateLsdbType"), ("OSPF-MIB", "ospfAreaAggregateNet"), ("OSPF-MIB", "ospfAreaAggregateMask"), ("OSPF-MIB", "ospfAreaAggregateStatus"), ("OSPF-MIB", "ospfAreaAggregateEffect"), ("OSPF-MIB", "ospfAreaAggregateExtRouteTag"),))
if mibBuilder.loadTexts: ospfAreaAggregateGroup2.setDescription('These objects are used for OSPF systems to support\n          network prefix aggregation across areas.')
ospfAreaLsaCountGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 24)).setObjects(*(("OSPF-MIB", "ospfAreaLsaCountNumber"),))
if mibBuilder.loadTexts: ospfAreaLsaCountGroup.setDescription('These objects are used for OSPF systems that display\n          per-area, per-LSA-type counters.')
ospfHostGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 25)).setObjects(*(("OSPF-MIB", "ospfHostIpAddress"), ("OSPF-MIB", "ospfHostTOS"), ("OSPF-MIB", "ospfHostMetric"), ("OSPF-MIB", "ospfHostStatus"), ("OSPF-MIB", "ospfHostCfgAreaID"),))
if mibBuilder.loadTexts: ospfHostGroup2.setDescription('These objects are used for OSPF systems\n          that support attached hosts.')
ospfObsoleteGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 26)).setObjects(*(("OSPF-MIB", "ospfAuthType"),))
if mibBuilder.loadTexts: ospfObsoleteGroup.setDescription('These objects are obsolete and are no longer required for\n          OSPF systems.  They are placed into this group for SMI\n          conformance.')
mibBuilder.exportSymbols("OSPF-MIB", ospfLocalLsdbLsid=ospfLocalLsdbLsid, ospfNbrEvents=ospfNbrEvents, ospfVirtIfEvents=ospfVirtIfEvents, ospfIfDesignatedRouterId=ospfIfDesignatedRouterId, ospfRestartAge=ospfRestartAge, ospfVirtIfEntry=ospfVirtIfEntry, ospfAreaRangeStatus=ospfAreaRangeStatus, ospf=ospf, ospfAsLsdbTable=ospfAsLsdbTable, ospfCompliance2=ospfCompliance2, ospfStubAreaId=ospfStubAreaId, ospfVirtNbrRestartHelperExitReason=ospfVirtNbrRestartHelperExitReason, ospfIfBackupDesignatedRouter=ospfIfBackupDesignatedRouter, ospfExtLsdbAdvertisement=ospfExtLsdbAdvertisement, ospfAreaRangeEffect=ospfAreaRangeEffect, ospfIfMetricGroup=ospfIfMetricGroup, ospfVirtLocalLsdbAge=ospfVirtLocalLsdbAge, ospfHostAreaID=ospfHostAreaID, ospfOriginateNewLsas=ospfOriginateNewLsas, ospfGroups=ospfGroups, ospfStubRouterAdvertisement=ospfStubRouterAdvertisement, ospfLsdbTable=ospfLsdbTable, ospfLocalLsdbSequence=ospfLocalLsdbSequence, ospfAreaLsaCountNumber=ospfAreaLsaCountNumber, ospfLsdbGroup=ospfLsdbGroup, ospfAreaLsaCountAreaId=ospfAreaLsaCountAreaId, ospfAreaRangeMask=ospfAreaRangeMask, ospfVirtNbrTable=ospfVirtNbrTable, HelloRange=HelloRange, ospfHostTOS=ospfHostTOS, ospfHostCfgAreaID=ospfHostCfgAreaID, ospfVirtLocalLsdbNeighbor=ospfVirtLocalLsdbNeighbor, ospfLsdbAdvertisement=ospfLsdbAdvertisement, ospfExtLsdbRouterId=ospfExtLsdbRouterId, ospfAreaLsaCountTable=ospfAreaLsaCountTable, ospfHostIpAddress=ospfHostIpAddress, ospfExtLsdbGroup=ospfExtLsdbGroup, ospfExtLsdbChecksum=ospfExtLsdbChecksum, ospfAreaLsaCksumSum=ospfAreaLsaCksumSum, ospfRxNewLsas=ospfRxNewLsas, ospfStubStatus=ospfStubStatus, BigMetric=BigMetric, ospfIfIpAddress=ospfIfIpAddress, ospfIfRetransInterval=ospfIfRetransInterval, ospfAdminStat=ospfAdminStat, ospfExtLsdbAge=ospfExtLsdbAge, ospfIfAreaId=ospfIfAreaId, ospfVirtIfRtrDeadInterval=ospfVirtIfRtrDeadInterval, ospfVirtIfNeighbor=ospfVirtIfNeighbor, ospfObsoleteGroup=ospfObsoleteGroup, ospfVirtIfHelloInterval=ospfVirtIfHelloInterval, ospfHostStatus=ospfHostStatus, ospfLsdbAreaId=ospfLsdbAreaId, ospfAreaAggregateGroup=ospfAreaAggregateGroup, ospfOpaqueLsaSupport=ospfOpaqueLsaSupport, ospfNbrRestartHelperExitReason=ospfNbrRestartHelperExitReason, ospfCompliances=ospfCompliances, ospfVirtNbrOptions=ospfVirtNbrOptions, ospfNbrGroup=ospfNbrGroup, ospfVirtLocalLsdbSequence=ospfVirtLocalLsdbSequence, ospfAsBdrRtrCount=ospfAsBdrRtrCount, ospfImportAsExtern=ospfImportAsExtern, ospfIfAuthType=ospfIfAuthType, ospfExternLsaCount=ospfExternLsaCount, ospfVirtNbrLsRetransQLen=ospfVirtNbrLsRetransQLen, ospfVirtLocalLsdbGroup=ospfVirtLocalLsdbGroup, ospfIfLsaCount=ospfIfLsaCount, ospfVirtIfGroup2=ospfVirtIfGroup2, ospfAreaBdrRtrCount=ospfAreaBdrRtrCount, ospfAreaNssaTranslatorRole=ospfAreaNssaTranslatorRole, ospfTOSSupport=ospfTOSSupport, ospfIfType=ospfIfType, ospfVirtIfRetransInterval=ospfVirtIfRetransInterval, ospfVirtLocalLsdbChecksum=ospfVirtLocalLsdbChecksum, ospfLocalLsdbAdvertisement=ospfLocalLsdbAdvertisement, ospfStubTOS=ospfStubTOS, ospfDiscontinuityTime=ospfDiscontinuityTime, ospfHostGroup=ospfHostGroup, ospfRestartSupport=ospfRestartSupport, ospfNbrEntry=ospfNbrEntry, ospfIfDemand=ospfIfDemand, ospfVirtIfAuthKey=ospfVirtIfAuthKey, ospfVirtIfGroup=ospfVirtIfGroup, ospfLocalLsdbEntry=ospfLocalLsdbEntry, ospfVirtNbrGroup=ospfVirtNbrGroup, ospfNbrAddressLessIndex=ospfNbrAddressLessIndex, ospfVirtIfState=ospfVirtIfState, ospfAreaGroup=ospfAreaGroup, ospfIfAdminStat=ospfIfAdminStat, ospfAreaRangeNet=ospfAreaRangeNet, ospfNbrState=ospfNbrState, ospfComplianceObsolete=ospfComplianceObsolete, ospfNbrOptions=ospfNbrOptions, ospfLocalLsdbType=ospfLocalLsdbType, ospfVirtLocalLsdbAdvertisement=ospfVirtLocalLsdbAdvertisement, ospfNbrRtrId=ospfNbrRtrId, ospfLsdbType=ospfLsdbType, ospfVirtIfLsaCksumSum=ospfVirtIfLsaCksumSum, ospfIfMetricTOS=ospfIfMetricTOS, ospfVirtLocalLsdbTransitArea=ospfVirtLocalLsdbTransitArea, ospfAsLsdbAdvertisement=ospfAsLsdbAdvertisement, ospfNbrRestartHelperStatus=ospfNbrRestartHelperStatus, ospfNbrPriority=ospfNbrPriority, ospfVirtIfStatus=ospfVirtIfStatus, ospfHostTable=ospfHostTable, ospfAreaRangeEntry=ospfAreaRangeEntry, ospfAsLsdbSequence=ospfAsLsdbSequence, ospfVirtNbrGroup2=ospfVirtNbrGroup2, ospfAreaRangeAreaId=ospfAreaRangeAreaId, ospfHostGroup2=ospfHostGroup2, ospfDemandExtensions=ospfDemandExtensions, PositiveInteger=PositiveInteger, ospfVirtNbrIpAddr=ospfVirtNbrIpAddr, ospfMulticastExtensions=ospfMulticastExtensions, ospfAsLsdbLsid=ospfAsLsdbLsid, ospfLocalLsdbGroup=ospfLocalLsdbGroup, ospfAreaNssaTranslatorState=ospfAreaNssaTranslatorState, ospfAsLsdbType=ospfAsLsdbType, ospfIfHelloInterval=ospfIfHelloInterval, ospfLsdbSequence=ospfLsdbSequence, ospfVirtIfLsaCount=ospfVirtIfLsaCount, ospfIfTable=ospfIfTable, ospfAsLsaCksumSum=ospfAsLsaCksumSum, ospfAreaRangeTable=ospfAreaRangeTable, ospfIfPollInterval=ospfIfPollInterval, ospfRestartInterval=ospfRestartInterval, ospfIfLsaCksumSum=ospfIfLsaCksumSum, ospfNbrIpAddr=ospfNbrIpAddr, ospfIfAuthKey=ospfIfAuthKey, ospfAsLsaCount=ospfAsLsaCount, ospfAsLsdbEntry=ospfAsLsdbEntry, ospfReferenceBandwidth=ospfReferenceBandwidth, ospfIfMulticastForwarding=ospfIfMulticastForwarding, ospfIfState=ospfIfState, ospfVirtIfTable=ospfVirtIfTable, ospfCompliance=ospfCompliance, ospfVirtLocalLsdbType=ospfVirtLocalLsdbType, ospfIfGroup=ospfIfGroup, ospfVirtIfAreaId=ospfVirtIfAreaId, OspfAuthenticationType=OspfAuthenticationType, ospfAreaLsaCount=ospfAreaLsaCount, ospfAreaAggregateEntry=ospfAreaAggregateEntry, ospfRestartExitReason=ospfRestartExitReason, ospfExtLsdbEntry=ospfExtLsdbEntry, ospfIfTransitDelay=ospfIfTransitDelay, ospfLsdbLsid=ospfLsdbLsid, ospfVirtLocalLsdbLsid=ospfVirtLocalLsdbLsid, AreaID=AreaID, ospfExtLsdbLimit=ospfExtLsdbLimit, ospfRFC1583Compatibility=ospfRFC1583Compatibility, ospfAreaBdrRtrStatus=ospfAreaBdrRtrStatus, ospfRestartStatus=ospfRestartStatus, ospfIfRtrPriority=ospfIfRtrPriority, ospfIfEvents=ospfIfEvents, ospfAreaId=ospfAreaId, ospfAreaSummary=ospfAreaSummary, ospfAreaAggregateNet=ospfAreaAggregateNet, RouterID=RouterID, ospfAreaRangeGroup=ospfAreaRangeGroup, ospfLocalLsdbAddressLessIf=ospfLocalLsdbAddressLessIf, ospfStubAreaTable=ospfStubAreaTable, ospfLocalLsdbRouterId=ospfLocalLsdbRouterId, ospfExternalType2=ospfExternalType2, ospfAreaAggregateGroup2=ospfAreaAggregateGroup2, ospfIfMetricIpAddress=ospfIfMetricIpAddress, ospfAsLsdbAge=ospfAsLsdbAge, ospfAsLsdbChecksum=ospfAsLsdbChecksum, ospfLocalLsdbAge=ospfLocalLsdbAge, ospfAreaLsaCountLsaType=ospfAreaLsaCountLsaType, ospfLsdbAge=ospfLsdbAge, ospfNbrGroup2=ospfNbrGroup2, ospfAreaAggregateMask=ospfAreaAggregateMask, ospfExternLsaCksumSum=ospfExternLsaCksumSum, ospfIfGroup2=ospfIfGroup2, ospfIfStatus=ospfIfStatus, ospfExtLsdbLsid=ospfExtLsdbLsid, ospfAreaAggregateAreaID=ospfAreaAggregateAreaID, ospfLsdbChecksum=ospfLsdbChecksum, ospfIfMetricStatus=ospfIfMetricStatus, ospfNbrRestartHelperAge=ospfNbrRestartHelperAge, ospfAreaAggregateLsdbType=ospfAreaAggregateLsdbType, ospfVirtIfTransitDelay=ospfVirtIfTransitDelay, ospfBasicGroup=ospfBasicGroup, ospfAreaGroup2=ospfAreaGroup2, ospfAsLsdbGroup=ospfAsLsdbGroup, ospfAsLsdbRouterId=ospfAsLsdbRouterId, TOSType=TOSType, ospfAreaNssaTranslatorStabilityInterval=ospfAreaNssaTranslatorStabilityInterval, ospfRouteGroup=ospfRouteGroup, ospfStubAreaEntry=ospfStubAreaEntry, ospfAreaAggregateTable=ospfAreaAggregateTable, ospfExternalType1=ospfExternalType1, ospfLocalLsdbTable=ospfLocalLsdbTable, ospfASBdrRtrStatus=ospfASBdrRtrStatus, ospfVirtLocalLsdbEntry=ospfVirtLocalLsdbEntry, ospfVirtNbrRestartHelperAge=ospfVirtNbrRestartHelperAge, ospfVirtNbrArea=ospfVirtNbrArea, ospfNbmaNbrStatus=ospfNbmaNbrStatus, ospfLocalLsdbChecksum=ospfLocalLsdbChecksum, ospfVirtIfAuthType=ospfVirtIfAuthType, ospfAddressLessIf=ospfAddressLessIf, ospfVirtNbrEntry=ospfVirtNbrEntry, ospfIfDesignatedRouter=ospfIfDesignatedRouter, ospfNbmaNbrPermanence=ospfNbmaNbrPermanence, ospfVirtLocalLsdbTable=ospfVirtLocalLsdbTable, ospfStubRouterSupport=ospfStubRouterSupport, ospfVersionNumber=ospfVersionNumber, ospfAreaAggregateStatus=ospfAreaAggregateStatus, ospfRouterId=ospfRouterId, ospfIfEntry=ospfIfEntry, ospfAreaNssaTranslatorEvents=ospfAreaNssaTranslatorEvents, ospfExtLsdbType=ospfExtLsdbType, ospfInterArea=ospfInterArea, ospfVirtNbrRtrId=ospfVirtNbrRtrId, ospfGeneralGroup=ospfGeneralGroup, ospfIfBackupDesignatedRouterId=ospfIfBackupDesignatedRouterId, ospfVirtNbrEvents=ospfVirtNbrEvents, ospfVirtNbrState=ospfVirtNbrState, Status=Status, ospfAreaTable=ospfAreaTable, ospfRestartStrictLsaChecking=ospfRestartStrictLsaChecking, ospfHostMetric=ospfHostMetric, ospfIfMetricAddressLessIf=ospfIfMetricAddressLessIf, ospfAreaEntry=ospfAreaEntry, ospfAreaAggregateExtRouteTag=ospfAreaAggregateExtRouteTag, ospfIfMetricEntry=ospfIfMetricEntry, ospfIfMetricTable=ospfIfMetricTable, ospfAreaLsaCountGroup=ospfAreaLsaCountGroup, ospfNbrTable=ospfNbrTable, ospfExtLsdbSequence=ospfExtLsdbSequence, ospfIntraArea=ospfIntraArea, ospfLsdbRouterId=ospfLsdbRouterId, ospfLsdbEntry=ospfLsdbEntry, ospfNbrHelloSuppressed=ospfNbrHelloSuppressed, Metric=Metric, ospfAuthType=ospfAuthType, ospfAreaStatus=ospfAreaStatus, ospfLocalLsdbIpAddress=ospfLocalLsdbIpAddress, ospfExtLsdbTable=ospfExtLsdbTable, ospfAreaLsaCountEntry=ospfAreaLsaCountEntry, UpToMaxAge=UpToMaxAge, ospfExitOverflowInterval=ospfExitOverflowInterval, ospfIfMetricValue=ospfIfMetricValue, ospfNbrLsRetransQLen=ospfNbrLsRetransQLen, ospfSpfRuns=ospfSpfRuns, ospfHostEntry=ospfHostEntry, ospfBasicGroup2=ospfBasicGroup2, ospfStubAreaGroup=ospfStubAreaGroup, ospfAreaAggregateEffect=ospfAreaAggregateEffect, PYSNMP_MODULE_ID=ospf, ospfVirtNbrHelloSuppressed=ospfVirtNbrHelloSuppressed, ospfVirtLocalLsdbRouterId=ospfVirtLocalLsdbRouterId, ospfIfRtrDeadInterval=ospfIfRtrDeadInterval, DesignatedRouterPriority=DesignatedRouterPriority)
mibBuilder.exportSymbols("OSPF-MIB", ospfStubMetricType=ospfStubMetricType, ospfVirtNbrRestartHelperStatus=ospfVirtNbrRestartHelperStatus, ospfConformance=ospfConformance, ospfStubMetric=ospfStubMetric)
