#!/usr/bin/env python
#-*- coding:utf-8 -*-

from __future__ import print_function, unicode_literals, division, absolute_import

import sys
try:
    from pynlpl.formats import folia
except ImportError:
    print("PyNLPL is required to run this script, obtain it from https://github.com/proycon/pynlpl and either install it or make sure the pynlpl/ dir is symlinked from the directory this script is in.",file=sys.stderr)
    sys.exit(3)
import io

print("Generating Relax NG schema")
folia.relaxng('folia-min.rng')

#!/usr/bin/python
data = io.open("folia-min.rng",'r',encoding='utf-8').readlines()
data.insert(1,"""<!--
RelaxNG schema for FoLiA XML v%s
    by Maarten van Gompel
    Induction of Linguistic Knowledge Research group
    Tilburg University

    http://ilk.uvt.nl/folia
    http://github.com/proycon/folia

    Schema version %s
      (auto-generated by pynlpl.formats.folia)

    Validation examples:
     $ xmllint ‒‒relaxng folia.rng foliadocument.xml
     $ jing folia.rng foliadocument.xml

    However, it is recommended to use the foliavalidator tool instead,
    as it does extra validation that can not be captured by RelaxNG!

    $ foliavalidator foliadocument.xml

    Licensed under the GNU General Public License v3
-->
""" %  (folia.FOLIAVERSION, folia.LIBVERSION))
io.open('folia.rng','w',encoding='utf-8').writelines(data)


print("Validating example document")
folia.validate('../test/example.xml')
