# Copyright 2020 The ML Collections Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Lint as: python 3
"""Config file with field references."""

import ml_collections
from ml_collections.config_dict import config_dict


def get_config():
  cfg = ml_collections.ConfigDict()
  cfg.ref = ml_collections.FieldReference(123)
  cfg.ref_nodefault = config_dict.placeholder(int)
  return cfg
