# MkDocs

Project documentation with&nbsp;Markdown.

---

MkDocs is a **fast**, **simple** and **downright gorgeous** static site
generator that's geared towards building project documentation. Documentation
source files are written in Markdown, and configured with a single YAML
configuration file. Start by reading the [introductory tutorial], then check the
[User Guide] for more information.

[introductory tutorial]: getting-started.md
[User Guide]: user-guide/README.md

<div class="text-center">
<a href="getting-started/" class="btn btn-primary" role="button">Getting Started</a>
<a href="user-guide/" class="btn btn-primary" role="button">User Guide</a>
</div>

<div class="jumbotron">
<h2 class="display-4 text-center">Features</h2>

<div class="row">
  <div class="col-sm-6">
    <div class="card">
      <div class="card-body">
        <h3 class="card-title">Great themes available</h3>
        <p class="card-text">
            There's a stack of good looking <a href="user-guide/choosing-your-theme">themes</a> available for MkDocs.
            Choose between the built in themes:
            <a href="user-guide/choosing-your-theme/#mkdocs">mkdocs</a> and
            <a href="user-guide/choosing-your-theme/#readthedocs">readthedocs</a>,
            select one of the third-party themes
            (on the <a href="https://github.com/mkdocs/mkdocs/wiki/MkDocs-Themes">MkDocs Themes</a> wiki page
            as well as the <a href="https://github.com/mkdocs/catalog#-theming">MkDocs Catalog</a>),
            or <a href="dev-guide/themes/">build your own</a>.
        </p>
      </div>
    </div>
  </div>
  <div class="col-sm-6">
    <div class="card">
      <div class="card-body">
        <h3 class="card-title">Easy to customize</h3>
        <p class="card-text">
            Get your project documentation looking just the way you want it by
            <a href="user-guide/customizing-your-theme/">customizing your
            theme</a> and/or installing some <a
            href="user-guide/configuration/#plugins">plugins</a>. Modify
            Markdown's behavior with <a
            href="user-guide/configuration/#markdown_extensions">Markdown
            extensions</a>. Many <a
            href="user-guide/configuration/">configuration options</a> are
            available.
        </p>
      </div>
    </div>
  </div>
</div>

<div class="row">
  <div class="col-sm-6">
    <div class="card">
      <div class="card-body">
        <h3 class="card-title">Preview your site as you work</h3>
        <p class="card-text">
            The built-in dev-server allows you to preview your documentation
            as you're writing it. It will even auto-reload and refresh your
            browser whenever you save your changes.
        </p>
      </div>
    </div>
  </div>
  <div class="col-sm-6">
    <div class="card">
      <div class="card-body">
        <h3 class="card-title">Host anywhere</h3>
        <p class="card-text">
            MkDocs builds completely static HTML sites that you can host on
            GitHub Pages, Amazon S3, or <a
            href="user-guide/deploying-your-docs/">anywhere</a> else you
            choose.
        </p>
      </div>
    </div>
  </div>
</div>
</div>
