# About GeoPandas

```{toctree}
:maxdepth: 2
:caption: About
:hidden:

Team <about/team>
Citing <about/citing>
Logo <about/logo>
```


GeoPandas is an open source project to add support for geographic data to pandas objects. It
currently implements `GeoSeries` and `GeoDataFrame` types which are subclasses of
`pandas.Series` and `pandas.DataFrame` respectively. GeoPandas objects can act on
`shapely` geometry objects and perform geometric operations.

GeoPandas is a community-led project written, used and supported by a wide range of
people from all around of world of a large variety of backgrounds. Want to get involved
in the community? See our [community guidelines](community).

GeoPandas will always be 100% open source software, free for all to use and released
under the liberal terms of the BSD-3-Clause license.

```{container} button

{doc}`Team <about/team>`
{doc}`Citing <about/citing>` {doc}`Logo <about/logo>`
```

## Project history

Kelsey Jordahl founded GeoPandas project in 2013 during the Scipy Conference and
released a version 0.1.0 in July 2014. In 2016, Joris Van den Bossche took the lead and
became the maintainer of the project. Since the beginning, GeoPandas is a BSD-licensed
open-source project supported by a [community of
contributors](https://github.com/geopandas/geopandas/graphs/contributors) from around
the world and is now maintained by a [team](about/team) of core developers.

In 2020 GeoPandas became [NumFOCUS Affiliated
Project](https://numfocus.org/sponsored-projects/affiliated-projects) and received two
[Small Development Grants](https://numfocus.org/programs/sustainability) to support its
development.

## Timeline

- **2013**: Beginning of the development
- **2014**: GeoPandas 0.1.0 released
- **2020**: GeoPandas became [NumFOCUS Affiliated
  Project](https://numfocus.org/sponsored-projects/affiliated-projects)


