# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class AssociationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Association Type Enum."""

    SUBNETS = "subnets"
    """Association of Type Subnet"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class PolicyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Policy Type of the Security Policy."""

    WAF = "waf"
    """Policy of Type WAF"""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource Provisioning State Enum."""

    PROVISIONING = "Provisioning"
    """Resource in Provisioning State"""
    UPDATING = "Updating"
    """Resource in Updating State"""
    DELETING = "Deleting"
    """Resource in Deleting State"""
    ACCEPTED = "Accepted"
    """Resource in Accepted State"""
    SUCCEEDED = "Succeeded"
    """Resource in Succeeded State"""
    FAILED = "Failed"
    """Resource in Failed State"""
    CANCELED = "Canceled"
    """Resource in Canceled State"""
