# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.kusto import KustoManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestKustoManagementClustersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(KustoManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_get(self, resource_group):
        response = self.client.clusters.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-04-13",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_create_or_update(self, resource_group):
        response = self.client.clusters.begin_create_or_update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            parameters={
                "location": "str",
                "sku": {"name": "str", "tier": "str", "capacity": 0},
                "acceptedAudiences": [{"value": "str"}],
                "allowedFqdnList": ["str"],
                "allowedIpRangeList": ["str"],
                "calloutPolicies": [
                    {"calloutId": "str", "calloutType": "str", "calloutUriRegex": "str", "outboundAccess": "str"}
                ],
                "dataIngestionUri": "str",
                "enableAutoStop": True,
                "enableDiskEncryption": False,
                "enableDoubleEncryption": False,
                "enablePurge": False,
                "enableStreamingIngest": False,
                "engineType": "V3",
                "etag": "str",
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "keyVaultProperties": {
                    "keyName": "str",
                    "keyVaultUri": "str",
                    "keyVersion": "str",
                    "userIdentity": "str",
                },
                "languageExtensions": {
                    "value": [
                        {
                            "languageExtensionCustomImageName": "str",
                            "languageExtensionImageName": "str",
                            "languageExtensionName": "str",
                        }
                    ]
                },
                "migrationCluster": {"dataIngestionUri": "str", "id": "str", "role": "str", "uri": "str"},
                "name": "str",
                "optimizedAutoscale": {"isEnabled": bool, "maximum": 0, "minimum": 0, "version": 0},
                "privateEndpointConnections": [
                    {
                        "groupId": "str",
                        "id": "str",
                        "name": "str",
                        "privateEndpoint": {"id": "str"},
                        "privateLinkServiceConnectionState": {
                            "actionsRequired": "str",
                            "description": "str",
                            "status": "str",
                        },
                        "provisioningState": "str",
                        "systemData": {
                            "createdAt": "2020-02-20 00:00:00",
                            "createdBy": "str",
                            "createdByType": "str",
                            "lastModifiedAt": "2020-02-20 00:00:00",
                            "lastModifiedBy": "str",
                            "lastModifiedByType": "str",
                        },
                        "type": "str",
                    }
                ],
                "provisioningState": "str",
                "publicIPType": "IPv4",
                "publicNetworkAccess": "Enabled",
                "restrictOutboundNetworkAccess": "Disabled",
                "state": "str",
                "stateReason": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "trustedExternalTenants": [{"value": "str"}],
                "type": "str",
                "uri": "str",
                "virtualClusterGraduationProperties": "str",
                "virtualNetworkConfiguration": {
                    "dataManagementPublicIpId": "str",
                    "enginePublicIpId": "str",
                    "subnetId": "str",
                    "state": "Enabled",
                },
                "zoneStatus": "str",
                "zones": ["str"],
            },
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_update(self, resource_group):
        response = self.client.clusters.begin_update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            parameters={
                "acceptedAudiences": [{"value": "str"}],
                "allowedFqdnList": ["str"],
                "allowedIpRangeList": ["str"],
                "calloutPolicies": [
                    {"calloutId": "str", "calloutType": "str", "calloutUriRegex": "str", "outboundAccess": "str"}
                ],
                "dataIngestionUri": "str",
                "enableAutoStop": True,
                "enableDiskEncryption": False,
                "enableDoubleEncryption": False,
                "enablePurge": False,
                "enableStreamingIngest": False,
                "engineType": "V3",
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "keyVaultProperties": {
                    "keyName": "str",
                    "keyVaultUri": "str",
                    "keyVersion": "str",
                    "userIdentity": "str",
                },
                "languageExtensions": {
                    "value": [
                        {
                            "languageExtensionCustomImageName": "str",
                            "languageExtensionImageName": "str",
                            "languageExtensionName": "str",
                        }
                    ]
                },
                "location": "str",
                "migrationCluster": {"dataIngestionUri": "str", "id": "str", "role": "str", "uri": "str"},
                "name": "str",
                "optimizedAutoscale": {"isEnabled": bool, "maximum": 0, "minimum": 0, "version": 0},
                "privateEndpointConnections": [
                    {
                        "groupId": "str",
                        "id": "str",
                        "name": "str",
                        "privateEndpoint": {"id": "str"},
                        "privateLinkServiceConnectionState": {
                            "actionsRequired": "str",
                            "description": "str",
                            "status": "str",
                        },
                        "provisioningState": "str",
                        "systemData": {
                            "createdAt": "2020-02-20 00:00:00",
                            "createdBy": "str",
                            "createdByType": "str",
                            "lastModifiedAt": "2020-02-20 00:00:00",
                            "lastModifiedBy": "str",
                            "lastModifiedByType": "str",
                        },
                        "type": "str",
                    }
                ],
                "provisioningState": "str",
                "publicIPType": "IPv4",
                "publicNetworkAccess": "Enabled",
                "restrictOutboundNetworkAccess": "Disabled",
                "sku": {"name": "str", "tier": "str", "capacity": 0},
                "state": "str",
                "stateReason": "str",
                "tags": {"str": "str"},
                "trustedExternalTenants": [{"value": "str"}],
                "type": "str",
                "uri": "str",
                "virtualClusterGraduationProperties": "str",
                "virtualNetworkConfiguration": {
                    "dataManagementPublicIpId": "str",
                    "enginePublicIpId": "str",
                    "subnetId": "str",
                    "state": "Enabled",
                },
                "zoneStatus": "str",
                "zones": ["str"],
            },
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_delete(self, resource_group):
        response = self.client.clusters.begin_delete(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_stop(self, resource_group):
        response = self.client.clusters.begin_stop(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_start(self, resource_group):
        response = self.client.clusters.begin_start(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_migrate(self, resource_group):
        response = self.client.clusters.begin_migrate(
            resource_group_name=resource_group.name,
            cluster_name="str",
            cluster_migrate_request={"clusterResourceId": "str"},
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_list_follower_databases_get(self, resource_group):
        response = self.client.clusters.list_follower_databases_get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-04-13",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_list_follower_databases(self, resource_group):
        response = self.client.clusters.list_follower_databases(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-04-13",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_detach_follower_databases(self, resource_group):
        response = self.client.clusters.begin_detach_follower_databases(
            resource_group_name=resource_group.name,
            cluster_name="str",
            follower_database_to_remove={
                "attachedDatabaseConfigurationName": "str",
                "clusterResourceId": "str",
                "databaseName": "str",
                "databaseShareOrigin": "str",
                "tableLevelSharingProperties": {
                    "externalTablesToExclude": ["str"],
                    "externalTablesToInclude": ["str"],
                    "functionsToExclude": ["str"],
                    "functionsToInclude": ["str"],
                    "materializedViewsToExclude": ["str"],
                    "materializedViewsToInclude": ["str"],
                    "tablesToExclude": ["str"],
                    "tablesToInclude": ["str"],
                },
            },
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_diagnose_virtual_network(self, resource_group):
        response = self.client.clusters.begin_diagnose_virtual_network(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_list_by_resource_group(self, resource_group):
        response = self.client.clusters.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-04-13",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_list(self, resource_group):
        response = self.client.clusters.list(
            api_version="2024-04-13",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_list_skus(self, resource_group):
        response = self.client.clusters.list_skus(
            api_version="2024-04-13",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_check_name_availability(self, resource_group):
        response = self.client.clusters.check_name_availability(
            location="str",
            cluster_name={"name": "str", "type": "Microsoft.Kusto/clusters"},
            api_version="2024-04-13",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_list_skus_by_resource(self, resource_group):
        response = self.client.clusters.list_skus_by_resource(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-04-13",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_list_outbound_network_dependencies_endpoints(self, resource_group):
        response = self.client.clusters.list_outbound_network_dependencies_endpoints(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-04-13",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_add_callout_policies(self, resource_group):
        response = self.client.clusters.begin_add_callout_policies(
            resource_group_name=resource_group.name,
            cluster_name="str",
            callout_policies={
                "nextLink": "str",
                "value": [
                    {"calloutId": "str", "calloutType": "str", "calloutUriRegex": "str", "outboundAccess": "str"}
                ],
            },
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_remove_callout_policy(self, resource_group):
        response = self.client.clusters.begin_remove_callout_policy(
            resource_group_name=resource_group.name,
            cluster_name="str",
            callout_policy={"calloutId": "str"},
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_list_callout_policies(self, resource_group):
        response = self.client.clusters.list_callout_policies(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-04-13",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_list_language_extensions(self, resource_group):
        response = self.client.clusters.list_language_extensions(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-04-13",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_add_language_extensions(self, resource_group):
        response = self.client.clusters.begin_add_language_extensions(
            resource_group_name=resource_group.name,
            cluster_name="str",
            language_extensions_to_add={
                "value": [
                    {
                        "languageExtensionCustomImageName": "str",
                        "languageExtensionImageName": "str",
                        "languageExtensionName": "str",
                    }
                ]
            },
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_remove_language_extensions(self, resource_group):
        response = self.client.clusters.begin_remove_language_extensions(
            resource_group_name=resource_group.name,
            cluster_name="str",
            language_extensions_to_remove={
                "value": [
                    {
                        "languageExtensionCustomImageName": "str",
                        "languageExtensionImageName": "str",
                        "languageExtensionName": "str",
                    }
                ]
            },
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
