# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .directory_object_py3 import DirectoryObject


class ADGroup(DirectoryObject):
    """Active Directory group information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :ivar object_id: The object ID.
    :vartype object_id: str
    :ivar deletion_timestamp: The time at which the directory object was
     deleted.
    :vartype deletion_timestamp: datetime
    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param display_name: The display name of the group.
    :type display_name: str
    :param mail_enabled: Whether the group is mail-enabled. Must be false.
     This is because only pure security groups can be created using the Graph
     API.
    :type mail_enabled: bool
    :param mail_nickname: The mail alias for the group.
    :type mail_nickname: str
    :param security_enabled: Whether the group is security-enable.
    :type security_enabled: bool
    :param mail: The primary email address of the group.
    :type mail: str
    """

    _validation = {
        'object_id': {'readonly': True},
        'deletion_timestamp': {'readonly': True},
        'object_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'deletion_timestamp': {'key': 'deletionTimestamp', 'type': 'iso-8601'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'mail_enabled': {'key': 'mailEnabled', 'type': 'bool'},
        'mail_nickname': {'key': 'mailNickname', 'type': 'str'},
        'security_enabled': {'key': 'securityEnabled', 'type': 'bool'},
        'mail': {'key': 'mail', 'type': 'str'},
    }

    def __init__(self, *, additional_properties=None, display_name: str=None, mail_enabled: bool=None, mail_nickname: str=None, security_enabled: bool=None, mail: str=None, **kwargs) -> None:
        super(ADGroup, self).__init__(additional_properties=additional_properties, **kwargs)
        self.display_name = display_name
        self.mail_enabled = mail_enabled
        self.mail_nickname = mail_nickname
        self.security_enabled = security_enabled
        self.mail = mail
        self.object_type = 'Group'
