# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.fabric import FabricMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestFabricMgmtFabricCapacitiesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(FabricMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fabric_capacities_get(self, resource_group):
        response = self.client.fabric_capacities.get(
            resource_group_name=resource_group.name,
            capacity_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fabric_capacities_begin_create_or_update(self, resource_group):
        response = self.client.fabric_capacities.begin_create_or_update(
            resource_group_name=resource_group.name,
            capacity_name="str",
            resource={
                "location": "str",
                "properties": {"administration": {"members": ["str"]}, "provisioningState": "str", "state": "str"},
                "sku": {"name": "str", "tier": "str"},
                "id": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fabric_capacities_begin_update(self, resource_group):
        response = self.client.fabric_capacities.begin_update(
            resource_group_name=resource_group.name,
            capacity_name="str",
            properties={
                "properties": {"administration": {"members": ["str"]}},
                "sku": {"name": "str", "tier": "str"},
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fabric_capacities_begin_delete(self, resource_group):
        response = self.client.fabric_capacities.begin_delete(
            resource_group_name=resource_group.name,
            capacity_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fabric_capacities_list_by_resource_group(self, resource_group):
        response = self.client.fabric_capacities.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fabric_capacities_list_by_subscription(self, resource_group):
        response = self.client.fabric_capacities.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fabric_capacities_begin_resume(self, resource_group):
        response = self.client.fabric_capacities.begin_resume(
            resource_group_name=resource_group.name,
            capacity_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fabric_capacities_begin_suspend(self, resource_group):
        response = self.client.fabric_capacities.begin_suspend(
            resource_group_name=resource_group.name,
            capacity_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fabric_capacities_check_name_availability(self, resource_group):
        response = self.client.fabric_capacities.check_name_availability(
            location="str",
            body={"name": "str", "type": "str"},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fabric_capacities_list_skus_for_capacity(self, resource_group):
        response = self.client.fabric_capacities.list_skus_for_capacity(
            resource_group_name=resource_group.name,
            capacity_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fabric_capacities_list_skus(self, resource_group):
        response = self.client.fabric_capacities.list_skus()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
