# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, List, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ..._operations._operations import (
    build_confidential_ledger_create_ledger_entry_request,
    build_confidential_ledger_create_or_update_ledger_user_request,
    build_confidential_ledger_create_or_update_user_request,
    build_confidential_ledger_create_user_defined_endpoint_request,
    build_confidential_ledger_create_user_defined_role_request,
    build_confidential_ledger_delete_ledger_user_request,
    build_confidential_ledger_delete_user_defined_role_request,
    build_confidential_ledger_delete_user_request,
    build_confidential_ledger_get_constitution_request,
    build_confidential_ledger_get_current_ledger_entry_request,
    build_confidential_ledger_get_enclave_quotes_request,
    build_confidential_ledger_get_ledger_entry_request,
    build_confidential_ledger_get_ledger_user_request,
    build_confidential_ledger_get_receipt_request,
    build_confidential_ledger_get_runtime_options_request,
    build_confidential_ledger_get_transaction_status_request,
    build_confidential_ledger_get_user_defined_endpoint_request,
    build_confidential_ledger_get_user_defined_endpoints_module_request,
    build_confidential_ledger_get_user_defined_role_request,
    build_confidential_ledger_get_user_request,
    build_confidential_ledger_list_collections_request,
    build_confidential_ledger_list_consortium_members_request,
    build_confidential_ledger_list_ledger_entries_request,
    build_confidential_ledger_list_ledger_users_request,
    build_confidential_ledger_list_users_request,
    build_confidential_ledger_update_runtime_options_request,
    build_confidential_ledger_update_user_defined_role_request,
)
from .._vendor import ConfidentialLedgerClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ConfidentialLedgerClientOperationsMixin(  # pylint: disable=too-many-public-methods
    ConfidentialLedgerClientMixinABC
):

    @distributed_trace_async
    async def get_constitution(self, **kwargs: Any) -> JSON:
        """Gets the constitution used for governance.

        The constitution is a script that assesses and applies proposals from consortium members.

        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "digest": "str",
                    "script": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_constitution_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def list_consortium_members(self, **kwargs: Any) -> AsyncIterable[JSON]:
        """Lists the consortium members.

        Consortium members can manage the Confidential Ledger.

        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "certificate": "str",
                    "id": "str"
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_confidential_ledger_list_consortium_members_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["members"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_enclave_quotes(self, **kwargs: Any) -> JSON:
        """Gets quotes for all nodes of the Confidential Ledger.

        A quote is an SGX enclave measurement that can be used to verify the validity of a node and its
        enclave.

        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "currentNodeId": "str",
                    "enclaveQuotes": {
                        "str": {
                            "nodeId": "str",
                            "quoteVersion": "str",
                            "raw": "str",
                            "mrenclave": "str"
                        }
                    }
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_enclave_quotes_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def list_collections(self, **kwargs: Any) -> AsyncIterable[JSON]:
        """Retrieves a list of collection ids present in the Confidential Ledger.

        Collection ids are user-created collections of ledger entries.

        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "collectionId": "str"
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_confidential_ledger_list_collections_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["collections"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_ledger_entries(
        self,
        *,
        collection_id: Optional[str] = None,
        from_transaction_id: Optional[str] = None,
        to_transaction_id: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Gets ledger entries from a collection corresponding to a range.

        A collection id may optionally be specified. Only entries in the specified (or default)
        collection will be returned.

        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :keyword from_transaction_id: Specify the first transaction ID in a range. Default value is
         None.
        :paramtype from_transaction_id: str
        :keyword to_transaction_id: Specify the last transaction ID in a range. Default value is None.
        :paramtype to_transaction_id: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "contents": "str",
                    "collectionId": "str",
                    "transactionId": "str"
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_confidential_ledger_list_ledger_entries_request(
                    collection_id=collection_id,
                    from_transaction_id=from_transaction_id,
                    to_transaction_id=to_transaction_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["entries"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def create_ledger_entry(
        self, entry: JSON, *, collection_id: Optional[str] = None, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Writes a ledger entry.

        A collection id may optionally be specified.

        :param entry: Ledger entry. Required.
        :type entry: JSON
        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                entry = {
                    "contents": "str",
                    "collectionId": "str",
                    "transactionId": "str"
                }

                # response body for status code(s): 200
                response == {
                    "collectionId": "str"
                }
        """

    @overload
    async def create_ledger_entry(
        self,
        entry: IO[bytes],
        *,
        collection_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Writes a ledger entry.

        A collection id may optionally be specified.

        :param entry: Ledger entry. Required.
        :type entry: IO[bytes]
        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "collectionId": "str"
                }
        """

    @distributed_trace_async
    async def create_ledger_entry(
        self, entry: Union[JSON, IO[bytes]], *, collection_id: Optional[str] = None, **kwargs: Any
    ) -> JSON:
        """Writes a ledger entry.

        A collection id may optionally be specified.

        :param entry: Ledger entry. Is either a JSON type or a IO[bytes] type. Required.
        :type entry: JSON or IO[bytes]
        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                entry = {
                    "contents": "str",
                    "collectionId": "str",
                    "transactionId": "str"
                }

                # response body for status code(s): 200
                response == {
                    "collectionId": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(entry, (IOBase, bytes)):
            _content = entry
        else:
            _json = entry

        _request = build_confidential_ledger_create_ledger_entry_request(
            collection_id=collection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["x-ms-ccf-transaction-id"] = self._deserialize(
            "str", response.headers.get("x-ms-ccf-transaction-id")
        )

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_ledger_entry(
        self, transaction_id: str, *, collection_id: Optional[str] = None, **kwargs: Any
    ) -> JSON:
        """Gets the ledger entry at the specified transaction id. A collection id may optionally be
        specified to indicate the collection from which to fetch the value.

        To return older ledger entries, the relevant sections of the ledger must be read from disk and
        validated. To prevent blocking within the enclave, the response will indicate whether the entry
        is ready and part of the response, or if the loading is still ongoing.

        :param transaction_id: Identifies a write transaction. Required.
        :type transaction_id: str
        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "state": "str",
                    "entry": {
                        "contents": "str",
                        "collectionId": "str",
                        "transactionId": "str"
                    }
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_ledger_entry_request(
            transaction_id=transaction_id,
            collection_id=collection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_receipt(self, transaction_id: str, **kwargs: Any) -> JSON:
        """Gets a receipt certifying ledger contents at a particular transaction id.

        Gets a receipt certifying ledger contents at a particular transaction id.

        :param transaction_id: Identifies a write transaction. Required.
        :type transaction_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "state": "str",
                    "transactionId": "str",
                    "applicationClaims": [
                        {
                            "kind": "str",
                            "digest": {
                                "protocol": "str",
                                "value": "str"
                            },
                            "ledgerEntry": {
                                "protocol": "str",
                                "collectionId": "str",
                                "contents": "str",
                                "secretKey": "str"
                            }
                        }
                    ],
                    "receipt": {
                        "nodeId": "str",
                        "proof": [
                            {
                                "left": "str",
                                "right": "str"
                            }
                        ],
                        "signature": "str",
                        "cert": "str",
                        "leaf": "str",
                        "leafComponents": {
                            "claimsDigest": "str",
                            "commitEvidence": "str",
                            "writeSetDigest": "str"
                        },
                        "root": "str",
                        "serviceEndorsements": [
                            "str"
                        ]
                    }
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_receipt_request(
            transaction_id=transaction_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_transaction_status(self, transaction_id: str, **kwargs: Any) -> JSON:
        """Gets the status of an entry identified by a transaction id.

        Gets the status of an entry identified by a transaction id.

        :param transaction_id: Identifies a write transaction. Required.
        :type transaction_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "state": "str",
                    "transactionId": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_transaction_status_request(
            transaction_id=transaction_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_current_ledger_entry(self, *, collection_id: Optional[str] = None, **kwargs: Any) -> JSON:
        """Gets the current value available in the ledger.

        A collection id may optionally be specified.

        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "contents": "str",
                    "collectionId": "str",
                    "transactionId": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_current_ledger_entry_request(
            collection_id=collection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def list_users(self, **kwargs: Any) -> AsyncIterable[JSON]:
        """Gets details on a list of users.

        All users' object IDs and single role per user will be returned.

        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assignedRole": "str",
                    "userId": "str"
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_confidential_ledger_list_users_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["ledgerUsers"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_ledger_users(self, **kwargs: Any) -> AsyncIterable[JSON]:
        """Gets details on a list of users.

        All users' object IDs and multiple roles will be returned.

        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assignedRoles": [
                        "str"
                    ],
                    "userId": "str"
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_confidential_ledger_list_ledger_users_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["ledgerUsers"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def delete_user(self, user_id: str, **kwargs: Any) -> None:
        """Deletes a user from the Confidential Ledger.

        Deletes a user from the Confidential Ledger.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_delete_user_request(
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_user(self, user_id: str, **kwargs: Any) -> JSON:
        """Gets a user.

        Gets a user.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assignedRole": "str",
                    "userId": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_user_request(
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def create_or_update_user(
        self, user_id: str, user_details: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_details: Details about a Confidential Ledger user. Required.
        :type user_details: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                user_details = {
                    "assignedRole": "str",
                    "userId": "str"
                }

                # response body for status code(s): 200
                response == {
                    "assignedRole": "str",
                    "userId": "str"
                }
        """

    @overload
    async def create_or_update_user(
        self,
        user_id: str,
        user_details: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_details: Details about a Confidential Ledger user. Required.
        :type user_details: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assignedRole": "str",
                    "userId": "str"
                }
        """

    @distributed_trace_async
    async def create_or_update_user(self, user_id: str, user_details: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_details: Details about a Confidential Ledger user. Is either a JSON type or a
         IO[bytes] type. Required.
        :type user_details: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                user_details = {
                    "assignedRole": "str",
                    "userId": "str"
                }

                # response body for status code(s): 200
                response == {
                    "assignedRole": "str",
                    "userId": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(user_details, (IOBase, bytes)):
            _content = user_details
        else:
            _json = user_details

        _request = build_confidential_ledger_create_or_update_user_request(
            user_id=user_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def delete_ledger_user(self, user_id: str, **kwargs: Any) -> None:
        """Deletes a user with multiple roles from the Confidential Ledger.

        Deletes a user with multiple roles from the Confidential Ledger.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_delete_ledger_user_request(
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_ledger_user(self, user_id: str, **kwargs: Any) -> JSON:
        """Gets a user with multiple roles.

        Gets a user with multiple roles.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assignedRoles": [
                        "str"
                    ],
                    "userId": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_ledger_user_request(
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def create_or_update_ledger_user(
        self,
        user_id: str,
        user_multiple_roles: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_multiple_roles: Details about a Confidential Ledger user with multiple roles.
         Required.
        :type user_multiple_roles: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                user_multiple_roles = {
                    "assignedRoles": [
                        "str"
                    ],
                    "userId": "str"
                }

                # response body for status code(s): 200
                response == {
                    "assignedRoles": [
                        "str"
                    ],
                    "userId": "str"
                }
        """

    @overload
    async def create_or_update_ledger_user(
        self,
        user_id: str,
        user_multiple_roles: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_multiple_roles: Details about a Confidential Ledger user with multiple roles.
         Required.
        :type user_multiple_roles: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assignedRoles": [
                        "str"
                    ],
                    "userId": "str"
                }
        """

    @distributed_trace_async
    async def create_or_update_ledger_user(
        self, user_id: str, user_multiple_roles: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> JSON:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_multiple_roles: Details about a Confidential Ledger user with multiple roles. Is
         either a JSON type or a IO[bytes] type. Required.
        :type user_multiple_roles: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                user_multiple_roles = {
                    "assignedRoles": [
                        "str"
                    ],
                    "userId": "str"
                }

                # response body for status code(s): 200
                response == {
                    "assignedRoles": [
                        "str"
                    ],
                    "userId": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(user_multiple_roles, (IOBase, bytes)):
            _content = user_multiple_roles
        else:
            _json = user_multiple_roles

        _request = build_confidential_ledger_create_or_update_ledger_user_request(
            user_id=user_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_user_defined_endpoint(self, **kwargs: Any) -> JSON:
        """Gets a user defined endpoint.

        Returns the user defined endpoint in the ACL instance.

        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "metadata": {
                        "endpoints": {
                            "str": {
                                "delete": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "get": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "patch": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "put": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                }
                            }
                        }
                    },
                    "modules": {}
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_user_defined_endpoint_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def create_user_defined_endpoint(
        self, bundle: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Creates a user defined endpoint.

        Creates the user defined endpoint in the ACL instance.

        :param bundle: bundle parameter description. Required.
        :type bundle: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                bundle = {
                    "metadata": {
                        "endpoints": {
                            "str": {
                                "delete": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "get": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "patch": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "put": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                }
                            }
                        }
                    },
                    "modules": {}
                }
        """

    @overload
    async def create_user_defined_endpoint(
        self, bundle: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Creates a user defined endpoint.

        Creates the user defined endpoint in the ACL instance.

        :param bundle: bundle parameter description. Required.
        :type bundle: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_user_defined_endpoint(self, bundle: Union[JSON, IO[bytes]], **kwargs: Any) -> None:
        """Creates a user defined endpoint.

        Creates the user defined endpoint in the ACL instance.

        :param bundle: bundle parameter description. Is either a JSON type or a IO[bytes] type.
         Required.
        :type bundle: JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                bundle = {
                    "metadata": {
                        "endpoints": {
                            "str": {
                                "delete": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "get": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "patch": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "put": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                }
                            }
                        }
                    },
                    "modules": {}
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(bundle, (IOBase, bytes)):
            _content = bundle
        else:
            _json = bundle

        _request = build_confidential_ledger_create_user_defined_endpoint_request(
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_runtime_options(self, **kwargs: Any) -> JSON:
        """Runtime options for user defined endpoints.

        It returns the runtime options.

        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "log_exception_details": bool,
                    "max_cached_interpreters": 0,
                    "max_execution_time_ms": 0,
                    "max_heap_bytes": 0,
                    "max_stack_bytes": 0,
                    "return_exception_details": bool
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_runtime_options_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def update_runtime_options(
        self, js_runtime_options: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Runtime options for user defined endpoints.

        Updates the runtime options.

        :param js_runtime_options: JS runtime options. Required.
        :type js_runtime_options: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                js_runtime_options = {
                    "log_exception_details": bool,
                    "max_cached_interpreters": 0,
                    "max_execution_time_ms": 0,
                    "max_heap_bytes": 0,
                    "max_stack_bytes": 0,
                    "return_exception_details": bool
                }

                # response body for status code(s): 200
                response == {
                    "log_exception_details": bool,
                    "max_cached_interpreters": 0,
                    "max_execution_time_ms": 0,
                    "max_heap_bytes": 0,
                    "max_stack_bytes": 0,
                    "return_exception_details": bool
                }
        """

    @overload
    async def update_runtime_options(
        self, js_runtime_options: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Runtime options for user defined endpoints.

        Updates the runtime options.

        :param js_runtime_options: JS runtime options. Required.
        :type js_runtime_options: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "log_exception_details": bool,
                    "max_cached_interpreters": 0,
                    "max_execution_time_ms": 0,
                    "max_heap_bytes": 0,
                    "max_stack_bytes": 0,
                    "return_exception_details": bool
                }
        """

    @distributed_trace_async
    async def update_runtime_options(self, js_runtime_options: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Runtime options for user defined endpoints.

        Updates the runtime options.

        :param js_runtime_options: JS runtime options. Is either a JSON type or a IO[bytes] type.
         Required.
        :type js_runtime_options: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                js_runtime_options = {
                    "log_exception_details": bool,
                    "max_cached_interpreters": 0,
                    "max_execution_time_ms": 0,
                    "max_heap_bytes": 0,
                    "max_stack_bytes": 0,
                    "return_exception_details": bool
                }

                # response body for status code(s): 200
                response == {
                    "log_exception_details": bool,
                    "max_cached_interpreters": 0,
                    "max_execution_time_ms": 0,
                    "max_heap_bytes": 0,
                    "max_stack_bytes": 0,
                    "return_exception_details": bool
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(js_runtime_options, (IOBase, bytes)):
            _content = js_runtime_options
        else:
            _json = js_runtime_options

        _request = build_confidential_ledger_update_runtime_options_request(
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_user_defined_endpoints_module(self, *, module: str, **kwargs: Any) -> JSON:
        """Module for user defined endpoints.

        It gets the module for the user defined endpoint.

        :keyword module: module name of the user defined endpoint. Required.
        :paramtype module: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "module": "str",
                    "name": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_user_defined_endpoints_module_request(
            module=module,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_user_defined_role(self, *, role_name: str, **kwargs: Any) -> List[JSON]:
        """Gets role actions for user defined roles.

        user defined roles allow users to define and manage app specific AuthZ policy.

        :keyword role_name: user defined role name. Required.
        :paramtype role_name: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "roleActions": [
                            "str"
                        ],
                        "roleName": "str"
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_user_defined_role_request(
            role_name=role_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @overload
    async def create_user_defined_role(
        self, roles: List[JSON], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Creates new roles and their actions.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param roles: user defined role. Required.
        :type roles: list[JSON]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                roles = [
                    {
                        "roleActions": [
                            "str"
                        ],
                        "roleName": "str"
                    }
                ]
        """

    @overload
    async def create_user_defined_role(
        self, roles: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Creates new roles and their actions.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param roles: user defined role. Required.
        :type roles: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_user_defined_role(self, roles: Union[List[JSON], IO[bytes]], **kwargs: Any) -> None:
        """Creates new roles and their actions.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param roles: user defined role. Is either a [JSON] type or a IO[bytes] type. Required.
        :type roles: list[JSON] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(roles, (IOBase, bytes)):
            _content = roles
        else:
            _json = roles

        _request = build_confidential_ledger_create_user_defined_role_request(
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def update_user_defined_role(
        self, roles: List[JSON], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Patch replaces the allowed action on existing roles,if the desire is to remove an existing
        action, the role must be deleted and recreated.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param roles: user defined role. Required.
        :type roles: list[JSON]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                roles = [
                    {
                        "roleActions": [
                            "str"
                        ],
                        "roleName": "str"
                    }
                ]
        """

    @overload
    async def update_user_defined_role(
        self, roles: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Patch replaces the allowed action on existing roles,if the desire is to remove an existing
        action, the role must be deleted and recreated.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param roles: user defined role. Required.
        :type roles: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_user_defined_role(self, roles: Union[List[JSON], IO[bytes]], **kwargs: Any) -> None:
        """Patch replaces the allowed action on existing roles,if the desire is to remove an existing
        action, the role must be deleted and recreated.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param roles: user defined role. Is either a [JSON] type or a IO[bytes] type. Required.
        :type roles: list[JSON] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(roles, (IOBase, bytes)):
            _content = roles
        else:
            _json = roles

        _request = build_confidential_ledger_update_user_defined_role_request(
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def delete_user_defined_role(self, *, role_name: str, **kwargs: Any) -> None:
        """Deletes user defined roles.

        A user defined role allows the users to create and manage their own role actions using the API.

        :keyword role_name: user defined role name. Required.
        :paramtype role_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_delete_user_defined_role_request(
            role_name=role_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
