# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class ActiveDirectoryConnectorDNSDetails(_serialization.Model):
    """DNS server details.

    All required parameters must be populated in order to send to Azure.

    :ivar domain_name: DNS domain name for which DNS lookups should be forwarded to the Active
     Directory DNS servers.
    :vartype domain_name: str
    :ivar nameserver_ip_addresses: List of Active Directory DNS server IP addresses. Required.
    :vartype nameserver_ip_addresses: list[str]
    :ivar replicas: Replica count for DNS proxy service. Default value is 1.
    :vartype replicas: int
    :ivar prefer_k8_s_dns_for_ptr_lookups: Flag indicating whether to prefer Kubernetes DNS server
     response over AD DNS server response for IP address lookups.
    :vartype prefer_k8_s_dns_for_ptr_lookups: bool
    """

    _validation = {
        "nameserver_ip_addresses": {"required": True},
    }

    _attribute_map = {
        "domain_name": {"key": "domainName", "type": "str"},
        "nameserver_ip_addresses": {"key": "nameserverIPAddresses", "type": "[str]"},
        "replicas": {"key": "replicas", "type": "int"},
        "prefer_k8_s_dns_for_ptr_lookups": {"key": "preferK8sDnsForPtrLookups", "type": "bool"},
    }

    def __init__(
        self,
        *,
        nameserver_ip_addresses: List[str],
        domain_name: Optional[str] = None,
        replicas: int = 1,
        prefer_k8_s_dns_for_ptr_lookups: bool = True,
        **kwargs
    ):
        """
        :keyword domain_name: DNS domain name for which DNS lookups should be forwarded to the Active
         Directory DNS servers.
        :paramtype domain_name: str
        :keyword nameserver_ip_addresses: List of Active Directory DNS server IP addresses. Required.
        :paramtype nameserver_ip_addresses: list[str]
        :keyword replicas: Replica count for DNS proxy service. Default value is 1.
        :paramtype replicas: int
        :keyword prefer_k8_s_dns_for_ptr_lookups: Flag indicating whether to prefer Kubernetes DNS
         server response over AD DNS server response for IP address lookups.
        :paramtype prefer_k8_s_dns_for_ptr_lookups: bool
        """
        super().__init__(**kwargs)
        self.domain_name = domain_name
        self.nameserver_ip_addresses = nameserver_ip_addresses
        self.replicas = replicas
        self.prefer_k8_s_dns_for_ptr_lookups = prefer_k8_s_dns_for_ptr_lookups


class ActiveDirectoryConnectorDomainDetails(_serialization.Model):
    """Active Directory domain details.

    All required parameters must be populated in order to send to Azure.

    :ivar realm: Name (uppercase) of the Active Directory domain that this AD connector will be
     associated with. Required.
    :vartype realm: str
    :ivar netbios_domain_name: NETBIOS name of the Active Directory domain.
    :vartype netbios_domain_name: str
    :ivar service_account_provisioning: The service account provisioning mode for this Active
     Directory connector. Known values are: "automatic" and "manual".
    :vartype service_account_provisioning: str or
     ~azure.mgmt.azurearcdata.models.AccountProvisioningMode
    :ivar ou_distinguished_name: The distinguished name of the Active Directory Organizational
     Unit.
    :vartype ou_distinguished_name: str
    :ivar domain_controllers: null. Required.
    :vartype domain_controllers: ~azure.mgmt.azurearcdata.models.ActiveDirectoryDomainControllers
    """

    _validation = {
        "realm": {"required": True},
        "domain_controllers": {"required": True},
    }

    _attribute_map = {
        "realm": {"key": "realm", "type": "str"},
        "netbios_domain_name": {"key": "netbiosDomainName", "type": "str"},
        "service_account_provisioning": {"key": "serviceAccountProvisioning", "type": "str"},
        "ou_distinguished_name": {"key": "ouDistinguishedName", "type": "str"},
        "domain_controllers": {"key": "domainControllers", "type": "ActiveDirectoryDomainControllers"},
    }

    def __init__(
        self,
        *,
        realm: str,
        domain_controllers: "_models.ActiveDirectoryDomainControllers",
        netbios_domain_name: Optional[str] = None,
        service_account_provisioning: Union[str, "_models.AccountProvisioningMode"] = "manual",
        ou_distinguished_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword realm: Name (uppercase) of the Active Directory domain that this AD connector will be
         associated with. Required.
        :paramtype realm: str
        :keyword netbios_domain_name: NETBIOS name of the Active Directory domain.
        :paramtype netbios_domain_name: str
        :keyword service_account_provisioning: The service account provisioning mode for this Active
         Directory connector. Known values are: "automatic" and "manual".
        :paramtype service_account_provisioning: str or
         ~azure.mgmt.azurearcdata.models.AccountProvisioningMode
        :keyword ou_distinguished_name: The distinguished name of the Active Directory Organizational
         Unit.
        :paramtype ou_distinguished_name: str
        :keyword domain_controllers: null. Required.
        :paramtype domain_controllers: ~azure.mgmt.azurearcdata.models.ActiveDirectoryDomainControllers
        """
        super().__init__(**kwargs)
        self.realm = realm
        self.netbios_domain_name = netbios_domain_name
        self.service_account_provisioning = service_account_provisioning
        self.ou_distinguished_name = ou_distinguished_name
        self.domain_controllers = domain_controllers


class ActiveDirectoryConnectorListResult(_serialization.Model):
    """A list of active directory connectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.azurearcdata.models.ActiveDirectoryConnectorResource]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ActiveDirectoryConnectorResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ActiveDirectoryConnectorProperties(_serialization.Model):
    """The properties of an Active Directory connector resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar domain_service_account_login_information: Username and password for domain service
     account authentication.
    :vartype domain_service_account_login_information:
     ~azure.mgmt.azurearcdata.models.BasicLoginInformation
    :ivar provisioning_state: The provisioning state of the Active Directory connector resource.
    :vartype provisioning_state: str
    :ivar spec: null. Required.
    :vartype spec: ~azure.mgmt.azurearcdata.models.ActiveDirectoryConnectorSpec
    :ivar status: null.
    :vartype status: ~azure.mgmt.azurearcdata.models.ActiveDirectoryConnectorStatus
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "spec": {"required": True},
    }

    _attribute_map = {
        "domain_service_account_login_information": {
            "key": "domainServiceAccountLoginInformation",
            "type": "BasicLoginInformation",
        },
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "spec": {"key": "spec", "type": "ActiveDirectoryConnectorSpec"},
        "status": {"key": "status", "type": "ActiveDirectoryConnectorStatus"},
    }

    def __init__(
        self,
        *,
        spec: "_models.ActiveDirectoryConnectorSpec",
        domain_service_account_login_information: Optional["_models.BasicLoginInformation"] = None,
        status: Optional["_models.ActiveDirectoryConnectorStatus"] = None,
        **kwargs
    ):
        """
        :keyword domain_service_account_login_information: Username and password for domain service
         account authentication.
        :paramtype domain_service_account_login_information:
         ~azure.mgmt.azurearcdata.models.BasicLoginInformation
        :keyword spec: null. Required.
        :paramtype spec: ~azure.mgmt.azurearcdata.models.ActiveDirectoryConnectorSpec
        :keyword status: null.
        :paramtype status: ~azure.mgmt.azurearcdata.models.ActiveDirectoryConnectorStatus
        """
        super().__init__(**kwargs)
        self.domain_service_account_login_information = domain_service_account_login_information
        self.provisioning_state = None
        self.spec = spec
        self.status = status


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurearcdata.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurearcdata.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class ActiveDirectoryConnectorResource(ProxyResource):
    """Active directory connector resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurearcdata.models.SystemData
    :ivar properties: null. Required.
    :vartype properties: ~azure.mgmt.azurearcdata.models.ActiveDirectoryConnectorProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ActiveDirectoryConnectorProperties"},
    }

    def __init__(self, *, properties: "_models.ActiveDirectoryConnectorProperties", **kwargs):
        """
        :keyword properties: null. Required.
        :paramtype properties: ~azure.mgmt.azurearcdata.models.ActiveDirectoryConnectorProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ActiveDirectoryConnectorSpec(_serialization.Model):
    """The specifications of the AD Kubernetes resource.

    All required parameters must be populated in order to send to Azure.

    :ivar active_directory: null. Required.
    :vartype active_directory:
     ~azure.mgmt.azurearcdata.models.ActiveDirectoryConnectorDomainDetails
    :ivar dns: null. Required.
    :vartype dns: ~azure.mgmt.azurearcdata.models.ActiveDirectoryConnectorDNSDetails
    """

    _validation = {
        "active_directory": {"required": True},
        "dns": {"required": True},
    }

    _attribute_map = {
        "active_directory": {"key": "activeDirectory", "type": "ActiveDirectoryConnectorDomainDetails"},
        "dns": {"key": "dns", "type": "ActiveDirectoryConnectorDNSDetails"},
    }

    def __init__(
        self,
        *,
        active_directory: "_models.ActiveDirectoryConnectorDomainDetails",
        dns: "_models.ActiveDirectoryConnectorDNSDetails",
        **kwargs
    ):
        """
        :keyword active_directory: null. Required.
        :paramtype active_directory:
         ~azure.mgmt.azurearcdata.models.ActiveDirectoryConnectorDomainDetails
        :keyword dns: null. Required.
        :paramtype dns: ~azure.mgmt.azurearcdata.models.ActiveDirectoryConnectorDNSDetails
        """
        super().__init__(**kwargs)
        self.active_directory = active_directory
        self.dns = dns


class ActiveDirectoryConnectorStatus(_serialization.Model):
    """The status of the Kubernetes custom resource.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar last_update_time: The time that the custom resource was last updated.
    :vartype last_update_time: str
    :ivar observed_generation: The version of the replicaSet associated with the AD connector
     custom resource.
    :vartype observed_generation: int
    :ivar state: The state of the AD connector custom resource.
    :vartype state: str
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "last_update_time": {"key": "lastUpdateTime", "type": "str"},
        "observed_generation": {"key": "observedGeneration", "type": "int"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        last_update_time: Optional[str] = None,
        observed_generation: Optional[int] = None,
        state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword last_update_time: The time that the custom resource was last updated.
        :paramtype last_update_time: str
        :keyword observed_generation: The version of the replicaSet associated with the AD connector
         custom resource.
        :paramtype observed_generation: int
        :keyword state: The state of the AD connector custom resource.
        :paramtype state: str
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.last_update_time = last_update_time
        self.observed_generation = observed_generation
        self.state = state


class ActiveDirectoryDomainController(_serialization.Model):
    """Information about a domain controller in the AD domain.

    All required parameters must be populated in order to send to Azure.

    :ivar hostname: Fully-qualified domain name of a domain controller in the AD domain. Required.
    :vartype hostname: str
    """

    _validation = {
        "hostname": {"required": True},
    }

    _attribute_map = {
        "hostname": {"key": "hostname", "type": "str"},
    }

    def __init__(self, *, hostname: str, **kwargs):
        """
        :keyword hostname: Fully-qualified domain name of a domain controller in the AD domain.
         Required.
        :paramtype hostname: str
        """
        super().__init__(**kwargs)
        self.hostname = hostname


class ActiveDirectoryDomainControllers(_serialization.Model):
    """Details about the Active Directory domain controllers associated with this AD connector instance.

    :ivar primary_domain_controller: Information about the Primary Domain Controller (PDC) in the
     AD domain.
    :vartype primary_domain_controller:
     ~azure.mgmt.azurearcdata.models.ActiveDirectoryDomainController
    :ivar secondary_domain_controllers: null.
    :vartype secondary_domain_controllers:
     list[~azure.mgmt.azurearcdata.models.ActiveDirectoryDomainController]
    """

    _attribute_map = {
        "primary_domain_controller": {"key": "primaryDomainController", "type": "ActiveDirectoryDomainController"},
        "secondary_domain_controllers": {
            "key": "secondaryDomainControllers",
            "type": "[ActiveDirectoryDomainController]",
        },
    }

    def __init__(
        self,
        *,
        primary_domain_controller: Optional["_models.ActiveDirectoryDomainController"] = None,
        secondary_domain_controllers: Optional[List["_models.ActiveDirectoryDomainController"]] = None,
        **kwargs
    ):
        """
        :keyword primary_domain_controller: Information about the Primary Domain Controller (PDC) in
         the AD domain.
        :paramtype primary_domain_controller:
         ~azure.mgmt.azurearcdata.models.ActiveDirectoryDomainController
        :keyword secondary_domain_controllers: null.
        :paramtype secondary_domain_controllers:
         list[~azure.mgmt.azurearcdata.models.ActiveDirectoryDomainController]
        """
        super().__init__(**kwargs)
        self.primary_domain_controller = primary_domain_controller
        self.secondary_domain_controllers = secondary_domain_controllers


class ActiveDirectoryInformation(_serialization.Model):
    """Active Directory information that related to the resource.

    :ivar keytab_information: Keytab information that is used for the Sql Managed Instance when
     Active Directory authentication is used.
    :vartype keytab_information: ~azure.mgmt.azurearcdata.models.KeytabInformation
    """

    _attribute_map = {
        "keytab_information": {"key": "keytabInformation", "type": "KeytabInformation"},
    }

    def __init__(self, *, keytab_information: Optional["_models.KeytabInformation"] = None, **kwargs):
        """
        :keyword keytab_information: Keytab information that is used for the Sql Managed Instance when
         Active Directory authentication is used.
        :paramtype keytab_information: ~azure.mgmt.azurearcdata.models.KeytabInformation
        """
        super().__init__(**kwargs)
        self.keytab_information = keytab_information


class BasicLoginInformation(_serialization.Model):
    """Username and password for basic login authentication.

    :ivar username: Login username.
    :vartype username: str
    :ivar password: Login password.
    :vartype password: str
    """

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
    }

    def __init__(self, *, username: Optional[str] = None, password: Optional[str] = None, **kwargs):
        """
        :keyword username: Login username.
        :paramtype username: str
        :keyword password: Login password.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.username = username
        self.password = password


class CommonSku(_serialization.Model):
    """The resource model definition representing SKU for ARM resources.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the SKU.  It is typically a letter+number code. Required.
    :vartype name: str
    :ivar dev: Whether dev/test is enabled. When the dev field is set to true, the resource is used
     for dev/test purpose.
    :vartype dev: bool
    :ivar size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :vartype size: str
    :ivar family: If the service has different generations of hardware, for the same SKU, then that
     can be captured here.
    :vartype family: str
    :ivar capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :vartype capacity: int
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "dev": {"key": "dev", "type": "bool"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: str,
        dev: bool = True,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the SKU.  It is typically a letter+number code. Required.
        :paramtype name: str
        :keyword dev: Whether dev/test is enabled. When the dev field is set to true, the resource is
         used for dev/test purpose.
        :paramtype dev: bool
        :keyword size: The SKU size. When the name field is the combination of tier and some other
         value, this would be the standalone code.
        :paramtype size: str
        :keyword family: If the service has different generations of hardware, for the same SKU, then
         that can be captured here.
        :paramtype family: str
        :keyword capacity: If the SKU supports scale out/in then the capacity integer should be
         included. If scale out/in is not possible for the resource this may be omitted.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.dev = dev
        self.size = size
        self.family = family
        self.capacity = capacity


class DataControllerProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The data controller properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar infrastructure: The infrastructure the data controller is running on. Known values are:
     "azure", "gcp", "aws", "alibaba", "onpremises", and "other".
    :vartype infrastructure: str or ~azure.mgmt.azurearcdata.models.Infrastructure
    :ivar on_premise_property: Properties from the Kubernetes data controller.
    :vartype on_premise_property: ~azure.mgmt.azurearcdata.models.OnPremiseProperty
    :ivar k8_s_raw: The raw kubernetes information.
    :vartype k8_s_raw: JSON
    :ivar upload_watermark: Properties on upload watermark.  Mostly timestamp for each upload data
     type.
    :vartype upload_watermark: ~azure.mgmt.azurearcdata.models.UploadWatermark
    :ivar last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date
     time.
    :vartype last_uploaded_date: ~datetime.datetime
    :ivar basic_login_information: Deprecated. Azure Arc Data Services data controller no longer
     expose any endpoint. All traffic are exposed through Kubernetes native API.
    :vartype basic_login_information: ~azure.mgmt.azurearcdata.models.BasicLoginInformation
    :ivar metrics_dashboard_credential: Login credential for metrics dashboard on the Kubernetes
     cluster.
    :vartype metrics_dashboard_credential: ~azure.mgmt.azurearcdata.models.BasicLoginInformation
    :ivar logs_dashboard_credential: Login credential for logs dashboard on the Kubernetes cluster.
    :vartype logs_dashboard_credential: ~azure.mgmt.azurearcdata.models.BasicLoginInformation
    :ivar log_analytics_workspace_config: Log analytics workspace id and primary key.
    :vartype log_analytics_workspace_config:
     ~azure.mgmt.azurearcdata.models.LogAnalyticsWorkspaceConfig
    :ivar upload_service_principal: Deprecated. Service principal is deprecated in favor of Arc
     Kubernetes service extension managed identity.
    :vartype upload_service_principal: ~azure.mgmt.azurearcdata.models.UploadServicePrincipal
    :ivar provisioning_state: The provisioning state of the Arc Data Controller resource.
    :vartype provisioning_state: str
    :ivar cluster_id: If a CustomLocation is provided, this contains the ARM id of the connected
     cluster the custom location belongs to.
    :vartype cluster_id: str
    :ivar extension_id: If a CustomLocation is provided, this contains the ARM id of the extension
     the custom location belongs to.
    :vartype extension_id: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "infrastructure": {"key": "infrastructure", "type": "str"},
        "on_premise_property": {"key": "onPremiseProperty", "type": "OnPremiseProperty"},
        "k8_s_raw": {"key": "k8sRaw", "type": "object"},
        "upload_watermark": {"key": "uploadWatermark", "type": "UploadWatermark"},
        "last_uploaded_date": {"key": "lastUploadedDate", "type": "iso-8601"},
        "basic_login_information": {"key": "basicLoginInformation", "type": "BasicLoginInformation"},
        "metrics_dashboard_credential": {"key": "metricsDashboardCredential", "type": "BasicLoginInformation"},
        "logs_dashboard_credential": {"key": "logsDashboardCredential", "type": "BasicLoginInformation"},
        "log_analytics_workspace_config": {"key": "logAnalyticsWorkspaceConfig", "type": "LogAnalyticsWorkspaceConfig"},
        "upload_service_principal": {"key": "uploadServicePrincipal", "type": "UploadServicePrincipal"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "cluster_id": {"key": "clusterId", "type": "str"},
        "extension_id": {"key": "extensionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        infrastructure: Union[str, "_models.Infrastructure"] = "other",
        on_premise_property: Optional["_models.OnPremiseProperty"] = None,
        k8_s_raw: Optional[JSON] = None,
        upload_watermark: Optional["_models.UploadWatermark"] = None,
        last_uploaded_date: Optional[datetime.datetime] = None,
        basic_login_information: Optional["_models.BasicLoginInformation"] = None,
        metrics_dashboard_credential: Optional["_models.BasicLoginInformation"] = None,
        logs_dashboard_credential: Optional["_models.BasicLoginInformation"] = None,
        log_analytics_workspace_config: Optional["_models.LogAnalyticsWorkspaceConfig"] = None,
        upload_service_principal: Optional["_models.UploadServicePrincipal"] = None,
        cluster_id: Optional[str] = None,
        extension_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword infrastructure: The infrastructure the data controller is running on. Known values
         are: "azure", "gcp", "aws", "alibaba", "onpremises", and "other".
        :paramtype infrastructure: str or ~azure.mgmt.azurearcdata.models.Infrastructure
        :keyword on_premise_property: Properties from the Kubernetes data controller.
        :paramtype on_premise_property: ~azure.mgmt.azurearcdata.models.OnPremiseProperty
        :keyword k8_s_raw: The raw kubernetes information.
        :paramtype k8_s_raw: JSON
        :keyword upload_watermark: Properties on upload watermark.  Mostly timestamp for each upload
         data type.
        :paramtype upload_watermark: ~azure.mgmt.azurearcdata.models.UploadWatermark
        :keyword last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current
         date time.
        :paramtype last_uploaded_date: ~datetime.datetime
        :keyword basic_login_information: Deprecated. Azure Arc Data Services data controller no longer
         expose any endpoint. All traffic are exposed through Kubernetes native API.
        :paramtype basic_login_information: ~azure.mgmt.azurearcdata.models.BasicLoginInformation
        :keyword metrics_dashboard_credential: Login credential for metrics dashboard on the Kubernetes
         cluster.
        :paramtype metrics_dashboard_credential: ~azure.mgmt.azurearcdata.models.BasicLoginInformation
        :keyword logs_dashboard_credential: Login credential for logs dashboard on the Kubernetes
         cluster.
        :paramtype logs_dashboard_credential: ~azure.mgmt.azurearcdata.models.BasicLoginInformation
        :keyword log_analytics_workspace_config: Log analytics workspace id and primary key.
        :paramtype log_analytics_workspace_config:
         ~azure.mgmt.azurearcdata.models.LogAnalyticsWorkspaceConfig
        :keyword upload_service_principal: Deprecated. Service principal is deprecated in favor of Arc
         Kubernetes service extension managed identity.
        :paramtype upload_service_principal: ~azure.mgmt.azurearcdata.models.UploadServicePrincipal
        :keyword cluster_id: If a CustomLocation is provided, this contains the ARM id of the connected
         cluster the custom location belongs to.
        :paramtype cluster_id: str
        :keyword extension_id: If a CustomLocation is provided, this contains the ARM id of the
         extension the custom location belongs to.
        :paramtype extension_id: str
        """
        super().__init__(**kwargs)
        self.infrastructure = infrastructure
        self.on_premise_property = on_premise_property
        self.k8_s_raw = k8_s_raw
        self.upload_watermark = upload_watermark
        self.last_uploaded_date = last_uploaded_date
        self.basic_login_information = basic_login_information
        self.metrics_dashboard_credential = metrics_dashboard_credential
        self.logs_dashboard_credential = logs_dashboard_credential
        self.log_analytics_workspace_config = log_analytics_workspace_config
        self.upload_service_principal = upload_service_principal
        self.provisioning_state = None
        self.cluster_id = cluster_id
        self.extension_id = extension_id


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurearcdata.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class DataControllerResource(TrackedResource):
    """Data controller resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurearcdata.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurearcdata.models.ExtendedLocation
    :ivar properties: The data controller's properties. Required.
    :vartype properties: ~azure.mgmt.azurearcdata.models.DataControllerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "properties": {"key": "properties", "type": "DataControllerProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.DataControllerProperties",
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extendedLocation of the resource.
        :paramtype extended_location: ~azure.mgmt.azurearcdata.models.ExtendedLocation
        :keyword properties: The data controller's properties. Required.
        :paramtype properties: ~azure.mgmt.azurearcdata.models.DataControllerProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.properties = properties


class DataControllerUpdate(_serialization.Model):
    """Used for updating a data controller resource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The data controller's properties.
    :vartype properties: ~azure.mgmt.azurearcdata.models.DataControllerProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "DataControllerProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.DataControllerProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The data controller's properties.
        :paramtype properties: ~azure.mgmt.azurearcdata.models.DataControllerProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class ErrorResponse(_serialization.Model):
    """An error response from the Azure Data on Azure Arc service.

    :ivar error: null.
    :vartype error: ~azure.mgmt.azurearcdata.models.ErrorResponseBody
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponseBody"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponseBody"] = None, **kwargs):
        """
        :keyword error: null.
        :paramtype error: ~azure.mgmt.azurearcdata.models.ErrorResponseBody
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseBody(_serialization.Model):
    """An error response from the Batch service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.azurearcdata.models.ErrorResponseBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponseBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.ErrorResponseBody"]] = None,
        **kwargs
    ):
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.azurearcdata.models.ErrorResponseBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ExtendedLocation(_serialization.Model):
    """The complex type of the extended location.

    :ivar name: The name of the extended location.
    :vartype name: str
    :ivar type: The type of the extended location. "CustomLocation"
    :vartype type: str or ~azure.mgmt.azurearcdata.models.ExtendedLocationTypes
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "_models.ExtendedLocationTypes"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the extended location.
        :paramtype name: str
        :keyword type: The type of the extended location. "CustomLocation"
        :paramtype type: str or ~azure.mgmt.azurearcdata.models.ExtendedLocationTypes
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class K8SResourceRequirements(_serialization.Model):
    """The kubernetes resource limits and requests used to restrict or reserve resource usage.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar requests: Requests for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu'
     request must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default
     'memory' is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and
     maximum 'memory' is '128Gi'.
    :vartype requests: dict[str, str]
    :ivar limits: Limits for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request
     must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default 'memory'
     is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum
     'memory' is '128Gi'.
    :vartype limits: dict[str, str]
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "requests": {"key": "requests", "type": "{str}"},
        "limits": {"key": "limits", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        requests: Optional[Dict[str, str]] = None,
        limits: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword requests: Requests for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu'
         request must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default
         'memory' is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and
         maximum 'memory' is '128Gi'.
        :paramtype requests: dict[str, str]
        :keyword limits: Limits for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request
         must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default 'memory'
         is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum
         'memory' is '128Gi'.
        :paramtype limits: dict[str, str]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.requests = requests
        self.limits = limits


class K8SScheduling(_serialization.Model):
    """The kubernetes scheduling information.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar default: The kubernetes scheduling options. It describes restrictions used to help
     Kubernetes select appropriate nodes to host the database service.
    :vartype default: ~azure.mgmt.azurearcdata.models.K8SSchedulingOptions
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "default": {"key": "default", "type": "K8SSchedulingOptions"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        default: Optional["_models.K8SSchedulingOptions"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword default: The kubernetes scheduling options. It describes restrictions used to help
         Kubernetes select appropriate nodes to host the database service.
        :paramtype default: ~azure.mgmt.azurearcdata.models.K8SSchedulingOptions
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.default = default


class K8SSchedulingOptions(_serialization.Model):
    """The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar resources: The kubernetes resource limits and requests used to restrict or reserve
     resource usage.
    :vartype resources: ~azure.mgmt.azurearcdata.models.K8SResourceRequirements
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "resources": {"key": "resources", "type": "K8SResourceRequirements"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        resources: Optional["_models.K8SResourceRequirements"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword resources: The kubernetes resource limits and requests used to restrict or reserve
         resource usage.
        :paramtype resources: ~azure.mgmt.azurearcdata.models.K8SResourceRequirements
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.resources = resources


class KeytabInformation(_serialization.Model):
    """Keytab used for authenticate with Active Directory.

    :ivar keytab: A base64-encoded keytab.
    :vartype keytab: str
    """

    _attribute_map = {
        "keytab": {"key": "keytab", "type": "str"},
    }

    def __init__(self, *, keytab: Optional[str] = None, **kwargs):
        """
        :keyword keytab: A base64-encoded keytab.
        :paramtype keytab: str
        """
        super().__init__(**kwargs)
        self.keytab = keytab


class LogAnalyticsWorkspaceConfig(_serialization.Model):
    """Log analytics workspace id and primary key.

    :ivar workspace_id: Azure Log Analytics workspace ID.
    :vartype workspace_id: str
    :ivar primary_key: Primary key of the workspace.
    :vartype primary_key: str
    """

    _attribute_map = {
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "primary_key": {"key": "primaryKey", "type": "str"},
    }

    def __init__(self, *, workspace_id: Optional[str] = None, primary_key: Optional[str] = None, **kwargs):
        """
        :keyword workspace_id: Azure Log Analytics workspace ID.
        :paramtype workspace_id: str
        :keyword primary_key: Primary key of the workspace.
        :paramtype primary_key: str
        """
        super().__init__(**kwargs)
        self.workspace_id = workspace_id
        self.primary_key = primary_key


class OnPremiseProperty(_serialization.Model):
    """Properties from the Kubernetes data controller.

    All required parameters must be populated in order to send to Azure.

    :ivar id: A globally unique ID identifying the associated Kubernetes cluster. Required.
    :vartype id: str
    :ivar public_signing_key: Certificate that contains the Kubernetes cluster public key used to
     verify signing. Required.
    :vartype public_signing_key: str
    :ivar signing_certificate_thumbprint: Unique thumbprint returned to customer to verify the
     certificate being uploaded.
    :vartype signing_certificate_thumbprint: str
    """

    _validation = {
        "id": {"required": True},
        "public_signing_key": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "public_signing_key": {"key": "publicSigningKey", "type": "str"},
        "signing_certificate_thumbprint": {"key": "signingCertificateThumbprint", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        public_signing_key: str,
        signing_certificate_thumbprint: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: A globally unique ID identifying the associated Kubernetes cluster. Required.
        :paramtype id: str
        :keyword public_signing_key: Certificate that contains the Kubernetes cluster public key used
         to verify signing. Required.
        :paramtype public_signing_key: str
        :keyword signing_certificate_thumbprint: Unique thumbprint returned to customer to verify the
         certificate being uploaded.
        :paramtype signing_certificate_thumbprint: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.public_signing_key = public_signing_key
        self.signing_certificate_thumbprint = signing_certificate_thumbprint


class Operation(_serialization.Model):
    """Azure Data Services on Azure Arc operation definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the operation being performed on this particular object. Required.
    :vartype name: str
    :ivar display: The localized display information for this particular operation / action.
     Required.
    :vartype display: ~azure.mgmt.azurearcdata.models.OperationDisplay
    :ivar origin: The intended executor of the operation. Known values are: "user" and "system".
    :vartype origin: str or ~azure.mgmt.azurearcdata.models.OperationOrigin
    :ivar is_data_action: Indicates whether the operation is a data action. Required.
    :vartype is_data_action: bool
    :ivar properties: Additional descriptions for the operation.
    :vartype properties: dict[str, JSON]
    """

    _validation = {
        "name": {"required": True},
        "display": {"required": True},
        "origin": {"readonly": True},
        "is_data_action": {"required": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "properties": {"key": "properties", "type": "{object}"},
    }

    def __init__(self, *, name: str, display: "_models.OperationDisplay", is_data_action: bool, **kwargs):
        """
        :keyword name: The name of the operation being performed on this particular object. Required.
        :paramtype name: str
        :keyword display: The localized display information for this particular operation / action.
         Required.
        :paramtype display: ~azure.mgmt.azurearcdata.models.OperationDisplay
        :keyword is_data_action: Indicates whether the operation is a data action. Required.
        :paramtype is_data_action: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = None
        self.is_data_action = is_data_action
        self.properties = None


class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    All required parameters must be populated in order to send to Azure.

    :ivar provider: The localized friendly form of the resource provider name. Required.
    :vartype provider: str
    :ivar resource: The localized friendly form of the resource type related to this
     action/operation. Required.
    :vartype resource: str
    :ivar operation: The localized friendly name for the operation. Required.
    :vartype operation: str
    :ivar description: The localized friendly description for the operation. Required.
    :vartype description: str
    """

    _validation = {
        "provider": {"required": True},
        "resource": {"required": True},
        "operation": {"required": True},
        "description": {"required": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, provider: str, resource: str, operation: str, description: str, **kwargs):
        """
        :keyword provider: The localized friendly form of the resource provider name. Required.
        :paramtype provider: str
        :keyword resource: The localized friendly form of the resource type related to this
         action/operation. Required.
        :paramtype resource: str
        :keyword operation: The localized friendly name for the operation. Required.
        :paramtype operation: str
        :keyword description: The localized friendly description for the operation. Required.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of the request to list Azure Data Services on Azure Arc operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.azurearcdata.models.Operation]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PageOfDataControllerResource(_serialization.Model):
    """A list of data controllers.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.azurearcdata.models.DataControllerResource]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DataControllerResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.DataControllerResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Array of results.
        :paramtype value: list[~azure.mgmt.azurearcdata.models.DataControllerResource]
        :keyword next_link: Link to retrieve next page of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PostgresInstance(TrackedResource):
    """A Postgres Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurearcdata.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurearcdata.models.ExtendedLocation
    :ivar properties: null. Required.
    :vartype properties: ~azure.mgmt.azurearcdata.models.PostgresInstanceProperties
    :ivar sku: Resource sku.
    :vartype sku: ~azure.mgmt.azurearcdata.models.PostgresInstanceSku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "properties": {"key": "properties", "type": "PostgresInstanceProperties"},
        "sku": {"key": "sku", "type": "PostgresInstanceSku"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.PostgresInstanceProperties",
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        sku: Optional["_models.PostgresInstanceSku"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extendedLocation of the resource.
        :paramtype extended_location: ~azure.mgmt.azurearcdata.models.ExtendedLocation
        :keyword properties: null. Required.
        :paramtype properties: ~azure.mgmt.azurearcdata.models.PostgresInstanceProperties
        :keyword sku: Resource sku.
        :paramtype sku: ~azure.mgmt.azurearcdata.models.PostgresInstanceSku
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.properties = properties
        self.sku = sku


class PostgresInstanceListResult(_serialization.Model):
    """A list of PostgresInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.azurearcdata.models.PostgresInstance]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PostgresInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PostgresInstanceProperties(_serialization.Model):
    """Postgres Instance properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar data_controller_id: The data controller id.
    :vartype data_controller_id: str
    :ivar admin: The instance admin.
    :vartype admin: str
    :ivar basic_login_information: Username and password for basic authentication.
    :vartype basic_login_information: ~azure.mgmt.azurearcdata.models.BasicLoginInformation
    :ivar k8_s_raw: The raw kubernetes information.
    :vartype k8_s_raw: JSON
    :ivar last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date
     time.
    :vartype last_uploaded_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the Azure Arc-enabled PostgreSQL instance.
    :vartype provisioning_state: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "data_controller_id": {"key": "dataControllerId", "type": "str"},
        "admin": {"key": "admin", "type": "str"},
        "basic_login_information": {"key": "basicLoginInformation", "type": "BasicLoginInformation"},
        "k8_s_raw": {"key": "k8sRaw", "type": "object"},
        "last_uploaded_date": {"key": "lastUploadedDate", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_controller_id: Optional[str] = None,
        admin: Optional[str] = None,
        basic_login_information: Optional["_models.BasicLoginInformation"] = None,
        k8_s_raw: Optional[JSON] = None,
        last_uploaded_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword data_controller_id: The data controller id.
        :paramtype data_controller_id: str
        :keyword admin: The instance admin.
        :paramtype admin: str
        :keyword basic_login_information: Username and password for basic authentication.
        :paramtype basic_login_information: ~azure.mgmt.azurearcdata.models.BasicLoginInformation
        :keyword k8_s_raw: The raw kubernetes information.
        :paramtype k8_s_raw: JSON
        :keyword last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current
         date time.
        :paramtype last_uploaded_date: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.data_controller_id = data_controller_id
        self.admin = admin
        self.basic_login_information = basic_login_information
        self.k8_s_raw = k8_s_raw
        self.last_uploaded_date = last_uploaded_date
        self.provisioning_state = None


class PostgresInstanceSku(CommonSku):
    """The resource model definition representing SKU for Azure Database for PostgresSQL - Azure Arc.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the SKU.  It is typically a letter+number code. Required.
    :vartype name: str
    :ivar dev: Whether dev/test is enabled. When the dev field is set to true, the resource is used
     for dev/test purpose.
    :vartype dev: bool
    :ivar size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :vartype size: str
    :ivar family: If the service has different generations of hardware, for the same SKU, then that
     can be captured here.
    :vartype family: str
    :ivar capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :vartype capacity: int
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier. Default value is "Hyperscale".
    :vartype tier: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "dev": {"key": "dev", "type": "bool"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        dev: bool = True,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        tier: Literal["Hyperscale"] = "Hyperscale",
        **kwargs
    ):
        """
        :keyword name: The name of the SKU.  It is typically a letter+number code. Required.
        :paramtype name: str
        :keyword dev: Whether dev/test is enabled. When the dev field is set to true, the resource is
         used for dev/test purpose.
        :paramtype dev: bool
        :keyword size: The SKU size. When the name field is the combination of tier and some other
         value, this would be the standalone code.
        :paramtype size: str
        :keyword family: If the service has different generations of hardware, for the same SKU, then
         that can be captured here.
        :paramtype family: str
        :keyword capacity: If the SKU supports scale out/in then the capacity integer should be
         included. If scale out/in is not possible for the resource this may be omitted.
        :paramtype capacity: int
        :keyword tier: This field is required to be implemented by the Resource Provider if the service
         has more than one tier. Default value is "Hyperscale".
        :paramtype tier: str
        """
        super().__init__(name=name, dev=dev, size=size, family=family, capacity=capacity, **kwargs)
        self.tier = tier


class PostgresInstanceUpdate(_serialization.Model):
    """An update to a Postgres Instance.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Postgres Instance properties.
    :vartype properties: ~azure.mgmt.azurearcdata.models.PostgresInstanceProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "PostgresInstanceProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.PostgresInstanceProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Postgres Instance properties.
        :paramtype properties: ~azure.mgmt.azurearcdata.models.PostgresInstanceProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class SqlManagedInstance(TrackedResource):
    """A SqlManagedInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurearcdata.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: null. Required.
    :vartype properties: ~azure.mgmt.azurearcdata.models.SqlManagedInstanceProperties
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurearcdata.models.ExtendedLocation
    :ivar sku: Resource sku.
    :vartype sku: ~azure.mgmt.azurearcdata.models.SqlManagedInstanceSku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "SqlManagedInstanceProperties"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "sku": {"key": "sku", "type": "SqlManagedInstanceSku"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.SqlManagedInstanceProperties",
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        sku: Optional["_models.SqlManagedInstanceSku"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: null. Required.
        :paramtype properties: ~azure.mgmt.azurearcdata.models.SqlManagedInstanceProperties
        :keyword extended_location: The extendedLocation of the resource.
        :paramtype extended_location: ~azure.mgmt.azurearcdata.models.ExtendedLocation
        :keyword sku: Resource sku.
        :paramtype sku: ~azure.mgmt.azurearcdata.models.SqlManagedInstanceSku
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties
        self.extended_location = extended_location
        self.sku = sku


class SqlManagedInstanceK8SRaw(_serialization.Model):
    """The raw kubernetes information.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar spec: The kubernetes spec information.
    :vartype spec: ~azure.mgmt.azurearcdata.models.SqlManagedInstanceK8SSpec
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "spec": {"key": "spec", "type": "SqlManagedInstanceK8SSpec"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        spec: Optional["_models.SqlManagedInstanceK8SSpec"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword spec: The kubernetes spec information.
        :paramtype spec: ~azure.mgmt.azurearcdata.models.SqlManagedInstanceK8SSpec
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.spec = spec


class SqlManagedInstanceK8SSpec(_serialization.Model):
    """The kubernetes spec information.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar scheduling: The kubernetes scheduling information.
    :vartype scheduling: ~azure.mgmt.azurearcdata.models.K8SScheduling
    :ivar replicas: This option specifies the number of SQL Managed Instance replicas that will be
     deployed in your Kubernetes cluster for high availability purposes. If sku.tier is
     BusinessCritical, allowed values are '2' or '3' with default of '3'. If sku.tier is
     GeneralPurpose, replicas must be '1'.
    :vartype replicas: int
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "scheduling": {"key": "scheduling", "type": "K8SScheduling"},
        "replicas": {"key": "replicas", "type": "int"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        scheduling: Optional["_models.K8SScheduling"] = None,
        replicas: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword scheduling: The kubernetes scheduling information.
        :paramtype scheduling: ~azure.mgmt.azurearcdata.models.K8SScheduling
        :keyword replicas: This option specifies the number of SQL Managed Instance replicas that will
         be deployed in your Kubernetes cluster for high availability purposes. If sku.tier is
         BusinessCritical, allowed values are '2' or '3' with default of '3'. If sku.tier is
         GeneralPurpose, replicas must be '1'.
        :paramtype replicas: int
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.scheduling = scheduling
        self.replicas = replicas


class SqlManagedInstanceListResult(_serialization.Model):
    """A list of SqlManagedInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.azurearcdata.models.SqlManagedInstance]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SqlManagedInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SqlManagedInstanceProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties of sqlManagedInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar data_controller_id: null.
    :vartype data_controller_id: str
    :ivar admin: The instance admin user.
    :vartype admin: str
    :ivar start_time: The instance start time.
    :vartype start_time: str
    :ivar end_time: The instance end time.
    :vartype end_time: str
    :ivar k8_s_raw: The raw kubernetes information.
    :vartype k8_s_raw: ~azure.mgmt.azurearcdata.models.SqlManagedInstanceK8SRaw
    :ivar basic_login_information: Username and password for basic authentication.
    :vartype basic_login_information: ~azure.mgmt.azurearcdata.models.BasicLoginInformation
    :ivar last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date
     time.
    :vartype last_uploaded_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the Arc-enabled SQL Managed Instance
     resource.
    :vartype provisioning_state: str
    :ivar active_directory_information: Active Directory information related to this SQL Managed
     Instance.
    :vartype active_directory_information:
     ~azure.mgmt.azurearcdata.models.ActiveDirectoryInformation
    :ivar license_type: The license type to apply for this managed instance. Known values are:
     "BasePrice", "LicenseIncluded", and "DisasterRecovery".
    :vartype license_type: str or ~azure.mgmt.azurearcdata.models.ArcSqlManagedInstanceLicenseType
    :ivar cluster_id: If a CustomLocation is provided, this contains the ARM id of the connected
     cluster the custom location belongs to.
    :vartype cluster_id: str
    :ivar extension_id: If a CustomLocation is provided, this contains the ARM id of the extension
     the custom location belongs to.
    :vartype extension_id: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "data_controller_id": {"key": "dataControllerId", "type": "str"},
        "admin": {"key": "admin", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "end_time": {"key": "endTime", "type": "str"},
        "k8_s_raw": {"key": "k8sRaw", "type": "SqlManagedInstanceK8SRaw"},
        "basic_login_information": {"key": "basicLoginInformation", "type": "BasicLoginInformation"},
        "last_uploaded_date": {"key": "lastUploadedDate", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "active_directory_information": {"key": "activeDirectoryInformation", "type": "ActiveDirectoryInformation"},
        "license_type": {"key": "licenseType", "type": "str"},
        "cluster_id": {"key": "clusterId", "type": "str"},
        "extension_id": {"key": "extensionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_controller_id: Optional[str] = None,
        admin: Optional[str] = None,
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        k8_s_raw: Optional["_models.SqlManagedInstanceK8SRaw"] = None,
        basic_login_information: Optional["_models.BasicLoginInformation"] = None,
        last_uploaded_date: Optional[datetime.datetime] = None,
        active_directory_information: Optional["_models.ActiveDirectoryInformation"] = None,
        license_type: Union[str, "_models.ArcSqlManagedInstanceLicenseType"] = "BasePrice",
        cluster_id: Optional[str] = None,
        extension_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword data_controller_id: null.
        :paramtype data_controller_id: str
        :keyword admin: The instance admin user.
        :paramtype admin: str
        :keyword start_time: The instance start time.
        :paramtype start_time: str
        :keyword end_time: The instance end time.
        :paramtype end_time: str
        :keyword k8_s_raw: The raw kubernetes information.
        :paramtype k8_s_raw: ~azure.mgmt.azurearcdata.models.SqlManagedInstanceK8SRaw
        :keyword basic_login_information: Username and password for basic authentication.
        :paramtype basic_login_information: ~azure.mgmt.azurearcdata.models.BasicLoginInformation
        :keyword last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current
         date time.
        :paramtype last_uploaded_date: ~datetime.datetime
        :keyword active_directory_information: Active Directory information related to this SQL Managed
         Instance.
        :paramtype active_directory_information:
         ~azure.mgmt.azurearcdata.models.ActiveDirectoryInformation
        :keyword license_type: The license type to apply for this managed instance. Known values are:
         "BasePrice", "LicenseIncluded", and "DisasterRecovery".
        :paramtype license_type: str or
         ~azure.mgmt.azurearcdata.models.ArcSqlManagedInstanceLicenseType
        :keyword cluster_id: If a CustomLocation is provided, this contains the ARM id of the connected
         cluster the custom location belongs to.
        :paramtype cluster_id: str
        :keyword extension_id: If a CustomLocation is provided, this contains the ARM id of the
         extension the custom location belongs to.
        :paramtype extension_id: str
        """
        super().__init__(**kwargs)
        self.data_controller_id = data_controller_id
        self.admin = admin
        self.start_time = start_time
        self.end_time = end_time
        self.k8_s_raw = k8_s_raw
        self.basic_login_information = basic_login_information
        self.last_uploaded_date = last_uploaded_date
        self.provisioning_state = None
        self.active_directory_information = active_directory_information
        self.license_type = license_type
        self.cluster_id = cluster_id
        self.extension_id = extension_id


class SqlManagedInstanceSku(_serialization.Model):
    """The resource model definition representing SKU for Azure Managed Instance - Azure Arc.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the SKU. Required. Default value is "vCore".
    :vartype name: str
    :ivar tier: The pricing tier for the instance. Known values are: "GeneralPurpose" and
     "BusinessCritical".
    :vartype tier: str or ~azure.mgmt.azurearcdata.models.SqlManagedInstanceSkuTier
    :ivar dev: Whether dev/test is enabled. When the dev field is set to true, the resource is used
     for dev/test purpose.
    :vartype dev: bool
    :ivar size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :vartype size: str
    :ivar family: The SKU family.
    :vartype family: str
    :ivar capacity: The SKU capacity.
    :vartype capacity: int
    """

    _validation = {
        "name": {"required": True, "constant": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "dev": {"key": "dev", "type": "bool"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    name = "vCore"

    def __init__(
        self,
        *,
        tier: Union[str, "_models.SqlManagedInstanceSkuTier"] = "GeneralPurpose",
        dev: bool = True,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword tier: The pricing tier for the instance. Known values are: "GeneralPurpose" and
         "BusinessCritical".
        :paramtype tier: str or ~azure.mgmt.azurearcdata.models.SqlManagedInstanceSkuTier
        :keyword dev: Whether dev/test is enabled. When the dev field is set to true, the resource is
         used for dev/test purpose.
        :paramtype dev: bool
        :keyword size: The SKU size. When the name field is the combination of tier and some other
         value, this would be the standalone code.
        :paramtype size: str
        :keyword family: The SKU family.
        :paramtype family: str
        :keyword capacity: The SKU capacity.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.tier = tier
        self.dev = dev
        self.size = size
        self.family = family
        self.capacity = capacity


class SqlManagedInstanceUpdate(_serialization.Model):
    """An update to a SQL Managed Instance.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class SqlServerInstance(TrackedResource):
    """A SqlServerInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurearcdata.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: null.
    :vartype properties: ~azure.mgmt.azurearcdata.models.SqlServerInstanceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "SqlServerInstanceProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SqlServerInstanceProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: null.
        :paramtype properties: ~azure.mgmt.azurearcdata.models.SqlServerInstanceProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class SqlServerInstanceListResult(_serialization.Model):
    """A list of SqlServerInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.azurearcdata.models.SqlServerInstance]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SqlServerInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SqlServerInstanceProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties of SqlServerInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar version: SQL Server version. Known values are: "SQL Server 2012", "SQL Server 2014", "SQL
     Server 2016", "SQL Server 2017", "SQL Server 2019", "SQL Server 2022", and "Unknown".
    :vartype version: str or ~azure.mgmt.azurearcdata.models.SqlVersion
    :ivar edition: SQL Server edition. Known values are: "Evaluation", "Enterprise", "Standard",
     "Web", "Developer", and "Express".
    :vartype edition: str or ~azure.mgmt.azurearcdata.models.EditionType
    :ivar container_resource_id: ARM Resource id of the container resource (Azure Arc for Servers).
     Required.
    :vartype container_resource_id: str
    :ivar create_time: The time when the resource was created.
    :vartype create_time: str
    :ivar v_core: The number of logical processors used by the SQL Server instance.
    :vartype v_core: str
    :ivar status: The cloud connectivity status. Required. Known values are: "Connected",
     "Disconnected", "Registered", and "Unknown".
    :vartype status: str or ~azure.mgmt.azurearcdata.models.ConnectionStatus
    :ivar patch_level: SQL Server update level.
    :vartype patch_level: str
    :ivar collation: SQL Server collation.
    :vartype collation: str
    :ivar current_version: SQL Server current version.
    :vartype current_version: str
    :ivar instance_name: SQL Server instance name.
    :vartype instance_name: str
    :ivar tcp_dynamic_ports: Dynamic TCP ports used by SQL Server.
    :vartype tcp_dynamic_ports: str
    :ivar tcp_static_ports: Static TCP ports used by SQL Server.
    :vartype tcp_static_ports: str
    :ivar product_id: SQL Server product ID.
    :vartype product_id: str
    :ivar license_type: SQL Server license type. Known values are: "Undefined", "Free", "HADR",
     "ServerCAL", "LicenseOnly", "PAYG", and "Paid".
    :vartype license_type: str or ~azure.mgmt.azurearcdata.models.ArcSqlServerLicenseType
    :ivar azure_defender_status_last_updated: Timestamp of last Azure Defender status update.
    :vartype azure_defender_status_last_updated: ~datetime.datetime
    :ivar azure_defender_status: Status of Azure Defender. Known values are: "Protected",
     "Unprotected", and "Unknown".
    :vartype azure_defender_status: str or ~azure.mgmt.azurearcdata.models.DefenderStatus
    :ivar provisioning_state: The provisioning state of the Arc-enabled SQL Server resource.
    :vartype provisioning_state: str
    :ivar host_type: Type of host for Azure Arc SQL Server. Known values are: "Azure Virtual
     Machine", "Azure VMWare Virtual Machine", "Azure Kubernetes Service", "AWS VMWare Virtual
     Machine", "AWS Kubernetes Service", "GCP VMWare Virtual Machine", "GCP Kubernetes Service",
     "Container", "Virtual Machine", "Physical Server", "AWS Virtual Machine", "GCP Virtual
     Machine", and "Other".
    :vartype host_type: str or ~azure.mgmt.azurearcdata.models.HostType
    """

    _validation = {
        "container_resource_id": {"required": True},
        "create_time": {"readonly": True},
        "status": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "edition": {"key": "edition", "type": "str"},
        "container_resource_id": {"key": "containerResourceId", "type": "str"},
        "create_time": {"key": "createTime", "type": "str"},
        "v_core": {"key": "vCore", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "patch_level": {"key": "patchLevel", "type": "str"},
        "collation": {"key": "collation", "type": "str"},
        "current_version": {"key": "currentVersion", "type": "str"},
        "instance_name": {"key": "instanceName", "type": "str"},
        "tcp_dynamic_ports": {"key": "tcpDynamicPorts", "type": "str"},
        "tcp_static_ports": {"key": "tcpStaticPorts", "type": "str"},
        "product_id": {"key": "productId", "type": "str"},
        "license_type": {"key": "licenseType", "type": "str"},
        "azure_defender_status_last_updated": {"key": "azureDefenderStatusLastUpdated", "type": "iso-8601"},
        "azure_defender_status": {"key": "azureDefenderStatus", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "host_type": {"key": "hostType", "type": "str"},
    }

    def __init__(
        self,
        *,
        container_resource_id: str,
        status: Union[str, "_models.ConnectionStatus"],
        version: Optional[Union[str, "_models.SqlVersion"]] = None,
        edition: Optional[Union[str, "_models.EditionType"]] = None,
        v_core: Optional[str] = None,
        patch_level: Optional[str] = None,
        collation: Optional[str] = None,
        current_version: Optional[str] = None,
        instance_name: Optional[str] = None,
        tcp_dynamic_ports: Optional[str] = None,
        tcp_static_ports: Optional[str] = None,
        product_id: Optional[str] = None,
        license_type: Optional[Union[str, "_models.ArcSqlServerLicenseType"]] = None,
        azure_defender_status_last_updated: Optional[datetime.datetime] = None,
        azure_defender_status: Optional[Union[str, "_models.DefenderStatus"]] = None,
        host_type: Optional[Union[str, "_models.HostType"]] = None,
        **kwargs
    ):
        """
        :keyword version: SQL Server version. Known values are: "SQL Server 2012", "SQL Server 2014",
         "SQL Server 2016", "SQL Server 2017", "SQL Server 2019", "SQL Server 2022", and "Unknown".
        :paramtype version: str or ~azure.mgmt.azurearcdata.models.SqlVersion
        :keyword edition: SQL Server edition. Known values are: "Evaluation", "Enterprise", "Standard",
         "Web", "Developer", and "Express".
        :paramtype edition: str or ~azure.mgmt.azurearcdata.models.EditionType
        :keyword container_resource_id: ARM Resource id of the container resource (Azure Arc for
         Servers). Required.
        :paramtype container_resource_id: str
        :keyword v_core: The number of logical processors used by the SQL Server instance.
        :paramtype v_core: str
        :keyword status: The cloud connectivity status. Required. Known values are: "Connected",
         "Disconnected", "Registered", and "Unknown".
        :paramtype status: str or ~azure.mgmt.azurearcdata.models.ConnectionStatus
        :keyword patch_level: SQL Server update level.
        :paramtype patch_level: str
        :keyword collation: SQL Server collation.
        :paramtype collation: str
        :keyword current_version: SQL Server current version.
        :paramtype current_version: str
        :keyword instance_name: SQL Server instance name.
        :paramtype instance_name: str
        :keyword tcp_dynamic_ports: Dynamic TCP ports used by SQL Server.
        :paramtype tcp_dynamic_ports: str
        :keyword tcp_static_ports: Static TCP ports used by SQL Server.
        :paramtype tcp_static_ports: str
        :keyword product_id: SQL Server product ID.
        :paramtype product_id: str
        :keyword license_type: SQL Server license type. Known values are: "Undefined", "Free", "HADR",
         "ServerCAL", "LicenseOnly", "PAYG", and "Paid".
        :paramtype license_type: str or ~azure.mgmt.azurearcdata.models.ArcSqlServerLicenseType
        :keyword azure_defender_status_last_updated: Timestamp of last Azure Defender status update.
        :paramtype azure_defender_status_last_updated: ~datetime.datetime
        :keyword azure_defender_status: Status of Azure Defender. Known values are: "Protected",
         "Unprotected", and "Unknown".
        :paramtype azure_defender_status: str or ~azure.mgmt.azurearcdata.models.DefenderStatus
        :keyword host_type: Type of host for Azure Arc SQL Server. Known values are: "Azure Virtual
         Machine", "Azure VMWare Virtual Machine", "Azure Kubernetes Service", "AWS VMWare Virtual
         Machine", "AWS Kubernetes Service", "GCP VMWare Virtual Machine", "GCP Kubernetes Service",
         "Container", "Virtual Machine", "Physical Server", "AWS Virtual Machine", "GCP Virtual
         Machine", and "Other".
        :paramtype host_type: str or ~azure.mgmt.azurearcdata.models.HostType
        """
        super().__init__(**kwargs)
        self.version = version
        self.edition = edition
        self.container_resource_id = container_resource_id
        self.create_time = None
        self.v_core = v_core
        self.status = status
        self.patch_level = patch_level
        self.collation = collation
        self.current_version = current_version
        self.instance_name = instance_name
        self.tcp_dynamic_ports = tcp_dynamic_ports
        self.tcp_static_ports = tcp_static_ports
        self.product_id = product_id
        self.license_type = license_type
        self.azure_defender_status_last_updated = azure_defender_status_last_updated
        self.azure_defender_status = azure_defender_status
        self.provisioning_state = None
        self.host_type = host_type


class SqlServerInstanceUpdate(_serialization.Model):
    """An update to a SQL Server Instance.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.azurearcdata.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.azurearcdata.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.azurearcdata.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.azurearcdata.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UploadServicePrincipal(_serialization.Model):
    """Service principal for uploading billing, metrics and logs.

    :ivar client_id: Client ID of the service principal for uploading data.
    :vartype client_id: str
    :ivar tenant_id: Tenant ID of the service principal.
    :vartype tenant_id: str
    :ivar authority: Authority for the service principal. Example:
     https://login.microsoftonline.com/.
    :vartype authority: str
    :ivar client_secret: Secret of the service principal.
    :vartype client_secret: str
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "authority": {"key": "authority", "type": "str"},
        "client_secret": {"key": "clientSecret", "type": "str"},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        authority: Optional[str] = None,
        client_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword client_id: Client ID of the service principal for uploading data.
        :paramtype client_id: str
        :keyword tenant_id: Tenant ID of the service principal.
        :paramtype tenant_id: str
        :keyword authority: Authority for the service principal. Example:
         https://login.microsoftonline.com/.
        :paramtype authority: str
        :keyword client_secret: Secret of the service principal.
        :paramtype client_secret: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.tenant_id = tenant_id
        self.authority = authority
        self.client_secret = client_secret


class UploadWatermark(_serialization.Model):
    """Properties on upload watermark.  Mostly timestamp for each upload data type.

    :ivar metrics: Last uploaded date for metrics from kubernetes cluster. Defaults to current date
     time.
    :vartype metrics: ~datetime.datetime
    :ivar logs: Last uploaded date for logs from kubernetes cluster. Defaults to current date time.
    :vartype logs: ~datetime.datetime
    :ivar usages: Last uploaded date for usages from kubernetes cluster. Defaults to current date
     time.
    :vartype usages: ~datetime.datetime
    """

    _attribute_map = {
        "metrics": {"key": "metrics", "type": "iso-8601"},
        "logs": {"key": "logs", "type": "iso-8601"},
        "usages": {"key": "usages", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        metrics: Optional[datetime.datetime] = None,
        logs: Optional[datetime.datetime] = None,
        usages: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword metrics: Last uploaded date for metrics from kubernetes cluster. Defaults to current
         date time.
        :paramtype metrics: ~datetime.datetime
        :keyword logs: Last uploaded date for logs from kubernetes cluster. Defaults to current date
         time.
        :paramtype logs: ~datetime.datetime
        :keyword usages: Last uploaded date for usages from kubernetes cluster. Defaults to current
         date time.
        :paramtype usages: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.metrics = metrics
        self.logs = logs
        self.usages = usages
