# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .service_partition_info import ServicePartitionInfo


class StatefulServicePartitionInfo(ServicePartitionInfo):
    """Information about a partition of a stateful Service Fabric service..

    :param health_state: Possible values include: 'Invalid', 'Ok', 'Warning',
     'Error', 'Unknown'
    :type health_state: str
    :param partition_status: Possible values include: 'Invalid', 'Ready',
     'NotReady', 'InQuorumLoss', 'Reconfiguring', 'Deleting'
    :type partition_status: str
    :param partition_information:
    :type partition_information: :class:`PartitionInformation
     <azure.servicefabric.models.PartitionInformation>`
    :param ServiceKind: Polymorphic Discriminator
    :type ServiceKind: str
    :param target_replica_set_size: The target replica set size as a number.
    :type target_replica_set_size: long
    :param min_replica_set_size: The minimum replica set size as a number.
    :type min_replica_set_size: long
    :param last_quorum_loss_duration: The duration for which this partition
     was in quorum loss. If the partition is currently in quorum loss, it
     returns the duration since it has been in that state. This field is
     using ISO8601 format for specifying the duration.
    :type last_quorum_loss_duration: timedelta
    :param current_configuration_epoch:
    :type current_configuration_epoch: :class:`Epoch
     <azure.servicefabric.models.Epoch>`
    """ 

    _validation = {
        'ServiceKind': {'required': True},
    }

    _attribute_map = {
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'partition_status': {'key': 'PartitionStatus', 'type': 'str'},
        'partition_information': {'key': 'PartitionInformation', 'type': 'PartitionInformation'},
        'ServiceKind': {'key': 'ServiceKind', 'type': 'str'},
        'target_replica_set_size': {'key': 'TargetReplicaSetSize', 'type': 'long'},
        'min_replica_set_size': {'key': 'MinReplicaSetSize', 'type': 'long'},
        'last_quorum_loss_duration': {'key': 'LastQuorumLossDuration', 'type': 'duration'},
        'current_configuration_epoch': {'key': 'CurrentConfigurationEpoch', 'type': 'Epoch'},
    }

    def __init__(self, health_state=None, partition_status=None, partition_information=None, target_replica_set_size=None, min_replica_set_size=None, last_quorum_loss_duration=None, current_configuration_epoch=None):
        super(StatefulServicePartitionInfo, self).__init__(health_state=health_state, partition_status=partition_status, partition_information=partition_information)
        self.target_replica_set_size = target_replica_set_size
        self.min_replica_set_size = min_replica_set_size
        self.last_quorum_loss_duration = last_quorum_loss_duration
        self.current_configuration_epoch = current_configuration_epoch
        self.ServiceKind = 'Stateful'
