# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VirtualMachineConfiguration(Model):
    """The configuration for compute nodes in a pool based on the Azure Virtual
    Machines infrastructure.

    :param image_reference: A reference to the Azure Virtual Machines
     Marketplace image to use. This property and osDisk are mutually exclusive
     and one of the properties must be specified.
    :type image_reference: :class:`ImageReference
     <azure.batch.models.ImageReference>`
    :param os_disk: A reference to the OS disk image to use. This property can
     be specified only if the Batch account was created with its
     poolAllocationMode property set to 'UserSubscription'. This property and
     imageReference are mutually exclusive and one of the properties must be
     specified.
    :type os_disk: :class:`OSDisk <azure.batch.models.OSDisk>`
    :param node_agent_sku_id: The SKU of the Batch node agent to be
     provisioned on compute nodes in the pool. The Batch node agent is a
     program that runs on each node in the pool, and provides the
     command-and-control interface between the node and the Batch service.
     There are different implementations of the node agent, known as SKUs, for
     different operating systems. You must specify a node agent SKU which
     matches the selected image reference. To get the list of supported node
     agent SKUs along with their list of verified image references, see the
     'List supported node agent SKUs' operation.
    :type node_agent_sku_id: str
    :param windows_configuration: Windows operating system settings on the
     virtual machine. This property must not be specified if the imageReference
     or osDisk property specifies a Linux OS image.
    :type windows_configuration: :class:`WindowsConfiguration
     <azure.batch.models.WindowsConfiguration>`
    """

    _validation = {
        'node_agent_sku_id': {'required': True},
    }

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'os_disk': {'key': 'osDisk', 'type': 'OSDisk'},
        'node_agent_sku_id': {'key': 'nodeAgentSKUId', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
    }

    def __init__(self, node_agent_sku_id, image_reference=None, os_disk=None, windows_configuration=None):
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.node_agent_sku_id = node_agent_sku_id
        self.windows_configuration = windows_configuration
