"""
Streamgraph
-----------------
This example shows the streamgraph from vega-lite examples.
"""
# category: area charts
import altair as alt
from vega_datasets import data

source = data.unemployment_across_industries.url

alt.Chart(source).mark_area().encode(
    alt.X('yearmonth(date):T').axis(format='%Y', domain=False, tickSize=0),
    alt.Y('sum(count):Q').stack('center').axis(None),
    alt.Color('series:N').scale(scheme='category20b')
).interactive()
