#############################################################################
##
## Copyright (C) 2018 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the simplified signatures for all functions in PySide
for module 'exists_win32_5_14_0_ci' using
Python 3.6.1 (v3.6.1:69c0db5, Mar 21 2017, 17:54:52) [MSC v.1900 32 bit (Intel)]
Qt 5.14.0 (i386-little_endian-ilp32 shared (dynamic) release build; by MSVC 2017)

There are no default values, no variable names and no self
parameter. Only types are present after simplification. The
functions 'next' resp. '__next__' are removed to make the output
identical for Python 2 and 3. '__div__' is also removed,
since it exists in Python 2, only.
"""

import sys

sig_dict = {}

# Module PySide2.QtCore
sig_dict.update({

# class PySide2.QtCore.ClassInfo:
    "PySide2.QtCore.ClassInfo.__init__": ('typing.Dict',),

# class PySide2.QtCore.MetaFunction:
    "PySide2.QtCore.MetaFunction.__call__": ('typing.Any',),

# class PySide2.QtCore.MetaSignal:
    "PySide2.QtCore.MetaSignal.__instancecheck__": ('object',),

# class PySide2.QtCore.Property:
    "PySide2.QtCore.Property.__init__": ('type', 'typing.Callable', 'typing.Callable', 'typing.Callable', 'typing.Callable', 'str', 'typing.Callable', 'bool', 'bool', 'bool', 'bool', 'bool', 'bool'),
    "PySide2.QtCore.Property.getter": ('typing.Callable',),
    "PySide2.QtCore.Property.read": ('typing.Callable',),
    "PySide2.QtCore.Property.setter": ('typing.Callable',),
    "PySide2.QtCore.Property.write": ('typing.Callable',),

# class PySide2.QtCore.QAbstractAnimation:

# class PySide2.QtCore.QAbstractAnimation.DeletionPolicy:

# class PySide2.QtCore.QAbstractAnimation.Direction:

# class PySide2.QtCore.QAbstractAnimation.State:
    "PySide2.QtCore.QAbstractAnimation.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QAbstractAnimation.currentLoop": (),
    "PySide2.QtCore.QAbstractAnimation.currentLoopTime": (),
    "PySide2.QtCore.QAbstractAnimation.currentTime": (),
    "PySide2.QtCore.QAbstractAnimation.direction": (),
    "PySide2.QtCore.QAbstractAnimation.duration": (),
    "PySide2.QtCore.QAbstractAnimation.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QAbstractAnimation.group": (),
    "PySide2.QtCore.QAbstractAnimation.loopCount": (),
    "PySide2.QtCore.QAbstractAnimation.pause": (),
    "PySide2.QtCore.QAbstractAnimation.resume": (),
    "PySide2.QtCore.QAbstractAnimation.setCurrentTime": ('int',),
    "PySide2.QtCore.QAbstractAnimation.setDirection": ('PySide2.QtCore.QAbstractAnimation.Direction',),
    "PySide2.QtCore.QAbstractAnimation.setLoopCount": ('int',),
    "PySide2.QtCore.QAbstractAnimation.setPaused": ('bool',),
    "PySide2.QtCore.QAbstractAnimation.start": ('PySide2.QtCore.QAbstractAnimation.DeletionPolicy',),
    "PySide2.QtCore.QAbstractAnimation.state": (),
    "PySide2.QtCore.QAbstractAnimation.stop": (),
    "PySide2.QtCore.QAbstractAnimation.totalDuration": (),
    "PySide2.QtCore.QAbstractAnimation.updateCurrentTime": ('int',),
    "PySide2.QtCore.QAbstractAnimation.updateDirection": ('PySide2.QtCore.QAbstractAnimation.Direction',),
    "PySide2.QtCore.QAbstractAnimation.updateState": ('PySide2.QtCore.QAbstractAnimation.State', 'PySide2.QtCore.QAbstractAnimation.State'),

# class PySide2.QtCore.QAbstractEventDispatcher:

# class PySide2.QtCore.QAbstractEventDispatcher.TimerInfo:
    "PySide2.QtCore.QAbstractEventDispatcher.TimerInfo.__init__": ('int', 'int', 'PySide2.QtCore.Qt.TimerType'),

    "PySide2.QtCore.QAbstractEventDispatcher.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QAbstractEventDispatcher.closingDown": (),
    "PySide2.QtCore.QAbstractEventDispatcher.filterNativeEvent": ('PySide2.QtCore.QByteArray', 'int'),
    "PySide2.QtCore.QAbstractEventDispatcher.flush": (),
    "PySide2.QtCore.QAbstractEventDispatcher.hasPendingEvents": (),
    "PySide2.QtCore.QAbstractEventDispatcher.installNativeEventFilter": ('PySide2.QtCore.QAbstractNativeEventFilter',),
    "PySide2.QtCore.QAbstractEventDispatcher.instance": ('PySide2.QtCore.QThread',),
    "PySide2.QtCore.QAbstractEventDispatcher.interrupt": (),
    "PySide2.QtCore.QAbstractEventDispatcher.processEvents": ('PySide2.QtCore.QEventLoop.ProcessEventsFlags',),
    "PySide2.QtCore.QAbstractEventDispatcher.registerEventNotifier": ('PySide2.QtCore.QWinEventNotifier',),
    "PySide2.QtCore.QAbstractEventDispatcher.registerSocketNotifier": ('PySide2.QtCore.QSocketNotifier',),
    "PySide2.QtCore.QAbstractEventDispatcher.registerTimer": [('int', 'PySide2.QtCore.Qt.TimerType', 'PySide2.QtCore.QObject'), ('int', 'int', 'PySide2.QtCore.Qt.TimerType', 'PySide2.QtCore.QObject')],
    "PySide2.QtCore.QAbstractEventDispatcher.registeredTimers": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QAbstractEventDispatcher.remainingTime": ('int',),
    "PySide2.QtCore.QAbstractEventDispatcher.removeNativeEventFilter": ('PySide2.QtCore.QAbstractNativeEventFilter',),
    "PySide2.QtCore.QAbstractEventDispatcher.startingUp": (),
    "PySide2.QtCore.QAbstractEventDispatcher.unregisterEventNotifier": ('PySide2.QtCore.QWinEventNotifier',),
    "PySide2.QtCore.QAbstractEventDispatcher.unregisterSocketNotifier": ('PySide2.QtCore.QSocketNotifier',),
    "PySide2.QtCore.QAbstractEventDispatcher.unregisterTimer": ('int',),
    "PySide2.QtCore.QAbstractEventDispatcher.unregisterTimers": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QAbstractEventDispatcher.wakeUp": (),

# class PySide2.QtCore.QAbstractItemModel:

# class PySide2.QtCore.QAbstractItemModel.CheckIndexOption:

# class PySide2.QtCore.QAbstractItemModel.CheckIndexOptions:

# class PySide2.QtCore.QAbstractItemModel.LayoutChangeHint:
    "PySide2.QtCore.QAbstractItemModel.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QAbstractItemModel.beginInsertColumns": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtCore.QAbstractItemModel.beginInsertRows": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtCore.QAbstractItemModel.beginMoveColumns": ('PySide2.QtCore.QModelIndex', 'int', 'int', 'PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtCore.QAbstractItemModel.beginMoveRows": ('PySide2.QtCore.QModelIndex', 'int', 'int', 'PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtCore.QAbstractItemModel.beginRemoveColumns": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtCore.QAbstractItemModel.beginRemoveRows": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtCore.QAbstractItemModel.beginResetModel": (),
    "PySide2.QtCore.QAbstractItemModel.buddy": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractItemModel.canDropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractItemModel.canFetchMore": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractItemModel.changePersistentIndex": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractItemModel.changePersistentIndexList": ('typing.List', 'typing.List'),
    "PySide2.QtCore.QAbstractItemModel.checkIndex": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QAbstractItemModel.CheckIndexOptions'),
    "PySide2.QtCore.QAbstractItemModel.columnCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractItemModel.createIndex": [('int', 'int', 'int'), ('int', 'int', 'object')],
    "PySide2.QtCore.QAbstractItemModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtCore.QAbstractItemModel.decodeData": ('int', 'int', 'PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QDataStream'),
    "PySide2.QtCore.QAbstractItemModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractItemModel.encodeData": ('typing.List', 'PySide2.QtCore.QDataStream'),
    "PySide2.QtCore.QAbstractItemModel.endInsertColumns": (),
    "PySide2.QtCore.QAbstractItemModel.endInsertRows": (),
    "PySide2.QtCore.QAbstractItemModel.endMoveColumns": (),
    "PySide2.QtCore.QAbstractItemModel.endMoveRows": (),
    "PySide2.QtCore.QAbstractItemModel.endRemoveColumns": (),
    "PySide2.QtCore.QAbstractItemModel.endRemoveRows": (),
    "PySide2.QtCore.QAbstractItemModel.endResetModel": (),
    "PySide2.QtCore.QAbstractItemModel.fetchMore": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractItemModel.flags": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractItemModel.hasChildren": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractItemModel.hasIndex": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractItemModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
    "PySide2.QtCore.QAbstractItemModel.index": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractItemModel.insertColumn": ('int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractItemModel.insertColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractItemModel.insertRow": ('int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractItemModel.insertRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractItemModel.itemData": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractItemModel.match": ('PySide2.QtCore.QModelIndex', 'int', 'typing.Any', 'int', 'PySide2.QtCore.Qt.MatchFlags'),
    "PySide2.QtCore.QAbstractItemModel.mimeData": ('typing.List',),
    "PySide2.QtCore.QAbstractItemModel.mimeTypes": (),
    "PySide2.QtCore.QAbstractItemModel.moveColumn": ('PySide2.QtCore.QModelIndex', 'int', 'PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtCore.QAbstractItemModel.moveColumns": ('PySide2.QtCore.QModelIndex', 'int', 'int', 'PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtCore.QAbstractItemModel.moveRow": ('PySide2.QtCore.QModelIndex', 'int', 'PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtCore.QAbstractItemModel.moveRows": ('PySide2.QtCore.QModelIndex', 'int', 'int', 'PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtCore.QAbstractItemModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
    "PySide2.QtCore.QAbstractItemModel.persistentIndexList": (),
    "PySide2.QtCore.QAbstractItemModel.removeColumn": ('int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractItemModel.removeColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractItemModel.removeRow": ('int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractItemModel.removeRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractItemModel.resetInternalData": (),
    "PySide2.QtCore.QAbstractItemModel.revert": (),
    "PySide2.QtCore.QAbstractItemModel.roleNames": (),
    "PySide2.QtCore.QAbstractItemModel.rowCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractItemModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
    "PySide2.QtCore.QAbstractItemModel.setHeaderData": ('int', 'PySide2.QtCore.Qt.Orientation', 'typing.Any', 'int'),
    "PySide2.QtCore.QAbstractItemModel.setItemData": ('PySide2.QtCore.QModelIndex', 'typing.Dict'),
    "PySide2.QtCore.QAbstractItemModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractItemModel.sort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
    "PySide2.QtCore.QAbstractItemModel.span": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractItemModel.submit": (),
    "PySide2.QtCore.QAbstractItemModel.supportedDragActions": (),
    "PySide2.QtCore.QAbstractItemModel.supportedDropActions": (),

# class PySide2.QtCore.QAbstractListModel:
    "PySide2.QtCore.QAbstractListModel.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QAbstractListModel.columnCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractListModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractListModel.flags": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractListModel.hasChildren": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractListModel.index": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractListModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
    "PySide2.QtCore.QAbstractListModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),

# class PySide2.QtCore.QAbstractNativeEventFilter:
    "PySide2.QtCore.QAbstractNativeEventFilter.__init__": (),
    "PySide2.QtCore.QAbstractNativeEventFilter.nativeEventFilter": ('PySide2.QtCore.QByteArray', 'int'),

# class PySide2.QtCore.QAbstractProxyModel:
    "PySide2.QtCore.QAbstractProxyModel.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QAbstractProxyModel.buddy": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractProxyModel.canDropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractProxyModel.canFetchMore": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractProxyModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtCore.QAbstractProxyModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractProxyModel.fetchMore": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractProxyModel.flags": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractProxyModel.hasChildren": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractProxyModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
    "PySide2.QtCore.QAbstractProxyModel.itemData": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractProxyModel.mapFromSource": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractProxyModel.mapSelectionFromSource": ('PySide2.QtCore.QItemSelection',),
    "PySide2.QtCore.QAbstractProxyModel.mapSelectionToSource": ('PySide2.QtCore.QItemSelection',),
    "PySide2.QtCore.QAbstractProxyModel.mapToSource": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractProxyModel.mimeData": ('typing.List',),
    "PySide2.QtCore.QAbstractProxyModel.mimeTypes": (),
    "PySide2.QtCore.QAbstractProxyModel.resetInternalData": (),
    "PySide2.QtCore.QAbstractProxyModel.revert": (),
    "PySide2.QtCore.QAbstractProxyModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
    "PySide2.QtCore.QAbstractProxyModel.setHeaderData": ('int', 'PySide2.QtCore.Qt.Orientation', 'typing.Any', 'int'),
    "PySide2.QtCore.QAbstractProxyModel.setItemData": ('PySide2.QtCore.QModelIndex', 'typing.Dict'),
    "PySide2.QtCore.QAbstractProxyModel.setSourceModel": ('PySide2.QtCore.QAbstractItemModel',),
    "PySide2.QtCore.QAbstractProxyModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractProxyModel.sort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
    "PySide2.QtCore.QAbstractProxyModel.sourceModel": (),
    "PySide2.QtCore.QAbstractProxyModel.span": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractProxyModel.submit": (),
    "PySide2.QtCore.QAbstractProxyModel.supportedDragActions": (),
    "PySide2.QtCore.QAbstractProxyModel.supportedDropActions": (),

# class PySide2.QtCore.QAbstractState:
    "PySide2.QtCore.QAbstractState.__init__": ('PySide2.QtCore.QState',),
    "PySide2.QtCore.QAbstractState.active": (),
    "PySide2.QtCore.QAbstractState.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QAbstractState.machine": (),
    "PySide2.QtCore.QAbstractState.onEntry": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QAbstractState.onExit": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QAbstractState.parentState": (),

# class PySide2.QtCore.QAbstractTableModel:
    "PySide2.QtCore.QAbstractTableModel.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QAbstractTableModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractTableModel.flags": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractTableModel.hasChildren": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QAbstractTableModel.index": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QAbstractTableModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
    "PySide2.QtCore.QAbstractTableModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),

# class PySide2.QtCore.QAbstractTransition:

# class PySide2.QtCore.QAbstractTransition.TransitionType:
    "PySide2.QtCore.QAbstractTransition.__init__": ('PySide2.QtCore.QState',),
    "PySide2.QtCore.QAbstractTransition.addAnimation": ('PySide2.QtCore.QAbstractAnimation',),
    "PySide2.QtCore.QAbstractTransition.animations": (),
    "PySide2.QtCore.QAbstractTransition.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QAbstractTransition.eventTest": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QAbstractTransition.machine": (),
    "PySide2.QtCore.QAbstractTransition.onTransition": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QAbstractTransition.removeAnimation": ('PySide2.QtCore.QAbstractAnimation',),
    "PySide2.QtCore.QAbstractTransition.setTargetState": ('PySide2.QtCore.QAbstractState',),
    "PySide2.QtCore.QAbstractTransition.setTargetStates": ('typing.Sequence',),
    "PySide2.QtCore.QAbstractTransition.setTransitionType": ('PySide2.QtCore.QAbstractTransition.TransitionType',),
    "PySide2.QtCore.QAbstractTransition.sourceState": (),
    "PySide2.QtCore.QAbstractTransition.targetState": (),
    "PySide2.QtCore.QAbstractTransition.targetStates": (),
    "PySide2.QtCore.QAbstractTransition.transitionType": (),

# class PySide2.QtCore.QAnimationGroup:
    "PySide2.QtCore.QAnimationGroup.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QAnimationGroup.addAnimation": ('PySide2.QtCore.QAbstractAnimation',),
    "PySide2.QtCore.QAnimationGroup.animationAt": ('int',),
    "PySide2.QtCore.QAnimationGroup.animationCount": (),
    "PySide2.QtCore.QAnimationGroup.clear": (),
    "PySide2.QtCore.QAnimationGroup.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QAnimationGroup.indexOfAnimation": ('PySide2.QtCore.QAbstractAnimation',),
    "PySide2.QtCore.QAnimationGroup.insertAnimation": ('int', 'PySide2.QtCore.QAbstractAnimation'),
    "PySide2.QtCore.QAnimationGroup.removeAnimation": ('PySide2.QtCore.QAbstractAnimation',),
    "PySide2.QtCore.QAnimationGroup.takeAnimation": ('int',),

# class PySide2.QtCore.QBasicMutex:
    "PySide2.QtCore.QBasicMutex.__init__": (),
    "PySide2.QtCore.QBasicMutex.isRecursive": (),
    "PySide2.QtCore.QBasicMutex.lock": (),
    "PySide2.QtCore.QBasicMutex.tryLock": (),
    "PySide2.QtCore.QBasicMutex.try_lock": (),
    "PySide2.QtCore.QBasicMutex.unlock": (),

# class PySide2.QtCore.QBasicTimer:
    "PySide2.QtCore.QBasicTimer.__init__": [(), ('PySide2.QtCore.QBasicTimer',)],
    "PySide2.QtCore.QBasicTimer.__copy__": (),
    "PySide2.QtCore.QBasicTimer.isActive": (),
    "PySide2.QtCore.QBasicTimer.start": [('int', 'PySide2.QtCore.QObject'), ('int', 'PySide2.QtCore.Qt.TimerType', 'PySide2.QtCore.QObject')],
    "PySide2.QtCore.QBasicTimer.stop": (),
    "PySide2.QtCore.QBasicTimer.swap": ('PySide2.QtCore.QBasicTimer',),
    "PySide2.QtCore.QBasicTimer.timerId": (),

# class PySide2.QtCore.QBitArray:
    "PySide2.QtCore.QBitArray.__init__": [(), ('PySide2.QtCore.QBitArray',), ('int', 'bool')],
    "PySide2.QtCore.QBitArray.__and__": ('PySide2.QtCore.QBitArray',),
    "PySide2.QtCore.QBitArray.__copy__": (),
    "PySide2.QtCore.QBitArray.__iand__": ('PySide2.QtCore.QBitArray',),
    "PySide2.QtCore.QBitArray.__invert__": (),
    "PySide2.QtCore.QBitArray.__ior__": ('PySide2.QtCore.QBitArray',),
    "PySide2.QtCore.QBitArray.__ixor__": ('PySide2.QtCore.QBitArray',),
    "PySide2.QtCore.QBitArray.__or__": ('PySide2.QtCore.QBitArray',),
    "PySide2.QtCore.QBitArray.__xor__": ('PySide2.QtCore.QBitArray',),
    "PySide2.QtCore.QBitArray.at": ('int',),
    "PySide2.QtCore.QBitArray.bits": (),
    "PySide2.QtCore.QBitArray.clear": (),
    "PySide2.QtCore.QBitArray.clearBit": ('int',),
    "PySide2.QtCore.QBitArray.count": [(), ('bool',)],
    "PySide2.QtCore.QBitArray.fill": [('bool', 'int'), ('bool', 'int', 'int')],
    "PySide2.QtCore.QBitArray.fromBits": ('bytes', 'int'),
    "PySide2.QtCore.QBitArray.isEmpty": (),
    "PySide2.QtCore.QBitArray.isNull": (),
    "PySide2.QtCore.QBitArray.resize": ('int',),
    "PySide2.QtCore.QBitArray.setBit": [('int',), ('int', 'bool')],
    "PySide2.QtCore.QBitArray.size": (),
    "PySide2.QtCore.QBitArray.swap": ('PySide2.QtCore.QBitArray',),
    "PySide2.QtCore.QBitArray.testBit": ('int',),
    "PySide2.QtCore.QBitArray.toggleBit": ('int',),
    "PySide2.QtCore.QBitArray.truncate": ('int',),

# class PySide2.QtCore.QBuffer:
    "PySide2.QtCore.QBuffer.__init__": [('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QObject'), ('PySide2.QtCore.QObject',)],
    "PySide2.QtCore.QBuffer.atEnd": (),
    "PySide2.QtCore.QBuffer.buffer": (),
    "PySide2.QtCore.QBuffer.canReadLine": (),
    "PySide2.QtCore.QBuffer.close": (),
    "PySide2.QtCore.QBuffer.connectNotify": ('PySide2.QtCore.QMetaMethod',),
    "PySide2.QtCore.QBuffer.data": (),
    "PySide2.QtCore.QBuffer.disconnectNotify": ('PySide2.QtCore.QMetaMethod',),
    "PySide2.QtCore.QBuffer.open": ('PySide2.QtCore.QIODevice.OpenMode',),
    "PySide2.QtCore.QBuffer.pos": (),
    "PySide2.QtCore.QBuffer.readData": ('bytes', 'int'),
    "PySide2.QtCore.QBuffer.seek": ('int',),
    "PySide2.QtCore.QBuffer.setBuffer": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtCore.QBuffer.setData": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtCore.QBuffer.size": (),
    "PySide2.QtCore.QBuffer.writeData": ('bytes', 'int'),

# class PySide2.QtCore.QByteArray:

# class PySide2.QtCore.QByteArray.Base64Option:

# class PySide2.QtCore.QByteArray.Base64Options:
    "PySide2.QtCore.QByteArray.__init__": [(), ('PySide2.QtCore.QByteArray',), ('bytearray',), ('bytes',), ('int', 'typing.Char')],
    "PySide2.QtCore.QByteArray.__add__": [('PySide2.QtCore.QByteArray',), ('bytearray',), ('bytes',), ('typing.Char',)],
    "PySide2.QtCore.QByteArray.__copy__": (),
    "PySide2.QtCore.QByteArray.__iadd__": [('PySide2.QtCore.QByteArray',), ('bytearray',), ('typing.Char',)],
    "PySide2.QtCore.QByteArray.__reduce__": (),
    "PySide2.QtCore.QByteArray.__repr__": (),
    "PySide2.QtCore.QByteArray.__str__": (),
    "PySide2.QtCore.QByteArray.append": [('PySide2.QtCore.QByteArray',), ('int', 'typing.Char'), ('typing.Char',)],
    "PySide2.QtCore.QByteArray.at": ('int',),
    "PySide2.QtCore.QByteArray.back": (),
    "PySide2.QtCore.QByteArray.capacity": (),
    "PySide2.QtCore.QByteArray.cbegin": (),
    "PySide2.QtCore.QByteArray.cend": (),
    "PySide2.QtCore.QByteArray.chop": ('int',),
    "PySide2.QtCore.QByteArray.chopped": ('int',),
    "PySide2.QtCore.QByteArray.clear": (),
    "PySide2.QtCore.QByteArray.compare": [('PySide2.QtCore.QByteArray', 'PySide2.QtCore.Qt.CaseSensitivity'), ('bytes', 'PySide2.QtCore.Qt.CaseSensitivity')],
    "PySide2.QtCore.QByteArray.contains": [('PySide2.QtCore.QByteArray',), ('typing.Char',)],
    "PySide2.QtCore.QByteArray.count": [(), ('PySide2.QtCore.QByteArray',), ('typing.Char',)],
    "PySide2.QtCore.QByteArray.data": (),
    "PySide2.QtCore.QByteArray.endsWith": [('PySide2.QtCore.QByteArray',), ('typing.Char',)],
    "PySide2.QtCore.QByteArray.fill": ('typing.Char', 'int'),
    "PySide2.QtCore.QByteArray.fromBase64": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray.Base64Options')],
    "PySide2.QtCore.QByteArray.fromHex": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtCore.QByteArray.fromPercentEncoding": ('PySide2.QtCore.QByteArray', 'typing.Char'),
    "PySide2.QtCore.QByteArray.fromRawData": ('bytes', 'int'),
    "PySide2.QtCore.QByteArray.front": (),
    "PySide2.QtCore.QByteArray.indexOf": ('PySide2.QtCore.QByteArray', 'int'),
    "PySide2.QtCore.QByteArray.insert": [('int', 'PySide2.QtCore.QByteArray'), ('int', 'int', 'typing.Char')],
    "PySide2.QtCore.QByteArray.isEmpty": (),
    "PySide2.QtCore.QByteArray.isLower": (),
    "PySide2.QtCore.QByteArray.isNull": (),
    "PySide2.QtCore.QByteArray.isSharedWith": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtCore.QByteArray.isUpper": (),
    "PySide2.QtCore.QByteArray.lastIndexOf": ('PySide2.QtCore.QByteArray', 'int'),
    "PySide2.QtCore.QByteArray.left": ('int',),
    "PySide2.QtCore.QByteArray.leftJustified": ('int', 'typing.Char', 'bool'),
    "PySide2.QtCore.QByteArray.length": (),
    "PySide2.QtCore.QByteArray.mid": ('int', 'int'),
    "PySide2.QtCore.QByteArray.number": [('float', 'typing.Char', 'int'), ('int', 'int')],
    "PySide2.QtCore.QByteArray.prepend": [('PySide2.QtCore.QByteArray',), ('int', 'typing.Char'), ('typing.Char',)],
    "PySide2.QtCore.QByteArray.remove": ('int', 'int'),
    "PySide2.QtCore.QByteArray.repeated": ('int',),
    "PySide2.QtCore.QByteArray.replace": [('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray'), ('int', 'int', 'PySide2.QtCore.QByteArray'), ('str', 'PySide2.QtCore.QByteArray'), ('typing.Char', 'PySide2.QtCore.QByteArray'), ('typing.Char', 'typing.Char')],
    "PySide2.QtCore.QByteArray.reserve": ('int',),
    "PySide2.QtCore.QByteArray.resize": ('int',),
    "PySide2.QtCore.QByteArray.right": ('int',),
    "PySide2.QtCore.QByteArray.rightJustified": ('int', 'typing.Char', 'bool'),
    "PySide2.QtCore.QByteArray.setNum": [('float', 'typing.Char', 'int'), ('int', 'int')],
    "PySide2.QtCore.QByteArray.setRawData": ('bytes', 'int'),
    "PySide2.QtCore.QByteArray.shrink_to_fit": (),
    "PySide2.QtCore.QByteArray.simplified": (),
    "PySide2.QtCore.QByteArray.size": (),
    "PySide2.QtCore.QByteArray.split": ('typing.Char',),
    "PySide2.QtCore.QByteArray.squeeze": (),
    "PySide2.QtCore.QByteArray.startsWith": [('PySide2.QtCore.QByteArray',), ('typing.Char',)],
    "PySide2.QtCore.QByteArray.swap": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtCore.QByteArray.toBase64": [(), ('PySide2.QtCore.QByteArray.Base64Options',)],
    "PySide2.QtCore.QByteArray.toDouble": (),
    "PySide2.QtCore.QByteArray.toFloat": (),
    "PySide2.QtCore.QByteArray.toHex": [(), ('typing.Char',)],
    "PySide2.QtCore.QByteArray.toInt": ('int',),
    "PySide2.QtCore.QByteArray.toLong": ('int',),
    "PySide2.QtCore.QByteArray.toLongLong": ('int',),
    "PySide2.QtCore.QByteArray.toLower": (),
    "PySide2.QtCore.QByteArray.toPercentEncoding": ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray', 'typing.Char'),
    "PySide2.QtCore.QByteArray.toShort": ('int',),
    "PySide2.QtCore.QByteArray.toUInt": ('int',),
    "PySide2.QtCore.QByteArray.toULong": ('int',),
    "PySide2.QtCore.QByteArray.toULongLong": ('int',),
    "PySide2.QtCore.QByteArray.toUShort": ('int',),
    "PySide2.QtCore.QByteArray.toUpper": (),
    "PySide2.QtCore.QByteArray.trimmed": (),
    "PySide2.QtCore.QByteArray.truncate": ('int',),

# class PySide2.QtCore.QByteArrayMatcher:
    "PySide2.QtCore.QByteArrayMatcher.__init__": [(), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QByteArrayMatcher',), ('bytes', 'int')],
    "PySide2.QtCore.QByteArrayMatcher.__copy__": (),
    "PySide2.QtCore.QByteArrayMatcher.indexIn": [('PySide2.QtCore.QByteArray', 'int'), ('bytes', 'int', 'int')],
    "PySide2.QtCore.QByteArrayMatcher.pattern": (),
    "PySide2.QtCore.QByteArrayMatcher.setPattern": ('PySide2.QtCore.QByteArray',),

# class PySide2.QtCore.QCalendar:

# class PySide2.QtCore.QCalendar.System:

# class PySide2.QtCore.QCalendar.YearMonthDay:
    "PySide2.QtCore.QCalendar.YearMonthDay.__init__": [(), ('PySide2.QtCore.QCalendar.YearMonthDay',), ('int', 'int', 'int')],
    "PySide2.QtCore.QCalendar.YearMonthDay.__copy__": (),
    "PySide2.QtCore.QCalendar.YearMonthDay.isValid": (),

    "PySide2.QtCore.QCalendar.__init__": [(), ('PySide2.QtCore.QCalendar.System',)],
    "PySide2.QtCore.QCalendar.__copy__": (),
    "PySide2.QtCore.QCalendar.availableCalendars": (),
    "PySide2.QtCore.QCalendar.dateFromParts": [('PySide2.QtCore.QCalendar.YearMonthDay',), ('int', 'int', 'int')],
    "PySide2.QtCore.QCalendar.dayOfWeek": ('PySide2.QtCore.QDate',),
    "PySide2.QtCore.QCalendar.daysInMonth": ('int', 'int'),
    "PySide2.QtCore.QCalendar.daysInYear": ('int',),
    "PySide2.QtCore.QCalendar.hasYearZero": (),
    "PySide2.QtCore.QCalendar.isDateValid": ('int', 'int', 'int'),
    "PySide2.QtCore.QCalendar.isGregorian": (),
    "PySide2.QtCore.QCalendar.isLeapYear": ('int',),
    "PySide2.QtCore.QCalendar.isLunar": (),
    "PySide2.QtCore.QCalendar.isLuniSolar": (),
    "PySide2.QtCore.QCalendar.isProleptic": (),
    "PySide2.QtCore.QCalendar.isSolar": (),
    "PySide2.QtCore.QCalendar.isValid": (),
    "PySide2.QtCore.QCalendar.maximumDaysInMonth": (),
    "PySide2.QtCore.QCalendar.maximumMonthsInYear": (),
    "PySide2.QtCore.QCalendar.minimumDaysInMonth": (),
    "PySide2.QtCore.QCalendar.monthName": ('PySide2.QtCore.QLocale', 'int', 'int', 'PySide2.QtCore.QLocale.FormatType'),
    "PySide2.QtCore.QCalendar.monthsInYear": ('int',),
    "PySide2.QtCore.QCalendar.name": (),
    "PySide2.QtCore.QCalendar.partsFromDate": ('PySide2.QtCore.QDate',),
    "PySide2.QtCore.QCalendar.standaloneMonthName": ('PySide2.QtCore.QLocale', 'int', 'int', 'PySide2.QtCore.QLocale.FormatType'),
    "PySide2.QtCore.QCalendar.standaloneWeekDayName": ('PySide2.QtCore.QLocale', 'int', 'PySide2.QtCore.QLocale.FormatType'),
    "PySide2.QtCore.QCalendar.weekDayName": ('PySide2.QtCore.QLocale', 'int', 'PySide2.QtCore.QLocale.FormatType'),

# class PySide2.QtCore.QCborArray:
    "PySide2.QtCore.QCborArray.__init__": [(), ('PySide2.QtCore.QCborArray',)],
    "PySide2.QtCore.QCborArray.__add__": ('PySide2.QtCore.QCborValue',),
    "PySide2.QtCore.QCborArray.__copy__": (),
    "PySide2.QtCore.QCborArray.__iadd__": ('PySide2.QtCore.QCborValue',),
    "PySide2.QtCore.QCborArray.__lshift__": ('PySide2.QtCore.QCborValue',),
    "PySide2.QtCore.QCborArray.append": ('PySide2.QtCore.QCborValue',),
    "PySide2.QtCore.QCborArray.at": ('int',),
    "PySide2.QtCore.QCborArray.clear": (),
    "PySide2.QtCore.QCborArray.compare": ('PySide2.QtCore.QCborArray',),
    "PySide2.QtCore.QCborArray.contains": ('PySide2.QtCore.QCborValue',),
    "PySide2.QtCore.QCborArray.empty": (),
    "PySide2.QtCore.QCborArray.first": (),
    "PySide2.QtCore.QCborArray.fromJsonArray": ('PySide2.QtCore.QJsonArray',),
    "PySide2.QtCore.QCborArray.fromStringList": ('typing.Sequence',),
    "PySide2.QtCore.QCborArray.fromVariantList": ('typing.Sequence',),
    "PySide2.QtCore.QCborArray.insert": ('int', 'PySide2.QtCore.QCborValue'),
    "PySide2.QtCore.QCborArray.isEmpty": (),
    "PySide2.QtCore.QCborArray.last": (),
    "PySide2.QtCore.QCborArray.pop_back": (),
    "PySide2.QtCore.QCborArray.pop_front": (),
    "PySide2.QtCore.QCborArray.prepend": ('PySide2.QtCore.QCborValue',),
    "PySide2.QtCore.QCborArray.push_back": ('PySide2.QtCore.QCborValue',),
    "PySide2.QtCore.QCborArray.push_front": ('PySide2.QtCore.QCborValue',),
    "PySide2.QtCore.QCborArray.removeAt": ('int',),
    "PySide2.QtCore.QCborArray.removeFirst": (),
    "PySide2.QtCore.QCborArray.removeLast": (),
    "PySide2.QtCore.QCborArray.size": (),
    "PySide2.QtCore.QCborArray.swap": ('PySide2.QtCore.QCborArray',),
    "PySide2.QtCore.QCborArray.takeAt": ('int',),
    "PySide2.QtCore.QCborArray.takeFirst": (),
    "PySide2.QtCore.QCborArray.takeLast": (),
    "PySide2.QtCore.QCborArray.toCborValue": (),
    "PySide2.QtCore.QCborArray.toJsonArray": (),
    "PySide2.QtCore.QCborArray.toVariantList": (),

# class PySide2.QtCore.QCborError:

# class PySide2.QtCore.QCborError.Code:
    "PySide2.QtCore.QCborError.__init__": [(), ('PySide2.QtCore.QCborError',)],
    "PySide2.QtCore.QCborError.__copy__": (),
    "PySide2.QtCore.QCborError.toString": (),

# class PySide2.QtCore.QCborKnownTags:

# class PySide2.QtCore.QCborMap:
    "PySide2.QtCore.QCborMap.__init__": [(), ('PySide2.QtCore.QCborMap',)],
    "PySide2.QtCore.QCborMap.__copy__": (),
    "PySide2.QtCore.QCborMap.clear": (),
    "PySide2.QtCore.QCborMap.compare": ('PySide2.QtCore.QCborMap',),
    "PySide2.QtCore.QCborMap.contains": [('PySide2.QtCore.QCborValue',), ('int',), ('str',)],
    "PySide2.QtCore.QCborMap.empty": (),
    "PySide2.QtCore.QCborMap.fromJsonObject": ('typing.Dict',),
    "PySide2.QtCore.QCborMap.fromVariantHash": ('typing.Dict',),
    "PySide2.QtCore.QCborMap.fromVariantMap": ('typing.Dict',),
    "PySide2.QtCore.QCborMap.isEmpty": (),
    "PySide2.QtCore.QCborMap.keys": (),
    "PySide2.QtCore.QCborMap.remove": [('PySide2.QtCore.QCborValue',), ('int',), ('str',)],
    "PySide2.QtCore.QCborMap.size": (),
    "PySide2.QtCore.QCborMap.swap": ('PySide2.QtCore.QCborMap',),
    "PySide2.QtCore.QCborMap.take": [('PySide2.QtCore.QCborValue',), ('int',), ('str',)],
    "PySide2.QtCore.QCborMap.toCborValue": (),
    "PySide2.QtCore.QCborMap.toJsonObject": (),
    "PySide2.QtCore.QCborMap.toVariantHash": (),
    "PySide2.QtCore.QCborMap.toVariantMap": (),
    "PySide2.QtCore.QCborMap.value": [('PySide2.QtCore.QCborValue',), ('int',), ('str',)],

# class PySide2.QtCore.QCborParserError:
    "PySide2.QtCore.QCborParserError.__init__": [(), ('PySide2.QtCore.QCborParserError',)],
    "PySide2.QtCore.QCborParserError.__copy__": (),
    "PySide2.QtCore.QCborParserError.errorString": (),

# class PySide2.QtCore.QCborSimpleType:

# class PySide2.QtCore.QCborStreamReader:

# class PySide2.QtCore.QCborStreamReader.StringResultCode:

# class PySide2.QtCore.QCborStreamReader.Type:
    "PySide2.QtCore.QCborStreamReader.__init__": [(), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QIODevice',), ('bytearray', 'int'), ('bytes', 'int')],
    "PySide2.QtCore.QCborStreamReader.addData": [('PySide2.QtCore.QByteArray',), ('bytearray', 'int'), ('bytes', 'int')],
    "PySide2.QtCore.QCborStreamReader.clear": (),
    "PySide2.QtCore.QCborStreamReader.containerDepth": (),
    "PySide2.QtCore.QCborStreamReader.currentOffset": (),
    "PySide2.QtCore.QCborStreamReader.currentStringChunkSize": (),
    "PySide2.QtCore.QCborStreamReader.device": (),
    "PySide2.QtCore.QCborStreamReader.enterContainer": (),
    "PySide2.QtCore.QCborStreamReader.hasNext": (),
    "PySide2.QtCore.QCborStreamReader.isArray": (),
    "PySide2.QtCore.QCborStreamReader.isBool": (),
    "PySide2.QtCore.QCborStreamReader.isByteArray": (),
    "PySide2.QtCore.QCborStreamReader.isContainer": (),
    "PySide2.QtCore.QCborStreamReader.isDouble": (),
    "PySide2.QtCore.QCborStreamReader.isFalse": (),
    "PySide2.QtCore.QCborStreamReader.isFloat": (),
    "PySide2.QtCore.QCborStreamReader.isFloat16": (),
    "PySide2.QtCore.QCborStreamReader.isInteger": (),
    "PySide2.QtCore.QCborStreamReader.isInvalid": (),
    "PySide2.QtCore.QCborStreamReader.isLengthKnown": (),
    "PySide2.QtCore.QCborStreamReader.isMap": (),
    "PySide2.QtCore.QCborStreamReader.isNegativeInteger": (),
    "PySide2.QtCore.QCborStreamReader.isNull": (),
    "PySide2.QtCore.QCborStreamReader.isSimpleType": [(), ('PySide2.QtCore.QCborSimpleType',)],
    "PySide2.QtCore.QCborStreamReader.isString": (),
    "PySide2.QtCore.QCborStreamReader.isTag": (),
    "PySide2.QtCore.QCborStreamReader.isTrue": (),
    "PySide2.QtCore.QCborStreamReader.isUndefined": (),
    "PySide2.QtCore.QCborStreamReader.isUnsignedInteger": (),
    "PySide2.QtCore.QCborStreamReader.isValid": (),
    "PySide2.QtCore.QCborStreamReader.lastError": (),
    "PySide2.QtCore.QCborStreamReader.leaveContainer": (),
    "PySide2.QtCore.QCborStreamReader.length": (),
    "PySide2.QtCore.QCborStreamReader.parentContainerType": (),
    "PySide2.QtCore.QCborStreamReader.readByteArray": (),
    "PySide2.QtCore.QCborStreamReader.readString": (),
    "PySide2.QtCore.QCborStreamReader.reparse": (),
    "PySide2.QtCore.QCborStreamReader.reset": (),
    "PySide2.QtCore.QCborStreamReader.setDevice": ('PySide2.QtCore.QIODevice',),
    "PySide2.QtCore.QCborStreamReader.toBool": (),
    "PySide2.QtCore.QCborStreamReader.toDouble": (),
    "PySide2.QtCore.QCborStreamReader.toFloat": (),
    "PySide2.QtCore.QCborStreamReader.toInteger": (),
    "PySide2.QtCore.QCborStreamReader.toSimpleType": (),
    "PySide2.QtCore.QCborStreamReader.toUnsignedInteger": (),
    "PySide2.QtCore.QCborStreamReader.type": (),

# class PySide2.QtCore.QCborStreamWriter:
    "PySide2.QtCore.QCborStreamWriter.__init__": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QIODevice',)],
    "PySide2.QtCore.QCborStreamWriter.append": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QCborKnownTags',), ('PySide2.QtCore.QCborSimpleType',), ('bool',), ('bytes', 'int'), ('float',), ('int',)],
    "PySide2.QtCore.QCborStreamWriter.appendByteString": ('bytes', 'int'),
    "PySide2.QtCore.QCborStreamWriter.appendNull": (),
    "PySide2.QtCore.QCborStreamWriter.appendTextString": ('bytes', 'int'),
    "PySide2.QtCore.QCborStreamWriter.appendUndefined": (),
    "PySide2.QtCore.QCborStreamWriter.device": (),
    "PySide2.QtCore.QCborStreamWriter.endArray": (),
    "PySide2.QtCore.QCborStreamWriter.endMap": (),
    "PySide2.QtCore.QCborStreamWriter.setDevice": ('PySide2.QtCore.QIODevice',),
    "PySide2.QtCore.QCborStreamWriter.startArray": [(), ('int',)],
    "PySide2.QtCore.QCborStreamWriter.startMap": [(), ('int',)],

# class PySide2.QtCore.QCborStringResultByteArray:
    "PySide2.QtCore.QCborStringResultByteArray.__init__": [(), ('PySide2.QtCore.QCborStringResultByteArray',)],
    "PySide2.QtCore.QCborStringResultByteArray.__copy__": (),

# class PySide2.QtCore.QCborStringResultString:
    "PySide2.QtCore.QCborStringResultString.__init__": [(), ('PySide2.QtCore.QCborStringResultString',)],
    "PySide2.QtCore.QCborStringResultString.__copy__": (),

# class PySide2.QtCore.QCborValue:

# class PySide2.QtCore.QCborValue.DiagnosticNotationOption:

# class PySide2.QtCore.QCborValue.DiagnosticNotationOptions:

# class PySide2.QtCore.QCborValue.EncodingOption:

# class PySide2.QtCore.QCborValue.EncodingOptions:

# class PySide2.QtCore.QCborValue.Type:
    "PySide2.QtCore.QCborValue.__init__": [(), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QCborArray',), ('PySide2.QtCore.QCborKnownTags', 'PySide2.QtCore.QCborValue'), ('PySide2.QtCore.QCborMap',), ('PySide2.QtCore.QCborSimpleType',), ('PySide2.QtCore.QCborValue',), ('PySide2.QtCore.QCborValue.Type',), ('PySide2.QtCore.QDateTime',), ('PySide2.QtCore.QRegularExpression',), ('PySide2.QtCore.QUrl',), ('PySide2.QtCore.QUuid',), ('bool',), ('bytes',), ('float',), ('int',), ('str',)],
    "PySide2.QtCore.QCborValue.__copy__": (),
    "PySide2.QtCore.QCborValue.compare": ('PySide2.QtCore.QCborValue',),
    "PySide2.QtCore.QCborValue.fromCbor": [('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QCborParserError'), ('PySide2.QtCore.QCborStreamReader',), ('bytearray', 'int', 'PySide2.QtCore.QCborParserError'), ('bytes', 'int', 'PySide2.QtCore.QCborParserError')],
    "PySide2.QtCore.QCborValue.fromJsonValue": ('PySide2.QtCore.QJsonValue',),
    "PySide2.QtCore.QCborValue.fromVariant": ('typing.Any',),
    "PySide2.QtCore.QCborValue.isArray": (),
    "PySide2.QtCore.QCborValue.isBool": (),
    "PySide2.QtCore.QCborValue.isByteArray": (),
    "PySide2.QtCore.QCborValue.isContainer": (),
    "PySide2.QtCore.QCborValue.isDateTime": (),
    "PySide2.QtCore.QCborValue.isDouble": (),
    "PySide2.QtCore.QCborValue.isFalse": (),
    "PySide2.QtCore.QCborValue.isInteger": (),
    "PySide2.QtCore.QCborValue.isInvalid": (),
    "PySide2.QtCore.QCborValue.isMap": (),
    "PySide2.QtCore.QCborValue.isNull": (),
    "PySide2.QtCore.QCborValue.isRegularExpression": (),
    "PySide2.QtCore.QCborValue.isSimpleType": [(), ('PySide2.QtCore.QCborSimpleType',)],
    "PySide2.QtCore.QCborValue.isString": (),
    "PySide2.QtCore.QCborValue.isTag": (),
    "PySide2.QtCore.QCborValue.isTrue": (),
    "PySide2.QtCore.QCborValue.isUndefined": (),
    "PySide2.QtCore.QCborValue.isUrl": (),
    "PySide2.QtCore.QCborValue.isUuid": (),
    "PySide2.QtCore.QCborValue.swap": ('PySide2.QtCore.QCborValue',),
    "PySide2.QtCore.QCborValue.taggedValue": ('PySide2.QtCore.QCborValue',),
    "PySide2.QtCore.QCborValue.toArray": [(), ('PySide2.QtCore.QCborArray',)],
    "PySide2.QtCore.QCborValue.toBool": ('bool',),
    "PySide2.QtCore.QCborValue.toByteArray": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtCore.QCborValue.toCbor": [('PySide2.QtCore.QCborStreamWriter', 'PySide2.QtCore.QCborValue.EncodingOptions'), ('PySide2.QtCore.QCborValue.EncodingOptions',)],
    "PySide2.QtCore.QCborValue.toDateTime": ('PySide2.QtCore.QDateTime',),
    "PySide2.QtCore.QCborValue.toDiagnosticNotation": ('PySide2.QtCore.QCborValue.DiagnosticNotationOptions',),
    "PySide2.QtCore.QCborValue.toDouble": ('float',),
    "PySide2.QtCore.QCborValue.toInteger": ('int',),
    "PySide2.QtCore.QCborValue.toJsonValue": (),
    "PySide2.QtCore.QCborValue.toMap": [(), ('PySide2.QtCore.QCborMap',)],
    "PySide2.QtCore.QCborValue.toRegularExpression": ('PySide2.QtCore.QRegularExpression',),
    "PySide2.QtCore.QCborValue.toSimpleType": ('PySide2.QtCore.QCborSimpleType',),
    "PySide2.QtCore.QCborValue.toString": ('str',),
    "PySide2.QtCore.QCborValue.toUrl": ('PySide2.QtCore.QUrl',),
    "PySide2.QtCore.QCborValue.toUuid": ('PySide2.QtCore.QUuid',),
    "PySide2.QtCore.QCborValue.toVariant": (),
    "PySide2.QtCore.QCborValue.type": (),

# class PySide2.QtCore.QChildEvent:
    "PySide2.QtCore.QChildEvent.__init__": ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QObject'),
    "PySide2.QtCore.QChildEvent.added": (),
    "PySide2.QtCore.QChildEvent.child": (),
    "PySide2.QtCore.QChildEvent.polished": (),
    "PySide2.QtCore.QChildEvent.removed": (),

# class PySide2.QtCore.QCollator:
    "PySide2.QtCore.QCollator.__init__": [(), ('PySide2.QtCore.QCollator',), ('PySide2.QtCore.QLocale',)],
    "PySide2.QtCore.QCollator.__call__": ('str', 'str'),
    "PySide2.QtCore.QCollator.caseSensitivity": (),
    "PySide2.QtCore.QCollator.compare": [('bytes', 'int', 'bytes', 'int'), ('str', 'str')],
    "PySide2.QtCore.QCollator.ignorePunctuation": (),
    "PySide2.QtCore.QCollator.locale": (),
    "PySide2.QtCore.QCollator.numericMode": (),
    "PySide2.QtCore.QCollator.setCaseSensitivity": ('PySide2.QtCore.Qt.CaseSensitivity',),
    "PySide2.QtCore.QCollator.setIgnorePunctuation": ('bool',),
    "PySide2.QtCore.QCollator.setLocale": ('PySide2.QtCore.QLocale',),
    "PySide2.QtCore.QCollator.setNumericMode": ('bool',),
    "PySide2.QtCore.QCollator.sortKey": ('str',),
    "PySide2.QtCore.QCollator.swap": ('PySide2.QtCore.QCollator',),

# class PySide2.QtCore.QCollatorSortKey:
    "PySide2.QtCore.QCollatorSortKey.__init__": ('PySide2.QtCore.QCollatorSortKey',),
    "PySide2.QtCore.QCollatorSortKey.compare": ('PySide2.QtCore.QCollatorSortKey',),
    "PySide2.QtCore.QCollatorSortKey.swap": ('PySide2.QtCore.QCollatorSortKey',),

# class PySide2.QtCore.QCommandLineOption:

# class PySide2.QtCore.QCommandLineOption.Flag:

# class PySide2.QtCore.QCommandLineOption.Flags:
    "PySide2.QtCore.QCommandLineOption.__init__": [('PySide2.QtCore.QCommandLineOption',), ('str',), ('str', 'str', 'str', 'str'), ('typing.Sequence',), ('typing.Sequence', 'str', 'str', 'str')],
    "PySide2.QtCore.QCommandLineOption.defaultValues": (),
    "PySide2.QtCore.QCommandLineOption.description": (),
    "PySide2.QtCore.QCommandLineOption.flags": (),
    "PySide2.QtCore.QCommandLineOption.isHidden": (),
    "PySide2.QtCore.QCommandLineOption.names": (),
    "PySide2.QtCore.QCommandLineOption.setDefaultValue": ('str',),
    "PySide2.QtCore.QCommandLineOption.setDefaultValues": ('typing.Sequence',),
    "PySide2.QtCore.QCommandLineOption.setDescription": ('str',),
    "PySide2.QtCore.QCommandLineOption.setFlags": ('PySide2.QtCore.QCommandLineOption.Flags',),
    "PySide2.QtCore.QCommandLineOption.setHidden": ('bool',),
    "PySide2.QtCore.QCommandLineOption.setValueName": ('str',),
    "PySide2.QtCore.QCommandLineOption.swap": ('PySide2.QtCore.QCommandLineOption',),
    "PySide2.QtCore.QCommandLineOption.valueName": (),

# class PySide2.QtCore.QCommandLineParser:

# class PySide2.QtCore.QCommandLineParser.OptionsAfterPositionalArgumentsMode:

# class PySide2.QtCore.QCommandLineParser.SingleDashWordOptionMode:
    "PySide2.QtCore.QCommandLineParser.__init__": (),
    "PySide2.QtCore.QCommandLineParser.addHelpOption": (),
    "PySide2.QtCore.QCommandLineParser.addOption": ('PySide2.QtCore.QCommandLineOption',),
    "PySide2.QtCore.QCommandLineParser.addOptions": ('typing.Sequence',),
    "PySide2.QtCore.QCommandLineParser.addPositionalArgument": ('str', 'str', 'str'),
    "PySide2.QtCore.QCommandLineParser.addVersionOption": (),
    "PySide2.QtCore.QCommandLineParser.applicationDescription": (),
    "PySide2.QtCore.QCommandLineParser.clearPositionalArguments": (),
    "PySide2.QtCore.QCommandLineParser.errorText": (),
    "PySide2.QtCore.QCommandLineParser.helpText": (),
    "PySide2.QtCore.QCommandLineParser.isSet": [('PySide2.QtCore.QCommandLineOption',), ('str',)],
    "PySide2.QtCore.QCommandLineParser.optionNames": (),
    "PySide2.QtCore.QCommandLineParser.parse": ('typing.Sequence',),
    "PySide2.QtCore.QCommandLineParser.positionalArguments": (),
    "PySide2.QtCore.QCommandLineParser.process": [('PySide2.QtCore.QCoreApplication',), ('typing.Sequence',)],
    "PySide2.QtCore.QCommandLineParser.setApplicationDescription": ('str',),
    "PySide2.QtCore.QCommandLineParser.setOptionsAfterPositionalArgumentsMode": ('PySide2.QtCore.QCommandLineParser.OptionsAfterPositionalArgumentsMode',),
    "PySide2.QtCore.QCommandLineParser.setSingleDashWordOptionMode": ('PySide2.QtCore.QCommandLineParser.SingleDashWordOptionMode',),
    "PySide2.QtCore.QCommandLineParser.showHelp": ('int',),
    "PySide2.QtCore.QCommandLineParser.showVersion": (),
    "PySide2.QtCore.QCommandLineParser.unknownOptionNames": (),
    "PySide2.QtCore.QCommandLineParser.value": [('PySide2.QtCore.QCommandLineOption',), ('str',)],
    "PySide2.QtCore.QCommandLineParser.values": [('PySide2.QtCore.QCommandLineOption',), ('str',)],

# class PySide2.QtCore.QConcatenateTablesProxyModel:
    "PySide2.QtCore.QConcatenateTablesProxyModel.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QConcatenateTablesProxyModel.addSourceModel": ('PySide2.QtCore.QAbstractItemModel',),
    "PySide2.QtCore.QConcatenateTablesProxyModel.canDropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QConcatenateTablesProxyModel.columnCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QConcatenateTablesProxyModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtCore.QConcatenateTablesProxyModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QConcatenateTablesProxyModel.flags": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QConcatenateTablesProxyModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
    "PySide2.QtCore.QConcatenateTablesProxyModel.index": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QConcatenateTablesProxyModel.itemData": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QConcatenateTablesProxyModel.mapFromSource": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QConcatenateTablesProxyModel.mapToSource": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QConcatenateTablesProxyModel.mimeData": ('typing.List',),
    "PySide2.QtCore.QConcatenateTablesProxyModel.mimeTypes": (),
    "PySide2.QtCore.QConcatenateTablesProxyModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
    "PySide2.QtCore.QConcatenateTablesProxyModel.removeSourceModel": ('PySide2.QtCore.QAbstractItemModel',),
    "PySide2.QtCore.QConcatenateTablesProxyModel.rowCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QConcatenateTablesProxyModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
    "PySide2.QtCore.QConcatenateTablesProxyModel.setItemData": ('PySide2.QtCore.QModelIndex', 'typing.Dict'),
    "PySide2.QtCore.QConcatenateTablesProxyModel.span": ('PySide2.QtCore.QModelIndex',),

# class PySide2.QtCore.QCoreApplication:
    "PySide2.QtCore.QCoreApplication.__init__": [(), ('typing.Sequence',)],
    "PySide2.QtCore.QCoreApplication.addLibraryPath": ('str',),
    "PySide2.QtCore.QCoreApplication.applicationDirPath": (),
    "PySide2.QtCore.QCoreApplication.applicationFilePath": (),
    "PySide2.QtCore.QCoreApplication.applicationName": (),
    "PySide2.QtCore.QCoreApplication.applicationPid": (),
    "PySide2.QtCore.QCoreApplication.applicationVersion": (),
    "PySide2.QtCore.QCoreApplication.arguments": (),
    "PySide2.QtCore.QCoreApplication.closingDown": (),
    "PySide2.QtCore.QCoreApplication.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QCoreApplication.eventDispatcher": (),
    "PySide2.QtCore.QCoreApplication.exec_": (),
    "PySide2.QtCore.QCoreApplication.exit": ('int',),
    "PySide2.QtCore.QCoreApplication.flush": (),
    "PySide2.QtCore.QCoreApplication.hasPendingEvents": (),
    "PySide2.QtCore.QCoreApplication.installNativeEventFilter": ('PySide2.QtCore.QAbstractNativeEventFilter',),
    "PySide2.QtCore.QCoreApplication.installTranslator": ('PySide2.QtCore.QTranslator',),
    "PySide2.QtCore.QCoreApplication.instance": (),
    "PySide2.QtCore.QCoreApplication.isQuitLockEnabled": (),
    "PySide2.QtCore.QCoreApplication.isSetuidAllowed": (),
    "PySide2.QtCore.QCoreApplication.libraryPaths": (),
    "PySide2.QtCore.QCoreApplication.notify": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtCore.QCoreApplication.organizationDomain": (),
    "PySide2.QtCore.QCoreApplication.organizationName": (),
    "PySide2.QtCore.QCoreApplication.postEvent": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent', 'int'),
    "PySide2.QtCore.QCoreApplication.processEvents": [('PySide2.QtCore.QEventLoop.ProcessEventsFlags',), ('PySide2.QtCore.QEventLoop.ProcessEventsFlags', 'int')],
    "PySide2.QtCore.QCoreApplication.quit": (),
    "PySide2.QtCore.QCoreApplication.removeLibraryPath": ('str',),
    "PySide2.QtCore.QCoreApplication.removeNativeEventFilter": ('PySide2.QtCore.QAbstractNativeEventFilter',),
    "PySide2.QtCore.QCoreApplication.removePostedEvents": ('PySide2.QtCore.QObject', 'int'),
    "PySide2.QtCore.QCoreApplication.removeTranslator": ('PySide2.QtCore.QTranslator',),
    "PySide2.QtCore.QCoreApplication.sendEvent": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtCore.QCoreApplication.sendPostedEvents": ('PySide2.QtCore.QObject', 'int'),
    "PySide2.QtCore.QCoreApplication.setApplicationName": ('str',),
    "PySide2.QtCore.QCoreApplication.setApplicationVersion": ('str',),
    "PySide2.QtCore.QCoreApplication.setAttribute": ('PySide2.QtCore.Qt.ApplicationAttribute', 'bool'),
    "PySide2.QtCore.QCoreApplication.setEventDispatcher": ('PySide2.QtCore.QAbstractEventDispatcher',),
    "PySide2.QtCore.QCoreApplication.setLibraryPaths": ('typing.Sequence',),
    "PySide2.QtCore.QCoreApplication.setOrganizationDomain": ('str',),
    "PySide2.QtCore.QCoreApplication.setOrganizationName": ('str',),
    "PySide2.QtCore.QCoreApplication.setQuitLockEnabled": ('bool',),
    "PySide2.QtCore.QCoreApplication.setSetuidAllowed": ('bool',),
    "PySide2.QtCore.QCoreApplication.startingUp": (),
    "PySide2.QtCore.QCoreApplication.testAttribute": ('PySide2.QtCore.Qt.ApplicationAttribute',),
    "PySide2.QtCore.QCoreApplication.translate": ('bytes', 'bytes', 'bytes', 'int'),

# class PySide2.QtCore.QCryptographicHash:

# class PySide2.QtCore.QCryptographicHash.Algorithm:
    "PySide2.QtCore.QCryptographicHash.__init__": ('PySide2.QtCore.QCryptographicHash.Algorithm',),
    "PySide2.QtCore.QCryptographicHash.addData": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QIODevice',), ('bytes', 'int')],
    "PySide2.QtCore.QCryptographicHash.hash": ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QCryptographicHash.Algorithm'),
    "PySide2.QtCore.QCryptographicHash.hashLength": ('PySide2.QtCore.QCryptographicHash.Algorithm',),
    "PySide2.QtCore.QCryptographicHash.reset": (),
    "PySide2.QtCore.QCryptographicHash.result": (),

# class PySide2.QtCore.QDataStream:

# class PySide2.QtCore.QDataStream.ByteOrder:

# class PySide2.QtCore.QDataStream.FloatingPointPrecision:

# class PySide2.QtCore.QDataStream.Status:

# class PySide2.QtCore.QDataStream.Version:
    "PySide2.QtCore.QDataStream.__init__": [(), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QIODevice.OpenMode'), ('PySide2.QtCore.QIODevice',)],
    "PySide2.QtCore.QDataStream.__lshift__": [('PySide2.QtCore.QBitArray',), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QCborArray',), ('PySide2.QtCore.QCborMap',), ('PySide2.QtCore.QCborValue',), ('PySide2.QtCore.QDate',), ('PySide2.QtCore.QDateTime',), ('PySide2.QtCore.QEasingCurve',), ('PySide2.QtCore.QJsonArray',), ('PySide2.QtCore.QJsonDocument',), ('PySide2.QtCore.QJsonValue',), ('PySide2.QtCore.QLine',), ('PySide2.QtCore.QLineF',), ('PySide2.QtCore.QLocale',), ('PySide2.QtCore.QMargins',), ('PySide2.QtCore.QMarginsF',), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',), ('PySide2.QtCore.QRegExp',), ('PySide2.QtCore.QRegularExpression',), ('PySide2.QtCore.QSize',), ('PySide2.QtCore.QSizeF',), ('PySide2.QtCore.QTime',), ('PySide2.QtCore.QTimeZone',), ('PySide2.QtCore.QUrl',), ('PySide2.QtCore.QUuid',), ('PySide2.QtCore.QVersionNumber',), ('str',)],
    "PySide2.QtCore.QDataStream.__rshift__": [('PySide2.QtCore.QBitArray',), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QCborArray',), ('PySide2.QtCore.QCborMap',), ('PySide2.QtCore.QCborValue',), ('PySide2.QtCore.QDate',), ('PySide2.QtCore.QDateTime',), ('PySide2.QtCore.QEasingCurve',), ('PySide2.QtCore.QJsonArray',), ('PySide2.QtCore.QJsonDocument',), ('PySide2.QtCore.QJsonValue',), ('PySide2.QtCore.QLine',), ('PySide2.QtCore.QLineF',), ('PySide2.QtCore.QLocale',), ('PySide2.QtCore.QMargins',), ('PySide2.QtCore.QMarginsF',), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',), ('PySide2.QtCore.QRegExp',), ('PySide2.QtCore.QRegularExpression',), ('PySide2.QtCore.QSize',), ('PySide2.QtCore.QSizeF',), ('PySide2.QtCore.QTime',), ('PySide2.QtCore.QTimeZone',), ('PySide2.QtCore.QUrl',), ('PySide2.QtCore.QUuid',), ('PySide2.QtCore.QVersionNumber',)],
    "PySide2.QtCore.QDataStream.abortTransaction": (),
    "PySide2.QtCore.QDataStream.atEnd": (),
    "PySide2.QtCore.QDataStream.byteOrder": (),
    "PySide2.QtCore.QDataStream.commitTransaction": (),
    "PySide2.QtCore.QDataStream.device": (),
    "PySide2.QtCore.QDataStream.floatingPointPrecision": (),
    "PySide2.QtCore.QDataStream.readBool": (),
    "PySide2.QtCore.QDataStream.readDouble": (),
    "PySide2.QtCore.QDataStream.readFloat": (),
    "PySide2.QtCore.QDataStream.readInt16": (),
    "PySide2.QtCore.QDataStream.readInt32": (),
    "PySide2.QtCore.QDataStream.readInt64": (),
    "PySide2.QtCore.QDataStream.readInt8": (),
    "PySide2.QtCore.QDataStream.readQChar": (),
    "PySide2.QtCore.QDataStream.readQString": (),
    "PySide2.QtCore.QDataStream.readQStringList": (),
    "PySide2.QtCore.QDataStream.readQVariant": (),
    "PySide2.QtCore.QDataStream.readRawData": ('bytes', 'int'),
    "PySide2.QtCore.QDataStream.readString": (),
    "PySide2.QtCore.QDataStream.readUInt16": (),
    "PySide2.QtCore.QDataStream.readUInt32": (),
    "PySide2.QtCore.QDataStream.readUInt64": (),
    "PySide2.QtCore.QDataStream.readUInt8": (),
    "PySide2.QtCore.QDataStream.resetStatus": (),
    "PySide2.QtCore.QDataStream.rollbackTransaction": (),
    "PySide2.QtCore.QDataStream.setByteOrder": ('PySide2.QtCore.QDataStream.ByteOrder',),
    "PySide2.QtCore.QDataStream.setDevice": ('PySide2.QtCore.QIODevice',),
    "PySide2.QtCore.QDataStream.setFloatingPointPrecision": ('PySide2.QtCore.QDataStream.FloatingPointPrecision',),
    "PySide2.QtCore.QDataStream.setStatus": ('PySide2.QtCore.QDataStream.Status',),
    "PySide2.QtCore.QDataStream.setVersion": ('int',),
    "PySide2.QtCore.QDataStream.skipRawData": ('int',),
    "PySide2.QtCore.QDataStream.startTransaction": (),
    "PySide2.QtCore.QDataStream.status": (),
    "PySide2.QtCore.QDataStream.unsetDevice": (),
    "PySide2.QtCore.QDataStream.version": (),
    "PySide2.QtCore.QDataStream.writeBool": ('bool',),
    "PySide2.QtCore.QDataStream.writeDouble": ('float',),
    "PySide2.QtCore.QDataStream.writeFloat": ('float',),
    "PySide2.QtCore.QDataStream.writeInt16": ('int',),
    "PySide2.QtCore.QDataStream.writeInt32": ('int',),
    "PySide2.QtCore.QDataStream.writeInt64": ('int',),
    "PySide2.QtCore.QDataStream.writeInt8": ('int',),
    "PySide2.QtCore.QDataStream.writeQChar": ('typing.Char',),
    "PySide2.QtCore.QDataStream.writeQString": ('str',),
    "PySide2.QtCore.QDataStream.writeQStringList": ('typing.Sequence',),
    "PySide2.QtCore.QDataStream.writeQVariant": ('typing.Any',),
    "PySide2.QtCore.QDataStream.writeRawData": ('bytes', 'int'),
    "PySide2.QtCore.QDataStream.writeString": ('str',),
    "PySide2.QtCore.QDataStream.writeUInt16": ('int',),
    "PySide2.QtCore.QDataStream.writeUInt32": ('int',),
    "PySide2.QtCore.QDataStream.writeUInt64": ('int',),
    "PySide2.QtCore.QDataStream.writeUInt8": ('int',),

# class PySide2.QtCore.QDate:

# class PySide2.QtCore.QDate.MonthNameType:
    "PySide2.QtCore.QDate.__init__": [(), ('PySide2.QtCore.QDate',), ('int', 'int', 'int'), ('int', 'int', 'int', 'PySide2.QtCore.QCalendar')],
    "PySide2.QtCore.QDate.__copy__": (),
    "PySide2.QtCore.QDate.__reduce__": (),
    "PySide2.QtCore.QDate.__repr__": (),
    "PySide2.QtCore.QDate.addDays": ('int',),
    "PySide2.QtCore.QDate.addMonths": [('int',), ('int', 'PySide2.QtCore.QCalendar')],
    "PySide2.QtCore.QDate.addYears": [('int',), ('int', 'PySide2.QtCore.QCalendar')],
    "PySide2.QtCore.QDate.currentDate": (),
    "PySide2.QtCore.QDate.day": [(), ('PySide2.QtCore.QCalendar',)],
    "PySide2.QtCore.QDate.dayOfWeek": [(), ('PySide2.QtCore.QCalendar',)],
    "PySide2.QtCore.QDate.dayOfYear": [(), ('PySide2.QtCore.QCalendar',)],
    "PySide2.QtCore.QDate.daysInMonth": [(), ('PySide2.QtCore.QCalendar',)],
    "PySide2.QtCore.QDate.daysInYear": [(), ('PySide2.QtCore.QCalendar',)],
    "PySide2.QtCore.QDate.daysTo": ('PySide2.QtCore.QDate',),
    "PySide2.QtCore.QDate.endOfDay": [('PySide2.QtCore.QTimeZone',), ('PySide2.QtCore.Qt.TimeSpec', 'int')],
    "PySide2.QtCore.QDate.fromJulianDay": ('int',),
    "PySide2.QtCore.QDate.fromString": [('str', 'PySide2.QtCore.Qt.DateFormat'), ('str', 'str'), ('str', 'str', 'PySide2.QtCore.QCalendar')],
    "PySide2.QtCore.QDate.getDate": (),
    "PySide2.QtCore.QDate.isLeapYear": ('int',),
    "PySide2.QtCore.QDate.isNull": (),
    "PySide2.QtCore.QDate.isValid": [(), ('int', 'int', 'int')],
    "PySide2.QtCore.QDate.longDayName": ('int', 'PySide2.QtCore.QDate.MonthNameType'),
    "PySide2.QtCore.QDate.longMonthName": ('int', 'PySide2.QtCore.QDate.MonthNameType'),
    "PySide2.QtCore.QDate.month": [(), ('PySide2.QtCore.QCalendar',)],
    "PySide2.QtCore.QDate.setDate": [('int', 'int', 'int'), ('int', 'int', 'int', 'PySide2.QtCore.QCalendar')],
    "PySide2.QtCore.QDate.shortDayName": ('int', 'PySide2.QtCore.QDate.MonthNameType'),
    "PySide2.QtCore.QDate.shortMonthName": ('int', 'PySide2.QtCore.QDate.MonthNameType'),
    "PySide2.QtCore.QDate.startOfDay": [('PySide2.QtCore.QTimeZone',), ('PySide2.QtCore.Qt.TimeSpec', 'int')],
    "PySide2.QtCore.QDate.toJulianDay": (),
    "PySide2.QtCore.QDate.toPython": (),
    "PySide2.QtCore.QDate.toString": [('PySide2.QtCore.Qt.DateFormat',), ('PySide2.QtCore.Qt.DateFormat', 'PySide2.QtCore.QCalendar'), ('str',), ('str', 'PySide2.QtCore.QCalendar')],
    "PySide2.QtCore.QDate.weekNumber": (),
    "PySide2.QtCore.QDate.year": [(), ('PySide2.QtCore.QCalendar',)],

# class PySide2.QtCore.QDateTime:

# class PySide2.QtCore.QDateTime.YearRange:
    "PySide2.QtCore.QDateTime.__init__": [(), ('PySide2.QtCore.QDate',), ('PySide2.QtCore.QDate', 'PySide2.QtCore.QTime', 'PySide2.QtCore.QTimeZone'), ('PySide2.QtCore.QDate', 'PySide2.QtCore.QTime', 'PySide2.QtCore.Qt.TimeSpec'), ('PySide2.QtCore.QDate', 'PySide2.QtCore.QTime', 'PySide2.QtCore.Qt.TimeSpec', 'int'), ('PySide2.QtCore.QDateTime',), ('int', 'int', 'int', 'int', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int')],
    "PySide2.QtCore.QDateTime.__copy__": (),
    "PySide2.QtCore.QDateTime.__reduce__": (),
    "PySide2.QtCore.QDateTime.__repr__": (),
    "PySide2.QtCore.QDateTime.addDays": ('int',),
    "PySide2.QtCore.QDateTime.addMSecs": ('int',),
    "PySide2.QtCore.QDateTime.addMonths": ('int',),
    "PySide2.QtCore.QDateTime.addSecs": ('int',),
    "PySide2.QtCore.QDateTime.addYears": ('int',),
    "PySide2.QtCore.QDateTime.currentDateTime": (),
    "PySide2.QtCore.QDateTime.currentDateTimeUtc": (),
    "PySide2.QtCore.QDateTime.currentMSecsSinceEpoch": (),
    "PySide2.QtCore.QDateTime.currentSecsSinceEpoch": (),
    "PySide2.QtCore.QDateTime.date": (),
    "PySide2.QtCore.QDateTime.daysTo": ('PySide2.QtCore.QDateTime',),
    "PySide2.QtCore.QDateTime.fromMSecsSinceEpoch": [('int',), ('int', 'PySide2.QtCore.QTimeZone'), ('int', 'PySide2.QtCore.Qt.TimeSpec', 'int')],
    "PySide2.QtCore.QDateTime.fromSecsSinceEpoch": [('int', 'PySide2.QtCore.QTimeZone'), ('int', 'PySide2.QtCore.Qt.TimeSpec', 'int')],
    "PySide2.QtCore.QDateTime.fromString": [('str', 'PySide2.QtCore.Qt.DateFormat'), ('str', 'str'), ('str', 'str', 'PySide2.QtCore.QCalendar')],
    "PySide2.QtCore.QDateTime.fromTime_t": [('int',), ('int', 'PySide2.QtCore.QTimeZone'), ('int', 'PySide2.QtCore.Qt.TimeSpec', 'int')],
    "PySide2.QtCore.QDateTime.isDaylightTime": (),
    "PySide2.QtCore.QDateTime.isNull": (),
    "PySide2.QtCore.QDateTime.isValid": (),
    "PySide2.QtCore.QDateTime.msecsTo": ('PySide2.QtCore.QDateTime',),
    "PySide2.QtCore.QDateTime.offsetFromUtc": (),
    "PySide2.QtCore.QDateTime.secsTo": ('PySide2.QtCore.QDateTime',),
    "PySide2.QtCore.QDateTime.setDate": ('PySide2.QtCore.QDate',),
    "PySide2.QtCore.QDateTime.setMSecsSinceEpoch": ('int',),
    "PySide2.QtCore.QDateTime.setOffsetFromUtc": ('int',),
    "PySide2.QtCore.QDateTime.setSecsSinceEpoch": ('int',),
    "PySide2.QtCore.QDateTime.setTime": ('PySide2.QtCore.QTime',),
    "PySide2.QtCore.QDateTime.setTimeSpec": ('PySide2.QtCore.Qt.TimeSpec',),
    "PySide2.QtCore.QDateTime.setTimeZone": ('PySide2.QtCore.QTimeZone',),
    "PySide2.QtCore.QDateTime.setTime_t": ('int',),
    "PySide2.QtCore.QDateTime.setUtcOffset": ('int',),
    "PySide2.QtCore.QDateTime.swap": ('PySide2.QtCore.QDateTime',),
    "PySide2.QtCore.QDateTime.time": (),
    "PySide2.QtCore.QDateTime.timeSpec": (),
    "PySide2.QtCore.QDateTime.timeZone": (),
    "PySide2.QtCore.QDateTime.timeZoneAbbreviation": (),
    "PySide2.QtCore.QDateTime.toLocalTime": (),
    "PySide2.QtCore.QDateTime.toMSecsSinceEpoch": (),
    "PySide2.QtCore.QDateTime.toOffsetFromUtc": ('int',),
    "PySide2.QtCore.QDateTime.toPython": (),
    "PySide2.QtCore.QDateTime.toSecsSinceEpoch": (),
    "PySide2.QtCore.QDateTime.toString": [('PySide2.QtCore.Qt.DateFormat',), ('str',)],
    "PySide2.QtCore.QDateTime.toTimeSpec": ('PySide2.QtCore.Qt.TimeSpec',),
    "PySide2.QtCore.QDateTime.toTimeZone": ('PySide2.QtCore.QTimeZone',),
    "PySide2.QtCore.QDateTime.toTime_t": (),
    "PySide2.QtCore.QDateTime.toUTC": (),
    "PySide2.QtCore.QDateTime.utcOffset": (),

# class PySide2.QtCore.QDir:

# class PySide2.QtCore.QDir.Filter:

# class PySide2.QtCore.QDir.Filters:

# class PySide2.QtCore.QDir.SortFlag:

# class PySide2.QtCore.QDir.SortFlags:
    "PySide2.QtCore.QDir.__init__": [('PySide2.QtCore.QDir',), ('str',), ('str', 'str', 'PySide2.QtCore.QDir.SortFlags', 'PySide2.QtCore.QDir.Filters')],
    "PySide2.QtCore.QDir.__copy__": (),
    "PySide2.QtCore.QDir.__reduce__": (),
    "PySide2.QtCore.QDir.absoluteFilePath": ('str',),
    "PySide2.QtCore.QDir.absolutePath": (),
    "PySide2.QtCore.QDir.addResourceSearchPath": ('str',),
    "PySide2.QtCore.QDir.addSearchPath": ('str', 'str'),
    "PySide2.QtCore.QDir.canonicalPath": (),
    "PySide2.QtCore.QDir.cd": ('str',),
    "PySide2.QtCore.QDir.cdUp": (),
    "PySide2.QtCore.QDir.cleanPath": ('str',),
    "PySide2.QtCore.QDir.count": (),
    "PySide2.QtCore.QDir.current": (),
    "PySide2.QtCore.QDir.currentPath": (),
    "PySide2.QtCore.QDir.dirName": (),
    "PySide2.QtCore.QDir.drives": (),
    "PySide2.QtCore.QDir.entryInfoList": [('PySide2.QtCore.QDir.Filters', 'PySide2.QtCore.QDir.SortFlags'), ('typing.Sequence', 'PySide2.QtCore.QDir.Filters', 'PySide2.QtCore.QDir.SortFlags')],
    "PySide2.QtCore.QDir.entryList": [('PySide2.QtCore.QDir.Filters', 'PySide2.QtCore.QDir.SortFlags'), ('typing.Sequence', 'PySide2.QtCore.QDir.Filters', 'PySide2.QtCore.QDir.SortFlags')],
    "PySide2.QtCore.QDir.exists": [(), ('str',)],
    "PySide2.QtCore.QDir.filePath": ('str',),
    "PySide2.QtCore.QDir.filter": (),
    "PySide2.QtCore.QDir.fromNativeSeparators": ('str',),
    "PySide2.QtCore.QDir.home": (),
    "PySide2.QtCore.QDir.homePath": (),
    "PySide2.QtCore.QDir.isAbsolute": (),
    "PySide2.QtCore.QDir.isAbsolutePath": ('str',),
    "PySide2.QtCore.QDir.isEmpty": ('PySide2.QtCore.QDir.Filters',),
    "PySide2.QtCore.QDir.isReadable": (),
    "PySide2.QtCore.QDir.isRelative": (),
    "PySide2.QtCore.QDir.isRelativePath": ('str',),
    "PySide2.QtCore.QDir.isRoot": (),
    "PySide2.QtCore.QDir.listSeparator": (),
    "PySide2.QtCore.QDir.makeAbsolute": (),
    "PySide2.QtCore.QDir.match": [('str', 'str'), ('typing.Sequence', 'str')],
    "PySide2.QtCore.QDir.mkdir": ('str',),
    "PySide2.QtCore.QDir.mkpath": ('str',),
    "PySide2.QtCore.QDir.nameFilters": (),
    "PySide2.QtCore.QDir.nameFiltersFromString": ('str',),
    "PySide2.QtCore.QDir.path": (),
    "PySide2.QtCore.QDir.refresh": (),
    "PySide2.QtCore.QDir.relativeFilePath": ('str',),
    "PySide2.QtCore.QDir.remove": ('str',),
    "PySide2.QtCore.QDir.removeRecursively": (),
    "PySide2.QtCore.QDir.rename": ('str', 'str'),
    "PySide2.QtCore.QDir.rmdir": ('str',),
    "PySide2.QtCore.QDir.rmpath": ('str',),
    "PySide2.QtCore.QDir.root": (),
    "PySide2.QtCore.QDir.rootPath": (),
    "PySide2.QtCore.QDir.searchPaths": ('str',),
    "PySide2.QtCore.QDir.separator": (),
    "PySide2.QtCore.QDir.setCurrent": ('str',),
    "PySide2.QtCore.QDir.setFilter": ('PySide2.QtCore.QDir.Filters',),
    "PySide2.QtCore.QDir.setNameFilters": ('typing.Sequence',),
    "PySide2.QtCore.QDir.setPath": ('str',),
    "PySide2.QtCore.QDir.setSearchPaths": ('str', 'typing.Sequence'),
    "PySide2.QtCore.QDir.setSorting": ('PySide2.QtCore.QDir.SortFlags',),
    "PySide2.QtCore.QDir.sorting": (),
    "PySide2.QtCore.QDir.swap": ('PySide2.QtCore.QDir',),
    "PySide2.QtCore.QDir.temp": (),
    "PySide2.QtCore.QDir.tempPath": (),
    "PySide2.QtCore.QDir.toNativeSeparators": ('str',),

# class PySide2.QtCore.QDirIterator:

# class PySide2.QtCore.QDirIterator.IteratorFlag:

# class PySide2.QtCore.QDirIterator.IteratorFlags:
    "PySide2.QtCore.QDirIterator.__init__": [('PySide2.QtCore.QDir', 'PySide2.QtCore.QDirIterator.IteratorFlags'), ('str', 'PySide2.QtCore.QDir.Filters', 'PySide2.QtCore.QDirIterator.IteratorFlags'), ('str', 'PySide2.QtCore.QDirIterator.IteratorFlags'), ('str', 'typing.Sequence', 'PySide2.QtCore.QDir.Filters', 'PySide2.QtCore.QDirIterator.IteratorFlags')],
    "PySide2.QtCore.QDirIterator.fileInfo": (),
    "PySide2.QtCore.QDirIterator.fileName": (),
    "PySide2.QtCore.QDirIterator.filePath": (),
    "PySide2.QtCore.QDirIterator.hasNext": (),
    "PySide2.QtCore.QDirIterator.path": (),

# class PySide2.QtCore.QDynamicPropertyChangeEvent:
    "PySide2.QtCore.QDynamicPropertyChangeEvent.__init__": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtCore.QDynamicPropertyChangeEvent.propertyName": (),

# class PySide2.QtCore.QEasingCurve:

# class PySide2.QtCore.QEasingCurve.Type:
    "PySide2.QtCore.QEasingCurve.__init__": [('PySide2.QtCore.QEasingCurve',), ('PySide2.QtCore.QEasingCurve.Type',)],
    "PySide2.QtCore.QEasingCurve.__copy__": (),
    "PySide2.QtCore.QEasingCurve.addCubicBezierSegment": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'),
    "PySide2.QtCore.QEasingCurve.addTCBSegment": ('PySide2.QtCore.QPointF', 'float', 'float', 'float'),
    "PySide2.QtCore.QEasingCurve.amplitude": (),
    "PySide2.QtCore.QEasingCurve.customType": (),
    "PySide2.QtCore.QEasingCurve.overshoot": (),
    "PySide2.QtCore.QEasingCurve.period": (),
    "PySide2.QtCore.QEasingCurve.setAmplitude": ('float',),
    "PySide2.QtCore.QEasingCurve.setCustomType": ('object',),
    "PySide2.QtCore.QEasingCurve.setOvershoot": ('float',),
    "PySide2.QtCore.QEasingCurve.setPeriod": ('float',),
    "PySide2.QtCore.QEasingCurve.setType": ('PySide2.QtCore.QEasingCurve.Type',),
    "PySide2.QtCore.QEasingCurve.swap": ('PySide2.QtCore.QEasingCurve',),
    "PySide2.QtCore.QEasingCurve.toCubicSpline": (),
    "PySide2.QtCore.QEasingCurve.type": (),
    "PySide2.QtCore.QEasingCurve.valueForProgress": ('float',),

# class PySide2.QtCore.QElapsedTimer:

# class PySide2.QtCore.QElapsedTimer.ClockType:
    "PySide2.QtCore.QElapsedTimer.__init__": [(), ('PySide2.QtCore.QElapsedTimer',)],
    "PySide2.QtCore.QElapsedTimer.__copy__": (),
    "PySide2.QtCore.QElapsedTimer.clockType": (),
    "PySide2.QtCore.QElapsedTimer.elapsed": (),
    "PySide2.QtCore.QElapsedTimer.hasExpired": ('int',),
    "PySide2.QtCore.QElapsedTimer.invalidate": (),
    "PySide2.QtCore.QElapsedTimer.isMonotonic": (),
    "PySide2.QtCore.QElapsedTimer.isValid": (),
    "PySide2.QtCore.QElapsedTimer.msecsSinceReference": (),
    "PySide2.QtCore.QElapsedTimer.msecsTo": ('PySide2.QtCore.QElapsedTimer',),
    "PySide2.QtCore.QElapsedTimer.nsecsElapsed": (),
    "PySide2.QtCore.QElapsedTimer.restart": (),
    "PySide2.QtCore.QElapsedTimer.secsTo": ('PySide2.QtCore.QElapsedTimer',),
    "PySide2.QtCore.QElapsedTimer.start": (),

# class PySide2.QtCore.QEvent:

# class PySide2.QtCore.QEvent.Type:
    "PySide2.QtCore.QEvent.__init__": [('PySide2.QtCore.QEvent',), ('PySide2.QtCore.QEvent.Type',)],
    "PySide2.QtCore.QEvent.accept": (),
    "PySide2.QtCore.QEvent.ignore": (),
    "PySide2.QtCore.QEvent.isAccepted": (),
    "PySide2.QtCore.QEvent.registerEventType": ('int',),
    "PySide2.QtCore.QEvent.setAccepted": ('bool',),
    "PySide2.QtCore.QEvent.spontaneous": (),
    "PySide2.QtCore.QEvent.type": (),

# class PySide2.QtCore.QEventLoop:

# class PySide2.QtCore.QEventLoop.ProcessEventsFlag:

# class PySide2.QtCore.QEventLoop.ProcessEventsFlags:
    "PySide2.QtCore.QEventLoop.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QEventLoop.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QEventLoop.exec_": ('PySide2.QtCore.QEventLoop.ProcessEventsFlags',),
    "PySide2.QtCore.QEventLoop.exit": ('int',),
    "PySide2.QtCore.QEventLoop.isRunning": (),
    "PySide2.QtCore.QEventLoop.processEvents": [('PySide2.QtCore.QEventLoop.ProcessEventsFlags',), ('PySide2.QtCore.QEventLoop.ProcessEventsFlags', 'int')],
    "PySide2.QtCore.QEventLoop.quit": (),
    "PySide2.QtCore.QEventLoop.wakeUp": (),

# class PySide2.QtCore.QEventTransition:
    "PySide2.QtCore.QEventTransition.__init__": [('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QState'), ('PySide2.QtCore.QState',)],
    "PySide2.QtCore.QEventTransition.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QEventTransition.eventSource": (),
    "PySide2.QtCore.QEventTransition.eventTest": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QEventTransition.eventType": (),
    "PySide2.QtCore.QEventTransition.onTransition": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QEventTransition.setEventSource": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QEventTransition.setEventType": ('PySide2.QtCore.QEvent.Type',),

# class PySide2.QtCore.QFactoryInterface:
    "PySide2.QtCore.QFactoryInterface.__init__": (),
    "PySide2.QtCore.QFactoryInterface.keys": (),

# class PySide2.QtCore.QFile:
    "PySide2.QtCore.QFile.__init__": [(), ('PySide2.QtCore.QObject',), ('str',), ('str', 'PySide2.QtCore.QObject')],
    "PySide2.QtCore.QFile.copy": [('str',), ('str', 'str')],
    "PySide2.QtCore.QFile.decodeName": [('PySide2.QtCore.QByteArray',), ('bytes',)],
    "PySide2.QtCore.QFile.encodeName": ('str',),
    "PySide2.QtCore.QFile.exists": [(), ('str',)],
    "PySide2.QtCore.QFile.fileName": (),
    "PySide2.QtCore.QFile.link": [('str',), ('str', 'str')],
    "PySide2.QtCore.QFile.open": [('PySide2.QtCore.QIODevice.OpenMode',), ('int', 'PySide2.QtCore.QIODevice.OpenMode', 'PySide2.QtCore.QFileDevice.FileHandleFlags')],
    "PySide2.QtCore.QFile.permissions": [(), ('str',)],
    "PySide2.QtCore.QFile.readLink": [(), ('str',)],
    "PySide2.QtCore.QFile.remove": [(), ('str',)],
    "PySide2.QtCore.QFile.rename": [('str',), ('str', 'str')],
    "PySide2.QtCore.QFile.resize": [('int',), ('str', 'int')],
    "PySide2.QtCore.QFile.setFileName": ('str',),
    "PySide2.QtCore.QFile.setPermissions": [('PySide2.QtCore.QFileDevice.Permissions',), ('str', 'PySide2.QtCore.QFileDevice.Permissions')],
    "PySide2.QtCore.QFile.size": (),
    "PySide2.QtCore.QFile.symLinkTarget": [(), ('str',)],

# class PySide2.QtCore.QFileDevice:

# class PySide2.QtCore.QFileDevice.FileError:

# class PySide2.QtCore.QFileDevice.FileHandleFlag:

# class PySide2.QtCore.QFileDevice.FileHandleFlags:

# class PySide2.QtCore.QFileDevice.FileTime:

# class PySide2.QtCore.QFileDevice.MemoryMapFlags:

# class PySide2.QtCore.QFileDevice.Permission:

# class PySide2.QtCore.QFileDevice.Permissions:
    "PySide2.QtCore.QFileDevice.__init__": [(), ('PySide2.QtCore.QObject',)],
    "PySide2.QtCore.QFileDevice.atEnd": (),
    "PySide2.QtCore.QFileDevice.close": (),
    "PySide2.QtCore.QFileDevice.error": (),
    "PySide2.QtCore.QFileDevice.fileName": (),
    "PySide2.QtCore.QFileDevice.fileTime": ('PySide2.QtCore.QFileDevice.FileTime',),
    "PySide2.QtCore.QFileDevice.flush": (),
    "PySide2.QtCore.QFileDevice.handle": (),
    "PySide2.QtCore.QFileDevice.isSequential": (),
    "PySide2.QtCore.QFileDevice.map": ('int', 'int', 'PySide2.QtCore.QFileDevice.MemoryMapFlags'),
    "PySide2.QtCore.QFileDevice.permissions": (),
    "PySide2.QtCore.QFileDevice.pos": (),
    "PySide2.QtCore.QFileDevice.readData": ('bytes', 'int'),
    "PySide2.QtCore.QFileDevice.readLineData": ('bytes', 'int'),
    "PySide2.QtCore.QFileDevice.resize": ('int',),
    "PySide2.QtCore.QFileDevice.seek": ('int',),
    "PySide2.QtCore.QFileDevice.setFileTime": ('PySide2.QtCore.QDateTime', 'PySide2.QtCore.QFileDevice.FileTime'),
    "PySide2.QtCore.QFileDevice.setPermissions": ('PySide2.QtCore.QFileDevice.Permissions',),
    "PySide2.QtCore.QFileDevice.size": (),
    "PySide2.QtCore.QFileDevice.unmap": ('bytes',),
    "PySide2.QtCore.QFileDevice.unsetError": (),
    "PySide2.QtCore.QFileDevice.writeData": ('bytes', 'int'),

# class PySide2.QtCore.QFileInfo:
    "PySide2.QtCore.QFileInfo.__init__": [(), ('PySide2.QtCore.QDir', 'str'), ('PySide2.QtCore.QFile',), ('PySide2.QtCore.QFileInfo',), ('str',)],
    "PySide2.QtCore.QFileInfo.__copy__": (),
    "PySide2.QtCore.QFileInfo.__reduce__": (),
    "PySide2.QtCore.QFileInfo.absoluteDir": (),
    "PySide2.QtCore.QFileInfo.absoluteFilePath": (),
    "PySide2.QtCore.QFileInfo.absolutePath": (),
    "PySide2.QtCore.QFileInfo.baseName": (),
    "PySide2.QtCore.QFileInfo.birthTime": (),
    "PySide2.QtCore.QFileInfo.bundleName": (),
    "PySide2.QtCore.QFileInfo.caching": (),
    "PySide2.QtCore.QFileInfo.canonicalFilePath": (),
    "PySide2.QtCore.QFileInfo.canonicalPath": (),
    "PySide2.QtCore.QFileInfo.completeBaseName": (),
    "PySide2.QtCore.QFileInfo.completeSuffix": (),
    "PySide2.QtCore.QFileInfo.created": (),
    "PySide2.QtCore.QFileInfo.dir": (),
    "PySide2.QtCore.QFileInfo.exists": [(), ('str',)],
    "PySide2.QtCore.QFileInfo.fileName": (),
    "PySide2.QtCore.QFileInfo.filePath": (),
    "PySide2.QtCore.QFileInfo.group": (),
    "PySide2.QtCore.QFileInfo.groupId": (),
    "PySide2.QtCore.QFileInfo.isAbsolute": (),
    "PySide2.QtCore.QFileInfo.isBundle": (),
    "PySide2.QtCore.QFileInfo.isDir": (),
    "PySide2.QtCore.QFileInfo.isExecutable": (),
    "PySide2.QtCore.QFileInfo.isFile": (),
    "PySide2.QtCore.QFileInfo.isHidden": (),
    "PySide2.QtCore.QFileInfo.isNativePath": (),
    "PySide2.QtCore.QFileInfo.isReadable": (),
    "PySide2.QtCore.QFileInfo.isRelative": (),
    "PySide2.QtCore.QFileInfo.isRoot": (),
    "PySide2.QtCore.QFileInfo.isShortcut": (),
    "PySide2.QtCore.QFileInfo.isSymLink": (),
    "PySide2.QtCore.QFileInfo.isSymbolicLink": (),
    "PySide2.QtCore.QFileInfo.isWritable": (),
    "PySide2.QtCore.QFileInfo.lastModified": (),
    "PySide2.QtCore.QFileInfo.lastRead": (),
    "PySide2.QtCore.QFileInfo.makeAbsolute": (),
    "PySide2.QtCore.QFileInfo.metadataChangeTime": (),
    "PySide2.QtCore.QFileInfo.owner": (),
    "PySide2.QtCore.QFileInfo.ownerId": (),
    "PySide2.QtCore.QFileInfo.path": (),
    "PySide2.QtCore.QFileInfo.readLink": (),
    "PySide2.QtCore.QFileInfo.refresh": (),
    "PySide2.QtCore.QFileInfo.setCaching": ('bool',),
    "PySide2.QtCore.QFileInfo.setFile": [('PySide2.QtCore.QDir', 'str'), ('PySide2.QtCore.QFile',), ('str',)],
    "PySide2.QtCore.QFileInfo.size": (),
    "PySide2.QtCore.QFileInfo.suffix": (),
    "PySide2.QtCore.QFileInfo.swap": ('PySide2.QtCore.QFileInfo',),
    "PySide2.QtCore.QFileInfo.symLinkTarget": (),

# class PySide2.QtCore.QFileSelector:
    "PySide2.QtCore.QFileSelector.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QFileSelector.allSelectors": (),
    "PySide2.QtCore.QFileSelector.extraSelectors": (),
    "PySide2.QtCore.QFileSelector.select": [('PySide2.QtCore.QUrl',), ('str',)],
    "PySide2.QtCore.QFileSelector.setExtraSelectors": ('typing.Sequence',),

# class PySide2.QtCore.QFileSystemWatcher:
    "PySide2.QtCore.QFileSystemWatcher.__init__": [('PySide2.QtCore.QObject',), ('typing.Sequence', 'PySide2.QtCore.QObject')],
    "PySide2.QtCore.QFileSystemWatcher.addPath": ('str',),
    "PySide2.QtCore.QFileSystemWatcher.addPaths": ('typing.Sequence',),
    "PySide2.QtCore.QFileSystemWatcher.directories": (),
    "PySide2.QtCore.QFileSystemWatcher.files": (),
    "PySide2.QtCore.QFileSystemWatcher.removePath": ('str',),
    "PySide2.QtCore.QFileSystemWatcher.removePaths": ('typing.Sequence',),

# class PySide2.QtCore.QFinalState:
    "PySide2.QtCore.QFinalState.__init__": ('PySide2.QtCore.QState',),
    "PySide2.QtCore.QFinalState.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QFinalState.onEntry": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QFinalState.onExit": ('PySide2.QtCore.QEvent',),

# class PySide2.QtCore.QGenericArgument:
    "PySide2.QtCore.QGenericArgument.__init__": [('PySide2.QtCore.QGenericArgument',), ('bytes', 'int')],
    "PySide2.QtCore.QGenericArgument.__copy__": (),
    "PySide2.QtCore.QGenericArgument.data": (),
    "PySide2.QtCore.QGenericArgument.name": (),

# class PySide2.QtCore.QGenericReturnArgument:
    "PySide2.QtCore.QGenericReturnArgument.__init__": [('PySide2.QtCore.QGenericReturnArgument',), ('bytes', 'int')],
    "PySide2.QtCore.QGenericReturnArgument.__copy__": (),

# class PySide2.QtCore.QHistoryState:

# class PySide2.QtCore.QHistoryState.HistoryType:
    "PySide2.QtCore.QHistoryState.__init__": [('PySide2.QtCore.QHistoryState.HistoryType', 'PySide2.QtCore.QState'), ('PySide2.QtCore.QState',)],
    "PySide2.QtCore.QHistoryState.defaultState": (),
    "PySide2.QtCore.QHistoryState.defaultTransition": (),
    "PySide2.QtCore.QHistoryState.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QHistoryState.historyType": (),
    "PySide2.QtCore.QHistoryState.onEntry": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QHistoryState.onExit": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QHistoryState.setDefaultState": ('PySide2.QtCore.QAbstractState',),
    "PySide2.QtCore.QHistoryState.setDefaultTransition": ('PySide2.QtCore.QAbstractTransition',),
    "PySide2.QtCore.QHistoryState.setHistoryType": ('PySide2.QtCore.QHistoryState.HistoryType',),

# class PySide2.QtCore.QIODevice:

# class PySide2.QtCore.QIODevice.OpenMode:

# class PySide2.QtCore.QIODevice.OpenModeFlag:
    "PySide2.QtCore.QIODevice.__init__": [(), ('PySide2.QtCore.QObject',)],
    "PySide2.QtCore.QIODevice.atEnd": (),
    "PySide2.QtCore.QIODevice.bytesAvailable": (),
    "PySide2.QtCore.QIODevice.bytesToWrite": (),
    "PySide2.QtCore.QIODevice.canReadLine": (),
    "PySide2.QtCore.QIODevice.close": (),
    "PySide2.QtCore.QIODevice.commitTransaction": (),
    "PySide2.QtCore.QIODevice.currentReadChannel": (),
    "PySide2.QtCore.QIODevice.currentWriteChannel": (),
    "PySide2.QtCore.QIODevice.errorString": (),
    "PySide2.QtCore.QIODevice.getChar": ('bytes',),
    "PySide2.QtCore.QIODevice.isOpen": (),
    "PySide2.QtCore.QIODevice.isReadable": (),
    "PySide2.QtCore.QIODevice.isSequential": (),
    "PySide2.QtCore.QIODevice.isTextModeEnabled": (),
    "PySide2.QtCore.QIODevice.isTransactionStarted": (),
    "PySide2.QtCore.QIODevice.isWritable": (),
    "PySide2.QtCore.QIODevice.open": ('PySide2.QtCore.QIODevice.OpenMode',),
    "PySide2.QtCore.QIODevice.openMode": (),
    "PySide2.QtCore.QIODevice.peek": ('int',),
    "PySide2.QtCore.QIODevice.pos": (),
    "PySide2.QtCore.QIODevice.putChar": ('typing.Char',),
    "PySide2.QtCore.QIODevice.read": ('int',),
    "PySide2.QtCore.QIODevice.readAll": (),
    "PySide2.QtCore.QIODevice.readChannelCount": (),
    "PySide2.QtCore.QIODevice.readData": ('bytes', 'int'),
    "PySide2.QtCore.QIODevice.readLine": ('int',),
    "PySide2.QtCore.QIODevice.readLineData": ('bytes', 'int'),
    "PySide2.QtCore.QIODevice.reset": (),
    "PySide2.QtCore.QIODevice.rollbackTransaction": (),
    "PySide2.QtCore.QIODevice.seek": ('int',),
    "PySide2.QtCore.QIODevice.setCurrentReadChannel": ('int',),
    "PySide2.QtCore.QIODevice.setCurrentWriteChannel": ('int',),
    "PySide2.QtCore.QIODevice.setErrorString": ('str',),
    "PySide2.QtCore.QIODevice.setOpenMode": ('PySide2.QtCore.QIODevice.OpenMode',),
    "PySide2.QtCore.QIODevice.setTextModeEnabled": ('bool',),
    "PySide2.QtCore.QIODevice.size": (),
    "PySide2.QtCore.QIODevice.skip": ('int',),
    "PySide2.QtCore.QIODevice.startTransaction": (),
    "PySide2.QtCore.QIODevice.ungetChar": ('typing.Char',),
    "PySide2.QtCore.QIODevice.waitForBytesWritten": ('int',),
    "PySide2.QtCore.QIODevice.waitForReadyRead": ('int',),
    "PySide2.QtCore.QIODevice.write": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtCore.QIODevice.writeChannelCount": (),
    "PySide2.QtCore.QIODevice.writeData": ('bytes', 'int'),

# class PySide2.QtCore.QIdentityProxyModel:
    "PySide2.QtCore.QIdentityProxyModel.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QIdentityProxyModel.columnCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QIdentityProxyModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QIdentityProxyModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
    "PySide2.QtCore.QIdentityProxyModel.index": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QIdentityProxyModel.insertColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QIdentityProxyModel.insertRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QIdentityProxyModel.mapFromSource": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QIdentityProxyModel.mapSelectionFromSource": ('PySide2.QtCore.QItemSelection',),
    "PySide2.QtCore.QIdentityProxyModel.mapSelectionToSource": ('PySide2.QtCore.QItemSelection',),
    "PySide2.QtCore.QIdentityProxyModel.mapToSource": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QIdentityProxyModel.match": ('PySide2.QtCore.QModelIndex', 'int', 'typing.Any', 'int', 'PySide2.QtCore.Qt.MatchFlags'),
    "PySide2.QtCore.QIdentityProxyModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
    "PySide2.QtCore.QIdentityProxyModel.removeColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QIdentityProxyModel.removeRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QIdentityProxyModel.rowCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QIdentityProxyModel.setSourceModel": ('PySide2.QtCore.QAbstractItemModel',),
    "PySide2.QtCore.QIdentityProxyModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),

# class PySide2.QtCore.QItemSelection:
    "PySide2.QtCore.QItemSelection.__init__": [(), ('PySide2.QtCore.QItemSelection',), ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex')],
    "PySide2.QtCore.QItemSelection.__add__": ('typing.Sequence',),
    "PySide2.QtCore.QItemSelection.__copy__": (),
    "PySide2.QtCore.QItemSelection.__iadd__": [('PySide2.QtCore.QItemSelectionRange',), ('typing.Sequence',)],
    "PySide2.QtCore.QItemSelection.__lshift__": [('PySide2.QtCore.QItemSelectionRange',), ('typing.Sequence',)],
    "PySide2.QtCore.QItemSelection.append": [('PySide2.QtCore.QItemSelectionRange',), ('typing.Sequence',)],
    "PySide2.QtCore.QItemSelection.at": ('int',),
    "PySide2.QtCore.QItemSelection.back": (),
    "PySide2.QtCore.QItemSelection.clear": (),
    "PySide2.QtCore.QItemSelection.constFirst": (),
    "PySide2.QtCore.QItemSelection.constLast": (),
    "PySide2.QtCore.QItemSelection.contains": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QItemSelection.count": [(), ('PySide2.QtCore.QItemSelectionRange',)],
    "PySide2.QtCore.QItemSelection.detachShared": (),
    "PySide2.QtCore.QItemSelection.empty": (),
    "PySide2.QtCore.QItemSelection.endsWith": ('PySide2.QtCore.QItemSelectionRange',),
    "PySide2.QtCore.QItemSelection.first": (),
    "PySide2.QtCore.QItemSelection.fromSet": ('typing.Set',),
    "PySide2.QtCore.QItemSelection.fromVector": ('typing.List',),
    "PySide2.QtCore.QItemSelection.front": (),
    "PySide2.QtCore.QItemSelection.indexOf": ('PySide2.QtCore.QItemSelectionRange', 'int'),
    "PySide2.QtCore.QItemSelection.indexes": (),
    "PySide2.QtCore.QItemSelection.insert": ('int', 'PySide2.QtCore.QItemSelectionRange'),
    "PySide2.QtCore.QItemSelection.isEmpty": (),
    "PySide2.QtCore.QItemSelection.isSharedWith": ('typing.Sequence',),
    "PySide2.QtCore.QItemSelection.last": (),
    "PySide2.QtCore.QItemSelection.lastIndexOf": ('PySide2.QtCore.QItemSelectionRange', 'int'),
    "PySide2.QtCore.QItemSelection.length": (),
    "PySide2.QtCore.QItemSelection.merge": ('PySide2.QtCore.QItemSelection', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'),
    "PySide2.QtCore.QItemSelection.mid": ('int', 'int'),
    "PySide2.QtCore.QItemSelection.move": ('int', 'int'),
    "PySide2.QtCore.QItemSelection.pop_back": (),
    "PySide2.QtCore.QItemSelection.pop_front": (),
    "PySide2.QtCore.QItemSelection.prepend": ('PySide2.QtCore.QItemSelectionRange',),
    "PySide2.QtCore.QItemSelection.push_back": ('PySide2.QtCore.QItemSelectionRange',),
    "PySide2.QtCore.QItemSelection.push_front": ('PySide2.QtCore.QItemSelectionRange',),
    "PySide2.QtCore.QItemSelection.removeAll": ('PySide2.QtCore.QItemSelectionRange',),
    "PySide2.QtCore.QItemSelection.removeAt": ('int',),
    "PySide2.QtCore.QItemSelection.removeFirst": (),
    "PySide2.QtCore.QItemSelection.removeLast": (),
    "PySide2.QtCore.QItemSelection.removeOne": ('PySide2.QtCore.QItemSelectionRange',),
    "PySide2.QtCore.QItemSelection.replace": ('int', 'PySide2.QtCore.QItemSelectionRange'),
    "PySide2.QtCore.QItemSelection.reserve": ('int',),
    "PySide2.QtCore.QItemSelection.select": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QItemSelection.setSharable": ('bool',),
    "PySide2.QtCore.QItemSelection.size": (),
    "PySide2.QtCore.QItemSelection.split": ('PySide2.QtCore.QItemSelectionRange', 'PySide2.QtCore.QItemSelectionRange', 'PySide2.QtCore.QItemSelection'),
    "PySide2.QtCore.QItemSelection.startsWith": ('PySide2.QtCore.QItemSelectionRange',),
    "PySide2.QtCore.QItemSelection.swap": [('int', 'int'), ('typing.Sequence',)],
    "PySide2.QtCore.QItemSelection.swapItemsAt": ('int', 'int'),
    "PySide2.QtCore.QItemSelection.takeAt": ('int',),
    "PySide2.QtCore.QItemSelection.takeFirst": (),
    "PySide2.QtCore.QItemSelection.takeLast": (),
    "PySide2.QtCore.QItemSelection.toSet": (),
    "PySide2.QtCore.QItemSelection.toVector": (),
    "PySide2.QtCore.QItemSelection.value": [('int',), ('int', 'PySide2.QtCore.QItemSelectionRange')],

# class PySide2.QtCore.QItemSelectionModel:

# class PySide2.QtCore.QItemSelectionModel.SelectionFlag:

# class PySide2.QtCore.QItemSelectionModel.SelectionFlags:
    "PySide2.QtCore.QItemSelectionModel.__init__": [('PySide2.QtCore.QAbstractItemModel',), ('PySide2.QtCore.QAbstractItemModel', 'PySide2.QtCore.QObject')],
    "PySide2.QtCore.QItemSelectionModel.clear": (),
    "PySide2.QtCore.QItemSelectionModel.clearCurrentIndex": (),
    "PySide2.QtCore.QItemSelectionModel.clearSelection": (),
    "PySide2.QtCore.QItemSelectionModel.columnIntersectsSelection": ('int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QItemSelectionModel.currentIndex": (),
    "PySide2.QtCore.QItemSelectionModel.emitSelectionChanged": ('PySide2.QtCore.QItemSelection', 'PySide2.QtCore.QItemSelection'),
    "PySide2.QtCore.QItemSelectionModel.hasSelection": (),
    "PySide2.QtCore.QItemSelectionModel.isColumnSelected": ('int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QItemSelectionModel.isRowSelected": ('int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QItemSelectionModel.isSelected": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QItemSelectionModel.model": (),
    "PySide2.QtCore.QItemSelectionModel.reset": (),
    "PySide2.QtCore.QItemSelectionModel.rowIntersectsSelection": ('int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QItemSelectionModel.select": [('PySide2.QtCore.QItemSelection', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'), ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags')],
    "PySide2.QtCore.QItemSelectionModel.selectedColumns": ('int',),
    "PySide2.QtCore.QItemSelectionModel.selectedIndexes": (),
    "PySide2.QtCore.QItemSelectionModel.selectedRows": ('int',),
    "PySide2.QtCore.QItemSelectionModel.selection": (),
    "PySide2.QtCore.QItemSelectionModel.setCurrentIndex": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'),
    "PySide2.QtCore.QItemSelectionModel.setModel": ('PySide2.QtCore.QAbstractItemModel',),

# class PySide2.QtCore.QItemSelectionRange:
    "PySide2.QtCore.QItemSelectionRange.__init__": [(), ('PySide2.QtCore.QItemSelectionRange',), ('PySide2.QtCore.QModelIndex',), ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex')],
    "PySide2.QtCore.QItemSelectionRange.__copy__": (),
    "PySide2.QtCore.QItemSelectionRange.bottom": (),
    "PySide2.QtCore.QItemSelectionRange.bottomRight": (),
    "PySide2.QtCore.QItemSelectionRange.contains": [('PySide2.QtCore.QModelIndex',), ('int', 'int', 'PySide2.QtCore.QModelIndex')],
    "PySide2.QtCore.QItemSelectionRange.height": (),
    "PySide2.QtCore.QItemSelectionRange.indexes": (),
    "PySide2.QtCore.QItemSelectionRange.intersected": ('PySide2.QtCore.QItemSelectionRange',),
    "PySide2.QtCore.QItemSelectionRange.intersects": ('PySide2.QtCore.QItemSelectionRange',),
    "PySide2.QtCore.QItemSelectionRange.isEmpty": (),
    "PySide2.QtCore.QItemSelectionRange.isValid": (),
    "PySide2.QtCore.QItemSelectionRange.left": (),
    "PySide2.QtCore.QItemSelectionRange.model": (),
    "PySide2.QtCore.QItemSelectionRange.parent": (),
    "PySide2.QtCore.QItemSelectionRange.right": (),
    "PySide2.QtCore.QItemSelectionRange.swap": ('PySide2.QtCore.QItemSelectionRange',),
    "PySide2.QtCore.QItemSelectionRange.top": (),
    "PySide2.QtCore.QItemSelectionRange.topLeft": (),
    "PySide2.QtCore.QItemSelectionRange.width": (),

# class PySide2.QtCore.QJsonArray:
    "PySide2.QtCore.QJsonArray.__init__": [(), ('PySide2.QtCore.QJsonArray',)],
    "PySide2.QtCore.QJsonArray.__add__": ('PySide2.QtCore.QJsonValue',),
    "PySide2.QtCore.QJsonArray.__copy__": (),
    "PySide2.QtCore.QJsonArray.__iadd__": ('PySide2.QtCore.QJsonValue',),
    "PySide2.QtCore.QJsonArray.__lshift__": ('PySide2.QtCore.QJsonValue',),
    "PySide2.QtCore.QJsonArray.append": ('PySide2.QtCore.QJsonValue',),
    "PySide2.QtCore.QJsonArray.at": ('int',),
    "PySide2.QtCore.QJsonArray.contains": ('PySide2.QtCore.QJsonValue',),
    "PySide2.QtCore.QJsonArray.count": (),
    "PySide2.QtCore.QJsonArray.empty": (),
    "PySide2.QtCore.QJsonArray.first": (),
    "PySide2.QtCore.QJsonArray.fromStringList": ('typing.Sequence',),
    "PySide2.QtCore.QJsonArray.fromVariantList": ('typing.Sequence',),
    "PySide2.QtCore.QJsonArray.insert": ('int', 'PySide2.QtCore.QJsonValue'),
    "PySide2.QtCore.QJsonArray.isEmpty": (),
    "PySide2.QtCore.QJsonArray.last": (),
    "PySide2.QtCore.QJsonArray.pop_back": (),
    "PySide2.QtCore.QJsonArray.pop_front": (),
    "PySide2.QtCore.QJsonArray.prepend": ('PySide2.QtCore.QJsonValue',),
    "PySide2.QtCore.QJsonArray.push_back": ('PySide2.QtCore.QJsonValue',),
    "PySide2.QtCore.QJsonArray.push_front": ('PySide2.QtCore.QJsonValue',),
    "PySide2.QtCore.QJsonArray.removeAt": ('int',),
    "PySide2.QtCore.QJsonArray.removeFirst": (),
    "PySide2.QtCore.QJsonArray.removeLast": (),
    "PySide2.QtCore.QJsonArray.replace": ('int', 'PySide2.QtCore.QJsonValue'),
    "PySide2.QtCore.QJsonArray.size": (),
    "PySide2.QtCore.QJsonArray.swap": ('PySide2.QtCore.QJsonArray',),
    "PySide2.QtCore.QJsonArray.takeAt": ('int',),
    "PySide2.QtCore.QJsonArray.toVariantList": (),

# class PySide2.QtCore.QJsonDocument:

# class PySide2.QtCore.QJsonDocument.DataValidation:

# class PySide2.QtCore.QJsonDocument.JsonFormat:
    "PySide2.QtCore.QJsonDocument.__init__": [(), ('PySide2.QtCore.QJsonArray',), ('PySide2.QtCore.QJsonDocument',), ('typing.Dict',)],
    "PySide2.QtCore.QJsonDocument.__copy__": (),
    "PySide2.QtCore.QJsonDocument.array": (),
    "PySide2.QtCore.QJsonDocument.fromBinaryData": ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QJsonDocument.DataValidation'),
    "PySide2.QtCore.QJsonDocument.fromJson": ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QJsonParseError'),
    "PySide2.QtCore.QJsonDocument.fromRawData": ('bytes', 'int', 'PySide2.QtCore.QJsonDocument.DataValidation'),
    "PySide2.QtCore.QJsonDocument.fromVariant": ('typing.Any',),
    "PySide2.QtCore.QJsonDocument.isArray": (),
    "PySide2.QtCore.QJsonDocument.isEmpty": (),
    "PySide2.QtCore.QJsonDocument.isNull": (),
    "PySide2.QtCore.QJsonDocument.isObject": (),
    "PySide2.QtCore.QJsonDocument.object": (),
    "PySide2.QtCore.QJsonDocument.rawData": (),
    "PySide2.QtCore.QJsonDocument.setArray": ('PySide2.QtCore.QJsonArray',),
    "PySide2.QtCore.QJsonDocument.setObject": ('typing.Dict',),
    "PySide2.QtCore.QJsonDocument.swap": ('PySide2.QtCore.QJsonDocument',),
    "PySide2.QtCore.QJsonDocument.toBinaryData": (),
    "PySide2.QtCore.QJsonDocument.toJson": [(), ('PySide2.QtCore.QJsonDocument.JsonFormat',)],
    "PySide2.QtCore.QJsonDocument.toVariant": (),

# class PySide2.QtCore.QJsonParseError:

# class PySide2.QtCore.QJsonParseError.ParseError:
    "PySide2.QtCore.QJsonParseError.__init__": [(), ('PySide2.QtCore.QJsonParseError',)],
    "PySide2.QtCore.QJsonParseError.__copy__": (),
    "PySide2.QtCore.QJsonParseError.errorString": (),

# class PySide2.QtCore.QJsonValue:

# class PySide2.QtCore.QJsonValue.Type:
    "PySide2.QtCore.QJsonValue.__init__": [('PySide2.QtCore.QJsonArray',), ('PySide2.QtCore.QJsonValue',), ('PySide2.QtCore.QJsonValue.Type',), ('bool',), ('bytes',), ('float',), ('int',), ('str',), ('typing.Dict',)],
    "PySide2.QtCore.QJsonValue.__copy__": (),
    "PySide2.QtCore.QJsonValue.fromVariant": ('typing.Any',),
    "PySide2.QtCore.QJsonValue.isArray": (),
    "PySide2.QtCore.QJsonValue.isBool": (),
    "PySide2.QtCore.QJsonValue.isDouble": (),
    "PySide2.QtCore.QJsonValue.isNull": (),
    "PySide2.QtCore.QJsonValue.isObject": (),
    "PySide2.QtCore.QJsonValue.isString": (),
    "PySide2.QtCore.QJsonValue.isUndefined": (),
    "PySide2.QtCore.QJsonValue.swap": ('PySide2.QtCore.QJsonValue',),
    "PySide2.QtCore.QJsonValue.toArray": [(), ('PySide2.QtCore.QJsonArray',)],
    "PySide2.QtCore.QJsonValue.toBool": ('bool',),
    "PySide2.QtCore.QJsonValue.toDouble": ('float',),
    "PySide2.QtCore.QJsonValue.toInt": ('int',),
    "PySide2.QtCore.QJsonValue.toObject": [(), ('typing.Dict',)],
    "PySide2.QtCore.QJsonValue.toString": [(), ('str',)],
    "PySide2.QtCore.QJsonValue.toVariant": (),
    "PySide2.QtCore.QJsonValue.type": (),

# class PySide2.QtCore.QLibraryInfo:

# class PySide2.QtCore.QLibraryInfo.LibraryLocation:
    "PySide2.QtCore.QLibraryInfo.build": (),
    "PySide2.QtCore.QLibraryInfo.buildDate": (),
    "PySide2.QtCore.QLibraryInfo.isDebugBuild": (),
    "PySide2.QtCore.QLibraryInfo.licensedProducts": (),
    "PySide2.QtCore.QLibraryInfo.licensee": (),
    "PySide2.QtCore.QLibraryInfo.location": ('PySide2.QtCore.QLibraryInfo.LibraryLocation',),
    "PySide2.QtCore.QLibraryInfo.platformPluginArguments": ('str',),
    "PySide2.QtCore.QLibraryInfo.version": (),

# class PySide2.QtCore.QLine:
    "PySide2.QtCore.QLine.__init__": [(), ('PySide2.QtCore.QLine',), ('PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint'), ('int', 'int', 'int', 'int')],
    "PySide2.QtCore.QLine.__copy__": (),
    "PySide2.QtCore.QLine.__reduce__": (),
    "PySide2.QtCore.QLine.__repr__": (),
    "PySide2.QtCore.QLine.center": (),
    "PySide2.QtCore.QLine.dx": (),
    "PySide2.QtCore.QLine.dy": (),
    "PySide2.QtCore.QLine.isNull": (),
    "PySide2.QtCore.QLine.p1": (),
    "PySide2.QtCore.QLine.p2": (),
    "PySide2.QtCore.QLine.setLine": ('int', 'int', 'int', 'int'),
    "PySide2.QtCore.QLine.setP1": ('PySide2.QtCore.QPoint',),
    "PySide2.QtCore.QLine.setP2": ('PySide2.QtCore.QPoint',),
    "PySide2.QtCore.QLine.setPoints": ('PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint'),
    "PySide2.QtCore.QLine.toTuple": (),
    "PySide2.QtCore.QLine.translate": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtCore.QLine.translated": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtCore.QLine.x1": (),
    "PySide2.QtCore.QLine.x2": (),
    "PySide2.QtCore.QLine.y1": (),
    "PySide2.QtCore.QLine.y2": (),

# class PySide2.QtCore.QLineF:

# class PySide2.QtCore.QLineF.IntersectType:
    "PySide2.QtCore.QLineF.__init__": [(), ('PySide2.QtCore.QLine',), ('PySide2.QtCore.QLineF',), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'), ('float', 'float', 'float', 'float')],
    "PySide2.QtCore.QLineF.__copy__": (),
    "PySide2.QtCore.QLineF.__reduce__": (),
    "PySide2.QtCore.QLineF.__repr__": (),
    "PySide2.QtCore.QLineF.angle": [(), ('PySide2.QtCore.QLineF',)],
    "PySide2.QtCore.QLineF.angleTo": ('PySide2.QtCore.QLineF',),
    "PySide2.QtCore.QLineF.center": (),
    "PySide2.QtCore.QLineF.dx": (),
    "PySide2.QtCore.QLineF.dy": (),
    "PySide2.QtCore.QLineF.fromPolar": ('float', 'float'),
    "PySide2.QtCore.QLineF.intersect": ('PySide2.QtCore.QLineF', 'PySide2.QtCore.QPointF'),
    "PySide2.QtCore.QLineF.intersects": ('PySide2.QtCore.QLineF', 'PySide2.QtCore.QPointF'),
    "PySide2.QtCore.QLineF.isNull": (),
    "PySide2.QtCore.QLineF.length": (),
    "PySide2.QtCore.QLineF.normalVector": (),
    "PySide2.QtCore.QLineF.p1": (),
    "PySide2.QtCore.QLineF.p2": (),
    "PySide2.QtCore.QLineF.pointAt": ('float',),
    "PySide2.QtCore.QLineF.setAngle": ('float',),
    "PySide2.QtCore.QLineF.setLength": ('float',),
    "PySide2.QtCore.QLineF.setLine": ('float', 'float', 'float', 'float'),
    "PySide2.QtCore.QLineF.setP1": ('PySide2.QtCore.QPointF',),
    "PySide2.QtCore.QLineF.setP2": ('PySide2.QtCore.QPointF',),
    "PySide2.QtCore.QLineF.setPoints": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'),
    "PySide2.QtCore.QLineF.toLine": (),
    "PySide2.QtCore.QLineF.toTuple": (),
    "PySide2.QtCore.QLineF.translate": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtCore.QLineF.translated": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtCore.QLineF.unitVector": (),
    "PySide2.QtCore.QLineF.x1": (),
    "PySide2.QtCore.QLineF.x2": (),
    "PySide2.QtCore.QLineF.y1": (),
    "PySide2.QtCore.QLineF.y2": (),

# class PySide2.QtCore.QLocale:

# class PySide2.QtCore.QLocale.Country:

# class PySide2.QtCore.QLocale.CurrencySymbolFormat:

# class PySide2.QtCore.QLocale.DataSizeFormat:

# class PySide2.QtCore.QLocale.DataSizeFormats:

# class PySide2.QtCore.QLocale.FloatingPointPrecisionOption:

# class PySide2.QtCore.QLocale.FormatType:

# class PySide2.QtCore.QLocale.Language:

# class PySide2.QtCore.QLocale.MeasurementSystem:

# class PySide2.QtCore.QLocale.NumberOption:

# class PySide2.QtCore.QLocale.NumberOptions:

# class PySide2.QtCore.QLocale.QuotationStyle:

# class PySide2.QtCore.QLocale.Script:
    "PySide2.QtCore.QLocale.__init__": [(), ('PySide2.QtCore.QLocale',), ('PySide2.QtCore.QLocale.Language', 'PySide2.QtCore.QLocale.Country'), ('PySide2.QtCore.QLocale.Language', 'PySide2.QtCore.QLocale.Script', 'PySide2.QtCore.QLocale.Country'), ('str',)],
    "PySide2.QtCore.QLocale.__copy__": (),
    "PySide2.QtCore.QLocale.amText": (),
    "PySide2.QtCore.QLocale.bcp47Name": (),
    "PySide2.QtCore.QLocale.c": (),
    "PySide2.QtCore.QLocale.collation": (),
    "PySide2.QtCore.QLocale.countriesForLanguage": ('PySide2.QtCore.QLocale.Language',),
    "PySide2.QtCore.QLocale.country": (),
    "PySide2.QtCore.QLocale.countryToString": ('PySide2.QtCore.QLocale.Country',),
    "PySide2.QtCore.QLocale.createSeparatedList": ('typing.Sequence',),
    "PySide2.QtCore.QLocale.currencySymbol": ('PySide2.QtCore.QLocale.CurrencySymbolFormat',),
    "PySide2.QtCore.QLocale.dateFormat": ('PySide2.QtCore.QLocale.FormatType',),
    "PySide2.QtCore.QLocale.dateTimeFormat": ('PySide2.QtCore.QLocale.FormatType',),
    "PySide2.QtCore.QLocale.dayName": ('int', 'PySide2.QtCore.QLocale.FormatType'),
    "PySide2.QtCore.QLocale.decimalPoint": (),
    "PySide2.QtCore.QLocale.exponential": (),
    "PySide2.QtCore.QLocale.firstDayOfWeek": (),
    "PySide2.QtCore.QLocale.formattedDataSize": ('int', 'int', 'PySide2.QtCore.QLocale.DataSizeFormats'),
    "PySide2.QtCore.QLocale.groupSeparator": (),
    "PySide2.QtCore.QLocale.language": (),
    "PySide2.QtCore.QLocale.languageToString": ('PySide2.QtCore.QLocale.Language',),
    "PySide2.QtCore.QLocale.matchingLocales": ('PySide2.QtCore.QLocale.Language', 'PySide2.QtCore.QLocale.Script', 'PySide2.QtCore.QLocale.Country'),
    "PySide2.QtCore.QLocale.measurementSystem": (),
    "PySide2.QtCore.QLocale.monthName": ('int', 'PySide2.QtCore.QLocale.FormatType'),
    "PySide2.QtCore.QLocale.name": (),
    "PySide2.QtCore.QLocale.nativeCountryName": (),
    "PySide2.QtCore.QLocale.nativeLanguageName": (),
    "PySide2.QtCore.QLocale.negativeSign": (),
    "PySide2.QtCore.QLocale.numberOptions": (),
    "PySide2.QtCore.QLocale.percent": (),
    "PySide2.QtCore.QLocale.pmText": (),
    "PySide2.QtCore.QLocale.positiveSign": (),
    "PySide2.QtCore.QLocale.quoteString": ('str', 'PySide2.QtCore.QLocale.QuotationStyle'),
    "PySide2.QtCore.QLocale.script": (),
    "PySide2.QtCore.QLocale.scriptToString": ('PySide2.QtCore.QLocale.Script',),
    "PySide2.QtCore.QLocale.setDefault": ('PySide2.QtCore.QLocale',),
    "PySide2.QtCore.QLocale.setNumberOptions": ('PySide2.QtCore.QLocale.NumberOptions',),
    "PySide2.QtCore.QLocale.standaloneDayName": ('int', 'PySide2.QtCore.QLocale.FormatType'),
    "PySide2.QtCore.QLocale.standaloneMonthName": ('int', 'PySide2.QtCore.QLocale.FormatType'),
    "PySide2.QtCore.QLocale.swap": ('PySide2.QtCore.QLocale',),
    "PySide2.QtCore.QLocale.system": (),
    "PySide2.QtCore.QLocale.textDirection": (),
    "PySide2.QtCore.QLocale.timeFormat": ('PySide2.QtCore.QLocale.FormatType',),
    "PySide2.QtCore.QLocale.toCurrencyString": [('float', 'str'), ('float', 'str', 'int'), ('int', 'str')],
    "PySide2.QtCore.QLocale.toDate": [('str', 'PySide2.QtCore.QLocale.FormatType'), ('str', 'PySide2.QtCore.QLocale.FormatType', 'PySide2.QtCore.QCalendar'), ('str', 'str'), ('str', 'str', 'PySide2.QtCore.QCalendar')],
    "PySide2.QtCore.QLocale.toDateTime": [('str', 'PySide2.QtCore.QLocale.FormatType'), ('str', 'PySide2.QtCore.QLocale.FormatType', 'PySide2.QtCore.QCalendar'), ('str', 'str'), ('str', 'str', 'PySide2.QtCore.QCalendar')],
    "PySide2.QtCore.QLocale.toDouble": ('str',),
    "PySide2.QtCore.QLocale.toFloat": ('str',),
    "PySide2.QtCore.QLocale.toInt": ('str',),
    "PySide2.QtCore.QLocale.toLong": ('str',),
    "PySide2.QtCore.QLocale.toLongLong": ('str',),
    "PySide2.QtCore.QLocale.toLower": ('str',),
    "PySide2.QtCore.QLocale.toShort": ('str',),
    "PySide2.QtCore.QLocale.toString": [('PySide2.QtCore.QDate', 'PySide2.QtCore.QLocale.FormatType'), ('PySide2.QtCore.QDate', 'PySide2.QtCore.QLocale.FormatType', 'PySide2.QtCore.QCalendar'), ('PySide2.QtCore.QDate', 'str'), ('PySide2.QtCore.QDateTime', 'PySide2.QtCore.QLocale.FormatType'), ('PySide2.QtCore.QDateTime', 'PySide2.QtCore.QLocale.FormatType', 'PySide2.QtCore.QCalendar'), ('PySide2.QtCore.QDateTime', 'str'), ('PySide2.QtCore.QTime', 'PySide2.QtCore.QLocale.FormatType'), ('PySide2.QtCore.QTime', 'str'), ('float', 'typing.Char', 'int'), ('int',)],
    "PySide2.QtCore.QLocale.toTime": [('str', 'PySide2.QtCore.QLocale.FormatType'), ('str', 'PySide2.QtCore.QLocale.FormatType', 'PySide2.QtCore.QCalendar'), ('str', 'str'), ('str', 'str', 'PySide2.QtCore.QCalendar')],
    "PySide2.QtCore.QLocale.toUInt": ('str',),
    "PySide2.QtCore.QLocale.toULong": ('str',),
    "PySide2.QtCore.QLocale.toULongLong": ('str',),
    "PySide2.QtCore.QLocale.toUShort": ('str',),
    "PySide2.QtCore.QLocale.toUpper": ('str',),
    "PySide2.QtCore.QLocale.uiLanguages": (),
    "PySide2.QtCore.QLocale.weekdays": (),
    "PySide2.QtCore.QLocale.zeroDigit": (),

# class PySide2.QtCore.QLockFile:

# class PySide2.QtCore.QLockFile.LockError:
    "PySide2.QtCore.QLockFile.__init__": ('str',),
    "PySide2.QtCore.QLockFile.error": (),
    "PySide2.QtCore.QLockFile.getLockInfo": (),
    "PySide2.QtCore.QLockFile.isLocked": (),
    "PySide2.QtCore.QLockFile.lock": (),
    "PySide2.QtCore.QLockFile.removeStaleLockFile": (),
    "PySide2.QtCore.QLockFile.setStaleLockTime": ('int',),
    "PySide2.QtCore.QLockFile.staleLockTime": (),
    "PySide2.QtCore.QLockFile.tryLock": ('int',),
    "PySide2.QtCore.QLockFile.unlock": (),

# class PySide2.QtCore.QMargins:
    "PySide2.QtCore.QMargins.__init__": [(), ('PySide2.QtCore.QMargins',), ('int', 'int', 'int', 'int')],
    "PySide2.QtCore.QMargins.__add__": [('PySide2.QtCore.QMargins',), ('int',)],
    "PySide2.QtCore.QMargins.__copy__": (),
    "PySide2.QtCore.QMargins.__iadd__": [('PySide2.QtCore.QMargins',), ('int',)],
    "PySide2.QtCore.QMargins.__imul__": [('float',), ('int',)],
    "PySide2.QtCore.QMargins.__isub__": [('PySide2.QtCore.QMargins',), ('int',)],
    "PySide2.QtCore.QMargins.__mul__": [('float',), ('int',)],
    "PySide2.QtCore.QMargins.__neg__": (),
    "PySide2.QtCore.QMargins.__pos__": (),
    "PySide2.QtCore.QMargins.__sub__": [('PySide2.QtCore.QMargins',), ('int',)],
    "PySide2.QtCore.QMargins.bottom": (),
    "PySide2.QtCore.QMargins.isNull": (),
    "PySide2.QtCore.QMargins.left": (),
    "PySide2.QtCore.QMargins.right": (),
    "PySide2.QtCore.QMargins.setBottom": ('int',),
    "PySide2.QtCore.QMargins.setLeft": ('int',),
    "PySide2.QtCore.QMargins.setRight": ('int',),
    "PySide2.QtCore.QMargins.setTop": ('int',),
    "PySide2.QtCore.QMargins.top": (),

# class PySide2.QtCore.QMarginsF:
    "PySide2.QtCore.QMarginsF.__init__": [(), ('PySide2.QtCore.QMargins',), ('PySide2.QtCore.QMarginsF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtCore.QMarginsF.__add__": [('PySide2.QtCore.QMarginsF',), ('float',)],
    "PySide2.QtCore.QMarginsF.__copy__": (),
    "PySide2.QtCore.QMarginsF.__iadd__": [('PySide2.QtCore.QMarginsF',), ('float',)],
    "PySide2.QtCore.QMarginsF.__imul__": ('float',),
    "PySide2.QtCore.QMarginsF.__isub__": [('PySide2.QtCore.QMarginsF',), ('float',)],
    "PySide2.QtCore.QMarginsF.__mul__": ('float',),
    "PySide2.QtCore.QMarginsF.__neg__": (),
    "PySide2.QtCore.QMarginsF.__pos__": (),
    "PySide2.QtCore.QMarginsF.__sub__": [('PySide2.QtCore.QMarginsF',), ('float',)],
    "PySide2.QtCore.QMarginsF.bottom": (),
    "PySide2.QtCore.QMarginsF.isNull": (),
    "PySide2.QtCore.QMarginsF.left": (),
    "PySide2.QtCore.QMarginsF.right": (),
    "PySide2.QtCore.QMarginsF.setBottom": ('float',),
    "PySide2.QtCore.QMarginsF.setLeft": ('float',),
    "PySide2.QtCore.QMarginsF.setRight": ('float',),
    "PySide2.QtCore.QMarginsF.setTop": ('float',),
    "PySide2.QtCore.QMarginsF.toMargins": (),
    "PySide2.QtCore.QMarginsF.top": (),

# class PySide2.QtCore.QMessageAuthenticationCode:
    "PySide2.QtCore.QMessageAuthenticationCode.__init__": ('PySide2.QtCore.QCryptographicHash.Algorithm', 'PySide2.QtCore.QByteArray'),
    "PySide2.QtCore.QMessageAuthenticationCode.addData": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QIODevice',), ('bytes', 'int')],
    "PySide2.QtCore.QMessageAuthenticationCode.hash": ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray', 'PySide2.QtCore.QCryptographicHash.Algorithm'),
    "PySide2.QtCore.QMessageAuthenticationCode.reset": (),
    "PySide2.QtCore.QMessageAuthenticationCode.result": (),
    "PySide2.QtCore.QMessageAuthenticationCode.setKey": ('PySide2.QtCore.QByteArray',),

# class PySide2.QtCore.QMessageLogContext:
    "PySide2.QtCore.QMessageLogContext.__init__": [(), ('bytes', 'int', 'bytes', 'bytes')],

# class PySide2.QtCore.QMetaClassInfo:
    "PySide2.QtCore.QMetaClassInfo.__init__": [(), ('PySide2.QtCore.QMetaClassInfo',)],
    "PySide2.QtCore.QMetaClassInfo.__copy__": (),
    "PySide2.QtCore.QMetaClassInfo.name": (),
    "PySide2.QtCore.QMetaClassInfo.value": (),

# class PySide2.QtCore.QMetaEnum:
    "PySide2.QtCore.QMetaEnum.__init__": [(), ('PySide2.QtCore.QMetaEnum',)],
    "PySide2.QtCore.QMetaEnum.__copy__": (),
    "PySide2.QtCore.QMetaEnum.enumName": (),
    "PySide2.QtCore.QMetaEnum.isFlag": (),
    "PySide2.QtCore.QMetaEnum.isScoped": (),
    "PySide2.QtCore.QMetaEnum.isValid": (),
    "PySide2.QtCore.QMetaEnum.key": ('int',),
    "PySide2.QtCore.QMetaEnum.keyCount": (),
    "PySide2.QtCore.QMetaEnum.keyToValue": ('bytes',),
    "PySide2.QtCore.QMetaEnum.keysToValue": ('bytes',),
    "PySide2.QtCore.QMetaEnum.name": (),
    "PySide2.QtCore.QMetaEnum.scope": (),
    "PySide2.QtCore.QMetaEnum.value": ('int',),
    "PySide2.QtCore.QMetaEnum.valueToKey": ('int',),
    "PySide2.QtCore.QMetaEnum.valueToKeys": ('int',),

# class PySide2.QtCore.QMetaMethod:

# class PySide2.QtCore.QMetaMethod.Access:

# class PySide2.QtCore.QMetaMethod.MethodType:
    "PySide2.QtCore.QMetaMethod.__init__": [(), ('PySide2.QtCore.QMetaMethod',)],
    "PySide2.QtCore.QMetaMethod.__copy__": (),
    "PySide2.QtCore.QMetaMethod.access": (),
    "PySide2.QtCore.QMetaMethod.enclosingMetaObject": (),
    "PySide2.QtCore.QMetaMethod.invoke": [('PySide2.QtCore.QObject', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument'), ('PySide2.QtCore.QObject', 'PySide2.QtCore.QGenericReturnArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument'), ('PySide2.QtCore.QObject', 'PySide2.QtCore.Qt.ConnectionType', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument'), ('PySide2.QtCore.QObject', 'PySide2.QtCore.Qt.ConnectionType', 'PySide2.QtCore.QGenericReturnArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument')],
    "PySide2.QtCore.QMetaMethod.invokeOnGadget": [('int', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument'), ('int', 'PySide2.QtCore.QGenericReturnArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument')],
    "PySide2.QtCore.QMetaMethod.isValid": (),
    "PySide2.QtCore.QMetaMethod.methodIndex": (),
    "PySide2.QtCore.QMetaMethod.methodSignature": (),
    "PySide2.QtCore.QMetaMethod.methodType": (),
    "PySide2.QtCore.QMetaMethod.name": (),
    "PySide2.QtCore.QMetaMethod.parameterCount": (),
    "PySide2.QtCore.QMetaMethod.parameterNames": (),
    "PySide2.QtCore.QMetaMethod.parameterType": ('int',),
    "PySide2.QtCore.QMetaMethod.parameterTypes": (),
    "PySide2.QtCore.QMetaMethod.returnType": (),
    "PySide2.QtCore.QMetaMethod.revision": (),
    "PySide2.QtCore.QMetaMethod.tag": (),
    "PySide2.QtCore.QMetaMethod.typeName": (),

# class PySide2.QtCore.QMetaObject:

# class PySide2.QtCore.QMetaObject.Call:

# class PySide2.QtCore.QMetaObject.Connection:
    "PySide2.QtCore.QMetaObject.Connection.__init__": [(), ('PySide2.QtCore.QMetaObject.Connection',)],

    "PySide2.QtCore.QMetaObject.__init__": (),
    "PySide2.QtCore.QMetaObject.cast": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QMetaObject.checkConnectArgs": [('PySide2.QtCore.QMetaMethod', 'PySide2.QtCore.QMetaMethod'), ('bytes', 'bytes')],
    "PySide2.QtCore.QMetaObject.classInfo": ('int',),
    "PySide2.QtCore.QMetaObject.classInfoCount": (),
    "PySide2.QtCore.QMetaObject.classInfoOffset": (),
    "PySide2.QtCore.QMetaObject.className": (),
    "PySide2.QtCore.QMetaObject.connectSlotsByName": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QMetaObject.constructor": ('int',),
    "PySide2.QtCore.QMetaObject.constructorCount": (),
    "PySide2.QtCore.QMetaObject.disconnect": ('PySide2.QtCore.QObject', 'int', 'PySide2.QtCore.QObject', 'int'),
    "PySide2.QtCore.QMetaObject.disconnectOne": ('PySide2.QtCore.QObject', 'int', 'PySide2.QtCore.QObject', 'int'),
    "PySide2.QtCore.QMetaObject.enumerator": ('int',),
    "PySide2.QtCore.QMetaObject.enumeratorCount": (),
    "PySide2.QtCore.QMetaObject.enumeratorOffset": (),
    "PySide2.QtCore.QMetaObject.indexOfClassInfo": ('bytes',),
    "PySide2.QtCore.QMetaObject.indexOfConstructor": ('bytes',),
    "PySide2.QtCore.QMetaObject.indexOfEnumerator": ('bytes',),
    "PySide2.QtCore.QMetaObject.indexOfMethod": ('bytes',),
    "PySide2.QtCore.QMetaObject.indexOfProperty": ('bytes',),
    "PySide2.QtCore.QMetaObject.indexOfSignal": ('bytes',),
    "PySide2.QtCore.QMetaObject.indexOfSlot": ('bytes',),
    "PySide2.QtCore.QMetaObject.inherits": ('PySide2.QtCore.QMetaObject',),
    "PySide2.QtCore.QMetaObject.invokeMethod": [('PySide2.QtCore.QObject', 'bytes', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument'), ('PySide2.QtCore.QObject', 'bytes', 'PySide2.QtCore.QGenericReturnArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument'), ('PySide2.QtCore.QObject', 'bytes', 'PySide2.QtCore.Qt.ConnectionType', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument'), ('PySide2.QtCore.QObject', 'bytes', 'PySide2.QtCore.Qt.ConnectionType', 'PySide2.QtCore.QGenericReturnArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument')],
    "PySide2.QtCore.QMetaObject.method": ('int',),
    "PySide2.QtCore.QMetaObject.methodCount": (),
    "PySide2.QtCore.QMetaObject.methodOffset": (),
    "PySide2.QtCore.QMetaObject.newInstance": ('PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument', 'PySide2.QtCore.QGenericArgument'),
    "PySide2.QtCore.QMetaObject.normalizedSignature": ('bytes',),
    "PySide2.QtCore.QMetaObject.normalizedType": ('bytes',),
    "PySide2.QtCore.QMetaObject.property": ('int',),
    "PySide2.QtCore.QMetaObject.propertyCount": (),
    "PySide2.QtCore.QMetaObject.propertyOffset": (),
    "PySide2.QtCore.QMetaObject.superClass": (),
    "PySide2.QtCore.QMetaObject.userProperty": (),

# class PySide2.QtCore.QMetaProperty:
    "PySide2.QtCore.QMetaProperty.__init__": [(), ('PySide2.QtCore.QMetaProperty',)],
    "PySide2.QtCore.QMetaProperty.__copy__": (),
    "PySide2.QtCore.QMetaProperty.enumerator": (),
    "PySide2.QtCore.QMetaProperty.hasNotifySignal": (),
    "PySide2.QtCore.QMetaProperty.hasStdCppSet": (),
    "PySide2.QtCore.QMetaProperty.isConstant": (),
    "PySide2.QtCore.QMetaProperty.isDesignable": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QMetaProperty.isEditable": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QMetaProperty.isEnumType": (),
    "PySide2.QtCore.QMetaProperty.isFinal": (),
    "PySide2.QtCore.QMetaProperty.isFlagType": (),
    "PySide2.QtCore.QMetaProperty.isReadable": (),
    "PySide2.QtCore.QMetaProperty.isResettable": (),
    "PySide2.QtCore.QMetaProperty.isScriptable": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QMetaProperty.isStored": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QMetaProperty.isUser": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QMetaProperty.isValid": (),
    "PySide2.QtCore.QMetaProperty.isWritable": (),
    "PySide2.QtCore.QMetaProperty.name": (),
    "PySide2.QtCore.QMetaProperty.notifySignal": (),
    "PySide2.QtCore.QMetaProperty.notifySignalIndex": (),
    "PySide2.QtCore.QMetaProperty.propertyIndex": (),
    "PySide2.QtCore.QMetaProperty.read": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QMetaProperty.readOnGadget": ('int',),
    "PySide2.QtCore.QMetaProperty.relativePropertyIndex": (),
    "PySide2.QtCore.QMetaProperty.reset": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QMetaProperty.resetOnGadget": ('int',),
    "PySide2.QtCore.QMetaProperty.revision": (),
    "PySide2.QtCore.QMetaProperty.type": (),
    "PySide2.QtCore.QMetaProperty.typeName": (),
    "PySide2.QtCore.QMetaProperty.userType": (),
    "PySide2.QtCore.QMetaProperty.write": ('PySide2.QtCore.QObject', 'typing.Any'),
    "PySide2.QtCore.QMetaProperty.writeOnGadget": ('int', 'typing.Any'),

# class PySide2.QtCore.QMimeData:
    "PySide2.QtCore.QMimeData.__init__": (),
    "PySide2.QtCore.QMimeData.clear": (),
    "PySide2.QtCore.QMimeData.colorData": (),
    "PySide2.QtCore.QMimeData.data": ('str',),
    "PySide2.QtCore.QMimeData.formats": (),
    "PySide2.QtCore.QMimeData.hasColor": (),
    "PySide2.QtCore.QMimeData.hasFormat": ('str',),
    "PySide2.QtCore.QMimeData.hasHtml": (),
    "PySide2.QtCore.QMimeData.hasImage": (),
    "PySide2.QtCore.QMimeData.hasText": (),
    "PySide2.QtCore.QMimeData.hasUrls": (),
    "PySide2.QtCore.QMimeData.html": (),
    "PySide2.QtCore.QMimeData.imageData": (),
    "PySide2.QtCore.QMimeData.removeFormat": ('str',),
    "PySide2.QtCore.QMimeData.retrieveData": ('str', 'type'),
    "PySide2.QtCore.QMimeData.setColorData": ('typing.Any',),
    "PySide2.QtCore.QMimeData.setData": ('str', 'PySide2.QtCore.QByteArray'),
    "PySide2.QtCore.QMimeData.setHtml": ('str',),
    "PySide2.QtCore.QMimeData.setImageData": ('typing.Any',),
    "PySide2.QtCore.QMimeData.setText": ('str',),
    "PySide2.QtCore.QMimeData.setUrls": ('typing.Sequence',),
    "PySide2.QtCore.QMimeData.text": (),
    "PySide2.QtCore.QMimeData.urls": (),

# class PySide2.QtCore.QMimeDatabase:

# class PySide2.QtCore.QMimeDatabase.MatchMode:
    "PySide2.QtCore.QMimeDatabase.__init__": (),
    "PySide2.QtCore.QMimeDatabase.allMimeTypes": (),
    "PySide2.QtCore.QMimeDatabase.mimeTypeForData": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QIODevice',)],
    "PySide2.QtCore.QMimeDatabase.mimeTypeForFile": [('PySide2.QtCore.QFileInfo', 'PySide2.QtCore.QMimeDatabase.MatchMode'), ('str', 'PySide2.QtCore.QMimeDatabase.MatchMode')],
    "PySide2.QtCore.QMimeDatabase.mimeTypeForFileNameAndData": [('str', 'PySide2.QtCore.QByteArray'), ('str', 'PySide2.QtCore.QIODevice')],
    "PySide2.QtCore.QMimeDatabase.mimeTypeForName": ('str',),
    "PySide2.QtCore.QMimeDatabase.mimeTypeForUrl": ('PySide2.QtCore.QUrl',),
    "PySide2.QtCore.QMimeDatabase.mimeTypesForFileName": ('str',),
    "PySide2.QtCore.QMimeDatabase.suffixForFileName": ('str',),

# class PySide2.QtCore.QMimeType:
    "PySide2.QtCore.QMimeType.__init__": [(), ('PySide2.QtCore.QMimeType',)],
    "PySide2.QtCore.QMimeType.__copy__": (),
    "PySide2.QtCore.QMimeType.aliases": (),
    "PySide2.QtCore.QMimeType.allAncestors": (),
    "PySide2.QtCore.QMimeType.comment": (),
    "PySide2.QtCore.QMimeType.filterString": (),
    "PySide2.QtCore.QMimeType.genericIconName": (),
    "PySide2.QtCore.QMimeType.globPatterns": (),
    "PySide2.QtCore.QMimeType.iconName": (),
    "PySide2.QtCore.QMimeType.inherits": ('str',),
    "PySide2.QtCore.QMimeType.isDefault": (),
    "PySide2.QtCore.QMimeType.isValid": (),
    "PySide2.QtCore.QMimeType.name": (),
    "PySide2.QtCore.QMimeType.parentMimeTypes": (),
    "PySide2.QtCore.QMimeType.preferredSuffix": (),
    "PySide2.QtCore.QMimeType.suffixes": (),
    "PySide2.QtCore.QMimeType.swap": ('PySide2.QtCore.QMimeType',),

# class PySide2.QtCore.QModelIndex:
    "PySide2.QtCore.QModelIndex.__init__": [(), ('PySide2.QtCore.QModelIndex',)],
    "PySide2.QtCore.QModelIndex.__copy__": (),
    "PySide2.QtCore.QModelIndex.child": ('int', 'int'),
    "PySide2.QtCore.QModelIndex.column": (),
    "PySide2.QtCore.QModelIndex.data": ('int',),
    "PySide2.QtCore.QModelIndex.flags": (),
    "PySide2.QtCore.QModelIndex.internalId": (),
    "PySide2.QtCore.QModelIndex.internalPointer": (),
    "PySide2.QtCore.QModelIndex.isValid": (),
    "PySide2.QtCore.QModelIndex.model": (),
    "PySide2.QtCore.QModelIndex.parent": (),
    "PySide2.QtCore.QModelIndex.row": (),
    "PySide2.QtCore.QModelIndex.sibling": ('int', 'int'),
    "PySide2.QtCore.QModelIndex.siblingAtColumn": ('int',),
    "PySide2.QtCore.QModelIndex.siblingAtRow": ('int',),

# class PySide2.QtCore.QMutex:

# class PySide2.QtCore.QMutex.RecursionMode:
    "PySide2.QtCore.QMutex.__init__": [(), ('PySide2.QtCore.QMutex.RecursionMode',)],
    "PySide2.QtCore.QMutex.isRecursive": (),
    "PySide2.QtCore.QMutex.lock": (),
    "PySide2.QtCore.QMutex.tryLock": [(), ('int',)],
    "PySide2.QtCore.QMutex.try_lock": (),
    "PySide2.QtCore.QMutex.unlock": (),

# class PySide2.QtCore.QMutexLocker:
    "PySide2.QtCore.QMutexLocker.__init__": [('PySide2.QtCore.QBasicMutex',), ('PySide2.QtCore.QRecursiveMutex',)],
    "PySide2.QtCore.QMutexLocker.__enter__": (),
    "PySide2.QtCore.QMutexLocker.__exit__": ('object', 'object', 'object'),
    "PySide2.QtCore.QMutexLocker.mutex": (),
    "PySide2.QtCore.QMutexLocker.relock": (),
    "PySide2.QtCore.QMutexLocker.unlock": (),

# class PySide2.QtCore.QObject:
    "PySide2.QtCore.QObject.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QObject.blockSignals": ('bool',),
    "PySide2.QtCore.QObject.childEvent": ('PySide2.QtCore.QChildEvent',),
    "PySide2.QtCore.QObject.children": (),
    "PySide2.QtCore.QObject.connect": [('PySide2.QtCore.QObject', 'PySide2.QtCore.QMetaMethod', 'PySide2.QtCore.QObject', 'PySide2.QtCore.QMetaMethod', 'PySide2.QtCore.Qt.ConnectionType'), ('PySide2.QtCore.QObject', 'bytes', 'PySide2.QtCore.QObject', 'bytes', 'PySide2.QtCore.Qt.ConnectionType'), ('PySide2.QtCore.QObject', 'bytes', 'bytes', 'PySide2.QtCore.Qt.ConnectionType'), ('PySide2.QtCore.QObject', 'bytes', 'typing.Callable', 'PySide2.QtCore.Qt.ConnectionType'), ('bytes', 'PySide2.QtCore.QObject', 'bytes', 'PySide2.QtCore.Qt.ConnectionType'), ('bytes', 'typing.Callable', 'PySide2.QtCore.Qt.ConnectionType')],
    "PySide2.QtCore.QObject.connectNotify": ('PySide2.QtCore.QMetaMethod',),
    "PySide2.QtCore.QObject.customEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QObject.deleteLater": (),
    "PySide2.QtCore.QObject.disconnect": [('PySide2.QtCore.QMetaObject.Connection',), ('PySide2.QtCore.QObject', 'PySide2.QtCore.QMetaMethod', 'PySide2.QtCore.QObject', 'PySide2.QtCore.QMetaMethod'), ('PySide2.QtCore.QObject', 'bytes'), ('PySide2.QtCore.QObject', 'bytes', 'PySide2.QtCore.QObject', 'bytes'), ('PySide2.QtCore.QObject', 'bytes', 'typing.Callable'), ('bytes', 'PySide2.QtCore.QObject', 'bytes'), ('bytes', 'typing.Callable')],
    "PySide2.QtCore.QObject.disconnectNotify": ('PySide2.QtCore.QMetaMethod',),
    "PySide2.QtCore.QObject.dumpObjectInfo": (),
    "PySide2.QtCore.QObject.dumpObjectTree": (),
    "PySide2.QtCore.QObject.dynamicPropertyNames": (),
    "PySide2.QtCore.QObject.emit": ('bytes', 'None'),
    "PySide2.QtCore.QObject.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QObject.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtCore.QObject.findChild": ('type', 'str'),
    "PySide2.QtCore.QObject.findChildren": [('type', 'PySide2.QtCore.QRegExp'), ('type', 'str')],
    "PySide2.QtCore.QObject.inherits": ('bytes',),
    "PySide2.QtCore.QObject.installEventFilter": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QObject.isSignalConnected": ('PySide2.QtCore.QMetaMethod',),
    "PySide2.QtCore.QObject.isWidgetType": (),
    "PySide2.QtCore.QObject.isWindowType": (),
    "PySide2.QtCore.QObject.killTimer": ('int',),
    "PySide2.QtCore.QObject.metaObject": (),
    "PySide2.QtCore.QObject.moveToThread": ('PySide2.QtCore.QThread',),
    "PySide2.QtCore.QObject.objectName": (),
    "PySide2.QtCore.QObject.parent": (),
    "PySide2.QtCore.QObject.property": ('bytes',),
    "PySide2.QtCore.QObject.receivers": ('bytes',),
    "PySide2.QtCore.QObject.registerUserData": (),
    "PySide2.QtCore.QObject.removeEventFilter": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QObject.sender": (),
    "PySide2.QtCore.QObject.senderSignalIndex": (),
    "PySide2.QtCore.QObject.setObjectName": ('str',),
    "PySide2.QtCore.QObject.setParent": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QObject.setProperty": ('bytes', 'typing.Any'),
    "PySide2.QtCore.QObject.signalsBlocked": (),
    "PySide2.QtCore.QObject.startTimer": ('int', 'PySide2.QtCore.Qt.TimerType'),
    "PySide2.QtCore.QObject.thread": (),
    "PySide2.QtCore.QObject.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtCore.QObject.tr": ('bytes', 'bytes', 'int'),

# class PySide2.QtCore.QOperatingSystemVersion:

# class PySide2.QtCore.QOperatingSystemVersion.OSType:
    "PySide2.QtCore.QOperatingSystemVersion.__init__": [('PySide2.QtCore.QOperatingSystemVersion',), ('PySide2.QtCore.QOperatingSystemVersion.OSType', 'int', 'int', 'int')],
    "PySide2.QtCore.QOperatingSystemVersion.__copy__": (),
    "PySide2.QtCore.QOperatingSystemVersion.current": (),
    "PySide2.QtCore.QOperatingSystemVersion.currentType": (),
    "PySide2.QtCore.QOperatingSystemVersion.majorVersion": (),
    "PySide2.QtCore.QOperatingSystemVersion.microVersion": (),
    "PySide2.QtCore.QOperatingSystemVersion.minorVersion": (),
    "PySide2.QtCore.QOperatingSystemVersion.name": (),
    "PySide2.QtCore.QOperatingSystemVersion.segmentCount": (),
    "PySide2.QtCore.QOperatingSystemVersion.type": (),

# class PySide2.QtCore.QParallelAnimationGroup:
    "PySide2.QtCore.QParallelAnimationGroup.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QParallelAnimationGroup.duration": (),
    "PySide2.QtCore.QParallelAnimationGroup.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QParallelAnimationGroup.updateCurrentTime": ('int',),
    "PySide2.QtCore.QParallelAnimationGroup.updateDirection": ('PySide2.QtCore.QAbstractAnimation.Direction',),
    "PySide2.QtCore.QParallelAnimationGroup.updateState": ('PySide2.QtCore.QAbstractAnimation.State', 'PySide2.QtCore.QAbstractAnimation.State'),

# class PySide2.QtCore.QPauseAnimation:
    "PySide2.QtCore.QPauseAnimation.__init__": [('PySide2.QtCore.QObject',), ('int', 'PySide2.QtCore.QObject')],
    "PySide2.QtCore.QPauseAnimation.duration": (),
    "PySide2.QtCore.QPauseAnimation.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QPauseAnimation.setDuration": ('int',),
    "PySide2.QtCore.QPauseAnimation.updateCurrentTime": ('int',),

# class PySide2.QtCore.QPersistentModelIndex:
    "PySide2.QtCore.QPersistentModelIndex.__init__": [(), ('PySide2.QtCore.QModelIndex',), ('PySide2.QtCore.QPersistentModelIndex',)],
    "PySide2.QtCore.QPersistentModelIndex.__copy__": (),
    "PySide2.QtCore.QPersistentModelIndex.child": ('int', 'int'),
    "PySide2.QtCore.QPersistentModelIndex.column": (),
    "PySide2.QtCore.QPersistentModelIndex.data": ('int',),
    "PySide2.QtCore.QPersistentModelIndex.flags": (),
    "PySide2.QtCore.QPersistentModelIndex.internalId": (),
    "PySide2.QtCore.QPersistentModelIndex.internalPointer": (),
    "PySide2.QtCore.QPersistentModelIndex.isValid": (),
    "PySide2.QtCore.QPersistentModelIndex.model": (),
    "PySide2.QtCore.QPersistentModelIndex.parent": (),
    "PySide2.QtCore.QPersistentModelIndex.row": (),
    "PySide2.QtCore.QPersistentModelIndex.sibling": ('int', 'int'),
    "PySide2.QtCore.QPersistentModelIndex.swap": ('PySide2.QtCore.QPersistentModelIndex',),

# class PySide2.QtCore.QPluginLoader:
    "PySide2.QtCore.QPluginLoader.__init__": [('PySide2.QtCore.QObject',), ('str', 'PySide2.QtCore.QObject')],
    "PySide2.QtCore.QPluginLoader.errorString": (),
    "PySide2.QtCore.QPluginLoader.fileName": (),
    "PySide2.QtCore.QPluginLoader.instance": (),
    "PySide2.QtCore.QPluginLoader.isLoaded": (),
    "PySide2.QtCore.QPluginLoader.load": (),
    "PySide2.QtCore.QPluginLoader.metaData": (),
    "PySide2.QtCore.QPluginLoader.setFileName": ('str',),
    "PySide2.QtCore.QPluginLoader.staticInstances": (),
    "PySide2.QtCore.QPluginLoader.unload": (),

# class PySide2.QtCore.QPoint:
    "PySide2.QtCore.QPoint.__init__": [(), ('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtCore.QPoint.__add__": ('PySide2.QtCore.QPoint',),
    "PySide2.QtCore.QPoint.__copy__": (),
    "PySide2.QtCore.QPoint.__iadd__": ('PySide2.QtCore.QPoint',),
    "PySide2.QtCore.QPoint.__imul__": [('float',), ('int',)],
    "PySide2.QtCore.QPoint.__isub__": ('PySide2.QtCore.QPoint',),
    "PySide2.QtCore.QPoint.__mul__": [('float',), ('int',)],
    "PySide2.QtCore.QPoint.__neg__": (),
    "PySide2.QtCore.QPoint.__pos__": (),
    "PySide2.QtCore.QPoint.__reduce__": (),
    "PySide2.QtCore.QPoint.__repr__": (),
    "PySide2.QtCore.QPoint.__sub__": ('PySide2.QtCore.QPoint',),
    "PySide2.QtCore.QPoint.dotProduct": ('PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint'),
    "PySide2.QtCore.QPoint.isNull": (),
    "PySide2.QtCore.QPoint.manhattanLength": (),
    "PySide2.QtCore.QPoint.setX": ('int',),
    "PySide2.QtCore.QPoint.setY": ('int',),
    "PySide2.QtCore.QPoint.toTuple": (),
    "PySide2.QtCore.QPoint.transposed": (),
    "PySide2.QtCore.QPoint.x": (),
    "PySide2.QtCore.QPoint.y": (),

# class PySide2.QtCore.QPointF:
    "PySide2.QtCore.QPointF.__init__": [(), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtCore.QPointF.__add__": ('PySide2.QtCore.QPointF',),
    "PySide2.QtCore.QPointF.__copy__": (),
    "PySide2.QtCore.QPointF.__iadd__": ('PySide2.QtCore.QPointF',),
    "PySide2.QtCore.QPointF.__imul__": ('float',),
    "PySide2.QtCore.QPointF.__isub__": ('PySide2.QtCore.QPointF',),
    "PySide2.QtCore.QPointF.__mul__": ('float',),
    "PySide2.QtCore.QPointF.__neg__": (),
    "PySide2.QtCore.QPointF.__pos__": (),
    "PySide2.QtCore.QPointF.__reduce__": (),
    "PySide2.QtCore.QPointF.__repr__": (),
    "PySide2.QtCore.QPointF.__sub__": ('PySide2.QtCore.QPointF',),
    "PySide2.QtCore.QPointF.dotProduct": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'),
    "PySide2.QtCore.QPointF.isNull": (),
    "PySide2.QtCore.QPointF.manhattanLength": (),
    "PySide2.QtCore.QPointF.setX": ('float',),
    "PySide2.QtCore.QPointF.setY": ('float',),
    "PySide2.QtCore.QPointF.toPoint": (),
    "PySide2.QtCore.QPointF.toTuple": (),
    "PySide2.QtCore.QPointF.transposed": (),
    "PySide2.QtCore.QPointF.x": (),
    "PySide2.QtCore.QPointF.y": (),

# class PySide2.QtCore.QProcess:

# class PySide2.QtCore.QProcess.ExitStatus:

# class PySide2.QtCore.QProcess.InputChannelMode:

# class PySide2.QtCore.QProcess.ProcessChannel:

# class PySide2.QtCore.QProcess.ProcessChannelMode:

# class PySide2.QtCore.QProcess.ProcessError:

# class PySide2.QtCore.QProcess.ProcessState:
    "PySide2.QtCore.QProcess.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QProcess.arguments": (),
    "PySide2.QtCore.QProcess.atEnd": (),
    "PySide2.QtCore.QProcess.bytesAvailable": (),
    "PySide2.QtCore.QProcess.bytesToWrite": (),
    "PySide2.QtCore.QProcess.canReadLine": (),
    "PySide2.QtCore.QProcess.close": (),
    "PySide2.QtCore.QProcess.closeReadChannel": ('PySide2.QtCore.QProcess.ProcessChannel',),
    "PySide2.QtCore.QProcess.closeWriteChannel": (),
    "PySide2.QtCore.QProcess.environment": (),
    "PySide2.QtCore.QProcess.error": (),
    "PySide2.QtCore.QProcess.execute": [('str',), ('str', 'typing.Sequence')],
    "PySide2.QtCore.QProcess.exitCode": (),
    "PySide2.QtCore.QProcess.exitStatus": (),
    "PySide2.QtCore.QProcess.inputChannelMode": (),
    "PySide2.QtCore.QProcess.isSequential": (),
    "PySide2.QtCore.QProcess.kill": (),
    "PySide2.QtCore.QProcess.nativeArguments": (),
    "PySide2.QtCore.QProcess.nullDevice": (),
    "PySide2.QtCore.QProcess.open": ('PySide2.QtCore.QIODevice.OpenMode',),
    "PySide2.QtCore.QProcess.pid": (),
    "PySide2.QtCore.QProcess.processChannelMode": (),
    "PySide2.QtCore.QProcess.processEnvironment": (),
    "PySide2.QtCore.QProcess.processId": (),
    "PySide2.QtCore.QProcess.program": (),
    "PySide2.QtCore.QProcess.readAllStandardError": (),
    "PySide2.QtCore.QProcess.readAllStandardOutput": (),
    "PySide2.QtCore.QProcess.readChannel": (),
    "PySide2.QtCore.QProcess.readData": ('bytes', 'int'),
    "PySide2.QtCore.QProcess.setArguments": ('typing.Sequence',),
    "PySide2.QtCore.QProcess.setEnvironment": ('typing.Sequence',),
    "PySide2.QtCore.QProcess.setInputChannelMode": ('PySide2.QtCore.QProcess.InputChannelMode',),
    "PySide2.QtCore.QProcess.setNativeArguments": ('str',),
    "PySide2.QtCore.QProcess.setProcessChannelMode": ('PySide2.QtCore.QProcess.ProcessChannelMode',),
    "PySide2.QtCore.QProcess.setProcessEnvironment": ('PySide2.QtCore.QProcessEnvironment',),
    "PySide2.QtCore.QProcess.setProcessState": ('PySide2.QtCore.QProcess.ProcessState',),
    "PySide2.QtCore.QProcess.setProgram": ('str',),
    "PySide2.QtCore.QProcess.setReadChannel": ('PySide2.QtCore.QProcess.ProcessChannel',),
    "PySide2.QtCore.QProcess.setStandardErrorFile": ('str', 'PySide2.QtCore.QIODevice.OpenMode'),
    "PySide2.QtCore.QProcess.setStandardInputFile": ('str',),
    "PySide2.QtCore.QProcess.setStandardOutputFile": ('str', 'PySide2.QtCore.QIODevice.OpenMode'),
    "PySide2.QtCore.QProcess.setStandardOutputProcess": ('PySide2.QtCore.QProcess',),
    "PySide2.QtCore.QProcess.setWorkingDirectory": ('str',),
    "PySide2.QtCore.QProcess.setupChildProcess": (),
    "PySide2.QtCore.QProcess.start": [('PySide2.QtCore.QIODevice.OpenMode',), ('str', 'PySide2.QtCore.QIODevice.OpenMode'), ('str', 'typing.Sequence', 'PySide2.QtCore.QIODevice.OpenMode')],
    "PySide2.QtCore.QProcess.startDetached": [(), ('str',), ('str', 'typing.Sequence'), ('str', 'typing.Sequence', 'str')],
    "PySide2.QtCore.QProcess.state": (),
    "PySide2.QtCore.QProcess.systemEnvironment": (),
    "PySide2.QtCore.QProcess.terminate": (),
    "PySide2.QtCore.QProcess.waitForBytesWritten": ('int',),
    "PySide2.QtCore.QProcess.waitForFinished": ('int',),
    "PySide2.QtCore.QProcess.waitForReadyRead": ('int',),
    "PySide2.QtCore.QProcess.waitForStarted": ('int',),
    "PySide2.QtCore.QProcess.workingDirectory": (),
    "PySide2.QtCore.QProcess.writeData": ('bytes', 'int'),

# class PySide2.QtCore.QProcessEnvironment:
    "PySide2.QtCore.QProcessEnvironment.__init__": [(), ('PySide2.QtCore.QProcessEnvironment',)],
    "PySide2.QtCore.QProcessEnvironment.__copy__": (),
    "PySide2.QtCore.QProcessEnvironment.clear": (),
    "PySide2.QtCore.QProcessEnvironment.contains": ('str',),
    "PySide2.QtCore.QProcessEnvironment.insert": [('PySide2.QtCore.QProcessEnvironment',), ('str', 'str')],
    "PySide2.QtCore.QProcessEnvironment.isEmpty": (),
    "PySide2.QtCore.QProcessEnvironment.keys": (),
    "PySide2.QtCore.QProcessEnvironment.remove": ('str',),
    "PySide2.QtCore.QProcessEnvironment.swap": ('PySide2.QtCore.QProcessEnvironment',),
    "PySide2.QtCore.QProcessEnvironment.systemEnvironment": (),
    "PySide2.QtCore.QProcessEnvironment.toStringList": (),
    "PySide2.QtCore.QProcessEnvironment.value": ('str', 'str'),

# class PySide2.QtCore.QPropertyAnimation:
    "PySide2.QtCore.QPropertyAnimation.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtCore.QObject', 'PySide2.QtCore.QByteArray', 'PySide2.QtCore.QObject')],
    "PySide2.QtCore.QPropertyAnimation.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QPropertyAnimation.propertyName": (),
    "PySide2.QtCore.QPropertyAnimation.setPropertyName": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtCore.QPropertyAnimation.setTargetObject": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QPropertyAnimation.targetObject": (),
    "PySide2.QtCore.QPropertyAnimation.updateCurrentValue": ('typing.Any',),
    "PySide2.QtCore.QPropertyAnimation.updateState": ('PySide2.QtCore.QAbstractAnimation.State', 'PySide2.QtCore.QAbstractAnimation.State'),

# class PySide2.QtCore.QRandomGenerator:
    "PySide2.QtCore.QRandomGenerator.__init__": [('PySide2.QtCore.QRandomGenerator',), ('int',), ('int', 'int')],
    "PySide2.QtCore.QRandomGenerator.bounded": [('float',), ('int',), ('int', 'int')],
    "PySide2.QtCore.QRandomGenerator.discard": ('int',),
    "PySide2.QtCore.QRandomGenerator.generate": (),
    "PySide2.QtCore.QRandomGenerator.generate64": (),
    "PySide2.QtCore.QRandomGenerator.generateDouble": (),
    "PySide2.QtCore.QRandomGenerator.global_": (),
    "PySide2.QtCore.QRandomGenerator.max": (),
    "PySide2.QtCore.QRandomGenerator.min": (),
    "PySide2.QtCore.QRandomGenerator.securelySeeded": (),
    "PySide2.QtCore.QRandomGenerator.seed": ('int',),
    "PySide2.QtCore.QRandomGenerator.system": (),

# class PySide2.QtCore.QRandomGenerator64:
    "PySide2.QtCore.QRandomGenerator64.__init__": [('PySide2.QtCore.QRandomGenerator',), ('int',), ('int', 'int')],
    "PySide2.QtCore.QRandomGenerator64.discard": ('int',),
    "PySide2.QtCore.QRandomGenerator64.generate": (),
    "PySide2.QtCore.QRandomGenerator64.global_": (),
    "PySide2.QtCore.QRandomGenerator64.max": (),
    "PySide2.QtCore.QRandomGenerator64.min": (),
    "PySide2.QtCore.QRandomGenerator64.securelySeeded": (),
    "PySide2.QtCore.QRandomGenerator64.system": (),

# class PySide2.QtCore.QReadLocker:
    "PySide2.QtCore.QReadLocker.__init__": ('PySide2.QtCore.QReadWriteLock',),
    "PySide2.QtCore.QReadLocker.__enter__": (),
    "PySide2.QtCore.QReadLocker.__exit__": ('object', 'object', 'object'),
    "PySide2.QtCore.QReadLocker.readWriteLock": (),
    "PySide2.QtCore.QReadLocker.relock": (),
    "PySide2.QtCore.QReadLocker.unlock": (),

# class PySide2.QtCore.QReadWriteLock:

# class PySide2.QtCore.QReadWriteLock.RecursionMode:
    "PySide2.QtCore.QReadWriteLock.__init__": ('PySide2.QtCore.QReadWriteLock.RecursionMode',),
    "PySide2.QtCore.QReadWriteLock.lockForRead": (),
    "PySide2.QtCore.QReadWriteLock.lockForWrite": (),
    "PySide2.QtCore.QReadWriteLock.tryLockForRead": [(), ('int',)],
    "PySide2.QtCore.QReadWriteLock.tryLockForWrite": [(), ('int',)],
    "PySide2.QtCore.QReadWriteLock.unlock": (),

# class PySide2.QtCore.QRect:
    "PySide2.QtCore.QRect.__init__": [(), ('PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint'), ('PySide2.QtCore.QPoint', 'PySide2.QtCore.QSize'), ('PySide2.QtCore.QRect',), ('int', 'int', 'int', 'int')],
    "PySide2.QtCore.QRect.__add__": ('PySide2.QtCore.QMargins',),
    "PySide2.QtCore.QRect.__and__": ('PySide2.QtCore.QRect',),
    "PySide2.QtCore.QRect.__copy__": (),
    "PySide2.QtCore.QRect.__iadd__": ('PySide2.QtCore.QMargins',),
    "PySide2.QtCore.QRect.__iand__": ('PySide2.QtCore.QRect',),
    "PySide2.QtCore.QRect.__ior__": ('PySide2.QtCore.QRect',),
    "PySide2.QtCore.QRect.__isub__": ('PySide2.QtCore.QMargins',),
    "PySide2.QtCore.QRect.__or__": ('PySide2.QtCore.QRect',),
    "PySide2.QtCore.QRect.__reduce__": (),
    "PySide2.QtCore.QRect.__repr__": (),
    "PySide2.QtCore.QRect.__sub__": ('PySide2.QtCore.QMargins',),
    "PySide2.QtCore.QRect.adjust": ('int', 'int', 'int', 'int'),
    "PySide2.QtCore.QRect.adjusted": ('int', 'int', 'int', 'int'),
    "PySide2.QtCore.QRect.bottom": (),
    "PySide2.QtCore.QRect.bottomLeft": (),
    "PySide2.QtCore.QRect.bottomRight": (),
    "PySide2.QtCore.QRect.center": (),
    "PySide2.QtCore.QRect.contains": [('PySide2.QtCore.QPoint', 'bool'), ('PySide2.QtCore.QRect', 'bool'), ('int', 'int'), ('int', 'int', 'bool')],
    "PySide2.QtCore.QRect.getCoords": (),
    "PySide2.QtCore.QRect.getRect": (),
    "PySide2.QtCore.QRect.height": (),
    "PySide2.QtCore.QRect.intersected": ('PySide2.QtCore.QRect',),
    "PySide2.QtCore.QRect.intersects": ('PySide2.QtCore.QRect',),
    "PySide2.QtCore.QRect.isEmpty": (),
    "PySide2.QtCore.QRect.isNull": (),
    "PySide2.QtCore.QRect.isValid": (),
    "PySide2.QtCore.QRect.left": (),
    "PySide2.QtCore.QRect.marginsAdded": ('PySide2.QtCore.QMargins',),
    "PySide2.QtCore.QRect.marginsRemoved": ('PySide2.QtCore.QMargins',),
    "PySide2.QtCore.QRect.moveBottom": ('int',),
    "PySide2.QtCore.QRect.moveBottomLeft": ('PySide2.QtCore.QPoint',),
    "PySide2.QtCore.QRect.moveBottomRight": ('PySide2.QtCore.QPoint',),
    "PySide2.QtCore.QRect.moveCenter": ('PySide2.QtCore.QPoint',),
    "PySide2.QtCore.QRect.moveLeft": ('int',),
    "PySide2.QtCore.QRect.moveRight": ('int',),
    "PySide2.QtCore.QRect.moveTo": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtCore.QRect.moveTop": ('int',),
    "PySide2.QtCore.QRect.moveTopLeft": ('PySide2.QtCore.QPoint',),
    "PySide2.QtCore.QRect.moveTopRight": ('PySide2.QtCore.QPoint',),
    "PySide2.QtCore.QRect.normalized": (),
    "PySide2.QtCore.QRect.right": (),
    "PySide2.QtCore.QRect.setBottom": ('int',),
    "PySide2.QtCore.QRect.setBottomLeft": ('PySide2.QtCore.QPoint',),
    "PySide2.QtCore.QRect.setBottomRight": ('PySide2.QtCore.QPoint',),
    "PySide2.QtCore.QRect.setCoords": ('int', 'int', 'int', 'int'),
    "PySide2.QtCore.QRect.setHeight": ('int',),
    "PySide2.QtCore.QRect.setLeft": ('int',),
    "PySide2.QtCore.QRect.setRect": ('int', 'int', 'int', 'int'),
    "PySide2.QtCore.QRect.setRight": ('int',),
    "PySide2.QtCore.QRect.setSize": ('PySide2.QtCore.QSize',),
    "PySide2.QtCore.QRect.setTop": ('int',),
    "PySide2.QtCore.QRect.setTopLeft": ('PySide2.QtCore.QPoint',),
    "PySide2.QtCore.QRect.setTopRight": ('PySide2.QtCore.QPoint',),
    "PySide2.QtCore.QRect.setWidth": ('int',),
    "PySide2.QtCore.QRect.setX": ('int',),
    "PySide2.QtCore.QRect.setY": ('int',),
    "PySide2.QtCore.QRect.size": (),
    "PySide2.QtCore.QRect.top": (),
    "PySide2.QtCore.QRect.topLeft": (),
    "PySide2.QtCore.QRect.topRight": (),
    "PySide2.QtCore.QRect.translate": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtCore.QRect.translated": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtCore.QRect.transposed": (),
    "PySide2.QtCore.QRect.united": ('PySide2.QtCore.QRect',),
    "PySide2.QtCore.QRect.width": (),
    "PySide2.QtCore.QRect.x": (),
    "PySide2.QtCore.QRect.y": (),

# class PySide2.QtCore.QRectF:
    "PySide2.QtCore.QRectF.__init__": [(), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QSizeF'), ('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtCore.QRectF.__add__": ('PySide2.QtCore.QMarginsF',),
    "PySide2.QtCore.QRectF.__and__": ('PySide2.QtCore.QRectF',),
    "PySide2.QtCore.QRectF.__copy__": (),
    "PySide2.QtCore.QRectF.__iadd__": ('PySide2.QtCore.QMarginsF',),
    "PySide2.QtCore.QRectF.__iand__": ('PySide2.QtCore.QRectF',),
    "PySide2.QtCore.QRectF.__ior__": ('PySide2.QtCore.QRectF',),
    "PySide2.QtCore.QRectF.__isub__": ('PySide2.QtCore.QMarginsF',),
    "PySide2.QtCore.QRectF.__or__": ('PySide2.QtCore.QRectF',),
    "PySide2.QtCore.QRectF.__reduce__": (),
    "PySide2.QtCore.QRectF.__repr__": (),
    "PySide2.QtCore.QRectF.__sub__": ('PySide2.QtCore.QMarginsF',),
    "PySide2.QtCore.QRectF.adjust": ('float', 'float', 'float', 'float'),
    "PySide2.QtCore.QRectF.adjusted": ('float', 'float', 'float', 'float'),
    "PySide2.QtCore.QRectF.bottom": (),
    "PySide2.QtCore.QRectF.bottomLeft": (),
    "PySide2.QtCore.QRectF.bottomRight": (),
    "PySide2.QtCore.QRectF.center": (),
    "PySide2.QtCore.QRectF.contains": [('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRectF',), ('float', 'float')],
    "PySide2.QtCore.QRectF.getCoords": (),
    "PySide2.QtCore.QRectF.getRect": (),
    "PySide2.QtCore.QRectF.height": (),
    "PySide2.QtCore.QRectF.intersected": ('PySide2.QtCore.QRectF',),
    "PySide2.QtCore.QRectF.intersects": ('PySide2.QtCore.QRectF',),
    "PySide2.QtCore.QRectF.isEmpty": (),
    "PySide2.QtCore.QRectF.isNull": (),
    "PySide2.QtCore.QRectF.isValid": (),
    "PySide2.QtCore.QRectF.left": (),
    "PySide2.QtCore.QRectF.marginsAdded": ('PySide2.QtCore.QMarginsF',),
    "PySide2.QtCore.QRectF.marginsRemoved": ('PySide2.QtCore.QMarginsF',),
    "PySide2.QtCore.QRectF.moveBottom": ('float',),
    "PySide2.QtCore.QRectF.moveBottomLeft": ('PySide2.QtCore.QPointF',),
    "PySide2.QtCore.QRectF.moveBottomRight": ('PySide2.QtCore.QPointF',),
    "PySide2.QtCore.QRectF.moveCenter": ('PySide2.QtCore.QPointF',),
    "PySide2.QtCore.QRectF.moveLeft": ('float',),
    "PySide2.QtCore.QRectF.moveRight": ('float',),
    "PySide2.QtCore.QRectF.moveTo": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtCore.QRectF.moveTop": ('float',),
    "PySide2.QtCore.QRectF.moveTopLeft": ('PySide2.QtCore.QPointF',),
    "PySide2.QtCore.QRectF.moveTopRight": ('PySide2.QtCore.QPointF',),
    "PySide2.QtCore.QRectF.normalized": (),
    "PySide2.QtCore.QRectF.right": (),
    "PySide2.QtCore.QRectF.setBottom": ('float',),
    "PySide2.QtCore.QRectF.setBottomLeft": ('PySide2.QtCore.QPointF',),
    "PySide2.QtCore.QRectF.setBottomRight": ('PySide2.QtCore.QPointF',),
    "PySide2.QtCore.QRectF.setCoords": ('float', 'float', 'float', 'float'),
    "PySide2.QtCore.QRectF.setHeight": ('float',),
    "PySide2.QtCore.QRectF.setLeft": ('float',),
    "PySide2.QtCore.QRectF.setRect": ('float', 'float', 'float', 'float'),
    "PySide2.QtCore.QRectF.setRight": ('float',),
    "PySide2.QtCore.QRectF.setSize": ('PySide2.QtCore.QSizeF',),
    "PySide2.QtCore.QRectF.setTop": ('float',),
    "PySide2.QtCore.QRectF.setTopLeft": ('PySide2.QtCore.QPointF',),
    "PySide2.QtCore.QRectF.setTopRight": ('PySide2.QtCore.QPointF',),
    "PySide2.QtCore.QRectF.setWidth": ('float',),
    "PySide2.QtCore.QRectF.setX": ('float',),
    "PySide2.QtCore.QRectF.setY": ('float',),
    "PySide2.QtCore.QRectF.size": (),
    "PySide2.QtCore.QRectF.toAlignedRect": (),
    "PySide2.QtCore.QRectF.toRect": (),
    "PySide2.QtCore.QRectF.top": (),
    "PySide2.QtCore.QRectF.topLeft": (),
    "PySide2.QtCore.QRectF.topRight": (),
    "PySide2.QtCore.QRectF.translate": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtCore.QRectF.translated": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtCore.QRectF.transposed": (),
    "PySide2.QtCore.QRectF.united": ('PySide2.QtCore.QRectF',),
    "PySide2.QtCore.QRectF.width": (),
    "PySide2.QtCore.QRectF.x": (),
    "PySide2.QtCore.QRectF.y": (),

# class PySide2.QtCore.QRecursiveMutex:
    "PySide2.QtCore.QRecursiveMutex.__init__": (),

# class PySide2.QtCore.QRegExp:

# class PySide2.QtCore.QRegExp.CaretMode:

# class PySide2.QtCore.QRegExp.PatternSyntax:
    "PySide2.QtCore.QRegExp.__init__": [(), ('PySide2.QtCore.QRegExp',), ('str', 'PySide2.QtCore.Qt.CaseSensitivity', 'PySide2.QtCore.QRegExp.PatternSyntax')],
    "PySide2.QtCore.QRegExp.__copy__": (),
    "PySide2.QtCore.QRegExp.__reduce__": (),
    "PySide2.QtCore.QRegExp.__repr__": (),
    "PySide2.QtCore.QRegExp.cap": ('int',),
    "PySide2.QtCore.QRegExp.captureCount": (),
    "PySide2.QtCore.QRegExp.capturedTexts": (),
    "PySide2.QtCore.QRegExp.caseSensitivity": (),
    "PySide2.QtCore.QRegExp.errorString": (),
    "PySide2.QtCore.QRegExp.escape": ('str',),
    "PySide2.QtCore.QRegExp.exactMatch": ('str',),
    "PySide2.QtCore.QRegExp.indexIn": ('str', 'int', 'PySide2.QtCore.QRegExp.CaretMode'),
    "PySide2.QtCore.QRegExp.isEmpty": (),
    "PySide2.QtCore.QRegExp.isMinimal": (),
    "PySide2.QtCore.QRegExp.isValid": (),
    "PySide2.QtCore.QRegExp.lastIndexIn": ('str', 'int', 'PySide2.QtCore.QRegExp.CaretMode'),
    "PySide2.QtCore.QRegExp.matchedLength": (),
    "PySide2.QtCore.QRegExp.pattern": (),
    "PySide2.QtCore.QRegExp.patternSyntax": (),
    "PySide2.QtCore.QRegExp.pos": ('int',),
    "PySide2.QtCore.QRegExp.replace": ('str', 'str'),
    "PySide2.QtCore.QRegExp.setCaseSensitivity": ('PySide2.QtCore.Qt.CaseSensitivity',),
    "PySide2.QtCore.QRegExp.setMinimal": ('bool',),
    "PySide2.QtCore.QRegExp.setPattern": ('str',),
    "PySide2.QtCore.QRegExp.setPatternSyntax": ('PySide2.QtCore.QRegExp.PatternSyntax',),
    "PySide2.QtCore.QRegExp.swap": ('PySide2.QtCore.QRegExp',),

# class PySide2.QtCore.QRegularExpression:

# class PySide2.QtCore.QRegularExpression.MatchOption:

# class PySide2.QtCore.QRegularExpression.MatchOptions:

# class PySide2.QtCore.QRegularExpression.MatchType:

# class PySide2.QtCore.QRegularExpression.PatternOption:

# class PySide2.QtCore.QRegularExpression.PatternOptions:
    "PySide2.QtCore.QRegularExpression.__init__": [(), ('PySide2.QtCore.QRegularExpression',), ('str', 'PySide2.QtCore.QRegularExpression.PatternOptions')],
    "PySide2.QtCore.QRegularExpression.__copy__": (),
    "PySide2.QtCore.QRegularExpression.anchoredPattern": ('str',),
    "PySide2.QtCore.QRegularExpression.captureCount": (),
    "PySide2.QtCore.QRegularExpression.errorString": (),
    "PySide2.QtCore.QRegularExpression.escape": ('str',),
    "PySide2.QtCore.QRegularExpression.globalMatch": ('str', 'int', 'PySide2.QtCore.QRegularExpression.MatchType', 'PySide2.QtCore.QRegularExpression.MatchOptions'),
    "PySide2.QtCore.QRegularExpression.isValid": (),
    "PySide2.QtCore.QRegularExpression.match": ('str', 'int', 'PySide2.QtCore.QRegularExpression.MatchType', 'PySide2.QtCore.QRegularExpression.MatchOptions'),
    "PySide2.QtCore.QRegularExpression.namedCaptureGroups": (),
    "PySide2.QtCore.QRegularExpression.optimize": (),
    "PySide2.QtCore.QRegularExpression.pattern": (),
    "PySide2.QtCore.QRegularExpression.patternErrorOffset": (),
    "PySide2.QtCore.QRegularExpression.patternOptions": (),
    "PySide2.QtCore.QRegularExpression.setPattern": ('str',),
    "PySide2.QtCore.QRegularExpression.setPatternOptions": ('PySide2.QtCore.QRegularExpression.PatternOptions',),
    "PySide2.QtCore.QRegularExpression.swap": ('PySide2.QtCore.QRegularExpression',),
    "PySide2.QtCore.QRegularExpression.wildcardToRegularExpression": ('str',),

# class PySide2.QtCore.QRegularExpressionMatch:
    "PySide2.QtCore.QRegularExpressionMatch.__init__": [(), ('PySide2.QtCore.QRegularExpressionMatch',)],
    "PySide2.QtCore.QRegularExpressionMatch.__copy__": (),
    "PySide2.QtCore.QRegularExpressionMatch.captured": [('int',), ('str',)],
    "PySide2.QtCore.QRegularExpressionMatch.capturedEnd": [('int',), ('str',)],
    "PySide2.QtCore.QRegularExpressionMatch.capturedLength": [('int',), ('str',)],
    "PySide2.QtCore.QRegularExpressionMatch.capturedRef": [('int',), ('str',)],
    "PySide2.QtCore.QRegularExpressionMatch.capturedStart": [('int',), ('str',)],
    "PySide2.QtCore.QRegularExpressionMatch.capturedTexts": (),
    "PySide2.QtCore.QRegularExpressionMatch.hasMatch": (),
    "PySide2.QtCore.QRegularExpressionMatch.hasPartialMatch": (),
    "PySide2.QtCore.QRegularExpressionMatch.isValid": (),
    "PySide2.QtCore.QRegularExpressionMatch.lastCapturedIndex": (),
    "PySide2.QtCore.QRegularExpressionMatch.matchOptions": (),
    "PySide2.QtCore.QRegularExpressionMatch.matchType": (),
    "PySide2.QtCore.QRegularExpressionMatch.regularExpression": (),
    "PySide2.QtCore.QRegularExpressionMatch.swap": ('PySide2.QtCore.QRegularExpressionMatch',),

# class PySide2.QtCore.QRegularExpressionMatchIterator:
    "PySide2.QtCore.QRegularExpressionMatchIterator.__init__": [(), ('PySide2.QtCore.QRegularExpressionMatchIterator',)],
    "PySide2.QtCore.QRegularExpressionMatchIterator.__copy__": (),
    "PySide2.QtCore.QRegularExpressionMatchIterator.hasNext": (),
    "PySide2.QtCore.QRegularExpressionMatchIterator.isValid": (),
    "PySide2.QtCore.QRegularExpressionMatchIterator.matchOptions": (),
    "PySide2.QtCore.QRegularExpressionMatchIterator.matchType": (),
    "PySide2.QtCore.QRegularExpressionMatchIterator.peekNext": (),
    "PySide2.QtCore.QRegularExpressionMatchIterator.regularExpression": (),
    "PySide2.QtCore.QRegularExpressionMatchIterator.swap": ('PySide2.QtCore.QRegularExpressionMatchIterator',),

# class PySide2.QtCore.QResource:

# class PySide2.QtCore.QResource.Compression:
    "PySide2.QtCore.QResource.__init__": ('str', 'PySide2.QtCore.QLocale'),
    "PySide2.QtCore.QResource.absoluteFilePath": (),
    "PySide2.QtCore.QResource.addSearchPath": ('str',),
    "PySide2.QtCore.QResource.children": (),
    "PySide2.QtCore.QResource.compressionAlgorithm": (),
    "PySide2.QtCore.QResource.data": (),
    "PySide2.QtCore.QResource.fileName": (),
    "PySide2.QtCore.QResource.isCompressed": (),
    "PySide2.QtCore.QResource.isDir": (),
    "PySide2.QtCore.QResource.isFile": (),
    "PySide2.QtCore.QResource.isValid": (),
    "PySide2.QtCore.QResource.lastModified": (),
    "PySide2.QtCore.QResource.locale": (),
    "PySide2.QtCore.QResource.registerResource": ('str', 'str'),
    "PySide2.QtCore.QResource.registerResourceData": ('bytes', 'str'),
    "PySide2.QtCore.QResource.searchPaths": (),
    "PySide2.QtCore.QResource.setFileName": ('str',),
    "PySide2.QtCore.QResource.setLocale": ('PySide2.QtCore.QLocale',),
    "PySide2.QtCore.QResource.size": (),
    "PySide2.QtCore.QResource.unregisterResource": ('str', 'str'),
    "PySide2.QtCore.QResource.unregisterResourceData": ('bytes', 'str'),

# class PySide2.QtCore.QRunnable:
    "PySide2.QtCore.QRunnable.__init__": (),
    "PySide2.QtCore.QRunnable.autoDelete": (),
    "PySide2.QtCore.QRunnable.run": (),
    "PySide2.QtCore.QRunnable.setAutoDelete": ('bool',),

# class PySide2.QtCore.QSaveFile:
    "PySide2.QtCore.QSaveFile.__init__": [('PySide2.QtCore.QObject',), ('str',), ('str', 'PySide2.QtCore.QObject')],
    "PySide2.QtCore.QSaveFile.cancelWriting": (),
    "PySide2.QtCore.QSaveFile.close": (),
    "PySide2.QtCore.QSaveFile.commit": (),
    "PySide2.QtCore.QSaveFile.directWriteFallback": (),
    "PySide2.QtCore.QSaveFile.fileName": (),
    "PySide2.QtCore.QSaveFile.open": ('PySide2.QtCore.QIODevice.OpenMode',),
    "PySide2.QtCore.QSaveFile.setDirectWriteFallback": ('bool',),
    "PySide2.QtCore.QSaveFile.setFileName": ('str',),
    "PySide2.QtCore.QSaveFile.writeData": ('bytes', 'int'),

# class PySide2.QtCore.QSemaphore:
    "PySide2.QtCore.QSemaphore.__init__": ('int',),
    "PySide2.QtCore.QSemaphore.acquire": ('int',),
    "PySide2.QtCore.QSemaphore.available": (),
    "PySide2.QtCore.QSemaphore.release": ('int',),
    "PySide2.QtCore.QSemaphore.tryAcquire": [('int',), ('int', 'int')],

# class PySide2.QtCore.QSemaphoreReleaser:
    "PySide2.QtCore.QSemaphoreReleaser.__init__": [(), ('PySide2.QtCore.QSemaphore', 'int')],
    "PySide2.QtCore.QSemaphoreReleaser.cancel": (),
    "PySide2.QtCore.QSemaphoreReleaser.semaphore": (),
    "PySide2.QtCore.QSemaphoreReleaser.swap": ('PySide2.QtCore.QSemaphoreReleaser',),

# class PySide2.QtCore.QSequentialAnimationGroup:
    "PySide2.QtCore.QSequentialAnimationGroup.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QSequentialAnimationGroup.addPause": ('int',),
    "PySide2.QtCore.QSequentialAnimationGroup.currentAnimation": (),
    "PySide2.QtCore.QSequentialAnimationGroup.duration": (),
    "PySide2.QtCore.QSequentialAnimationGroup.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QSequentialAnimationGroup.insertPause": ('int', 'int'),
    "PySide2.QtCore.QSequentialAnimationGroup.updateCurrentTime": ('int',),
    "PySide2.QtCore.QSequentialAnimationGroup.updateDirection": ('PySide2.QtCore.QAbstractAnimation.Direction',),
    "PySide2.QtCore.QSequentialAnimationGroup.updateState": ('PySide2.QtCore.QAbstractAnimation.State', 'PySide2.QtCore.QAbstractAnimation.State'),

# class PySide2.QtCore.QSettings:

# class PySide2.QtCore.QSettings.Format:

# class PySide2.QtCore.QSettings.Scope:

# class PySide2.QtCore.QSettings.Status:
    "PySide2.QtCore.QSettings.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtCore.QSettings.Format', 'PySide2.QtCore.QSettings.Scope', 'str', 'str', 'PySide2.QtCore.QObject'), ('PySide2.QtCore.QSettings.Scope', 'PySide2.QtCore.QObject'), ('PySide2.QtCore.QSettings.Scope', 'str', 'str', 'PySide2.QtCore.QObject'), ('str', 'PySide2.QtCore.QSettings.Format', 'PySide2.QtCore.QObject'), ('str', 'str', 'PySide2.QtCore.QObject')],
    "PySide2.QtCore.QSettings.allKeys": (),
    "PySide2.QtCore.QSettings.applicationName": (),
    "PySide2.QtCore.QSettings.beginGroup": ('str',),
    "PySide2.QtCore.QSettings.beginReadArray": ('str',),
    "PySide2.QtCore.QSettings.beginWriteArray": ('str', 'int'),
    "PySide2.QtCore.QSettings.childGroups": (),
    "PySide2.QtCore.QSettings.childKeys": (),
    "PySide2.QtCore.QSettings.clear": (),
    "PySide2.QtCore.QSettings.contains": ('str',),
    "PySide2.QtCore.QSettings.defaultFormat": (),
    "PySide2.QtCore.QSettings.endArray": (),
    "PySide2.QtCore.QSettings.endGroup": (),
    "PySide2.QtCore.QSettings.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QSettings.fallbacksEnabled": (),
    "PySide2.QtCore.QSettings.fileName": (),
    "PySide2.QtCore.QSettings.format": (),
    "PySide2.QtCore.QSettings.group": (),
    "PySide2.QtCore.QSettings.iniCodec": (),
    "PySide2.QtCore.QSettings.isAtomicSyncRequired": (),
    "PySide2.QtCore.QSettings.isWritable": (),
    "PySide2.QtCore.QSettings.organizationName": (),
    "PySide2.QtCore.QSettings.remove": ('str',),
    "PySide2.QtCore.QSettings.scope": (),
    "PySide2.QtCore.QSettings.setArrayIndex": ('int',),
    "PySide2.QtCore.QSettings.setAtomicSyncRequired": ('bool',),
    "PySide2.QtCore.QSettings.setDefaultFormat": ('PySide2.QtCore.QSettings.Format',),
    "PySide2.QtCore.QSettings.setFallbacksEnabled": ('bool',),
    "PySide2.QtCore.QSettings.setIniCodec": [('PySide2.QtCore.QTextCodec',), ('bytes',)],
    "PySide2.QtCore.QSettings.setPath": ('PySide2.QtCore.QSettings.Format', 'PySide2.QtCore.QSettings.Scope', 'str'),
    "PySide2.QtCore.QSettings.setValue": ('str', 'typing.Any'),
    "PySide2.QtCore.QSettings.status": (),
    "PySide2.QtCore.QSettings.sync": (),
    "PySide2.QtCore.QSettings.value": ('str', 'typing.Any', 'object'),

# class PySide2.QtCore.QSignalBlocker:
    "PySide2.QtCore.QSignalBlocker.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QSignalBlocker.reblock": (),
    "PySide2.QtCore.QSignalBlocker.unblock": (),

# class PySide2.QtCore.QSignalMapper:
    "PySide2.QtCore.QSignalMapper.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QSignalMapper.map": [(), ('PySide2.QtCore.QObject',)],
    "PySide2.QtCore.QSignalMapper.mapping": [('PySide2.QtCore.QObject',), ('int',), ('str',)],
    "PySide2.QtCore.QSignalMapper.removeMappings": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QSignalMapper.setMapping": [('PySide2.QtCore.QObject', 'PySide2.QtCore.QObject'), ('PySide2.QtCore.QObject', 'int'), ('PySide2.QtCore.QObject', 'str')],

# class PySide2.QtCore.QSignalTransition:
    "PySide2.QtCore.QSignalTransition.__init__": [('PySide2.QtCore.QObject', 'bytes', 'PySide2.QtCore.QState'), ('PySide2.QtCore.QState',), ('object', 'PySide2.QtCore.QState')],
    "PySide2.QtCore.QSignalTransition.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QSignalTransition.eventTest": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QSignalTransition.onTransition": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QSignalTransition.senderObject": (),
    "PySide2.QtCore.QSignalTransition.setSenderObject": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QSignalTransition.setSignal": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtCore.QSignalTransition.signal": (),

# class PySide2.QtCore.QSize:
    "PySide2.QtCore.QSize.__init__": [(), ('PySide2.QtCore.QSize',), ('int', 'int')],
    "PySide2.QtCore.QSize.__add__": ('PySide2.QtCore.QSize',),
    "PySide2.QtCore.QSize.__copy__": (),
    "PySide2.QtCore.QSize.__iadd__": ('PySide2.QtCore.QSize',),
    "PySide2.QtCore.QSize.__imul__": ('float',),
    "PySide2.QtCore.QSize.__isub__": ('PySide2.QtCore.QSize',),
    "PySide2.QtCore.QSize.__mul__": ('float',),
    "PySide2.QtCore.QSize.__reduce__": (),
    "PySide2.QtCore.QSize.__repr__": (),
    "PySide2.QtCore.QSize.__sub__": ('PySide2.QtCore.QSize',),
    "PySide2.QtCore.QSize.boundedTo": ('PySide2.QtCore.QSize',),
    "PySide2.QtCore.QSize.expandedTo": ('PySide2.QtCore.QSize',),
    "PySide2.QtCore.QSize.grownBy": ('PySide2.QtCore.QMargins',),
    "PySide2.QtCore.QSize.height": (),
    "PySide2.QtCore.QSize.isEmpty": (),
    "PySide2.QtCore.QSize.isNull": (),
    "PySide2.QtCore.QSize.isValid": (),
    "PySide2.QtCore.QSize.scale": [('PySide2.QtCore.QSize', 'PySide2.QtCore.Qt.AspectRatioMode'), ('int', 'int', 'PySide2.QtCore.Qt.AspectRatioMode')],
    "PySide2.QtCore.QSize.scaled": [('PySide2.QtCore.QSize', 'PySide2.QtCore.Qt.AspectRatioMode'), ('int', 'int', 'PySide2.QtCore.Qt.AspectRatioMode')],
    "PySide2.QtCore.QSize.setHeight": ('int',),
    "PySide2.QtCore.QSize.setWidth": ('int',),
    "PySide2.QtCore.QSize.shrunkBy": ('PySide2.QtCore.QMargins',),
    "PySide2.QtCore.QSize.toTuple": (),
    "PySide2.QtCore.QSize.transpose": (),
    "PySide2.QtCore.QSize.transposed": (),
    "PySide2.QtCore.QSize.width": (),

# class PySide2.QtCore.QSizeF:
    "PySide2.QtCore.QSizeF.__init__": [(), ('PySide2.QtCore.QSize',), ('PySide2.QtCore.QSizeF',), ('float', 'float')],
    "PySide2.QtCore.QSizeF.__add__": ('PySide2.QtCore.QSizeF',),
    "PySide2.QtCore.QSizeF.__copy__": (),
    "PySide2.QtCore.QSizeF.__iadd__": ('PySide2.QtCore.QSizeF',),
    "PySide2.QtCore.QSizeF.__imul__": ('float',),
    "PySide2.QtCore.QSizeF.__isub__": ('PySide2.QtCore.QSizeF',),
    "PySide2.QtCore.QSizeF.__mul__": ('float',),
    "PySide2.QtCore.QSizeF.__reduce__": (),
    "PySide2.QtCore.QSizeF.__repr__": (),
    "PySide2.QtCore.QSizeF.__sub__": ('PySide2.QtCore.QSizeF',),
    "PySide2.QtCore.QSizeF.boundedTo": ('PySide2.QtCore.QSizeF',),
    "PySide2.QtCore.QSizeF.expandedTo": ('PySide2.QtCore.QSizeF',),
    "PySide2.QtCore.QSizeF.grownBy": ('PySide2.QtCore.QMarginsF',),
    "PySide2.QtCore.QSizeF.height": (),
    "PySide2.QtCore.QSizeF.isEmpty": (),
    "PySide2.QtCore.QSizeF.isNull": (),
    "PySide2.QtCore.QSizeF.isValid": (),
    "PySide2.QtCore.QSizeF.scale": [('PySide2.QtCore.QSizeF', 'PySide2.QtCore.Qt.AspectRatioMode'), ('float', 'float', 'PySide2.QtCore.Qt.AspectRatioMode')],
    "PySide2.QtCore.QSizeF.scaled": [('PySide2.QtCore.QSizeF', 'PySide2.QtCore.Qt.AspectRatioMode'), ('float', 'float', 'PySide2.QtCore.Qt.AspectRatioMode')],
    "PySide2.QtCore.QSizeF.setHeight": ('float',),
    "PySide2.QtCore.QSizeF.setWidth": ('float',),
    "PySide2.QtCore.QSizeF.shrunkBy": ('PySide2.QtCore.QMarginsF',),
    "PySide2.QtCore.QSizeF.toSize": (),
    "PySide2.QtCore.QSizeF.toTuple": (),
    "PySide2.QtCore.QSizeF.transpose": (),
    "PySide2.QtCore.QSizeF.transposed": (),
    "PySide2.QtCore.QSizeF.width": (),

# class PySide2.QtCore.QSocketNotifier:

# class PySide2.QtCore.QSocketNotifier.Type:
    "PySide2.QtCore.QSocketNotifier.__init__": [('int', 'PySide2.QtCore.QSocketNotifier.Type', 'PySide2.QtCore.QObject'), ('object', 'PySide2.QtCore.QSocketNotifier.Type', 'PySide2.QtCore.QObject')],
    "PySide2.QtCore.QSocketNotifier.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QSocketNotifier.isEnabled": (),
    "PySide2.QtCore.QSocketNotifier.setEnabled": ('bool',),
    "PySide2.QtCore.QSocketNotifier.socket": (),
    "PySide2.QtCore.QSocketNotifier.type": (),

# class PySide2.QtCore.QSortFilterProxyModel:
    "PySide2.QtCore.QSortFilterProxyModel.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QSortFilterProxyModel.buddy": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QSortFilterProxyModel.canFetchMore": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QSortFilterProxyModel.columnCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QSortFilterProxyModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtCore.QSortFilterProxyModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QSortFilterProxyModel.dynamicSortFilter": (),
    "PySide2.QtCore.QSortFilterProxyModel.fetchMore": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QSortFilterProxyModel.filterAcceptsColumn": ('int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QSortFilterProxyModel.filterAcceptsRow": ('int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QSortFilterProxyModel.filterCaseSensitivity": (),
    "PySide2.QtCore.QSortFilterProxyModel.filterKeyColumn": (),
    "PySide2.QtCore.QSortFilterProxyModel.filterRegExp": (),
    "PySide2.QtCore.QSortFilterProxyModel.filterRegularExpression": (),
    "PySide2.QtCore.QSortFilterProxyModel.filterRole": (),
    "PySide2.QtCore.QSortFilterProxyModel.flags": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QSortFilterProxyModel.hasChildren": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QSortFilterProxyModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
    "PySide2.QtCore.QSortFilterProxyModel.index": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QSortFilterProxyModel.insertColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QSortFilterProxyModel.insertRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QSortFilterProxyModel.invalidate": (),
    "PySide2.QtCore.QSortFilterProxyModel.invalidateFilter": (),
    "PySide2.QtCore.QSortFilterProxyModel.isRecursiveFilteringEnabled": (),
    "PySide2.QtCore.QSortFilterProxyModel.isSortLocaleAware": (),
    "PySide2.QtCore.QSortFilterProxyModel.lessThan": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QSortFilterProxyModel.mapFromSource": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QSortFilterProxyModel.mapSelectionFromSource": ('PySide2.QtCore.QItemSelection',),
    "PySide2.QtCore.QSortFilterProxyModel.mapSelectionToSource": ('PySide2.QtCore.QItemSelection',),
    "PySide2.QtCore.QSortFilterProxyModel.mapToSource": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QSortFilterProxyModel.match": ('PySide2.QtCore.QModelIndex', 'int', 'typing.Any', 'int', 'PySide2.QtCore.Qt.MatchFlags'),
    "PySide2.QtCore.QSortFilterProxyModel.mimeData": ('typing.List',),
    "PySide2.QtCore.QSortFilterProxyModel.mimeTypes": (),
    "PySide2.QtCore.QSortFilterProxyModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
    "PySide2.QtCore.QSortFilterProxyModel.removeColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QSortFilterProxyModel.removeRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QSortFilterProxyModel.rowCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QSortFilterProxyModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
    "PySide2.QtCore.QSortFilterProxyModel.setDynamicSortFilter": ('bool',),
    "PySide2.QtCore.QSortFilterProxyModel.setFilterCaseSensitivity": ('PySide2.QtCore.Qt.CaseSensitivity',),
    "PySide2.QtCore.QSortFilterProxyModel.setFilterFixedString": ('str',),
    "PySide2.QtCore.QSortFilterProxyModel.setFilterKeyColumn": ('int',),
    "PySide2.QtCore.QSortFilterProxyModel.setFilterRegExp": [('PySide2.QtCore.QRegExp',), ('str',)],
    "PySide2.QtCore.QSortFilterProxyModel.setFilterRegularExpression": [('PySide2.QtCore.QRegularExpression',), ('str',)],
    "PySide2.QtCore.QSortFilterProxyModel.setFilterRole": ('int',),
    "PySide2.QtCore.QSortFilterProxyModel.setFilterWildcard": ('str',),
    "PySide2.QtCore.QSortFilterProxyModel.setHeaderData": ('int', 'PySide2.QtCore.Qt.Orientation', 'typing.Any', 'int'),
    "PySide2.QtCore.QSortFilterProxyModel.setRecursiveFilteringEnabled": ('bool',),
    "PySide2.QtCore.QSortFilterProxyModel.setSortCaseSensitivity": ('PySide2.QtCore.Qt.CaseSensitivity',),
    "PySide2.QtCore.QSortFilterProxyModel.setSortLocaleAware": ('bool',),
    "PySide2.QtCore.QSortFilterProxyModel.setSortRole": ('int',),
    "PySide2.QtCore.QSortFilterProxyModel.setSourceModel": ('PySide2.QtCore.QAbstractItemModel',),
    "PySide2.QtCore.QSortFilterProxyModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QSortFilterProxyModel.sort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
    "PySide2.QtCore.QSortFilterProxyModel.sortCaseSensitivity": (),
    "PySide2.QtCore.QSortFilterProxyModel.sortColumn": (),
    "PySide2.QtCore.QSortFilterProxyModel.sortOrder": (),
    "PySide2.QtCore.QSortFilterProxyModel.sortRole": (),
    "PySide2.QtCore.QSortFilterProxyModel.span": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QSortFilterProxyModel.supportedDropActions": (),

# class PySide2.QtCore.QStandardPaths:

# class PySide2.QtCore.QStandardPaths.LocateOption:

# class PySide2.QtCore.QStandardPaths.LocateOptions:

# class PySide2.QtCore.QStandardPaths.StandardLocation:
    "PySide2.QtCore.QStandardPaths.displayName": ('PySide2.QtCore.QStandardPaths.StandardLocation',),
    "PySide2.QtCore.QStandardPaths.enableTestMode": ('bool',),
    "PySide2.QtCore.QStandardPaths.findExecutable": ('str', 'typing.Sequence'),
    "PySide2.QtCore.QStandardPaths.isTestModeEnabled": (),
    "PySide2.QtCore.QStandardPaths.locate": ('PySide2.QtCore.QStandardPaths.StandardLocation', 'str', 'PySide2.QtCore.QStandardPaths.LocateOptions'),
    "PySide2.QtCore.QStandardPaths.locateAll": ('PySide2.QtCore.QStandardPaths.StandardLocation', 'str', 'PySide2.QtCore.QStandardPaths.LocateOptions'),
    "PySide2.QtCore.QStandardPaths.setTestModeEnabled": ('bool',),
    "PySide2.QtCore.QStandardPaths.standardLocations": ('PySide2.QtCore.QStandardPaths.StandardLocation',),
    "PySide2.QtCore.QStandardPaths.writableLocation": ('PySide2.QtCore.QStandardPaths.StandardLocation',),

# class PySide2.QtCore.QState:

# class PySide2.QtCore.QState.ChildMode:

# class PySide2.QtCore.QState.RestorePolicy:
    "PySide2.QtCore.QState.__init__": [('PySide2.QtCore.QState',), ('PySide2.QtCore.QState.ChildMode', 'PySide2.QtCore.QState')],
    "PySide2.QtCore.QState.addTransition": [('PySide2.QtCore.QAbstractState',), ('PySide2.QtCore.QAbstractTransition',), ('PySide2.QtCore.QObject', 'bytes', 'PySide2.QtCore.QAbstractState'), ('object', 'PySide2.QtCore.QAbstractState')],
    "PySide2.QtCore.QState.assignProperty": ('PySide2.QtCore.QObject', 'bytes', 'typing.Any'),
    "PySide2.QtCore.QState.childMode": (),
    "PySide2.QtCore.QState.errorState": (),
    "PySide2.QtCore.QState.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QState.initialState": (),
    "PySide2.QtCore.QState.onEntry": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QState.onExit": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QState.removeTransition": ('PySide2.QtCore.QAbstractTransition',),
    "PySide2.QtCore.QState.setChildMode": ('PySide2.QtCore.QState.ChildMode',),
    "PySide2.QtCore.QState.setErrorState": ('PySide2.QtCore.QAbstractState',),
    "PySide2.QtCore.QState.setInitialState": ('PySide2.QtCore.QAbstractState',),
    "PySide2.QtCore.QState.transitions": (),

# class PySide2.QtCore.QStateMachine:

# class PySide2.QtCore.QStateMachine.Error:

# class PySide2.QtCore.QStateMachine.EventPriority:

# class PySide2.QtCore.QStateMachine.SignalEvent:
    "PySide2.QtCore.QStateMachine.SignalEvent.__init__": [('PySide2.QtCore.QObject', 'int', 'typing.Sequence'), ('PySide2.QtCore.QStateMachine.SignalEvent',)],
    "PySide2.QtCore.QStateMachine.SignalEvent.__copy__": (),
    "PySide2.QtCore.QStateMachine.SignalEvent.arguments": (),
    "PySide2.QtCore.QStateMachine.SignalEvent.sender": (),
    "PySide2.QtCore.QStateMachine.SignalEvent.signalIndex": (),

# class PySide2.QtCore.QStateMachine.WrappedEvent:
    "PySide2.QtCore.QStateMachine.WrappedEvent.__init__": [('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'), ('PySide2.QtCore.QStateMachine.WrappedEvent',)],
    "PySide2.QtCore.QStateMachine.WrappedEvent.__copy__": (),
    "PySide2.QtCore.QStateMachine.WrappedEvent.event": (),
    "PySide2.QtCore.QStateMachine.WrappedEvent.object": (),

    "PySide2.QtCore.QStateMachine.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtCore.QState.ChildMode', 'PySide2.QtCore.QObject')],
    "PySide2.QtCore.QStateMachine.addDefaultAnimation": ('PySide2.QtCore.QAbstractAnimation',),
    "PySide2.QtCore.QStateMachine.addState": ('PySide2.QtCore.QAbstractState',),
    "PySide2.QtCore.QStateMachine.beginMicrostep": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QStateMachine.beginSelectTransitions": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QStateMachine.cancelDelayedEvent": ('int',),
    "PySide2.QtCore.QStateMachine.clearError": (),
    "PySide2.QtCore.QStateMachine.configuration": (),
    "PySide2.QtCore.QStateMachine.defaultAnimations": (),
    "PySide2.QtCore.QStateMachine.endMicrostep": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QStateMachine.endSelectTransitions": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QStateMachine.error": (),
    "PySide2.QtCore.QStateMachine.errorString": (),
    "PySide2.QtCore.QStateMachine.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QStateMachine.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtCore.QStateMachine.globalRestorePolicy": (),
    "PySide2.QtCore.QStateMachine.isAnimated": (),
    "PySide2.QtCore.QStateMachine.isRunning": (),
    "PySide2.QtCore.QStateMachine.onEntry": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QStateMachine.onExit": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QStateMachine.postDelayedEvent": ('PySide2.QtCore.QEvent', 'int'),
    "PySide2.QtCore.QStateMachine.postEvent": ('PySide2.QtCore.QEvent', 'PySide2.QtCore.QStateMachine.EventPriority'),
    "PySide2.QtCore.QStateMachine.removeDefaultAnimation": ('PySide2.QtCore.QAbstractAnimation',),
    "PySide2.QtCore.QStateMachine.removeState": ('PySide2.QtCore.QAbstractState',),
    "PySide2.QtCore.QStateMachine.setAnimated": ('bool',),
    "PySide2.QtCore.QStateMachine.setGlobalRestorePolicy": ('PySide2.QtCore.QState.RestorePolicy',),
    "PySide2.QtCore.QStateMachine.setRunning": ('bool',),
    "PySide2.QtCore.QStateMachine.start": (),
    "PySide2.QtCore.QStateMachine.stop": (),

# class PySide2.QtCore.QStorageInfo:
    "PySide2.QtCore.QStorageInfo.__init__": [(), ('PySide2.QtCore.QDir',), ('PySide2.QtCore.QStorageInfo',), ('str',)],
    "PySide2.QtCore.QStorageInfo.__copy__": (),
    "PySide2.QtCore.QStorageInfo.blockSize": (),
    "PySide2.QtCore.QStorageInfo.bytesAvailable": (),
    "PySide2.QtCore.QStorageInfo.bytesFree": (),
    "PySide2.QtCore.QStorageInfo.bytesTotal": (),
    "PySide2.QtCore.QStorageInfo.device": (),
    "PySide2.QtCore.QStorageInfo.displayName": (),
    "PySide2.QtCore.QStorageInfo.fileSystemType": (),
    "PySide2.QtCore.QStorageInfo.isReadOnly": (),
    "PySide2.QtCore.QStorageInfo.isReady": (),
    "PySide2.QtCore.QStorageInfo.isRoot": (),
    "PySide2.QtCore.QStorageInfo.isValid": (),
    "PySide2.QtCore.QStorageInfo.mountedVolumes": (),
    "PySide2.QtCore.QStorageInfo.name": (),
    "PySide2.QtCore.QStorageInfo.refresh": (),
    "PySide2.QtCore.QStorageInfo.root": (),
    "PySide2.QtCore.QStorageInfo.rootPath": (),
    "PySide2.QtCore.QStorageInfo.setPath": ('str',),
    "PySide2.QtCore.QStorageInfo.subvolume": (),
    "PySide2.QtCore.QStorageInfo.swap": ('PySide2.QtCore.QStorageInfo',),

# class PySide2.QtCore.QStringListModel:
    "PySide2.QtCore.QStringListModel.__init__": [('PySide2.QtCore.QObject',), ('typing.Sequence', 'PySide2.QtCore.QObject')],
    "PySide2.QtCore.QStringListModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtCore.QStringListModel.flags": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QStringListModel.insertRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QStringListModel.itemData": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QStringListModel.moveRows": ('PySide2.QtCore.QModelIndex', 'int', 'int', 'PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtCore.QStringListModel.removeRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QStringListModel.rowCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QStringListModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
    "PySide2.QtCore.QStringListModel.setItemData": ('PySide2.QtCore.QModelIndex', 'typing.Dict'),
    "PySide2.QtCore.QStringListModel.setStringList": ('typing.Sequence',),
    "PySide2.QtCore.QStringListModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QStringListModel.sort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
    "PySide2.QtCore.QStringListModel.stringList": (),
    "PySide2.QtCore.QStringListModel.supportedDropActions": (),

# class PySide2.QtCore.QSysInfo:

# class PySide2.QtCore.QSysInfo.Endian:

# class PySide2.QtCore.QSysInfo.Sizes:

# class PySide2.QtCore.QSysInfo.WinVersion:
    "PySide2.QtCore.QSysInfo.__init__": (),
    "PySide2.QtCore.QSysInfo.bootUniqueId": (),
    "PySide2.QtCore.QSysInfo.buildAbi": (),
    "PySide2.QtCore.QSysInfo.buildCpuArchitecture": (),
    "PySide2.QtCore.QSysInfo.currentCpuArchitecture": (),
    "PySide2.QtCore.QSysInfo.kernelType": (),
    "PySide2.QtCore.QSysInfo.kernelVersion": (),
    "PySide2.QtCore.QSysInfo.machineHostName": (),
    "PySide2.QtCore.QSysInfo.machineUniqueId": (),
    "PySide2.QtCore.QSysInfo.prettyProductName": (),
    "PySide2.QtCore.QSysInfo.productType": (),
    "PySide2.QtCore.QSysInfo.productVersion": (),
    "PySide2.QtCore.QSysInfo.windowsVersion": (),

# class PySide2.QtCore.QSystemSemaphore:

# class PySide2.QtCore.QSystemSemaphore.AccessMode:

# class PySide2.QtCore.QSystemSemaphore.SystemSemaphoreError:
    "PySide2.QtCore.QSystemSemaphore.__init__": ('str', 'int', 'PySide2.QtCore.QSystemSemaphore.AccessMode'),
    "PySide2.QtCore.QSystemSemaphore.acquire": (),
    "PySide2.QtCore.QSystemSemaphore.error": (),
    "PySide2.QtCore.QSystemSemaphore.errorString": (),
    "PySide2.QtCore.QSystemSemaphore.key": (),
    "PySide2.QtCore.QSystemSemaphore.release": ('int',),
    "PySide2.QtCore.QSystemSemaphore.setKey": ('str', 'int', 'PySide2.QtCore.QSystemSemaphore.AccessMode'),

# class PySide2.QtCore.QTemporaryDir:
    "PySide2.QtCore.QTemporaryDir.__init__": [(), ('str',)],
    "PySide2.QtCore.QTemporaryDir.autoRemove": (),
    "PySide2.QtCore.QTemporaryDir.errorString": (),
    "PySide2.QtCore.QTemporaryDir.filePath": ('str',),
    "PySide2.QtCore.QTemporaryDir.isValid": (),
    "PySide2.QtCore.QTemporaryDir.path": (),
    "PySide2.QtCore.QTemporaryDir.remove": (),
    "PySide2.QtCore.QTemporaryDir.setAutoRemove": ('bool',),

# class PySide2.QtCore.QTemporaryFile:
    "PySide2.QtCore.QTemporaryFile.__init__": [(), ('PySide2.QtCore.QObject',), ('str',), ('str', 'PySide2.QtCore.QObject')],
    "PySide2.QtCore.QTemporaryFile.autoRemove": (),
    "PySide2.QtCore.QTemporaryFile.createLocalFile": [('PySide2.QtCore.QFile',), ('str',)],
    "PySide2.QtCore.QTemporaryFile.createNativeFile": [('PySide2.QtCore.QFile',), ('str',)],
    "PySide2.QtCore.QTemporaryFile.fileName": (),
    "PySide2.QtCore.QTemporaryFile.fileTemplate": (),
    "PySide2.QtCore.QTemporaryFile.open": [(), ('PySide2.QtCore.QIODevice.OpenMode',)],
    "PySide2.QtCore.QTemporaryFile.rename": ('str',),
    "PySide2.QtCore.QTemporaryFile.setAutoRemove": ('bool',),
    "PySide2.QtCore.QTemporaryFile.setFileTemplate": ('str',),

# class PySide2.QtCore.QTextBoundaryFinder:

# class PySide2.QtCore.QTextBoundaryFinder.BoundaryReason:

# class PySide2.QtCore.QTextBoundaryFinder.BoundaryReasons:

# class PySide2.QtCore.QTextBoundaryFinder.BoundaryType:
    "PySide2.QtCore.QTextBoundaryFinder.__init__": [(), ('PySide2.QtCore.QTextBoundaryFinder',), ('PySide2.QtCore.QTextBoundaryFinder.BoundaryType', 'str')],
    "PySide2.QtCore.QTextBoundaryFinder.__copy__": (),
    "PySide2.QtCore.QTextBoundaryFinder.boundaryReasons": (),
    "PySide2.QtCore.QTextBoundaryFinder.isAtBoundary": (),
    "PySide2.QtCore.QTextBoundaryFinder.isValid": (),
    "PySide2.QtCore.QTextBoundaryFinder.position": (),
    "PySide2.QtCore.QTextBoundaryFinder.setPosition": ('int',),
    "PySide2.QtCore.QTextBoundaryFinder.string": (),
    "PySide2.QtCore.QTextBoundaryFinder.toEnd": (),
    "PySide2.QtCore.QTextBoundaryFinder.toNextBoundary": (),
    "PySide2.QtCore.QTextBoundaryFinder.toPreviousBoundary": (),
    "PySide2.QtCore.QTextBoundaryFinder.toStart": (),
    "PySide2.QtCore.QTextBoundaryFinder.type": (),

# class PySide2.QtCore.QTextCodec:

# class PySide2.QtCore.QTextCodec.ConversionFlag:

# class PySide2.QtCore.QTextCodec.ConversionFlags:

# class PySide2.QtCore.QTextCodec.ConverterState:
    "PySide2.QtCore.QTextCodec.ConverterState.__init__": ('PySide2.QtCore.QTextCodec.ConversionFlags',),

    "PySide2.QtCore.QTextCodec.__init__": (),
    "PySide2.QtCore.QTextCodec.aliases": (),
    "PySide2.QtCore.QTextCodec.availableCodecs": (),
    "PySide2.QtCore.QTextCodec.availableMibs": (),
    "PySide2.QtCore.QTextCodec.canEncode": [('str',), ('typing.Char',)],
    "PySide2.QtCore.QTextCodec.codecForHtml": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QTextCodec')],
    "PySide2.QtCore.QTextCodec.codecForLocale": (),
    "PySide2.QtCore.QTextCodec.codecForMib": ('int',),
    "PySide2.QtCore.QTextCodec.codecForName": [('PySide2.QtCore.QByteArray',), ('bytes',)],
    "PySide2.QtCore.QTextCodec.codecForUtfText": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QTextCodec')],
    "PySide2.QtCore.QTextCodec.convertToUnicode": ('bytes', 'int', 'PySide2.QtCore.QTextCodec.ConverterState'),
    "PySide2.QtCore.QTextCodec.fromUnicode": ('str',),
    "PySide2.QtCore.QTextCodec.makeDecoder": ('PySide2.QtCore.QTextCodec.ConversionFlags',),
    "PySide2.QtCore.QTextCodec.makeEncoder": ('PySide2.QtCore.QTextCodec.ConversionFlags',),
    "PySide2.QtCore.QTextCodec.mibEnum": (),
    "PySide2.QtCore.QTextCodec.name": (),
    "PySide2.QtCore.QTextCodec.setCodecForLocale": ('PySide2.QtCore.QTextCodec',),
    "PySide2.QtCore.QTextCodec.toUnicode": [('PySide2.QtCore.QByteArray',), ('bytes',), ('bytes', 'int', 'PySide2.QtCore.QTextCodec.ConverterState')],

# class PySide2.QtCore.QTextDecoder:
    "PySide2.QtCore.QTextDecoder.__init__": [('PySide2.QtCore.QTextCodec',), ('PySide2.QtCore.QTextCodec', 'PySide2.QtCore.QTextCodec.ConversionFlags')],
    "PySide2.QtCore.QTextDecoder.hasFailure": (),
    "PySide2.QtCore.QTextDecoder.needsMoreData": (),
    "PySide2.QtCore.QTextDecoder.toUnicode": ('PySide2.QtCore.QByteArray',),

# class PySide2.QtCore.QTextEncoder:
    "PySide2.QtCore.QTextEncoder.__init__": [('PySide2.QtCore.QTextCodec',), ('PySide2.QtCore.QTextCodec', 'PySide2.QtCore.QTextCodec.ConversionFlags')],
    "PySide2.QtCore.QTextEncoder.fromUnicode": ('str',),
    "PySide2.QtCore.QTextEncoder.hasFailure": (),

# class PySide2.QtCore.QTextStream:

# class PySide2.QtCore.QTextStream.FieldAlignment:

# class PySide2.QtCore.QTextStream.NumberFlag:

# class PySide2.QtCore.QTextStream.NumberFlags:

# class PySide2.QtCore.QTextStream.RealNumberNotation:

# class PySide2.QtCore.QTextStream.Status:
    "PySide2.QtCore.QTextStream.__init__": [(), ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QIODevice.OpenMode'), ('PySide2.QtCore.QIODevice',)],
    "PySide2.QtCore.QTextStream.__lshift__": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QTextStreamManipulator',), ('float',), ('int',), ('str',), ('typing.Char',)],
    "PySide2.QtCore.QTextStream.__rshift__": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtCore.QTextStream.atEnd": (),
    "PySide2.QtCore.QTextStream.autoDetectUnicode": (),
    "PySide2.QtCore.QTextStream.codec": (),
    "PySide2.QtCore.QTextStream.device": (),
    "PySide2.QtCore.QTextStream.fieldAlignment": (),
    "PySide2.QtCore.QTextStream.fieldWidth": (),
    "PySide2.QtCore.QTextStream.flush": (),
    "PySide2.QtCore.QTextStream.generateByteOrderMark": (),
    "PySide2.QtCore.QTextStream.integerBase": (),
    "PySide2.QtCore.QTextStream.locale": (),
    "PySide2.QtCore.QTextStream.numberFlags": (),
    "PySide2.QtCore.QTextStream.padChar": (),
    "PySide2.QtCore.QTextStream.pos": (),
    "PySide2.QtCore.QTextStream.read": ('int',),
    "PySide2.QtCore.QTextStream.readAll": (),
    "PySide2.QtCore.QTextStream.readLine": ('int',),
    "PySide2.QtCore.QTextStream.realNumberNotation": (),
    "PySide2.QtCore.QTextStream.realNumberPrecision": (),
    "PySide2.QtCore.QTextStream.reset": (),
    "PySide2.QtCore.QTextStream.resetStatus": (),
    "PySide2.QtCore.QTextStream.seek": ('int',),
    "PySide2.QtCore.QTextStream.setAutoDetectUnicode": ('bool',),
    "PySide2.QtCore.QTextStream.setCodec": [('PySide2.QtCore.QTextCodec',), ('bytes',)],
    "PySide2.QtCore.QTextStream.setDevice": ('PySide2.QtCore.QIODevice',),
    "PySide2.QtCore.QTextStream.setFieldAlignment": ('PySide2.QtCore.QTextStream.FieldAlignment',),
    "PySide2.QtCore.QTextStream.setFieldWidth": ('int',),
    "PySide2.QtCore.QTextStream.setGenerateByteOrderMark": ('bool',),
    "PySide2.QtCore.QTextStream.setIntegerBase": ('int',),
    "PySide2.QtCore.QTextStream.setLocale": ('PySide2.QtCore.QLocale',),
    "PySide2.QtCore.QTextStream.setNumberFlags": ('PySide2.QtCore.QTextStream.NumberFlags',),
    "PySide2.QtCore.QTextStream.setPadChar": ('typing.Char',),
    "PySide2.QtCore.QTextStream.setRealNumberNotation": ('PySide2.QtCore.QTextStream.RealNumberNotation',),
    "PySide2.QtCore.QTextStream.setRealNumberPrecision": ('int',),
    "PySide2.QtCore.QTextStream.setStatus": ('PySide2.QtCore.QTextStream.Status',),
    "PySide2.QtCore.QTextStream.skipWhiteSpace": (),
    "PySide2.QtCore.QTextStream.status": (),
    "PySide2.QtCore.QTextStream.string": (),

# class PySide2.QtCore.QTextStreamManipulator:
    "PySide2.QtCore.QTextStreamManipulator.__copy__": (),
    "PySide2.QtCore.QTextStreamManipulator.exec_": ('PySide2.QtCore.QTextStream',),

# class PySide2.QtCore.QThread:

# class PySide2.QtCore.QThread.Priority:
    "PySide2.QtCore.QThread.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QThread.currentThread": (),
    "PySide2.QtCore.QThread.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QThread.eventDispatcher": (),
    "PySide2.QtCore.QThread.exec_": (),
    "PySide2.QtCore.QThread.exit": ('int',),
    "PySide2.QtCore.QThread.idealThreadCount": (),
    "PySide2.QtCore.QThread.isFinished": (),
    "PySide2.QtCore.QThread.isInterruptionRequested": (),
    "PySide2.QtCore.QThread.isRunning": (),
    "PySide2.QtCore.QThread.loopLevel": (),
    "PySide2.QtCore.QThread.msleep": ('int',),
    "PySide2.QtCore.QThread.priority": (),
    "PySide2.QtCore.QThread.quit": (),
    "PySide2.QtCore.QThread.requestInterruption": (),
    "PySide2.QtCore.QThread.run": (),
    "PySide2.QtCore.QThread.setEventDispatcher": ('PySide2.QtCore.QAbstractEventDispatcher',),
    "PySide2.QtCore.QThread.setPriority": ('PySide2.QtCore.QThread.Priority',),
    "PySide2.QtCore.QThread.setStackSize": ('int',),
    "PySide2.QtCore.QThread.setTerminationEnabled": ('bool',),
    "PySide2.QtCore.QThread.sleep": ('int',),
    "PySide2.QtCore.QThread.stackSize": (),
    "PySide2.QtCore.QThread.start": ('PySide2.QtCore.QThread.Priority',),
    "PySide2.QtCore.QThread.terminate": (),
    "PySide2.QtCore.QThread.usleep": ('int',),
    "PySide2.QtCore.QThread.wait": ('int',),
    "PySide2.QtCore.QThread.yieldCurrentThread": (),

# class PySide2.QtCore.QThreadPool:
    "PySide2.QtCore.QThreadPool.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QThreadPool.activeThreadCount": (),
    "PySide2.QtCore.QThreadPool.cancel": ('PySide2.QtCore.QRunnable',),
    "PySide2.QtCore.QThreadPool.clear": (),
    "PySide2.QtCore.QThreadPool.expiryTimeout": (),
    "PySide2.QtCore.QThreadPool.globalInstance": (),
    "PySide2.QtCore.QThreadPool.maxThreadCount": (),
    "PySide2.QtCore.QThreadPool.releaseThread": (),
    "PySide2.QtCore.QThreadPool.reserveThread": (),
    "PySide2.QtCore.QThreadPool.setExpiryTimeout": ('int',),
    "PySide2.QtCore.QThreadPool.setMaxThreadCount": ('int',),
    "PySide2.QtCore.QThreadPool.setStackSize": ('int',),
    "PySide2.QtCore.QThreadPool.stackSize": (),
    "PySide2.QtCore.QThreadPool.start": ('PySide2.QtCore.QRunnable', 'int'),
    "PySide2.QtCore.QThreadPool.tryStart": ('PySide2.QtCore.QRunnable',),
    "PySide2.QtCore.QThreadPool.tryTake": ('PySide2.QtCore.QRunnable',),
    "PySide2.QtCore.QThreadPool.waitForDone": ('int',),

# class PySide2.QtCore.QTime:
    "PySide2.QtCore.QTime.__init__": [(), ('PySide2.QtCore.QTime',), ('int', 'int', 'int', 'int')],
    "PySide2.QtCore.QTime.__copy__": (),
    "PySide2.QtCore.QTime.__reduce__": (),
    "PySide2.QtCore.QTime.__repr__": (),
    "PySide2.QtCore.QTime.addMSecs": ('int',),
    "PySide2.QtCore.QTime.addSecs": ('int',),
    "PySide2.QtCore.QTime.currentTime": (),
    "PySide2.QtCore.QTime.elapsed": (),
    "PySide2.QtCore.QTime.fromMSecsSinceStartOfDay": ('int',),
    "PySide2.QtCore.QTime.fromString": [('str', 'PySide2.QtCore.Qt.DateFormat'), ('str', 'str')],
    "PySide2.QtCore.QTime.hour": (),
    "PySide2.QtCore.QTime.isNull": (),
    "PySide2.QtCore.QTime.isValid": [(), ('int', 'int', 'int', 'int')],
    "PySide2.QtCore.QTime.minute": (),
    "PySide2.QtCore.QTime.msec": (),
    "PySide2.QtCore.QTime.msecsSinceStartOfDay": (),
    "PySide2.QtCore.QTime.msecsTo": ('PySide2.QtCore.QTime',),
    "PySide2.QtCore.QTime.restart": (),
    "PySide2.QtCore.QTime.second": (),
    "PySide2.QtCore.QTime.secsTo": ('PySide2.QtCore.QTime',),
    "PySide2.QtCore.QTime.setHMS": ('int', 'int', 'int', 'int'),
    "PySide2.QtCore.QTime.start": (),
    "PySide2.QtCore.QTime.toPython": (),
    "PySide2.QtCore.QTime.toString": [('PySide2.QtCore.Qt.DateFormat',), ('str',)],

# class PySide2.QtCore.QTimeLine:

# class PySide2.QtCore.QTimeLine.CurveShape:

# class PySide2.QtCore.QTimeLine.Direction:

# class PySide2.QtCore.QTimeLine.State:
    "PySide2.QtCore.QTimeLine.__init__": ('int', 'PySide2.QtCore.QObject'),
    "PySide2.QtCore.QTimeLine.currentFrame": (),
    "PySide2.QtCore.QTimeLine.currentTime": (),
    "PySide2.QtCore.QTimeLine.currentValue": (),
    "PySide2.QtCore.QTimeLine.curveShape": (),
    "PySide2.QtCore.QTimeLine.direction": (),
    "PySide2.QtCore.QTimeLine.duration": (),
    "PySide2.QtCore.QTimeLine.easingCurve": (),
    "PySide2.QtCore.QTimeLine.endFrame": (),
    "PySide2.QtCore.QTimeLine.frameForTime": ('int',),
    "PySide2.QtCore.QTimeLine.loopCount": (),
    "PySide2.QtCore.QTimeLine.resume": (),
    "PySide2.QtCore.QTimeLine.setCurrentTime": ('int',),
    "PySide2.QtCore.QTimeLine.setCurveShape": ('PySide2.QtCore.QTimeLine.CurveShape',),
    "PySide2.QtCore.QTimeLine.setDirection": ('PySide2.QtCore.QTimeLine.Direction',),
    "PySide2.QtCore.QTimeLine.setDuration": ('int',),
    "PySide2.QtCore.QTimeLine.setEasingCurve": ('PySide2.QtCore.QEasingCurve',),
    "PySide2.QtCore.QTimeLine.setEndFrame": ('int',),
    "PySide2.QtCore.QTimeLine.setFrameRange": ('int', 'int'),
    "PySide2.QtCore.QTimeLine.setLoopCount": ('int',),
    "PySide2.QtCore.QTimeLine.setPaused": ('bool',),
    "PySide2.QtCore.QTimeLine.setStartFrame": ('int',),
    "PySide2.QtCore.QTimeLine.setUpdateInterval": ('int',),
    "PySide2.QtCore.QTimeLine.start": (),
    "PySide2.QtCore.QTimeLine.startFrame": (),
    "PySide2.QtCore.QTimeLine.state": (),
    "PySide2.QtCore.QTimeLine.stop": (),
    "PySide2.QtCore.QTimeLine.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtCore.QTimeLine.toggleDirection": (),
    "PySide2.QtCore.QTimeLine.updateInterval": (),
    "PySide2.QtCore.QTimeLine.valueForTime": ('int',),

# class PySide2.QtCore.QTimeZone:

# class PySide2.QtCore.QTimeZone.NameType:

# class PySide2.QtCore.QTimeZone.OffsetData:
    "PySide2.QtCore.QTimeZone.OffsetData.__init__": [(), ('PySide2.QtCore.QTimeZone.OffsetData',)],
    "PySide2.QtCore.QTimeZone.OffsetData.__copy__": (),

# class PySide2.QtCore.QTimeZone.TimeType:

    "PySide2.QtCore.QTimeZone.__init__": [(), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QByteArray', 'int', 'str', 'str', 'PySide2.QtCore.QLocale.Country', 'str'), ('PySide2.QtCore.QTimeZone',), ('int',)],
    "PySide2.QtCore.QTimeZone.__copy__": (),
    "PySide2.QtCore.QTimeZone.abbreviation": ('PySide2.QtCore.QDateTime',),
    "PySide2.QtCore.QTimeZone.availableTimeZoneIds": [(), ('PySide2.QtCore.QLocale.Country',), ('int',)],
    "PySide2.QtCore.QTimeZone.comment": (),
    "PySide2.QtCore.QTimeZone.country": (),
    "PySide2.QtCore.QTimeZone.daylightTimeOffset": ('PySide2.QtCore.QDateTime',),
    "PySide2.QtCore.QTimeZone.displayName": [('PySide2.QtCore.QDateTime', 'PySide2.QtCore.QTimeZone.NameType', 'PySide2.QtCore.QLocale'), ('PySide2.QtCore.QTimeZone.TimeType', 'PySide2.QtCore.QTimeZone.NameType', 'PySide2.QtCore.QLocale')],
    "PySide2.QtCore.QTimeZone.hasDaylightTime": (),
    "PySide2.QtCore.QTimeZone.hasTransitions": (),
    "PySide2.QtCore.QTimeZone.ianaIdToWindowsId": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtCore.QTimeZone.id": (),
    "PySide2.QtCore.QTimeZone.isDaylightTime": ('PySide2.QtCore.QDateTime',),
    "PySide2.QtCore.QTimeZone.isTimeZoneIdAvailable": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtCore.QTimeZone.isValid": (),
    "PySide2.QtCore.QTimeZone.nextTransition": ('PySide2.QtCore.QDateTime',),
    "PySide2.QtCore.QTimeZone.offsetData": ('PySide2.QtCore.QDateTime',),
    "PySide2.QtCore.QTimeZone.offsetFromUtc": ('PySide2.QtCore.QDateTime',),
    "PySide2.QtCore.QTimeZone.previousTransition": ('PySide2.QtCore.QDateTime',),
    "PySide2.QtCore.QTimeZone.standardTimeOffset": ('PySide2.QtCore.QDateTime',),
    "PySide2.QtCore.QTimeZone.swap": ('PySide2.QtCore.QTimeZone',),
    "PySide2.QtCore.QTimeZone.systemTimeZone": (),
    "PySide2.QtCore.QTimeZone.systemTimeZoneId": (),
    "PySide2.QtCore.QTimeZone.transitions": ('PySide2.QtCore.QDateTime', 'PySide2.QtCore.QDateTime'),
    "PySide2.QtCore.QTimeZone.utc": (),
    "PySide2.QtCore.QTimeZone.windowsIdToDefaultIanaId": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QLocale.Country')],
    "PySide2.QtCore.QTimeZone.windowsIdToIanaIds": [('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QLocale.Country')],

# class PySide2.QtCore.QTimer:
    "PySide2.QtCore.QTimer.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QTimer.interval": (),
    "PySide2.QtCore.QTimer.isActive": (),
    "PySide2.QtCore.QTimer.isSingleShot": (),
    "PySide2.QtCore.QTimer.killTimer": ('int',),
    "PySide2.QtCore.QTimer.remainingTime": (),
    "PySide2.QtCore.QTimer.setInterval": ('int',),
    "PySide2.QtCore.QTimer.setSingleShot": ('bool',),
    "PySide2.QtCore.QTimer.setTimerType": ('PySide2.QtCore.Qt.TimerType',),
    "PySide2.QtCore.QTimer.singleShot": [('int', 'PySide2.QtCore.QObject', 'bytes'), ('int', 'PySide2.QtCore.Qt.TimerType', 'PySide2.QtCore.QObject', 'bytes'), ('int', 'typing.Callable')],
    "PySide2.QtCore.QTimer.start": [(), ('int',)],
    "PySide2.QtCore.QTimer.stop": (),
    "PySide2.QtCore.QTimer.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtCore.QTimer.timerId": (),
    "PySide2.QtCore.QTimer.timerType": (),

# class PySide2.QtCore.QTimerEvent:
    "PySide2.QtCore.QTimerEvent.__init__": ('int',),
    "PySide2.QtCore.QTimerEvent.timerId": (),

# class PySide2.QtCore.QTranslator:
    "PySide2.QtCore.QTranslator.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QTranslator.isEmpty": (),
    "PySide2.QtCore.QTranslator.load": [('PySide2.QtCore.QLocale', 'str', 'str', 'str', 'str'), ('bytes', 'int', 'str'), ('str', 'str', 'str', 'str')],
    "PySide2.QtCore.QTranslator.translate": ('bytes', 'bytes', 'bytes', 'int'),

# class PySide2.QtCore.QTransposeProxyModel:
    "PySide2.QtCore.QTransposeProxyModel.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QTransposeProxyModel.columnCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QTransposeProxyModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
    "PySide2.QtCore.QTransposeProxyModel.index": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QTransposeProxyModel.insertColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QTransposeProxyModel.insertRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QTransposeProxyModel.itemData": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QTransposeProxyModel.mapFromSource": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QTransposeProxyModel.mapToSource": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QTransposeProxyModel.moveColumns": ('PySide2.QtCore.QModelIndex', 'int', 'int', 'PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtCore.QTransposeProxyModel.moveRows": ('PySide2.QtCore.QModelIndex', 'int', 'int', 'PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtCore.QTransposeProxyModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
    "PySide2.QtCore.QTransposeProxyModel.removeColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QTransposeProxyModel.removeRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtCore.QTransposeProxyModel.rowCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtCore.QTransposeProxyModel.setHeaderData": ('int', 'PySide2.QtCore.Qt.Orientation', 'typing.Any', 'int'),
    "PySide2.QtCore.QTransposeProxyModel.setItemData": ('PySide2.QtCore.QModelIndex', 'typing.Dict'),
    "PySide2.QtCore.QTransposeProxyModel.setSourceModel": ('PySide2.QtCore.QAbstractItemModel',),
    "PySide2.QtCore.QTransposeProxyModel.sort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
    "PySide2.QtCore.QTransposeProxyModel.span": ('PySide2.QtCore.QModelIndex',),

# class PySide2.QtCore.QUrl:

# class PySide2.QtCore.QUrl.ComponentFormattingOption:

# class PySide2.QtCore.QUrl.FormattingOptions:

# class PySide2.QtCore.QUrl.ParsingMode:

# class PySide2.QtCore.QUrl.UrlFormattingOption:

# class PySide2.QtCore.QUrl.UserInputResolutionOption:

# class PySide2.QtCore.QUrl.UserInputResolutionOptions:
    "PySide2.QtCore.QUrl.__init__": [(), ('PySide2.QtCore.QUrl',), ('str', 'PySide2.QtCore.QUrl.ParsingMode')],
    "PySide2.QtCore.QUrl.__copy__": (),
    "PySide2.QtCore.QUrl.__reduce__": (),
    "PySide2.QtCore.QUrl.__repr__": (),
    "PySide2.QtCore.QUrl.adjusted": ('PySide2.QtCore.QUrl.FormattingOptions',),
    "PySide2.QtCore.QUrl.authority": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
    "PySide2.QtCore.QUrl.clear": (),
    "PySide2.QtCore.QUrl.errorString": (),
    "PySide2.QtCore.QUrl.fileName": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
    "PySide2.QtCore.QUrl.fragment": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
    "PySide2.QtCore.QUrl.fromAce": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtCore.QUrl.fromEncoded": ('PySide2.QtCore.QByteArray', 'PySide2.QtCore.QUrl.ParsingMode'),
    "PySide2.QtCore.QUrl.fromLocalFile": ('str',),
    "PySide2.QtCore.QUrl.fromPercentEncoding": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtCore.QUrl.fromStringList": ('typing.Sequence', 'PySide2.QtCore.QUrl.ParsingMode'),
    "PySide2.QtCore.QUrl.fromUserInput": [('str',), ('str', 'str', 'PySide2.QtCore.QUrl.UserInputResolutionOptions')],
    "PySide2.QtCore.QUrl.hasFragment": (),
    "PySide2.QtCore.QUrl.hasQuery": (),
    "PySide2.QtCore.QUrl.host": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
    "PySide2.QtCore.QUrl.idnWhitelist": (),
    "PySide2.QtCore.QUrl.isEmpty": (),
    "PySide2.QtCore.QUrl.isLocalFile": (),
    "PySide2.QtCore.QUrl.isParentOf": ('PySide2.QtCore.QUrl',),
    "PySide2.QtCore.QUrl.isRelative": (),
    "PySide2.QtCore.QUrl.isValid": (),
    "PySide2.QtCore.QUrl.matches": ('PySide2.QtCore.QUrl', 'PySide2.QtCore.QUrl.FormattingOptions'),
    "PySide2.QtCore.QUrl.password": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
    "PySide2.QtCore.QUrl.path": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
    "PySide2.QtCore.QUrl.port": ('int',),
    "PySide2.QtCore.QUrl.query": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
    "PySide2.QtCore.QUrl.resolved": ('PySide2.QtCore.QUrl',),
    "PySide2.QtCore.QUrl.scheme": (),
    "PySide2.QtCore.QUrl.setAuthority": ('str', 'PySide2.QtCore.QUrl.ParsingMode'),
    "PySide2.QtCore.QUrl.setFragment": ('str', 'PySide2.QtCore.QUrl.ParsingMode'),
    "PySide2.QtCore.QUrl.setHost": ('str', 'PySide2.QtCore.QUrl.ParsingMode'),
    "PySide2.QtCore.QUrl.setIdnWhitelist": ('typing.Sequence',),
    "PySide2.QtCore.QUrl.setPassword": ('str', 'PySide2.QtCore.QUrl.ParsingMode'),
    "PySide2.QtCore.QUrl.setPath": ('str', 'PySide2.QtCore.QUrl.ParsingMode'),
    "PySide2.QtCore.QUrl.setPort": ('int',),
    "PySide2.QtCore.QUrl.setQuery": [('PySide2.QtCore.QUrlQuery',), ('str', 'PySide2.QtCore.QUrl.ParsingMode')],
    "PySide2.QtCore.QUrl.setScheme": ('str',),
    "PySide2.QtCore.QUrl.setUrl": ('str', 'PySide2.QtCore.QUrl.ParsingMode'),
    "PySide2.QtCore.QUrl.setUserInfo": ('str', 'PySide2.QtCore.QUrl.ParsingMode'),
    "PySide2.QtCore.QUrl.setUserName": ('str', 'PySide2.QtCore.QUrl.ParsingMode'),
    "PySide2.QtCore.QUrl.swap": ('PySide2.QtCore.QUrl',),
    "PySide2.QtCore.QUrl.toAce": ('str',),
    "PySide2.QtCore.QUrl.toDisplayString": ('PySide2.QtCore.QUrl.FormattingOptions',),
    "PySide2.QtCore.QUrl.toEncoded": ('PySide2.QtCore.QUrl.FormattingOptions',),
    "PySide2.QtCore.QUrl.toLocalFile": (),
    "PySide2.QtCore.QUrl.toPercentEncoding": ('str', 'PySide2.QtCore.QByteArray', 'PySide2.QtCore.QByteArray'),
    "PySide2.QtCore.QUrl.toString": ('PySide2.QtCore.QUrl.FormattingOptions',),
    "PySide2.QtCore.QUrl.toStringList": ('typing.Sequence', 'PySide2.QtCore.QUrl.FormattingOptions'),
    "PySide2.QtCore.QUrl.topLevelDomain": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
    "PySide2.QtCore.QUrl.url": ('PySide2.QtCore.QUrl.FormattingOptions',),
    "PySide2.QtCore.QUrl.userInfo": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
    "PySide2.QtCore.QUrl.userName": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),

# class PySide2.QtCore.QUrlQuery:
    "PySide2.QtCore.QUrlQuery.__init__": [(), ('PySide2.QtCore.QUrl',), ('PySide2.QtCore.QUrlQuery',), ('str',)],
    "PySide2.QtCore.QUrlQuery.__copy__": (),
    "PySide2.QtCore.QUrlQuery.addQueryItem": ('str', 'str'),
    "PySide2.QtCore.QUrlQuery.allQueryItemValues": ('str', 'PySide2.QtCore.QUrl.ComponentFormattingOption'),
    "PySide2.QtCore.QUrlQuery.clear": (),
    "PySide2.QtCore.QUrlQuery.defaultQueryPairDelimiter": (),
    "PySide2.QtCore.QUrlQuery.defaultQueryValueDelimiter": (),
    "PySide2.QtCore.QUrlQuery.hasQueryItem": ('str',),
    "PySide2.QtCore.QUrlQuery.isEmpty": (),
    "PySide2.QtCore.QUrlQuery.query": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
    "PySide2.QtCore.QUrlQuery.queryItemValue": ('str', 'PySide2.QtCore.QUrl.ComponentFormattingOption'),
    "PySide2.QtCore.QUrlQuery.queryItems": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),
    "PySide2.QtCore.QUrlQuery.queryPairDelimiter": (),
    "PySide2.QtCore.QUrlQuery.queryValueDelimiter": (),
    "PySide2.QtCore.QUrlQuery.removeAllQueryItems": ('str',),
    "PySide2.QtCore.QUrlQuery.removeQueryItem": ('str',),
    "PySide2.QtCore.QUrlQuery.setQuery": ('str',),
    "PySide2.QtCore.QUrlQuery.setQueryDelimiters": ('typing.Char', 'typing.Char'),
    "PySide2.QtCore.QUrlQuery.setQueryItems": ('typing.Sequence',),
    "PySide2.QtCore.QUrlQuery.swap": ('PySide2.QtCore.QUrlQuery',),
    "PySide2.QtCore.QUrlQuery.toString": ('PySide2.QtCore.QUrl.ComponentFormattingOption',),

# class PySide2.QtCore.QUuid:

# class PySide2.QtCore.QUuid.StringFormat:

# class PySide2.QtCore.QUuid.Variant:

# class PySide2.QtCore.QUuid.Version:
    "PySide2.QtCore.QUuid.__init__": [(), ('PySide2.QtCore.QByteArray',), ('bytes',), ('int', 'int', 'int', 'typing.Char', 'typing.Char', 'typing.Char', 'typing.Char', 'typing.Char', 'typing.Char', 'typing.Char', 'typing.Char'), ('str',)],
    "PySide2.QtCore.QUuid.__copy__": (),
    "PySide2.QtCore.QUuid.__reduce__": (),
    "PySide2.QtCore.QUuid.__repr__": (),
    "PySide2.QtCore.QUuid.createUuid": (),
    "PySide2.QtCore.QUuid.createUuidV3": [('PySide2.QtCore.QUuid', 'PySide2.QtCore.QByteArray'), ('PySide2.QtCore.QUuid', 'str')],
    "PySide2.QtCore.QUuid.createUuidV5": [('PySide2.QtCore.QUuid', 'PySide2.QtCore.QByteArray'), ('PySide2.QtCore.QUuid', 'str')],
    "PySide2.QtCore.QUuid.fromRfc4122": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtCore.QUuid.isNull": (),
    "PySide2.QtCore.QUuid.toByteArray": [(), ('PySide2.QtCore.QUuid.StringFormat',)],
    "PySide2.QtCore.QUuid.toRfc4122": (),
    "PySide2.QtCore.QUuid.toString": [(), ('PySide2.QtCore.QUuid.StringFormat',)],
    "PySide2.QtCore.QUuid.variant": (),
    "PySide2.QtCore.QUuid.version": (),

# class PySide2.QtCore.QVariantAnimation:
    "PySide2.QtCore.QVariantAnimation.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtCore.QVariantAnimation.currentValue": (),
    "PySide2.QtCore.QVariantAnimation.duration": (),
    "PySide2.QtCore.QVariantAnimation.easingCurve": (),
    "PySide2.QtCore.QVariantAnimation.endValue": (),
    "PySide2.QtCore.QVariantAnimation.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QVariantAnimation.interpolated": ('typing.Any', 'typing.Any', 'float'),
    "PySide2.QtCore.QVariantAnimation.keyValueAt": ('float',),
    "PySide2.QtCore.QVariantAnimation.keyValues": (),
    "PySide2.QtCore.QVariantAnimation.setDuration": ('int',),
    "PySide2.QtCore.QVariantAnimation.setEasingCurve": ('PySide2.QtCore.QEasingCurve',),
    "PySide2.QtCore.QVariantAnimation.setEndValue": ('typing.Any',),
    "PySide2.QtCore.QVariantAnimation.setKeyValueAt": ('float', 'typing.Any'),
    "PySide2.QtCore.QVariantAnimation.setKeyValues": ('typing.List',),
    "PySide2.QtCore.QVariantAnimation.setStartValue": ('typing.Any',),
    "PySide2.QtCore.QVariantAnimation.startValue": (),
    "PySide2.QtCore.QVariantAnimation.updateCurrentTime": ('int',),
    "PySide2.QtCore.QVariantAnimation.updateCurrentValue": ('typing.Any',),
    "PySide2.QtCore.QVariantAnimation.updateState": ('PySide2.QtCore.QAbstractAnimation.State', 'PySide2.QtCore.QAbstractAnimation.State'),

# class PySide2.QtCore.QVersionNumber:
    "PySide2.QtCore.QVersionNumber.__init__": [(), ('int',), ('int', 'int'), ('int', 'int', 'int'), ('typing.List',)],
    "PySide2.QtCore.QVersionNumber.__copy__": (),
    "PySide2.QtCore.QVersionNumber.commonPrefix": ('PySide2.QtCore.QVersionNumber', 'PySide2.QtCore.QVersionNumber'),
    "PySide2.QtCore.QVersionNumber.compare": ('PySide2.QtCore.QVersionNumber', 'PySide2.QtCore.QVersionNumber'),
    "PySide2.QtCore.QVersionNumber.fromString": ('str',),
    "PySide2.QtCore.QVersionNumber.isNormalized": (),
    "PySide2.QtCore.QVersionNumber.isNull": (),
    "PySide2.QtCore.QVersionNumber.isPrefixOf": ('PySide2.QtCore.QVersionNumber',),
    "PySide2.QtCore.QVersionNumber.majorVersion": (),
    "PySide2.QtCore.QVersionNumber.microVersion": (),
    "PySide2.QtCore.QVersionNumber.minorVersion": (),
    "PySide2.QtCore.QVersionNumber.normalized": (),
    "PySide2.QtCore.QVersionNumber.segmentAt": ('int',),
    "PySide2.QtCore.QVersionNumber.segmentCount": (),
    "PySide2.QtCore.QVersionNumber.segments": (),
    "PySide2.QtCore.QVersionNumber.toString": (),

# class PySide2.QtCore.QWaitCondition:
    "PySide2.QtCore.QWaitCondition.__init__": (),
    "PySide2.QtCore.QWaitCondition.notify_all": (),
    "PySide2.QtCore.QWaitCondition.notify_one": (),
    "PySide2.QtCore.QWaitCondition.wait": [('PySide2.QtCore.QMutex', 'int'), ('PySide2.QtCore.QReadWriteLock', 'int')],
    "PySide2.QtCore.QWaitCondition.wakeAll": (),
    "PySide2.QtCore.QWaitCondition.wakeOne": (),

# class PySide2.QtCore.QWinEventNotifier:
    "PySide2.QtCore.QWinEventNotifier.__init__": [('PySide2.QtCore.QObject',), ('int', 'PySide2.QtCore.QObject')],
    "PySide2.QtCore.QWinEventNotifier.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtCore.QWinEventNotifier.handle": (),
    "PySide2.QtCore.QWinEventNotifier.isEnabled": (),
    "PySide2.QtCore.QWinEventNotifier.setEnabled": ('bool',),
    "PySide2.QtCore.QWinEventNotifier.setHandle": ('int',),

# class PySide2.QtCore.QWriteLocker:
    "PySide2.QtCore.QWriteLocker.__init__": ('PySide2.QtCore.QReadWriteLock',),
    "PySide2.QtCore.QWriteLocker.__enter__": (),
    "PySide2.QtCore.QWriteLocker.__exit__": ('object', 'object', 'object'),
    "PySide2.QtCore.QWriteLocker.readWriteLock": (),
    "PySide2.QtCore.QWriteLocker.relock": (),
    "PySide2.QtCore.QWriteLocker.unlock": (),

# class PySide2.QtCore.QXmlStreamAttribute:
    "PySide2.QtCore.QXmlStreamAttribute.__init__": [(), ('PySide2.QtCore.QXmlStreamAttribute',), ('str', 'str'), ('str', 'str', 'str')],
    "PySide2.QtCore.QXmlStreamAttribute.__copy__": (),
    "PySide2.QtCore.QXmlStreamAttribute.isDefault": (),
    "PySide2.QtCore.QXmlStreamAttribute.name": (),
    "PySide2.QtCore.QXmlStreamAttribute.namespaceUri": (),
    "PySide2.QtCore.QXmlStreamAttribute.prefix": (),
    "PySide2.QtCore.QXmlStreamAttribute.qualifiedName": (),
    "PySide2.QtCore.QXmlStreamAttribute.value": (),

# class PySide2.QtCore.QXmlStreamAttributes:
    "PySide2.QtCore.QXmlStreamAttributes.__init__": [(), ('PySide2.QtCore.QXmlStreamAttributes',)],
    "PySide2.QtCore.QXmlStreamAttributes.__add__": ('typing.List',),
    "PySide2.QtCore.QXmlStreamAttributes.__copy__": (),
    "PySide2.QtCore.QXmlStreamAttributes.__iadd__": ('PySide2.QtCore.QXmlStreamAttribute',),
    "PySide2.QtCore.QXmlStreamAttributes.__lshift__": [('PySide2.QtCore.QXmlStreamAttribute',), ('typing.List',)],
    "PySide2.QtCore.QXmlStreamAttributes.append": [('str', 'str'), ('str', 'str', 'str')],
    "PySide2.QtCore.QXmlStreamAttributes.at": ('int',),
    "PySide2.QtCore.QXmlStreamAttributes.back": (),
    "PySide2.QtCore.QXmlStreamAttributes.capacity": (),
    "PySide2.QtCore.QXmlStreamAttributes.clear": (),
    "PySide2.QtCore.QXmlStreamAttributes.constData": (),
    "PySide2.QtCore.QXmlStreamAttributes.constFirst": (),
    "PySide2.QtCore.QXmlStreamAttributes.constLast": (),
    "PySide2.QtCore.QXmlStreamAttributes.contains": ('PySide2.QtCore.QXmlStreamAttribute',),
    "PySide2.QtCore.QXmlStreamAttributes.count": [(), ('PySide2.QtCore.QXmlStreamAttribute',)],
    "PySide2.QtCore.QXmlStreamAttributes.data": (),
    "PySide2.QtCore.QXmlStreamAttributes.empty": (),
    "PySide2.QtCore.QXmlStreamAttributes.endsWith": ('PySide2.QtCore.QXmlStreamAttribute',),
    "PySide2.QtCore.QXmlStreamAttributes.fill": ('PySide2.QtCore.QXmlStreamAttribute', 'int'),
    "PySide2.QtCore.QXmlStreamAttributes.first": (),
    "PySide2.QtCore.QXmlStreamAttributes.front": (),
    "PySide2.QtCore.QXmlStreamAttributes.hasAttribute": [('str',), ('str', 'str')],
    "PySide2.QtCore.QXmlStreamAttributes.indexOf": ('PySide2.QtCore.QXmlStreamAttribute', 'int'),
    "PySide2.QtCore.QXmlStreamAttributes.insert": [('int', 'PySide2.QtCore.QXmlStreamAttribute'), ('int', 'int', 'PySide2.QtCore.QXmlStreamAttribute')],
    "PySide2.QtCore.QXmlStreamAttributes.isEmpty": (),
    "PySide2.QtCore.QXmlStreamAttributes.isSharedWith": ('typing.List',),
    "PySide2.QtCore.QXmlStreamAttributes.last": (),
    "PySide2.QtCore.QXmlStreamAttributes.lastIndexOf": ('PySide2.QtCore.QXmlStreamAttribute', 'int'),
    "PySide2.QtCore.QXmlStreamAttributes.length": (),
    "PySide2.QtCore.QXmlStreamAttributes.mid": ('int', 'int'),
    "PySide2.QtCore.QXmlStreamAttributes.move": ('int', 'int'),
    "PySide2.QtCore.QXmlStreamAttributes.prepend": ('PySide2.QtCore.QXmlStreamAttribute',),
    "PySide2.QtCore.QXmlStreamAttributes.remove": [('int',), ('int', 'int')],
    "PySide2.QtCore.QXmlStreamAttributes.removeAll": ('PySide2.QtCore.QXmlStreamAttribute',),
    "PySide2.QtCore.QXmlStreamAttributes.removeAt": ('int',),
    "PySide2.QtCore.QXmlStreamAttributes.removeFirst": (),
    "PySide2.QtCore.QXmlStreamAttributes.removeLast": (),
    "PySide2.QtCore.QXmlStreamAttributes.removeOne": ('PySide2.QtCore.QXmlStreamAttribute',),
    "PySide2.QtCore.QXmlStreamAttributes.replace": ('int', 'PySide2.QtCore.QXmlStreamAttribute'),
    "PySide2.QtCore.QXmlStreamAttributes.reserve": ('int',),
    "PySide2.QtCore.QXmlStreamAttributes.resize": ('int',),
    "PySide2.QtCore.QXmlStreamAttributes.setSharable": ('bool',),
    "PySide2.QtCore.QXmlStreamAttributes.shrink_to_fit": (),
    "PySide2.QtCore.QXmlStreamAttributes.size": (),
    "PySide2.QtCore.QXmlStreamAttributes.squeeze": (),
    "PySide2.QtCore.QXmlStreamAttributes.startsWith": ('PySide2.QtCore.QXmlStreamAttribute',),
    "PySide2.QtCore.QXmlStreamAttributes.swap": ('typing.List',),
    "PySide2.QtCore.QXmlStreamAttributes.swapItemsAt": ('int', 'int'),
    "PySide2.QtCore.QXmlStreamAttributes.takeAt": ('int',),
    "PySide2.QtCore.QXmlStreamAttributes.takeFirst": (),
    "PySide2.QtCore.QXmlStreamAttributes.takeLast": (),
    "PySide2.QtCore.QXmlStreamAttributes.value": [('str',), ('str', 'str')],

# class PySide2.QtCore.QXmlStreamEntityDeclaration:
    "PySide2.QtCore.QXmlStreamEntityDeclaration.__init__": [(), ('PySide2.QtCore.QXmlStreamEntityDeclaration',)],
    "PySide2.QtCore.QXmlStreamEntityDeclaration.__copy__": (),
    "PySide2.QtCore.QXmlStreamEntityDeclaration.name": (),
    "PySide2.QtCore.QXmlStreamEntityDeclaration.notationName": (),
    "PySide2.QtCore.QXmlStreamEntityDeclaration.publicId": (),
    "PySide2.QtCore.QXmlStreamEntityDeclaration.systemId": (),
    "PySide2.QtCore.QXmlStreamEntityDeclaration.value": (),

# class PySide2.QtCore.QXmlStreamEntityResolver:
    "PySide2.QtCore.QXmlStreamEntityResolver.__init__": (),
    "PySide2.QtCore.QXmlStreamEntityResolver.resolveEntity": ('str', 'str'),
    "PySide2.QtCore.QXmlStreamEntityResolver.resolveUndeclaredEntity": ('str',),

# class PySide2.QtCore.QXmlStreamNamespaceDeclaration:
    "PySide2.QtCore.QXmlStreamNamespaceDeclaration.__init__": [(), ('PySide2.QtCore.QXmlStreamNamespaceDeclaration',), ('str', 'str')],
    "PySide2.QtCore.QXmlStreamNamespaceDeclaration.__copy__": (),
    "PySide2.QtCore.QXmlStreamNamespaceDeclaration.namespaceUri": (),
    "PySide2.QtCore.QXmlStreamNamespaceDeclaration.prefix": (),

# class PySide2.QtCore.QXmlStreamNotationDeclaration:
    "PySide2.QtCore.QXmlStreamNotationDeclaration.__init__": [(), ('PySide2.QtCore.QXmlStreamNotationDeclaration',)],
    "PySide2.QtCore.QXmlStreamNotationDeclaration.__copy__": (),
    "PySide2.QtCore.QXmlStreamNotationDeclaration.name": (),
    "PySide2.QtCore.QXmlStreamNotationDeclaration.publicId": (),
    "PySide2.QtCore.QXmlStreamNotationDeclaration.systemId": (),

# class PySide2.QtCore.QXmlStreamReader:

# class PySide2.QtCore.QXmlStreamReader.Error:

# class PySide2.QtCore.QXmlStreamReader.ReadElementTextBehaviour:

# class PySide2.QtCore.QXmlStreamReader.TokenType:
    "PySide2.QtCore.QXmlStreamReader.__init__": [(), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QIODevice',), ('bytes',), ('str',)],
    "PySide2.QtCore.QXmlStreamReader.addData": [('PySide2.QtCore.QByteArray',), ('bytes',), ('str',)],
    "PySide2.QtCore.QXmlStreamReader.addExtraNamespaceDeclaration": ('PySide2.QtCore.QXmlStreamNamespaceDeclaration',),
    "PySide2.QtCore.QXmlStreamReader.addExtraNamespaceDeclarations": ('typing.List',),
    "PySide2.QtCore.QXmlStreamReader.atEnd": (),
    "PySide2.QtCore.QXmlStreamReader.attributes": (),
    "PySide2.QtCore.QXmlStreamReader.characterOffset": (),
    "PySide2.QtCore.QXmlStreamReader.clear": (),
    "PySide2.QtCore.QXmlStreamReader.columnNumber": (),
    "PySide2.QtCore.QXmlStreamReader.device": (),
    "PySide2.QtCore.QXmlStreamReader.documentEncoding": (),
    "PySide2.QtCore.QXmlStreamReader.documentVersion": (),
    "PySide2.QtCore.QXmlStreamReader.dtdName": (),
    "PySide2.QtCore.QXmlStreamReader.dtdPublicId": (),
    "PySide2.QtCore.QXmlStreamReader.dtdSystemId": (),
    "PySide2.QtCore.QXmlStreamReader.entityDeclarations": (),
    "PySide2.QtCore.QXmlStreamReader.entityResolver": (),
    "PySide2.QtCore.QXmlStreamReader.error": (),
    "PySide2.QtCore.QXmlStreamReader.errorString": (),
    "PySide2.QtCore.QXmlStreamReader.hasError": (),
    "PySide2.QtCore.QXmlStreamReader.isCDATA": (),
    "PySide2.QtCore.QXmlStreamReader.isCharacters": (),
    "PySide2.QtCore.QXmlStreamReader.isComment": (),
    "PySide2.QtCore.QXmlStreamReader.isDTD": (),
    "PySide2.QtCore.QXmlStreamReader.isEndDocument": (),
    "PySide2.QtCore.QXmlStreamReader.isEndElement": (),
    "PySide2.QtCore.QXmlStreamReader.isEntityReference": (),
    "PySide2.QtCore.QXmlStreamReader.isProcessingInstruction": (),
    "PySide2.QtCore.QXmlStreamReader.isStandaloneDocument": (),
    "PySide2.QtCore.QXmlStreamReader.isStartDocument": (),
    "PySide2.QtCore.QXmlStreamReader.isStartElement": (),
    "PySide2.QtCore.QXmlStreamReader.isWhitespace": (),
    "PySide2.QtCore.QXmlStreamReader.lineNumber": (),
    "PySide2.QtCore.QXmlStreamReader.name": (),
    "PySide2.QtCore.QXmlStreamReader.namespaceDeclarations": (),
    "PySide2.QtCore.QXmlStreamReader.namespaceProcessing": (),
    "PySide2.QtCore.QXmlStreamReader.namespaceUri": (),
    "PySide2.QtCore.QXmlStreamReader.notationDeclarations": (),
    "PySide2.QtCore.QXmlStreamReader.prefix": (),
    "PySide2.QtCore.QXmlStreamReader.processingInstructionData": (),
    "PySide2.QtCore.QXmlStreamReader.processingInstructionTarget": (),
    "PySide2.QtCore.QXmlStreamReader.qualifiedName": (),
    "PySide2.QtCore.QXmlStreamReader.raiseError": ('str',),
    "PySide2.QtCore.QXmlStreamReader.readElementText": ('PySide2.QtCore.QXmlStreamReader.ReadElementTextBehaviour',),
    "PySide2.QtCore.QXmlStreamReader.readNext": (),
    "PySide2.QtCore.QXmlStreamReader.readNextStartElement": (),
    "PySide2.QtCore.QXmlStreamReader.setDevice": ('PySide2.QtCore.QIODevice',),
    "PySide2.QtCore.QXmlStreamReader.setEntityResolver": ('PySide2.QtCore.QXmlStreamEntityResolver',),
    "PySide2.QtCore.QXmlStreamReader.setNamespaceProcessing": ('bool',),
    "PySide2.QtCore.QXmlStreamReader.skipCurrentElement": (),
    "PySide2.QtCore.QXmlStreamReader.text": (),
    "PySide2.QtCore.QXmlStreamReader.tokenString": (),
    "PySide2.QtCore.QXmlStreamReader.tokenType": (),

# class PySide2.QtCore.QXmlStreamWriter:
    "PySide2.QtCore.QXmlStreamWriter.__init__": [(), ('PySide2.QtCore.QByteArray',), ('PySide2.QtCore.QIODevice',)],
    "PySide2.QtCore.QXmlStreamWriter.autoFormatting": (),
    "PySide2.QtCore.QXmlStreamWriter.autoFormattingIndent": (),
    "PySide2.QtCore.QXmlStreamWriter.codec": (),
    "PySide2.QtCore.QXmlStreamWriter.device": (),
    "PySide2.QtCore.QXmlStreamWriter.hasError": (),
    "PySide2.QtCore.QXmlStreamWriter.setAutoFormatting": ('bool',),
    "PySide2.QtCore.QXmlStreamWriter.setAutoFormattingIndent": ('int',),
    "PySide2.QtCore.QXmlStreamWriter.setCodec": [('PySide2.QtCore.QTextCodec',), ('bytes',)],
    "PySide2.QtCore.QXmlStreamWriter.setDevice": ('PySide2.QtCore.QIODevice',),
    "PySide2.QtCore.QXmlStreamWriter.writeAttribute": [('PySide2.QtCore.QXmlStreamAttribute',), ('str', 'str'), ('str', 'str', 'str')],
    "PySide2.QtCore.QXmlStreamWriter.writeAttributes": ('PySide2.QtCore.QXmlStreamAttributes',),
    "PySide2.QtCore.QXmlStreamWriter.writeCDATA": ('str',),
    "PySide2.QtCore.QXmlStreamWriter.writeCharacters": ('str',),
    "PySide2.QtCore.QXmlStreamWriter.writeComment": ('str',),
    "PySide2.QtCore.QXmlStreamWriter.writeCurrentToken": ('PySide2.QtCore.QXmlStreamReader',),
    "PySide2.QtCore.QXmlStreamWriter.writeDTD": ('str',),
    "PySide2.QtCore.QXmlStreamWriter.writeDefaultNamespace": ('str',),
    "PySide2.QtCore.QXmlStreamWriter.writeEmptyElement": [('str',), ('str', 'str')],
    "PySide2.QtCore.QXmlStreamWriter.writeEndDocument": (),
    "PySide2.QtCore.QXmlStreamWriter.writeEndElement": (),
    "PySide2.QtCore.QXmlStreamWriter.writeEntityReference": ('str',),
    "PySide2.QtCore.QXmlStreamWriter.writeNamespace": ('str', 'str'),
    "PySide2.QtCore.QXmlStreamWriter.writeProcessingInstruction": ('str', 'str'),
    "PySide2.QtCore.QXmlStreamWriter.writeStartDocument": [(), ('str',), ('str', 'bool')],
    "PySide2.QtCore.QXmlStreamWriter.writeStartElement": [('str',), ('str', 'str')],
    "PySide2.QtCore.QXmlStreamWriter.writeTextElement": [('str', 'str'), ('str', 'str', 'str')],

# class PySide2.QtCore.Qt:

# class PySide2.QtCore.Qt.Alignment:

# class PySide2.QtCore.Qt.AlignmentFlag:

# class PySide2.QtCore.Qt.AnchorPoint:

# class PySide2.QtCore.Qt.ApplicationAttribute:

# class PySide2.QtCore.Qt.ApplicationState:

# class PySide2.QtCore.Qt.ApplicationStates:

# class PySide2.QtCore.Qt.ArrowType:

# class PySide2.QtCore.Qt.AspectRatioMode:

# class PySide2.QtCore.Qt.Axis:

# class PySide2.QtCore.Qt.BGMode:

# class PySide2.QtCore.Qt.BrushStyle:

# class PySide2.QtCore.Qt.CaseSensitivity:

# class PySide2.QtCore.Qt.CheckState:

# class PySide2.QtCore.Qt.ChecksumType:

# class PySide2.QtCore.Qt.ClipOperation:

# class PySide2.QtCore.Qt.ConnectionType:

# class PySide2.QtCore.Qt.ContextMenuPolicy:

# class PySide2.QtCore.Qt.CoordinateSystem:

# class PySide2.QtCore.Qt.Corner:

# class PySide2.QtCore.Qt.CursorMoveStyle:

# class PySide2.QtCore.Qt.CursorShape:

# class PySide2.QtCore.Qt.DateFormat:

# class PySide2.QtCore.Qt.DayOfWeek:

# class PySide2.QtCore.Qt.DockWidgetArea:

# class PySide2.QtCore.Qt.DockWidgetAreaSizes:

# class PySide2.QtCore.Qt.DockWidgetAreas:

# class PySide2.QtCore.Qt.DropAction:

# class PySide2.QtCore.Qt.DropActions:

# class PySide2.QtCore.Qt.Edge:

# class PySide2.QtCore.Qt.Edges:

# class PySide2.QtCore.Qt.EnterKeyType:

# class PySide2.QtCore.Qt.EventPriority:

# class PySide2.QtCore.Qt.FillRule:

# class PySide2.QtCore.Qt.FindChildOption:

# class PySide2.QtCore.Qt.FindChildOptions:

# class PySide2.QtCore.Qt.FocusPolicy:

# class PySide2.QtCore.Qt.FocusReason:

# class PySide2.QtCore.Qt.GestureFlag:

# class PySide2.QtCore.Qt.GestureFlags:

# class PySide2.QtCore.Qt.GestureState:

# class PySide2.QtCore.Qt.GestureType:

# class PySide2.QtCore.Qt.GlobalColor:

# class PySide2.QtCore.Qt.HighDpiScaleFactorRoundingPolicy:

# class PySide2.QtCore.Qt.HitTestAccuracy:

# class PySide2.QtCore.Qt.ImageConversionFlag:

# class PySide2.QtCore.Qt.ImageConversionFlags:

# class PySide2.QtCore.Qt.InputMethodHint:

# class PySide2.QtCore.Qt.InputMethodHints:

# class PySide2.QtCore.Qt.InputMethodQueries:

# class PySide2.QtCore.Qt.InputMethodQuery:

# class PySide2.QtCore.Qt.ItemDataRole:

# class PySide2.QtCore.Qt.ItemFlag:

# class PySide2.QtCore.Qt.ItemFlags:

# class PySide2.QtCore.Qt.ItemSelectionMode:

# class PySide2.QtCore.Qt.ItemSelectionOperation:

# class PySide2.QtCore.Qt.Key:

# class PySide2.QtCore.Qt.KeyboardModifier:

# class PySide2.QtCore.Qt.KeyboardModifiers:

# class PySide2.QtCore.Qt.LayoutDirection:

# class PySide2.QtCore.Qt.MaskMode:

# class PySide2.QtCore.Qt.MatchFlag:

# class PySide2.QtCore.Qt.MatchFlags:

# class PySide2.QtCore.Qt.Modifier:

# class PySide2.QtCore.Qt.MouseButton:

# class PySide2.QtCore.Qt.MouseButtons:

# class PySide2.QtCore.Qt.MouseEventFlag:

# class PySide2.QtCore.Qt.MouseEventFlags:

# class PySide2.QtCore.Qt.MouseEventSource:

# class PySide2.QtCore.Qt.NativeGestureType:

# class PySide2.QtCore.Qt.NavigationMode:

# class PySide2.QtCore.Qt.Orientation:

# class PySide2.QtCore.Qt.Orientations:

# class PySide2.QtCore.Qt.PenCapStyle:

# class PySide2.QtCore.Qt.PenJoinStyle:

# class PySide2.QtCore.Qt.PenStyle:

# class PySide2.QtCore.Qt.ScreenOrientation:

# class PySide2.QtCore.Qt.ScreenOrientations:

# class PySide2.QtCore.Qt.ScrollBarPolicy:

# class PySide2.QtCore.Qt.ScrollPhase:

# class PySide2.QtCore.Qt.ShortcutContext:

# class PySide2.QtCore.Qt.SizeHint:

# class PySide2.QtCore.Qt.SizeMode:

# class PySide2.QtCore.Qt.SortOrder:

# class PySide2.QtCore.Qt.SplitBehavior:

# class PySide2.QtCore.Qt.SplitBehaviorFlags:

# class PySide2.QtCore.Qt.TabFocusBehavior:

# class PySide2.QtCore.Qt.TextElideMode:

# class PySide2.QtCore.Qt.TextFlag:

# class PySide2.QtCore.Qt.TextFormat:

# class PySide2.QtCore.Qt.TextInteractionFlag:

# class PySide2.QtCore.Qt.TextInteractionFlags:

# class PySide2.QtCore.Qt.TileRule:

# class PySide2.QtCore.Qt.TimeSpec:

# class PySide2.QtCore.Qt.TimerType:

# class PySide2.QtCore.Qt.ToolBarArea:

# class PySide2.QtCore.Qt.ToolBarAreaSizes:

# class PySide2.QtCore.Qt.ToolBarAreas:

# class PySide2.QtCore.Qt.ToolButtonStyle:

# class PySide2.QtCore.Qt.TouchPointState:

# class PySide2.QtCore.Qt.TouchPointStates:

# class PySide2.QtCore.Qt.TransformationMode:

# class PySide2.QtCore.Qt.UIEffect:

# class PySide2.QtCore.Qt.WhiteSpaceMode:

# class PySide2.QtCore.Qt.WidgetAttribute:

# class PySide2.QtCore.Qt.WindowFlags:

# class PySide2.QtCore.Qt.WindowFrameSection:

# class PySide2.QtCore.Qt.WindowModality:

# class PySide2.QtCore.Qt.WindowState:

# class PySide2.QtCore.Qt.WindowStates:

# class PySide2.QtCore.Qt.WindowType:

# class PySide2.QtCore.QtMsgType:

# class PySide2.QtCore.Signal:
    "PySide2.QtCore.Signal.__init__": ('type', 'str', 'str'),

# class PySide2.QtCore.SignalInstance:
    "PySide2.QtCore.SignalInstance.connect": ('object', 'type'),
    "PySide2.QtCore.SignalInstance.disconnect": ('object',),
    "PySide2.QtCore.SignalInstance.emit": ('typing.Any',),

# class PySide2.QtCore.Slot:
    "PySide2.QtCore.Slot.__init__": ('type', 'str', 'str'),

    "PySide2.QtCore.Slot.QT_TRANSLATE_NOOP": ('object', 'object'),
    "PySide2.QtCore.Slot.QT_TRANSLATE_NOOP3": ('object', 'object', 'object'),
    "PySide2.QtCore.Slot.QT_TRANSLATE_NOOP_UTF8": ('object',),
    "PySide2.QtCore.Slot.QT_TR_NOOP": ('object',),
    "PySide2.QtCore.Slot.QT_TR_NOOP_UTF8": ('object',),
    "PySide2.QtCore.Slot.SIGNAL": ('bytes',),
    "PySide2.QtCore.Slot.SLOT": ('bytes',),
    "PySide2.QtCore.Slot.__moduleShutdown": (),
    "PySide2.QtCore.Slot.qAbs": ('float',),
    "PySide2.QtCore.Slot.qAcos": ('float',),
    "PySide2.QtCore.Slot.qAddPostRoutine": ('object',),
    "PySide2.QtCore.Slot.qAsin": ('float',),
    "PySide2.QtCore.Slot.qAtan": ('float',),
    "PySide2.QtCore.Slot.qAtan2": ('float', 'float'),
    "PySide2.QtCore.Slot.qChecksum": ('bytes', 'int'),
    "PySide2.QtCore.Slot.qCompress": [('PySide2.QtCore.QByteArray', 'int'), ('bytes', 'int', 'int')],
    "PySide2.QtCore.Slot.qCritical": ('bytes',),
    "PySide2.QtCore.Slot.qDebug": ('bytes',),
    "PySide2.QtCore.Slot.qExp": ('float',),
    "PySide2.QtCore.Slot.qFabs": ('float',),
    "PySide2.QtCore.Slot.qFastCos": ('float',),
    "PySide2.QtCore.Slot.qFastSin": ('float',),
    "PySide2.QtCore.Slot.qFatal": ('bytes',),
    "PySide2.QtCore.Slot.qFuzzyCompare": ('float', 'float'),
    "PySide2.QtCore.Slot.qFuzzyIsNull": ('float',),
    "PySide2.QtCore.Slot.qInstallMessageHandler": ('object',),
    "PySide2.QtCore.Slot.qIsFinite": ('float',),
    "PySide2.QtCore.Slot.qIsInf": ('float',),
    "PySide2.QtCore.Slot.qIsNaN": ('float',),
    "PySide2.QtCore.Slot.qIsNull": ('float',),
    "PySide2.QtCore.Slot.qRegisterResourceData": ('int', 'bytes', 'bytes', 'bytes'),
    "PySide2.QtCore.Slot.qTan": ('float',),
    "PySide2.QtCore.Slot.qUncompress": [('PySide2.QtCore.QByteArray',), ('bytes', 'int')],
    "PySide2.QtCore.Slot.qUnregisterResourceData": ('int', 'bytes', 'bytes', 'bytes'),
    "PySide2.QtCore.Slot.qVersion": (),
    "PySide2.QtCore.Slot.qWarning": ('bytes',),
    "PySide2.QtCore.Slot.qrand": (),
    "PySide2.QtCore.Slot.qsrand": ('int',),
    "PySide2.QtCore.Slot.qtTrId": ('bytes', 'int'),
    }) if "PySide2.QtCore" in sys.modules else None

# Module PySide2.QtGui
sig_dict.update({

# class PySide2.QtGui.QAbstractOpenGLFunctions:
    "PySide2.QtGui.QAbstractOpenGLFunctions.__init__": (),
    "PySide2.QtGui.QAbstractOpenGLFunctions.initializeOpenGLFunctions": (),
    "PySide2.QtGui.QAbstractOpenGLFunctions.isInitialized": (),
    "PySide2.QtGui.QAbstractOpenGLFunctions.owningContext": (),
    "PySide2.QtGui.QAbstractOpenGLFunctions.setOwningContext": ('PySide2.QtGui.QOpenGLContext',),

# class PySide2.QtGui.QAbstractTextDocumentLayout:

# class PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext:
    "PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext.__init__": [(), ('PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext',)],
    "PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext.__copy__": (),

# class PySide2.QtGui.QAbstractTextDocumentLayout.Selection:
    "PySide2.QtGui.QAbstractTextDocumentLayout.Selection.__init__": [(), ('PySide2.QtGui.QAbstractTextDocumentLayout.Selection',)],
    "PySide2.QtGui.QAbstractTextDocumentLayout.Selection.__copy__": (),

    "PySide2.QtGui.QAbstractTextDocumentLayout.__init__": ('PySide2.QtGui.QTextDocument',),
    "PySide2.QtGui.QAbstractTextDocumentLayout.anchorAt": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QAbstractTextDocumentLayout.blockBoundingRect": ('PySide2.QtGui.QTextBlock',),
    "PySide2.QtGui.QAbstractTextDocumentLayout.blockWithMarkerAt": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QAbstractTextDocumentLayout.document": (),
    "PySide2.QtGui.QAbstractTextDocumentLayout.documentChanged": ('int', 'int', 'int'),
    "PySide2.QtGui.QAbstractTextDocumentLayout.documentSize": (),
    "PySide2.QtGui.QAbstractTextDocumentLayout.draw": ('PySide2.QtGui.QPainter', 'PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext'),
    "PySide2.QtGui.QAbstractTextDocumentLayout.drawInlineObject": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF', 'PySide2.QtGui.QTextInlineObject', 'int', 'PySide2.QtGui.QTextFormat'),
    "PySide2.QtGui.QAbstractTextDocumentLayout.format": ('int',),
    "PySide2.QtGui.QAbstractTextDocumentLayout.formatAt": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QAbstractTextDocumentLayout.formatIndex": ('int',),
    "PySide2.QtGui.QAbstractTextDocumentLayout.frameBoundingRect": ('PySide2.QtGui.QTextFrame',),
    "PySide2.QtGui.QAbstractTextDocumentLayout.handlerForObject": ('int',),
    "PySide2.QtGui.QAbstractTextDocumentLayout.hitTest": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.HitTestAccuracy'),
    "PySide2.QtGui.QAbstractTextDocumentLayout.imageAt": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QAbstractTextDocumentLayout.pageCount": (),
    "PySide2.QtGui.QAbstractTextDocumentLayout.paintDevice": (),
    "PySide2.QtGui.QAbstractTextDocumentLayout.positionInlineObject": ('PySide2.QtGui.QTextInlineObject', 'int', 'PySide2.QtGui.QTextFormat'),
    "PySide2.QtGui.QAbstractTextDocumentLayout.registerHandler": ('int', 'PySide2.QtCore.QObject'),
    "PySide2.QtGui.QAbstractTextDocumentLayout.resizeInlineObject": ('PySide2.QtGui.QTextInlineObject', 'int', 'PySide2.QtGui.QTextFormat'),
    "PySide2.QtGui.QAbstractTextDocumentLayout.setPaintDevice": ('PySide2.QtGui.QPaintDevice',),
    "PySide2.QtGui.QAbstractTextDocumentLayout.unregisterHandler": ('int', 'PySide2.QtCore.QObject'),

# class PySide2.QtGui.QAccessible:

# class PySide2.QtGui.QAccessible.Event:

# class PySide2.QtGui.QAccessible.InterfaceType:

# class PySide2.QtGui.QAccessible.Relation:

# class PySide2.QtGui.QAccessible.RelationFlag:

# class PySide2.QtGui.QAccessible.Role:

# class PySide2.QtGui.QAccessible.State:
    "PySide2.QtGui.QAccessible.State.__init__": [(), ('PySide2.QtGui.QAccessible.State',)],
    "PySide2.QtGui.QAccessible.State.__copy__": (),

# class PySide2.QtGui.QAccessible.Text:

# class PySide2.QtGui.QAccessible.TextBoundaryType:

    "PySide2.QtGui.QAccessible.__copy__": (),
    "PySide2.QtGui.QAccessible.accessibleInterface": ('int',),
    "PySide2.QtGui.QAccessible.cleanup": (),
    "PySide2.QtGui.QAccessible.deleteAccessibleInterface": ('int',),
    "PySide2.QtGui.QAccessible.isActive": (),
    "PySide2.QtGui.QAccessible.qAccessibleTextBoundaryHelper": ('PySide2.QtGui.QTextCursor', 'PySide2.QtGui.QAccessible.TextBoundaryType'),
    "PySide2.QtGui.QAccessible.queryAccessibleInterface": ('PySide2.QtCore.QObject',),
    "PySide2.QtGui.QAccessible.registerAccessibleInterface": ('PySide2.QtGui.QAccessibleInterface',),
    "PySide2.QtGui.QAccessible.setActive": ('bool',),
    "PySide2.QtGui.QAccessible.setRootObject": ('PySide2.QtCore.QObject',),
    "PySide2.QtGui.QAccessible.uniqueId": ('PySide2.QtGui.QAccessibleInterface',),
    "PySide2.QtGui.QAccessible.updateAccessibility": ('PySide2.QtGui.QAccessibleEvent',),

# class PySide2.QtGui.QAccessibleEditableTextInterface:
    "PySide2.QtGui.QAccessibleEditableTextInterface.__init__": (),
    "PySide2.QtGui.QAccessibleEditableTextInterface.deleteText": ('int', 'int'),
    "PySide2.QtGui.QAccessibleEditableTextInterface.insertText": ('int', 'str'),
    "PySide2.QtGui.QAccessibleEditableTextInterface.replaceText": ('int', 'int', 'str'),

# class PySide2.QtGui.QAccessibleEvent:
    "PySide2.QtGui.QAccessibleEvent.__init__": [('PySide2.QtCore.QObject', 'PySide2.QtGui.QAccessible.Event'), ('PySide2.QtGui.QAccessibleInterface', 'PySide2.QtGui.QAccessible.Event')],
    "PySide2.QtGui.QAccessibleEvent.accessibleInterface": (),
    "PySide2.QtGui.QAccessibleEvent.child": (),
    "PySide2.QtGui.QAccessibleEvent.object": (),
    "PySide2.QtGui.QAccessibleEvent.setChild": ('int',),
    "PySide2.QtGui.QAccessibleEvent.type": (),
    "PySide2.QtGui.QAccessibleEvent.uniqueId": (),

# class PySide2.QtGui.QAccessibleInterface:
    "PySide2.QtGui.QAccessibleInterface.__init__": (),
    "PySide2.QtGui.QAccessibleInterface.backgroundColor": (),
    "PySide2.QtGui.QAccessibleInterface.child": ('int',),
    "PySide2.QtGui.QAccessibleInterface.childAt": ('int', 'int'),
    "PySide2.QtGui.QAccessibleInterface.childCount": (),
    "PySide2.QtGui.QAccessibleInterface.editableTextInterface": (),
    "PySide2.QtGui.QAccessibleInterface.focusChild": (),
    "PySide2.QtGui.QAccessibleInterface.foregroundColor": (),
    "PySide2.QtGui.QAccessibleInterface.indexOfChild": ('PySide2.QtGui.QAccessibleInterface',),
    "PySide2.QtGui.QAccessibleInterface.interface_cast": ('PySide2.QtGui.QAccessible.InterfaceType',),
    "PySide2.QtGui.QAccessibleInterface.isValid": (),
    "PySide2.QtGui.QAccessibleInterface.object": (),
    "PySide2.QtGui.QAccessibleInterface.parent": (),
    "PySide2.QtGui.QAccessibleInterface.rect": (),
    "PySide2.QtGui.QAccessibleInterface.relations": ('PySide2.QtGui.QAccessible.Relation',),
    "PySide2.QtGui.QAccessibleInterface.role": (),
    "PySide2.QtGui.QAccessibleInterface.setText": ('PySide2.QtGui.QAccessible.Text', 'str'),
    "PySide2.QtGui.QAccessibleInterface.state": (),
    "PySide2.QtGui.QAccessibleInterface.tableCellInterface": (),
    "PySide2.QtGui.QAccessibleInterface.text": ('PySide2.QtGui.QAccessible.Text',),
    "PySide2.QtGui.QAccessibleInterface.textInterface": (),
    "PySide2.QtGui.QAccessibleInterface.valueInterface": (),
    "PySide2.QtGui.QAccessibleInterface.virtual_hook": ('int', 'int'),
    "PySide2.QtGui.QAccessibleInterface.window": (),

# class PySide2.QtGui.QAccessibleObject:
    "PySide2.QtGui.QAccessibleObject.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtGui.QAccessibleObject.childAt": ('int', 'int'),
    "PySide2.QtGui.QAccessibleObject.isValid": (),
    "PySide2.QtGui.QAccessibleObject.object": (),
    "PySide2.QtGui.QAccessibleObject.rect": (),
    "PySide2.QtGui.QAccessibleObject.setText": ('PySide2.QtGui.QAccessible.Text', 'str'),

# class PySide2.QtGui.QAccessibleStateChangeEvent:
    "PySide2.QtGui.QAccessibleStateChangeEvent.__init__": [('PySide2.QtCore.QObject', 'PySide2.QtGui.QAccessible.State'), ('PySide2.QtGui.QAccessibleInterface', 'PySide2.QtGui.QAccessible.State')],
    "PySide2.QtGui.QAccessibleStateChangeEvent.changedStates": (),

# class PySide2.QtGui.QAccessibleTableCellInterface:
    "PySide2.QtGui.QAccessibleTableCellInterface.__init__": (),
    "PySide2.QtGui.QAccessibleTableCellInterface.columnExtent": (),
    "PySide2.QtGui.QAccessibleTableCellInterface.columnHeaderCells": (),
    "PySide2.QtGui.QAccessibleTableCellInterface.columnIndex": (),
    "PySide2.QtGui.QAccessibleTableCellInterface.isSelected": (),
    "PySide2.QtGui.QAccessibleTableCellInterface.rowExtent": (),
    "PySide2.QtGui.QAccessibleTableCellInterface.rowHeaderCells": (),
    "PySide2.QtGui.QAccessibleTableCellInterface.rowIndex": (),
    "PySide2.QtGui.QAccessibleTableCellInterface.table": (),

# class PySide2.QtGui.QAccessibleTableModelChangeEvent:

# class PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType:
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.__init__": [('PySide2.QtCore.QObject', 'PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType'), ('PySide2.QtGui.QAccessibleInterface', 'PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType')],
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.firstColumn": (),
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.firstRow": (),
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.lastColumn": (),
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.lastRow": (),
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.modelChangeType": (),
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.setFirstColumn": ('int',),
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.setFirstRow": ('int',),
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.setLastColumn": ('int',),
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.setLastRow": ('int',),
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.setModelChangeType": ('PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType',),

# class PySide2.QtGui.QAccessibleTextCursorEvent:
    "PySide2.QtGui.QAccessibleTextCursorEvent.__init__": [('PySide2.QtCore.QObject', 'int'), ('PySide2.QtGui.QAccessibleInterface', 'int')],
    "PySide2.QtGui.QAccessibleTextCursorEvent.cursorPosition": (),
    "PySide2.QtGui.QAccessibleTextCursorEvent.setCursorPosition": ('int',),

# class PySide2.QtGui.QAccessibleTextInsertEvent:
    "PySide2.QtGui.QAccessibleTextInsertEvent.__init__": [('PySide2.QtCore.QObject', 'int', 'str'), ('PySide2.QtGui.QAccessibleInterface', 'int', 'str')],
    "PySide2.QtGui.QAccessibleTextInsertEvent.changePosition": (),
    "PySide2.QtGui.QAccessibleTextInsertEvent.textInserted": (),

# class PySide2.QtGui.QAccessibleTextInterface:
    "PySide2.QtGui.QAccessibleTextInterface.__init__": (),
    "PySide2.QtGui.QAccessibleTextInterface.addSelection": ('int', 'int'),
    "PySide2.QtGui.QAccessibleTextInterface.attributes": ('int',),
    "PySide2.QtGui.QAccessibleTextInterface.characterCount": (),
    "PySide2.QtGui.QAccessibleTextInterface.characterRect": ('int',),
    "PySide2.QtGui.QAccessibleTextInterface.cursorPosition": (),
    "PySide2.QtGui.QAccessibleTextInterface.offsetAtPoint": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QAccessibleTextInterface.removeSelection": ('int',),
    "PySide2.QtGui.QAccessibleTextInterface.scrollToSubstring": ('int', 'int'),
    "PySide2.QtGui.QAccessibleTextInterface.selection": ('int',),
    "PySide2.QtGui.QAccessibleTextInterface.selectionCount": (),
    "PySide2.QtGui.QAccessibleTextInterface.setCursorPosition": ('int',),
    "PySide2.QtGui.QAccessibleTextInterface.setSelection": ('int', 'int', 'int'),
    "PySide2.QtGui.QAccessibleTextInterface.text": ('int', 'int'),
    "PySide2.QtGui.QAccessibleTextInterface.textAfterOffset": ('int', 'PySide2.QtGui.QAccessible.TextBoundaryType'),
    "PySide2.QtGui.QAccessibleTextInterface.textAtOffset": ('int', 'PySide2.QtGui.QAccessible.TextBoundaryType'),
    "PySide2.QtGui.QAccessibleTextInterface.textBeforeOffset": ('int', 'PySide2.QtGui.QAccessible.TextBoundaryType'),

# class PySide2.QtGui.QAccessibleTextRemoveEvent:
    "PySide2.QtGui.QAccessibleTextRemoveEvent.__init__": [('PySide2.QtCore.QObject', 'int', 'str'), ('PySide2.QtGui.QAccessibleInterface', 'int', 'str')],
    "PySide2.QtGui.QAccessibleTextRemoveEvent.changePosition": (),
    "PySide2.QtGui.QAccessibleTextRemoveEvent.textRemoved": (),

# class PySide2.QtGui.QAccessibleTextSelectionEvent:
    "PySide2.QtGui.QAccessibleTextSelectionEvent.__init__": [('PySide2.QtCore.QObject', 'int', 'int'), ('PySide2.QtGui.QAccessibleInterface', 'int', 'int')],
    "PySide2.QtGui.QAccessibleTextSelectionEvent.selectionEnd": (),
    "PySide2.QtGui.QAccessibleTextSelectionEvent.selectionStart": (),
    "PySide2.QtGui.QAccessibleTextSelectionEvent.setSelection": ('int', 'int'),

# class PySide2.QtGui.QAccessibleTextUpdateEvent:
    "PySide2.QtGui.QAccessibleTextUpdateEvent.__init__": [('PySide2.QtCore.QObject', 'int', 'str', 'str'), ('PySide2.QtGui.QAccessibleInterface', 'int', 'str', 'str')],
    "PySide2.QtGui.QAccessibleTextUpdateEvent.changePosition": (),
    "PySide2.QtGui.QAccessibleTextUpdateEvent.textInserted": (),
    "PySide2.QtGui.QAccessibleTextUpdateEvent.textRemoved": (),

# class PySide2.QtGui.QAccessibleValueChangeEvent:
    "PySide2.QtGui.QAccessibleValueChangeEvent.__init__": [('PySide2.QtCore.QObject', 'typing.Any'), ('PySide2.QtGui.QAccessibleInterface', 'typing.Any')],
    "PySide2.QtGui.QAccessibleValueChangeEvent.setValue": ('typing.Any',),
    "PySide2.QtGui.QAccessibleValueChangeEvent.value": (),

# class PySide2.QtGui.QAccessibleValueInterface:
    "PySide2.QtGui.QAccessibleValueInterface.__init__": (),
    "PySide2.QtGui.QAccessibleValueInterface.currentValue": (),
    "PySide2.QtGui.QAccessibleValueInterface.maximumValue": (),
    "PySide2.QtGui.QAccessibleValueInterface.minimumStepSize": (),
    "PySide2.QtGui.QAccessibleValueInterface.minimumValue": (),
    "PySide2.QtGui.QAccessibleValueInterface.setCurrentValue": ('typing.Any',),

# class PySide2.QtGui.QActionEvent:

# class PySide2.QtGui.QBackingStore:
    "PySide2.QtGui.QBackingStore.__init__": ('PySide2.QtGui.QWindow',),
    "PySide2.QtGui.QBackingStore.beginPaint": ('PySide2.QtGui.QRegion',),
    "PySide2.QtGui.QBackingStore.endPaint": (),
    "PySide2.QtGui.QBackingStore.flush": ('PySide2.QtGui.QRegion', 'PySide2.QtGui.QWindow', 'PySide2.QtCore.QPoint'),
    "PySide2.QtGui.QBackingStore.hasStaticContents": (),
    "PySide2.QtGui.QBackingStore.paintDevice": (),
    "PySide2.QtGui.QBackingStore.resize": ('PySide2.QtCore.QSize',),
    "PySide2.QtGui.QBackingStore.scroll": ('PySide2.QtGui.QRegion', 'int', 'int'),
    "PySide2.QtGui.QBackingStore.setStaticContents": ('PySide2.QtGui.QRegion',),
    "PySide2.QtGui.QBackingStore.size": (),
    "PySide2.QtGui.QBackingStore.staticContents": (),
    "PySide2.QtGui.QBackingStore.window": (),

# class PySide2.QtGui.QBitmap:
    "PySide2.QtGui.QBitmap.__init__": [(), ('PySide2.QtCore.QSize',), ('PySide2.QtGui.QBitmap',), ('PySide2.QtGui.QPixmap',), ('int', 'int'), ('str', 'bytes')],
    "PySide2.QtGui.QBitmap.__copy__": (),
    "PySide2.QtGui.QBitmap.clear": (),
    "PySide2.QtGui.QBitmap.fromData": ('PySide2.QtCore.QSize', 'bytes', 'PySide2.QtGui.QImage.Format'),
    "PySide2.QtGui.QBitmap.fromImage": ('PySide2.QtGui.QImage', 'PySide2.QtCore.Qt.ImageConversionFlags'),
    "PySide2.QtGui.QBitmap.swap": [('PySide2.QtGui.QBitmap',), ('PySide2.QtGui.QPixmap',)],
    "PySide2.QtGui.QBitmap.transformed": [('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QMatrix', 'PySide2.QtCore.Qt.TransformationMode'), ('PySide2.QtGui.QTransform',)],

# class PySide2.QtGui.QBrush:
    "PySide2.QtGui.QBrush.__init__": [(), ('PySide2.QtCore.Qt.BrushStyle',), ('PySide2.QtCore.Qt.GlobalColor', 'PySide2.QtCore.Qt.BrushStyle'), ('PySide2.QtCore.Qt.GlobalColor', 'PySide2.QtGui.QPixmap'), ('PySide2.QtGui.QBrush',), ('PySide2.QtGui.QColor', 'PySide2.QtCore.Qt.BrushStyle'), ('PySide2.QtGui.QColor', 'PySide2.QtGui.QPixmap'), ('PySide2.QtGui.QGradient',), ('PySide2.QtGui.QImage',), ('PySide2.QtGui.QPixmap',)],
    "PySide2.QtGui.QBrush.__copy__": (),
    "PySide2.QtGui.QBrush.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QBrush.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QBrush.color": (),
    "PySide2.QtGui.QBrush.gradient": (),
    "PySide2.QtGui.QBrush.isOpaque": (),
    "PySide2.QtGui.QBrush.matrix": (),
    "PySide2.QtGui.QBrush.setColor": [('PySide2.QtCore.Qt.GlobalColor',), ('PySide2.QtGui.QColor',)],
    "PySide2.QtGui.QBrush.setMatrix": ('PySide2.QtGui.QMatrix',),
    "PySide2.QtGui.QBrush.setStyle": ('PySide2.QtCore.Qt.BrushStyle',),
    "PySide2.QtGui.QBrush.setTexture": ('PySide2.QtGui.QPixmap',),
    "PySide2.QtGui.QBrush.setTextureImage": ('PySide2.QtGui.QImage',),
    "PySide2.QtGui.QBrush.setTransform": ('PySide2.QtGui.QTransform',),
    "PySide2.QtGui.QBrush.style": (),
    "PySide2.QtGui.QBrush.swap": ('PySide2.QtGui.QBrush',),
    "PySide2.QtGui.QBrush.texture": (),
    "PySide2.QtGui.QBrush.textureImage": (),
    "PySide2.QtGui.QBrush.transform": (),

# class PySide2.QtGui.QClipboard:

# class PySide2.QtGui.QClipboard.Mode:
    "PySide2.QtGui.QClipboard.clear": ('PySide2.QtGui.QClipboard.Mode',),
    "PySide2.QtGui.QClipboard.image": ('PySide2.QtGui.QClipboard.Mode',),
    "PySide2.QtGui.QClipboard.mimeData": ('PySide2.QtGui.QClipboard.Mode',),
    "PySide2.QtGui.QClipboard.ownsClipboard": (),
    "PySide2.QtGui.QClipboard.ownsFindBuffer": (),
    "PySide2.QtGui.QClipboard.ownsSelection": (),
    "PySide2.QtGui.QClipboard.pixmap": ('PySide2.QtGui.QClipboard.Mode',),
    "PySide2.QtGui.QClipboard.setImage": ('PySide2.QtGui.QImage', 'PySide2.QtGui.QClipboard.Mode'),
    "PySide2.QtGui.QClipboard.setMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtGui.QClipboard.Mode'),
    "PySide2.QtGui.QClipboard.setPixmap": ('PySide2.QtGui.QPixmap', 'PySide2.QtGui.QClipboard.Mode'),
    "PySide2.QtGui.QClipboard.setText": ('str', 'PySide2.QtGui.QClipboard.Mode'),
    "PySide2.QtGui.QClipboard.supportsFindBuffer": (),
    "PySide2.QtGui.QClipboard.supportsSelection": (),
    "PySide2.QtGui.QClipboard.text": [('PySide2.QtGui.QClipboard.Mode',), ('str', 'PySide2.QtGui.QClipboard.Mode')],

# class PySide2.QtGui.QCloseEvent:
    "PySide2.QtGui.QCloseEvent.__init__": (),

# class PySide2.QtGui.QColor:

# class PySide2.QtGui.QColor.NameFormat:

# class PySide2.QtGui.QColor.Spec:
    "PySide2.QtGui.QColor.__init__": [(), ('PySide2.QtCore.Qt.GlobalColor',), ('PySide2.QtGui.QColor',), ('int',), ('int', 'int', 'int', 'int'), ('str',), ('typing.Any',)],
    "PySide2.QtGui.QColor.__copy__": (),
    "PySide2.QtGui.QColor.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QColor.__reduce__": (),
    "PySide2.QtGui.QColor.__repr__": (),
    "PySide2.QtGui.QColor.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QColor.__setstate__": ('object',),
    "PySide2.QtGui.QColor.__str__": (),
    "PySide2.QtGui.QColor.alpha": (),
    "PySide2.QtGui.QColor.alphaF": (),
    "PySide2.QtGui.QColor.black": (),
    "PySide2.QtGui.QColor.blackF": (),
    "PySide2.QtGui.QColor.blue": (),
    "PySide2.QtGui.QColor.blueF": (),
    "PySide2.QtGui.QColor.colorNames": (),
    "PySide2.QtGui.QColor.convertTo": ('PySide2.QtGui.QColor.Spec',),
    "PySide2.QtGui.QColor.cyan": (),
    "PySide2.QtGui.QColor.cyanF": (),
    "PySide2.QtGui.QColor.dark": ('int',),
    "PySide2.QtGui.QColor.darker": ('int',),
    "PySide2.QtGui.QColor.fromCmyk": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QColor.fromCmykF": ('float', 'float', 'float', 'float', 'float'),
    "PySide2.QtGui.QColor.fromHsl": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QColor.fromHslF": ('float', 'float', 'float', 'float'),
    "PySide2.QtGui.QColor.fromHsv": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QColor.fromHsvF": ('float', 'float', 'float', 'float'),
    "PySide2.QtGui.QColor.fromRgb": [('int',), ('int', 'int', 'int', 'int')],
    "PySide2.QtGui.QColor.fromRgbF": ('float', 'float', 'float', 'float'),
    "PySide2.QtGui.QColor.fromRgba": ('int',),
    "PySide2.QtGui.QColor.fromRgba64": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QColor.getCmyk": (),
    "PySide2.QtGui.QColor.getCmykF": (),
    "PySide2.QtGui.QColor.getHsl": (),
    "PySide2.QtGui.QColor.getHslF": (),
    "PySide2.QtGui.QColor.getHsv": (),
    "PySide2.QtGui.QColor.getHsvF": (),
    "PySide2.QtGui.QColor.getRgb": (),
    "PySide2.QtGui.QColor.getRgbF": (),
    "PySide2.QtGui.QColor.green": (),
    "PySide2.QtGui.QColor.greenF": (),
    "PySide2.QtGui.QColor.hslHue": (),
    "PySide2.QtGui.QColor.hslHueF": (),
    "PySide2.QtGui.QColor.hslSaturation": (),
    "PySide2.QtGui.QColor.hslSaturationF": (),
    "PySide2.QtGui.QColor.hsvHue": (),
    "PySide2.QtGui.QColor.hsvHueF": (),
    "PySide2.QtGui.QColor.hsvSaturation": (),
    "PySide2.QtGui.QColor.hsvSaturationF": (),
    "PySide2.QtGui.QColor.hue": (),
    "PySide2.QtGui.QColor.hueF": (),
    "PySide2.QtGui.QColor.isValid": (),
    "PySide2.QtGui.QColor.isValidColor": ('str',),
    "PySide2.QtGui.QColor.light": ('int',),
    "PySide2.QtGui.QColor.lighter": ('int',),
    "PySide2.QtGui.QColor.lightness": (),
    "PySide2.QtGui.QColor.lightnessF": (),
    "PySide2.QtGui.QColor.magenta": (),
    "PySide2.QtGui.QColor.magentaF": (),
    "PySide2.QtGui.QColor.name": [(), ('PySide2.QtGui.QColor.NameFormat',)],
    "PySide2.QtGui.QColor.red": (),
    "PySide2.QtGui.QColor.redF": (),
    "PySide2.QtGui.QColor.rgb": (),
    "PySide2.QtGui.QColor.rgba": (),
    "PySide2.QtGui.QColor.saturation": (),
    "PySide2.QtGui.QColor.saturationF": (),
    "PySide2.QtGui.QColor.setAlpha": ('int',),
    "PySide2.QtGui.QColor.setAlphaF": ('float',),
    "PySide2.QtGui.QColor.setBlue": ('int',),
    "PySide2.QtGui.QColor.setBlueF": ('float',),
    "PySide2.QtGui.QColor.setCmyk": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QColor.setCmykF": ('float', 'float', 'float', 'float', 'float'),
    "PySide2.QtGui.QColor.setGreen": ('int',),
    "PySide2.QtGui.QColor.setGreenF": ('float',),
    "PySide2.QtGui.QColor.setHsl": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QColor.setHslF": ('float', 'float', 'float', 'float'),
    "PySide2.QtGui.QColor.setHsv": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QColor.setHsvF": ('float', 'float', 'float', 'float'),
    "PySide2.QtGui.QColor.setNamedColor": ('str',),
    "PySide2.QtGui.QColor.setRed": ('int',),
    "PySide2.QtGui.QColor.setRedF": ('float',),
    "PySide2.QtGui.QColor.setRgb": [('int',), ('int', 'int', 'int', 'int')],
    "PySide2.QtGui.QColor.setRgbF": ('float', 'float', 'float', 'float'),
    "PySide2.QtGui.QColor.setRgba": ('int',),
    "PySide2.QtGui.QColor.spec": (),
    "PySide2.QtGui.QColor.toCmyk": (),
    "PySide2.QtGui.QColor.toExtendedRgb": (),
    "PySide2.QtGui.QColor.toHsl": (),
    "PySide2.QtGui.QColor.toHsv": (),
    "PySide2.QtGui.QColor.toRgb": (),
    "PySide2.QtGui.QColor.toTuple": (),
    "PySide2.QtGui.QColor.value": (),
    "PySide2.QtGui.QColor.valueF": (),
    "PySide2.QtGui.QColor.yellow": (),
    "PySide2.QtGui.QColor.yellowF": (),

# class PySide2.QtGui.QColorSpace:

# class PySide2.QtGui.QColorSpace.NamedColorSpace:

# class PySide2.QtGui.QColorSpace.Primaries:

# class PySide2.QtGui.QColorSpace.TransferFunction:
    "PySide2.QtGui.QColorSpace.__init__": [(), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtGui.QColorSpace.TransferFunction', 'float'), ('PySide2.QtGui.QColorSpace',), ('PySide2.QtGui.QColorSpace.NamedColorSpace',), ('PySide2.QtGui.QColorSpace.Primaries', 'PySide2.QtGui.QColorSpace.TransferFunction', 'float'), ('PySide2.QtGui.QColorSpace.Primaries', 'float')],
    "PySide2.QtGui.QColorSpace.__copy__": (),
    "PySide2.QtGui.QColorSpace.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QColorSpace.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QColorSpace.fromIccProfile": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtGui.QColorSpace.gamma": (),
    "PySide2.QtGui.QColorSpace.iccProfile": (),
    "PySide2.QtGui.QColorSpace.isValid": (),
    "PySide2.QtGui.QColorSpace.primaries": (),
    "PySide2.QtGui.QColorSpace.setPrimaries": [('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'), ('PySide2.QtGui.QColorSpace.Primaries',)],
    "PySide2.QtGui.QColorSpace.setTransferFunction": ('PySide2.QtGui.QColorSpace.TransferFunction', 'float'),
    "PySide2.QtGui.QColorSpace.swap": ('PySide2.QtGui.QColorSpace',),
    "PySide2.QtGui.QColorSpace.transferFunction": (),
    "PySide2.QtGui.QColorSpace.withTransferFunction": ('PySide2.QtGui.QColorSpace.TransferFunction', 'float'),

# class PySide2.QtGui.QConicalGradient:
    "PySide2.QtGui.QConicalGradient.__init__": [(), ('PySide2.QtCore.QPointF', 'float'), ('PySide2.QtGui.QConicalGradient',), ('float', 'float', 'float')],
    "PySide2.QtGui.QConicalGradient.__copy__": (),
    "PySide2.QtGui.QConicalGradient.angle": (),
    "PySide2.QtGui.QConicalGradient.center": (),
    "PySide2.QtGui.QConicalGradient.setAngle": ('float',),
    "PySide2.QtGui.QConicalGradient.setCenter": [('PySide2.QtCore.QPointF',), ('float', 'float')],

# class PySide2.QtGui.QContextMenuEvent:

# class PySide2.QtGui.QContextMenuEvent.Reason:
    "PySide2.QtGui.QContextMenuEvent.__init__": [('PySide2.QtGui.QContextMenuEvent.Reason', 'PySide2.QtCore.QPoint'), ('PySide2.QtGui.QContextMenuEvent.Reason', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint'), ('PySide2.QtGui.QContextMenuEvent.Reason', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.Qt.KeyboardModifiers')],
    "PySide2.QtGui.QContextMenuEvent.globalPos": (),
    "PySide2.QtGui.QContextMenuEvent.globalX": (),
    "PySide2.QtGui.QContextMenuEvent.global""Y": (),
    "PySide2.QtGui.QContextMenuEvent.pos": (),
    "PySide2.QtGui.QContextMenuEvent.reason": (),
    "PySide2.QtGui.QContextMenuEvent.x": (),
    "PySide2.QtGui.QContextMenuEvent.y": (),

# class PySide2.QtGui.QCursor:
    "PySide2.QtGui.QCursor.__init__": [(), ('PySide2.QtCore.Qt.CursorShape',), ('PySide2.QtGui.QBitmap', 'PySide2.QtGui.QBitmap', 'int', 'int'), ('PySide2.QtGui.QCursor',), ('PySide2.QtGui.QPixmap', 'int', 'int')],
    "PySide2.QtGui.QCursor.__copy__": (),
    "PySide2.QtGui.QCursor.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QCursor.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QCursor.bitmap": (),
    "PySide2.QtGui.QCursor.hotSpot": (),
    "PySide2.QtGui.QCursor.mask": (),
    "PySide2.QtGui.QCursor.pixmap": (),
    "PySide2.QtGui.QCursor.pos": [(), ('PySide2.QtGui.QScreen',)],
    "PySide2.QtGui.QCursor.setPos": [('PySide2.QtCore.QPoint',), ('PySide2.QtGui.QScreen', 'PySide2.QtCore.QPoint'), ('PySide2.QtGui.QScreen', 'int', 'int'), ('int', 'int')],
    "PySide2.QtGui.QCursor.setShape": ('PySide2.QtCore.Qt.CursorShape',),
    "PySide2.QtGui.QCursor.shape": (),
    "PySide2.QtGui.QCursor.swap": ('PySide2.QtGui.QCursor',),

# class PySide2.QtGui.QDesktopServices:
    "PySide2.QtGui.QDesktopServices.__init__": (),
    "PySide2.QtGui.QDesktopServices.openUrl": ('PySide2.QtCore.QUrl',),
    "PySide2.QtGui.QDesktopServices.setUrlHandler": ('str', 'PySide2.QtCore.QObject', 'bytes'),
    "PySide2.QtGui.QDesktopServices.unsetUrlHandler": ('str',),

# class PySide2.QtGui.QDoubleValidator:

# class PySide2.QtGui.QDoubleValidator.Notation:
    "PySide2.QtGui.QDoubleValidator.__init__": [('PySide2.QtCore.QObject',), ('float', 'float', 'int', 'PySide2.QtCore.QObject')],
    "PySide2.QtGui.QDoubleValidator.bottom": (),
    "PySide2.QtGui.QDoubleValidator.decimals": (),
    "PySide2.QtGui.QDoubleValidator.notation": (),
    "PySide2.QtGui.QDoubleValidator.setBottom": ('float',),
    "PySide2.QtGui.QDoubleValidator.setDecimals": ('int',),
    "PySide2.QtGui.QDoubleValidator.setNotation": ('PySide2.QtGui.QDoubleValidator.Notation',),
    "PySide2.QtGui.QDoubleValidator.setRange": ('float', 'float', 'int'),
    "PySide2.QtGui.QDoubleValidator.setTop": ('float',),
    "PySide2.QtGui.QDoubleValidator.top": (),
    "PySide2.QtGui.QDoubleValidator.validate": ('str', 'int'),

# class PySide2.QtGui.QDrag:
    "PySide2.QtGui.QDrag.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtGui.QDrag.cancel": (),
    "PySide2.QtGui.QDrag.defaultAction": (),
    "PySide2.QtGui.QDrag.dragCursor": ('PySide2.QtCore.Qt.DropAction',),
    "PySide2.QtGui.QDrag.exec_": [('PySide2.QtCore.Qt.DropActions',), ('PySide2.QtCore.Qt.DropActions', 'PySide2.QtCore.Qt.DropAction')],
    "PySide2.QtGui.QDrag.hotSpot": (),
    "PySide2.QtGui.QDrag.mimeData": (),
    "PySide2.QtGui.QDrag.pixmap": (),
    "PySide2.QtGui.QDrag.setDragCursor": ('PySide2.QtGui.QPixmap', 'PySide2.QtCore.Qt.DropAction'),
    "PySide2.QtGui.QDrag.setHotSpot": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QDrag.setMimeData": ('PySide2.QtCore.QMimeData',),
    "PySide2.QtGui.QDrag.setPixmap": ('PySide2.QtGui.QPixmap',),
    "PySide2.QtGui.QDrag.source": (),
    "PySide2.QtGui.QDrag.start": ('PySide2.QtCore.Qt.DropActions',),
    "PySide2.QtGui.QDrag.supportedActions": (),
    "PySide2.QtGui.QDrag.target": (),

# class PySide2.QtGui.QDragEnterEvent:
    "PySide2.QtGui.QDragEnterEvent.__init__": ('PySide2.QtCore.QPoint', 'PySide2.QtCore.Qt.DropActions', 'PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers'),

# class PySide2.QtGui.QDragLeaveEvent:
    "PySide2.QtGui.QDragLeaveEvent.__init__": (),

# class PySide2.QtGui.QDragMoveEvent:
    "PySide2.QtGui.QDragMoveEvent.__init__": ('PySide2.QtCore.QPoint', 'PySide2.QtCore.Qt.DropActions', 'PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.QEvent.Type'),
    "PySide2.QtGui.QDragMoveEvent.accept": [(), ('PySide2.QtCore.QRect',)],
    "PySide2.QtGui.QDragMoveEvent.answerRect": (),
    "PySide2.QtGui.QDragMoveEvent.ignore": [(), ('PySide2.QtCore.QRect',)],

# class PySide2.QtGui.QDropEvent:
    "PySide2.QtGui.QDropEvent.__init__": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.DropActions', 'PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.QEvent.Type'),
    "PySide2.QtGui.QDropEvent.acceptProposedAction": (),
    "PySide2.QtGui.QDropEvent.dropAction": (),
    "PySide2.QtGui.QDropEvent.keyboardModifiers": (),
    "PySide2.QtGui.QDropEvent.mimeData": (),
    "PySide2.QtGui.QDropEvent.mouseButtons": (),
    "PySide2.QtGui.QDropEvent.pos": (),
    "PySide2.QtGui.QDropEvent.posF": (),
    "PySide2.QtGui.QDropEvent.possibleActions": (),
    "PySide2.QtGui.QDropEvent.proposedAction": (),
    "PySide2.QtGui.QDropEvent.setDropAction": ('PySide2.QtCore.Qt.DropAction',),
    "PySide2.QtGui.QDropEvent.source": (),

# class PySide2.QtGui.QEnterEvent:
    "PySide2.QtGui.QEnterEvent.__init__": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'),
    "PySide2.QtGui.QEnterEvent.globalPos": (),
    "PySide2.QtGui.QEnterEvent.globalX": (),
    "PySide2.QtGui.QEnterEvent.global""Y": (),
    "PySide2.QtGui.QEnterEvent.localPos": (),
    "PySide2.QtGui.QEnterEvent.pos": (),
    "PySide2.QtGui.QEnterEvent.screenPos": (),
    "PySide2.QtGui.QEnterEvent.windowPos": (),
    "PySide2.QtGui.QEnterEvent.x": (),
    "PySide2.QtGui.QEnterEvent.y": (),

# class PySide2.QtGui.QExposeEvent:
    "PySide2.QtGui.QExposeEvent.__init__": ('PySide2.QtGui.QRegion',),
    "PySide2.QtGui.QExposeEvent.region": (),

# class PySide2.QtGui.QFileOpenEvent:
    "PySide2.QtGui.QFileOpenEvent.__init__": [('PySide2.QtCore.QUrl',), ('str',)],
    "PySide2.QtGui.QFileOpenEvent.file": (),
    "PySide2.QtGui.QFileOpenEvent.openFile": ('PySide2.QtCore.QFile', 'PySide2.QtCore.QIODevice.OpenMode'),
    "PySide2.QtGui.QFileOpenEvent.url": (),

# class PySide2.QtGui.QFocusEvent:
    "PySide2.QtGui.QFocusEvent.__init__": ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.Qt.FocusReason'),
    "PySide2.QtGui.QFocusEvent.gotFocus": (),
    "PySide2.QtGui.QFocusEvent.lostFocus": (),
    "PySide2.QtGui.QFocusEvent.reason": (),

# class PySide2.QtGui.QFont:

# class PySide2.QtGui.QFont.Capitalization:

# class PySide2.QtGui.QFont.HintingPreference:

# class PySide2.QtGui.QFont.SpacingType:

# class PySide2.QtGui.QFont.Stretch:

# class PySide2.QtGui.QFont.Style:

# class PySide2.QtGui.QFont.StyleHint:

# class PySide2.QtGui.QFont.StyleStrategy:

# class PySide2.QtGui.QFont.Weight:
    "PySide2.QtGui.QFont.__init__": [(), ('PySide2.QtGui.QFont',), ('PySide2.QtGui.QFont', 'PySide2.QtGui.QPaintDevice'), ('str', 'int', 'int', 'bool')],
    "PySide2.QtGui.QFont.__copy__": (),
    "PySide2.QtGui.QFont.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QFont.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QFont.bold": (),
    "PySide2.QtGui.QFont.cacheStatistics": (),
    "PySide2.QtGui.QFont.capitalization": (),
    "PySide2.QtGui.QFont.cleanup": (),
    "PySide2.QtGui.QFont.defaultFamily": (),
    "PySide2.QtGui.QFont.exactMatch": (),
    "PySide2.QtGui.QFont.families": (),
    "PySide2.QtGui.QFont.family": (),
    "PySide2.QtGui.QFont.fixedPitch": (),
    "PySide2.QtGui.QFont.fromString": ('str',),
    "PySide2.QtGui.QFont.hintingPreference": (),
    "PySide2.QtGui.QFont.initialize": (),
    "PySide2.QtGui.QFont.insertSubstitution": ('str', 'str'),
    "PySide2.QtGui.QFont.insertSubstitutions": ('str', 'typing.Sequence'),
    "PySide2.QtGui.QFont.isCopyOf": ('PySide2.QtGui.QFont',),
    "PySide2.QtGui.QFont.italic": (),
    "PySide2.QtGui.QFont.kerning": (),
    "PySide2.QtGui.QFont.key": (),
    "PySide2.QtGui.QFont.lastResortFamily": (),
    "PySide2.QtGui.QFont.lastResortFont": (),
    "PySide2.QtGui.QFont.letterSpacing": (),
    "PySide2.QtGui.QFont.letterSpacingType": (),
    "PySide2.QtGui.QFont.overline": (),
    "PySide2.QtGui.QFont.pixelSize": (),
    "PySide2.QtGui.QFont.pointSize": (),
    "PySide2.QtGui.QFont.pointSizeF": (),
    "PySide2.QtGui.QFont.rawMode": (),
    "PySide2.QtGui.QFont.rawName": (),
    "PySide2.QtGui.QFont.removeSubstitutions": ('str',),
    "PySide2.QtGui.QFont.resolve": [(), ('PySide2.QtGui.QFont',), ('int',)],
    "PySide2.QtGui.QFont.setBold": ('bool',),
    "PySide2.QtGui.QFont.setCapitalization": ('PySide2.QtGui.QFont.Capitalization',),
    "PySide2.QtGui.QFont.setFamilies": ('typing.Sequence',),
    "PySide2.QtGui.QFont.setFamily": ('str',),
    "PySide2.QtGui.QFont.setFixedPitch": ('bool',),
    "PySide2.QtGui.QFont.setHintingPreference": ('PySide2.QtGui.QFont.HintingPreference',),
    "PySide2.QtGui.QFont.setItalic": ('bool',),
    "PySide2.QtGui.QFont.setKerning": ('bool',),
    "PySide2.QtGui.QFont.setLetterSpacing": ('PySide2.QtGui.QFont.SpacingType', 'float'),
    "PySide2.QtGui.QFont.setOverline": ('bool',),
    "PySide2.QtGui.QFont.setPixelSize": ('int',),
    "PySide2.QtGui.QFont.setPointSize": ('int',),
    "PySide2.QtGui.QFont.setPointSizeF": ('float',),
    "PySide2.QtGui.QFont.setRawMode": ('bool',),
    "PySide2.QtGui.QFont.setRawName": ('str',),
    "PySide2.QtGui.QFont.setStretch": ('int',),
    "PySide2.QtGui.QFont.setStrikeOut": ('bool',),
    "PySide2.QtGui.QFont.setStyle": ('PySide2.QtGui.QFont.Style',),
    "PySide2.QtGui.QFont.setStyleHint": ('PySide2.QtGui.QFont.StyleHint', 'PySide2.QtGui.QFont.StyleStrategy'),
    "PySide2.QtGui.QFont.setStyleName": ('str',),
    "PySide2.QtGui.QFont.setStyleStrategy": ('PySide2.QtGui.QFont.StyleStrategy',),
    "PySide2.QtGui.QFont.setUnderline": ('bool',),
    "PySide2.QtGui.QFont.setWeight": ('int',),
    "PySide2.QtGui.QFont.setWordSpacing": ('float',),
    "PySide2.QtGui.QFont.stretch": (),
    "PySide2.QtGui.QFont.strikeOut": (),
    "PySide2.QtGui.QFont.style": (),
    "PySide2.QtGui.QFont.styleHint": (),
    "PySide2.QtGui.QFont.styleName": (),
    "PySide2.QtGui.QFont.styleStrategy": (),
    "PySide2.QtGui.QFont.substitute": ('str',),
    "PySide2.QtGui.QFont.substitutes": ('str',),
    "PySide2.QtGui.QFont.substitutions": (),
    "PySide2.QtGui.QFont.swap": ('PySide2.QtGui.QFont',),
    "PySide2.QtGui.QFont.toString": (),
    "PySide2.QtGui.QFont.underline": (),
    "PySide2.QtGui.QFont.weight": (),
    "PySide2.QtGui.QFont.wordSpacing": (),

# class PySide2.QtGui.QFontDatabase:

# class PySide2.QtGui.QFontDatabase.SystemFont:

# class PySide2.QtGui.QFontDatabase.WritingSystem:
    "PySide2.QtGui.QFontDatabase.__init__": [(), ('PySide2.QtGui.QFontDatabase',)],
    "PySide2.QtGui.QFontDatabase.__copy__": (),
    "PySide2.QtGui.QFontDatabase.addApplicationFont": ('str',),
    "PySide2.QtGui.QFontDatabase.addApplicationFontFromData": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtGui.QFontDatabase.applicationFontFamilies": ('int',),
    "PySide2.QtGui.QFontDatabase.bold": ('str', 'str'),
    "PySide2.QtGui.QFontDatabase.families": ('PySide2.QtGui.QFontDatabase.WritingSystem',),
    "PySide2.QtGui.QFontDatabase.font": ('str', 'str', 'int'),
    "PySide2.QtGui.QFontDatabase.hasFamily": ('str',),
    "PySide2.QtGui.QFontDatabase.isBitmapScalable": ('str', 'str'),
    "PySide2.QtGui.QFontDatabase.isFixedPitch": ('str', 'str'),
    "PySide2.QtGui.QFontDatabase.isPrivateFamily": ('str',),
    "PySide2.QtGui.QFontDatabase.isScalable": ('str', 'str'),
    "PySide2.QtGui.QFontDatabase.isSmoothlyScalable": ('str', 'str'),
    "PySide2.QtGui.QFontDatabase.italic": ('str', 'str'),
    "PySide2.QtGui.QFontDatabase.pointSizes": ('str', 'str'),
    "PySide2.QtGui.QFontDatabase.removeAllApplicationFonts": (),
    "PySide2.QtGui.QFontDatabase.removeApplicationFont": ('int',),
    "PySide2.QtGui.QFontDatabase.smoothSizes": ('str', 'str'),
    "PySide2.QtGui.QFontDatabase.standardSizes": (),
    "PySide2.QtGui.QFontDatabase.styleString": [('PySide2.QtGui.QFont',), ('PySide2.QtGui.QFontInfo',)],
    "PySide2.QtGui.QFontDatabase.styles": ('str',),
    "PySide2.QtGui.QFontDatabase.supportsThreadedFontRendering": (),
    "PySide2.QtGui.QFontDatabase.systemFont": ('PySide2.QtGui.QFontDatabase.SystemFont',),
    "PySide2.QtGui.QFontDatabase.weight": ('str', 'str'),
    "PySide2.QtGui.QFontDatabase.writingSystemName": ('PySide2.QtGui.QFontDatabase.WritingSystem',),
    "PySide2.QtGui.QFontDatabase.writingSystemSample": ('PySide2.QtGui.QFontDatabase.WritingSystem',),
    "PySide2.QtGui.QFontDatabase.writingSystems": [(), ('str',)],

# class PySide2.QtGui.QFontInfo:
    "PySide2.QtGui.QFontInfo.__init__": [('PySide2.QtGui.QFont',), ('PySide2.QtGui.QFontInfo',)],
    "PySide2.QtGui.QFontInfo.__copy__": (),
    "PySide2.QtGui.QFontInfo.bold": (),
    "PySide2.QtGui.QFontInfo.exactMatch": (),
    "PySide2.QtGui.QFontInfo.family": (),
    "PySide2.QtGui.QFontInfo.fixedPitch": (),
    "PySide2.QtGui.QFontInfo.italic": (),
    "PySide2.QtGui.QFontInfo.overline": (),
    "PySide2.QtGui.QFontInfo.pixelSize": (),
    "PySide2.QtGui.QFontInfo.pointSize": (),
    "PySide2.QtGui.QFontInfo.pointSizeF": (),
    "PySide2.QtGui.QFontInfo.rawMode": (),
    "PySide2.QtGui.QFontInfo.strikeOut": (),
    "PySide2.QtGui.QFontInfo.style": (),
    "PySide2.QtGui.QFontInfo.styleHint": (),
    "PySide2.QtGui.QFontInfo.styleName": (),
    "PySide2.QtGui.QFontInfo.swap": ('PySide2.QtGui.QFontInfo',),
    "PySide2.QtGui.QFontInfo.underline": (),
    "PySide2.QtGui.QFontInfo.weight": (),

# class PySide2.QtGui.QFontMetrics:
    "PySide2.QtGui.QFontMetrics.__init__": [('PySide2.QtGui.QFont',), ('PySide2.QtGui.QFont', 'PySide2.QtGui.QPaintDevice'), ('PySide2.QtGui.QFontMetrics',)],
    "PySide2.QtGui.QFontMetrics.__copy__": (),
    "PySide2.QtGui.QFontMetrics.ascent": (),
    "PySide2.QtGui.QFontMetrics.averageCharWidth": (),
    "PySide2.QtGui.QFontMetrics.boundingRect": [('PySide2.QtCore.QRect', 'int', 'str', 'int', 'typing.Sequence'), ('int', 'int', 'int', 'int', 'int', 'str', 'int', 'typing.Sequence'), ('str',)],
    "PySide2.QtGui.QFontMetrics.boundingRectChar": ('typing.Char',),
    "PySide2.QtGui.QFontMetrics.capHeight": (),
    "PySide2.QtGui.QFontMetrics.charWidth": ('str', 'int'),
    "PySide2.QtGui.QFontMetrics.descent": (),
    "PySide2.QtGui.QFontMetrics.elidedText": ('str', 'PySide2.QtCore.Qt.TextElideMode', 'int', 'int'),
    "PySide2.QtGui.QFontMetrics.fontDpi": (),
    "PySide2.QtGui.QFontMetrics.height": (),
    "PySide2.QtGui.QFontMetrics.horizontalAdvance": [('str', 'int'), ('typing.Char',)],
    "PySide2.QtGui.QFontMetrics.inFont": ('typing.Char',),
    "PySide2.QtGui.QFontMetrics.inFontUcs4": ('int',),
    "PySide2.QtGui.QFontMetrics.leading": (),
    "PySide2.QtGui.QFontMetrics.leftBearing": ('typing.Char',),
    "PySide2.QtGui.QFontMetrics.lineSpacing": (),
    "PySide2.QtGui.QFontMetrics.lineWidth": (),
    "PySide2.QtGui.QFontMetrics.maxWidth": (),
    "PySide2.QtGui.QFontMetrics.minLeftBearing": (),
    "PySide2.QtGui.QFontMetrics.minRightBearing": (),
    "PySide2.QtGui.QFontMetrics.overlinePos": (),
    "PySide2.QtGui.QFontMetrics.rightBearing": ('typing.Char',),
    "PySide2.QtGui.QFontMetrics.size": ('int', 'str', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QFontMetrics.strikeOutPos": (),
    "PySide2.QtGui.QFontMetrics.swap": ('PySide2.QtGui.QFontMetrics',),
    "PySide2.QtGui.QFontMetrics.tightBoundingRect": ('str',),
    "PySide2.QtGui.QFontMetrics.underlinePos": (),
    "PySide2.QtGui.QFontMetrics.width": [('str', 'int'), ('str', 'int', 'int')],
    "PySide2.QtGui.QFontMetrics.widthChar": ('typing.Char',),
    "PySide2.QtGui.QFontMetrics.xHeight": (),

# class PySide2.QtGui.QFontMetricsF:
    "PySide2.QtGui.QFontMetricsF.__init__": [('PySide2.QtGui.QFont',), ('PySide2.QtGui.QFont', 'PySide2.QtGui.QPaintDevice'), ('PySide2.QtGui.QFontMetrics',), ('PySide2.QtGui.QFontMetricsF',)],
    "PySide2.QtGui.QFontMetricsF.__copy__": (),
    "PySide2.QtGui.QFontMetricsF.ascent": (),
    "PySide2.QtGui.QFontMetricsF.averageCharWidth": (),
    "PySide2.QtGui.QFontMetricsF.boundingRect": [('PySide2.QtCore.QRectF', 'int', 'str', 'int', 'typing.Sequence'), ('str',)],
    "PySide2.QtGui.QFontMetricsF.boundingRectChar": ('typing.Char',),
    "PySide2.QtGui.QFontMetricsF.capHeight": (),
    "PySide2.QtGui.QFontMetricsF.descent": (),
    "PySide2.QtGui.QFontMetricsF.elidedText": ('str', 'PySide2.QtCore.Qt.TextElideMode', 'float', 'int'),
    "PySide2.QtGui.QFontMetricsF.fontDpi": (),
    "PySide2.QtGui.QFontMetricsF.height": (),
    "PySide2.QtGui.QFontMetricsF.horizontalAdvance": [('str', 'int'), ('typing.Char',)],
    "PySide2.QtGui.QFontMetricsF.inFont": ('typing.Char',),
    "PySide2.QtGui.QFontMetricsF.inFontUcs4": ('int',),
    "PySide2.QtGui.QFontMetricsF.leading": (),
    "PySide2.QtGui.QFontMetricsF.leftBearing": ('typing.Char',),
    "PySide2.QtGui.QFontMetricsF.lineSpacing": (),
    "PySide2.QtGui.QFontMetricsF.lineWidth": (),
    "PySide2.QtGui.QFontMetricsF.maxWidth": (),
    "PySide2.QtGui.QFontMetricsF.minLeftBearing": (),
    "PySide2.QtGui.QFontMetricsF.minRightBearing": (),
    "PySide2.QtGui.QFontMetricsF.overlinePos": (),
    "PySide2.QtGui.QFontMetricsF.rightBearing": ('typing.Char',),
    "PySide2.QtGui.QFontMetricsF.size": ('int', 'str', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QFontMetricsF.strikeOutPos": (),
    "PySide2.QtGui.QFontMetricsF.swap": ('PySide2.QtGui.QFontMetricsF',),
    "PySide2.QtGui.QFontMetricsF.tightBoundingRect": ('str',),
    "PySide2.QtGui.QFontMetricsF.underlinePos": (),
    "PySide2.QtGui.QFontMetricsF.width": ('str',),
    "PySide2.QtGui.QFontMetricsF.widthChar": ('typing.Char',),
    "PySide2.QtGui.QFontMetricsF.xHeight": (),

# class PySide2.QtGui.QGradient:

# class PySide2.QtGui.QGradient.CoordinateMode:

# class PySide2.QtGui.QGradient.InterpolationMode:

# class PySide2.QtGui.QGradient.Preset:

# class PySide2.QtGui.QGradient.Spread:

# class PySide2.QtGui.QGradient.Type:
    "PySide2.QtGui.QGradient.__init__": [(), ('PySide2.QtGui.QGradient',), ('PySide2.QtGui.QGradient.Preset',)],
    "PySide2.QtGui.QGradient.__copy__": (),
    "PySide2.QtGui.QGradient.coordinateMode": (),
    "PySide2.QtGui.QGradient.interpolationMode": (),
    "PySide2.QtGui.QGradient.setColorAt": ('float', 'PySide2.QtGui.QColor'),
    "PySide2.QtGui.QGradient.setCoordinateMode": ('PySide2.QtGui.QGradient.CoordinateMode',),
    "PySide2.QtGui.QGradient.setInterpolationMode": ('PySide2.QtGui.QGradient.InterpolationMode',),
    "PySide2.QtGui.QGradient.setSpread": ('PySide2.QtGui.QGradient.Spread',),
    "PySide2.QtGui.QGradient.setStops": ('typing.List',),
    "PySide2.QtGui.QGradient.spread": (),
    "PySide2.QtGui.QGradient.stops": (),
    "PySide2.QtGui.QGradient.type": (),

# class PySide2.QtGui.QGuiApplication:
    "PySide2.QtGui.QGuiApplication.__init__": [(), ('typing.Sequence',)],
    "PySide2.QtGui.QGuiApplication.allWindows": (),
    "PySide2.QtGui.QGuiApplication.applicationDisplayName": (),
    "PySide2.QtGui.QGuiApplication.applicationState": (),
    "PySide2.QtGui.QGuiApplication.changeOverrideCursor": ('PySide2.QtGui.QCursor',),
    "PySide2.QtGui.QGuiApplication.clipboard": (),
    "PySide2.QtGui.QGuiApplication.desktopFileName": (),
    "PySide2.QtGui.QGuiApplication.desktopSettingsAware": (),
    "PySide2.QtGui.QGuiApplication.devicePixelRatio": (),
    "PySide2.QtGui.QGuiApplication.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtGui.QGuiApplication.exec_": (),
    "PySide2.QtGui.QGuiApplication.focusObject": (),
    "PySide2.QtGui.QGuiApplication.focusWindow": (),
    "PySide2.QtGui.QGuiApplication.font": (),
    "PySide2.QtGui.QGuiApplication.highDpiScaleFactorRoundingPolicy": (),
    "PySide2.QtGui.QGuiApplication.inputMethod": (),
    "PySide2.QtGui.QGuiApplication.isFallbackSessionManagementEnabled": (),
    "PySide2.QtGui.QGuiApplication.isLeftToRight": (),
    "PySide2.QtGui.QGuiApplication.isRightToLeft": (),
    "PySide2.QtGui.QGuiApplication.isSavingSession": (),
    "PySide2.QtGui.QGuiApplication.isSessionRestored": (),
    "PySide2.QtGui.QGuiApplication.keyboardModifiers": (),
    "PySide2.QtGui.QGuiApplication.layoutDirection": (),
    "PySide2.QtGui.QGuiApplication.modalWindow": (),
    "PySide2.QtGui.QGuiApplication.mouseButtons": (),
    "PySide2.QtGui.QGuiApplication.notify": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtGui.QGuiApplication.overrideCursor": (),
    "PySide2.QtGui.QGuiApplication.palette": (),
    "PySide2.QtGui.QGuiApplication.platformName": (),
    "PySide2.QtGui.QGuiApplication.primaryScreen": (),
    "PySide2.QtGui.QGuiApplication.queryKeyboardModifiers": (),
    "PySide2.QtGui.QGuiApplication.quitOnLastWindowClosed": (),
    "PySide2.QtGui.QGuiApplication.restoreOverrideCursor": (),
    "PySide2.QtGui.QGuiApplication.screenAt": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QGuiApplication.screens": (),
    "PySide2.QtGui.QGuiApplication.sessionId": (),
    "PySide2.QtGui.QGuiApplication.sessionKey": (),
    "PySide2.QtGui.QGuiApplication.setApplicationDisplayName": ('str',),
    "PySide2.QtGui.QGuiApplication.setDesktopFileName": ('str',),
    "PySide2.QtGui.QGuiApplication.setDesktopSettingsAware": ('bool',),
    "PySide2.QtGui.QGuiApplication.setFallbackSessionManagementEnabled": ('bool',),
    "PySide2.QtGui.QGuiApplication.setFont": ('PySide2.QtGui.QFont',),
    "PySide2.QtGui.QGuiApplication.setHighDpiScaleFactorRoundingPolicy": ('PySide2.QtCore.Qt.HighDpiScaleFactorRoundingPolicy',),
    "PySide2.QtGui.QGuiApplication.setLayoutDirection": ('PySide2.QtCore.Qt.LayoutDirection',),
    "PySide2.QtGui.QGuiApplication.setOverrideCursor": ('PySide2.QtGui.QCursor',),
    "PySide2.QtGui.QGuiApplication.setPalette": ('PySide2.QtGui.QPalette',),
    "PySide2.QtGui.QGuiApplication.setQuitOnLastWindowClosed": ('bool',),
    "PySide2.QtGui.QGuiApplication.setWindowIcon": ('PySide2.QtGui.QIcon',),
    "PySide2.QtGui.QGuiApplication.styleHints": (),
    "PySide2.QtGui.QGuiApplication.sync": (),
    "PySide2.QtGui.QGuiApplication.topLevelAt": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QGuiApplication.topLevelWindows": (),
    "PySide2.QtGui.QGuiApplication.windowIcon": (),

# class PySide2.QtGui.QHelpEvent:
    "PySide2.QtGui.QHelpEvent.__init__": ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint'),
    "PySide2.QtGui.QHelpEvent.globalPos": (),
    "PySide2.QtGui.QHelpEvent.globalX": (),
    "PySide2.QtGui.QHelpEvent.global""Y": (),
    "PySide2.QtGui.QHelpEvent.pos": (),
    "PySide2.QtGui.QHelpEvent.x": (),
    "PySide2.QtGui.QHelpEvent.y": (),

# class PySide2.QtGui.QHideEvent:
    "PySide2.QtGui.QHideEvent.__init__": (),

# class PySide2.QtGui.QHoverEvent:
    "PySide2.QtGui.QHoverEvent.__init__": ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.KeyboardModifiers'),
    "PySide2.QtGui.QHoverEvent.oldPos": (),
    "PySide2.QtGui.QHoverEvent.oldPosF": (),
    "PySide2.QtGui.QHoverEvent.pos": (),
    "PySide2.QtGui.QHoverEvent.posF": (),

# class PySide2.QtGui.QIcon:

# class PySide2.QtGui.QIcon.Mode:

# class PySide2.QtGui.QIcon.State:
    "PySide2.QtGui.QIcon.__init__": [(), ('PySide2.QtGui.QIcon',), ('PySide2.QtGui.QIconEngine',), ('PySide2.QtGui.QPixmap',), ('str',)],
    "PySide2.QtGui.QIcon.__copy__": (),
    "PySide2.QtGui.QIcon.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QIcon.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QIcon.actualSize": [('PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'), ('PySide2.QtGui.QWindow', 'PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State')],
    "PySide2.QtGui.QIcon.addFile": ('str', 'PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
    "PySide2.QtGui.QIcon.addPixmap": ('PySide2.QtGui.QPixmap', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
    "PySide2.QtGui.QIcon.availableSizes": ('PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
    "PySide2.QtGui.QIcon.cacheKey": (),
    "PySide2.QtGui.QIcon.fallbackSearchPaths": (),
    "PySide2.QtGui.QIcon.fallbackThemeName": (),
    "PySide2.QtGui.QIcon.fromTheme": [('str',), ('str', 'PySide2.QtGui.QIcon')],
    "PySide2.QtGui.QIcon.hasThemeIcon": ('str',),
    "PySide2.QtGui.QIcon.isMask": (),
    "PySide2.QtGui.QIcon.isNull": (),
    "PySide2.QtGui.QIcon.name": (),
    "PySide2.QtGui.QIcon.paint": [('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.Alignment', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'), ('PySide2.QtGui.QPainter', 'int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.Alignment', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State')],
    "PySide2.QtGui.QIcon.pixmap": [('PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'), ('PySide2.QtGui.QWindow', 'PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'), ('int', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'), ('int', 'int', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State')],
    "PySide2.QtGui.QIcon.setFallbackSearchPaths": ('typing.Sequence',),
    "PySide2.QtGui.QIcon.setFallbackThemeName": ('str',),
    "PySide2.QtGui.QIcon.setIsMask": ('bool',),
    "PySide2.QtGui.QIcon.setThemeName": ('str',),
    "PySide2.QtGui.QIcon.setThemeSearchPaths": ('typing.Sequence',),
    "PySide2.QtGui.QIcon.swap": ('PySide2.QtGui.QIcon',),
    "PySide2.QtGui.QIcon.themeName": (),
    "PySide2.QtGui.QIcon.themeSearchPaths": (),

# class PySide2.QtGui.QIconDragEvent:
    "PySide2.QtGui.QIconDragEvent.__init__": (),

# class PySide2.QtGui.QIconEngine:

# class PySide2.QtGui.QIconEngine.AvailableSizesArgument:
    "PySide2.QtGui.QIconEngine.AvailableSizesArgument.__init__": (),

# class PySide2.QtGui.QIconEngine.IconEngineHook:

    "PySide2.QtGui.QIconEngine.__init__": [(), ('PySide2.QtGui.QIconEngine',)],
    "PySide2.QtGui.QIconEngine.actualSize": ('PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
    "PySide2.QtGui.QIconEngine.addFile": ('str', 'PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
    "PySide2.QtGui.QIconEngine.addPixmap": ('PySide2.QtGui.QPixmap', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
    "PySide2.QtGui.QIconEngine.availableSizes": ('PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
    "PySide2.QtGui.QIconEngine.clone": (),
    "PySide2.QtGui.QIconEngine.iconName": (),
    "PySide2.QtGui.QIconEngine.isNull": (),
    "PySide2.QtGui.QIconEngine.key": (),
    "PySide2.QtGui.QIconEngine.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
    "PySide2.QtGui.QIconEngine.pixmap": ('PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State'),
    "PySide2.QtGui.QIconEngine.read": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QIconEngine.scaledPixmap": ('PySide2.QtCore.QSize', 'PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QIcon.State', 'float'),
    "PySide2.QtGui.QIconEngine.write": ('PySide2.QtCore.QDataStream',),

# class PySide2.QtGui.QImage:

# class PySide2.QtGui.QImage.Format:

# class PySide2.QtGui.QImage.InvertMode:
    "PySide2.QtGui.QImage.__init__": [(), ('PySide2.QtCore.QSize', 'PySide2.QtGui.QImage.Format'), ('PySide2.QtGui.QImage',), ('bytes', 'int', 'int', 'PySide2.QtGui.QImage.Format', 'typing.Callable', 'int'), ('bytes', 'int', 'int', 'int', 'PySide2.QtGui.QImage.Format', 'typing.Callable', 'int'), ('int', 'int', 'PySide2.QtGui.QImage.Format'), ('str', 'bytes'), ('str', 'int', 'int', 'PySide2.QtGui.QImage.Format'), ('str', 'int', 'int', 'int', 'PySide2.QtGui.QImage.Format'), ('typing.Sequence',)],
    "PySide2.QtGui.QImage.__copy__": (),
    "PySide2.QtGui.QImage.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QImage.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QImage.allGray": (),
    "PySide2.QtGui.QImage.alphaChannel": (),
    "PySide2.QtGui.QImage.bitPlaneCount": (),
    "PySide2.QtGui.QImage.bits": (),
    "PySide2.QtGui.QImage.byteCount": (),
    "PySide2.QtGui.QImage.bytesPerLine": (),
    "PySide2.QtGui.QImage.cacheKey": (),
    "PySide2.QtGui.QImage.color": ('int',),
    "PySide2.QtGui.QImage.colorCount": (),
    "PySide2.QtGui.QImage.colorSpace": (),
    "PySide2.QtGui.QImage.colorTable": (),
    "PySide2.QtGui.QImage.constBits": (),
    "PySide2.QtGui.QImage.constScanLine": ('int',),
    "PySide2.QtGui.QImage.convertTo": ('PySide2.QtGui.QImage.Format', 'PySide2.QtCore.Qt.ImageConversionFlags'),
    "PySide2.QtGui.QImage.convertToColorSpace": ('PySide2.QtGui.QColorSpace',),
    "PySide2.QtGui.QImage.convertToFormat": [('PySide2.QtGui.QImage.Format', 'PySide2.QtCore.Qt.ImageConversionFlags'), ('PySide2.QtGui.QImage.Format', 'typing.List', 'PySide2.QtCore.Qt.ImageConversionFlags')],
    "PySide2.QtGui.QImage.convertToFormat_helper": ('PySide2.QtGui.QImage.Format', 'PySide2.QtCore.Qt.ImageConversionFlags'),
    "PySide2.QtGui.QImage.convertToFormat_inplace": ('PySide2.QtGui.QImage.Format', 'PySide2.QtCore.Qt.ImageConversionFlags'),
    "PySide2.QtGui.QImage.convertedToColorSpace": ('PySide2.QtGui.QColorSpace',),
    "PySide2.QtGui.QImage.copy": [('PySide2.QtCore.QRect',), ('int', 'int', 'int', 'int')],
    "PySide2.QtGui.QImage.createAlphaMask": ('PySide2.QtCore.Qt.ImageConversionFlags',),
    "PySide2.QtGui.QImage.createHeuristicMask": ('bool',),
    "PySide2.QtGui.QImage.createMaskFromColor": ('int', 'PySide2.QtCore.Qt.MaskMode'),
    "PySide2.QtGui.QImage.depth": (),
    "PySide2.QtGui.QImage.devType": (),
    "PySide2.QtGui.QImage.devicePixelRatio": (),
    "PySide2.QtGui.QImage.dotsPerMeterX": (),
    "PySide2.QtGui.QImage.dotsPerMeterY": (),
    "PySide2.QtGui.QImage.fill": [('PySide2.QtCore.Qt.GlobalColor',), ('PySide2.QtGui.QColor',), ('int',)],
    "PySide2.QtGui.QImage.format": (),
    "PySide2.QtGui.QImage.fromData": ('PySide2.QtCore.QByteArray', 'bytes'),
    "PySide2.QtGui.QImage.hasAlphaChannel": (),
    "PySide2.QtGui.QImage.height": (),
    "PySide2.QtGui.QImage.invertPixels": ('PySide2.QtGui.QImage.InvertMode',),
    "PySide2.QtGui.QImage.isGrayscale": (),
    "PySide2.QtGui.QImage.isNull": (),
    "PySide2.QtGui.QImage.load": [('PySide2.QtCore.QIODevice', 'bytes'), ('str', 'bytes')],
    "PySide2.QtGui.QImage.loadFromData": ('PySide2.QtCore.QByteArray', 'bytes'),
    "PySide2.QtGui.QImage.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
    "PySide2.QtGui.QImage.mirrored": ('bool', 'bool'),
    "PySide2.QtGui.QImage.mirrored_helper": ('bool', 'bool'),
    "PySide2.QtGui.QImage.mirrored_inplace": ('bool', 'bool'),
    "PySide2.QtGui.QImage.offset": (),
    "PySide2.QtGui.QImage.paintEngine": (),
    "PySide2.QtGui.QImage.pixel": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtGui.QImage.pixelColor": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtGui.QImage.pixelFormat": (),
    "PySide2.QtGui.QImage.pixelIndex": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtGui.QImage.rect": (),
    "PySide2.QtGui.QImage.reinterpretAsFormat": ('PySide2.QtGui.QImage.Format',),
    "PySide2.QtGui.QImage.rgbSwapped": (),
    "PySide2.QtGui.QImage.rgbSwapped_helper": (),
    "PySide2.QtGui.QImage.rgbSwapped_inplace": (),
    "PySide2.QtGui.QImage.save": [('PySide2.QtCore.QIODevice', 'bytes', 'int'), ('str', 'bytes', 'int')],
    "PySide2.QtGui.QImage.scaled": [('PySide2.QtCore.QSize', 'PySide2.QtCore.Qt.AspectRatioMode', 'PySide2.QtCore.Qt.TransformationMode'), ('int', 'int', 'PySide2.QtCore.Qt.AspectRatioMode', 'PySide2.QtCore.Qt.TransformationMode')],
    "PySide2.QtGui.QImage.scaledToHeight": ('int', 'PySide2.QtCore.Qt.TransformationMode'),
    "PySide2.QtGui.QImage.scaledToWidth": ('int', 'PySide2.QtCore.Qt.TransformationMode'),
    "PySide2.QtGui.QImage.scanLine": ('int',),
    "PySide2.QtGui.QImage.setAlphaChannel": ('PySide2.QtGui.QImage',),
    "PySide2.QtGui.QImage.setColor": ('int', 'int'),
    "PySide2.QtGui.QImage.setColorCount": ('int',),
    "PySide2.QtGui.QImage.setColorSpace": ('PySide2.QtGui.QColorSpace',),
    "PySide2.QtGui.QImage.setColorTable": ('typing.List',),
    "PySide2.QtGui.QImage.setDevicePixelRatio": ('float',),
    "PySide2.QtGui.QImage.setDotsPerMeterX": ('int',),
    "PySide2.QtGui.QImage.setDotsPerMeterY": ('int',),
    "PySide2.QtGui.QImage.setOffset": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QImage.setPixel": [('PySide2.QtCore.QPoint', 'int'), ('int', 'int', 'int')],
    "PySide2.QtGui.QImage.setPixelColor": [('PySide2.QtCore.QPoint', 'PySide2.QtGui.QColor'), ('int', 'int', 'PySide2.QtGui.QColor')],
    "PySide2.QtGui.QImage.setText": ('str', 'str'),
    "PySide2.QtGui.QImage.size": (),
    "PySide2.QtGui.QImage.sizeInBytes": (),
    "PySide2.QtGui.QImage.smoothScaled": ('int', 'int'),
    "PySide2.QtGui.QImage.swap": ('PySide2.QtGui.QImage',),
    "PySide2.QtGui.QImage.text": ('str',),
    "PySide2.QtGui.QImage.textKeys": (),
    "PySide2.QtGui.QImage.toImageFormat": ('PySide2.QtGui.QPixelFormat',),
    "PySide2.QtGui.QImage.toPixelFormat": ('PySide2.QtGui.QImage.Format',),
    "PySide2.QtGui.QImage.transformed": [('PySide2.QtGui.QMatrix', 'PySide2.QtCore.Qt.TransformationMode'), ('PySide2.QtGui.QTransform', 'PySide2.QtCore.Qt.TransformationMode')],
    "PySide2.QtGui.QImage.trueMatrix": [('PySide2.QtGui.QMatrix', 'int', 'int'), ('PySide2.QtGui.QTransform', 'int', 'int')],
    "PySide2.QtGui.QImage.valid": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtGui.QImage.width": (),

# class PySide2.QtGui.QImageIOHandler:

# class PySide2.QtGui.QImageIOHandler.ImageOption:

# class PySide2.QtGui.QImageIOHandler.Transformation:

# class PySide2.QtGui.QImageIOHandler.Transformations:
    "PySide2.QtGui.QImageIOHandler.__init__": (),
    "PySide2.QtGui.QImageIOHandler.canRead": (),
    "PySide2.QtGui.QImageIOHandler.currentImageNumber": (),
    "PySide2.QtGui.QImageIOHandler.currentImageRect": (),
    "PySide2.QtGui.QImageIOHandler.device": (),
    "PySide2.QtGui.QImageIOHandler.format": (),
    "PySide2.QtGui.QImageIOHandler.imageCount": (),
    "PySide2.QtGui.QImageIOHandler.jumpToImage": ('int',),
    "PySide2.QtGui.QImageIOHandler.jumpToNextImage": (),
    "PySide2.QtGui.QImageIOHandler.loopCount": (),
    "PySide2.QtGui.QImageIOHandler.name": (),
    "PySide2.QtGui.QImageIOHandler.nextImageDelay": (),
    "PySide2.QtGui.QImageIOHandler.option": ('PySide2.QtGui.QImageIOHandler.ImageOption',),
    "PySide2.QtGui.QImageIOHandler.read": ('PySide2.QtGui.QImage',),
    "PySide2.QtGui.QImageIOHandler.setDevice": ('PySide2.QtCore.QIODevice',),
    "PySide2.QtGui.QImageIOHandler.setFormat": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtGui.QImageIOHandler.setOption": ('PySide2.QtGui.QImageIOHandler.ImageOption', 'typing.Any'),
    "PySide2.QtGui.QImageIOHandler.supportsOption": ('PySide2.QtGui.QImageIOHandler.ImageOption',),
    "PySide2.QtGui.QImageIOHandler.write": ('PySide2.QtGui.QImage',),

# class PySide2.QtGui.QImageReader:

# class PySide2.QtGui.QImageReader.ImageReaderError:
    "PySide2.QtGui.QImageReader.__init__": [(), ('PySide2.QtCore.QIODevice', 'PySide2.QtCore.QByteArray'), ('str', 'PySide2.QtCore.QByteArray')],
    "PySide2.QtGui.QImageReader.autoDetectImageFormat": (),
    "PySide2.QtGui.QImageReader.autoTransform": (),
    "PySide2.QtGui.QImageReader.backgroundColor": (),
    "PySide2.QtGui.QImageReader.canRead": (),
    "PySide2.QtGui.QImageReader.clipRect": (),
    "PySide2.QtGui.QImageReader.currentImageNumber": (),
    "PySide2.QtGui.QImageReader.currentImageRect": (),
    "PySide2.QtGui.QImageReader.decideFormatFromContent": (),
    "PySide2.QtGui.QImageReader.device": (),
    "PySide2.QtGui.QImageReader.error": (),
    "PySide2.QtGui.QImageReader.errorString": (),
    "PySide2.QtGui.QImageReader.fileName": (),
    "PySide2.QtGui.QImageReader.format": (),
    "PySide2.QtGui.QImageReader.gamma": (),
    "PySide2.QtGui.QImageReader.imageCount": (),
    "PySide2.QtGui.QImageReader.imageFormat": [(), ('PySide2.QtCore.QIODevice',), ('str',)],
    "PySide2.QtGui.QImageReader.imageFormatsForMimeType": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtGui.QImageReader.jumpToImage": ('int',),
    "PySide2.QtGui.QImageReader.jumpToNextImage": (),
    "PySide2.QtGui.QImageReader.loopCount": (),
    "PySide2.QtGui.QImageReader.nextImageDelay": (),
    "PySide2.QtGui.QImageReader.quality": (),
    "PySide2.QtGui.QImageReader.read": (),
    "PySide2.QtGui.QImageReader.scaledClipRect": (),
    "PySide2.QtGui.QImageReader.scaledSize": (),
    "PySide2.QtGui.QImageReader.setAutoDetectImageFormat": ('bool',),
    "PySide2.QtGui.QImageReader.setAutoTransform": ('bool',),
    "PySide2.QtGui.QImageReader.setBackgroundColor": ('PySide2.QtGui.QColor',),
    "PySide2.QtGui.QImageReader.setClipRect": ('PySide2.QtCore.QRect',),
    "PySide2.QtGui.QImageReader.setDecideFormatFromContent": ('bool',),
    "PySide2.QtGui.QImageReader.setDevice": ('PySide2.QtCore.QIODevice',),
    "PySide2.QtGui.QImageReader.setFileName": ('str',),
    "PySide2.QtGui.QImageReader.setFormat": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtGui.QImageReader.setGamma": ('float',),
    "PySide2.QtGui.QImageReader.setQuality": ('int',),
    "PySide2.QtGui.QImageReader.setScaledClipRect": ('PySide2.QtCore.QRect',),
    "PySide2.QtGui.QImageReader.setScaledSize": ('PySide2.QtCore.QSize',),
    "PySide2.QtGui.QImageReader.size": (),
    "PySide2.QtGui.QImageReader.subType": (),
    "PySide2.QtGui.QImageReader.supportedImageFormats": (),
    "PySide2.QtGui.QImageReader.supportedMimeTypes": (),
    "PySide2.QtGui.QImageReader.supportedSubTypes": (),
    "PySide2.QtGui.QImageReader.supportsAnimation": (),
    "PySide2.QtGui.QImageReader.supportsOption": ('PySide2.QtGui.QImageIOHandler.ImageOption',),
    "PySide2.QtGui.QImageReader.text": ('str',),
    "PySide2.QtGui.QImageReader.textKeys": (),
    "PySide2.QtGui.QImageReader.transformation": (),

# class PySide2.QtGui.QImageWriter:

# class PySide2.QtGui.QImageWriter.ImageWriterError:
    "PySide2.QtGui.QImageWriter.__init__": [(), ('PySide2.QtCore.QIODevice', 'PySide2.QtCore.QByteArray'), ('str', 'PySide2.QtCore.QByteArray')],
    "PySide2.QtGui.QImageWriter.canWrite": (),
    "PySide2.QtGui.QImageWriter.compression": (),
    "PySide2.QtGui.QImageWriter.description": (),
    "PySide2.QtGui.QImageWriter.device": (),
    "PySide2.QtGui.QImageWriter.error": (),
    "PySide2.QtGui.QImageWriter.errorString": (),
    "PySide2.QtGui.QImageWriter.fileName": (),
    "PySide2.QtGui.QImageWriter.format": (),
    "PySide2.QtGui.QImageWriter.gamma": (),
    "PySide2.QtGui.QImageWriter.imageFormatsForMimeType": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtGui.QImageWriter.optimizedWrite": (),
    "PySide2.QtGui.QImageWriter.progressiveScanWrite": (),
    "PySide2.QtGui.QImageWriter.quality": (),
    "PySide2.QtGui.QImageWriter.setCompression": ('int',),
    "PySide2.QtGui.QImageWriter.setDescription": ('str',),
    "PySide2.QtGui.QImageWriter.setDevice": ('PySide2.QtCore.QIODevice',),
    "PySide2.QtGui.QImageWriter.setFileName": ('str',),
    "PySide2.QtGui.QImageWriter.setFormat": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtGui.QImageWriter.setGamma": ('float',),
    "PySide2.QtGui.QImageWriter.setOptimizedWrite": ('bool',),
    "PySide2.QtGui.QImageWriter.setProgressiveScanWrite": ('bool',),
    "PySide2.QtGui.QImageWriter.setQuality": ('int',),
    "PySide2.QtGui.QImageWriter.setSubType": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtGui.QImageWriter.setText": ('str', 'str'),
    "PySide2.QtGui.QImageWriter.setTransformation": ('PySide2.QtGui.QImageIOHandler.Transformations',),
    "PySide2.QtGui.QImageWriter.subType": (),
    "PySide2.QtGui.QImageWriter.supportedImageFormats": (),
    "PySide2.QtGui.QImageWriter.supportedMimeTypes": (),
    "PySide2.QtGui.QImageWriter.supportedSubTypes": (),
    "PySide2.QtGui.QImageWriter.supportsOption": ('PySide2.QtGui.QImageIOHandler.ImageOption',),
    "PySide2.QtGui.QImageWriter.transformation": (),
    "PySide2.QtGui.QImageWriter.write": ('PySide2.QtGui.QImage',),

# class PySide2.QtGui.QInputEvent:
    "PySide2.QtGui.QInputEvent.__init__": ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.Qt.KeyboardModifiers'),
    "PySide2.QtGui.QInputEvent.modifiers": (),
    "PySide2.QtGui.QInputEvent.setModifiers": ('PySide2.QtCore.Qt.KeyboardModifiers',),
    "PySide2.QtGui.QInputEvent.setTimestamp": ('int',),
    "PySide2.QtGui.QInputEvent.timestamp": (),

# class PySide2.QtGui.QInputMethod:

# class PySide2.QtGui.QInputMethod.Action:
    "PySide2.QtGui.QInputMethod.anchorRectangle": (),
    "PySide2.QtGui.QInputMethod.commit": (),
    "PySide2.QtGui.QInputMethod.cursorRectangle": (),
    "PySide2.QtGui.QInputMethod.hide": (),
    "PySide2.QtGui.QInputMethod.inputDirection": (),
    "PySide2.QtGui.QInputMethod.inputItemClipRectangle": (),
    "PySide2.QtGui.QInputMethod.inputItemRectangle": (),
    "PySide2.QtGui.QInputMethod.inputItemTransform": (),
    "PySide2.QtGui.QInputMethod.invokeAction": ('PySide2.QtGui.QInputMethod.Action', 'int'),
    "PySide2.QtGui.QInputMethod.isAnimating": (),
    "PySide2.QtGui.QInputMethod.isVisible": (),
    "PySide2.QtGui.QInputMethod.keyboardRectangle": (),
    "PySide2.QtGui.QInputMethod.locale": (),
    "PySide2.QtGui.QInputMethod.queryFocusObject": ('PySide2.QtCore.Qt.InputMethodQuery', 'typing.Any'),
    "PySide2.QtGui.QInputMethod.reset": (),
    "PySide2.QtGui.QInputMethod.setInputItemRectangle": ('PySide2.QtCore.QRectF',),
    "PySide2.QtGui.QInputMethod.setInputItemTransform": ('PySide2.QtGui.QTransform',),
    "PySide2.QtGui.QInputMethod.setVisible": ('bool',),
    "PySide2.QtGui.QInputMethod.show": (),
    "PySide2.QtGui.QInputMethod.update": ('PySide2.QtCore.Qt.InputMethodQueries',),

# class PySide2.QtGui.QInputMethodEvent:

# class PySide2.QtGui.QInputMethodEvent.Attribute:
    "PySide2.QtGui.QInputMethodEvent.Attribute.__init__": [('PySide2.QtGui.QInputMethodEvent.Attribute',), ('PySide2.QtGui.QInputMethodEvent.AttributeType', 'int', 'int'), ('PySide2.QtGui.QInputMethodEvent.AttributeType', 'int', 'int', 'typing.Any')],
    "PySide2.QtGui.QInputMethodEvent.Attribute.__copy__": (),

# class PySide2.QtGui.QInputMethodEvent.AttributeType:

    "PySide2.QtGui.QInputMethodEvent.__init__": [(), ('PySide2.QtGui.QInputMethodEvent',), ('str', 'typing.Sequence')],
    "PySide2.QtGui.QInputMethodEvent.attributes": (),
    "PySide2.QtGui.QInputMethodEvent.commitString": (),
    "PySide2.QtGui.QInputMethodEvent.preeditString": (),
    "PySide2.QtGui.QInputMethodEvent.replacementLength": (),
    "PySide2.QtGui.QInputMethodEvent.replacementStart": (),
    "PySide2.QtGui.QInputMethodEvent.setCommitString": ('str', 'int', 'int'),

# class PySide2.QtGui.QInputMethodQueryEvent:
    "PySide2.QtGui.QInputMethodQueryEvent.__init__": ('PySide2.QtCore.Qt.InputMethodQueries',),
    "PySide2.QtGui.QInputMethodQueryEvent.queries": (),
    "PySide2.QtGui.QInputMethodQueryEvent.setValue": ('PySide2.QtCore.Qt.InputMethodQuery', 'typing.Any'),
    "PySide2.QtGui.QInputMethodQueryEvent.value": ('PySide2.QtCore.Qt.InputMethodQuery',),

# class PySide2.QtGui.QIntValidator:
    "PySide2.QtGui.QIntValidator.__init__": [('PySide2.QtCore.QObject',), ('int', 'int', 'PySide2.QtCore.QObject')],
    "PySide2.QtGui.QIntValidator.bottom": (),
    "PySide2.QtGui.QIntValidator.fixup": ('str',),
    "PySide2.QtGui.QIntValidator.setBottom": ('int',),
    "PySide2.QtGui.QIntValidator.setRange": ('int', 'int'),
    "PySide2.QtGui.QIntValidator.setTop": ('int',),
    "PySide2.QtGui.QIntValidator.top": (),
    "PySide2.QtGui.QIntValidator.validate": ('str', 'int'),

# class PySide2.QtGui.QKeyEvent:
    "PySide2.QtGui.QKeyEvent.__init__": [('PySide2.QtCore.QEvent.Type', 'int', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int', 'int', 'int', 'str', 'bool', 'int'), ('PySide2.QtCore.QEvent.Type', 'int', 'PySide2.QtCore.Qt.KeyboardModifiers', 'str', 'bool', 'int')],
    "PySide2.QtGui.QKeyEvent.count": (),
    "PySide2.QtGui.QKeyEvent.isAutoRepeat": (),
    "PySide2.QtGui.QKeyEvent.key": (),
    "PySide2.QtGui.QKeyEvent.matches": ('PySide2.QtGui.QKeySequence.StandardKey',),
    "PySide2.QtGui.QKeyEvent.modifiers": (),
    "PySide2.QtGui.QKeyEvent.nativeModifiers": (),
    "PySide2.QtGui.QKeyEvent.nativeScanCode": (),
    "PySide2.QtGui.QKeyEvent.nativeVirtualKey": (),
    "PySide2.QtGui.QKeyEvent.text": (),

# class PySide2.QtGui.QKeySequence:

# class PySide2.QtGui.QKeySequence.SequenceFormat:

# class PySide2.QtGui.QKeySequence.SequenceMatch:

# class PySide2.QtGui.QKeySequence.StandardKey:
    "PySide2.QtGui.QKeySequence.__init__": [(), ('PySide2.QtGui.QKeySequence',), ('PySide2.QtGui.QKeySequence.StandardKey',), ('int', 'int', 'int', 'int'), ('str', 'PySide2.QtGui.QKeySequence.SequenceFormat')],
    "PySide2.QtGui.QKeySequence.__copy__": (),
    "PySide2.QtGui.QKeySequence.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QKeySequence.__reduce__": (),
    "PySide2.QtGui.QKeySequence.__repr__": (),
    "PySide2.QtGui.QKeySequence.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QKeySequence.count": (),
    "PySide2.QtGui.QKeySequence.fromString": ('str', 'PySide2.QtGui.QKeySequence.SequenceFormat'),
    "PySide2.QtGui.QKeySequence.isEmpty": (),
    "PySide2.QtGui.QKeySequence.keyBindings": ('PySide2.QtGui.QKeySequence.StandardKey',),
    "PySide2.QtGui.QKeySequence.listFromString": ('str', 'PySide2.QtGui.QKeySequence.SequenceFormat'),
    "PySide2.QtGui.QKeySequence.listToString": ('typing.Sequence', 'PySide2.QtGui.QKeySequence.SequenceFormat'),
    "PySide2.QtGui.QKeySequence.matches": ('PySide2.QtGui.QKeySequence',),
    "PySide2.QtGui.QKeySequence.mnemonic": ('str',),
    "PySide2.QtGui.QKeySequence.swap": ('PySide2.QtGui.QKeySequence',),
    "PySide2.QtGui.QKeySequence.toString": ('PySide2.QtGui.QKeySequence.SequenceFormat',),

# class PySide2.QtGui.QLinearGradient:
    "PySide2.QtGui.QLinearGradient.__init__": [(), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'), ('PySide2.QtGui.QLinearGradient',), ('float', 'float', 'float', 'float')],
    "PySide2.QtGui.QLinearGradient.__copy__": (),
    "PySide2.QtGui.QLinearGradient.finalStop": (),
    "PySide2.QtGui.QLinearGradient.setFinalStop": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtGui.QLinearGradient.setStart": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtGui.QLinearGradient.start": (),

# class PySide2.QtGui.QMatrix:
    "PySide2.QtGui.QMatrix.__init__": [(), ('PySide2.QtGui.QMatrix',), ('float', 'float', 'float', 'float', 'float', 'float')],
    "PySide2.QtGui.QMatrix.__copy__": (),
    "PySide2.QtGui.QMatrix.__imul__": ('PySide2.QtGui.QMatrix',),
    "PySide2.QtGui.QMatrix.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QMatrix.__mul__": [('PySide2.QtCore.QLine',), ('PySide2.QtCore.QLineF',), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QMatrix',)],
    "PySide2.QtGui.QMatrix.__reduce__": (),
    "PySide2.QtGui.QMatrix.__repr__": (),
    "PySide2.QtGui.QMatrix.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QMatrix.determinant": (),
    "PySide2.QtGui.QMatrix.dx": (),
    "PySide2.QtGui.QMatrix.dy": (),
    "PySide2.QtGui.QMatrix.inverted": (),
    "PySide2.QtGui.QMatrix.isIdentity": (),
    "PySide2.QtGui.QMatrix.isInvertible": (),
    "PySide2.QtGui.QMatrix.m11": (),
    "PySide2.QtGui.QMatrix.m12": (),
    "PySide2.QtGui.QMatrix.m21": (),
    "PySide2.QtGui.QMatrix.m22": (),
    "PySide2.QtGui.QMatrix.map": [('PySide2.QtCore.QLine',), ('PySide2.QtCore.QLineF',), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QPainterPath',), ('PySide2.QtGui.QPolygon',), ('PySide2.QtGui.QPolygonF',), ('PySide2.QtGui.QRegion',), ('float', 'float'), ('int', 'int')],
    "PySide2.QtGui.QMatrix.mapRect": [('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',)],
    "PySide2.QtGui.QMatrix.mapToPolygon": ('PySide2.QtCore.QRect',),
    "PySide2.QtGui.QMatrix.reset": (),
    "PySide2.QtGui.QMatrix.rotate": ('float',),
    "PySide2.QtGui.QMatrix.scale": ('float', 'float'),
    "PySide2.QtGui.QMatrix.setMatrix": ('float', 'float', 'float', 'float', 'float', 'float'),
    "PySide2.QtGui.QMatrix.shear": ('float', 'float'),
    "PySide2.QtGui.QMatrix.translate": ('float', 'float'),

# class PySide2.QtGui.QMatrix2x2:
    "PySide2.QtGui.QMatrix2x2.__init__": [(), ('PySide2.QtGui.QMatrix2x2',), ('typing.Iterable',)],
    "PySide2.QtGui.QMatrix2x2.__call__": ('int', 'int'),
    "PySide2.QtGui.QMatrix2x2.__copy__": (),
    "PySide2.QtGui.QMatrix2x2.__iadd__": ('PySide2.QtGui.QMatrix2x2',),
    "PySide2.QtGui.QMatrix2x2.__imul__": ('float',),
    "PySide2.QtGui.QMatrix2x2.__isub__": ('PySide2.QtGui.QMatrix2x2',),
    "PySide2.QtGui.QMatrix2x2.__reduce__": (),
    "PySide2.QtGui.QMatrix2x2.__repr__": (),
    "PySide2.QtGui.QMatrix2x2.data": (),
    "PySide2.QtGui.QMatrix2x2.fill": ('float',),
    "PySide2.QtGui.QMatrix2x2.isIdentity": (),
    "PySide2.QtGui.QMatrix2x2.setToIdentity": (),
    "PySide2.QtGui.QMatrix2x2.transposed": (),

# class PySide2.QtGui.QMatrix2x3:
    "PySide2.QtGui.QMatrix2x3.__init__": [(), ('PySide2.QtGui.QMatrix2x3',), ('typing.Iterable',)],
    "PySide2.QtGui.QMatrix2x3.__call__": ('int', 'int'),
    "PySide2.QtGui.QMatrix2x3.__copy__": (),
    "PySide2.QtGui.QMatrix2x3.__iadd__": ('PySide2.QtGui.QMatrix2x3',),
    "PySide2.QtGui.QMatrix2x3.__imul__": ('float',),
    "PySide2.QtGui.QMatrix2x3.__isub__": ('PySide2.QtGui.QMatrix2x3',),
    "PySide2.QtGui.QMatrix2x3.__reduce__": (),
    "PySide2.QtGui.QMatrix2x3.__repr__": (),
    "PySide2.QtGui.QMatrix2x3.data": (),
    "PySide2.QtGui.QMatrix2x3.fill": ('float',),
    "PySide2.QtGui.QMatrix2x3.isIdentity": (),
    "PySide2.QtGui.QMatrix2x3.setToIdentity": (),
    "PySide2.QtGui.QMatrix2x3.transposed": (),

# class PySide2.QtGui.QMatrix2x4:
    "PySide2.QtGui.QMatrix2x4.__init__": [(), ('PySide2.QtGui.QMatrix2x4',), ('typing.Iterable',)],
    "PySide2.QtGui.QMatrix2x4.__call__": ('int', 'int'),
    "PySide2.QtGui.QMatrix2x4.__copy__": (),
    "PySide2.QtGui.QMatrix2x4.__iadd__": ('PySide2.QtGui.QMatrix2x4',),
    "PySide2.QtGui.QMatrix2x4.__imul__": ('float',),
    "PySide2.QtGui.QMatrix2x4.__isub__": ('PySide2.QtGui.QMatrix2x4',),
    "PySide2.QtGui.QMatrix2x4.__reduce__": (),
    "PySide2.QtGui.QMatrix2x4.__repr__": (),
    "PySide2.QtGui.QMatrix2x4.data": (),
    "PySide2.QtGui.QMatrix2x4.fill": ('float',),
    "PySide2.QtGui.QMatrix2x4.isIdentity": (),
    "PySide2.QtGui.QMatrix2x4.setToIdentity": (),
    "PySide2.QtGui.QMatrix2x4.transposed": (),

# class PySide2.QtGui.QMatrix3x2:
    "PySide2.QtGui.QMatrix3x2.__init__": [(), ('PySide2.QtGui.QMatrix3x2',), ('typing.Iterable',)],
    "PySide2.QtGui.QMatrix3x2.__call__": ('int', 'int'),
    "PySide2.QtGui.QMatrix3x2.__copy__": (),
    "PySide2.QtGui.QMatrix3x2.__iadd__": ('PySide2.QtGui.QMatrix3x2',),
    "PySide2.QtGui.QMatrix3x2.__imul__": ('float',),
    "PySide2.QtGui.QMatrix3x2.__isub__": ('PySide2.QtGui.QMatrix3x2',),
    "PySide2.QtGui.QMatrix3x2.__reduce__": (),
    "PySide2.QtGui.QMatrix3x2.__repr__": (),
    "PySide2.QtGui.QMatrix3x2.data": (),
    "PySide2.QtGui.QMatrix3x2.fill": ('float',),
    "PySide2.QtGui.QMatrix3x2.isIdentity": (),
    "PySide2.QtGui.QMatrix3x2.setToIdentity": (),
    "PySide2.QtGui.QMatrix3x2.transposed": (),

# class PySide2.QtGui.QMatrix3x3:
    "PySide2.QtGui.QMatrix3x3.__init__": [(), ('PySide2.QtGui.QMatrix3x3',), ('typing.Iterable',)],
    "PySide2.QtGui.QMatrix3x3.__call__": ('int', 'int'),
    "PySide2.QtGui.QMatrix3x3.__copy__": (),
    "PySide2.QtGui.QMatrix3x3.__iadd__": ('PySide2.QtGui.QMatrix3x3',),
    "PySide2.QtGui.QMatrix3x3.__imul__": ('float',),
    "PySide2.QtGui.QMatrix3x3.__isub__": ('PySide2.QtGui.QMatrix3x3',),
    "PySide2.QtGui.QMatrix3x3.__reduce__": (),
    "PySide2.QtGui.QMatrix3x3.__repr__": (),
    "PySide2.QtGui.QMatrix3x3.data": (),
    "PySide2.QtGui.QMatrix3x3.fill": ('float',),
    "PySide2.QtGui.QMatrix3x3.isIdentity": (),
    "PySide2.QtGui.QMatrix3x3.setToIdentity": (),
    "PySide2.QtGui.QMatrix3x3.transposed": (),

# class PySide2.QtGui.QMatrix3x4:
    "PySide2.QtGui.QMatrix3x4.__init__": [(), ('PySide2.QtGui.QMatrix3x4',), ('typing.Iterable',)],
    "PySide2.QtGui.QMatrix3x4.__call__": ('int', 'int'),
    "PySide2.QtGui.QMatrix3x4.__copy__": (),
    "PySide2.QtGui.QMatrix3x4.__iadd__": ('PySide2.QtGui.QMatrix3x4',),
    "PySide2.QtGui.QMatrix3x4.__imul__": ('float',),
    "PySide2.QtGui.QMatrix3x4.__isub__": ('PySide2.QtGui.QMatrix3x4',),
    "PySide2.QtGui.QMatrix3x4.__reduce__": (),
    "PySide2.QtGui.QMatrix3x4.__repr__": (),
    "PySide2.QtGui.QMatrix3x4.data": (),
    "PySide2.QtGui.QMatrix3x4.fill": ('float',),
    "PySide2.QtGui.QMatrix3x4.isIdentity": (),
    "PySide2.QtGui.QMatrix3x4.setToIdentity": (),
    "PySide2.QtGui.QMatrix3x4.transposed": (),

# class PySide2.QtGui.QMatrix4x2:
    "PySide2.QtGui.QMatrix4x2.__init__": [(), ('PySide2.QtGui.QMatrix4x2',), ('typing.Iterable',)],
    "PySide2.QtGui.QMatrix4x2.__call__": ('int', 'int'),
    "PySide2.QtGui.QMatrix4x2.__copy__": (),
    "PySide2.QtGui.QMatrix4x2.__iadd__": ('PySide2.QtGui.QMatrix4x2',),
    "PySide2.QtGui.QMatrix4x2.__imul__": ('float',),
    "PySide2.QtGui.QMatrix4x2.__isub__": ('PySide2.QtGui.QMatrix4x2',),
    "PySide2.QtGui.QMatrix4x2.__reduce__": (),
    "PySide2.QtGui.QMatrix4x2.__repr__": (),
    "PySide2.QtGui.QMatrix4x2.data": (),
    "PySide2.QtGui.QMatrix4x2.fill": ('float',),
    "PySide2.QtGui.QMatrix4x2.isIdentity": (),
    "PySide2.QtGui.QMatrix4x2.setToIdentity": (),
    "PySide2.QtGui.QMatrix4x2.transposed": (),

# class PySide2.QtGui.QMatrix4x3:
    "PySide2.QtGui.QMatrix4x3.__init__": [(), ('PySide2.QtGui.QMatrix4x3',), ('typing.Iterable',)],
    "PySide2.QtGui.QMatrix4x3.__call__": ('int', 'int'),
    "PySide2.QtGui.QMatrix4x3.__copy__": (),
    "PySide2.QtGui.QMatrix4x3.__iadd__": ('PySide2.QtGui.QMatrix4x3',),
    "PySide2.QtGui.QMatrix4x3.__imul__": ('float',),
    "PySide2.QtGui.QMatrix4x3.__isub__": ('PySide2.QtGui.QMatrix4x3',),
    "PySide2.QtGui.QMatrix4x3.__reduce__": (),
    "PySide2.QtGui.QMatrix4x3.__repr__": (),
    "PySide2.QtGui.QMatrix4x3.data": (),
    "PySide2.QtGui.QMatrix4x3.fill": ('float',),
    "PySide2.QtGui.QMatrix4x3.isIdentity": (),
    "PySide2.QtGui.QMatrix4x3.setToIdentity": (),
    "PySide2.QtGui.QMatrix4x3.transposed": (),

# class PySide2.QtGui.QMatrix4x4:
    "PySide2.QtGui.QMatrix4x4.__init__": [(), ('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',), ('float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float'), ('typing.Sequence',)],
    "PySide2.QtGui.QMatrix4x4.__add__": ('PySide2.QtGui.QMatrix4x4',),
    "PySide2.QtGui.QMatrix4x4.__copy__": (),
    "PySide2.QtGui.QMatrix4x4.__dummy": ('typing.Sequence',),
    "PySide2.QtGui.QMatrix4x4.__iadd__": ('PySide2.QtGui.QMatrix4x4',),
    "PySide2.QtGui.QMatrix4x4.__imul__": [('PySide2.QtGui.QMatrix4x4',), ('float',)],
    "PySide2.QtGui.QMatrix4x4.__isub__": ('PySide2.QtGui.QMatrix4x4',),
    "PySide2.QtGui.QMatrix4x4.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QMatrix4x4.__mul__": [('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QMatrix4x4',), ('float',)],
    "PySide2.QtGui.QMatrix4x4.__neg__": (),
    "PySide2.QtGui.QMatrix4x4.__reduce__": (),
    "PySide2.QtGui.QMatrix4x4.__repr__": (),
    "PySide2.QtGui.QMatrix4x4.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QMatrix4x4.__sub__": ('PySide2.QtGui.QMatrix4x4',),
    "PySide2.QtGui.QMatrix4x4.column": ('int',),
    "PySide2.QtGui.QMatrix4x4.copyDataTo": (),
    "PySide2.QtGui.QMatrix4x4.data": (),
    "PySide2.QtGui.QMatrix4x4.determinant": (),
    "PySide2.QtGui.QMatrix4x4.fill": ('float',),
    "PySide2.QtGui.QMatrix4x4.flipCoordinates": (),
    "PySide2.QtGui.QMatrix4x4.frustum": ('float', 'float', 'float', 'float', 'float', 'float'),
    "PySide2.QtGui.QMatrix4x4.inverted": (),
    "PySide2.QtGui.QMatrix4x4.isAffine": (),
    "PySide2.QtGui.QMatrix4x4.isIdentity": (),
    "PySide2.QtGui.QMatrix4x4.lookAt": ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'),
    "PySide2.QtGui.QMatrix4x4.map": [('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QVector3D',), ('PySide2.QtGui.QVector4D',)],
    "PySide2.QtGui.QMatrix4x4.mapRect": [('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',)],
    "PySide2.QtGui.QMatrix4x4.mapVector": ('PySide2.QtGui.QVector3D',),
    "PySide2.QtGui.QMatrix4x4.normalMatrix": (),
    "PySide2.QtGui.QMatrix4x4.optimize": (),
    "PySide2.QtGui.QMatrix4x4.ortho": [('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float', 'float', 'float')],
    "PySide2.QtGui.QMatrix4x4.perspective": ('float', 'float', 'float', 'float'),
    "PySide2.QtGui.QMatrix4x4.rotate": [('PySide2.QtGui.QQuaternion',), ('float', 'PySide2.QtGui.QVector3D'), ('float', 'float', 'float', 'float')],
    "PySide2.QtGui.QMatrix4x4.row": ('int',),
    "PySide2.QtGui.QMatrix4x4.scale": [('PySide2.QtGui.QVector3D',), ('float',), ('float', 'float'), ('float', 'float', 'float')],
    "PySide2.QtGui.QMatrix4x4.setColumn": ('int', 'PySide2.QtGui.QVector4D'),
    "PySide2.QtGui.QMatrix4x4.setRow": ('int', 'PySide2.QtGui.QVector4D'),
    "PySide2.QtGui.QMatrix4x4.setToIdentity": (),
    "PySide2.QtGui.QMatrix4x4.toAffine": (),
    "PySide2.QtGui.QMatrix4x4.toTransform": [(), ('float',)],
    "PySide2.QtGui.QMatrix4x4.translate": [('PySide2.QtGui.QVector3D',), ('float', 'float'), ('float', 'float', 'float')],
    "PySide2.QtGui.QMatrix4x4.transposed": (),
    "PySide2.QtGui.QMatrix4x4.viewport": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float', 'float', 'float')],

# class PySide2.QtGui.QMouseEvent:
    "PySide2.QtGui.QMouseEvent.__init__": [('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers'), ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.Qt.MouseEventSource'), ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers'), ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers')],
    "PySide2.QtGui.QMouseEvent.button": (),
    "PySide2.QtGui.QMouseEvent.buttons": (),
    "PySide2.QtGui.QMouseEvent.flags": (),
    "PySide2.QtGui.QMouseEvent.globalPos": (),
    "PySide2.QtGui.QMouseEvent.globalX": (),
    "PySide2.QtGui.QMouseEvent.global""Y": (),
    "PySide2.QtGui.QMouseEvent.localPos": (),
    "PySide2.QtGui.QMouseEvent.pos": (),
    "PySide2.QtGui.QMouseEvent.screenPos": (),
    "PySide2.QtGui.QMouseEvent.setLocalPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QMouseEvent.source": (),
    "PySide2.QtGui.QMouseEvent.windowPos": (),
    "PySide2.QtGui.QMouseEvent.x": (),
    "PySide2.QtGui.QMouseEvent.y": (),

# class PySide2.QtGui.QMoveEvent:
    "PySide2.QtGui.QMoveEvent.__init__": ('PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint'),
    "PySide2.QtGui.QMoveEvent.oldPos": (),
    "PySide2.QtGui.QMoveEvent.pos": (),

# class PySide2.QtGui.QMovie:

# class PySide2.QtGui.QMovie.CacheMode:

# class PySide2.QtGui.QMovie.MovieState:
    "PySide2.QtGui.QMovie.__init__": [('PySide2.QtCore.QIODevice', 'PySide2.QtCore.QByteArray', 'PySide2.QtCore.QObject'), ('PySide2.QtCore.QObject',), ('str', 'PySide2.QtCore.QByteArray', 'PySide2.QtCore.QObject')],
    "PySide2.QtGui.QMovie.backgroundColor": (),
    "PySide2.QtGui.QMovie.cacheMode": (),
    "PySide2.QtGui.QMovie.currentFrameNumber": (),
    "PySide2.QtGui.QMovie.currentImage": (),
    "PySide2.QtGui.QMovie.currentPixmap": (),
    "PySide2.QtGui.QMovie.device": (),
    "PySide2.QtGui.QMovie.fileName": (),
    "PySide2.QtGui.QMovie.format": (),
    "PySide2.QtGui.QMovie.frameCount": (),
    "PySide2.QtGui.QMovie.frameRect": (),
    "PySide2.QtGui.QMovie.isValid": (),
    "PySide2.QtGui.QMovie.jumpToFrame": ('int',),
    "PySide2.QtGui.QMovie.jumpToNextFrame": (),
    "PySide2.QtGui.QMovie.lastError": (),
    "PySide2.QtGui.QMovie.lastErrorString": (),
    "PySide2.QtGui.QMovie.loopCount": (),
    "PySide2.QtGui.QMovie.nextFrameDelay": (),
    "PySide2.QtGui.QMovie.scaledSize": (),
    "PySide2.QtGui.QMovie.setBackgroundColor": ('PySide2.QtGui.QColor',),
    "PySide2.QtGui.QMovie.setCacheMode": ('PySide2.QtGui.QMovie.CacheMode',),
    "PySide2.QtGui.QMovie.setDevice": ('PySide2.QtCore.QIODevice',),
    "PySide2.QtGui.QMovie.setFileName": ('str',),
    "PySide2.QtGui.QMovie.setFormat": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtGui.QMovie.setPaused": ('bool',),
    "PySide2.QtGui.QMovie.setScaledSize": ('PySide2.QtCore.QSize',),
    "PySide2.QtGui.QMovie.setSpeed": ('int',),
    "PySide2.QtGui.QMovie.speed": (),
    "PySide2.QtGui.QMovie.start": (),
    "PySide2.QtGui.QMovie.state": (),
    "PySide2.QtGui.QMovie.stop": (),
    "PySide2.QtGui.QMovie.supportedFormats": (),

# class PySide2.QtGui.QNativeGestureEvent:
    "PySide2.QtGui.QNativeGestureEvent.__init__": [('PySide2.QtCore.Qt.NativeGestureType', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'float', 'int', 'int'), ('PySide2.QtCore.Qt.NativeGestureType', 'PySide2.QtGui.QTouchDevice', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'float', 'int', 'int')],
    "PySide2.QtGui.QNativeGestureEvent.device": (),
    "PySide2.QtGui.QNativeGestureEvent.gestureType": (),
    "PySide2.QtGui.QNativeGestureEvent.globalPos": (),
    "PySide2.QtGui.QNativeGestureEvent.localPos": (),
    "PySide2.QtGui.QNativeGestureEvent.pos": (),
    "PySide2.QtGui.QNativeGestureEvent.screenPos": (),
    "PySide2.QtGui.QNativeGestureEvent.value": (),
    "PySide2.QtGui.QNativeGestureEvent.windowPos": (),

# class PySide2.QtGui.QOffscreenSurface:
    "PySide2.QtGui.QOffscreenSurface.__init__": [('PySide2.QtGui.QScreen',), ('PySide2.QtGui.QScreen', 'PySide2.QtCore.QObject')],
    "PySide2.QtGui.QOffscreenSurface.create": (),
    "PySide2.QtGui.QOffscreenSurface.destroy": (),
    "PySide2.QtGui.QOffscreenSurface.format": (),
    "PySide2.QtGui.QOffscreenSurface.isValid": (),
    "PySide2.QtGui.QOffscreenSurface.nativeHandle": (),
    "PySide2.QtGui.QOffscreenSurface.requestedFormat": (),
    "PySide2.QtGui.QOffscreenSurface.screen": (),
    "PySide2.QtGui.QOffscreenSurface.setFormat": ('PySide2.QtGui.QSurfaceFormat',),
    "PySide2.QtGui.QOffscreenSurface.setNativeHandle": ('int',),
    "PySide2.QtGui.QOffscreenSurface.setScreen": ('PySide2.QtGui.QScreen',),
    "PySide2.QtGui.QOffscreenSurface.size": (),
    "PySide2.QtGui.QOffscreenSurface.surfaceHandle": (),
    "PySide2.QtGui.QOffscreenSurface.surfaceType": (),

# class PySide2.QtGui.QOpenGLBuffer:

# class PySide2.QtGui.QOpenGLBuffer.Access:

# class PySide2.QtGui.QOpenGLBuffer.RangeAccessFlag:

# class PySide2.QtGui.QOpenGLBuffer.RangeAccessFlags:

# class PySide2.QtGui.QOpenGLBuffer.Type:

# class PySide2.QtGui.QOpenGLBuffer.UsagePattern:
    "PySide2.QtGui.QOpenGLBuffer.__init__": [(), ('PySide2.QtGui.QOpenGLBuffer',), ('PySide2.QtGui.QOpenGLBuffer.Type',)],
    "PySide2.QtGui.QOpenGLBuffer.allocate": [('int',), ('int', 'int')],
    "PySide2.QtGui.QOpenGLBuffer.bind": (),
    "PySide2.QtGui.QOpenGLBuffer.bufferId": (),
    "PySide2.QtGui.QOpenGLBuffer.create": (),
    "PySide2.QtGui.QOpenGLBuffer.destroy": (),
    "PySide2.QtGui.QOpenGLBuffer.isCreated": (),
    "PySide2.QtGui.QOpenGLBuffer.map": ('PySide2.QtGui.QOpenGLBuffer.Access',),
    "PySide2.QtGui.QOpenGLBuffer.mapRange": ('int', 'int', 'PySide2.QtGui.QOpenGLBuffer.RangeAccessFlags'),
    "PySide2.QtGui.QOpenGLBuffer.read": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLBuffer.release": [(), ('PySide2.QtGui.QOpenGLBuffer.Type',)],
    "PySide2.QtGui.QOpenGLBuffer.setUsagePattern": ('PySide2.QtGui.QOpenGLBuffer.UsagePattern',),
    "PySide2.QtGui.QOpenGLBuffer.size": (),
    "PySide2.QtGui.QOpenGLBuffer.type": (),
    "PySide2.QtGui.QOpenGLBuffer.unmap": (),
    "PySide2.QtGui.QOpenGLBuffer.usagePattern": (),
    "PySide2.QtGui.QOpenGLBuffer.write": ('int', 'int', 'int'),

# class PySide2.QtGui.QOpenGLContext:

# class PySide2.QtGui.QOpenGLContext.OpenGLModuleType:
    "PySide2.QtGui.QOpenGLContext.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtGui.QOpenGLContext.areSharing": ('PySide2.QtGui.QOpenGLContext', 'PySide2.QtGui.QOpenGLContext'),
    "PySide2.QtGui.QOpenGLContext.create": (),
    "PySide2.QtGui.QOpenGLContext.currentContext": (),
    "PySide2.QtGui.QOpenGLContext.defaultFramebufferObject": (),
    "PySide2.QtGui.QOpenGLContext.doneCurrent": (),
    "PySide2.QtGui.QOpenGLContext.extensions": (),
    "PySide2.QtGui.QOpenGLContext.extraFunctions": (),
    "PySide2.QtGui.QOpenGLContext.format": (),
    "PySide2.QtGui.QOpenGLContext.functions": (),
    "PySide2.QtGui.QOpenGLContext.globalShareContext": (),
    "PySide2.QtGui.QOpenGLContext.hasExtension": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtGui.QOpenGLContext.isOpenGLES": (),
    "PySide2.QtGui.QOpenGLContext.isValid": (),
    "PySide2.QtGui.QOpenGLContext.makeCurrent": ('PySide2.QtGui.QSurface',),
    "PySide2.QtGui.QOpenGLContext.nativeHandle": (),
    "PySide2.QtGui.QOpenGLContext.openGLModuleHandle": (),
    "PySide2.QtGui.QOpenGLContext.openGLModuleType": (),
    "PySide2.QtGui.QOpenGLContext.screen": (),
    "PySide2.QtGui.QOpenGLContext.setFormat": ('PySide2.QtGui.QSurfaceFormat',),
    "PySide2.QtGui.QOpenGLContext.setNativeHandle": ('typing.Any',),
    "PySide2.QtGui.QOpenGLContext.setScreen": ('PySide2.QtGui.QScreen',),
    "PySide2.QtGui.QOpenGLContext.setShareContext": ('PySide2.QtGui.QOpenGLContext',),
    "PySide2.QtGui.QOpenGLContext.shareContext": (),
    "PySide2.QtGui.QOpenGLContext.shareGroup": (),
    "PySide2.QtGui.QOpenGLContext.supportsThreadedOpenGL": (),
    "PySide2.QtGui.QOpenGLContext.surface": (),
    "PySide2.QtGui.QOpenGLContext.swapBuffers": ('PySide2.QtGui.QSurface',),
    "PySide2.QtGui.QOpenGLContext.versionFunctions": ('PySide2.QtGui.QOpenGLVersionProfile',),

# class PySide2.QtGui.QOpenGLContextGroup:
    "PySide2.QtGui.QOpenGLContextGroup.currentContextGroup": (),
    "PySide2.QtGui.QOpenGLContextGroup.shares": (),

# class PySide2.QtGui.QOpenGLDebugLogger:

# class PySide2.QtGui.QOpenGLDebugLogger.LoggingMode:
    "PySide2.QtGui.QOpenGLDebugLogger.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtGui.QOpenGLDebugLogger.disableMessages": [('PySide2.QtGui.QOpenGLDebugMessage.Sources', 'PySide2.QtGui.QOpenGLDebugMessage.Types', 'PySide2.QtGui.QOpenGLDebugMessage.Severities'), ('typing.List', 'PySide2.QtGui.QOpenGLDebugMessage.Sources', 'PySide2.QtGui.QOpenGLDebugMessage.Types')],
    "PySide2.QtGui.QOpenGLDebugLogger.enableMessages": [('PySide2.QtGui.QOpenGLDebugMessage.Sources', 'PySide2.QtGui.QOpenGLDebugMessage.Types', 'PySide2.QtGui.QOpenGLDebugMessage.Severities'), ('typing.List', 'PySide2.QtGui.QOpenGLDebugMessage.Sources', 'PySide2.QtGui.QOpenGLDebugMessage.Types')],
    "PySide2.QtGui.QOpenGLDebugLogger.initialize": (),
    "PySide2.QtGui.QOpenGLDebugLogger.isLogging": (),
    "PySide2.QtGui.QOpenGLDebugLogger.logMessage": ('PySide2.QtGui.QOpenGLDebugMessage',),
    "PySide2.QtGui.QOpenGLDebugLogger.loggedMessages": (),
    "PySide2.QtGui.QOpenGLDebugLogger.loggingMode": (),
    "PySide2.QtGui.QOpenGLDebugLogger.maximumMessageLength": (),
    "PySide2.QtGui.QOpenGLDebugLogger.popGroup": (),
    "PySide2.QtGui.QOpenGLDebugLogger.pushGroup": ('str', 'int', 'PySide2.QtGui.QOpenGLDebugMessage.Source'),
    "PySide2.QtGui.QOpenGLDebugLogger.startLogging": ('PySide2.QtGui.QOpenGLDebugLogger.LoggingMode',),
    "PySide2.QtGui.QOpenGLDebugLogger.stopLogging": (),

# class PySide2.QtGui.QOpenGLDebugMessage:

# class PySide2.QtGui.QOpenGLDebugMessage.Severities:

# class PySide2.QtGui.QOpenGLDebugMessage.Severity:

# class PySide2.QtGui.QOpenGLDebugMessage.Source:

# class PySide2.QtGui.QOpenGLDebugMessage.Sources:

# class PySide2.QtGui.QOpenGLDebugMessage.Type:

# class PySide2.QtGui.QOpenGLDebugMessage.Types:
    "PySide2.QtGui.QOpenGLDebugMessage.__init__": [(), ('PySide2.QtGui.QOpenGLDebugMessage',)],
    "PySide2.QtGui.QOpenGLDebugMessage.__copy__": (),
    "PySide2.QtGui.QOpenGLDebugMessage.createApplicationMessage": ('str', 'int', 'PySide2.QtGui.QOpenGLDebugMessage.Severity', 'PySide2.QtGui.QOpenGLDebugMessage.Type'),
    "PySide2.QtGui.QOpenGLDebugMessage.createThirdPartyMessage": ('str', 'int', 'PySide2.QtGui.QOpenGLDebugMessage.Severity', 'PySide2.QtGui.QOpenGLDebugMessage.Type'),
    "PySide2.QtGui.QOpenGLDebugMessage.id": (),
    "PySide2.QtGui.QOpenGLDebugMessage.message": (),
    "PySide2.QtGui.QOpenGLDebugMessage.severity": (),
    "PySide2.QtGui.QOpenGLDebugMessage.source": (),
    "PySide2.QtGui.QOpenGLDebugMessage.swap": ('PySide2.QtGui.QOpenGLDebugMessage',),
    "PySide2.QtGui.QOpenGLDebugMessage.type": (),

# class PySide2.QtGui.QOpenGLExtraFunctions:
    "PySide2.QtGui.QOpenGLExtraFunctions.__init__": [(), ('PySide2.QtGui.QOpenGLContext',)],
    "PySide2.QtGui.QOpenGLExtraFunctions.glActiveShaderProgram": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glBeginQuery": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glBeginTransformFeedback": ('int',),
    "PySide2.QtGui.QOpenGLExtraFunctions.glBindBufferBase": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glBindImageTexture": ('int', 'int', 'int', 'typing.Char', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glBindProgramPipeline": ('int',),
    "PySide2.QtGui.QOpenGLExtraFunctions.glBindSampler": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glBindTransformFeedback": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glBindVertexArray": ('int',),
    "PySide2.QtGui.QOpenGLExtraFunctions.glBlendBarrier": (),
    "PySide2.QtGui.QOpenGLExtraFunctions.glBlendEquationSeparatei": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glBlendEquationi": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glBlendFuncSeparatei": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glBlendFunci": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glBlitFramebuffer": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glClearBufferfi": ('int', 'int', 'float', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glClearBufferfv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glClearBufferiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glClearBufferuiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glColorMaski": ('int', 'typing.Char', 'typing.Char', 'typing.Char', 'typing.Char'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glCompressedTexImage3D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glCompressedTexSubImage3D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glCopyImageSubData": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glCopyTexSubImage3D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDebugMessageControl": ('int', 'int', 'int', 'int', 'typing.Sequence', 'typing.Char'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDebugMessageInsert": ('int', 'int', 'int', 'int', 'int', 'bytes'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDeleteProgramPipelines": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDeleteQueries": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDeleteSamplers": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDeleteTransformFeedbacks": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDeleteVertexArrays": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDisablei": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDispatchCompute": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawArraysIndirect": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawArraysInstanced": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawBuffers": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawElementsBaseVertex": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawElementsIndirect": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawElementsInstanced": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawElementsInstancedBaseVertex": ('int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawRangeElements": ('int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glDrawRangeElementsBaseVertex": ('int', 'int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glEnablei": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glEndQuery": ('int',),
    "PySide2.QtGui.QOpenGLExtraFunctions.glFramebufferParameteri": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glFramebufferTexture": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glFramebufferTextureLayer": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGenProgramPipelines": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGenQueries": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGenSamplers": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGenTransformFeedbacks": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGenVertexArrays": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetActiveUniformBlockiv": ('int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetActiveUniformsiv": ('int', 'int', 'typing.Sequence', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetBufferParameteri64v": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetFragDataLocation": ('int', 'bytes'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetFramebufferParameteriv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetGraphicsResetStatus": (),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetInteger64i_v": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetInteger64v": ('int',),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetIntegeri_v": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetInternalformativ": ('int', 'int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetMultisamplefv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramBinary": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramInterfaceiv": ('int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramPipelineiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramResourceIndex": ('int', 'int', 'bytes'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramResourceLocation": ('int', 'int', 'bytes'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetProgramResourceiv": ('int', 'int', 'int', 'int', 'typing.Sequence', 'int', 'typing.Sequence', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetQueryObjectuiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetQueryiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetSamplerParameterIiv": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetSamplerParameterIuiv": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetSamplerParameterfv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetSamplerParameteriv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetStringi": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetTexLevelParameterfv": ('int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetTexLevelParameteriv": ('int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetTexParameterIiv": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetTexParameterIuiv": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetUniformBlockIndex": ('int', 'bytes'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetUniformuiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetVertexAttribIiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetVertexAttribIuiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetnUniformfv": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetnUniformiv": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glGetnUniformuiv": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glInvalidateFramebuffer": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glInvalidateSubFramebuffer": ('int', 'int', 'typing.Sequence', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glIsEnabledi": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glIsProgramPipeline": ('int',),
    "PySide2.QtGui.QOpenGLExtraFunctions.glIsQuery": ('int',),
    "PySide2.QtGui.QOpenGLExtraFunctions.glIsSampler": ('int',),
    "PySide2.QtGui.QOpenGLExtraFunctions.glIsTransformFeedback": ('int',),
    "PySide2.QtGui.QOpenGLExtraFunctions.glIsVertexArray": ('int',),
    "PySide2.QtGui.QOpenGLExtraFunctions.glMemoryBarrier": ('int',),
    "PySide2.QtGui.QOpenGLExtraFunctions.glMemoryBarrierByRegion": ('int',),
    "PySide2.QtGui.QOpenGLExtraFunctions.glMinSampleShading": ('float',),
    "PySide2.QtGui.QOpenGLExtraFunctions.glObjectLabel": ('int', 'int', 'int', 'bytes'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glObjectPtrLabel": ('int', 'int', 'bytes'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glPatchParameteri": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glPopDebugGroup": (),
    "PySide2.QtGui.QOpenGLExtraFunctions.glPrimitiveBoundingBox": ('float', 'float', 'float', 'float', 'float', 'float', 'float', 'float'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramBinary": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramParameteri": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1f": ('int', 'int', 'float'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1fv": ('int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1i": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1iv": ('int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1ui": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform1uiv": ('int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2f": ('int', 'int', 'float', 'float'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2fv": ('int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2i": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2iv": ('int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2ui": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform2uiv": ('int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3f": ('int', 'int', 'float', 'float', 'float'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3fv": ('int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3i": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3iv": ('int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3ui": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform3uiv": ('int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4f": ('int', 'int', 'float', 'float', 'float', 'float'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4fv": ('int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4i": ('int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4iv": ('int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4ui": ('int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniform4uiv": ('int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix2fv": ('int', 'int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix2x3fv": ('int', 'int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix2x4fv": ('int', 'int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix3fv": ('int', 'int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix3x2fv": ('int', 'int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix3x4fv": ('int', 'int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix4fv": ('int', 'int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix4x2fv": ('int', 'int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glProgramUniformMatrix4x3fv": ('int', 'int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glPushDebugGroup": ('int', 'int', 'int', 'bytes'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glReadBuffer": ('int',),
    "PySide2.QtGui.QOpenGLExtraFunctions.glReadnPixels": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glRenderbufferStorageMultisample": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glSampleMaski": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameterIiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameterIuiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameterf": ('int', 'int', 'float'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameterfv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameteri": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glSamplerParameteriv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexBuffer": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexImage3D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexParameterIiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexParameterIuiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexStorage2D": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexStorage2DMultisample": ('int', 'int', 'int', 'int', 'int', 'typing.Char'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexStorage3D": ('int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexStorage3DMultisample": ('int', 'int', 'int', 'int', 'int', 'int', 'typing.Char'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glTexSubImage3D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniform1ui": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniform1uiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniform2ui": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniform2uiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniform3ui": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniform3uiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniform4ui": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniform4uiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniformBlockBinding": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix2x3fv": ('int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix2x4fv": ('int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix3x2fv": ('int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix3x4fv": ('int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix4x2fv": ('int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glUniformMatrix4x3fv": ('int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glUnmapBuffer": ('int',),
    "PySide2.QtGui.QOpenGLExtraFunctions.glUseProgramStages": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glValidateProgramPipeline": ('int',),
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribBinding": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribDivisor": ('int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribFormat": ('int', 'int', 'int', 'typing.Char', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribI4i": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribI4iv": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribI4ui": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribI4uiv": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribIFormat": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexAttribIPointer": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLExtraFunctions.glVertexBindingDivisor": ('int', 'int'),

# class PySide2.QtGui.QOpenGLFramebufferObject:

# class PySide2.QtGui.QOpenGLFramebufferObject.Attachment:

# class PySide2.QtGui.QOpenGLFramebufferObject.FramebufferRestorePolicy:
    "PySide2.QtGui.QOpenGLFramebufferObject.__init__": [('PySide2.QtCore.QSize', 'PySide2.QtGui.QOpenGLFramebufferObject.Attachment', 'int', 'int'), ('PySide2.QtCore.QSize', 'PySide2.QtGui.QOpenGLFramebufferObjectFormat'), ('PySide2.QtCore.QSize', 'int'), ('int', 'int', 'PySide2.QtGui.QOpenGLFramebufferObject.Attachment', 'int', 'int'), ('int', 'int', 'PySide2.QtGui.QOpenGLFramebufferObjectFormat'), ('int', 'int', 'int')],
    "PySide2.QtGui.QOpenGLFramebufferObject.addColorAttachment": [('PySide2.QtCore.QSize', 'int'), ('int', 'int', 'int')],
    "PySide2.QtGui.QOpenGLFramebufferObject.attachment": (),
    "PySide2.QtGui.QOpenGLFramebufferObject.bind": (),
    "PySide2.QtGui.QOpenGLFramebufferObject.bindDefault": (),
    "PySide2.QtGui.QOpenGLFramebufferObject.blitFramebuffer": [('PySide2.QtGui.QOpenGLFramebufferObject', 'PySide2.QtCore.QRect', 'PySide2.QtGui.QOpenGLFramebufferObject', 'PySide2.QtCore.QRect', 'int', 'int'), ('PySide2.QtGui.QOpenGLFramebufferObject', 'PySide2.QtCore.QRect', 'PySide2.QtGui.QOpenGLFramebufferObject', 'PySide2.QtCore.QRect', 'int', 'int', 'int', 'int'), ('PySide2.QtGui.QOpenGLFramebufferObject', 'PySide2.QtCore.QRect', 'PySide2.QtGui.QOpenGLFramebufferObject', 'PySide2.QtCore.QRect', 'int', 'int', 'int', 'int', 'PySide2.QtGui.QOpenGLFramebufferObject.FramebufferRestorePolicy'), ('PySide2.QtGui.QOpenGLFramebufferObject', 'PySide2.QtGui.QOpenGLFramebufferObject', 'int', 'int')],
    "PySide2.QtGui.QOpenGLFramebufferObject.format": (),
    "PySide2.QtGui.QOpenGLFramebufferObject.handle": (),
    "PySide2.QtGui.QOpenGLFramebufferObject.hasOpenGLFramebufferBlit": (),
    "PySide2.QtGui.QOpenGLFramebufferObject.hasOpenGLFramebufferObjects": (),
    "PySide2.QtGui.QOpenGLFramebufferObject.height": (),
    "PySide2.QtGui.QOpenGLFramebufferObject.isBound": (),
    "PySide2.QtGui.QOpenGLFramebufferObject.isValid": (),
    "PySide2.QtGui.QOpenGLFramebufferObject.release": (),
    "PySide2.QtGui.QOpenGLFramebufferObject.setAttachment": ('PySide2.QtGui.QOpenGLFramebufferObject.Attachment',),
    "PySide2.QtGui.QOpenGLFramebufferObject.size": (),
    "PySide2.QtGui.QOpenGLFramebufferObject.sizes": (),
    "PySide2.QtGui.QOpenGLFramebufferObject.takeTexture": [(), ('int',)],
    "PySide2.QtGui.QOpenGLFramebufferObject.texture": (),
    "PySide2.QtGui.QOpenGLFramebufferObject.textures": (),
    "PySide2.QtGui.QOpenGLFramebufferObject.toImage": [(), ('bool',), ('bool', 'int')],
    "PySide2.QtGui.QOpenGLFramebufferObject.width": (),

# class PySide2.QtGui.QOpenGLFramebufferObjectFormat:
    "PySide2.QtGui.QOpenGLFramebufferObjectFormat.__init__": [(), ('PySide2.QtGui.QOpenGLFramebufferObjectFormat',)],
    "PySide2.QtGui.QOpenGLFramebufferObjectFormat.__copy__": (),
    "PySide2.QtGui.QOpenGLFramebufferObjectFormat.attachment": (),
    "PySide2.QtGui.QOpenGLFramebufferObjectFormat.internalTextureFormat": (),
    "PySide2.QtGui.QOpenGLFramebufferObjectFormat.mipmap": (),
    "PySide2.QtGui.QOpenGLFramebufferObjectFormat.samples": (),
    "PySide2.QtGui.QOpenGLFramebufferObjectFormat.setAttachment": ('PySide2.QtGui.QOpenGLFramebufferObject.Attachment',),
    "PySide2.QtGui.QOpenGLFramebufferObjectFormat.setInternalTextureFormat": ('int',),
    "PySide2.QtGui.QOpenGLFramebufferObjectFormat.setMipmap": ('bool',),
    "PySide2.QtGui.QOpenGLFramebufferObjectFormat.setSamples": ('int',),
    "PySide2.QtGui.QOpenGLFramebufferObjectFormat.setTextureTarget": ('int',),
    "PySide2.QtGui.QOpenGLFramebufferObjectFormat.textureTarget": (),

# class PySide2.QtGui.QOpenGLFunctions:

# class PySide2.QtGui.QOpenGLFunctions.OpenGLFeature:

# class PySide2.QtGui.QOpenGLFunctions.OpenGLFeatures:
    "PySide2.QtGui.QOpenGLFunctions.__init__": [(), ('PySide2.QtGui.QOpenGLContext',)],
    "PySide2.QtGui.QOpenGLFunctions.glActiveTexture": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glAttachShader": ('int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glBindAttribLocation": ('int', 'int', 'bytes'),
    "PySide2.QtGui.QOpenGLFunctions.glBindBuffer": ('int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glBindFramebuffer": ('int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glBindRenderbuffer": ('int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glBindTexture": ('int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glBlendColor": ('float', 'float', 'float', 'float'),
    "PySide2.QtGui.QOpenGLFunctions.glBlendEquation": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glBlendEquationSeparate": ('int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glBlendFunc": ('int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glBlendFuncSeparate": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glCheckFramebufferStatus": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glClear": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glClearColor": ('float', 'float', 'float', 'float'),
    "PySide2.QtGui.QOpenGLFunctions.glClearDepthf": ('float',),
    "PySide2.QtGui.QOpenGLFunctions.glClearStencil": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glColorMask": ('typing.Char', 'typing.Char', 'typing.Char', 'typing.Char'),
    "PySide2.QtGui.QOpenGLFunctions.glCompileShader": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glCompressedTexImage2D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glCompressedTexSubImage2D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glCopyTexImage2D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glCopyTexSubImage2D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glCreateProgram": (),
    "PySide2.QtGui.QOpenGLFunctions.glCreateShader": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glCullFace": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glDeleteBuffers": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glDeleteFramebuffers": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glDeleteProgram": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glDeleteRenderbuffers": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glDeleteShader": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glDeleteTextures": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glDepthFunc": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glDepthMask": ('typing.Char',),
    "PySide2.QtGui.QOpenGLFunctions.glDepthRangef": ('float', 'float'),
    "PySide2.QtGui.QOpenGLFunctions.glDetachShader": ('int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glDisable": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glDisableVertexAttribArray": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glDrawArrays": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glDrawElements": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glEnable": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glEnableVertexAttribArray": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glFinish": (),
    "PySide2.QtGui.QOpenGLFunctions.glFlush": (),
    "PySide2.QtGui.QOpenGLFunctions.glFramebufferRenderbuffer": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glFramebufferTexture2D": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glFrontFace": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glGenBuffers": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGenFramebuffers": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGenRenderbuffers": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGenTextures": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGenerateMipmap": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glGetAttachedShaders": ('int', 'int', 'typing.Sequence', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGetAttribLocation": ('int', 'bytes'),
    "PySide2.QtGui.QOpenGLFunctions.glGetBufferParameteriv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGetError": (),
    "PySide2.QtGui.QOpenGLFunctions.glGetFloatv": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGetFramebufferAttachmentParameteriv": ('int', 'int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGetIntegerv": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGetProgramiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGetRenderbufferParameteriv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGetShaderPrecisionFormat": ('int', 'int', 'typing.Sequence', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGetShaderiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGetString": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glGetTexParameterfv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGetTexParameteriv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGetUniformLocation": ('int', 'bytes'),
    "PySide2.QtGui.QOpenGLFunctions.glGetUniformfv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGetUniformiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGetVertexAttribfv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glGetVertexAttribiv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glHint": ('int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glIsBuffer": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glIsEnabled": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glIsFramebuffer": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glIsProgram": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glIsRenderbuffer": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glIsShader": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glIsTexture": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glLineWidth": ('float',),
    "PySide2.QtGui.QOpenGLFunctions.glLinkProgram": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glPixelStorei": ('int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glPolygonOffset": ('float', 'float'),
    "PySide2.QtGui.QOpenGLFunctions.glReadPixels": ('int', 'int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glReleaseShaderCompiler": (),
    "PySide2.QtGui.QOpenGLFunctions.glRenderbufferStorage": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glSampleCoverage": ('float', 'typing.Char'),
    "PySide2.QtGui.QOpenGLFunctions.glScissor": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glShaderBinary": ('int', 'typing.Sequence', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glStencilFunc": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glStencilFuncSeparate": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glStencilMask": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glStencilMaskSeparate": ('int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glStencilOp": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glStencilOpSeparate": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glTexImage2D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glTexParameterf": ('int', 'int', 'float'),
    "PySide2.QtGui.QOpenGLFunctions.glTexParameterfv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glTexParameteri": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glTexParameteriv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glTexSubImage2D": ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glUniform1f": ('int', 'float'),
    "PySide2.QtGui.QOpenGLFunctions.glUniform1fv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glUniform1i": ('int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glUniform1iv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glUniform2f": ('int', 'float', 'float'),
    "PySide2.QtGui.QOpenGLFunctions.glUniform2fv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glUniform2i": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glUniform2iv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glUniform3f": ('int', 'float', 'float', 'float'),
    "PySide2.QtGui.QOpenGLFunctions.glUniform3fv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glUniform3i": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glUniform3iv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glUniform4f": ('int', 'float', 'float', 'float', 'float'),
    "PySide2.QtGui.QOpenGLFunctions.glUniform4fv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glUniform4i": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glUniform4iv": ('int', 'int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glUniformMatrix2fv": ('int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glUniformMatrix3fv": ('int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glUniformMatrix4fv": ('int', 'int', 'typing.Char', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glUseProgram": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glValidateProgram": ('int',),
    "PySide2.QtGui.QOpenGLFunctions.glVertexAttrib1f": ('int', 'float'),
    "PySide2.QtGui.QOpenGLFunctions.glVertexAttrib1fv": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glVertexAttrib2f": ('int', 'float', 'float'),
    "PySide2.QtGui.QOpenGLFunctions.glVertexAttrib2fv": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glVertexAttrib3f": ('int', 'float', 'float', 'float'),
    "PySide2.QtGui.QOpenGLFunctions.glVertexAttrib3fv": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glVertexAttrib4f": ('int', 'float', 'float', 'float', 'float'),
    "PySide2.QtGui.QOpenGLFunctions.glVertexAttrib4fv": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QOpenGLFunctions.glVertexAttribPointer": ('int', 'int', 'int', 'typing.Char', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.glViewport": ('int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLFunctions.hasOpenGLFeature": ('PySide2.QtGui.QOpenGLFunctions.OpenGLFeature',),
    "PySide2.QtGui.QOpenGLFunctions.initializeOpenGLFunctions": (),
    "PySide2.QtGui.QOpenGLFunctions.openGLFeatures": (),

# class PySide2.QtGui.QOpenGLPixelTransferOptions:
    "PySide2.QtGui.QOpenGLPixelTransferOptions.__init__": [(), ('PySide2.QtGui.QOpenGLPixelTransferOptions',)],
    "PySide2.QtGui.QOpenGLPixelTransferOptions.__copy__": (),
    "PySide2.QtGui.QOpenGLPixelTransferOptions.alignment": (),
    "PySide2.QtGui.QOpenGLPixelTransferOptions.imageHeight": (),
    "PySide2.QtGui.QOpenGLPixelTransferOptions.isLeastSignificantBitFirst": (),
    "PySide2.QtGui.QOpenGLPixelTransferOptions.isSwapBytesEnabled": (),
    "PySide2.QtGui.QOpenGLPixelTransferOptions.rowLength": (),
    "PySide2.QtGui.QOpenGLPixelTransferOptions.setAlignment": ('int',),
    "PySide2.QtGui.QOpenGLPixelTransferOptions.setImageHeight": ('int',),
    "PySide2.QtGui.QOpenGLPixelTransferOptions.setLeastSignificantByteFirst": ('bool',),
    "PySide2.QtGui.QOpenGLPixelTransferOptions.setRowLength": ('int',),
    "PySide2.QtGui.QOpenGLPixelTransferOptions.setSkipImages": ('int',),
    "PySide2.QtGui.QOpenGLPixelTransferOptions.setSkipPixels": ('int',),
    "PySide2.QtGui.QOpenGLPixelTransferOptions.setSkipRows": ('int',),
    "PySide2.QtGui.QOpenGLPixelTransferOptions.setSwapBytesEnabled": ('bool',),
    "PySide2.QtGui.QOpenGLPixelTransferOptions.skipImages": (),
    "PySide2.QtGui.QOpenGLPixelTransferOptions.skipPixels": (),
    "PySide2.QtGui.QOpenGLPixelTransferOptions.skipRows": (),
    "PySide2.QtGui.QOpenGLPixelTransferOptions.swap": ('PySide2.QtGui.QOpenGLPixelTransferOptions',),

# class PySide2.QtGui.QOpenGLShader:

# class PySide2.QtGui.QOpenGLShader.ShaderType:

# class PySide2.QtGui.QOpenGLShader.ShaderTypeBit:
    "PySide2.QtGui.QOpenGLShader.__init__": ('PySide2.QtGui.QOpenGLShader.ShaderType', 'PySide2.QtCore.QObject'),
    "PySide2.QtGui.QOpenGLShader.compileSourceCode": [('PySide2.QtCore.QByteArray',), ('bytes',), ('str',)],
    "PySide2.QtGui.QOpenGLShader.compileSourceFile": ('str',),
    "PySide2.QtGui.QOpenGLShader.hasOpenGLShaders": ('PySide2.QtGui.QOpenGLShader.ShaderType', 'PySide2.QtGui.QOpenGLContext'),
    "PySide2.QtGui.QOpenGLShader.isCompiled": (),
    "PySide2.QtGui.QOpenGLShader.log": (),
    "PySide2.QtGui.QOpenGLShader.shaderId": (),
    "PySide2.QtGui.QOpenGLShader.shaderType": (),
    "PySide2.QtGui.QOpenGLShader.sourceCode": (),

# class PySide2.QtGui.QOpenGLShaderProgram:
    "PySide2.QtGui.QOpenGLShaderProgram.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtGui.QOpenGLShaderProgram.addCacheableShaderFromSourceCode": [('PySide2.QtGui.QOpenGLShader.ShaderType', 'PySide2.QtCore.QByteArray'), ('PySide2.QtGui.QOpenGLShader.ShaderType', 'bytes'), ('PySide2.QtGui.QOpenGLShader.ShaderType', 'str')],
    "PySide2.QtGui.QOpenGLShaderProgram.addCacheableShaderFromSourceFile": ('PySide2.QtGui.QOpenGLShader.ShaderType', 'str'),
    "PySide2.QtGui.QOpenGLShaderProgram.addShader": ('PySide2.QtGui.QOpenGLShader',),
    "PySide2.QtGui.QOpenGLShaderProgram.addShaderFromSourceCode": [('PySide2.QtGui.QOpenGLShader.ShaderType', 'PySide2.QtCore.QByteArray'), ('PySide2.QtGui.QOpenGLShader.ShaderType', 'bytes'), ('PySide2.QtGui.QOpenGLShader.ShaderType', 'str')],
    "PySide2.QtGui.QOpenGLShaderProgram.addShaderFromSourceFile": ('PySide2.QtGui.QOpenGLShader.ShaderType', 'str'),
    "PySide2.QtGui.QOpenGLShaderProgram.attributeLocation": [('PySide2.QtCore.QByteArray',), ('bytes',), ('str',)],
    "PySide2.QtGui.QOpenGLShaderProgram.bind": (),
    "PySide2.QtGui.QOpenGLShaderProgram.bindAttributeLocation": [('PySide2.QtCore.QByteArray', 'int'), ('bytes', 'int'), ('str', 'int')],
    "PySide2.QtGui.QOpenGLShaderProgram.create": (),
    "PySide2.QtGui.QOpenGLShaderProgram.defaultInnerTessellationLevels": (),
    "PySide2.QtGui.QOpenGLShaderProgram.defaultOuterTessellationLevels": (),
    "PySide2.QtGui.QOpenGLShaderProgram.disableAttributeArray": [('bytes',), ('int',)],
    "PySide2.QtGui.QOpenGLShaderProgram.enableAttributeArray": [('bytes',), ('int',)],
    "PySide2.QtGui.QOpenGLShaderProgram.hasOpenGLShaderPrograms": ('PySide2.QtGui.QOpenGLContext',),
    "PySide2.QtGui.QOpenGLShaderProgram.isLinked": (),
    "PySide2.QtGui.QOpenGLShaderProgram.link": (),
    "PySide2.QtGui.QOpenGLShaderProgram.log": (),
    "PySide2.QtGui.QOpenGLShaderProgram.maxGeometryOutputVertices": (),
    "PySide2.QtGui.QOpenGLShaderProgram.patchVertexCount": (),
    "PySide2.QtGui.QOpenGLShaderProgram.programId": (),
    "PySide2.QtGui.QOpenGLShaderProgram.release": (),
    "PySide2.QtGui.QOpenGLShaderProgram.removeAllShaders": (),
    "PySide2.QtGui.QOpenGLShaderProgram.removeShader": ('PySide2.QtGui.QOpenGLShader',),
    "PySide2.QtGui.QOpenGLShaderProgram.setAttributeArray": [('bytes', 'int', 'int', 'int', 'int'), ('bytes', 'typing.Sequence', 'int', 'int'), ('int', 'int', 'int', 'int', 'int'), ('int', 'typing.Sequence', 'int', 'int')],
    "PySide2.QtGui.QOpenGLShaderProgram.setAttributeBuffer": [('bytes', 'int', 'int', 'int', 'int'), ('int', 'int', 'int', 'int', 'int')],
    "PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue": [('bytes', 'PySide2.QtGui.QColor'), ('bytes', 'PySide2.QtGui.QVector2D'), ('bytes', 'PySide2.QtGui.QVector3D'), ('bytes', 'PySide2.QtGui.QVector4D'), ('bytes', 'float'), ('bytes', 'float', 'float'), ('bytes', 'float', 'float', 'float'), ('bytes', 'float', 'float', 'float', 'float'), ('bytes', 'typing.Sequence', 'int', 'int'), ('int', 'PySide2.QtGui.QColor'), ('int', 'PySide2.QtGui.QVector2D'), ('int', 'PySide2.QtGui.QVector3D'), ('int', 'PySide2.QtGui.QVector4D'), ('int', 'float'), ('int', 'float', 'float'), ('int', 'float', 'float', 'float'), ('int', 'float', 'float', 'float', 'float'), ('int', 'typing.Sequence', 'int', 'int')],
    "PySide2.QtGui.QOpenGLShaderProgram.setDefaultInnerTessellationLevels": ('typing.List',),
    "PySide2.QtGui.QOpenGLShaderProgram.setDefaultOuterTessellationLevels": ('typing.List',),
    "PySide2.QtGui.QOpenGLShaderProgram.setPatchVertexCount": ('int',),
    "PySide2.QtGui.QOpenGLShaderProgram.setUniformValue": [('bytes', 'PySide2.QtCore.QPoint'), ('bytes', 'PySide2.QtCore.QPointF'), ('bytes', 'PySide2.QtCore.QSize'), ('bytes', 'PySide2.QtCore.QSizeF'), ('bytes', 'PySide2.QtGui.QColor'), ('bytes', 'PySide2.QtGui.QMatrix2x2'), ('bytes', 'PySide2.QtGui.QMatrix2x3'), ('bytes', 'PySide2.QtGui.QMatrix2x4'), ('bytes', 'PySide2.QtGui.QMatrix3x2'), ('bytes', 'PySide2.QtGui.QMatrix3x3'), ('bytes', 'PySide2.QtGui.QMatrix3x4'), ('bytes', 'PySide2.QtGui.QMatrix4x2'), ('bytes', 'PySide2.QtGui.QMatrix4x3'), ('bytes', 'PySide2.QtGui.QMatrix4x4'), ('bytes', 'PySide2.QtGui.QTransform'), ('bytes', 'PySide2.QtGui.QVector2D'), ('bytes', 'PySide2.QtGui.QVector3D'), ('bytes', 'PySide2.QtGui.QVector4D'), ('bytes', 'float', 'float'), ('bytes', 'float', 'float', 'float'), ('bytes', 'float', 'float', 'float', 'float'), ('bytes', 'typing.Tuple'), ('int', 'PySide2.QtCore.QPoint'), ('int', 'PySide2.QtCore.QPointF'), ('int', 'PySide2.QtCore.QSize'), ('int', 'PySide2.QtCore.QSizeF'), ('int', 'PySide2.QtGui.QColor'), ('int', 'PySide2.QtGui.QMatrix2x2'), ('int', 'PySide2.QtGui.QMatrix2x3'), ('int', 'PySide2.QtGui.QMatrix2x4'), ('int', 'PySide2.QtGui.QMatrix3x2'), ('int', 'PySide2.QtGui.QMatrix3x3'), ('int', 'PySide2.QtGui.QMatrix3x4'), ('int', 'PySide2.QtGui.QMatrix4x2'), ('int', 'PySide2.QtGui.QMatrix4x3'), ('int', 'PySide2.QtGui.QMatrix4x4'), ('int', 'PySide2.QtGui.QTransform'), ('int', 'PySide2.QtGui.QVector2D'), ('int', 'PySide2.QtGui.QVector3D'), ('int', 'PySide2.QtGui.QVector4D'), ('int', 'float'), ('int', 'float', 'float'), ('int', 'float', 'float', 'float'), ('int', 'float', 'float', 'float', 'float'), ('int', 'int'), ('int', 'typing.Tuple')],
    "PySide2.QtGui.QOpenGLShaderProgram.setUniformValue1f": [('bytes', 'float'), ('int', 'float')],
    "PySide2.QtGui.QOpenGLShaderProgram.setUniformValue1i": [('bytes', 'int'), ('int', 'int')],
    "PySide2.QtGui.QOpenGLShaderProgram.setUniformValueArray": [('bytes', 'typing.Sequence', 'int'), ('bytes', 'typing.Sequence', 'int', 'int'), ('int', 'typing.Sequence', 'int'), ('int', 'typing.Sequence', 'int', 'int')],
    "PySide2.QtGui.QOpenGLShaderProgram.shaders": (),
    "PySide2.QtGui.QOpenGLShaderProgram.uniformLocation": [('PySide2.QtCore.QByteArray',), ('bytes',), ('str',)],

# class PySide2.QtGui.QOpenGLTexture:

# class PySide2.QtGui.QOpenGLTexture.BindingTarget:

# class PySide2.QtGui.QOpenGLTexture.ComparisonFunction:

# class PySide2.QtGui.QOpenGLTexture.ComparisonMode:

# class PySide2.QtGui.QOpenGLTexture.CoordinateDirection:

# class PySide2.QtGui.QOpenGLTexture.CubeMapFace:

# class PySide2.QtGui.QOpenGLTexture.DepthStencilMode:

# class PySide2.QtGui.QOpenGLTexture.Feature:

# class PySide2.QtGui.QOpenGLTexture.Features:

# class PySide2.QtGui.QOpenGLTexture.Filter:

# class PySide2.QtGui.QOpenGLTexture.MipMapGeneration:

# class PySide2.QtGui.QOpenGLTexture.PixelFormat:

# class PySide2.QtGui.QOpenGLTexture.PixelType:

# class PySide2.QtGui.QOpenGLTexture.SwizzleComponent:

# class PySide2.QtGui.QOpenGLTexture.SwizzleValue:

# class PySide2.QtGui.QOpenGLTexture.Target:

# class PySide2.QtGui.QOpenGLTexture.TextureFormat:

# class PySide2.QtGui.QOpenGLTexture.TextureFormatClass:

# class PySide2.QtGui.QOpenGLTexture.TextureUnitReset:

# class PySide2.QtGui.QOpenGLTexture.WrapMode:
    "PySide2.QtGui.QOpenGLTexture.__init__": [('PySide2.QtGui.QImage', 'PySide2.QtGui.QOpenGLTexture.MipMapGeneration'), ('PySide2.QtGui.QOpenGLTexture.Target',)],
    "PySide2.QtGui.QOpenGLTexture.allocateStorage": [(), ('PySide2.QtGui.QOpenGLTexture.PixelFormat', 'PySide2.QtGui.QOpenGLTexture.PixelType')],
    "PySide2.QtGui.QOpenGLTexture.bind": [(), ('int', 'PySide2.QtGui.QOpenGLTexture.TextureUnitReset')],
    "PySide2.QtGui.QOpenGLTexture.borderColor": (),
    "PySide2.QtGui.QOpenGLTexture.boundTextureId": [('PySide2.QtGui.QOpenGLTexture.BindingTarget',), ('int', 'PySide2.QtGui.QOpenGLTexture.BindingTarget')],
    "PySide2.QtGui.QOpenGLTexture.comparisonFunction": (),
    "PySide2.QtGui.QOpenGLTexture.comparisonMode": (),
    "PySide2.QtGui.QOpenGLTexture.create": (),
    "PySide2.QtGui.QOpenGLTexture.createTextureView": ('PySide2.QtGui.QOpenGLTexture.Target', 'PySide2.QtGui.QOpenGLTexture.TextureFormat', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLTexture.depth": (),
    "PySide2.QtGui.QOpenGLTexture.depthStencilMode": (),
    "PySide2.QtGui.QOpenGLTexture.destroy": (),
    "PySide2.QtGui.QOpenGLTexture.faces": (),
    "PySide2.QtGui.QOpenGLTexture.format": (),
    "PySide2.QtGui.QOpenGLTexture.generateMipMaps": [(), ('int', 'bool')],
    "PySide2.QtGui.QOpenGLTexture.hasFeature": ('PySide2.QtGui.QOpenGLTexture.Feature',),
    "PySide2.QtGui.QOpenGLTexture.height": (),
    "PySide2.QtGui.QOpenGLTexture.isAutoMipMapGenerationEnabled": (),
    "PySide2.QtGui.QOpenGLTexture.isBound": [(), ('int',)],
    "PySide2.QtGui.QOpenGLTexture.isCreated": (),
    "PySide2.QtGui.QOpenGLTexture.isFixedSamplePositions": (),
    "PySide2.QtGui.QOpenGLTexture.isStorageAllocated": (),
    "PySide2.QtGui.QOpenGLTexture.isTextureView": (),
    "PySide2.QtGui.QOpenGLTexture.layers": (),
    "PySide2.QtGui.QOpenGLTexture.levelOfDetailRange": (),
    "PySide2.QtGui.QOpenGLTexture.levelofDetailBias": (),
    "PySide2.QtGui.QOpenGLTexture.magnificationFilter": (),
    "PySide2.QtGui.QOpenGLTexture.maximumAnisotropy": (),
    "PySide2.QtGui.QOpenGLTexture.maximumLevelOfDetail": (),
    "PySide2.QtGui.QOpenGLTexture.maximumMipLevels": (),
    "PySide2.QtGui.QOpenGLTexture.minMagFilters": (),
    "PySide2.QtGui.QOpenGLTexture.minificationFilter": (),
    "PySide2.QtGui.QOpenGLTexture.minimumLevelOfDetail": (),
    "PySide2.QtGui.QOpenGLTexture.mipBaseLevel": (),
    "PySide2.QtGui.QOpenGLTexture.mipLevelRange": (),
    "PySide2.QtGui.QOpenGLTexture.mipLevels": (),
    "PySide2.QtGui.QOpenGLTexture.mipMaxLevel": (),
    "PySide2.QtGui.QOpenGLTexture.release": [(), ('int', 'PySide2.QtGui.QOpenGLTexture.TextureUnitReset')],
    "PySide2.QtGui.QOpenGLTexture.samples": (),
    "PySide2.QtGui.QOpenGLTexture.setAutoMipMapGenerationEnabled": ('bool',),
    "PySide2.QtGui.QOpenGLTexture.setBorderColor": [('PySide2.QtGui.QColor',), ('float', 'float', 'float', 'float'), ('int', 'int', 'int', 'int')],
    "PySide2.QtGui.QOpenGLTexture.setComparisonFunction": ('PySide2.QtGui.QOpenGLTexture.ComparisonFunction',),
    "PySide2.QtGui.QOpenGLTexture.setComparisonMode": ('PySide2.QtGui.QOpenGLTexture.ComparisonMode',),
    "PySide2.QtGui.QOpenGLTexture.setCompressedData": [('int', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'PySide2.QtGui.QOpenGLTexture.CubeMapFace', 'int', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'int', 'PySide2.QtGui.QOpenGLTexture.CubeMapFace', 'int', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'int', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions')],
    "PySide2.QtGui.QOpenGLTexture.setData": [('PySide2.QtGui.QImage', 'PySide2.QtGui.QOpenGLTexture.MipMapGeneration'), ('PySide2.QtGui.QOpenGLTexture.PixelFormat', 'PySide2.QtGui.QOpenGLTexture.PixelType', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'PySide2.QtGui.QOpenGLTexture.PixelFormat', 'PySide2.QtGui.QOpenGLTexture.PixelType', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'PySide2.QtGui.QOpenGLTexture.CubeMapFace', 'PySide2.QtGui.QOpenGLTexture.PixelFormat', 'PySide2.QtGui.QOpenGLTexture.PixelType', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'PySide2.QtGui.QOpenGLTexture.PixelFormat', 'PySide2.QtGui.QOpenGLTexture.PixelType', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'int', 'PySide2.QtGui.QOpenGLTexture.CubeMapFace', 'PySide2.QtGui.QOpenGLTexture.PixelFormat', 'PySide2.QtGui.QOpenGLTexture.PixelType', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'int', 'int', 'int', 'int', 'PySide2.QtGui.QOpenGLTexture.PixelFormat', 'PySide2.QtGui.QOpenGLTexture.PixelType', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'PySide2.QtGui.QOpenGLTexture.CubeMapFace', 'PySide2.QtGui.QOpenGLTexture.PixelFormat', 'PySide2.QtGui.QOpenGLTexture.PixelType', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'PySide2.QtGui.QOpenGLTexture.CubeMapFace', 'int', 'PySide2.QtGui.QOpenGLTexture.PixelFormat', 'PySide2.QtGui.QOpenGLTexture.PixelType', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions'), ('int', 'int', 'int', 'int', 'int', 'int', 'int', 'int', 'PySide2.QtGui.QOpenGLTexture.PixelFormat', 'PySide2.QtGui.QOpenGLTexture.PixelType', 'int', 'PySide2.QtGui.QOpenGLPixelTransferOptions')],
    "PySide2.QtGui.QOpenGLTexture.setDepthStencilMode": ('PySide2.QtGui.QOpenGLTexture.DepthStencilMode',),
    "PySide2.QtGui.QOpenGLTexture.setFixedSamplePositions": ('bool',),
    "PySide2.QtGui.QOpenGLTexture.setFormat": ('PySide2.QtGui.QOpenGLTexture.TextureFormat',),
    "PySide2.QtGui.QOpenGLTexture.setLayers": ('int',),
    "PySide2.QtGui.QOpenGLTexture.setLevelOfDetailRange": ('float', 'float'),
    "PySide2.QtGui.QOpenGLTexture.setLevelofDetailBias": ('float',),
    "PySide2.QtGui.QOpenGLTexture.setMagnificationFilter": ('PySide2.QtGui.QOpenGLTexture.Filter',),
    "PySide2.QtGui.QOpenGLTexture.setMaximumAnisotropy": ('float',),
    "PySide2.QtGui.QOpenGLTexture.setMaximumLevelOfDetail": ('float',),
    "PySide2.QtGui.QOpenGLTexture.setMinMagFilters": ('PySide2.QtGui.QOpenGLTexture.Filter', 'PySide2.QtGui.QOpenGLTexture.Filter'),
    "PySide2.QtGui.QOpenGLTexture.setMinificationFilter": ('PySide2.QtGui.QOpenGLTexture.Filter',),
    "PySide2.QtGui.QOpenGLTexture.setMinimumLevelOfDetail": ('float',),
    "PySide2.QtGui.QOpenGLTexture.setMipBaseLevel": ('int',),
    "PySide2.QtGui.QOpenGLTexture.setMipLevelRange": ('int', 'int'),
    "PySide2.QtGui.QOpenGLTexture.setMipLevels": ('int',),
    "PySide2.QtGui.QOpenGLTexture.setMipMaxLevel": ('int',),
    "PySide2.QtGui.QOpenGLTexture.setSamples": ('int',),
    "PySide2.QtGui.QOpenGLTexture.setSize": ('int', 'int', 'int'),
    "PySide2.QtGui.QOpenGLTexture.setSwizzleMask": [('PySide2.QtGui.QOpenGLTexture.SwizzleComponent', 'PySide2.QtGui.QOpenGLTexture.SwizzleValue'), ('PySide2.QtGui.QOpenGLTexture.SwizzleValue', 'PySide2.QtGui.QOpenGLTexture.SwizzleValue', 'PySide2.QtGui.QOpenGLTexture.SwizzleValue', 'PySide2.QtGui.QOpenGLTexture.SwizzleValue')],
    "PySide2.QtGui.QOpenGLTexture.setWrapMode": [('PySide2.QtGui.QOpenGLTexture.CoordinateDirection', 'PySide2.QtGui.QOpenGLTexture.WrapMode'), ('PySide2.QtGui.QOpenGLTexture.WrapMode',)],
    "PySide2.QtGui.QOpenGLTexture.swizzleMask": ('PySide2.QtGui.QOpenGLTexture.SwizzleComponent',),
    "PySide2.QtGui.QOpenGLTexture.target": (),
    "PySide2.QtGui.QOpenGLTexture.textureId": (),
    "PySide2.QtGui.QOpenGLTexture.width": (),
    "PySide2.QtGui.QOpenGLTexture.wrapMode": ('PySide2.QtGui.QOpenGLTexture.CoordinateDirection',),

# class PySide2.QtGui.QOpenGLTextureBlitter:

# class PySide2.QtGui.QOpenGLTextureBlitter.Origin:
    "PySide2.QtGui.QOpenGLTextureBlitter.__init__": (),
    "PySide2.QtGui.QOpenGLTextureBlitter.bind": ('int',),
    "PySide2.QtGui.QOpenGLTextureBlitter.blit": [('int', 'PySide2.QtGui.QMatrix4x4', 'PySide2.QtGui.QMatrix3x3'), ('int', 'PySide2.QtGui.QMatrix4x4', 'PySide2.QtGui.QOpenGLTextureBlitter.Origin')],
    "PySide2.QtGui.QOpenGLTextureBlitter.create": (),
    "PySide2.QtGui.QOpenGLTextureBlitter.destroy": (),
    "PySide2.QtGui.QOpenGLTextureBlitter.isCreated": (),
    "PySide2.QtGui.QOpenGLTextureBlitter.release": (),
    "PySide2.QtGui.QOpenGLTextureBlitter.setOpacity": ('float',),
    "PySide2.QtGui.QOpenGLTextureBlitter.setRedBlueSwizzle": ('bool',),
    "PySide2.QtGui.QOpenGLTextureBlitter.sourceTransform": ('PySide2.QtCore.QRectF', 'PySide2.QtCore.QSize', 'PySide2.QtGui.QOpenGLTextureBlitter.Origin'),
    "PySide2.QtGui.QOpenGLTextureBlitter.supportsExternalOESTarget": (),
    "PySide2.QtGui.QOpenGLTextureBlitter.targetTransform": ('PySide2.QtCore.QRectF', 'PySide2.QtCore.QRect'),

# class PySide2.QtGui.QOpenGLTimeMonitor:
    "PySide2.QtGui.QOpenGLTimeMonitor.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtGui.QOpenGLTimeMonitor.create": (),
    "PySide2.QtGui.QOpenGLTimeMonitor.destroy": (),
    "PySide2.QtGui.QOpenGLTimeMonitor.isCreated": (),
    "PySide2.QtGui.QOpenGLTimeMonitor.isResultAvailable": (),
    "PySide2.QtGui.QOpenGLTimeMonitor.objectIds": (),
    "PySide2.QtGui.QOpenGLTimeMonitor.recordSample": (),
    "PySide2.QtGui.QOpenGLTimeMonitor.reset": (),
    "PySide2.QtGui.QOpenGLTimeMonitor.sampleCount": (),
    "PySide2.QtGui.QOpenGLTimeMonitor.setSampleCount": ('int',),
    "PySide2.QtGui.QOpenGLTimeMonitor.waitForIntervals": (),
    "PySide2.QtGui.QOpenGLTimeMonitor.waitForSamples": (),

# class PySide2.QtGui.QOpenGLTimerQuery:
    "PySide2.QtGui.QOpenGLTimerQuery.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtGui.QOpenGLTimerQuery.begin": (),
    "PySide2.QtGui.QOpenGLTimerQuery.create": (),
    "PySide2.QtGui.QOpenGLTimerQuery.destroy": (),
    "PySide2.QtGui.QOpenGLTimerQuery.end": (),
    "PySide2.QtGui.QOpenGLTimerQuery.isCreated": (),
    "PySide2.QtGui.QOpenGLTimerQuery.isResultAvailable": (),
    "PySide2.QtGui.QOpenGLTimerQuery.objectId": (),
    "PySide2.QtGui.QOpenGLTimerQuery.recordTimestamp": (),
    "PySide2.QtGui.QOpenGLTimerQuery.waitForResult": (),
    "PySide2.QtGui.QOpenGLTimerQuery.waitForTimestamp": (),

# class PySide2.QtGui.QOpenGLVersionProfile:
    "PySide2.QtGui.QOpenGLVersionProfile.__init__": [(), ('PySide2.QtGui.QOpenGLVersionProfile',), ('PySide2.QtGui.QSurfaceFormat',)],
    "PySide2.QtGui.QOpenGLVersionProfile.__copy__": (),
    "PySide2.QtGui.QOpenGLVersionProfile.hasProfiles": (),
    "PySide2.QtGui.QOpenGLVersionProfile.isLegacyVersion": (),
    "PySide2.QtGui.QOpenGLVersionProfile.isValid": (),
    "PySide2.QtGui.QOpenGLVersionProfile.profile": (),
    "PySide2.QtGui.QOpenGLVersionProfile.setProfile": ('PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile',),
    "PySide2.QtGui.QOpenGLVersionProfile.setVersion": ('int', 'int'),
    "PySide2.QtGui.QOpenGLVersionProfile.version": (),

# class PySide2.QtGui.QOpenGLVertexArrayObject:

# class PySide2.QtGui.QOpenGLVertexArrayObject.Binder:
    "PySide2.QtGui.QOpenGLVertexArrayObject.Binder.__init__": ('PySide2.QtGui.QOpenGLVertexArrayObject',),
    "PySide2.QtGui.QOpenGLVertexArrayObject.Binder.rebind": (),
    "PySide2.QtGui.QOpenGLVertexArrayObject.Binder.release": (),

    "PySide2.QtGui.QOpenGLVertexArrayObject.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtGui.QOpenGLVertexArrayObject.bind": (),
    "PySide2.QtGui.QOpenGLVertexArrayObject.create": (),
    "PySide2.QtGui.QOpenGLVertexArrayObject.destroy": (),
    "PySide2.QtGui.QOpenGLVertexArrayObject.isCreated": (),
    "PySide2.QtGui.QOpenGLVertexArrayObject.objectId": (),
    "PySide2.QtGui.QOpenGLVertexArrayObject.release": (),

# class PySide2.QtGui.QOpenGLWindow:

# class PySide2.QtGui.QOpenGLWindow.UpdateBehavior:
    "PySide2.QtGui.QOpenGLWindow.__init__": [('PySide2.QtGui.QOpenGLContext', 'PySide2.QtGui.QOpenGLWindow.UpdateBehavior', 'PySide2.QtGui.QWindow'), ('PySide2.QtGui.QOpenGLWindow.UpdateBehavior', 'PySide2.QtGui.QWindow')],
    "PySide2.QtGui.QOpenGLWindow.context": (),
    "PySide2.QtGui.QOpenGLWindow.defaultFramebufferObject": (),
    "PySide2.QtGui.QOpenGLWindow.doneCurrent": (),
    "PySide2.QtGui.QOpenGLWindow.grabFramebuffer": (),
    "PySide2.QtGui.QOpenGLWindow.initializeGL": (),
    "PySide2.QtGui.QOpenGLWindow.isValid": (),
    "PySide2.QtGui.QOpenGLWindow.makeCurrent": (),
    "PySide2.QtGui.QOpenGLWindow.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
    "PySide2.QtGui.QOpenGLWindow.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtGui.QOpenGLWindow.paintGL": (),
    "PySide2.QtGui.QOpenGLWindow.paintOverGL": (),
    "PySide2.QtGui.QOpenGLWindow.paintUnderGL": (),
    "PySide2.QtGui.QOpenGLWindow.redirected": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QOpenGLWindow.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtGui.QOpenGLWindow.resizeGL": ('int', 'int'),
    "PySide2.QtGui.QOpenGLWindow.shareContext": (),
    "PySide2.QtGui.QOpenGLWindow.updateBehavior": (),

# class PySide2.QtGui.QPageLayout:

# class PySide2.QtGui.QPageLayout.Mode:

# class PySide2.QtGui.QPageLayout.Orientation:

# class PySide2.QtGui.QPageLayout.Unit:
    "PySide2.QtGui.QPageLayout.__init__": [(), ('PySide2.QtGui.QPageLayout',), ('PySide2.QtGui.QPageSize', 'PySide2.QtGui.QPageLayout.Orientation', 'PySide2.QtCore.QMarginsF', 'PySide2.QtGui.QPageLayout.Unit', 'PySide2.QtCore.QMarginsF')],
    "PySide2.QtGui.QPageLayout.__copy__": (),
    "PySide2.QtGui.QPageLayout.fullRect": [(), ('PySide2.QtGui.QPageLayout.Unit',)],
    "PySide2.QtGui.QPageLayout.fullRectPixels": ('int',),
    "PySide2.QtGui.QPageLayout.fullRectPoints": (),
    "PySide2.QtGui.QPageLayout.isEquivalentTo": ('PySide2.QtGui.QPageLayout',),
    "PySide2.QtGui.QPageLayout.isValid": (),
    "PySide2.QtGui.QPageLayout.margins": [(), ('PySide2.QtGui.QPageLayout.Unit',)],
    "PySide2.QtGui.QPageLayout.marginsPixels": ('int',),
    "PySide2.QtGui.QPageLayout.marginsPoints": (),
    "PySide2.QtGui.QPageLayout.maximumMargins": (),
    "PySide2.QtGui.QPageLayout.minimumMargins": (),
    "PySide2.QtGui.QPageLayout.mode": (),
    "PySide2.QtGui.QPageLayout.orientation": (),
    "PySide2.QtGui.QPageLayout.pageSize": (),
    "PySide2.QtGui.QPageLayout.paintRect": [(), ('PySide2.QtGui.QPageLayout.Unit',)],
    "PySide2.QtGui.QPageLayout.paintRectPixels": ('int',),
    "PySide2.QtGui.QPageLayout.paintRectPoints": (),
    "PySide2.QtGui.QPageLayout.setBottomMargin": ('float',),
    "PySide2.QtGui.QPageLayout.setLeftMargin": ('float',),
    "PySide2.QtGui.QPageLayout.setMargins": ('PySide2.QtCore.QMarginsF',),
    "PySide2.QtGui.QPageLayout.setMinimumMargins": ('PySide2.QtCore.QMarginsF',),
    "PySide2.QtGui.QPageLayout.setMode": ('PySide2.QtGui.QPageLayout.Mode',),
    "PySide2.QtGui.QPageLayout.setOrientation": ('PySide2.QtGui.QPageLayout.Orientation',),
    "PySide2.QtGui.QPageLayout.setPageSize": ('PySide2.QtGui.QPageSize', 'PySide2.QtCore.QMarginsF'),
    "PySide2.QtGui.QPageLayout.setRightMargin": ('float',),
    "PySide2.QtGui.QPageLayout.setTopMargin": ('float',),
    "PySide2.QtGui.QPageLayout.setUnits": ('PySide2.QtGui.QPageLayout.Unit',),
    "PySide2.QtGui.QPageLayout.swap": ('PySide2.QtGui.QPageLayout',),
    "PySide2.QtGui.QPageLayout.units": (),

# class PySide2.QtGui.QPageSize:

# class PySide2.QtGui.QPageSize.PageSizeId:

# class PySide2.QtGui.QPageSize.SizeMatchPolicy:

# class PySide2.QtGui.QPageSize.Unit:
    "PySide2.QtGui.QPageSize.__init__": [(), ('PySide2.QtCore.QSize', 'str', 'PySide2.QtGui.QPageSize.SizeMatchPolicy'), ('PySide2.QtCore.QSizeF', 'PySide2.QtGui.QPageSize.Unit', 'str', 'PySide2.QtGui.QPageSize.SizeMatchPolicy'), ('PySide2.QtGui.QPageSize',), ('PySide2.QtGui.QPageSize.PageSizeId',)],
    "PySide2.QtGui.QPageSize.__copy__": (),
    "PySide2.QtGui.QPageSize.definitionSize": [(), ('PySide2.QtGui.QPageSize.PageSizeId',)],
    "PySide2.QtGui.QPageSize.definitionUnits": [(), ('PySide2.QtGui.QPageSize.PageSizeId',)],
    "PySide2.QtGui.QPageSize.id": [(), ('PySide2.QtCore.QSize', 'PySide2.QtGui.QPageSize.SizeMatchPolicy'), ('PySide2.QtCore.QSizeF', 'PySide2.QtGui.QPageSize.Unit', 'PySide2.QtGui.QPageSize.SizeMatchPolicy'), ('int',)],
    "PySide2.QtGui.QPageSize.isEquivalentTo": ('PySide2.QtGui.QPageSize',),
    "PySide2.QtGui.QPageSize.isValid": (),
    "PySide2.QtGui.QPageSize.key": [(), ('PySide2.QtGui.QPageSize.PageSizeId',)],
    "PySide2.QtGui.QPageSize.name": [(), ('PySide2.QtGui.QPageSize.PageSizeId',)],
    "PySide2.QtGui.QPageSize.rect": ('PySide2.QtGui.QPageSize.Unit',),
    "PySide2.QtGui.QPageSize.rectPixels": ('int',),
    "PySide2.QtGui.QPageSize.rectPoints": (),
    "PySide2.QtGui.QPageSize.size": [('PySide2.QtGui.QPageSize.PageSizeId', 'PySide2.QtGui.QPageSize.Unit'), ('PySide2.QtGui.QPageSize.Unit',)],
    "PySide2.QtGui.QPageSize.sizePixels": [('PySide2.QtGui.QPageSize.PageSizeId', 'int'), ('int',)],
    "PySide2.QtGui.QPageSize.sizePoints": [(), ('PySide2.QtGui.QPageSize.PageSizeId',)],
    "PySide2.QtGui.QPageSize.swap": ('PySide2.QtGui.QPageSize',),
    "PySide2.QtGui.QPageSize.windowsId": [(), ('PySide2.QtGui.QPageSize.PageSizeId',)],

# class PySide2.QtGui.QPagedPaintDevice:

# class PySide2.QtGui.QPagedPaintDevice.Margins:
    "PySide2.QtGui.QPagedPaintDevice.Margins.__init__": [(), ('PySide2.QtGui.QPagedPaintDevice.Margins',)],
    "PySide2.QtGui.QPagedPaintDevice.Margins.__copy__": (),

# class PySide2.QtGui.QPagedPaintDevice.PageSize:

# class PySide2.QtGui.QPagedPaintDevice.PdfVersion:

    "PySide2.QtGui.QPagedPaintDevice.__init__": (),
    "PySide2.QtGui.QPagedPaintDevice.devicePageLayout": (),
    "PySide2.QtGui.QPagedPaintDevice.margins": (),
    "PySide2.QtGui.QPagedPaintDevice.newPage": (),
    "PySide2.QtGui.QPagedPaintDevice.pageLayout": (),
    "PySide2.QtGui.QPagedPaintDevice.pageSize": (),
    "PySide2.QtGui.QPagedPaintDevice.pageSizeMM": (),
    "PySide2.QtGui.QPagedPaintDevice.setMargins": ('PySide2.QtGui.QPagedPaintDevice.Margins',),
    "PySide2.QtGui.QPagedPaintDevice.setPageLayout": ('PySide2.QtGui.QPageLayout',),
    "PySide2.QtGui.QPagedPaintDevice.setPageMargins": [('PySide2.QtCore.QMarginsF',), ('PySide2.QtCore.QMarginsF', 'PySide2.QtGui.QPageLayout.Unit')],
    "PySide2.QtGui.QPagedPaintDevice.setPageOrientation": ('PySide2.QtGui.QPageLayout.Orientation',),
    "PySide2.QtGui.QPagedPaintDevice.setPageSize": [('PySide2.QtGui.QPageSize',), ('PySide2.QtGui.QPagedPaintDevice.PageSize',)],
    "PySide2.QtGui.QPagedPaintDevice.setPageSizeMM": ('PySide2.QtCore.QSizeF',),

# class PySide2.QtGui.QPaintDevice:

# class PySide2.QtGui.QPaintDevice.PaintDeviceMetric:
    "PySide2.QtGui.QPaintDevice.__init__": (),
    "PySide2.QtGui.QPaintDevice.colorCount": (),
    "PySide2.QtGui.QPaintDevice.depth": (),
    "PySide2.QtGui.QPaintDevice.devType": (),
    "PySide2.QtGui.QPaintDevice.devicePixelRatio": (),
    "PySide2.QtGui.QPaintDevice.devicePixelRatioF": (),
    "PySide2.QtGui.QPaintDevice.devicePixelRatioFScale": (),
    "PySide2.QtGui.QPaintDevice.height": (),
    "PySide2.QtGui.QPaintDevice.heightMM": (),
    "PySide2.QtGui.QPaintDevice.initPainter": ('PySide2.QtGui.QPainter',),
    "PySide2.QtGui.QPaintDevice.logicalDpiX": (),
    "PySide2.QtGui.QPaintDevice.logicalDpiY": (),
    "PySide2.QtGui.QPaintDevice.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
    "PySide2.QtGui.QPaintDevice.paintEngine": (),
    "PySide2.QtGui.QPaintDevice.paintingActive": (),
    "PySide2.QtGui.QPaintDevice.physicalDpiX": (),
    "PySide2.QtGui.QPaintDevice.physicalDpiY": (),
    "PySide2.QtGui.QPaintDevice.redirected": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QPaintDevice.sharedPainter": (),
    "PySide2.QtGui.QPaintDevice.width": (),
    "PySide2.QtGui.QPaintDevice.widthMM": (),

# class PySide2.QtGui.QPaintDeviceWindow:
    "PySide2.QtGui.QPaintDeviceWindow.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtGui.QPaintDeviceWindow.exposeEvent": ('PySide2.QtGui.QExposeEvent',),
    "PySide2.QtGui.QPaintDeviceWindow.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
    "PySide2.QtGui.QPaintDeviceWindow.paintEngine": (),
    "PySide2.QtGui.QPaintDeviceWindow.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtGui.QPaintDeviceWindow.update": [(), ('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',)],

# class PySide2.QtGui.QPaintEngine:

# class PySide2.QtGui.QPaintEngine.DirtyFlag:

# class PySide2.QtGui.QPaintEngine.DirtyFlags:

# class PySide2.QtGui.QPaintEngine.PaintEngineFeature:

# class PySide2.QtGui.QPaintEngine.PaintEngineFeatures:

# class PySide2.QtGui.QPaintEngine.PolygonDrawMode:

# class PySide2.QtGui.QPaintEngine.Type:
    "PySide2.QtGui.QPaintEngine.__init__": ('PySide2.QtGui.QPaintEngine.PaintEngineFeatures',),
    "PySide2.QtGui.QPaintEngine.begin": ('PySide2.QtGui.QPaintDevice',),
    "PySide2.QtGui.QPaintEngine.clearDirty": ('PySide2.QtGui.QPaintEngine.DirtyFlags',),
    "PySide2.QtGui.QPaintEngine.coordinateOffset": (),
    "PySide2.QtGui.QPaintEngine.drawEllipse": [('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',)],
    "PySide2.QtGui.QPaintEngine.drawImage": ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QImage', 'PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.ImageConversionFlags'),
    "PySide2.QtGui.QPaintEngine.drawLines": [('PySide2.QtCore.QLine', 'int'), ('PySide2.QtCore.QLineF', 'int')],
    "PySide2.QtGui.QPaintEngine.drawPath": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtGui.QPaintEngine.drawPixmap": ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.QRectF'),
    "PySide2.QtGui.QPaintEngine.drawPoints": [('PySide2.QtCore.QPoint', 'int'), ('PySide2.QtCore.QPointF', 'int')],
    "PySide2.QtGui.QPaintEngine.drawPolygon": [('PySide2.QtCore.QPoint', 'int', 'PySide2.QtGui.QPaintEngine.PolygonDrawMode'), ('PySide2.QtCore.QPointF', 'int', 'PySide2.QtGui.QPaintEngine.PolygonDrawMode')],
    "PySide2.QtGui.QPaintEngine.drawRects": [('PySide2.QtCore.QRect', 'int'), ('PySide2.QtCore.QRectF', 'int')],
    "PySide2.QtGui.QPaintEngine.drawTextItem": ('PySide2.QtCore.QPointF', 'PySide2.QtGui.QTextItem'),
    "PySide2.QtGui.QPaintEngine.drawTiledPixmap": ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.QPointF'),
    "PySide2.QtGui.QPaintEngine.end": (),
    "PySide2.QtGui.QPaintEngine.hasFeature": ('PySide2.QtGui.QPaintEngine.PaintEngineFeatures',),
    "PySide2.QtGui.QPaintEngine.isActive": (),
    "PySide2.QtGui.QPaintEngine.isExtended": (),
    "PySide2.QtGui.QPaintEngine.paintDevice": (),
    "PySide2.QtGui.QPaintEngine.painter": (),
    "PySide2.QtGui.QPaintEngine.setActive": ('bool',),
    "PySide2.QtGui.QPaintEngine.setDirty": ('PySide2.QtGui.QPaintEngine.DirtyFlags',),
    "PySide2.QtGui.QPaintEngine.setSystemClip": ('PySide2.QtGui.QRegion',),
    "PySide2.QtGui.QPaintEngine.setSystemRect": ('PySide2.QtCore.QRect',),
    "PySide2.QtGui.QPaintEngine.syncState": (),
    "PySide2.QtGui.QPaintEngine.systemClip": (),
    "PySide2.QtGui.QPaintEngine.systemRect": (),
    "PySide2.QtGui.QPaintEngine.testDirty": ('PySide2.QtGui.QPaintEngine.DirtyFlags',),
    "PySide2.QtGui.QPaintEngine.type": (),
    "PySide2.QtGui.QPaintEngine.updateState": ('PySide2.QtGui.QPaintEngineState',),

# class PySide2.QtGui.QPaintEngineState:
    "PySide2.QtGui.QPaintEngineState.__init__": (),
    "PySide2.QtGui.QPaintEngineState.backgroundBrush": (),
    "PySide2.QtGui.QPaintEngineState.backgroundMode": (),
    "PySide2.QtGui.QPaintEngineState.brush": (),
    "PySide2.QtGui.QPaintEngineState.brushNeedsResolving": (),
    "PySide2.QtGui.QPaintEngineState.brushOrigin": (),
    "PySide2.QtGui.QPaintEngineState.clipOperation": (),
    "PySide2.QtGui.QPaintEngineState.clipPath": (),
    "PySide2.QtGui.QPaintEngineState.clipRegion": (),
    "PySide2.QtGui.QPaintEngineState.compositionMode": (),
    "PySide2.QtGui.QPaintEngineState.font": (),
    "PySide2.QtGui.QPaintEngineState.isClipEnabled": (),
    "PySide2.QtGui.QPaintEngineState.matrix": (),
    "PySide2.QtGui.QPaintEngineState.opacity": (),
    "PySide2.QtGui.QPaintEngineState.painter": (),
    "PySide2.QtGui.QPaintEngineState.pen": (),
    "PySide2.QtGui.QPaintEngineState.penNeedsResolving": (),
    "PySide2.QtGui.QPaintEngineState.renderHints": (),
    "PySide2.QtGui.QPaintEngineState.state": (),
    "PySide2.QtGui.QPaintEngineState.transform": (),

# class PySide2.QtGui.QPaintEvent:
    "PySide2.QtGui.QPaintEvent.__init__": [('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',)],
    "PySide2.QtGui.QPaintEvent.rect": (),
    "PySide2.QtGui.QPaintEvent.region": (),

# class PySide2.QtGui.QPainter:

# class PySide2.QtGui.QPainter.CompositionMode:

# class PySide2.QtGui.QPainter.PixmapFragment:
    "PySide2.QtGui.QPainter.PixmapFragment.__init__": [(), ('PySide2.QtGui.QPainter.PixmapFragment',)],
    "PySide2.QtGui.QPainter.PixmapFragment.__copy__": (),
    "PySide2.QtGui.QPainter.PixmapFragment.create": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QRectF', 'float', 'float', 'float', 'float'),

# class PySide2.QtGui.QPainter.PixmapFragmentHint:

# class PySide2.QtGui.QPainter.PixmapFragmentHints:

# class PySide2.QtGui.QPainter.RenderHint:

# class PySide2.QtGui.QPainter.RenderHints:

    "PySide2.QtGui.QPainter.__init__": [(), ('PySide2.QtGui.QPaintDevice',)],
    "PySide2.QtGui.QPainter.background": (),
    "PySide2.QtGui.QPainter.backgroundMode": (),
    "PySide2.QtGui.QPainter.begin": ('PySide2.QtGui.QPaintDevice',),
    "PySide2.QtGui.QPainter.beginNativePainting": (),
    "PySide2.QtGui.QPainter.boundingRect": [('PySide2.QtCore.QRect', 'int', 'str'), ('PySide2.QtCore.QRectF', 'int', 'str'), ('PySide2.QtCore.QRectF', 'str', 'PySide2.QtGui.QTextOption'), ('int', 'int', 'int', 'int', 'int', 'str')],
    "PySide2.QtGui.QPainter.brush": (),
    "PySide2.QtGui.QPainter.brushOrigin": (),
    "PySide2.QtGui.QPainter.clipBoundingRect": (),
    "PySide2.QtGui.QPainter.clipPath": (),
    "PySide2.QtGui.QPainter.clipRegion": (),
    "PySide2.QtGui.QPainter.combinedMatrix": (),
    "PySide2.QtGui.QPainter.combinedTransform": (),
    "PySide2.QtGui.QPainter.compositionMode": (),
    "PySide2.QtGui.QPainter.device": (),
    "PySide2.QtGui.QPainter.deviceMatrix": (),
    "PySide2.QtGui.QPainter.deviceTransform": (),
    "PySide2.QtGui.QPainter.drawArc": [('PySide2.QtCore.QRect', 'int', 'int'), ('PySide2.QtCore.QRectF', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'int')],
    "PySide2.QtGui.QPainter.drawChord": [('PySide2.QtCore.QRect', 'int', 'int'), ('PySide2.QtCore.QRectF', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'int')],
    "PySide2.QtGui.QPainter.drawConvexPolygon": [('PySide2.QtGui.QPolygon',), ('PySide2.QtGui.QPolygonF',), ('typing.List',)],
    "PySide2.QtGui.QPainter.drawEllipse": [('PySide2.QtCore.QPoint', 'int', 'int'), ('PySide2.QtCore.QPointF', 'float', 'float'), ('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',), ('int', 'int', 'int', 'int')],
    "PySide2.QtGui.QPainter.drawImage": [('PySide2.QtCore.QPoint', 'PySide2.QtGui.QImage'), ('PySide2.QtCore.QPoint', 'PySide2.QtGui.QImage', 'PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.ImageConversionFlags'), ('PySide2.QtCore.QPointF', 'PySide2.QtGui.QImage'), ('PySide2.QtCore.QPointF', 'PySide2.QtGui.QImage', 'PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.ImageConversionFlags'), ('PySide2.QtCore.QRect', 'PySide2.QtGui.QImage'), ('PySide2.QtCore.QRect', 'PySide2.QtGui.QImage', 'PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.ImageConversionFlags'), ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QImage'), ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QImage', 'PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.ImageConversionFlags'), ('int', 'int', 'PySide2.QtGui.QImage', 'int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.ImageConversionFlags')],
    "PySide2.QtGui.QPainter.drawLine": [('PySide2.QtCore.QLine',), ('PySide2.QtCore.QLineF',), ('PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint'), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'), ('int', 'int', 'int', 'int')],
    "PySide2.QtGui.QPainter.drawLines": ('typing.List',),
    "PySide2.QtGui.QPainter.drawPath": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtGui.QPainter.drawPicture": [('PySide2.QtCore.QPoint', 'PySide2.QtGui.QPicture'), ('PySide2.QtCore.QPointF', 'PySide2.QtGui.QPicture'), ('int', 'int', 'PySide2.QtGui.QPicture')],
    "PySide2.QtGui.QPainter.drawPie": [('PySide2.QtCore.QRect', 'int', 'int'), ('PySide2.QtCore.QRectF', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'int')],
    "PySide2.QtGui.QPainter.drawPixmap": [('PySide2.QtCore.QPoint', 'PySide2.QtGui.QPixmap'), ('PySide2.QtCore.QPoint', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.QRect'), ('PySide2.QtCore.QPointF', 'PySide2.QtGui.QPixmap'), ('PySide2.QtCore.QPointF', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.QRectF'), ('PySide2.QtCore.QRect', 'PySide2.QtGui.QPixmap'), ('PySide2.QtCore.QRect', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.QRect'), ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.QRectF'), ('int', 'int', 'PySide2.QtGui.QPixmap'), ('int', 'int', 'PySide2.QtGui.QPixmap', 'int', 'int', 'int', 'int'), ('int', 'int', 'int', 'int', 'PySide2.QtGui.QPixmap'), ('int', 'int', 'int', 'int', 'PySide2.QtGui.QPixmap', 'int', 'int', 'int', 'int')],
    "PySide2.QtGui.QPainter.drawPixmapFragments": ('PySide2.QtGui.QPainter.PixmapFragment', 'int', 'PySide2.QtGui.QPixmap', 'PySide2.QtGui.QPainter.PixmapFragmentHints'),
    "PySide2.QtGui.QPainter.drawPoint": [('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('int', 'int')],
    "PySide2.QtGui.QPainter.drawPoints": [('PySide2.QtGui.QPolygon',), ('PySide2.QtGui.QPolygonF',), ('typing.List',)],
    "PySide2.QtGui.QPainter.drawPolygon": [('PySide2.QtGui.QPolygon', 'PySide2.QtCore.Qt.FillRule'), ('PySide2.QtGui.QPolygonF', 'PySide2.QtCore.Qt.FillRule'), ('typing.List', 'PySide2.QtCore.Qt.FillRule')],
    "PySide2.QtGui.QPainter.drawPolyline": [('PySide2.QtGui.QPolygon',), ('PySide2.QtGui.QPolygonF',), ('typing.List',)],
    "PySide2.QtGui.QPainter.drawRect": [('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',), ('int', 'int', 'int', 'int')],
    "PySide2.QtGui.QPainter.drawRects": ('typing.List',),
    "PySide2.QtGui.QPainter.drawRoundRect": [('PySide2.QtCore.QRect', 'int', 'int'), ('PySide2.QtCore.QRectF', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'int')],
    "PySide2.QtGui.QPainter.drawRoundedRect": [('PySide2.QtCore.QRect', 'float', 'float', 'PySide2.QtCore.Qt.SizeMode'), ('PySide2.QtCore.QRectF', 'float', 'float', 'PySide2.QtCore.Qt.SizeMode'), ('int', 'int', 'int', 'int', 'float', 'float', 'PySide2.QtCore.Qt.SizeMode')],
    "PySide2.QtGui.QPainter.drawStaticText": [('PySide2.QtCore.QPoint', 'PySide2.QtGui.QStaticText'), ('PySide2.QtCore.QPointF', 'PySide2.QtGui.QStaticText'), ('int', 'int', 'PySide2.QtGui.QStaticText')],
    "PySide2.QtGui.QPainter.drawText": [('PySide2.QtCore.QPoint', 'str'), ('PySide2.QtCore.QPointF', 'str'), ('PySide2.QtCore.QRect', 'int', 'str', 'PySide2.QtCore.QRect'), ('PySide2.QtCore.QRectF', 'int', 'str', 'PySide2.QtCore.QRectF'), ('PySide2.QtCore.QRectF', 'str', 'PySide2.QtGui.QTextOption'), ('int', 'int', 'int', 'int', 'int', 'str', 'PySide2.QtCore.QRect'), ('int', 'int', 'str')],
    "PySide2.QtGui.QPainter.drawTextItem": [('PySide2.QtCore.QPoint', 'PySide2.QtGui.QTextItem'), ('PySide2.QtCore.QPointF', 'PySide2.QtGui.QTextItem'), ('int', 'int', 'PySide2.QtGui.QTextItem')],
    "PySide2.QtGui.QPainter.drawTiledPixmap": [('PySide2.QtCore.QRect', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.QPoint'), ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.QPointF'), ('int', 'int', 'int', 'int', 'PySide2.QtGui.QPixmap', 'int', 'int')],
    "PySide2.QtGui.QPainter.end": (),
    "PySide2.QtGui.QPainter.endNativePainting": (),
    "PySide2.QtGui.QPainter.eraseRect": [('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',), ('int', 'int', 'int', 'int')],
    "PySide2.QtGui.QPainter.fillPath": ('PySide2.QtGui.QPainterPath', 'PySide2.QtGui.QBrush'),
    "PySide2.QtGui.QPainter.fillRect": [('PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.BrushStyle'), ('PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.GlobalColor'), ('PySide2.QtCore.QRect', 'PySide2.QtGui.QBrush'), ('PySide2.QtCore.QRect', 'PySide2.QtGui.QColor'), ('PySide2.QtCore.QRect', 'PySide2.QtGui.QGradient.Preset'), ('PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.BrushStyle'), ('PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.GlobalColor'), ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QBrush'), ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QColor'), ('PySide2.QtCore.QRectF', 'PySide2.QtGui.QGradient.Preset'), ('int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.BrushStyle'), ('int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.GlobalColor'), ('int', 'int', 'int', 'int', 'PySide2.QtGui.QBrush'), ('int', 'int', 'int', 'int', 'PySide2.QtGui.QColor'), ('int', 'int', 'int', 'int', 'PySide2.QtGui.QGradient.Preset')],
    "PySide2.QtGui.QPainter.font": (),
    "PySide2.QtGui.QPainter.fontInfo": (),
    "PySide2.QtGui.QPainter.fontMetrics": (),
    "PySide2.QtGui.QPainter.hasClipping": (),
    "PySide2.QtGui.QPainter.initFrom": ('PySide2.QtGui.QPaintDevice',),
    "PySide2.QtGui.QPainter.isActive": (),
    "PySide2.QtGui.QPainter.layoutDirection": (),
    "PySide2.QtGui.QPainter.matrix": (),
    "PySide2.QtGui.QPainter.matrixEnabled": (),
    "PySide2.QtGui.QPainter.opacity": (),
    "PySide2.QtGui.QPainter.paintEngine": (),
    "PySide2.QtGui.QPainter.pen": (),
    "PySide2.QtGui.QPainter.redirected": ('PySide2.QtGui.QPaintDevice', 'PySide2.QtCore.QPoint'),
    "PySide2.QtGui.QPainter.renderHints": (),
    "PySide2.QtGui.QPainter.resetMatrix": (),
    "PySide2.QtGui.QPainter.resetTransform": (),
    "PySide2.QtGui.QPainter.restore": (),
    "PySide2.QtGui.QPainter.restoreRedirected": ('PySide2.QtGui.QPaintDevice',),
    "PySide2.QtGui.QPainter.rotate": ('float',),
    "PySide2.QtGui.QPainter.save": (),
    "PySide2.QtGui.QPainter.scale": ('float', 'float'),
    "PySide2.QtGui.QPainter.setBackground": ('PySide2.QtGui.QBrush',),
    "PySide2.QtGui.QPainter.setBackgroundMode": ('PySide2.QtCore.Qt.BGMode',),
    "PySide2.QtGui.QPainter.setBrush": [('PySide2.QtCore.Qt.BrushStyle',), ('PySide2.QtGui.QBrush',)],
    "PySide2.QtGui.QPainter.setBrushOrigin": [('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('int', 'int')],
    "PySide2.QtGui.QPainter.setClipPath": ('PySide2.QtGui.QPainterPath', 'PySide2.QtCore.Qt.ClipOperation'),
    "PySide2.QtGui.QPainter.setClipRect": [('PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.ClipOperation'), ('PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.ClipOperation'), ('int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.ClipOperation')],
    "PySide2.QtGui.QPainter.setClipRegion": ('PySide2.QtGui.QRegion', 'PySide2.QtCore.Qt.ClipOperation'),
    "PySide2.QtGui.QPainter.setClipping": ('bool',),
    "PySide2.QtGui.QPainter.setCompositionMode": ('PySide2.QtGui.QPainter.CompositionMode',),
    "PySide2.QtGui.QPainter.setFont": ('PySide2.QtGui.QFont',),
    "PySide2.QtGui.QPainter.setLayoutDirection": ('PySide2.QtCore.Qt.LayoutDirection',),
    "PySide2.QtGui.QPainter.setMatrix": ('PySide2.QtGui.QMatrix', 'bool'),
    "PySide2.QtGui.QPainter.setMatrixEnabled": ('bool',),
    "PySide2.QtGui.QPainter.setOpacity": ('float',),
    "PySide2.QtGui.QPainter.setPen": [('PySide2.QtCore.Qt.PenStyle',), ('PySide2.QtGui.QColor',), ('PySide2.QtGui.QPen',)],
    "PySide2.QtGui.QPainter.setRedirected": ('PySide2.QtGui.QPaintDevice', 'PySide2.QtGui.QPaintDevice', 'PySide2.QtCore.QPoint'),
    "PySide2.QtGui.QPainter.setRenderHint": ('PySide2.QtGui.QPainter.RenderHint', 'bool'),
    "PySide2.QtGui.QPainter.setRenderHints": ('PySide2.QtGui.QPainter.RenderHints', 'bool'),
    "PySide2.QtGui.QPainter.setTransform": ('PySide2.QtGui.QTransform', 'bool'),
    "PySide2.QtGui.QPainter.setViewTransformEnabled": ('bool',),
    "PySide2.QtGui.QPainter.setViewport": [('PySide2.QtCore.QRect',), ('int', 'int', 'int', 'int')],
    "PySide2.QtGui.QPainter.setWindow": [('PySide2.QtCore.QRect',), ('int', 'int', 'int', 'int')],
    "PySide2.QtGui.QPainter.setWorldMatrix": ('PySide2.QtGui.QMatrix', 'bool'),
    "PySide2.QtGui.QPainter.setWorldMatrixEnabled": ('bool',),
    "PySide2.QtGui.QPainter.setWorldTransform": ('PySide2.QtGui.QTransform', 'bool'),
    "PySide2.QtGui.QPainter.shear": ('float', 'float'),
    "PySide2.QtGui.QPainter.strokePath": ('PySide2.QtGui.QPainterPath', 'PySide2.QtGui.QPen'),
    "PySide2.QtGui.QPainter.testRenderHint": ('PySide2.QtGui.QPainter.RenderHint',),
    "PySide2.QtGui.QPainter.transform": (),
    "PySide2.QtGui.QPainter.translate": [('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtGui.QPainter.viewTransformEnabled": (),
    "PySide2.QtGui.QPainter.viewport": (),
    "PySide2.QtGui.QPainter.window": (),
    "PySide2.QtGui.QPainter.worldMatrix": (),
    "PySide2.QtGui.QPainter.worldMatrixEnabled": (),
    "PySide2.QtGui.QPainter.worldTransform": (),

# class PySide2.QtGui.QPainterPath:

# class PySide2.QtGui.QPainterPath.Element:
    "PySide2.QtGui.QPainterPath.Element.__init__": [(), ('PySide2.QtGui.QPainterPath.Element',)],
    "PySide2.QtGui.QPainterPath.Element.__copy__": (),
    "PySide2.QtGui.QPainterPath.Element.isCurveTo": (),
    "PySide2.QtGui.QPainterPath.Element.isLineTo": (),
    "PySide2.QtGui.QPainterPath.Element.isMoveTo": (),

# class PySide2.QtGui.QPainterPath.ElementType:

    "PySide2.QtGui.QPainterPath.__init__": [(), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QPainterPath',)],
    "PySide2.QtGui.QPainterPath.__add__": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtGui.QPainterPath.__and__": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtGui.QPainterPath.__copy__": (),
    "PySide2.QtGui.QPainterPath.__iadd__": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtGui.QPainterPath.__iand__": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtGui.QPainterPath.__ior__": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtGui.QPainterPath.__isub__": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtGui.QPainterPath.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QPainterPath.__mul__": [('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',)],
    "PySide2.QtGui.QPainterPath.__or__": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtGui.QPainterPath.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QPainterPath.__sub__": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtGui.QPainterPath.addEllipse": [('PySide2.QtCore.QPointF', 'float', 'float'), ('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtGui.QPainterPath.addPath": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtGui.QPainterPath.addPolygon": ('PySide2.QtGui.QPolygonF',),
    "PySide2.QtGui.QPainterPath.addRect": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtGui.QPainterPath.addRegion": ('PySide2.QtGui.QRegion',),
    "PySide2.QtGui.QPainterPath.addRoundRect": [('PySide2.QtCore.QRectF', 'int'), ('PySide2.QtCore.QRectF', 'int', 'int'), ('float', 'float', 'float', 'float', 'int'), ('float', 'float', 'float', 'float', 'int', 'int')],
    "PySide2.QtGui.QPainterPath.addRoundedRect": [('PySide2.QtCore.QRectF', 'float', 'float', 'PySide2.QtCore.Qt.SizeMode'), ('float', 'float', 'float', 'float', 'float', 'float', 'PySide2.QtCore.Qt.SizeMode')],
    "PySide2.QtGui.QPainterPath.addText": [('PySide2.QtCore.QPointF', 'PySide2.QtGui.QFont', 'str'), ('float', 'float', 'PySide2.QtGui.QFont', 'str')],
    "PySide2.QtGui.QPainterPath.angleAtPercent": ('float',),
    "PySide2.QtGui.QPainterPath.arcMoveTo": [('PySide2.QtCore.QRectF', 'float'), ('float', 'float', 'float', 'float', 'float')],
    "PySide2.QtGui.QPainterPath.arcTo": [('PySide2.QtCore.QRectF', 'float', 'float'), ('float', 'float', 'float', 'float', 'float', 'float')],
    "PySide2.QtGui.QPainterPath.boundingRect": (),
    "PySide2.QtGui.QPainterPath.capacity": (),
    "PySide2.QtGui.QPainterPath.clear": (),
    "PySide2.QtGui.QPainterPath.closeSubpath": (),
    "PySide2.QtGui.QPainterPath.connectPath": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtGui.QPainterPath.contains": [('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRectF',), ('PySide2.QtGui.QPainterPath',)],
    "PySide2.QtGui.QPainterPath.controlPointRect": (),
    "PySide2.QtGui.QPainterPath.cubicTo": [('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'), ('float', 'float', 'float', 'float', 'float', 'float')],
    "PySide2.QtGui.QPainterPath.currentPosition": (),
    "PySide2.QtGui.QPainterPath.elementAt": ('int',),
    "PySide2.QtGui.QPainterPath.elementCount": (),
    "PySide2.QtGui.QPainterPath.fillRule": (),
    "PySide2.QtGui.QPainterPath.intersected": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtGui.QPainterPath.intersects": [('PySide2.QtCore.QRectF',), ('PySide2.QtGui.QPainterPath',)],
    "PySide2.QtGui.QPainterPath.isEmpty": (),
    "PySide2.QtGui.QPainterPath.length": (),
    "PySide2.QtGui.QPainterPath.lineTo": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtGui.QPainterPath.moveTo": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtGui.QPainterPath.percentAtLength": ('float',),
    "PySide2.QtGui.QPainterPath.pointAtPercent": ('float',),
    "PySide2.QtGui.QPainterPath.quadTo": [('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF'), ('float', 'float', 'float', 'float')],
    "PySide2.QtGui.QPainterPath.reserve": ('int',),
    "PySide2.QtGui.QPainterPath.setElementPositionAt": ('int', 'float', 'float'),
    "PySide2.QtGui.QPainterPath.setFillRule": ('PySide2.QtCore.Qt.FillRule',),
    "PySide2.QtGui.QPainterPath.simplified": (),
    "PySide2.QtGui.QPainterPath.slopeAtPercent": ('float',),
    "PySide2.QtGui.QPainterPath.subtracted": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtGui.QPainterPath.subtractedInverted": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtGui.QPainterPath.swap": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtGui.QPainterPath.toFillPolygon": [('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',)],
    "PySide2.QtGui.QPainterPath.toFillPolygons": [('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',)],
    "PySide2.QtGui.QPainterPath.toReversed": (),
    "PySide2.QtGui.QPainterPath.toSubpathPolygons": [('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',)],
    "PySide2.QtGui.QPainterPath.translate": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtGui.QPainterPath.translated": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtGui.QPainterPath.united": ('PySide2.QtGui.QPainterPath',),

# class PySide2.QtGui.QPainterPathStroker:
    "PySide2.QtGui.QPainterPathStroker.__init__": [(), ('PySide2.QtGui.QPen',)],
    "PySide2.QtGui.QPainterPathStroker.capStyle": (),
    "PySide2.QtGui.QPainterPathStroker.createStroke": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtGui.QPainterPathStroker.curveThreshold": (),
    "PySide2.QtGui.QPainterPathStroker.dashOffset": (),
    "PySide2.QtGui.QPainterPathStroker.dashPattern": (),
    "PySide2.QtGui.QPainterPathStroker.joinStyle": (),
    "PySide2.QtGui.QPainterPathStroker.miterLimit": (),
    "PySide2.QtGui.QPainterPathStroker.setCapStyle": ('PySide2.QtCore.Qt.PenCapStyle',),
    "PySide2.QtGui.QPainterPathStroker.setCurveThreshold": ('float',),
    "PySide2.QtGui.QPainterPathStroker.setDashOffset": ('float',),
    "PySide2.QtGui.QPainterPathStroker.setDashPattern": [('PySide2.QtCore.Qt.PenStyle',), ('typing.List',)],
    "PySide2.QtGui.QPainterPathStroker.setJoinStyle": ('PySide2.QtCore.Qt.PenJoinStyle',),
    "PySide2.QtGui.QPainterPathStroker.setMiterLimit": ('float',),
    "PySide2.QtGui.QPainterPathStroker.setWidth": ('float',),
    "PySide2.QtGui.QPainterPathStroker.width": (),

# class PySide2.QtGui.QPalette:

# class PySide2.QtGui.QPalette.ColorGroup:

# class PySide2.QtGui.QPalette.ColorRole:
    "PySide2.QtGui.QPalette.__init__": [(), ('PySide2.QtCore.Qt.GlobalColor',), ('PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush'), ('PySide2.QtGui.QColor',), ('PySide2.QtGui.QColor', 'PySide2.QtGui.QColor'), ('PySide2.QtGui.QColor', 'PySide2.QtGui.QColor', 'PySide2.QtGui.QColor', 'PySide2.QtGui.QColor', 'PySide2.QtGui.QColor', 'PySide2.QtGui.QColor', 'PySide2.QtGui.QColor'), ('PySide2.QtGui.QPalette',)],
    "PySide2.QtGui.QPalette.__copy__": (),
    "PySide2.QtGui.QPalette.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QPalette.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QPalette.alternateBase": (),
    "PySide2.QtGui.QPalette.background": (),
    "PySide2.QtGui.QPalette.base": (),
    "PySide2.QtGui.QPalette.brightText": (),
    "PySide2.QtGui.QPalette.brush": [('PySide2.QtGui.QPalette.ColorGroup', 'PySide2.QtGui.QPalette.ColorRole'), ('PySide2.QtGui.QPalette.ColorRole',)],
    "PySide2.QtGui.QPalette.button": (),
    "PySide2.QtGui.QPalette.buttonText": (),
    "PySide2.QtGui.QPalette.cacheKey": (),
    "PySide2.QtGui.QPalette.color": [('PySide2.QtGui.QPalette.ColorGroup', 'PySide2.QtGui.QPalette.ColorRole'), ('PySide2.QtGui.QPalette.ColorRole',)],
    "PySide2.QtGui.QPalette.currentColorGroup": (),
    "PySide2.QtGui.QPalette.dark": (),
    "PySide2.QtGui.QPalette.foreground": (),
    "PySide2.QtGui.QPalette.highlight": (),
    "PySide2.QtGui.QPalette.highlightedText": (),
    "PySide2.QtGui.QPalette.isBrushSet": ('PySide2.QtGui.QPalette.ColorGroup', 'PySide2.QtGui.QPalette.ColorRole'),
    "PySide2.QtGui.QPalette.isCopyOf": ('PySide2.QtGui.QPalette',),
    "PySide2.QtGui.QPalette.isEqual": ('PySide2.QtGui.QPalette.ColorGroup', 'PySide2.QtGui.QPalette.ColorGroup'),
    "PySide2.QtGui.QPalette.light": (),
    "PySide2.QtGui.QPalette.link": (),
    "PySide2.QtGui.QPalette.linkVisited": (),
    "PySide2.QtGui.QPalette.mid": (),
    "PySide2.QtGui.QPalette.midlight": (),
    "PySide2.QtGui.QPalette.placeholderText": (),
    "PySide2.QtGui.QPalette.resolve": [(), ('PySide2.QtGui.QPalette',), ('int',)],
    "PySide2.QtGui.QPalette.setBrush": [('PySide2.QtGui.QPalette.ColorGroup', 'PySide2.QtGui.QPalette.ColorRole', 'PySide2.QtGui.QBrush'), ('PySide2.QtGui.QPalette.ColorRole', 'PySide2.QtGui.QBrush')],
    "PySide2.QtGui.QPalette.setColor": [('PySide2.QtGui.QPalette.ColorGroup', 'PySide2.QtGui.QPalette.ColorRole', 'PySide2.QtGui.QColor'), ('PySide2.QtGui.QPalette.ColorRole', 'PySide2.QtGui.QColor')],
    "PySide2.QtGui.QPalette.setColorGroup": ('PySide2.QtGui.QPalette.ColorGroup', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush', 'PySide2.QtGui.QBrush'),
    "PySide2.QtGui.QPalette.setCurrentColorGroup": ('PySide2.QtGui.QPalette.ColorGroup',),
    "PySide2.QtGui.QPalette.shadow": (),
    "PySide2.QtGui.QPalette.swap": ('PySide2.QtGui.QPalette',),
    "PySide2.QtGui.QPalette.text": (),
    "PySide2.QtGui.QPalette.toolTipBase": (),
    "PySide2.QtGui.QPalette.toolTipText": (),
    "PySide2.QtGui.QPalette.window": (),
    "PySide2.QtGui.QPalette.windowText": (),

# class PySide2.QtGui.QPdfWriter:
    "PySide2.QtGui.QPdfWriter.__init__": [('PySide2.QtCore.QIODevice',), ('str',)],
    "PySide2.QtGui.QPdfWriter.creator": (),
    "PySide2.QtGui.QPdfWriter.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
    "PySide2.QtGui.QPdfWriter.newPage": (),
    "PySide2.QtGui.QPdfWriter.paintEngine": (),
    "PySide2.QtGui.QPdfWriter.pdfVersion": (),
    "PySide2.QtGui.QPdfWriter.resolution": (),
    "PySide2.QtGui.QPdfWriter.setCreator": ('str',),
    "PySide2.QtGui.QPdfWriter.setMargins": ('PySide2.QtGui.QPagedPaintDevice.Margins',),
    "PySide2.QtGui.QPdfWriter.setPageSize": ('PySide2.QtGui.QPagedPaintDevice.PageSize',),
    "PySide2.QtGui.QPdfWriter.setPageSizeMM": ('PySide2.QtCore.QSizeF',),
    "PySide2.QtGui.QPdfWriter.setPdfVersion": ('PySide2.QtGui.QPagedPaintDevice.PdfVersion',),
    "PySide2.QtGui.QPdfWriter.setResolution": ('int',),
    "PySide2.QtGui.QPdfWriter.setTitle": ('str',),
    "PySide2.QtGui.QPdfWriter.title": (),

# class PySide2.QtGui.QPen:
    "PySide2.QtGui.QPen.__init__": [(), ('PySide2.QtCore.Qt.PenStyle',), ('PySide2.QtGui.QBrush', 'float', 'PySide2.QtCore.Qt.PenStyle', 'PySide2.QtCore.Qt.PenCapStyle', 'PySide2.QtCore.Qt.PenJoinStyle'), ('PySide2.QtGui.QColor',), ('PySide2.QtGui.QPen',)],
    "PySide2.QtGui.QPen.__copy__": (),
    "PySide2.QtGui.QPen.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QPen.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QPen.brush": (),
    "PySide2.QtGui.QPen.capStyle": (),
    "PySide2.QtGui.QPen.color": (),
    "PySide2.QtGui.QPen.dashOffset": (),
    "PySide2.QtGui.QPen.dashPattern": (),
    "PySide2.QtGui.QPen.isCosmetic": (),
    "PySide2.QtGui.QPen.isSolid": (),
    "PySide2.QtGui.QPen.joinStyle": (),
    "PySide2.QtGui.QPen.miterLimit": (),
    "PySide2.QtGui.QPen.setBrush": ('PySide2.QtGui.QBrush',),
    "PySide2.QtGui.QPen.setCapStyle": ('PySide2.QtCore.Qt.PenCapStyle',),
    "PySide2.QtGui.QPen.setColor": ('PySide2.QtGui.QColor',),
    "PySide2.QtGui.QPen.setCosmetic": ('bool',),
    "PySide2.QtGui.QPen.setDashOffset": ('float',),
    "PySide2.QtGui.QPen.setDashPattern": ('typing.List',),
    "PySide2.QtGui.QPen.setJoinStyle": ('PySide2.QtCore.Qt.PenJoinStyle',),
    "PySide2.QtGui.QPen.setMiterLimit": ('float',),
    "PySide2.QtGui.QPen.setStyle": ('PySide2.QtCore.Qt.PenStyle',),
    "PySide2.QtGui.QPen.setWidth": ('int',),
    "PySide2.QtGui.QPen.setWidthF": ('float',),
    "PySide2.QtGui.QPen.style": (),
    "PySide2.QtGui.QPen.swap": ('PySide2.QtGui.QPen',),
    "PySide2.QtGui.QPen.width": (),
    "PySide2.QtGui.QPen.widthF": (),

# class PySide2.QtGui.QPicture:
    "PySide2.QtGui.QPicture.__init__": [('PySide2.QtGui.QPicture',), ('int',)],
    "PySide2.QtGui.QPicture.__copy__": (),
    "PySide2.QtGui.QPicture.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QPicture.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QPicture.boundingRect": (),
    "PySide2.QtGui.QPicture.data": (),
    "PySide2.QtGui.QPicture.devType": (),
    "PySide2.QtGui.QPicture.inputFormatList": (),
    "PySide2.QtGui.QPicture.inputFormats": (),
    "PySide2.QtGui.QPicture.isNull": (),
    "PySide2.QtGui.QPicture.load": [('PySide2.QtCore.QIODevice', 'bytes'), ('str', 'bytes')],
    "PySide2.QtGui.QPicture.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
    "PySide2.QtGui.QPicture.outputFormatList": (),
    "PySide2.QtGui.QPicture.outputFormats": (),
    "PySide2.QtGui.QPicture.paintEngine": (),
    "PySide2.QtGui.QPicture.pictureFormat": ('str',),
    "PySide2.QtGui.QPicture.play": ('PySide2.QtGui.QPainter',),
    "PySide2.QtGui.QPicture.save": [('PySide2.QtCore.QIODevice', 'bytes'), ('str', 'bytes')],
    "PySide2.QtGui.QPicture.setBoundingRect": ('PySide2.QtCore.QRect',),
    "PySide2.QtGui.QPicture.setData": ('bytes', 'int'),
    "PySide2.QtGui.QPicture.size": (),
    "PySide2.QtGui.QPicture.swap": ('PySide2.QtGui.QPicture',),

# class PySide2.QtGui.QPictureIO:
    "PySide2.QtGui.QPictureIO.__init__": [(), ('PySide2.QtCore.QIODevice', 'bytes'), ('str', 'bytes')],
    "PySide2.QtGui.QPictureIO.description": (),
    "PySide2.QtGui.QPictureIO.fileName": (),
    "PySide2.QtGui.QPictureIO.format": (),
    "PySide2.QtGui.QPictureIO.gamma": (),
    "PySide2.QtGui.QPictureIO.inputFormats": (),
    "PySide2.QtGui.QPictureIO.ioDevice": (),
    "PySide2.QtGui.QPictureIO.outputFormats": (),
    "PySide2.QtGui.QPictureIO.parameters": (),
    "PySide2.QtGui.QPictureIO.picture": (),
    "PySide2.QtGui.QPictureIO.pictureFormat": [('PySide2.QtCore.QIODevice',), ('str',)],
    "PySide2.QtGui.QPictureIO.quality": (),
    "PySide2.QtGui.QPictureIO.read": (),
    "PySide2.QtGui.QPictureIO.setDescription": ('str',),
    "PySide2.QtGui.QPictureIO.setFileName": ('str',),
    "PySide2.QtGui.QPictureIO.setFormat": ('bytes',),
    "PySide2.QtGui.QPictureIO.setGamma": ('float',),
    "PySide2.QtGui.QPictureIO.setIODevice": ('PySide2.QtCore.QIODevice',),
    "PySide2.QtGui.QPictureIO.setParameters": ('bytes',),
    "PySide2.QtGui.QPictureIO.setPicture": ('PySide2.QtGui.QPicture',),
    "PySide2.QtGui.QPictureIO.setQuality": ('int',),
    "PySide2.QtGui.QPictureIO.setStatus": ('int',),
    "PySide2.QtGui.QPictureIO.status": (),
    "PySide2.QtGui.QPictureIO.write": (),

# class PySide2.QtGui.QPixelFormat:

# class PySide2.QtGui.QPixelFormat.AlphaPosition:

# class PySide2.QtGui.QPixelFormat.AlphaPremultiplied:

# class PySide2.QtGui.QPixelFormat.AlphaUsage:

# class PySide2.QtGui.QPixelFormat.ByteOrder:

# class PySide2.QtGui.QPixelFormat.ColorModel:

# class PySide2.QtGui.QPixelFormat.TypeInterpretation:

# class PySide2.QtGui.QPixelFormat.YUVLayout:
    "PySide2.QtGui.QPixelFormat.__init__": [(), ('PySide2.QtGui.QPixelFormat',), ('PySide2.QtGui.QPixelFormat.ColorModel', 'typing.Char', 'typing.Char', 'typing.Char', 'typing.Char', 'typing.Char', 'typing.Char', 'PySide2.QtGui.QPixelFormat.AlphaUsage', 'PySide2.QtGui.QPixelFormat.AlphaPosition', 'PySide2.QtGui.QPixelFormat.AlphaPremultiplied', 'PySide2.QtGui.QPixelFormat.TypeInterpretation', 'PySide2.QtGui.QPixelFormat.ByteOrder', 'typing.Char')],
    "PySide2.QtGui.QPixelFormat.__copy__": (),
    "PySide2.QtGui.QPixelFormat.alphaPosition": (),
    "PySide2.QtGui.QPixelFormat.alphaSize": (),
    "PySide2.QtGui.QPixelFormat.alphaUsage": (),
    "PySide2.QtGui.QPixelFormat.bitsPerPixel": (),
    "PySide2.QtGui.QPixelFormat.blackSize": (),
    "PySide2.QtGui.QPixelFormat.blueSize": (),
    "PySide2.QtGui.QPixelFormat.brightnessSize": (),
    "PySide2.QtGui.QPixelFormat.byteOrder": (),
    "PySide2.QtGui.QPixelFormat.channelCount": (),
    "PySide2.QtGui.QPixelFormat.colorModel": (),
    "PySide2.QtGui.QPixelFormat.cyanSize": (),
    "PySide2.QtGui.QPixelFormat.greenSize": (),
    "PySide2.QtGui.QPixelFormat.hueSize": (),
    "PySide2.QtGui.QPixelFormat.lightnessSize": (),
    "PySide2.QtGui.QPixelFormat.magentaSize": (),
    "PySide2.QtGui.QPixelFormat.premultiplied": (),
    "PySide2.QtGui.QPixelFormat.redSize": (),
    "PySide2.QtGui.QPixelFormat.saturationSize": (),
    "PySide2.QtGui.QPixelFormat.subEnum": (),
    "PySide2.QtGui.QPixelFormat.typeInterpretation": (),
    "PySide2.QtGui.QPixelFormat.yellowSize": (),
    "PySide2.QtGui.QPixelFormat.yuvLayout": (),

# class PySide2.QtGui.QPixmap:
    "PySide2.QtGui.QPixmap.__init__": [(), ('PySide2.QtCore.QSize',), ('PySide2.QtGui.QImage',), ('PySide2.QtGui.QPixmap',), ('int', 'int'), ('str', 'bytes', 'PySide2.QtCore.Qt.ImageConversionFlags'), ('typing.Sequence',)],
    "PySide2.QtGui.QPixmap.__copy__": (),
    "PySide2.QtGui.QPixmap.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QPixmap.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QPixmap.cacheKey": (),
    "PySide2.QtGui.QPixmap.convertFromImage": ('PySide2.QtGui.QImage', 'PySide2.QtCore.Qt.ImageConversionFlags'),
    "PySide2.QtGui.QPixmap.copy": [('PySide2.QtCore.QRect',), ('int', 'int', 'int', 'int')],
    "PySide2.QtGui.QPixmap.createHeuristicMask": ('bool',),
    "PySide2.QtGui.QPixmap.createMaskFromColor": ('PySide2.QtGui.QColor', 'PySide2.QtCore.Qt.MaskMode'),
    "PySide2.QtGui.QPixmap.defaultDepth": (),
    "PySide2.QtGui.QPixmap.depth": (),
    "PySide2.QtGui.QPixmap.devType": (),
    "PySide2.QtGui.QPixmap.devicePixelRatio": (),
    "PySide2.QtGui.QPixmap.fill": [('PySide2.QtGui.QColor',), ('PySide2.QtGui.QPaintDevice', 'PySide2.QtCore.QPoint'), ('PySide2.QtGui.QPaintDevice', 'int', 'int')],
    "PySide2.QtGui.QPixmap.fromImage": ('PySide2.QtGui.QImage', 'PySide2.QtCore.Qt.ImageConversionFlags'),
    "PySide2.QtGui.QPixmap.fromImageInPlace": ('PySide2.QtGui.QImage', 'PySide2.QtCore.Qt.ImageConversionFlags'),
    "PySide2.QtGui.QPixmap.fromImageReader": ('PySide2.QtGui.QImageReader', 'PySide2.QtCore.Qt.ImageConversionFlags'),
    "PySide2.QtGui.QPixmap.grabWidget": [('PySide2.QtCore.QObject', 'PySide2.QtCore.QRect'), ('PySide2.QtCore.QObject', 'int', 'int', 'int', 'int')],
    "PySide2.QtGui.QPixmap.grabWindow": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QPixmap.hasAlpha": (),
    "PySide2.QtGui.QPixmap.hasAlphaChannel": (),
    "PySide2.QtGui.QPixmap.height": (),
    "PySide2.QtGui.QPixmap.isNull": (),
    "PySide2.QtGui.QPixmap.isQBitmap": (),
    "PySide2.QtGui.QPixmap.load": ('str', 'bytes', 'PySide2.QtCore.Qt.ImageConversionFlags'),
    "PySide2.QtGui.QPixmap.loadFromData": [('PySide2.QtCore.QByteArray', 'bytes', 'PySide2.QtCore.Qt.ImageConversionFlags'), ('bytes', 'int', 'bytes', 'PySide2.QtCore.Qt.ImageConversionFlags')],
    "PySide2.QtGui.QPixmap.mask": (),
    "PySide2.QtGui.QPixmap.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
    "PySide2.QtGui.QPixmap.paintEngine": (),
    "PySide2.QtGui.QPixmap.rect": (),
    "PySide2.QtGui.QPixmap.save": [('PySide2.QtCore.QIODevice', 'bytes', 'int'), ('str', 'bytes', 'int')],
    "PySide2.QtGui.QPixmap.scaled": [('PySide2.QtCore.QSize', 'PySide2.QtCore.Qt.AspectRatioMode', 'PySide2.QtCore.Qt.TransformationMode'), ('int', 'int', 'PySide2.QtCore.Qt.AspectRatioMode', 'PySide2.QtCore.Qt.TransformationMode')],
    "PySide2.QtGui.QPixmap.scaledToHeight": ('int', 'PySide2.QtCore.Qt.TransformationMode'),
    "PySide2.QtGui.QPixmap.scaledToWidth": ('int', 'PySide2.QtCore.Qt.TransformationMode'),
    "PySide2.QtGui.QPixmap.scroll": [('int', 'int', 'PySide2.QtCore.QRect', 'PySide2.QtGui.QRegion'), ('int', 'int', 'int', 'int', 'int', 'int', 'PySide2.QtGui.QRegion')],
    "PySide2.QtGui.QPixmap.setDevicePixelRatio": ('float',),
    "PySide2.QtGui.QPixmap.setMask": ('PySide2.QtGui.QBitmap',),
    "PySide2.QtGui.QPixmap.size": (),
    "PySide2.QtGui.QPixmap.swap": ('PySide2.QtGui.QPixmap',),
    "PySide2.QtGui.QPixmap.toImage": (),
    "PySide2.QtGui.QPixmap.transformed": [('PySide2.QtGui.QMatrix', 'PySide2.QtCore.Qt.TransformationMode'), ('PySide2.QtGui.QTransform', 'PySide2.QtCore.Qt.TransformationMode')],
    "PySide2.QtGui.QPixmap.trueMatrix": [('PySide2.QtGui.QMatrix', 'int', 'int'), ('PySide2.QtGui.QTransform', 'int', 'int')],
    "PySide2.QtGui.QPixmap.width": (),

# class PySide2.QtGui.QPixmapCache:

# class PySide2.QtGui.QPixmapCache.Key:
    "PySide2.QtGui.QPixmapCache.Key.__init__": [(), ('PySide2.QtGui.QPixmapCache.Key',)],
    "PySide2.QtGui.QPixmapCache.Key.__copy__": (),
    "PySide2.QtGui.QPixmapCache.Key.isValid": (),
    "PySide2.QtGui.QPixmapCache.Key.swap": ('PySide2.QtGui.QPixmapCache.Key',),

    "PySide2.QtGui.QPixmapCache.__init__": (),
    "PySide2.QtGui.QPixmapCache.cacheLimit": (),
    "PySide2.QtGui.QPixmapCache.clear": (),
    "PySide2.QtGui.QPixmapCache.find": [('PySide2.QtGui.QPixmapCache.Key',), ('PySide2.QtGui.QPixmapCache.Key', 'PySide2.QtGui.QPixmap'), ('str',), ('str', 'PySide2.QtGui.QPixmap')],
    "PySide2.QtGui.QPixmapCache.insert": [('PySide2.QtGui.QPixmap',), ('str', 'PySide2.QtGui.QPixmap')],
    "PySide2.QtGui.QPixmapCache.remove": [('PySide2.QtGui.QPixmapCache.Key',), ('str',)],
    "PySide2.QtGui.QPixmapCache.replace": ('PySide2.QtGui.QPixmapCache.Key', 'PySide2.QtGui.QPixmap'),
    "PySide2.QtGui.QPixmapCache.setCacheLimit": ('int',),

# class PySide2.QtGui.QPointingDeviceUniqueId:
    "PySide2.QtGui.QPointingDeviceUniqueId.__init__": [(), ('PySide2.QtGui.QPointingDeviceUniqueId',)],
    "PySide2.QtGui.QPointingDeviceUniqueId.__copy__": (),
    "PySide2.QtGui.QPointingDeviceUniqueId.fromNumericId": ('int',),
    "PySide2.QtGui.QPointingDeviceUniqueId.isValid": (),
    "PySide2.QtGui.QPointingDeviceUniqueId.numericId": (),

# class PySide2.QtGui.QPolygon:
    "PySide2.QtGui.QPolygon.__init__": [(), ('PySide2.QtCore.QRect', 'bool'), ('PySide2.QtGui.QPolygon',), ('int',), ('typing.List',)],
    "PySide2.QtGui.QPolygon.__add__": ('typing.List',),
    "PySide2.QtGui.QPolygon.__copy__": (),
    "PySide2.QtGui.QPolygon.__iadd__": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QPolygon.__lshift__": [('PySide2.QtCore.QDataStream',), ('PySide2.QtCore.QPoint',), ('typing.List',)],
    "PySide2.QtGui.QPolygon.__mul__": [('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',)],
    "PySide2.QtGui.QPolygon.__reduce__": (),
    "PySide2.QtGui.QPolygon.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QPolygon.append": [('PySide2.QtCore.QPoint',), ('typing.List',)],
    "PySide2.QtGui.QPolygon.at": ('int',),
    "PySide2.QtGui.QPolygon.back": (),
    "PySide2.QtGui.QPolygon.boundingRect": (),
    "PySide2.QtGui.QPolygon.capacity": (),
    "PySide2.QtGui.QPolygon.clear": (),
    "PySide2.QtGui.QPolygon.constData": (),
    "PySide2.QtGui.QPolygon.constFirst": (),
    "PySide2.QtGui.QPolygon.constLast": (),
    "PySide2.QtGui.QPolygon.contains": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QPolygon.containsPoint": ('PySide2.QtCore.QPoint', 'PySide2.QtCore.Qt.FillRule'),
    "PySide2.QtGui.QPolygon.count": [(), ('PySide2.QtCore.QPoint',)],
    "PySide2.QtGui.QPolygon.data": (),
    "PySide2.QtGui.QPolygon.empty": (),
    "PySide2.QtGui.QPolygon.endsWith": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QPolygon.fill": ('PySide2.QtCore.QPoint', 'int'),
    "PySide2.QtGui.QPolygon.first": (),
    "PySide2.QtGui.QPolygon.fromList": ('typing.Sequence',),
    "PySide2.QtGui.QPolygon.front": (),
    "PySide2.QtGui.QPolygon.indexOf": ('PySide2.QtCore.QPoint', 'int'),
    "PySide2.QtGui.QPolygon.insert": [('int', 'PySide2.QtCore.QPoint'), ('int', 'int', 'PySide2.QtCore.QPoint')],
    "PySide2.QtGui.QPolygon.intersected": ('PySide2.QtGui.QPolygon',),
    "PySide2.QtGui.QPolygon.intersects": ('PySide2.QtGui.QPolygon',),
    "PySide2.QtGui.QPolygon.isEmpty": (),
    "PySide2.QtGui.QPolygon.isSharedWith": ('typing.List',),
    "PySide2.QtGui.QPolygon.last": (),
    "PySide2.QtGui.QPolygon.lastIndexOf": ('PySide2.QtCore.QPoint', 'int'),
    "PySide2.QtGui.QPolygon.length": (),
    "PySide2.QtGui.QPolygon.mid": ('int', 'int'),
    "PySide2.QtGui.QPolygon.move": ('int', 'int'),
    "PySide2.QtGui.QPolygon.pop_back": (),
    "PySide2.QtGui.QPolygon.pop_front": (),
    "PySide2.QtGui.QPolygon.prepend": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QPolygon.push_back": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QPolygon.push_front": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QPolygon.remove": [('int',), ('int', 'int')],
    "PySide2.QtGui.QPolygon.removeAll": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QPolygon.removeAt": ('int',),
    "PySide2.QtGui.QPolygon.removeFirst": (),
    "PySide2.QtGui.QPolygon.removeLast": (),
    "PySide2.QtGui.QPolygon.removeOne": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QPolygon.replace": ('int', 'PySide2.QtCore.QPoint'),
    "PySide2.QtGui.QPolygon.reserve": ('int',),
    "PySide2.QtGui.QPolygon.resize": ('int',),
    "PySide2.QtGui.QPolygon.setSharable": ('bool',),
    "PySide2.QtGui.QPolygon.shrink_to_fit": (),
    "PySide2.QtGui.QPolygon.size": (),
    "PySide2.QtGui.QPolygon.squeeze": (),
    "PySide2.QtGui.QPolygon.startsWith": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QPolygon.subtracted": ('PySide2.QtGui.QPolygon',),
    "PySide2.QtGui.QPolygon.swap": ('PySide2.QtGui.QPolygon',),
    "PySide2.QtGui.QPolygon.swapItemsAt": ('int', 'int'),
    "PySide2.QtGui.QPolygon.takeAt": ('int',),
    "PySide2.QtGui.QPolygon.takeFirst": (),
    "PySide2.QtGui.QPolygon.takeLast": (),
    "PySide2.QtGui.QPolygon.toList": (),
    "PySide2.QtGui.QPolygon.translate": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtGui.QPolygon.translated": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtGui.QPolygon.united": ('PySide2.QtGui.QPolygon',),
    "PySide2.QtGui.QPolygon.value": [('int',), ('int', 'PySide2.QtCore.QPoint')],

# class PySide2.QtGui.QPolygonF:
    "PySide2.QtGui.QPolygonF.__init__": [(), ('PySide2.QtCore.QRectF',), ('PySide2.QtGui.QPolygon',), ('PySide2.QtGui.QPolygonF',), ('int',), ('typing.List',)],
    "PySide2.QtGui.QPolygonF.__add__": ('typing.List',),
    "PySide2.QtGui.QPolygonF.__copy__": (),
    "PySide2.QtGui.QPolygonF.__iadd__": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QPolygonF.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QPolygonF.__mul__": [('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',)],
    "PySide2.QtGui.QPolygonF.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QPolygonF.append": [('PySide2.QtCore.QPointF',), ('typing.List',)],
    "PySide2.QtGui.QPolygonF.at": ('int',),
    "PySide2.QtGui.QPolygonF.back": (),
    "PySide2.QtGui.QPolygonF.boundingRect": (),
    "PySide2.QtGui.QPolygonF.capacity": (),
    "PySide2.QtGui.QPolygonF.clear": (),
    "PySide2.QtGui.QPolygonF.constData": (),
    "PySide2.QtGui.QPolygonF.constFirst": (),
    "PySide2.QtGui.QPolygonF.constLast": (),
    "PySide2.QtGui.QPolygonF.contains": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QPolygonF.containsPoint": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.FillRule'),
    "PySide2.QtGui.QPolygonF.count": [(), ('PySide2.QtCore.QPointF',)],
    "PySide2.QtGui.QPolygonF.data": (),
    "PySide2.QtGui.QPolygonF.empty": (),
    "PySide2.QtGui.QPolygonF.endsWith": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QPolygonF.fill": ('PySide2.QtCore.QPointF', 'int'),
    "PySide2.QtGui.QPolygonF.first": (),
    "PySide2.QtGui.QPolygonF.fromList": ('typing.Sequence',),
    "PySide2.QtGui.QPolygonF.front": (),
    "PySide2.QtGui.QPolygonF.indexOf": ('PySide2.QtCore.QPointF', 'int'),
    "PySide2.QtGui.QPolygonF.insert": [('int', 'PySide2.QtCore.QPointF'), ('int', 'int', 'PySide2.QtCore.QPointF')],
    "PySide2.QtGui.QPolygonF.intersected": ('PySide2.QtGui.QPolygonF',),
    "PySide2.QtGui.QPolygonF.intersects": ('PySide2.QtGui.QPolygonF',),
    "PySide2.QtGui.QPolygonF.isClosed": (),
    "PySide2.QtGui.QPolygonF.isEmpty": (),
    "PySide2.QtGui.QPolygonF.isSharedWith": ('typing.List',),
    "PySide2.QtGui.QPolygonF.last": (),
    "PySide2.QtGui.QPolygonF.lastIndexOf": ('PySide2.QtCore.QPointF', 'int'),
    "PySide2.QtGui.QPolygonF.length": (),
    "PySide2.QtGui.QPolygonF.mid": ('int', 'int'),
    "PySide2.QtGui.QPolygonF.move": ('int', 'int'),
    "PySide2.QtGui.QPolygonF.pop_back": (),
    "PySide2.QtGui.QPolygonF.pop_front": (),
    "PySide2.QtGui.QPolygonF.prepend": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QPolygonF.push_back": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QPolygonF.push_front": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QPolygonF.remove": [('int',), ('int', 'int')],
    "PySide2.QtGui.QPolygonF.removeAll": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QPolygonF.removeAt": ('int',),
    "PySide2.QtGui.QPolygonF.removeFirst": (),
    "PySide2.QtGui.QPolygonF.removeLast": (),
    "PySide2.QtGui.QPolygonF.removeOne": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QPolygonF.replace": ('int', 'PySide2.QtCore.QPointF'),
    "PySide2.QtGui.QPolygonF.reserve": ('int',),
    "PySide2.QtGui.QPolygonF.resize": ('int',),
    "PySide2.QtGui.QPolygonF.setSharable": ('bool',),
    "PySide2.QtGui.QPolygonF.shrink_to_fit": (),
    "PySide2.QtGui.QPolygonF.size": (),
    "PySide2.QtGui.QPolygonF.squeeze": (),
    "PySide2.QtGui.QPolygonF.startsWith": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QPolygonF.subtracted": ('PySide2.QtGui.QPolygonF',),
    "PySide2.QtGui.QPolygonF.swap": ('PySide2.QtGui.QPolygonF',),
    "PySide2.QtGui.QPolygonF.swapItemsAt": ('int', 'int'),
    "PySide2.QtGui.QPolygonF.takeAt": ('int',),
    "PySide2.QtGui.QPolygonF.takeFirst": (),
    "PySide2.QtGui.QPolygonF.takeLast": (),
    "PySide2.QtGui.QPolygonF.toList": (),
    "PySide2.QtGui.QPolygonF.toPolygon": (),
    "PySide2.QtGui.QPolygonF.translate": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtGui.QPolygonF.translated": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtGui.QPolygonF.united": ('PySide2.QtGui.QPolygonF',),
    "PySide2.QtGui.QPolygonF.value": [('int',), ('int', 'PySide2.QtCore.QPointF')],

# class PySide2.QtGui.QPyTextObject:
    "PySide2.QtGui.QPyTextObject.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtGui.QPyTextObject.drawObject": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF', 'PySide2.QtGui.QTextDocument', 'int', 'PySide2.QtGui.QTextFormat'),
    "PySide2.QtGui.QPyTextObject.intrinsicSize": ('PySide2.QtGui.QTextDocument', 'int', 'PySide2.QtGui.QTextFormat'),

# class PySide2.QtGui.QQuaternion:
    "PySide2.QtGui.QQuaternion.__init__": [(), ('PySide2.QtGui.QVector4D',), ('float', 'PySide2.QtGui.QVector3D'), ('float', 'float', 'float', 'float')],
    "PySide2.QtGui.QQuaternion.__add__": ('PySide2.QtGui.QQuaternion',),
    "PySide2.QtGui.QQuaternion.__copy__": (),
    "PySide2.QtGui.QQuaternion.__iadd__": ('PySide2.QtGui.QQuaternion',),
    "PySide2.QtGui.QQuaternion.__imul__": [('PySide2.QtGui.QQuaternion',), ('float',)],
    "PySide2.QtGui.QQuaternion.__isub__": ('PySide2.QtGui.QQuaternion',),
    "PySide2.QtGui.QQuaternion.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QQuaternion.__mul__": [('PySide2.QtGui.QQuaternion',), ('float',)],
    "PySide2.QtGui.QQuaternion.__neg__": (),
    "PySide2.QtGui.QQuaternion.__reduce__": (),
    "PySide2.QtGui.QQuaternion.__repr__": (),
    "PySide2.QtGui.QQuaternion.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QQuaternion.__sub__": ('PySide2.QtGui.QQuaternion',),
    "PySide2.QtGui.QQuaternion.conjugate": (),
    "PySide2.QtGui.QQuaternion.conjugated": (),
    "PySide2.QtGui.QQuaternion.dotProduct": ('PySide2.QtGui.QQuaternion', 'PySide2.QtGui.QQuaternion'),
    "PySide2.QtGui.QQuaternion.fromAxes": ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'),
    "PySide2.QtGui.QQuaternion.fromAxisAndAngle": [('PySide2.QtGui.QVector3D', 'float'), ('float', 'float', 'float', 'float')],
    "PySide2.QtGui.QQuaternion.fromDirection": ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'),
    "PySide2.QtGui.QQuaternion.fromEulerAngles": [('PySide2.QtGui.QVector3D',), ('float', 'float', 'float')],
    "PySide2.QtGui.QQuaternion.fromRotationMatrix": ('PySide2.QtGui.QMatrix3x3',),
    "PySide2.QtGui.QQuaternion.getAxes": ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'),
    "PySide2.QtGui.QQuaternion.inverted": (),
    "PySide2.QtGui.QQuaternion.isIdentity": (),
    "PySide2.QtGui.QQuaternion.isNull": (),
    "PySide2.QtGui.QQuaternion.length": (),
    "PySide2.QtGui.QQuaternion.lengthSquared": (),
    "PySide2.QtGui.QQuaternion.nlerp": ('PySide2.QtGui.QQuaternion', 'PySide2.QtGui.QQuaternion', 'float'),
    "PySide2.QtGui.QQuaternion.normalize": (),
    "PySide2.QtGui.QQuaternion.normalized": (),
    "PySide2.QtGui.QQuaternion.rotatedVector": ('PySide2.QtGui.QVector3D',),
    "PySide2.QtGui.QQuaternion.rotationTo": ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'),
    "PySide2.QtGui.QQuaternion.scalar": (),
    "PySide2.QtGui.QQuaternion.setScalar": ('float',),
    "PySide2.QtGui.QQuaternion.setVector": [('PySide2.QtGui.QVector3D',), ('float', 'float', 'float')],
    "PySide2.QtGui.QQuaternion.setX": ('float',),
    "PySide2.QtGui.QQuaternion.setY": ('float',),
    "PySide2.QtGui.QQuaternion.setZ": ('float',),
    "PySide2.QtGui.QQuaternion.slerp": ('PySide2.QtGui.QQuaternion', 'PySide2.QtGui.QQuaternion', 'float'),
    "PySide2.QtGui.QQuaternion.toEulerAngles": (),
    "PySide2.QtGui.QQuaternion.toRotationMatrix": (),
    "PySide2.QtGui.QQuaternion.toVector4D": (),
    "PySide2.QtGui.QQuaternion.vector": (),
    "PySide2.QtGui.QQuaternion.x": (),
    "PySide2.QtGui.QQuaternion.y": (),
    "PySide2.QtGui.QQuaternion.z": (),

# class PySide2.QtGui.QRadialGradient:
    "PySide2.QtGui.QRadialGradient.__init__": [(), ('PySide2.QtCore.QPointF', 'float'), ('PySide2.QtCore.QPointF', 'float', 'PySide2.QtCore.QPointF'), ('PySide2.QtCore.QPointF', 'float', 'PySide2.QtCore.QPointF', 'float'), ('PySide2.QtGui.QRadialGradient',), ('float', 'float', 'float'), ('float', 'float', 'float', 'float', 'float'), ('float', 'float', 'float', 'float', 'float', 'float')],
    "PySide2.QtGui.QRadialGradient.__copy__": (),
    "PySide2.QtGui.QRadialGradient.center": (),
    "PySide2.QtGui.QRadialGradient.centerRadius": (),
    "PySide2.QtGui.QRadialGradient.focalPoint": (),
    "PySide2.QtGui.QRadialGradient.focalRadius": (),
    "PySide2.QtGui.QRadialGradient.radius": (),
    "PySide2.QtGui.QRadialGradient.setCenter": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtGui.QRadialGradient.setCenterRadius": ('float',),
    "PySide2.QtGui.QRadialGradient.setFocalPoint": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtGui.QRadialGradient.setFocalRadius": ('float',),
    "PySide2.QtGui.QRadialGradient.setRadius": ('float',),

# class PySide2.QtGui.QRasterWindow:
    "PySide2.QtGui.QRasterWindow.__init__": ('PySide2.QtGui.QWindow',),
    "PySide2.QtGui.QRasterWindow.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
    "PySide2.QtGui.QRasterWindow.redirected": ('PySide2.QtCore.QPoint',),

# class PySide2.QtGui.QRawFont:

# class PySide2.QtGui.QRawFont.AntialiasingType:

# class PySide2.QtGui.QRawFont.LayoutFlag:

# class PySide2.QtGui.QRawFont.LayoutFlags:
    "PySide2.QtGui.QRawFont.__init__": [(), ('PySide2.QtCore.QByteArray', 'float', 'PySide2.QtGui.QFont.HintingPreference'), ('PySide2.QtGui.QRawFont',), ('str', 'float', 'PySide2.QtGui.QFont.HintingPreference')],
    "PySide2.QtGui.QRawFont.__copy__": (),
    "PySide2.QtGui.QRawFont.advancesForGlyphIndexes": [('typing.List',), ('typing.List', 'PySide2.QtGui.QRawFont.LayoutFlags')],
    "PySide2.QtGui.QRawFont.alphaMapForGlyph": ('int', 'PySide2.QtGui.QRawFont.AntialiasingType', 'PySide2.QtGui.QTransform'),
    "PySide2.QtGui.QRawFont.ascent": (),
    "PySide2.QtGui.QRawFont.averageCharWidth": (),
    "PySide2.QtGui.QRawFont.boundingRect": ('int',),
    "PySide2.QtGui.QRawFont.capHeight": (),
    "PySide2.QtGui.QRawFont.descent": (),
    "PySide2.QtGui.QRawFont.familyName": (),
    "PySide2.QtGui.QRawFont.fontTable": ('bytes',),
    "PySide2.QtGui.QRawFont.fromFont": ('PySide2.QtGui.QFont', 'PySide2.QtGui.QFontDatabase.WritingSystem'),
    "PySide2.QtGui.QRawFont.glyphIndexesForString": ('str',),
    "PySide2.QtGui.QRawFont.hintingPreference": (),
    "PySide2.QtGui.QRawFont.isValid": (),
    "PySide2.QtGui.QRawFont.leading": (),
    "PySide2.QtGui.QRawFont.lineThickness": (),
    "PySide2.QtGui.QRawFont.loadFromData": ('PySide2.QtCore.QByteArray', 'float', 'PySide2.QtGui.QFont.HintingPreference'),
    "PySide2.QtGui.QRawFont.loadFromFile": ('str', 'float', 'PySide2.QtGui.QFont.HintingPreference'),
    "PySide2.QtGui.QRawFont.maxCharWidth": (),
    "PySide2.QtGui.QRawFont.pathForGlyph": ('int',),
    "PySide2.QtGui.QRawFont.pixelSize": (),
    "PySide2.QtGui.QRawFont.setPixelSize": ('float',),
    "PySide2.QtGui.QRawFont.style": (),
    "PySide2.QtGui.QRawFont.styleName": (),
    "PySide2.QtGui.QRawFont.supportedWritingSystems": (),
    "PySide2.QtGui.QRawFont.supportsCharacter": [('int',), ('typing.Char',)],
    "PySide2.QtGui.QRawFont.swap": ('PySide2.QtGui.QRawFont',),
    "PySide2.QtGui.QRawFont.underlinePosition": (),
    "PySide2.QtGui.QRawFont.unitsPerEm": (),
    "PySide2.QtGui.QRawFont.weight": (),
    "PySide2.QtGui.QRawFont.xHeight": (),

# class PySide2.QtGui.QRegExpValidator:
    "PySide2.QtGui.QRegExpValidator.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtCore.QRegExp', 'PySide2.QtCore.QObject')],
    "PySide2.QtGui.QRegExpValidator.regExp": (),
    "PySide2.QtGui.QRegExpValidator.setRegExp": ('PySide2.QtCore.QRegExp',),
    "PySide2.QtGui.QRegExpValidator.validate": ('str', 'int'),

# class PySide2.QtGui.QRegion:

# class PySide2.QtGui.QRegion.RegionType:
    "PySide2.QtGui.QRegion.__init__": [(), ('PySide2.QtCore.QRect', 'PySide2.QtGui.QRegion.RegionType'), ('PySide2.QtGui.QBitmap',), ('PySide2.QtGui.QPolygon', 'PySide2.QtCore.Qt.FillRule'), ('PySide2.QtGui.QRegion',), ('int', 'int', 'int', 'int', 'PySide2.QtGui.QRegion.RegionType')],
    "PySide2.QtGui.QRegion.__add__": [('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',)],
    "PySide2.QtGui.QRegion.__and__": [('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',)],
    "PySide2.QtGui.QRegion.__copy__": (),
    "PySide2.QtGui.QRegion.__iadd__": [('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',)],
    "PySide2.QtGui.QRegion.__ior__": ('PySide2.QtGui.QRegion',),
    "PySide2.QtGui.QRegion.__isub__": ('PySide2.QtGui.QRegion',),
    "PySide2.QtGui.QRegion.__ixor__": ('PySide2.QtGui.QRegion',),
    "PySide2.QtGui.QRegion.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QRegion.__mul__": [('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',)],
    "PySide2.QtGui.QRegion.__or__": ('PySide2.QtGui.QRegion',),
    "PySide2.QtGui.QRegion.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QRegion.__sub__": ('PySide2.QtGui.QRegion',),
    "PySide2.QtGui.QRegion.__xor__": ('PySide2.QtGui.QRegion',),
    "PySide2.QtGui.QRegion.begin": (),
    "PySide2.QtGui.QRegion.boundingRect": (),
    "PySide2.QtGui.QRegion.cbegin": (),
    "PySide2.QtGui.QRegion.cend": (),
    "PySide2.QtGui.QRegion.contains": [('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QRect',)],
    "PySide2.QtGui.QRegion.end": (),
    "PySide2.QtGui.QRegion.intersected": [('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',)],
    "PySide2.QtGui.QRegion.intersects": [('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',)],
    "PySide2.QtGui.QRegion.isEmpty": (),
    "PySide2.QtGui.QRegion.isNull": (),
    "PySide2.QtGui.QRegion.rectCount": (),
    "PySide2.QtGui.QRegion.rects": (),
    "PySide2.QtGui.QRegion.setRects": ('PySide2.QtCore.QRect', 'int'),
    "PySide2.QtGui.QRegion.subtracted": ('PySide2.QtGui.QRegion',),
    "PySide2.QtGui.QRegion.swap": ('PySide2.QtGui.QRegion',),
    "PySide2.QtGui.QRegion.translate": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtGui.QRegion.translated": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtGui.QRegion.united": [('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',)],
    "PySide2.QtGui.QRegion.xored": ('PySide2.QtGui.QRegion',),

# class PySide2.QtGui.QResizeEvent:
    "PySide2.QtGui.QResizeEvent.__init__": ('PySide2.QtCore.QSize', 'PySide2.QtCore.QSize'),
    "PySide2.QtGui.QResizeEvent.oldSize": (),
    "PySide2.QtGui.QResizeEvent.size": (),

# class PySide2.QtGui.QScreen:
    "PySide2.QtGui.QScreen.angleBetween": ('PySide2.QtCore.Qt.ScreenOrientation', 'PySide2.QtCore.Qt.ScreenOrientation'),
    "PySide2.QtGui.QScreen.availableGeometry": (),
    "PySide2.QtGui.QScreen.availableSize": (),
    "PySide2.QtGui.QScreen.availableVirtualGeometry": (),
    "PySide2.QtGui.QScreen.availableVirtualSize": (),
    "PySide2.QtGui.QScreen.depth": (),
    "PySide2.QtGui.QScreen.devicePixelRatio": (),
    "PySide2.QtGui.QScreen.geometry": (),
    "PySide2.QtGui.QScreen.grabWindow": ('int', 'int', 'int', 'int', 'int'),
    "PySide2.QtGui.QScreen.isLandscape": ('PySide2.QtCore.Qt.ScreenOrientation',),
    "PySide2.QtGui.QScreen.isPortrait": ('PySide2.QtCore.Qt.ScreenOrientation',),
    "PySide2.QtGui.QScreen.logicalDotsPerInch": (),
    "PySide2.QtGui.QScreen.logicalDotsPerInchX": (),
    "PySide2.QtGui.QScreen.logicalDotsPerInchY": (),
    "PySide2.QtGui.QScreen.manufacturer": (),
    "PySide2.QtGui.QScreen.mapBetween": ('PySide2.QtCore.Qt.ScreenOrientation', 'PySide2.QtCore.Qt.ScreenOrientation', 'PySide2.QtCore.QRect'),
    "PySide2.QtGui.QScreen.model": (),
    "PySide2.QtGui.QScreen.name": (),
    "PySide2.QtGui.QScreen.nativeOrientation": (),
    "PySide2.QtGui.QScreen.orientation": (),
    "PySide2.QtGui.QScreen.orientationUpdateMask": (),
    "PySide2.QtGui.QScreen.physicalDotsPerInch": (),
    "PySide2.QtGui.QScreen.physicalDotsPerInchX": (),
    "PySide2.QtGui.QScreen.physicalDotsPerInchY": (),
    "PySide2.QtGui.QScreen.physicalSize": (),
    "PySide2.QtGui.QScreen.primaryOrientation": (),
    "PySide2.QtGui.QScreen.refreshRate": (),
    "PySide2.QtGui.QScreen.serialNumber": (),
    "PySide2.QtGui.QScreen.setOrientationUpdateMask": ('PySide2.QtCore.Qt.ScreenOrientations',),
    "PySide2.QtGui.QScreen.size": (),
    "PySide2.QtGui.QScreen.transformBetween": ('PySide2.QtCore.Qt.ScreenOrientation', 'PySide2.QtCore.Qt.ScreenOrientation', 'PySide2.QtCore.QRect'),
    "PySide2.QtGui.QScreen.virtualGeometry": (),
    "PySide2.QtGui.QScreen.virtualSiblings": (),
    "PySide2.QtGui.QScreen.virtualSize": (),

# class PySide2.QtGui.QScrollEvent:

# class PySide2.QtGui.QScrollEvent.ScrollState:
    "PySide2.QtGui.QScrollEvent.__init__": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtGui.QScrollEvent.ScrollState'),
    "PySide2.QtGui.QScrollEvent.contentPos": (),
    "PySide2.QtGui.QScrollEvent.overshootDistance": (),
    "PySide2.QtGui.QScrollEvent.scrollState": (),

# class PySide2.QtGui.QScrollPrepareEvent:
    "PySide2.QtGui.QScrollPrepareEvent.__init__": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QScrollPrepareEvent.contentPos": (),
    "PySide2.QtGui.QScrollPrepareEvent.contentPosRange": (),
    "PySide2.QtGui.QScrollPrepareEvent.setContentPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QScrollPrepareEvent.setContentPosRange": ('PySide2.QtCore.QRectF',),
    "PySide2.QtGui.QScrollPrepareEvent.setViewportSize": ('PySide2.QtCore.QSizeF',),
    "PySide2.QtGui.QScrollPrepareEvent.startPos": (),
    "PySide2.QtGui.QScrollPrepareEvent.viewportSize": (),

# class PySide2.QtGui.QSessionManager:

# class PySide2.QtGui.QSessionManager.RestartHint:
    "PySide2.QtGui.QSessionManager.allowsErrorInteraction": (),
    "PySide2.QtGui.QSessionManager.allowsInteraction": (),
    "PySide2.QtGui.QSessionManager.cancel": (),
    "PySide2.QtGui.QSessionManager.discardCommand": (),
    "PySide2.QtGui.QSessionManager.isPhase2": (),
    "PySide2.QtGui.QSessionManager.release": (),
    "PySide2.QtGui.QSessionManager.requestPhase2": (),
    "PySide2.QtGui.QSessionManager.restartCommand": (),
    "PySide2.QtGui.QSessionManager.restartHint": (),
    "PySide2.QtGui.QSessionManager.sessionId": (),
    "PySide2.QtGui.QSessionManager.sessionKey": (),
    "PySide2.QtGui.QSessionManager.setDiscardCommand": ('typing.Sequence',),
    "PySide2.QtGui.QSessionManager.setManagerProperty": [('str', 'str'), ('str', 'typing.Sequence')],
    "PySide2.QtGui.QSessionManager.setRestartCommand": ('typing.Sequence',),
    "PySide2.QtGui.QSessionManager.setRestartHint": ('PySide2.QtGui.QSessionManager.RestartHint',),

# class PySide2.QtGui.QShortcutEvent:
    "PySide2.QtGui.QShortcutEvent.__init__": ('PySide2.QtGui.QKeySequence', 'int', 'bool'),
    "PySide2.QtGui.QShortcutEvent.isAmbiguous": (),
    "PySide2.QtGui.QShortcutEvent.key": (),
    "PySide2.QtGui.QShortcutEvent.shortcutId": (),

# class PySide2.QtGui.QShowEvent:
    "PySide2.QtGui.QShowEvent.__init__": (),

# class PySide2.QtGui.QStandardItem:

# class PySide2.QtGui.QStandardItem.ItemType:
    "PySide2.QtGui.QStandardItem.__init__": [(), ('PySide2.QtGui.QIcon', 'str'), ('PySide2.QtGui.QStandardItem',), ('int', 'int'), ('str',)],
    "PySide2.QtGui.QStandardItem.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QStandardItem.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QStandardItem.accessibleDescription": (),
    "PySide2.QtGui.QStandardItem.accessibleText": (),
    "PySide2.QtGui.QStandardItem.appendColumn": ('typing.Sequence',),
    "PySide2.QtGui.QStandardItem.appendRow": [('PySide2.QtGui.QStandardItem',), ('typing.Sequence',)],
    "PySide2.QtGui.QStandardItem.appendRows": ('typing.Sequence',),
    "PySide2.QtGui.QStandardItem.background": (),
    "PySide2.QtGui.QStandardItem.checkState": (),
    "PySide2.QtGui.QStandardItem.child": ('int', 'int'),
    "PySide2.QtGui.QStandardItem.clearData": (),
    "PySide2.QtGui.QStandardItem.clone": (),
    "PySide2.QtGui.QStandardItem.column": (),
    "PySide2.QtGui.QStandardItem.columnCount": (),
    "PySide2.QtGui.QStandardItem.data": ('int',),
    "PySide2.QtGui.QStandardItem.emitDataChanged": (),
    "PySide2.QtGui.QStandardItem.flags": (),
    "PySide2.QtGui.QStandardItem.font": (),
    "PySide2.QtGui.QStandardItem.foreground": (),
    "PySide2.QtGui.QStandardItem.hasChildren": (),
    "PySide2.QtGui.QStandardItem.icon": (),
    "PySide2.QtGui.QStandardItem.index": (),
    "PySide2.QtGui.QStandardItem.insertColumn": ('int', 'typing.Sequence'),
    "PySide2.QtGui.QStandardItem.insertColumns": ('int', 'int'),
    "PySide2.QtGui.QStandardItem.insertRow": [('int', 'PySide2.QtGui.QStandardItem'), ('int', 'typing.Sequence')],
    "PySide2.QtGui.QStandardItem.insertRows": [('int', 'int'), ('int', 'typing.Sequence')],
    "PySide2.QtGui.QStandardItem.isAutoTristate": (),
    "PySide2.QtGui.QStandardItem.isCheckable": (),
    "PySide2.QtGui.QStandardItem.isDragEnabled": (),
    "PySide2.QtGui.QStandardItem.isDropEnabled": (),
    "PySide2.QtGui.QStandardItem.isEditable": (),
    "PySide2.QtGui.QStandardItem.isEnabled": (),
    "PySide2.QtGui.QStandardItem.isSelectable": (),
    "PySide2.QtGui.QStandardItem.isTristate": (),
    "PySide2.QtGui.QStandardItem.isUserTristate": (),
    "PySide2.QtGui.QStandardItem.model": (),
    "PySide2.QtGui.QStandardItem.parent": (),
    "PySide2.QtGui.QStandardItem.read": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QStandardItem.removeColumn": ('int',),
    "PySide2.QtGui.QStandardItem.removeColumns": ('int', 'int'),
    "PySide2.QtGui.QStandardItem.removeRow": ('int',),
    "PySide2.QtGui.QStandardItem.removeRows": ('int', 'int'),
    "PySide2.QtGui.QStandardItem.row": (),
    "PySide2.QtGui.QStandardItem.rowCount": (),
    "PySide2.QtGui.QStandardItem.setAccessibleDescription": ('str',),
    "PySide2.QtGui.QStandardItem.setAccessibleText": ('str',),
    "PySide2.QtGui.QStandardItem.setAutoTristate": ('bool',),
    "PySide2.QtGui.QStandardItem.setBackground": ('PySide2.QtGui.QBrush',),
    "PySide2.QtGui.QStandardItem.setCheckState": ('PySide2.QtCore.Qt.CheckState',),
    "PySide2.QtGui.QStandardItem.setCheckable": ('bool',),
    "PySide2.QtGui.QStandardItem.setChild": [('int', 'PySide2.QtGui.QStandardItem'), ('int', 'int', 'PySide2.QtGui.QStandardItem')],
    "PySide2.QtGui.QStandardItem.setColumnCount": ('int',),
    "PySide2.QtGui.QStandardItem.setData": ('typing.Any', 'int'),
    "PySide2.QtGui.QStandardItem.setDragEnabled": ('bool',),
    "PySide2.QtGui.QStandardItem.setDropEnabled": ('bool',),
    "PySide2.QtGui.QStandardItem.setEditable": ('bool',),
    "PySide2.QtGui.QStandardItem.setEnabled": ('bool',),
    "PySide2.QtGui.QStandardItem.setFlags": ('PySide2.QtCore.Qt.ItemFlags',),
    "PySide2.QtGui.QStandardItem.setFont": ('PySide2.QtGui.QFont',),
    "PySide2.QtGui.QStandardItem.setForeground": ('PySide2.QtGui.QBrush',),
    "PySide2.QtGui.QStandardItem.setIcon": ('PySide2.QtGui.QIcon',),
    "PySide2.QtGui.QStandardItem.setRowCount": ('int',),
    "PySide2.QtGui.QStandardItem.setSelectable": ('bool',),
    "PySide2.QtGui.QStandardItem.setSizeHint": ('PySide2.QtCore.QSize',),
    "PySide2.QtGui.QStandardItem.setStatusTip": ('str',),
    "PySide2.QtGui.QStandardItem.setText": ('str',),
    "PySide2.QtGui.QStandardItem.setTextAlignment": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtGui.QStandardItem.setToolTip": ('str',),
    "PySide2.QtGui.QStandardItem.setTristate": ('bool',),
    "PySide2.QtGui.QStandardItem.setUserTristate": ('bool',),
    "PySide2.QtGui.QStandardItem.setWhatsThis": ('str',),
    "PySide2.QtGui.QStandardItem.sizeHint": (),
    "PySide2.QtGui.QStandardItem.sortChildren": ('int', 'PySide2.QtCore.Qt.SortOrder'),
    "PySide2.QtGui.QStandardItem.statusTip": (),
    "PySide2.QtGui.QStandardItem.takeChild": ('int', 'int'),
    "PySide2.QtGui.QStandardItem.takeColumn": ('int',),
    "PySide2.QtGui.QStandardItem.takeRow": ('int',),
    "PySide2.QtGui.QStandardItem.text": (),
    "PySide2.QtGui.QStandardItem.textAlignment": (),
    "PySide2.QtGui.QStandardItem.toolTip": (),
    "PySide2.QtGui.QStandardItem.type": (),
    "PySide2.QtGui.QStandardItem.whatsThis": (),
    "PySide2.QtGui.QStandardItem.write": ('PySide2.QtCore.QDataStream',),

# class PySide2.QtGui.QStandardItemModel:
    "PySide2.QtGui.QStandardItemModel.__init__": [('PySide2.QtCore.QObject',), ('int', 'int', 'PySide2.QtCore.QObject')],
    "PySide2.QtGui.QStandardItemModel.appendColumn": ('typing.Sequence',),
    "PySide2.QtGui.QStandardItemModel.appendRow": [('PySide2.QtGui.QStandardItem',), ('typing.Sequence',)],
    "PySide2.QtGui.QStandardItemModel.clear": (),
    "PySide2.QtGui.QStandardItemModel.clearItemData": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtGui.QStandardItemModel.columnCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtGui.QStandardItemModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtGui.QStandardItemModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtGui.QStandardItemModel.findItems": ('str', 'PySide2.QtCore.Qt.MatchFlags', 'int'),
    "PySide2.QtGui.QStandardItemModel.flags": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtGui.QStandardItemModel.hasChildren": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtGui.QStandardItemModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
    "PySide2.QtGui.QStandardItemModel.horizontalHeaderItem": ('int',),
    "PySide2.QtGui.QStandardItemModel.index": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtGui.QStandardItemModel.indexFromItem": ('PySide2.QtGui.QStandardItem',),
    "PySide2.QtGui.QStandardItemModel.insertColumn": [('int', 'PySide2.QtCore.QModelIndex'), ('int', 'typing.Sequence')],
    "PySide2.QtGui.QStandardItemModel.insertColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtGui.QStandardItemModel.insertRow": [('int', 'PySide2.QtCore.QModelIndex'), ('int', 'PySide2.QtGui.QStandardItem'), ('int', 'typing.Sequence')],
    "PySide2.QtGui.QStandardItemModel.insertRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtGui.QStandardItemModel.invisibleRootItem": (),
    "PySide2.QtGui.QStandardItemModel.item": ('int', 'int'),
    "PySide2.QtGui.QStandardItemModel.itemData": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtGui.QStandardItemModel.itemFromIndex": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtGui.QStandardItemModel.itemPrototype": (),
    "PySide2.QtGui.QStandardItemModel.mimeData": ('typing.List',),
    "PySide2.QtGui.QStandardItemModel.mimeTypes": (),
    "PySide2.QtGui.QStandardItemModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
    "PySide2.QtGui.QStandardItemModel.removeColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtGui.QStandardItemModel.removeRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtGui.QStandardItemModel.rowCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtGui.QStandardItemModel.setColumnCount": ('int',),
    "PySide2.QtGui.QStandardItemModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
    "PySide2.QtGui.QStandardItemModel.setHeaderData": ('int', 'PySide2.QtCore.Qt.Orientation', 'typing.Any', 'int'),
    "PySide2.QtGui.QStandardItemModel.setHorizontalHeaderItem": ('int', 'PySide2.QtGui.QStandardItem'),
    "PySide2.QtGui.QStandardItemModel.setHorizontalHeaderLabels": ('typing.Sequence',),
    "PySide2.QtGui.QStandardItemModel.setItem": [('int', 'PySide2.QtGui.QStandardItem'), ('int', 'int', 'PySide2.QtGui.QStandardItem')],
    "PySide2.QtGui.QStandardItemModel.setItemData": ('PySide2.QtCore.QModelIndex', 'typing.Dict'),
    "PySide2.QtGui.QStandardItemModel.setItemPrototype": ('PySide2.QtGui.QStandardItem',),
    "PySide2.QtGui.QStandardItemModel.setItemRoleNames": ('typing.Dict',),
    "PySide2.QtGui.QStandardItemModel.setRowCount": ('int',),
    "PySide2.QtGui.QStandardItemModel.setSortRole": ('int',),
    "PySide2.QtGui.QStandardItemModel.setVerticalHeaderItem": ('int', 'PySide2.QtGui.QStandardItem'),
    "PySide2.QtGui.QStandardItemModel.setVerticalHeaderLabels": ('typing.Sequence',),
    "PySide2.QtGui.QStandardItemModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtGui.QStandardItemModel.sort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
    "PySide2.QtGui.QStandardItemModel.sortRole": (),
    "PySide2.QtGui.QStandardItemModel.supportedDropActions": (),
    "PySide2.QtGui.QStandardItemModel.takeColumn": ('int',),
    "PySide2.QtGui.QStandardItemModel.takeHorizontalHeaderItem": ('int',),
    "PySide2.QtGui.QStandardItemModel.takeItem": ('int', 'int'),
    "PySide2.QtGui.QStandardItemModel.takeRow": ('int',),
    "PySide2.QtGui.QStandardItemModel.takeVerticalHeaderItem": ('int',),
    "PySide2.QtGui.QStandardItemModel.verticalHeaderItem": ('int',),

# class PySide2.QtGui.QStaticText:

# class PySide2.QtGui.QStaticText.PerformanceHint:
    "PySide2.QtGui.QStaticText.__init__": [(), ('PySide2.QtGui.QStaticText',), ('str',)],
    "PySide2.QtGui.QStaticText.__copy__": (),
    "PySide2.QtGui.QStaticText.performanceHint": (),
    "PySide2.QtGui.QStaticText.prepare": ('PySide2.QtGui.QTransform', 'PySide2.QtGui.QFont'),
    "PySide2.QtGui.QStaticText.setPerformanceHint": ('PySide2.QtGui.QStaticText.PerformanceHint',),
    "PySide2.QtGui.QStaticText.setText": ('str',),
    "PySide2.QtGui.QStaticText.setTextFormat": ('PySide2.QtCore.Qt.TextFormat',),
    "PySide2.QtGui.QStaticText.setTextOption": ('PySide2.QtGui.QTextOption',),
    "PySide2.QtGui.QStaticText.setTextWidth": ('float',),
    "PySide2.QtGui.QStaticText.size": (),
    "PySide2.QtGui.QStaticText.swap": ('PySide2.QtGui.QStaticText',),
    "PySide2.QtGui.QStaticText.text": (),
    "PySide2.QtGui.QStaticText.textFormat": (),
    "PySide2.QtGui.QStaticText.textOption": (),
    "PySide2.QtGui.QStaticText.textWidth": (),

# class PySide2.QtGui.QStatusTipEvent:
    "PySide2.QtGui.QStatusTipEvent.__init__": ('str',),
    "PySide2.QtGui.QStatusTipEvent.tip": (),

# class PySide2.QtGui.QStyleHints:
    "PySide2.QtGui.QStyleHints.cursorFlashTime": (),
    "PySide2.QtGui.QStyleHints.fontSmoothingGamma": (),
    "PySide2.QtGui.QStyleHints.keyboardAutoRepeatRate": (),
    "PySide2.QtGui.QStyleHints.keyboardInputInterval": (),
    "PySide2.QtGui.QStyleHints.mouseDoubleClickDistance": (),
    "PySide2.QtGui.QStyleHints.mouseDoubleClickInterval": (),
    "PySide2.QtGui.QStyleHints.mousePressAndHoldInterval": (),
    "PySide2.QtGui.QStyleHints.mouseQuickSelectionThreshold": (),
    "PySide2.QtGui.QStyleHints.passwordMaskCharacter": (),
    "PySide2.QtGui.QStyleHints.passwordMaskDelay": (),
    "PySide2.QtGui.QStyleHints.setCursorFlashTime": ('int',),
    "PySide2.QtGui.QStyleHints.setFocusOnTouchRelease": (),
    "PySide2.QtGui.QStyleHints.setKeyboardInputInterval": ('int',),
    "PySide2.QtGui.QStyleHints.setMouseDoubleClickInterval": ('int',),
    "PySide2.QtGui.QStyleHints.setMousePressAndHoldInterval": ('int',),
    "PySide2.QtGui.QStyleHints.setMouseQuickSelectionThreshold": ('int',),
    "PySide2.QtGui.QStyleHints.setShowShortcutsInContextMenus": ('bool',),
    "PySide2.QtGui.QStyleHints.setStartDragDistance": ('int',),
    "PySide2.QtGui.QStyleHints.setStartDragTime": ('int',),
    "PySide2.QtGui.QStyleHints.setTabFocusBehavior": ('PySide2.QtCore.Qt.TabFocusBehavior',),
    "PySide2.QtGui.QStyleHints.setUseHoverEffects": ('bool',),
    "PySide2.QtGui.QStyleHints.setWheelScrollLines": ('int',),
    "PySide2.QtGui.QStyleHints.showIsFullScreen": (),
    "PySide2.QtGui.QStyleHints.showIsMaximized": (),
    "PySide2.QtGui.QStyleHints.showShortcutsInContextMenus": (),
    "PySide2.QtGui.QStyleHints.singleClickActivation": (),
    "PySide2.QtGui.QStyleHints.startDragDistance": (),
    "PySide2.QtGui.QStyleHints.startDragTime": (),
    "PySide2.QtGui.QStyleHints.startDragVelocity": (),
    "PySide2.QtGui.QStyleHints.tabFocusBehavior": (),
    "PySide2.QtGui.QStyleHints.touchDoubleTapDistance": (),
    "PySide2.QtGui.QStyleHints.useHoverEffects": (),
    "PySide2.QtGui.QStyleHints.useRtlExtensions": (),
    "PySide2.QtGui.QStyleHints.wheelScrollLines": (),

# class PySide2.QtGui.QSurface:

# class PySide2.QtGui.QSurface.SurfaceClass:

# class PySide2.QtGui.QSurface.SurfaceType:
    "PySide2.QtGui.QSurface.__init__": ('PySide2.QtGui.QSurface.SurfaceClass',),
    "PySide2.QtGui.QSurface.format": (),
    "PySide2.QtGui.QSurface.size": (),
    "PySide2.QtGui.QSurface.supportsOpenGL": (),
    "PySide2.QtGui.QSurface.surfaceClass": (),
    "PySide2.QtGui.QSurface.surfaceHandle": (),
    "PySide2.QtGui.QSurface.surfaceType": (),

# class PySide2.QtGui.QSurfaceFormat:

# class PySide2.QtGui.QSurfaceFormat.ColorSpace:

# class PySide2.QtGui.QSurfaceFormat.FormatOption:

# class PySide2.QtGui.QSurfaceFormat.FormatOptions:

# class PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile:

# class PySide2.QtGui.QSurfaceFormat.RenderableType:

# class PySide2.QtGui.QSurfaceFormat.SwapBehavior:
    "PySide2.QtGui.QSurfaceFormat.__init__": [(), ('PySide2.QtGui.QSurfaceFormat',), ('PySide2.QtGui.QSurfaceFormat.FormatOptions',)],
    "PySide2.QtGui.QSurfaceFormat.__copy__": (),
    "PySide2.QtGui.QSurfaceFormat.alphaBufferSize": (),
    "PySide2.QtGui.QSurfaceFormat.blueBufferSize": (),
    "PySide2.QtGui.QSurfaceFormat.colorSpace": (),
    "PySide2.QtGui.QSurfaceFormat.defaultFormat": (),
    "PySide2.QtGui.QSurfaceFormat.depthBufferSize": (),
    "PySide2.QtGui.QSurfaceFormat.greenBufferSize": (),
    "PySide2.QtGui.QSurfaceFormat.hasAlpha": (),
    "PySide2.QtGui.QSurfaceFormat.majorVersion": (),
    "PySide2.QtGui.QSurfaceFormat.minorVersion": (),
    "PySide2.QtGui.QSurfaceFormat.options": (),
    "PySide2.QtGui.QSurfaceFormat.profile": (),
    "PySide2.QtGui.QSurfaceFormat.redBufferSize": (),
    "PySide2.QtGui.QSurfaceFormat.renderableType": (),
    "PySide2.QtGui.QSurfaceFormat.samples": (),
    "PySide2.QtGui.QSurfaceFormat.setAlphaBufferSize": ('int',),
    "PySide2.QtGui.QSurfaceFormat.setBlueBufferSize": ('int',),
    "PySide2.QtGui.QSurfaceFormat.setColorSpace": ('PySide2.QtGui.QSurfaceFormat.ColorSpace',),
    "PySide2.QtGui.QSurfaceFormat.setDefaultFormat": ('PySide2.QtGui.QSurfaceFormat',),
    "PySide2.QtGui.QSurfaceFormat.setDepthBufferSize": ('int',),
    "PySide2.QtGui.QSurfaceFormat.setGreenBufferSize": ('int',),
    "PySide2.QtGui.QSurfaceFormat.setMajorVersion": ('int',),
    "PySide2.QtGui.QSurfaceFormat.setMinorVersion": ('int',),
    "PySide2.QtGui.QSurfaceFormat.setOption": [('PySide2.QtGui.QSurfaceFormat.FormatOption', 'bool'), ('PySide2.QtGui.QSurfaceFormat.FormatOptions',)],
    "PySide2.QtGui.QSurfaceFormat.setOptions": ('PySide2.QtGui.QSurfaceFormat.FormatOptions',),
    "PySide2.QtGui.QSurfaceFormat.setProfile": ('PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile',),
    "PySide2.QtGui.QSurfaceFormat.setRedBufferSize": ('int',),
    "PySide2.QtGui.QSurfaceFormat.setRenderableType": ('PySide2.QtGui.QSurfaceFormat.RenderableType',),
    "PySide2.QtGui.QSurfaceFormat.setSamples": ('int',),
    "PySide2.QtGui.QSurfaceFormat.setStencilBufferSize": ('int',),
    "PySide2.QtGui.QSurfaceFormat.setStereo": ('bool',),
    "PySide2.QtGui.QSurfaceFormat.setSwapBehavior": ('PySide2.QtGui.QSurfaceFormat.SwapBehavior',),
    "PySide2.QtGui.QSurfaceFormat.setSwapInterval": ('int',),
    "PySide2.QtGui.QSurfaceFormat.setVersion": ('int', 'int'),
    "PySide2.QtGui.QSurfaceFormat.stencilBufferSize": (),
    "PySide2.QtGui.QSurfaceFormat.stereo": (),
    "PySide2.QtGui.QSurfaceFormat.swapBehavior": (),
    "PySide2.QtGui.QSurfaceFormat.swapInterval": (),
    "PySide2.QtGui.QSurfaceFormat.testOption": [('PySide2.QtGui.QSurfaceFormat.FormatOption',), ('PySide2.QtGui.QSurfaceFormat.FormatOptions',)],
    "PySide2.QtGui.QSurfaceFormat.version": (),

# class PySide2.QtGui.QSyntaxHighlighter:
    "PySide2.QtGui.QSyntaxHighlighter.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtGui.QTextDocument',)],
    "PySide2.QtGui.QSyntaxHighlighter.currentBlock": (),
    "PySide2.QtGui.QSyntaxHighlighter.currentBlockState": (),
    "PySide2.QtGui.QSyntaxHighlighter.currentBlockUserData": (),
    "PySide2.QtGui.QSyntaxHighlighter.document": (),
    "PySide2.QtGui.QSyntaxHighlighter.format": ('int',),
    "PySide2.QtGui.QSyntaxHighlighter.highlightBlock": ('str',),
    "PySide2.QtGui.QSyntaxHighlighter.previousBlockState": (),
    "PySide2.QtGui.QSyntaxHighlighter.rehighlight": (),
    "PySide2.QtGui.QSyntaxHighlighter.rehighlightBlock": ('PySide2.QtGui.QTextBlock',),
    "PySide2.QtGui.QSyntaxHighlighter.setCurrentBlockState": ('int',),
    "PySide2.QtGui.QSyntaxHighlighter.setCurrentBlockUserData": ('PySide2.QtGui.QTextBlockUserData',),
    "PySide2.QtGui.QSyntaxHighlighter.setDocument": ('PySide2.QtGui.QTextDocument',),
    "PySide2.QtGui.QSyntaxHighlighter.setFormat": [('int', 'int', 'PySide2.QtGui.QColor'), ('int', 'int', 'PySide2.QtGui.QFont'), ('int', 'int', 'PySide2.QtGui.QTextCharFormat')],

# class PySide2.QtGui.QTabletEvent:

# class PySide2.QtGui.QTabletEvent.PointerType:

# class PySide2.QtGui.QTabletEvent.TabletDevice:
    "PySide2.QtGui.QTabletEvent.__init__": [('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'int', 'int', 'float', 'int', 'int', 'float', 'float', 'int', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int'), ('PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'int', 'int', 'float', 'int', 'int', 'float', 'float', 'int', 'PySide2.QtCore.Qt.KeyboardModifiers', 'int', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.Qt.MouseButtons')],
    "PySide2.QtGui.QTabletEvent.button": (),
    "PySide2.QtGui.QTabletEvent.buttons": (),
    "PySide2.QtGui.QTabletEvent.device": (),
    "PySide2.QtGui.QTabletEvent.globalPos": (),
    "PySide2.QtGui.QTabletEvent.globalPosF": (),
    "PySide2.QtGui.QTabletEvent.globalX": (),
    "PySide2.QtGui.QTabletEvent.global""Y": (),
    "PySide2.QtGui.QTabletEvent.hiResGlobalX": (),
    "PySide2.QtGui.QTabletEvent.hiResGlobal""Y": (),
    "PySide2.QtGui.QTabletEvent.pointerType": (),
    "PySide2.QtGui.QTabletEvent.pos": (),
    "PySide2.QtGui.QTabletEvent.posF": (),
    "PySide2.QtGui.QTabletEvent.pressure": (),
    "PySide2.QtGui.QTabletEvent.rotation": (),
    "PySide2.QtGui.QTabletEvent.tangentialPressure": (),
    "PySide2.QtGui.QTabletEvent.uniqueId": (),
    "PySide2.QtGui.QTabletEvent.x": (),
    "PySide2.QtGui.QTabletEvent.xTilt": (),
    "PySide2.QtGui.QTabletEvent.y": (),
    "PySide2.QtGui.QTabletEvent.yTilt": (),
    "PySide2.QtGui.QTabletEvent.z": (),

# class PySide2.QtGui.QTextBlock:

# class PySide2.QtGui.QTextBlock.iterator:
    "PySide2.QtGui.QTextBlock.iterator.__init__": [(), ('PySide2.QtGui.QTextBlock.iterator',)],
    "PySide2.QtGui.QTextBlock.iterator.__copy__": (),
    "PySide2.QtGui.QTextBlock.iterator.__iadd__": ('int',),
    "PySide2.QtGui.QTextBlock.iterator.__isub__": ('int',),
    "PySide2.QtGui.QTextBlock.iterator.__iter__": (),
    "PySide2.QtGui.QTextBlock.iterator.atEnd": (),
    "PySide2.QtGui.QTextBlock.iterator.fragment": (),

    "PySide2.QtGui.QTextBlock.__init__": [(), ('PySide2.QtGui.QTextBlock',)],
    "PySide2.QtGui.QTextBlock.__copy__": (),
    "PySide2.QtGui.QTextBlock.__iter__": (),
    "PySide2.QtGui.QTextBlock.begin": (),
    "PySide2.QtGui.QTextBlock.blockFormat": (),
    "PySide2.QtGui.QTextBlock.blockFormatIndex": (),
    "PySide2.QtGui.QTextBlock.blockNumber": (),
    "PySide2.QtGui.QTextBlock.charFormat": (),
    "PySide2.QtGui.QTextBlock.charFormatIndex": (),
    "PySide2.QtGui.QTextBlock.clearLayout": (),
    "PySide2.QtGui.QTextBlock.contains": ('int',),
    "PySide2.QtGui.QTextBlock.document": (),
    "PySide2.QtGui.QTextBlock.end": (),
    "PySide2.QtGui.QTextBlock.firstLineNumber": (),
    "PySide2.QtGui.QTextBlock.fragmentIndex": (),
    "PySide2.QtGui.QTextBlock.isValid": (),
    "PySide2.QtGui.QTextBlock.isVisible": (),
    "PySide2.QtGui.QTextBlock.layout": (),
    "PySide2.QtGui.QTextBlock.length": (),
    "PySide2.QtGui.QTextBlock.lineCount": (),
    "PySide2.QtGui.QTextBlock.position": (),
    "PySide2.QtGui.QTextBlock.previous": (),
    "PySide2.QtGui.QTextBlock.revision": (),
    "PySide2.QtGui.QTextBlock.setLineCount": ('int',),
    "PySide2.QtGui.QTextBlock.setRevision": ('int',),
    "PySide2.QtGui.QTextBlock.setUserData": ('PySide2.QtGui.QTextBlockUserData',),
    "PySide2.QtGui.QTextBlock.setUserState": ('int',),
    "PySide2.QtGui.QTextBlock.setVisible": ('bool',),
    "PySide2.QtGui.QTextBlock.text": (),
    "PySide2.QtGui.QTextBlock.textDirection": (),
    "PySide2.QtGui.QTextBlock.textFormats": (),
    "PySide2.QtGui.QTextBlock.textList": (),
    "PySide2.QtGui.QTextBlock.userData": (),
    "PySide2.QtGui.QTextBlock.userState": (),

# class PySide2.QtGui.QTextBlockFormat:

# class PySide2.QtGui.QTextBlockFormat.LineHeightTypes:

# class PySide2.QtGui.QTextBlockFormat.MarkerType:
    "PySide2.QtGui.QTextBlockFormat.__init__": [(), ('PySide2.QtGui.QTextBlockFormat',), ('PySide2.QtGui.QTextFormat',)],
    "PySide2.QtGui.QTextBlockFormat.__copy__": (),
    "PySide2.QtGui.QTextBlockFormat.alignment": (),
    "PySide2.QtGui.QTextBlockFormat.bottomMargin": (),
    "PySide2.QtGui.QTextBlockFormat.headingLevel": (),
    "PySide2.QtGui.QTextBlockFormat.indent": (),
    "PySide2.QtGui.QTextBlockFormat.isValid": (),
    "PySide2.QtGui.QTextBlockFormat.leftMargin": (),
    "PySide2.QtGui.QTextBlockFormat.lineHeight": [(), ('float', 'float')],
    "PySide2.QtGui.QTextBlockFormat.lineHeightType": (),
    "PySide2.QtGui.QTextBlockFormat.marker": (),
    "PySide2.QtGui.QTextBlockFormat.nonBreakableLines": (),
    "PySide2.QtGui.QTextBlockFormat.pageBreakPolicy": (),
    "PySide2.QtGui.QTextBlockFormat.rightMargin": (),
    "PySide2.QtGui.QTextBlockFormat.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtGui.QTextBlockFormat.setBottomMargin": ('float',),
    "PySide2.QtGui.QTextBlockFormat.setHeadingLevel": ('int',),
    "PySide2.QtGui.QTextBlockFormat.setIndent": ('int',),
    "PySide2.QtGui.QTextBlockFormat.setLeftMargin": ('float',),
    "PySide2.QtGui.QTextBlockFormat.setLineHeight": ('float', 'int'),
    "PySide2.QtGui.QTextBlockFormat.setMarker": ('PySide2.QtGui.QTextBlockFormat.MarkerType',),
    "PySide2.QtGui.QTextBlockFormat.setNonBreakableLines": ('bool',),
    "PySide2.QtGui.QTextBlockFormat.setPageBreakPolicy": ('PySide2.QtGui.QTextFormat.PageBreakFlags',),
    "PySide2.QtGui.QTextBlockFormat.setRightMargin": ('float',),
    "PySide2.QtGui.QTextBlockFormat.setTabPositions": ('typing.Sequence',),
    "PySide2.QtGui.QTextBlockFormat.setTextIndent": ('float',),
    "PySide2.QtGui.QTextBlockFormat.setTopMargin": ('float',),
    "PySide2.QtGui.QTextBlockFormat.tabPositions": (),
    "PySide2.QtGui.QTextBlockFormat.textIndent": (),
    "PySide2.QtGui.QTextBlockFormat.topMargin": (),

# class PySide2.QtGui.QTextBlockGroup:
    "PySide2.QtGui.QTextBlockGroup.__init__": ('PySide2.QtGui.QTextDocument',),
    "PySide2.QtGui.QTextBlockGroup.blockFormatChanged": ('PySide2.QtGui.QTextBlock',),
    "PySide2.QtGui.QTextBlockGroup.blockInserted": ('PySide2.QtGui.QTextBlock',),
    "PySide2.QtGui.QTextBlockGroup.blockList": (),
    "PySide2.QtGui.QTextBlockGroup.blockRemoved": ('PySide2.QtGui.QTextBlock',),

# class PySide2.QtGui.QTextBlockUserData:
    "PySide2.QtGui.QTextBlockUserData.__init__": (),

# class PySide2.QtGui.QTextCharFormat:

# class PySide2.QtGui.QTextCharFormat.FontPropertiesInheritanceBehavior:

# class PySide2.QtGui.QTextCharFormat.UnderlineStyle:

# class PySide2.QtGui.QTextCharFormat.VerticalAlignment:
    "PySide2.QtGui.QTextCharFormat.__init__": [(), ('PySide2.QtGui.QTextCharFormat',), ('PySide2.QtGui.QTextFormat',)],
    "PySide2.QtGui.QTextCharFormat.__copy__": (),
    "PySide2.QtGui.QTextCharFormat.anchorHref": (),
    "PySide2.QtGui.QTextCharFormat.anchorName": (),
    "PySide2.QtGui.QTextCharFormat.anchorNames": (),
    "PySide2.QtGui.QTextCharFormat.font": (),
    "PySide2.QtGui.QTextCharFormat.fontCapitalization": (),
    "PySide2.QtGui.QTextCharFormat.fontFamilies": (),
    "PySide2.QtGui.QTextCharFormat.fontFamily": (),
    "PySide2.QtGui.QTextCharFormat.fontFixedPitch": (),
    "PySide2.QtGui.QTextCharFormat.fontHintingPreference": (),
    "PySide2.QtGui.QTextCharFormat.fontItalic": (),
    "PySide2.QtGui.QTextCharFormat.fontKerning": (),
    "PySide2.QtGui.QTextCharFormat.fontLetterSpacing": (),
    "PySide2.QtGui.QTextCharFormat.fontLetterSpacingType": (),
    "PySide2.QtGui.QTextCharFormat.fontOverline": (),
    "PySide2.QtGui.QTextCharFormat.fontPointSize": (),
    "PySide2.QtGui.QTextCharFormat.fontStretch": (),
    "PySide2.QtGui.QTextCharFormat.fontStrikeOut": (),
    "PySide2.QtGui.QTextCharFormat.fontStyleHint": (),
    "PySide2.QtGui.QTextCharFormat.fontStyleName": (),
    "PySide2.QtGui.QTextCharFormat.fontStyleStrategy": (),
    "PySide2.QtGui.QTextCharFormat.fontUnderline": (),
    "PySide2.QtGui.QTextCharFormat.fontWeight": (),
    "PySide2.QtGui.QTextCharFormat.fontWordSpacing": (),
    "PySide2.QtGui.QTextCharFormat.isAnchor": (),
    "PySide2.QtGui.QTextCharFormat.isValid": (),
    "PySide2.QtGui.QTextCharFormat.setAnchor": ('bool',),
    "PySide2.QtGui.QTextCharFormat.setAnchorHref": ('str',),
    "PySide2.QtGui.QTextCharFormat.setAnchorName": ('str',),
    "PySide2.QtGui.QTextCharFormat.setAnchorNames": ('typing.Sequence',),
    "PySide2.QtGui.QTextCharFormat.setFont": [('PySide2.QtGui.QFont',), ('PySide2.QtGui.QFont', 'PySide2.QtGui.QTextCharFormat.FontPropertiesInheritanceBehavior')],
    "PySide2.QtGui.QTextCharFormat.setFontCapitalization": ('PySide2.QtGui.QFont.Capitalization',),
    "PySide2.QtGui.QTextCharFormat.setFontFamilies": ('typing.Sequence',),
    "PySide2.QtGui.QTextCharFormat.setFontFamily": ('str',),
    "PySide2.QtGui.QTextCharFormat.setFontFixedPitch": ('bool',),
    "PySide2.QtGui.QTextCharFormat.setFontHintingPreference": ('PySide2.QtGui.QFont.HintingPreference',),
    "PySide2.QtGui.QTextCharFormat.setFontItalic": ('bool',),
    "PySide2.QtGui.QTextCharFormat.setFontKerning": ('bool',),
    "PySide2.QtGui.QTextCharFormat.setFontLetterSpacing": ('float',),
    "PySide2.QtGui.QTextCharFormat.setFontLetterSpacingType": ('PySide2.QtGui.QFont.SpacingType',),
    "PySide2.QtGui.QTextCharFormat.setFontOverline": ('bool',),
    "PySide2.QtGui.QTextCharFormat.setFontPointSize": ('float',),
    "PySide2.QtGui.QTextCharFormat.setFontStretch": ('int',),
    "PySide2.QtGui.QTextCharFormat.setFontStrikeOut": ('bool',),
    "PySide2.QtGui.QTextCharFormat.setFontStyleHint": ('PySide2.QtGui.QFont.StyleHint', 'PySide2.QtGui.QFont.StyleStrategy'),
    "PySide2.QtGui.QTextCharFormat.setFontStyleName": ('str',),
    "PySide2.QtGui.QTextCharFormat.setFontStyleStrategy": ('PySide2.QtGui.QFont.StyleStrategy',),
    "PySide2.QtGui.QTextCharFormat.setFontUnderline": ('bool',),
    "PySide2.QtGui.QTextCharFormat.setFontWeight": ('int',),
    "PySide2.QtGui.QTextCharFormat.setFontWordSpacing": ('float',),
    "PySide2.QtGui.QTextCharFormat.setTableCellColumnSpan": ('int',),
    "PySide2.QtGui.QTextCharFormat.setTableCellRowSpan": ('int',),
    "PySide2.QtGui.QTextCharFormat.setTextOutline": ('PySide2.QtGui.QPen',),
    "PySide2.QtGui.QTextCharFormat.setToolTip": ('str',),
    "PySide2.QtGui.QTextCharFormat.setUnderlineColor": ('PySide2.QtGui.QColor',),
    "PySide2.QtGui.QTextCharFormat.setUnderlineStyle": ('PySide2.QtGui.QTextCharFormat.UnderlineStyle',),
    "PySide2.QtGui.QTextCharFormat.setVerticalAlignment": ('PySide2.QtGui.QTextCharFormat.VerticalAlignment',),
    "PySide2.QtGui.QTextCharFormat.tableCellColumnSpan": (),
    "PySide2.QtGui.QTextCharFormat.tableCellRowSpan": (),
    "PySide2.QtGui.QTextCharFormat.textOutline": (),
    "PySide2.QtGui.QTextCharFormat.toolTip": (),
    "PySide2.QtGui.QTextCharFormat.underlineColor": (),
    "PySide2.QtGui.QTextCharFormat.underlineStyle": (),
    "PySide2.QtGui.QTextCharFormat.verticalAlignment": (),

# class PySide2.QtGui.QTextCursor:

# class PySide2.QtGui.QTextCursor.MoveMode:

# class PySide2.QtGui.QTextCursor.MoveOperation:

# class PySide2.QtGui.QTextCursor.SelectionType:
    "PySide2.QtGui.QTextCursor.__init__": [(), ('PySide2.QtGui.QTextBlock',), ('PySide2.QtGui.QTextCursor',), ('PySide2.QtGui.QTextDocument',), ('PySide2.QtGui.QTextFrame',)],
    "PySide2.QtGui.QTextCursor.__copy__": (),
    "PySide2.QtGui.QTextCursor.anchor": (),
    "PySide2.QtGui.QTextCursor.atBlockEnd": (),
    "PySide2.QtGui.QTextCursor.atBlockStart": (),
    "PySide2.QtGui.QTextCursor.atEnd": (),
    "PySide2.QtGui.QTextCursor.atStart": (),
    "PySide2.QtGui.QTextCursor.beginEditBlock": (),
    "PySide2.QtGui.QTextCursor.block": (),
    "PySide2.QtGui.QTextCursor.blockCharFormat": (),
    "PySide2.QtGui.QTextCursor.blockFormat": (),
    "PySide2.QtGui.QTextCursor.blockNumber": (),
    "PySide2.QtGui.QTextCursor.charFormat": (),
    "PySide2.QtGui.QTextCursor.clearSelection": (),
    "PySide2.QtGui.QTextCursor.columnNumber": (),
    "PySide2.QtGui.QTextCursor.createList": [('PySide2.QtGui.QTextListFormat',), ('PySide2.QtGui.QTextListFormat.Style',)],
    "PySide2.QtGui.QTextCursor.currentFrame": (),
    "PySide2.QtGui.QTextCursor.currentList": (),
    "PySide2.QtGui.QTextCursor.currentTable": (),
    "PySide2.QtGui.QTextCursor.deleteChar": (),
    "PySide2.QtGui.QTextCursor.deletePreviousChar": (),
    "PySide2.QtGui.QTextCursor.document": (),
    "PySide2.QtGui.QTextCursor.endEditBlock": (),
    "PySide2.QtGui.QTextCursor.hasComplexSelection": (),
    "PySide2.QtGui.QTextCursor.hasSelection": (),
    "PySide2.QtGui.QTextCursor.insertBlock": [(), ('PySide2.QtGui.QTextBlockFormat',), ('PySide2.QtGui.QTextBlockFormat', 'PySide2.QtGui.QTextCharFormat')],
    "PySide2.QtGui.QTextCursor.insertFragment": ('PySide2.QtGui.QTextDocumentFragment',),
    "PySide2.QtGui.QTextCursor.insertFrame": ('PySide2.QtGui.QTextFrameFormat',),
    "PySide2.QtGui.QTextCursor.insertHtml": ('str',),
    "PySide2.QtGui.QTextCursor.insertImage": [('PySide2.QtGui.QImage', 'str'), ('PySide2.QtGui.QTextImageFormat',), ('PySide2.QtGui.QTextImageFormat', 'PySide2.QtGui.QTextFrameFormat.Position'), ('str',)],
    "PySide2.QtGui.QTextCursor.insertList": [('PySide2.QtGui.QTextListFormat',), ('PySide2.QtGui.QTextListFormat.Style',)],
    "PySide2.QtGui.QTextCursor.insertTable": [('int', 'int'), ('int', 'int', 'PySide2.QtGui.QTextTableFormat')],
    "PySide2.QtGui.QTextCursor.insertText": [('str',), ('str', 'PySide2.QtGui.QTextCharFormat')],
    "PySide2.QtGui.QTextCursor.isCopyOf": ('PySide2.QtGui.QTextCursor',),
    "PySide2.QtGui.QTextCursor.isNull": (),
    "PySide2.QtGui.QTextCursor.joinPreviousEditBlock": (),
    "PySide2.QtGui.QTextCursor.keepPositionOnInsert": (),
    "PySide2.QtGui.QTextCursor.mergeBlockCharFormat": ('PySide2.QtGui.QTextCharFormat',),
    "PySide2.QtGui.QTextCursor.mergeBlockFormat": ('PySide2.QtGui.QTextBlockFormat',),
    "PySide2.QtGui.QTextCursor.mergeCharFormat": ('PySide2.QtGui.QTextCharFormat',),
    "PySide2.QtGui.QTextCursor.movePosition": ('PySide2.QtGui.QTextCursor.MoveOperation', 'PySide2.QtGui.QTextCursor.MoveMode', 'int'),
    "PySide2.QtGui.QTextCursor.position": (),
    "PySide2.QtGui.QTextCursor.positionInBlock": (),
    "PySide2.QtGui.QTextCursor.removeSelectedText": (),
    "PySide2.QtGui.QTextCursor.select": ('PySide2.QtGui.QTextCursor.SelectionType',),
    "PySide2.QtGui.QTextCursor.selectedTableCells": (),
    "PySide2.QtGui.QTextCursor.selectedText": (),
    "PySide2.QtGui.QTextCursor.selection": (),
    "PySide2.QtGui.QTextCursor.selectionEnd": (),
    "PySide2.QtGui.QTextCursor.selectionStart": (),
    "PySide2.QtGui.QTextCursor.setBlockCharFormat": ('PySide2.QtGui.QTextCharFormat',),
    "PySide2.QtGui.QTextCursor.setBlockFormat": ('PySide2.QtGui.QTextBlockFormat',),
    "PySide2.QtGui.QTextCursor.setCharFormat": ('PySide2.QtGui.QTextCharFormat',),
    "PySide2.QtGui.QTextCursor.setKeepPositionOnInsert": ('bool',),
    "PySide2.QtGui.QTextCursor.setPosition": ('int', 'PySide2.QtGui.QTextCursor.MoveMode'),
    "PySide2.QtGui.QTextCursor.setVerticalMovementX": ('int',),
    "PySide2.QtGui.QTextCursor.setVisualNavigation": ('bool',),
    "PySide2.QtGui.QTextCursor.swap": ('PySide2.QtGui.QTextCursor',),
    "PySide2.QtGui.QTextCursor.verticalMovementX": (),
    "PySide2.QtGui.QTextCursor.visualNavigation": (),

# class PySide2.QtGui.QTextDocument:

# class PySide2.QtGui.QTextDocument.FindFlag:

# class PySide2.QtGui.QTextDocument.FindFlags:

# class PySide2.QtGui.QTextDocument.MarkdownFeature:

# class PySide2.QtGui.QTextDocument.MarkdownFeatures:

# class PySide2.QtGui.QTextDocument.MetaInformation:

# class PySide2.QtGui.QTextDocument.ResourceType:

# class PySide2.QtGui.QTextDocument.Stacks:
    "PySide2.QtGui.QTextDocument.__init__": [('PySide2.QtCore.QObject',), ('str', 'PySide2.QtCore.QObject')],
    "PySide2.QtGui.QTextDocument.addResource": ('int', 'PySide2.QtCore.QUrl', 'typing.Any'),
    "PySide2.QtGui.QTextDocument.adjustSize": (),
    "PySide2.QtGui.QTextDocument.allFormats": (),
    "PySide2.QtGui.QTextDocument.availableRedoSteps": (),
    "PySide2.QtGui.QTextDocument.availableUndoSteps": (),
    "PySide2.QtGui.QTextDocument.baseUrl": (),
    "PySide2.QtGui.QTextDocument.begin": (),
    "PySide2.QtGui.QTextDocument.blockCount": (),
    "PySide2.QtGui.QTextDocument.characterAt": ('int',),
    "PySide2.QtGui.QTextDocument.characterCount": (),
    "PySide2.QtGui.QTextDocument.clear": (),
    "PySide2.QtGui.QTextDocument.clearUndoRedoStacks": ('PySide2.QtGui.QTextDocument.Stacks',),
    "PySide2.QtGui.QTextDocument.clone": ('PySide2.QtCore.QObject',),
    "PySide2.QtGui.QTextDocument.createObject": ('PySide2.QtGui.QTextFormat',),
    "PySide2.QtGui.QTextDocument.defaultCursorMoveStyle": (),
    "PySide2.QtGui.QTextDocument.defaultFont": (),
    "PySide2.QtGui.QTextDocument.defaultStyleSheet": (),
    "PySide2.QtGui.QTextDocument.defaultTextOption": (),
    "PySide2.QtGui.QTextDocument.documentLayout": (),
    "PySide2.QtGui.QTextDocument.documentMargin": (),
    "PySide2.QtGui.QTextDocument.drawContents": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF'),
    "PySide2.QtGui.QTextDocument.end": (),
    "PySide2.QtGui.QTextDocument.find": [('PySide2.QtCore.QRegExp', 'PySide2.QtGui.QTextCursor', 'PySide2.QtGui.QTextDocument.FindFlags'), ('PySide2.QtCore.QRegExp', 'int', 'PySide2.QtGui.QTextDocument.FindFlags'), ('PySide2.QtCore.QRegularExpression', 'PySide2.QtGui.QTextCursor', 'PySide2.QtGui.QTextDocument.FindFlags'), ('PySide2.QtCore.QRegularExpression', 'int', 'PySide2.QtGui.QTextDocument.FindFlags'), ('str', 'PySide2.QtGui.QTextCursor', 'PySide2.QtGui.QTextDocument.FindFlags'), ('str', 'int', 'PySide2.QtGui.QTextDocument.FindFlags')],
    "PySide2.QtGui.QTextDocument.findBlock": ('int',),
    "PySide2.QtGui.QTextDocument.findBlockByLineNumber": ('int',),
    "PySide2.QtGui.QTextDocument.findBlockByNumber": ('int',),
    "PySide2.QtGui.QTextDocument.firstBlock": (),
    "PySide2.QtGui.QTextDocument.frameAt": ('int',),
    "PySide2.QtGui.QTextDocument.idealWidth": (),
    "PySide2.QtGui.QTextDocument.indentWidth": (),
    "PySide2.QtGui.QTextDocument.isEmpty": (),
    "PySide2.QtGui.QTextDocument.isModified": (),
    "PySide2.QtGui.QTextDocument.isRedoAvailable": (),
    "PySide2.QtGui.QTextDocument.isUndoAvailable": (),
    "PySide2.QtGui.QTextDocument.isUndoRedoEnabled": (),
    "PySide2.QtGui.QTextDocument.lastBlock": (),
    "PySide2.QtGui.QTextDocument.lineCount": (),
    "PySide2.QtGui.QTextDocument.loadResource": ('int', 'PySide2.QtCore.QUrl'),
    "PySide2.QtGui.QTextDocument.markContentsDirty": ('int', 'int'),
    "PySide2.QtGui.QTextDocument.maximumBlockCount": (),
    "PySide2.QtGui.QTextDocument.metaInformation": ('PySide2.QtGui.QTextDocument.MetaInformation',),
    "PySide2.QtGui.QTextDocument.object": ('int',),
    "PySide2.QtGui.QTextDocument.objectForFormat": ('PySide2.QtGui.QTextFormat',),
    "PySide2.QtGui.QTextDocument.pageCount": (),
    "PySide2.QtGui.QTextDocument.pageSize": (),
    "PySide2.QtGui.QTextDocument.print_": ('PySide2.QtGui.QPagedPaintDevice',),
    "PySide2.QtGui.QTextDocument.redo": [(), ('PySide2.QtGui.QTextCursor',)],
    "PySide2.QtGui.QTextDocument.resource": ('int', 'PySide2.QtCore.QUrl'),
    "PySide2.QtGui.QTextDocument.revision": (),
    "PySide2.QtGui.QTextDocument.rootFrame": (),
    "PySide2.QtGui.QTextDocument.setBaseUrl": ('PySide2.QtCore.QUrl',),
    "PySide2.QtGui.QTextDocument.setDefaultCursorMoveStyle": ('PySide2.QtCore.Qt.CursorMoveStyle',),
    "PySide2.QtGui.QTextDocument.setDefaultFont": ('PySide2.QtGui.QFont',),
    "PySide2.QtGui.QTextDocument.setDefaultStyleSheet": ('str',),
    "PySide2.QtGui.QTextDocument.setDefaultTextOption": ('PySide2.QtGui.QTextOption',),
    "PySide2.QtGui.QTextDocument.setDocumentLayout": ('PySide2.QtGui.QAbstractTextDocumentLayout',),
    "PySide2.QtGui.QTextDocument.setDocumentMargin": ('float',),
    "PySide2.QtGui.QTextDocument.setHtml": ('str',),
    "PySide2.QtGui.QTextDocument.setIndentWidth": ('float',),
    "PySide2.QtGui.QTextDocument.setMarkdown": ('str', 'PySide2.QtGui.QTextDocument.MarkdownFeatures'),
    "PySide2.QtGui.QTextDocument.setMaximumBlockCount": ('int',),
    "PySide2.QtGui.QTextDocument.setMetaInformation": ('PySide2.QtGui.QTextDocument.MetaInformation', 'str'),
    "PySide2.QtGui.QTextDocument.setModified": ('bool',),
    "PySide2.QtGui.QTextDocument.setPageSize": ('PySide2.QtCore.QSizeF',),
    "PySide2.QtGui.QTextDocument.setPlainText": ('str',),
    "PySide2.QtGui.QTextDocument.setTextWidth": ('float',),
    "PySide2.QtGui.QTextDocument.setUndoRedoEnabled": ('bool',),
    "PySide2.QtGui.QTextDocument.setUseDesignMetrics": ('bool',),
    "PySide2.QtGui.QTextDocument.size": (),
    "PySide2.QtGui.QTextDocument.textWidth": (),
    "PySide2.QtGui.QTextDocument.toHtml": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtGui.QTextDocument.toMarkdown": ('PySide2.QtGui.QTextDocument.MarkdownFeatures',),
    "PySide2.QtGui.QTextDocument.toPlainText": (),
    "PySide2.QtGui.QTextDocument.toRawText": (),
    "PySide2.QtGui.QTextDocument.undo": [(), ('PySide2.QtGui.QTextCursor',)],
    "PySide2.QtGui.QTextDocument.useDesignMetrics": (),

# class PySide2.QtGui.QTextDocumentFragment:
    "PySide2.QtGui.QTextDocumentFragment.__init__": [(), ('PySide2.QtGui.QTextCursor',), ('PySide2.QtGui.QTextDocument',), ('PySide2.QtGui.QTextDocumentFragment',)],
    "PySide2.QtGui.QTextDocumentFragment.__copy__": (),
    "PySide2.QtGui.QTextDocumentFragment.fromHtml": [('str',), ('str', 'PySide2.QtGui.QTextDocument')],
    "PySide2.QtGui.QTextDocumentFragment.fromPlainText": ('str',),
    "PySide2.QtGui.QTextDocumentFragment.isEmpty": (),
    "PySide2.QtGui.QTextDocumentFragment.toHtml": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtGui.QTextDocumentFragment.toPlainText": (),

# class PySide2.QtGui.QTextDocumentWriter:
    "PySide2.QtGui.QTextDocumentWriter.__init__": [(), ('PySide2.QtCore.QIODevice', 'PySide2.QtCore.QByteArray'), ('str', 'PySide2.QtCore.QByteArray')],
    "PySide2.QtGui.QTextDocumentWriter.codec": (),
    "PySide2.QtGui.QTextDocumentWriter.device": (),
    "PySide2.QtGui.QTextDocumentWriter.fileName": (),
    "PySide2.QtGui.QTextDocumentWriter.format": (),
    "PySide2.QtGui.QTextDocumentWriter.setCodec": ('PySide2.QtCore.QTextCodec',),
    "PySide2.QtGui.QTextDocumentWriter.setDevice": ('PySide2.QtCore.QIODevice',),
    "PySide2.QtGui.QTextDocumentWriter.setFileName": ('str',),
    "PySide2.QtGui.QTextDocumentWriter.setFormat": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtGui.QTextDocumentWriter.supportedDocumentFormats": (),
    "PySide2.QtGui.QTextDocumentWriter.write": [('PySide2.QtGui.QTextDocument',), ('PySide2.QtGui.QTextDocumentFragment',)],

# class PySide2.QtGui.QTextFormat:

# class PySide2.QtGui.QTextFormat.FormatType:

# class PySide2.QtGui.QTextFormat.ObjectTypes:

# class PySide2.QtGui.QTextFormat.PageBreakFlag:

# class PySide2.QtGui.QTextFormat.PageBreakFlags:

# class PySide2.QtGui.QTextFormat.Property:
    "PySide2.QtGui.QTextFormat.__init__": [(), ('PySide2.QtGui.QTextFormat',), ('int',)],
    "PySide2.QtGui.QTextFormat.__copy__": (),
    "PySide2.QtGui.QTextFormat.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QTextFormat.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QTextFormat.background": (),
    "PySide2.QtGui.QTextFormat.boolProperty": ('int',),
    "PySide2.QtGui.QTextFormat.brushProperty": ('int',),
    "PySide2.QtGui.QTextFormat.clearBackground": (),
    "PySide2.QtGui.QTextFormat.clearForeground": (),
    "PySide2.QtGui.QTextFormat.clearProperty": ('int',),
    "PySide2.QtGui.QTextFormat.colorProperty": ('int',),
    "PySide2.QtGui.QTextFormat.doubleProperty": ('int',),
    "PySide2.QtGui.QTextFormat.foreground": (),
    "PySide2.QtGui.QTextFormat.hasProperty": ('int',),
    "PySide2.QtGui.QTextFormat.intProperty": ('int',),
    "PySide2.QtGui.QTextFormat.isBlockFormat": (),
    "PySide2.QtGui.QTextFormat.isCharFormat": (),
    "PySide2.QtGui.QTextFormat.isEmpty": (),
    "PySide2.QtGui.QTextFormat.isFrameFormat": (),
    "PySide2.QtGui.QTextFormat.isImageFormat": (),
    "PySide2.QtGui.QTextFormat.isListFormat": (),
    "PySide2.QtGui.QTextFormat.isTableCellFormat": (),
    "PySide2.QtGui.QTextFormat.isTableFormat": (),
    "PySide2.QtGui.QTextFormat.isValid": (),
    "PySide2.QtGui.QTextFormat.layoutDirection": (),
    "PySide2.QtGui.QTextFormat.lengthProperty": ('int',),
    "PySide2.QtGui.QTextFormat.lengthVectorProperty": ('int',),
    "PySide2.QtGui.QTextFormat.merge": ('PySide2.QtGui.QTextFormat',),
    "PySide2.QtGui.QTextFormat.objectIndex": (),
    "PySide2.QtGui.QTextFormat.objectType": (),
    "PySide2.QtGui.QTextFormat.penProperty": ('int',),
    "PySide2.QtGui.QTextFormat.properties": (),
    "PySide2.QtGui.QTextFormat.property": ('int',),
    "PySide2.QtGui.QTextFormat.propertyCount": (),
    "PySide2.QtGui.QTextFormat.setBackground": ('PySide2.QtGui.QBrush',),
    "PySide2.QtGui.QTextFormat.setForeground": ('PySide2.QtGui.QBrush',),
    "PySide2.QtGui.QTextFormat.setLayoutDirection": ('PySide2.QtCore.Qt.LayoutDirection',),
    "PySide2.QtGui.QTextFormat.setObjectIndex": ('int',),
    "PySide2.QtGui.QTextFormat.setObjectType": ('int',),
    "PySide2.QtGui.QTextFormat.setProperty": [('int', 'typing.Any'), ('int', 'typing.List')],
    "PySide2.QtGui.QTextFormat.stringProperty": ('int',),
    "PySide2.QtGui.QTextFormat.swap": ('PySide2.QtGui.QTextFormat',),
    "PySide2.QtGui.QTextFormat.toBlockFormat": (),
    "PySide2.QtGui.QTextFormat.toCharFormat": (),
    "PySide2.QtGui.QTextFormat.toFrameFormat": (),
    "PySide2.QtGui.QTextFormat.toImageFormat": (),
    "PySide2.QtGui.QTextFormat.toListFormat": (),
    "PySide2.QtGui.QTextFormat.toTableCellFormat": (),
    "PySide2.QtGui.QTextFormat.toTableFormat": (),
    "PySide2.QtGui.QTextFormat.type": (),

# class PySide2.QtGui.QTextFragment:
    "PySide2.QtGui.QTextFragment.__init__": [(), ('PySide2.QtGui.QTextFragment',)],
    "PySide2.QtGui.QTextFragment.__copy__": (),
    "PySide2.QtGui.QTextFragment.charFormat": (),
    "PySide2.QtGui.QTextFragment.charFormatIndex": (),
    "PySide2.QtGui.QTextFragment.contains": ('int',),
    "PySide2.QtGui.QTextFragment.isValid": (),
    "PySide2.QtGui.QTextFragment.length": (),
    "PySide2.QtGui.QTextFragment.position": (),
    "PySide2.QtGui.QTextFragment.text": (),

# class PySide2.QtGui.QTextFrame:

# class PySide2.QtGui.QTextFrame.iterator:
    "PySide2.QtGui.QTextFrame.iterator.__init__": [(), ('PySide2.QtGui.QTextFrame.iterator',)],
    "PySide2.QtGui.QTextFrame.iterator.__copy__": (),
    "PySide2.QtGui.QTextFrame.iterator.__iadd__": ('int',),
    "PySide2.QtGui.QTextFrame.iterator.__isub__": ('int',),
    "PySide2.QtGui.QTextFrame.iterator.__iter__": (),
    "PySide2.QtGui.QTextFrame.iterator.atEnd": (),
    "PySide2.QtGui.QTextFrame.iterator.currentBlock": (),
    "PySide2.QtGui.QTextFrame.iterator.currentFrame": (),
    "PySide2.QtGui.QTextFrame.iterator.parentFrame": (),

    "PySide2.QtGui.QTextFrame.__init__": ('PySide2.QtGui.QTextDocument',),
    "PySide2.QtGui.QTextFrame.__iter__": (),
    "PySide2.QtGui.QTextFrame.begin": (),
    "PySide2.QtGui.QTextFrame.childFrames": (),
    "PySide2.QtGui.QTextFrame.end": (),
    "PySide2.QtGui.QTextFrame.firstCursorPosition": (),
    "PySide2.QtGui.QTextFrame.firstPosition": (),
    "PySide2.QtGui.QTextFrame.frameFormat": (),
    "PySide2.QtGui.QTextFrame.lastCursorPosition": (),
    "PySide2.QtGui.QTextFrame.lastPosition": (),
    "PySide2.QtGui.QTextFrame.parentFrame": (),
    "PySide2.QtGui.QTextFrame.setFrameFormat": ('PySide2.QtGui.QTextFrameFormat',),

# class PySide2.QtGui.QTextFrameFormat:

# class PySide2.QtGui.QTextFrameFormat.BorderStyle:

# class PySide2.QtGui.QTextFrameFormat.Position:
    "PySide2.QtGui.QTextFrameFormat.__init__": [(), ('PySide2.QtGui.QTextFormat',), ('PySide2.QtGui.QTextFrameFormat',)],
    "PySide2.QtGui.QTextFrameFormat.__copy__": (),
    "PySide2.QtGui.QTextFrameFormat.border": (),
    "PySide2.QtGui.QTextFrameFormat.borderBrush": (),
    "PySide2.QtGui.QTextFrameFormat.borderStyle": (),
    "PySide2.QtGui.QTextFrameFormat.bottomMargin": (),
    "PySide2.QtGui.QTextFrameFormat.height": (),
    "PySide2.QtGui.QTextFrameFormat.isValid": (),
    "PySide2.QtGui.QTextFrameFormat.leftMargin": (),
    "PySide2.QtGui.QTextFrameFormat.margin": (),
    "PySide2.QtGui.QTextFrameFormat.padding": (),
    "PySide2.QtGui.QTextFrameFormat.pageBreakPolicy": (),
    "PySide2.QtGui.QTextFrameFormat.position": (),
    "PySide2.QtGui.QTextFrameFormat.rightMargin": (),
    "PySide2.QtGui.QTextFrameFormat.setBorder": ('float',),
    "PySide2.QtGui.QTextFrameFormat.setBorderBrush": ('PySide2.QtGui.QBrush',),
    "PySide2.QtGui.QTextFrameFormat.setBorderStyle": ('PySide2.QtGui.QTextFrameFormat.BorderStyle',),
    "PySide2.QtGui.QTextFrameFormat.setBottomMargin": ('float',),
    "PySide2.QtGui.QTextFrameFormat.setHeight": [('PySide2.QtGui.QTextLength',), ('float',)],
    "PySide2.QtGui.QTextFrameFormat.setLeftMargin": ('float',),
    "PySide2.QtGui.QTextFrameFormat.setMargin": ('float',),
    "PySide2.QtGui.QTextFrameFormat.setPadding": ('float',),
    "PySide2.QtGui.QTextFrameFormat.setPageBreakPolicy": ('PySide2.QtGui.QTextFormat.PageBreakFlags',),
    "PySide2.QtGui.QTextFrameFormat.setPosition": ('PySide2.QtGui.QTextFrameFormat.Position',),
    "PySide2.QtGui.QTextFrameFormat.setRightMargin": ('float',),
    "PySide2.QtGui.QTextFrameFormat.setTopMargin": ('float',),
    "PySide2.QtGui.QTextFrameFormat.setWidth": [('PySide2.QtGui.QTextLength',), ('float',)],
    "PySide2.QtGui.QTextFrameFormat.topMargin": (),
    "PySide2.QtGui.QTextFrameFormat.width": (),

# class PySide2.QtGui.QTextImageFormat:
    "PySide2.QtGui.QTextImageFormat.__init__": [(), ('PySide2.QtGui.QTextFormat',), ('PySide2.QtGui.QTextImageFormat',)],
    "PySide2.QtGui.QTextImageFormat.__copy__": (),
    "PySide2.QtGui.QTextImageFormat.height": (),
    "PySide2.QtGui.QTextImageFormat.isValid": (),
    "PySide2.QtGui.QTextImageFormat.name": (),
    "PySide2.QtGui.QTextImageFormat.quality": (),
    "PySide2.QtGui.QTextImageFormat.setHeight": ('float',),
    "PySide2.QtGui.QTextImageFormat.setName": ('str',),
    "PySide2.QtGui.QTextImageFormat.setQuality": ('int',),
    "PySide2.QtGui.QTextImageFormat.setWidth": ('float',),
    "PySide2.QtGui.QTextImageFormat.width": (),

# class PySide2.QtGui.QTextInlineObject:
    "PySide2.QtGui.QTextInlineObject.__init__": (),
    "PySide2.QtGui.QTextInlineObject.__copy__": (),
    "PySide2.QtGui.QTextInlineObject.ascent": (),
    "PySide2.QtGui.QTextInlineObject.descent": (),
    "PySide2.QtGui.QTextInlineObject.format": (),
    "PySide2.QtGui.QTextInlineObject.formatIndex": (),
    "PySide2.QtGui.QTextInlineObject.height": (),
    "PySide2.QtGui.QTextInlineObject.isValid": (),
    "PySide2.QtGui.QTextInlineObject.rect": (),
    "PySide2.QtGui.QTextInlineObject.setAscent": ('float',),
    "PySide2.QtGui.QTextInlineObject.setDescent": ('float',),
    "PySide2.QtGui.QTextInlineObject.setWidth": ('float',),
    "PySide2.QtGui.QTextInlineObject.textDirection": (),
    "PySide2.QtGui.QTextInlineObject.textPosition": (),
    "PySide2.QtGui.QTextInlineObject.width": (),

# class PySide2.QtGui.QTextItem:

# class PySide2.QtGui.QTextItem.RenderFlag:

# class PySide2.QtGui.QTextItem.RenderFlags:
    "PySide2.QtGui.QTextItem.__init__": (),
    "PySide2.QtGui.QTextItem.ascent": (),
    "PySide2.QtGui.QTextItem.descent": (),
    "PySide2.QtGui.QTextItem.font": (),
    "PySide2.QtGui.QTextItem.renderFlags": (),
    "PySide2.QtGui.QTextItem.text": (),
    "PySide2.QtGui.QTextItem.width": (),

# class PySide2.QtGui.QTextLayout:

# class PySide2.QtGui.QTextLayout.CursorMode:

# class PySide2.QtGui.QTextLayout.FormatRange:
    "PySide2.QtGui.QTextLayout.FormatRange.__init__": [(), ('PySide2.QtGui.QTextLayout.FormatRange',)],
    "PySide2.QtGui.QTextLayout.FormatRange.__copy__": (),

    "PySide2.QtGui.QTextLayout.__init__": [(), ('PySide2.QtGui.QTextBlock',), ('str',), ('str', 'PySide2.QtGui.QFont', 'PySide2.QtGui.QPaintDevice')],
    "PySide2.QtGui.QTextLayout.additionalFormats": (),
    "PySide2.QtGui.QTextLayout.beginLayout": (),
    "PySide2.QtGui.QTextLayout.boundingRect": (),
    "PySide2.QtGui.QTextLayout.cacheEnabled": (),
    "PySide2.QtGui.QTextLayout.clearAdditionalFormats": (),
    "PySide2.QtGui.QTextLayout.clearFormats": (),
    "PySide2.QtGui.QTextLayout.clearLayout": (),
    "PySide2.QtGui.QTextLayout.createLine": (),
    "PySide2.QtGui.QTextLayout.cursorMoveStyle": (),
    "PySide2.QtGui.QTextLayout.draw": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QPointF', 'typing.List', 'PySide2.QtCore.QRectF'),
    "PySide2.QtGui.QTextLayout.drawCursor": [('PySide2.QtGui.QPainter', 'PySide2.QtCore.QPointF', 'int'), ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QPointF', 'int', 'int')],
    "PySide2.QtGui.QTextLayout.endLayout": (),
    "PySide2.QtGui.QTextLayout.font": (),
    "PySide2.QtGui.QTextLayout.formats": (),
    "PySide2.QtGui.QTextLayout.isValidCursorPosition": ('int',),
    "PySide2.QtGui.QTextLayout.leftCursorPosition": ('int',),
    "PySide2.QtGui.QTextLayout.lineAt": ('int',),
    "PySide2.QtGui.QTextLayout.lineCount": (),
    "PySide2.QtGui.QTextLayout.lineForTextPosition": ('int',),
    "PySide2.QtGui.QTextLayout.maximumWidth": (),
    "PySide2.QtGui.QTextLayout.minimumWidth": (),
    "PySide2.QtGui.QTextLayout.nextCursorPosition": ('int', 'PySide2.QtGui.QTextLayout.CursorMode'),
    "PySide2.QtGui.QTextLayout.position": (),
    "PySide2.QtGui.QTextLayout.preeditAreaPosition": (),
    "PySide2.QtGui.QTextLayout.preeditAreaText": (),
    "PySide2.QtGui.QTextLayout.previousCursorPosition": ('int', 'PySide2.QtGui.QTextLayout.CursorMode'),
    "PySide2.QtGui.QTextLayout.rightCursorPosition": ('int',),
    "PySide2.QtGui.QTextLayout.setAdditionalFormats": ('typing.Sequence',),
    "PySide2.QtGui.QTextLayout.setCacheEnabled": ('bool',),
    "PySide2.QtGui.QTextLayout.setCursorMoveStyle": ('PySide2.QtCore.Qt.CursorMoveStyle',),
    "PySide2.QtGui.QTextLayout.setFlags": ('int',),
    "PySide2.QtGui.QTextLayout.setFont": ('PySide2.QtGui.QFont',),
    "PySide2.QtGui.QTextLayout.setFormats": ('typing.List',),
    "PySide2.QtGui.QTextLayout.setPosition": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QTextLayout.setPreeditArea": ('int', 'str'),
    "PySide2.QtGui.QTextLayout.setRawFont": ('PySide2.QtGui.QRawFont',),
    "PySide2.QtGui.QTextLayout.setText": ('str',),
    "PySide2.QtGui.QTextLayout.setTextOption": ('PySide2.QtGui.QTextOption',),
    "PySide2.QtGui.QTextLayout.text": (),
    "PySide2.QtGui.QTextLayout.textOption": (),

# class PySide2.QtGui.QTextLength:

# class PySide2.QtGui.QTextLength.Type:
    "PySide2.QtGui.QTextLength.__init__": [(), ('PySide2.QtGui.QTextLength',), ('PySide2.QtGui.QTextLength.Type', 'float')],
    "PySide2.QtGui.QTextLength.__copy__": (),
    "PySide2.QtGui.QTextLength.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QTextLength.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QTextLength.rawValue": (),
    "PySide2.QtGui.QTextLength.type": (),
    "PySide2.QtGui.QTextLength.value": ('float',),

# class PySide2.QtGui.QTextLine:

# class PySide2.QtGui.QTextLine.CursorPosition:

# class PySide2.QtGui.QTextLine.Edge:
    "PySide2.QtGui.QTextLine.__init__": (),
    "PySide2.QtGui.QTextLine.__copy__": (),
    "PySide2.QtGui.QTextLine.ascent": (),
    "PySide2.QtGui.QTextLine.cursorToX": ('int', 'PySide2.QtGui.QTextLine.Edge'),
    "PySide2.QtGui.QTextLine.descent": (),
    "PySide2.QtGui.QTextLine.draw": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QPointF', 'PySide2.QtGui.QTextLayout.FormatRange'),
    "PySide2.QtGui.QTextLine.height": (),
    "PySide2.QtGui.QTextLine.horizontalAdvance": (),
    "PySide2.QtGui.QTextLine.isValid": (),
    "PySide2.QtGui.QTextLine.leading": (),
    "PySide2.QtGui.QTextLine.leadingIncluded": (),
    "PySide2.QtGui.QTextLine.lineNumber": (),
    "PySide2.QtGui.QTextLine.naturalTextRect": (),
    "PySide2.QtGui.QTextLine.naturalTextWidth": (),
    "PySide2.QtGui.QTextLine.position": (),
    "PySide2.QtGui.QTextLine.rect": (),
    "PySide2.QtGui.QTextLine.setLeadingIncluded": ('bool',),
    "PySide2.QtGui.QTextLine.setLineWidth": ('float',),
    "PySide2.QtGui.QTextLine.setNumColumns": [('int',), ('int', 'float')],
    "PySide2.QtGui.QTextLine.setPosition": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QTextLine.textLength": (),
    "PySide2.QtGui.QTextLine.textStart": (),
    "PySide2.QtGui.QTextLine.width": (),
    "PySide2.QtGui.QTextLine.x": (),
    "PySide2.QtGui.QTextLine.xToCursor": ('float', 'PySide2.QtGui.QTextLine.CursorPosition'),
    "PySide2.QtGui.QTextLine.y": (),

# class PySide2.QtGui.QTextList:
    "PySide2.QtGui.QTextList.__init__": ('PySide2.QtGui.QTextDocument',),
    "PySide2.QtGui.QTextList.add": ('PySide2.QtGui.QTextBlock',),
    "PySide2.QtGui.QTextList.count": (),
    "PySide2.QtGui.QTextList.format": (),
    "PySide2.QtGui.QTextList.item": ('int',),
    "PySide2.QtGui.QTextList.itemNumber": ('PySide2.QtGui.QTextBlock',),
    "PySide2.QtGui.QTextList.itemText": ('PySide2.QtGui.QTextBlock',),
    "PySide2.QtGui.QTextList.remove": ('PySide2.QtGui.QTextBlock',),
    "PySide2.QtGui.QTextList.removeItem": ('int',),
    "PySide2.QtGui.QTextList.setFormat": [('PySide2.QtGui.QTextFormat',), ('PySide2.QtGui.QTextListFormat',)],

# class PySide2.QtGui.QTextListFormat:

# class PySide2.QtGui.QTextListFormat.Style:
    "PySide2.QtGui.QTextListFormat.__init__": [(), ('PySide2.QtGui.QTextFormat',), ('PySide2.QtGui.QTextListFormat',)],
    "PySide2.QtGui.QTextListFormat.__copy__": (),
    "PySide2.QtGui.QTextListFormat.indent": (),
    "PySide2.QtGui.QTextListFormat.isValid": (),
    "PySide2.QtGui.QTextListFormat.numberPrefix": (),
    "PySide2.QtGui.QTextListFormat.numberSuffix": (),
    "PySide2.QtGui.QTextListFormat.setIndent": ('int',),
    "PySide2.QtGui.QTextListFormat.setNumberPrefix": ('str',),
    "PySide2.QtGui.QTextListFormat.setNumberSuffix": ('str',),
    "PySide2.QtGui.QTextListFormat.setStyle": ('PySide2.QtGui.QTextListFormat.Style',),
    "PySide2.QtGui.QTextListFormat.style": (),

# class PySide2.QtGui.QTextObject:
    "PySide2.QtGui.QTextObject.__init__": ('PySide2.QtGui.QTextDocument',),
    "PySide2.QtGui.QTextObject.document": (),
    "PySide2.QtGui.QTextObject.format": (),
    "PySide2.QtGui.QTextObject.formatIndex": (),
    "PySide2.QtGui.QTextObject.objectIndex": (),
    "PySide2.QtGui.QTextObject.setFormat": ('PySide2.QtGui.QTextFormat',),

# class PySide2.QtGui.QTextObjectInterface:
    "PySide2.QtGui.QTextObjectInterface.__init__": (),
    "PySide2.QtGui.QTextObjectInterface.drawObject": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF', 'PySide2.QtGui.QTextDocument', 'int', 'PySide2.QtGui.QTextFormat'),
    "PySide2.QtGui.QTextObjectInterface.intrinsicSize": ('PySide2.QtGui.QTextDocument', 'int', 'PySide2.QtGui.QTextFormat'),

# class PySide2.QtGui.QTextOption:

# class PySide2.QtGui.QTextOption.Flag:

# class PySide2.QtGui.QTextOption.Flags:

# class PySide2.QtGui.QTextOption.Tab:
    "PySide2.QtGui.QTextOption.Tab.__init__": [(), ('PySide2.QtGui.QTextOption.Tab',), ('float', 'PySide2.QtGui.QTextOption.TabType', 'typing.Char')],
    "PySide2.QtGui.QTextOption.Tab.__copy__": (),

# class PySide2.QtGui.QTextOption.TabType:

# class PySide2.QtGui.QTextOption.WrapMode:

    "PySide2.QtGui.QTextOption.__init__": [(), ('PySide2.QtCore.Qt.Alignment',), ('PySide2.QtGui.QTextOption',)],
    "PySide2.QtGui.QTextOption.__copy__": (),
    "PySide2.QtGui.QTextOption.alignment": (),
    "PySide2.QtGui.QTextOption.flags": (),
    "PySide2.QtGui.QTextOption.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtGui.QTextOption.setFlags": ('PySide2.QtGui.QTextOption.Flags',),
    "PySide2.QtGui.QTextOption.setTabArray": ('typing.Sequence',),
    "PySide2.QtGui.QTextOption.setTabStop": ('float',),
    "PySide2.QtGui.QTextOption.setTabStopDistance": ('float',),
    "PySide2.QtGui.QTextOption.setTabs": ('typing.Sequence',),
    "PySide2.QtGui.QTextOption.setTextDirection": ('PySide2.QtCore.Qt.LayoutDirection',),
    "PySide2.QtGui.QTextOption.setUseDesignMetrics": ('bool',),
    "PySide2.QtGui.QTextOption.setWrapMode": ('PySide2.QtGui.QTextOption.WrapMode',),
    "PySide2.QtGui.QTextOption.tabArray": (),
    "PySide2.QtGui.QTextOption.tabStop": (),
    "PySide2.QtGui.QTextOption.tabStopDistance": (),
    "PySide2.QtGui.QTextOption.tabs": (),
    "PySide2.QtGui.QTextOption.textDirection": (),
    "PySide2.QtGui.QTextOption.useDesignMetrics": (),
    "PySide2.QtGui.QTextOption.wrapMode": (),

# class PySide2.QtGui.QTextTable:
    "PySide2.QtGui.QTextTable.__init__": ('PySide2.QtGui.QTextDocument',),
    "PySide2.QtGui.QTextTable.appendColumns": ('int',),
    "PySide2.QtGui.QTextTable.appendRows": ('int',),
    "PySide2.QtGui.QTextTable.cellAt": [('PySide2.QtGui.QTextCursor',), ('int',), ('int', 'int')],
    "PySide2.QtGui.QTextTable.columns": (),
    "PySide2.QtGui.QTextTable.format": (),
    "PySide2.QtGui.QTextTable.insertColumns": ('int', 'int'),
    "PySide2.QtGui.QTextTable.insertRows": ('int', 'int'),
    "PySide2.QtGui.QTextTable.mergeCells": [('PySide2.QtGui.QTextCursor',), ('int', 'int', 'int', 'int')],
    "PySide2.QtGui.QTextTable.removeColumns": ('int', 'int'),
    "PySide2.QtGui.QTextTable.removeRows": ('int', 'int'),
    "PySide2.QtGui.QTextTable.resize": ('int', 'int'),
    "PySide2.QtGui.QTextTable.rowEnd": ('PySide2.QtGui.QTextCursor',),
    "PySide2.QtGui.QTextTable.rowStart": ('PySide2.QtGui.QTextCursor',),
    "PySide2.QtGui.QTextTable.rows": (),
    "PySide2.QtGui.QTextTable.setFormat": [('PySide2.QtGui.QTextFormat',), ('PySide2.QtGui.QTextTableFormat',)],
    "PySide2.QtGui.QTextTable.splitCell": ('int', 'int', 'int', 'int'),

# class PySide2.QtGui.QTextTableCell:
    "PySide2.QtGui.QTextTableCell.__init__": [(), ('PySide2.QtGui.QTextTableCell',)],
    "PySide2.QtGui.QTextTableCell.__copy__": (),
    "PySide2.QtGui.QTextTableCell.begin": (),
    "PySide2.QtGui.QTextTableCell.column": (),
    "PySide2.QtGui.QTextTableCell.columnSpan": (),
    "PySide2.QtGui.QTextTableCell.end": (),
    "PySide2.QtGui.QTextTableCell.firstCursorPosition": (),
    "PySide2.QtGui.QTextTableCell.firstPosition": (),
    "PySide2.QtGui.QTextTableCell.format": (),
    "PySide2.QtGui.QTextTableCell.isValid": (),
    "PySide2.QtGui.QTextTableCell.lastCursorPosition": (),
    "PySide2.QtGui.QTextTableCell.lastPosition": (),
    "PySide2.QtGui.QTextTableCell.row": (),
    "PySide2.QtGui.QTextTableCell.rowSpan": (),
    "PySide2.QtGui.QTextTableCell.setFormat": ('PySide2.QtGui.QTextCharFormat',),
    "PySide2.QtGui.QTextTableCell.tableCellFormatIndex": (),

# class PySide2.QtGui.QTextTableCellFormat:
    "PySide2.QtGui.QTextTableCellFormat.__init__": [(), ('PySide2.QtGui.QTextFormat',), ('PySide2.QtGui.QTextTableCellFormat',)],
    "PySide2.QtGui.QTextTableCellFormat.__copy__": (),
    "PySide2.QtGui.QTextTableCellFormat.bottomBorder": (),
    "PySide2.QtGui.QTextTableCellFormat.bottomBorderBrush": (),
    "PySide2.QtGui.QTextTableCellFormat.bottomBorderStyle": (),
    "PySide2.QtGui.QTextTableCellFormat.bottomPadding": (),
    "PySide2.QtGui.QTextTableCellFormat.isValid": (),
    "PySide2.QtGui.QTextTableCellFormat.leftBorder": (),
    "PySide2.QtGui.QTextTableCellFormat.leftBorderBrush": (),
    "PySide2.QtGui.QTextTableCellFormat.leftBorderStyle": (),
    "PySide2.QtGui.QTextTableCellFormat.leftPadding": (),
    "PySide2.QtGui.QTextTableCellFormat.rightBorder": (),
    "PySide2.QtGui.QTextTableCellFormat.rightBorderBrush": (),
    "PySide2.QtGui.QTextTableCellFormat.rightBorderStyle": (),
    "PySide2.QtGui.QTextTableCellFormat.rightPadding": (),
    "PySide2.QtGui.QTextTableCellFormat.setBorder": ('float',),
    "PySide2.QtGui.QTextTableCellFormat.setBorderBrush": ('PySide2.QtGui.QBrush',),
    "PySide2.QtGui.QTextTableCellFormat.setBorderStyle": ('PySide2.QtGui.QTextFrameFormat.BorderStyle',),
    "PySide2.QtGui.QTextTableCellFormat.setBottomBorder": ('float',),
    "PySide2.QtGui.QTextTableCellFormat.setBottomBorderBrush": ('PySide2.QtGui.QBrush',),
    "PySide2.QtGui.QTextTableCellFormat.setBottomBorderStyle": ('PySide2.QtGui.QTextFrameFormat.BorderStyle',),
    "PySide2.QtGui.QTextTableCellFormat.setBottomPadding": ('float',),
    "PySide2.QtGui.QTextTableCellFormat.setLeftBorder": ('float',),
    "PySide2.QtGui.QTextTableCellFormat.setLeftBorderBrush": ('PySide2.QtGui.QBrush',),
    "PySide2.QtGui.QTextTableCellFormat.setLeftBorderStyle": ('PySide2.QtGui.QTextFrameFormat.BorderStyle',),
    "PySide2.QtGui.QTextTableCellFormat.setLeftPadding": ('float',),
    "PySide2.QtGui.QTextTableCellFormat.setPadding": ('float',),
    "PySide2.QtGui.QTextTableCellFormat.setRightBorder": ('float',),
    "PySide2.QtGui.QTextTableCellFormat.setRightBorderBrush": ('PySide2.QtGui.QBrush',),
    "PySide2.QtGui.QTextTableCellFormat.setRightBorderStyle": ('PySide2.QtGui.QTextFrameFormat.BorderStyle',),
    "PySide2.QtGui.QTextTableCellFormat.setRightPadding": ('float',),
    "PySide2.QtGui.QTextTableCellFormat.setTopBorder": ('float',),
    "PySide2.QtGui.QTextTableCellFormat.setTopBorderBrush": ('PySide2.QtGui.QBrush',),
    "PySide2.QtGui.QTextTableCellFormat.setTopBorderStyle": ('PySide2.QtGui.QTextFrameFormat.BorderStyle',),
    "PySide2.QtGui.QTextTableCellFormat.setTopPadding": ('float',),
    "PySide2.QtGui.QTextTableCellFormat.topBorder": (),
    "PySide2.QtGui.QTextTableCellFormat.topBorderBrush": (),
    "PySide2.QtGui.QTextTableCellFormat.topBorderStyle": (),
    "PySide2.QtGui.QTextTableCellFormat.topPadding": (),

# class PySide2.QtGui.QTextTableFormat:
    "PySide2.QtGui.QTextTableFormat.__init__": [(), ('PySide2.QtGui.QTextFormat',), ('PySide2.QtGui.QTextTableFormat',)],
    "PySide2.QtGui.QTextTableFormat.__copy__": (),
    "PySide2.QtGui.QTextTableFormat.alignment": (),
    "PySide2.QtGui.QTextTableFormat.borderCollapse": (),
    "PySide2.QtGui.QTextTableFormat.cellPadding": (),
    "PySide2.QtGui.QTextTableFormat.cellSpacing": (),
    "PySide2.QtGui.QTextTableFormat.clearColumnWidthConstraints": (),
    "PySide2.QtGui.QTextTableFormat.columnWidthConstraints": (),
    "PySide2.QtGui.QTextTableFormat.columns": (),
    "PySide2.QtGui.QTextTableFormat.headerRowCount": (),
    "PySide2.QtGui.QTextTableFormat.isValid": (),
    "PySide2.QtGui.QTextTableFormat.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtGui.QTextTableFormat.setBorderCollapse": ('bool',),
    "PySide2.QtGui.QTextTableFormat.setCellPadding": ('float',),
    "PySide2.QtGui.QTextTableFormat.setCellSpacing": ('float',),
    "PySide2.QtGui.QTextTableFormat.setColumnWidthConstraints": ('typing.List',),
    "PySide2.QtGui.QTextTableFormat.setColumns": ('int',),
    "PySide2.QtGui.QTextTableFormat.setHeaderRowCount": ('int',),

# class PySide2.QtGui.QToolBarChangeEvent:
    "PySide2.QtGui.QToolBarChangeEvent.__init__": ('bool',),
    "PySide2.QtGui.QToolBarChangeEvent.toggle": (),

# class PySide2.QtGui.QTouchDevice:

# class PySide2.QtGui.QTouchDevice.Capabilities:

# class PySide2.QtGui.QTouchDevice.CapabilityFlag:

# class PySide2.QtGui.QTouchDevice.DeviceType:
    "PySide2.QtGui.QTouchDevice.__init__": (),
    "PySide2.QtGui.QTouchDevice.capabilities": (),
    "PySide2.QtGui.QTouchDevice.devices": (),
    "PySide2.QtGui.QTouchDevice.maximumTouchPoints": (),
    "PySide2.QtGui.QTouchDevice.name": (),
    "PySide2.QtGui.QTouchDevice.setCapabilities": ('PySide2.QtGui.QTouchDevice.Capabilities',),
    "PySide2.QtGui.QTouchDevice.setMaximumTouchPoints": ('int',),
    "PySide2.QtGui.QTouchDevice.setName": ('str',),
    "PySide2.QtGui.QTouchDevice.setType": ('PySide2.QtGui.QTouchDevice.DeviceType',),
    "PySide2.QtGui.QTouchDevice.type": (),

# class PySide2.QtGui.QTouchEvent:

# class PySide2.QtGui.QTouchEvent.TouchPoint:

# class PySide2.QtGui.QTouchEvent.TouchPoint.InfoFlag:

# class PySide2.QtGui.QTouchEvent.TouchPoint.InfoFlags:
    "PySide2.QtGui.QTouchEvent.TouchPoint.__init__": [('PySide2.QtGui.QTouchEvent.TouchPoint',), ('int',)],
    "PySide2.QtGui.QTouchEvent.TouchPoint.__copy__": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.ellipseDiameters": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.flags": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.id": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.lastNormalizedPos": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.lastPos": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.lastScenePos": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.lastScreenPos": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.normalizedPos": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.pos": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.pressure": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.rawScreenPositions": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.rect": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.rotation": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.scenePos": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.sceneRect": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.screenPos": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.screenRect": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setEllipseDiameters": ('PySide2.QtCore.QSizeF',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setFlags": ('PySide2.QtGui.QTouchEvent.TouchPoint.InfoFlags',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setId": ('int',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setLastNormalizedPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setLastPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setLastScenePos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setLastScreenPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setNormalizedPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setPressure": ('float',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setRawScreenPositions": ('typing.List',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setRect": ('PySide2.QtCore.QRectF',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setRotation": ('float',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setScenePos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setSceneRect": ('PySide2.QtCore.QRectF',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setScreenPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setScreenRect": ('PySide2.QtCore.QRectF',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setStartNormalizedPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setStartPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setStartScenePos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setStartScreenPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setState": ('PySide2.QtCore.Qt.TouchPointStates',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setUniqueId": ('int',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.setVelocity": ('PySide2.QtGui.QVector2D',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.startNormalizedPos": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.startPos": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.startScenePos": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.startScreenPos": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.state": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.swap": ('PySide2.QtGui.QTouchEvent.TouchPoint',),
    "PySide2.QtGui.QTouchEvent.TouchPoint.uniqueId": (),
    "PySide2.QtGui.QTouchEvent.TouchPoint.velocity": (),

    "PySide2.QtGui.QTouchEvent.__init__": ('PySide2.QtCore.QEvent.Type', 'PySide2.QtGui.QTouchDevice', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.Qt.TouchPointStates', 'typing.Sequence'),
    "PySide2.QtGui.QTouchEvent.device": (),
    "PySide2.QtGui.QTouchEvent.setDevice": ('PySide2.QtGui.QTouchDevice',),
    "PySide2.QtGui.QTouchEvent.setTarget": ('PySide2.QtCore.QObject',),
    "PySide2.QtGui.QTouchEvent.setTouchPointStates": ('PySide2.QtCore.Qt.TouchPointStates',),
    "PySide2.QtGui.QTouchEvent.setTouchPoints": ('typing.Sequence',),
    "PySide2.QtGui.QTouchEvent.setWindow": ('PySide2.QtGui.QWindow',),
    "PySide2.QtGui.QTouchEvent.target": (),
    "PySide2.QtGui.QTouchEvent.touchPointStates": (),
    "PySide2.QtGui.QTouchEvent.touchPoints": (),
    "PySide2.QtGui.QTouchEvent.window": (),

# class PySide2.QtGui.QTransform:

# class PySide2.QtGui.QTransform.TransformationType:
    "PySide2.QtGui.QTransform.__init__": [(), ('PySide2.QtGui.QMatrix',), ('PySide2.QtGui.QTransform',), ('float', 'float', 'float', 'float', 'float', 'float'), ('float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float')],
    "PySide2.QtGui.QTransform.__add__": ('float',),
    "PySide2.QtGui.QTransform.__copy__": (),
    "PySide2.QtGui.QTransform.__iadd__": ('float',),
    "PySide2.QtGui.QTransform.__imul__": [('PySide2.QtGui.QTransform',), ('float',)],
    "PySide2.QtGui.QTransform.__isub__": ('float',),
    "PySide2.QtGui.QTransform.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QTransform.__mul__": [('PySide2.QtCore.QLine',), ('PySide2.QtCore.QLineF',), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QTransform',), ('float',)],
    "PySide2.QtGui.QTransform.__reduce__": (),
    "PySide2.QtGui.QTransform.__repr__": (),
    "PySide2.QtGui.QTransform.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QTransform.__sub__": ('float',),
    "PySide2.QtGui.QTransform.adjoint": (),
    "PySide2.QtGui.QTransform.det": (),
    "PySide2.QtGui.QTransform.determinant": (),
    "PySide2.QtGui.QTransform.dx": (),
    "PySide2.QtGui.QTransform.dy": (),
    "PySide2.QtGui.QTransform.fromScale": ('float', 'float'),
    "PySide2.QtGui.QTransform.fromTranslate": ('float', 'float'),
    "PySide2.QtGui.QTransform.inverted": (),
    "PySide2.QtGui.QTransform.isAffine": (),
    "PySide2.QtGui.QTransform.isIdentity": (),
    "PySide2.QtGui.QTransform.isInvertible": (),
    "PySide2.QtGui.QTransform.isRotating": (),
    "PySide2.QtGui.QTransform.isScaling": (),
    "PySide2.QtGui.QTransform.isTranslating": (),
    "PySide2.QtGui.QTransform.m11": (),
    "PySide2.QtGui.QTransform.m12": (),
    "PySide2.QtGui.QTransform.m13": (),
    "PySide2.QtGui.QTransform.m21": (),
    "PySide2.QtGui.QTransform.m22": (),
    "PySide2.QtGui.QTransform.m23": (),
    "PySide2.QtGui.QTransform.m31": (),
    "PySide2.QtGui.QTransform.m32": (),
    "PySide2.QtGui.QTransform.m33": (),
    "PySide2.QtGui.QTransform.map": [('PySide2.QtCore.QLine',), ('PySide2.QtCore.QLineF',), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QPainterPath',), ('PySide2.QtGui.QPolygon',), ('PySide2.QtGui.QPolygonF',), ('PySide2.QtGui.QRegion',), ('float', 'float')],
    "PySide2.QtGui.QTransform.mapRect": [('PySide2.QtCore.QRect',), ('PySide2.QtCore.QRectF',)],
    "PySide2.QtGui.QTransform.mapToPolygon": ('PySide2.QtCore.QRect',),
    "PySide2.QtGui.QTransform.quadToQuad": [('PySide2.QtGui.QPolygonF', 'PySide2.QtGui.QPolygonF'), ('PySide2.QtGui.QPolygonF', 'PySide2.QtGui.QPolygonF', 'PySide2.QtGui.QTransform')],
    "PySide2.QtGui.QTransform.quadToSquare": [('PySide2.QtGui.QPolygonF',), ('PySide2.QtGui.QPolygonF', 'PySide2.QtGui.QTransform')],
    "PySide2.QtGui.QTransform.reset": (),
    "PySide2.QtGui.QTransform.rotate": ('float', 'PySide2.QtCore.Qt.Axis'),
    "PySide2.QtGui.QTransform.rotateRadians": ('float', 'PySide2.QtCore.Qt.Axis'),
    "PySide2.QtGui.QTransform.scale": ('float', 'float'),
    "PySide2.QtGui.QTransform.setMatrix": ('float', 'float', 'float', 'float', 'float', 'float', 'float', 'float', 'float'),
    "PySide2.QtGui.QTransform.shear": ('float', 'float'),
    "PySide2.QtGui.QTransform.squareToQuad": [('PySide2.QtGui.QPolygonF',), ('PySide2.QtGui.QPolygonF', 'PySide2.QtGui.QTransform')],
    "PySide2.QtGui.QTransform.toAffine": (),
    "PySide2.QtGui.QTransform.translate": ('float', 'float'),
    "PySide2.QtGui.QTransform.transposed": (),
    "PySide2.QtGui.QTransform.type": (),

# class PySide2.QtGui.QValidator:

# class PySide2.QtGui.QValidator.State:
    "PySide2.QtGui.QValidator.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtGui.QValidator.fixup": ('str',),
    "PySide2.QtGui.QValidator.locale": (),
    "PySide2.QtGui.QValidator.setLocale": ('PySide2.QtCore.QLocale',),
    "PySide2.QtGui.QValidator.validate": ('str', 'int'),

# class PySide2.QtGui.QVector2D:
    "PySide2.QtGui.QVector2D.__init__": [(), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QVector3D',), ('PySide2.QtGui.QVector4D',), ('float', 'float')],
    "PySide2.QtGui.QVector2D.__add__": ('PySide2.QtGui.QVector2D',),
    "PySide2.QtGui.QVector2D.__copy__": (),
    "PySide2.QtGui.QVector2D.__iadd__": ('PySide2.QtGui.QVector2D',),
    "PySide2.QtGui.QVector2D.__imul__": [('PySide2.QtGui.QVector2D',), ('float',)],
    "PySide2.QtGui.QVector2D.__isub__": ('PySide2.QtGui.QVector2D',),
    "PySide2.QtGui.QVector2D.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QVector2D.__mul__": [('PySide2.QtGui.QVector2D',), ('float',)],
    "PySide2.QtGui.QVector2D.__neg__": (),
    "PySide2.QtGui.QVector2D.__reduce__": (),
    "PySide2.QtGui.QVector2D.__repr__": (),
    "PySide2.QtGui.QVector2D.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QVector2D.__sub__": ('PySide2.QtGui.QVector2D',),
    "PySide2.QtGui.QVector2D.distanceToLine": ('PySide2.QtGui.QVector2D', 'PySide2.QtGui.QVector2D'),
    "PySide2.QtGui.QVector2D.distanceToPoint": ('PySide2.QtGui.QVector2D',),
    "PySide2.QtGui.QVector2D.dotProduct": ('PySide2.QtGui.QVector2D', 'PySide2.QtGui.QVector2D'),
    "PySide2.QtGui.QVector2D.isNull": (),
    "PySide2.QtGui.QVector2D.length": (),
    "PySide2.QtGui.QVector2D.lengthSquared": (),
    "PySide2.QtGui.QVector2D.normalize": (),
    "PySide2.QtGui.QVector2D.normalized": (),
    "PySide2.QtGui.QVector2D.setX": ('float',),
    "PySide2.QtGui.QVector2D.setY": ('float',),
    "PySide2.QtGui.QVector2D.toPoint": (),
    "PySide2.QtGui.QVector2D.toPointF": (),
    "PySide2.QtGui.QVector2D.toTuple": (),
    "PySide2.QtGui.QVector2D.toVector3D": (),
    "PySide2.QtGui.QVector2D.toVector4D": (),
    "PySide2.QtGui.QVector2D.x": (),
    "PySide2.QtGui.QVector2D.y": (),

# class PySide2.QtGui.QVector3D:
    "PySide2.QtGui.QVector3D.__init__": [(), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QVector2D',), ('PySide2.QtGui.QVector2D', 'float'), ('PySide2.QtGui.QVector4D',), ('float', 'float', 'float')],
    "PySide2.QtGui.QVector3D.__add__": ('PySide2.QtGui.QVector3D',),
    "PySide2.QtGui.QVector3D.__copy__": (),
    "PySide2.QtGui.QVector3D.__iadd__": ('PySide2.QtGui.QVector3D',),
    "PySide2.QtGui.QVector3D.__imul__": [('PySide2.QtGui.QVector3D',), ('float',)],
    "PySide2.QtGui.QVector3D.__isub__": ('PySide2.QtGui.QVector3D',),
    "PySide2.QtGui.QVector3D.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QVector3D.__mul__": [('PySide2.QtGui.QMatrix4x4',), ('PySide2.QtGui.QQuaternion',), ('PySide2.QtGui.QVector3D',), ('float',)],
    "PySide2.QtGui.QVector3D.__neg__": (),
    "PySide2.QtGui.QVector3D.__reduce__": (),
    "PySide2.QtGui.QVector3D.__repr__": (),
    "PySide2.QtGui.QVector3D.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QVector3D.__sub__": ('PySide2.QtGui.QVector3D',),
    "PySide2.QtGui.QVector3D.crossProduct": ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'),
    "PySide2.QtGui.QVector3D.distanceToLine": ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'),
    "PySide2.QtGui.QVector3D.distanceToPlane": [('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'), ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D')],
    "PySide2.QtGui.QVector3D.distanceToPoint": ('PySide2.QtGui.QVector3D',),
    "PySide2.QtGui.QVector3D.dotProduct": ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'),
    "PySide2.QtGui.QVector3D.isNull": (),
    "PySide2.QtGui.QVector3D.length": (),
    "PySide2.QtGui.QVector3D.lengthSquared": (),
    "PySide2.QtGui.QVector3D.normal": [('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D'), ('PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D', 'PySide2.QtGui.QVector3D')],
    "PySide2.QtGui.QVector3D.normalize": (),
    "PySide2.QtGui.QVector3D.normalized": (),
    "PySide2.QtGui.QVector3D.project": ('PySide2.QtGui.QMatrix4x4', 'PySide2.QtGui.QMatrix4x4', 'PySide2.QtCore.QRect'),
    "PySide2.QtGui.QVector3D.setX": ('float',),
    "PySide2.QtGui.QVector3D.setY": ('float',),
    "PySide2.QtGui.QVector3D.setZ": ('float',),
    "PySide2.QtGui.QVector3D.toPoint": (),
    "PySide2.QtGui.QVector3D.toPointF": (),
    "PySide2.QtGui.QVector3D.toTuple": (),
    "PySide2.QtGui.QVector3D.toVector2D": (),
    "PySide2.QtGui.QVector3D.toVector4D": (),
    "PySide2.QtGui.QVector3D.unproject": ('PySide2.QtGui.QMatrix4x4', 'PySide2.QtGui.QMatrix4x4', 'PySide2.QtCore.QRect'),
    "PySide2.QtGui.QVector3D.x": (),
    "PySide2.QtGui.QVector3D.y": (),
    "PySide2.QtGui.QVector3D.z": (),

# class PySide2.QtGui.QVector4D:
    "PySide2.QtGui.QVector4D.__init__": [(), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QPointF',), ('PySide2.QtGui.QVector2D',), ('PySide2.QtGui.QVector2D', 'float', 'float'), ('PySide2.QtGui.QVector3D',), ('PySide2.QtGui.QVector3D', 'float'), ('float', 'float', 'float', 'float')],
    "PySide2.QtGui.QVector4D.__add__": ('PySide2.QtGui.QVector4D',),
    "PySide2.QtGui.QVector4D.__copy__": (),
    "PySide2.QtGui.QVector4D.__iadd__": ('PySide2.QtGui.QVector4D',),
    "PySide2.QtGui.QVector4D.__imul__": [('PySide2.QtGui.QVector4D',), ('float',)],
    "PySide2.QtGui.QVector4D.__isub__": ('PySide2.QtGui.QVector4D',),
    "PySide2.QtGui.QVector4D.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QVector4D.__mul__": [('PySide2.QtGui.QMatrix4x4',), ('PySide2.QtGui.QVector4D',), ('float',)],
    "PySide2.QtGui.QVector4D.__neg__": (),
    "PySide2.QtGui.QVector4D.__reduce__": (),
    "PySide2.QtGui.QVector4D.__repr__": (),
    "PySide2.QtGui.QVector4D.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtGui.QVector4D.__sub__": ('PySide2.QtGui.QVector4D',),
    "PySide2.QtGui.QVector4D.dotProduct": ('PySide2.QtGui.QVector4D', 'PySide2.QtGui.QVector4D'),
    "PySide2.QtGui.QVector4D.isNull": (),
    "PySide2.QtGui.QVector4D.length": (),
    "PySide2.QtGui.QVector4D.lengthSquared": (),
    "PySide2.QtGui.QVector4D.normalize": (),
    "PySide2.QtGui.QVector4D.normalized": (),
    "PySide2.QtGui.QVector4D.setW": ('float',),
    "PySide2.QtGui.QVector4D.setX": ('float',),
    "PySide2.QtGui.QVector4D.setY": ('float',),
    "PySide2.QtGui.QVector4D.setZ": ('float',),
    "PySide2.QtGui.QVector4D.toPoint": (),
    "PySide2.QtGui.QVector4D.toPointF": (),
    "PySide2.QtGui.QVector4D.toTuple": (),
    "PySide2.QtGui.QVector4D.toVector2D": (),
    "PySide2.QtGui.QVector4D.toVector2DAffine": (),
    "PySide2.QtGui.QVector4D.toVector3D": (),
    "PySide2.QtGui.QVector4D.toVector3DAffine": (),
    "PySide2.QtGui.QVector4D.w": (),
    "PySide2.QtGui.QVector4D.x": (),
    "PySide2.QtGui.QVector4D.y": (),
    "PySide2.QtGui.QVector4D.z": (),

# class PySide2.QtGui.QWhatsThisClickedEvent:
    "PySide2.QtGui.QWhatsThisClickedEvent.__init__": ('str',),
    "PySide2.QtGui.QWhatsThisClickedEvent.href": (),

# class PySide2.QtGui.QWheelEvent:
    "PySide2.QtGui.QWheelEvent.__init__": [('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.Qt.ScrollPhase', 'bool', 'PySide2.QtCore.Qt.MouseEventSource'), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint', 'int', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers'), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint', 'int', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.Qt.ScrollPhase'), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint', 'int', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.Qt.ScrollPhase', 'PySide2.QtCore.Qt.MouseEventSource'), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'PySide2.QtCore.QPoint', 'PySide2.QtCore.QPoint', 'int', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.Qt.ScrollPhase', 'PySide2.QtCore.Qt.MouseEventSource', 'bool'), ('PySide2.QtCore.QPointF', 'PySide2.QtCore.QPointF', 'int', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.Qt.Orientation'), ('PySide2.QtCore.QPointF', 'int', 'PySide2.QtCore.Qt.MouseButtons', 'PySide2.QtCore.Qt.KeyboardModifiers', 'PySide2.QtCore.Qt.Orientation')],
    "PySide2.QtGui.QWheelEvent.angleDelta": (),
    "PySide2.QtGui.QWheelEvent.buttons": (),
    "PySide2.QtGui.QWheelEvent.delta": (),
    "PySide2.QtGui.QWheelEvent.globalPos": (),
    "PySide2.QtGui.QWheelEvent.globalPosF": (),
    "PySide2.QtGui.QWheelEvent.globalPosition": (),
    "PySide2.QtGui.QWheelEvent.globalX": (),
    "PySide2.QtGui.QWheelEvent.global""Y": (),
    "PySide2.QtGui.QWheelEvent.inverted": (),
    "PySide2.QtGui.QWheelEvent.orientation": (),
    "PySide2.QtGui.QWheelEvent.phase": (),
    "PySide2.QtGui.QWheelEvent.pixelDelta": (),
    "PySide2.QtGui.QWheelEvent.pos": (),
    "PySide2.QtGui.QWheelEvent.posF": (),
    "PySide2.QtGui.QWheelEvent.position": (),
    "PySide2.QtGui.QWheelEvent.source": (),
    "PySide2.QtGui.QWheelEvent.x": (),
    "PySide2.QtGui.QWheelEvent.y": (),

# class PySide2.QtGui.QWindow:

# class PySide2.QtGui.QWindow.AncestorMode:

# class PySide2.QtGui.QWindow.Visibility:
    "PySide2.QtGui.QWindow.__init__": [('PySide2.QtGui.QScreen',), ('PySide2.QtGui.QWindow',)],
    "PySide2.QtGui.QWindow.accessibleRoot": (),
    "PySide2.QtGui.QWindow.alert": ('int',),
    "PySide2.QtGui.QWindow.baseSize": (),
    "PySide2.QtGui.QWindow.close": (),
    "PySide2.QtGui.QWindow.contentOrientation": (),
    "PySide2.QtGui.QWindow.create": (),
    "PySide2.QtGui.QWindow.cursor": (),
    "PySide2.QtGui.QWindow.destroy": (),
    "PySide2.QtGui.QWindow.devicePixelRatio": (),
    "PySide2.QtGui.QWindow.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtGui.QWindow.exposeEvent": ('PySide2.QtGui.QExposeEvent',),
    "PySide2.QtGui.QWindow.filePath": (),
    "PySide2.QtGui.QWindow.flags": (),
    "PySide2.QtGui.QWindow.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtGui.QWindow.focusObject": (),
    "PySide2.QtGui.QWindow.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtGui.QWindow.format": (),
    "PySide2.QtGui.QWindow.frameGeometry": (),
    "PySide2.QtGui.QWindow.frameMargins": (),
    "PySide2.QtGui.QWindow.framePosition": (),
    "PySide2.QtGui.QWindow.fromWinId": ('int',),
    "PySide2.QtGui.QWindow.geometry": (),
    "PySide2.QtGui.QWindow.height": (),
    "PySide2.QtGui.QWindow.hide": (),
    "PySide2.QtGui.QWindow.hideEvent": ('PySide2.QtGui.QHideEvent',),
    "PySide2.QtGui.QWindow.icon": (),
    "PySide2.QtGui.QWindow.isActive": (),
    "PySide2.QtGui.QWindow.isAncestorOf": ('PySide2.QtGui.QWindow', 'PySide2.QtGui.QWindow.AncestorMode'),
    "PySide2.QtGui.QWindow.isExposed": (),
    "PySide2.QtGui.QWindow.isModal": (),
    "PySide2.QtGui.QWindow.isTopLevel": (),
    "PySide2.QtGui.QWindow.isVisible": (),
    "PySide2.QtGui.QWindow.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtGui.QWindow.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtGui.QWindow.lower": (),
    "PySide2.QtGui.QWindow.mapFromGlobal": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QWindow.mapToGlobal": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QWindow.mask": (),
    "PySide2.QtGui.QWindow.maximumHeight": (),
    "PySide2.QtGui.QWindow.maximumSize": (),
    "PySide2.QtGui.QWindow.maximumWidth": (),
    "PySide2.QtGui.QWindow.minimumHeight": (),
    "PySide2.QtGui.QWindow.minimumSize": (),
    "PySide2.QtGui.QWindow.minimumWidth": (),
    "PySide2.QtGui.QWindow.modality": (),
    "PySide2.QtGui.QWindow.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtGui.QWindow.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtGui.QWindow.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtGui.QWindow.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtGui.QWindow.moveEvent": ('PySide2.QtGui.QMoveEvent',),
    "PySide2.QtGui.QWindow.nativeEvent": ('PySide2.QtCore.QByteArray', 'int'),
    "PySide2.QtGui.QWindow.opacity": (),
    "PySide2.QtGui.QWindow.parent": [(), ('PySide2.QtGui.QWindow.AncestorMode',)],
    "PySide2.QtGui.QWindow.position": (),
    "PySide2.QtGui.QWindow.raise_": (),
    "PySide2.QtGui.QWindow.reportContentOrientationChange": ('PySide2.QtCore.Qt.ScreenOrientation',),
    "PySide2.QtGui.QWindow.requestActivate": (),
    "PySide2.QtGui.QWindow.requestUpdate": (),
    "PySide2.QtGui.QWindow.requestedFormat": (),
    "PySide2.QtGui.QWindow.resize": [('PySide2.QtCore.QSize',), ('int', 'int')],
    "PySide2.QtGui.QWindow.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtGui.QWindow.screen": (),
    "PySide2.QtGui.QWindow.setBaseSize": ('PySide2.QtCore.QSize',),
    "PySide2.QtGui.QWindow.setCursor": ('PySide2.QtGui.QCursor',),
    "PySide2.QtGui.QWindow.setFilePath": ('str',),
    "PySide2.QtGui.QWindow.setFlag": ('PySide2.QtCore.Qt.WindowType', 'bool'),
    "PySide2.QtGui.QWindow.setFlags": ('PySide2.QtCore.Qt.WindowFlags',),
    "PySide2.QtGui.QWindow.setFormat": ('PySide2.QtGui.QSurfaceFormat',),
    "PySide2.QtGui.QWindow.setFramePosition": ('PySide2.QtCore.QPoint',),
    "PySide2.QtGui.QWindow.setGeometry": [('PySide2.QtCore.QRect',), ('int', 'int', 'int', 'int')],
    "PySide2.QtGui.QWindow.setHeight": ('int',),
    "PySide2.QtGui.QWindow.setIcon": ('PySide2.QtGui.QIcon',),
    "PySide2.QtGui.QWindow.setKeyboardGrabEnabled": ('bool',),
    "PySide2.QtGui.QWindow.setMask": ('PySide2.QtGui.QRegion',),
    "PySide2.QtGui.QWindow.setMaximumHeight": ('int',),
    "PySide2.QtGui.QWindow.setMaximumSize": ('PySide2.QtCore.QSize',),
    "PySide2.QtGui.QWindow.setMaximumWidth": ('int',),
    "PySide2.QtGui.QWindow.setMinimumHeight": ('int',),
    "PySide2.QtGui.QWindow.setMinimumSize": ('PySide2.QtCore.QSize',),
    "PySide2.QtGui.QWindow.setMinimumWidth": ('int',),
    "PySide2.QtGui.QWindow.setModality": ('PySide2.QtCore.Qt.WindowModality',),
    "PySide2.QtGui.QWindow.setMouseGrabEnabled": ('bool',),
    "PySide2.QtGui.QWindow.setOpacity": ('float',),
    "PySide2.QtGui.QWindow.setParent": ('PySide2.QtGui.QWindow',),
    "PySide2.QtGui.QWindow.setPosition": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtGui.QWindow.setScreen": ('PySide2.QtGui.QScreen',),
    "PySide2.QtGui.QWindow.setSizeIncrement": ('PySide2.QtCore.QSize',),
    "PySide2.QtGui.QWindow.setSurfaceType": ('PySide2.QtGui.QSurface.SurfaceType',),
    "PySide2.QtGui.QWindow.setTitle": ('str',),
    "PySide2.QtGui.QWindow.setTransientParent": ('PySide2.QtGui.QWindow',),
    "PySide2.QtGui.QWindow.setVisibility": ('PySide2.QtGui.QWindow.Visibility',),
    "PySide2.QtGui.QWindow.setVisible": ('bool',),
    "PySide2.QtGui.QWindow.setWidth": ('int',),
    "PySide2.QtGui.QWindow.setWindowState": ('PySide2.QtCore.Qt.WindowState',),
    "PySide2.QtGui.QWindow.setWindowStates": ('PySide2.QtCore.Qt.WindowStates',),
    "PySide2.QtGui.QWindow.setX": ('int',),
    "PySide2.QtGui.QWindow.setY": ('int',),
    "PySide2.QtGui.QWindow.show": (),
    "PySide2.QtGui.QWindow.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtGui.QWindow.showFullScreen": (),
    "PySide2.QtGui.QWindow.showMaximized": (),
    "PySide2.QtGui.QWindow.showMinimized": (),
    "PySide2.QtGui.QWindow.showNormal": (),
    "PySide2.QtGui.QWindow.size": (),
    "PySide2.QtGui.QWindow.sizeIncrement": (),
    "PySide2.QtGui.QWindow.surfaceHandle": (),
    "PySide2.QtGui.QWindow.surfaceType": (),
    "PySide2.QtGui.QWindow.tabletEvent": ('PySide2.QtGui.QTabletEvent',),
    "PySide2.QtGui.QWindow.title": (),
    "PySide2.QtGui.QWindow.touchEvent": ('PySide2.QtGui.QTouchEvent',),
    "PySide2.QtGui.QWindow.transientParent": (),
    "PySide2.QtGui.QWindow.type": (),
    "PySide2.QtGui.QWindow.unsetCursor": (),
    "PySide2.QtGui.QWindow.visibility": (),
    "PySide2.QtGui.QWindow.wheelEvent": ('PySide2.QtGui.QWheelEvent',),
    "PySide2.QtGui.QWindow.width": (),
    "PySide2.QtGui.QWindow.winId": (),
    "PySide2.QtGui.QWindow.windowState": (),
    "PySide2.QtGui.QWindow.windowStates": (),
    "PySide2.QtGui.QWindow.x": (),
    "PySide2.QtGui.QWindow.y": (),

# class PySide2.QtGui.QWindowStateChangeEvent:
    "PySide2.QtGui.QWindowStateChangeEvent.__init__": ('PySide2.QtCore.Qt.WindowStates', 'bool'),
    "PySide2.QtGui.QWindowStateChangeEvent.isOverride": (),
    "PySide2.QtGui.QWindowStateChangeEvent.oldState": (),

# class PySide2.QtGui.Qt:
    "PySide2.QtGui.Qt.codecForHtml": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtGui.Qt.convertFromPlainText": ('str', 'PySide2.QtCore.Qt.WhiteSpaceMode'),
    "PySide2.QtGui.Qt.mightBeRichText": ('str',),

    "PySide2.QtGui.Qt.qAlpha": ('int',),
    "PySide2.QtGui.Qt.qBlue": ('int',),
    "PySide2.QtGui.Qt.qGray": [('int',), ('int', 'int', 'int')],
    "PySide2.QtGui.Qt.qGreen": ('int',),
    "PySide2.QtGui.Qt.qIsGray": ('int',),
    "PySide2.QtGui.Qt.qRed": ('int',),
    "PySide2.QtGui.Qt.qRgb": ('int', 'int', 'int'),
    "PySide2.QtGui.Qt.qRgba": ('int', 'int', 'int', 'int'),
    }) if "PySide2.QtGui" in sys.modules else None

# Module PySide2.QtWidgets
sig_dict.update({

# class PySide2.QtWidgets.QAbstractButton:
    "PySide2.QtWidgets.QAbstractButton.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QAbstractButton.animateClick": ('int',),
    "PySide2.QtWidgets.QAbstractButton.autoExclusive": (),
    "PySide2.QtWidgets.QAbstractButton.autoRepeat": (),
    "PySide2.QtWidgets.QAbstractButton.autoRepeatDelay": (),
    "PySide2.QtWidgets.QAbstractButton.autoRepeatInterval": (),
    "PySide2.QtWidgets.QAbstractButton.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QAbstractButton.checkStateSet": (),
    "PySide2.QtWidgets.QAbstractButton.click": (),
    "PySide2.QtWidgets.QAbstractButton.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QAbstractButton.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QAbstractButton.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QAbstractButton.group": (),
    "PySide2.QtWidgets.QAbstractButton.hitButton": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QAbstractButton.icon": (),
    "PySide2.QtWidgets.QAbstractButton.iconSize": (),
    "PySide2.QtWidgets.QAbstractButton.isCheckable": (),
    "PySide2.QtWidgets.QAbstractButton.isChecked": (),
    "PySide2.QtWidgets.QAbstractButton.isDown": (),
    "PySide2.QtWidgets.QAbstractButton.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QAbstractButton.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QAbstractButton.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QAbstractButton.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QAbstractButton.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QAbstractButton.nextCheckState": (),
    "PySide2.QtWidgets.QAbstractButton.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QAbstractButton.setAutoExclusive": ('bool',),
    "PySide2.QtWidgets.QAbstractButton.setAutoRepeat": ('bool',),
    "PySide2.QtWidgets.QAbstractButton.setAutoRepeatDelay": ('int',),
    "PySide2.QtWidgets.QAbstractButton.setAutoRepeatInterval": ('int',),
    "PySide2.QtWidgets.QAbstractButton.setCheckable": ('bool',),
    "PySide2.QtWidgets.QAbstractButton.setChecked": ('bool',),
    "PySide2.QtWidgets.QAbstractButton.setDown": ('bool',),
    "PySide2.QtWidgets.QAbstractButton.setIcon": ('PySide2.QtGui.QIcon',),
    "PySide2.QtWidgets.QAbstractButton.setIconSize": ('PySide2.QtCore.QSize',),
    "PySide2.QtWidgets.QAbstractButton.setShortcut": ('PySide2.QtGui.QKeySequence',),
    "PySide2.QtWidgets.QAbstractButton.setText": ('str',),
    "PySide2.QtWidgets.QAbstractButton.shortcut": (),
    "PySide2.QtWidgets.QAbstractButton.text": (),
    "PySide2.QtWidgets.QAbstractButton.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtWidgets.QAbstractButton.toggle": (),

# class PySide2.QtWidgets.QAbstractGraphicsShapeItem:
    "PySide2.QtWidgets.QAbstractGraphicsShapeItem.__init__": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QAbstractGraphicsShapeItem.brush": (),
    "PySide2.QtWidgets.QAbstractGraphicsShapeItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QAbstractGraphicsShapeItem.opaqueArea": (),
    "PySide2.QtWidgets.QAbstractGraphicsShapeItem.pen": (),
    "PySide2.QtWidgets.QAbstractGraphicsShapeItem.setBrush": ('PySide2.QtGui.QBrush',),
    "PySide2.QtWidgets.QAbstractGraphicsShapeItem.setPen": ('PySide2.QtGui.QPen',),

# class PySide2.QtWidgets.QAbstractItemDelegate:

# class PySide2.QtWidgets.QAbstractItemDelegate.EndEditHint:
    "PySide2.QtWidgets.QAbstractItemDelegate.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QAbstractItemDelegate.createEditor": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QAbstractItemDelegate.destroyEditor": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QAbstractItemDelegate.editorEvent": ('PySide2.QtCore.QEvent', 'PySide2.QtCore.QAbstractItemModel', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QAbstractItemDelegate.elidedText": ('PySide2.QtGui.QFontMetrics', 'int', 'PySide2.QtCore.Qt.TextElideMode', 'str'),
    "PySide2.QtWidgets.QAbstractItemDelegate.helpEvent": ('PySide2.QtGui.QHelpEvent', 'PySide2.QtWidgets.QAbstractItemView', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QAbstractItemDelegate.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QAbstractItemDelegate.paintingRoles": (),
    "PySide2.QtWidgets.QAbstractItemDelegate.setEditorData": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QAbstractItemDelegate.setModelData": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QAbstractItemModel', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QAbstractItemDelegate.sizeHint": ('PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QAbstractItemDelegate.updateEditorGeometry": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),

# class PySide2.QtWidgets.QAbstractItemView:

# class PySide2.QtWidgets.QAbstractItemView.CursorAction:

# class PySide2.QtWidgets.QAbstractItemView.DragDropMode:

# class PySide2.QtWidgets.QAbstractItemView.DropIndicatorPosition:

# class PySide2.QtWidgets.QAbstractItemView.EditTrigger:

# class PySide2.QtWidgets.QAbstractItemView.EditTriggers:

# class PySide2.QtWidgets.QAbstractItemView.ScrollHint:

# class PySide2.QtWidgets.QAbstractItemView.ScrollMode:

# class PySide2.QtWidgets.QAbstractItemView.SelectionBehavior:

# class PySide2.QtWidgets.QAbstractItemView.SelectionMode:

# class PySide2.QtWidgets.QAbstractItemView.State:
    "PySide2.QtWidgets.QAbstractItemView.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QAbstractItemView.alternatingRowColors": (),
    "PySide2.QtWidgets.QAbstractItemView.autoScrollMargin": (),
    "PySide2.QtWidgets.QAbstractItemView.clearSelection": (),
    "PySide2.QtWidgets.QAbstractItemView.closeEditor": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QAbstractItemDelegate.EndEditHint'),
    "PySide2.QtWidgets.QAbstractItemView.closePersistentEditor": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QAbstractItemView.commitData": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QAbstractItemView.currentChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QAbstractItemView.currentIndex": (),
    "PySide2.QtWidgets.QAbstractItemView.dataChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex', 'typing.List'),
    "PySide2.QtWidgets.QAbstractItemView.defaultDropAction": (),
    "PySide2.QtWidgets.QAbstractItemView.dirtyRegionOffset": (),
    "PySide2.QtWidgets.QAbstractItemView.doAutoScroll": (),
    "PySide2.QtWidgets.QAbstractItemView.doItemsLayout": (),
    "PySide2.QtWidgets.QAbstractItemView.dragDropMode": (),
    "PySide2.QtWidgets.QAbstractItemView.dragDropOverwriteMode": (),
    "PySide2.QtWidgets.QAbstractItemView.dragEnabled": (),
    "PySide2.QtWidgets.QAbstractItemView.dragEnterEvent": ('PySide2.QtGui.QDragEnterEvent',),
    "PySide2.QtWidgets.QAbstractItemView.dragLeaveEvent": ('PySide2.QtGui.QDragLeaveEvent',),
    "PySide2.QtWidgets.QAbstractItemView.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
    "PySide2.QtWidgets.QAbstractItemView.dropEvent": ('PySide2.QtGui.QDropEvent',),
    "PySide2.QtWidgets.QAbstractItemView.dropIndicatorPosition": (),
    "PySide2.QtWidgets.QAbstractItemView.edit": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QAbstractItemView.EditTrigger', 'PySide2.QtCore.QEvent')],
    "PySide2.QtWidgets.QAbstractItemView.editTriggers": (),
    "PySide2.QtWidgets.QAbstractItemView.editorDestroyed": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QAbstractItemView.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QAbstractItemView.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QAbstractItemView.executeDelayedItemsLayout": (),
    "PySide2.QtWidgets.QAbstractItemView.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QAbstractItemView.focusNextPrevChild": ('bool',),
    "PySide2.QtWidgets.QAbstractItemView.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QAbstractItemView.hasAutoScroll": (),
    "PySide2.QtWidgets.QAbstractItemView.horizontalOffset": (),
    "PySide2.QtWidgets.QAbstractItemView.horizontalScrollMode": (),
    "PySide2.QtWidgets.QAbstractItemView.horizontalScrollbarAction": ('int',),
    "PySide2.QtWidgets.QAbstractItemView.horizontalScrollbarValueChanged": ('int',),
    "PySide2.QtWidgets.QAbstractItemView.horizontalStepsPerItem": (),
    "PySide2.QtWidgets.QAbstractItemView.iconSize": (),
    "PySide2.QtWidgets.QAbstractItemView.indexAt": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QAbstractItemView.indexWidget": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QAbstractItemView.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
    "PySide2.QtWidgets.QAbstractItemView.inputMethodQuery": ('PySide2.QtCore.Qt.InputMethodQuery',),
    "PySide2.QtWidgets.QAbstractItemView.isIndexHidden": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QAbstractItemView.isPersistentEditorOpen": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QAbstractItemView.itemDelegate": [(), ('PySide2.QtCore.QModelIndex',)],
    "PySide2.QtWidgets.QAbstractItemView.itemDelegateForColumn": ('int',),
    "PySide2.QtWidgets.QAbstractItemView.itemDelegateForRow": ('int',),
    "PySide2.QtWidgets.QAbstractItemView.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QAbstractItemView.keyboardSearch": ('str',),
    "PySide2.QtWidgets.QAbstractItemView.model": (),
    "PySide2.QtWidgets.QAbstractItemView.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QAbstractItemView.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QAbstractItemView.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QAbstractItemView.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QAbstractItemView.moveCursor": ('PySide2.QtWidgets.QAbstractItemView.CursorAction', 'PySide2.QtCore.Qt.KeyboardModifiers'),
    "PySide2.QtWidgets.QAbstractItemView.openPersistentEditor": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QAbstractItemView.reset": (),
    "PySide2.QtWidgets.QAbstractItemView.resetHorizontalScrollMode": (),
    "PySide2.QtWidgets.QAbstractItemView.resetVerticalScrollMode": (),
    "PySide2.QtWidgets.QAbstractItemView.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QAbstractItemView.rootIndex": (),
    "PySide2.QtWidgets.QAbstractItemView.rowsAboutToBeRemoved": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtWidgets.QAbstractItemView.rowsInserted": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtWidgets.QAbstractItemView.scheduleDelayedItemsLayout": (),
    "PySide2.QtWidgets.QAbstractItemView.scrollDirtyRegion": ('int', 'int'),
    "PySide2.QtWidgets.QAbstractItemView.scrollTo": ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
    "PySide2.QtWidgets.QAbstractItemView.scrollToBottom": (),
    "PySide2.QtWidgets.QAbstractItemView.scrollToTop": (),
    "PySide2.QtWidgets.QAbstractItemView.selectAll": (),
    "PySide2.QtWidgets.QAbstractItemView.selectedIndexes": (),
    "PySide2.QtWidgets.QAbstractItemView.selectionBehavior": (),
    "PySide2.QtWidgets.QAbstractItemView.selectionChanged": ('PySide2.QtCore.QItemSelection', 'PySide2.QtCore.QItemSelection'),
    "PySide2.QtWidgets.QAbstractItemView.selectionCommand": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QAbstractItemView.selectionMode": (),
    "PySide2.QtWidgets.QAbstractItemView.selectionModel": (),
    "PySide2.QtWidgets.QAbstractItemView.setAlternatingRowColors": ('bool',),
    "PySide2.QtWidgets.QAbstractItemView.setAutoScroll": ('bool',),
    "PySide2.QtWidgets.QAbstractItemView.setAutoScrollMargin": ('int',),
    "PySide2.QtWidgets.QAbstractItemView.setCurrentIndex": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QAbstractItemView.setDefaultDropAction": ('PySide2.QtCore.Qt.DropAction',),
    "PySide2.QtWidgets.QAbstractItemView.setDirtyRegion": ('PySide2.QtGui.QRegion',),
    "PySide2.QtWidgets.QAbstractItemView.setDragDropMode": ('PySide2.QtWidgets.QAbstractItemView.DragDropMode',),
    "PySide2.QtWidgets.QAbstractItemView.setDragDropOverwriteMode": ('bool',),
    "PySide2.QtWidgets.QAbstractItemView.setDragEnabled": ('bool',),
    "PySide2.QtWidgets.QAbstractItemView.setDropIndicatorShown": ('bool',),
    "PySide2.QtWidgets.QAbstractItemView.setEditTriggers": ('PySide2.QtWidgets.QAbstractItemView.EditTriggers',),
    "PySide2.QtWidgets.QAbstractItemView.setHorizontalScrollMode": ('PySide2.QtWidgets.QAbstractItemView.ScrollMode',),
    "PySide2.QtWidgets.QAbstractItemView.setHorizontalStepsPerItem": ('int',),
    "PySide2.QtWidgets.QAbstractItemView.setIconSize": ('PySide2.QtCore.QSize',),
    "PySide2.QtWidgets.QAbstractItemView.setIndexWidget": ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QAbstractItemView.setItemDelegate": ('PySide2.QtWidgets.QAbstractItemDelegate',),
    "PySide2.QtWidgets.QAbstractItemView.setItemDelegateForColumn": ('int', 'PySide2.QtWidgets.QAbstractItemDelegate'),
    "PySide2.QtWidgets.QAbstractItemView.setItemDelegateForRow": ('int', 'PySide2.QtWidgets.QAbstractItemDelegate'),
    "PySide2.QtWidgets.QAbstractItemView.setModel": ('PySide2.QtCore.QAbstractItemModel',),
    "PySide2.QtWidgets.QAbstractItemView.setRootIndex": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QAbstractItemView.setSelection": ('PySide2.QtCore.QRect', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'),
    "PySide2.QtWidgets.QAbstractItemView.setSelectionBehavior": ('PySide2.QtWidgets.QAbstractItemView.SelectionBehavior',),
    "PySide2.QtWidgets.QAbstractItemView.setSelectionMode": ('PySide2.QtWidgets.QAbstractItemView.SelectionMode',),
    "PySide2.QtWidgets.QAbstractItemView.setSelectionModel": ('PySide2.QtCore.QItemSelectionModel',),
    "PySide2.QtWidgets.QAbstractItemView.setState": ('PySide2.QtWidgets.QAbstractItemView.State',),
    "PySide2.QtWidgets.QAbstractItemView.setTabKeyNavigation": ('bool',),
    "PySide2.QtWidgets.QAbstractItemView.setTextElideMode": ('PySide2.QtCore.Qt.TextElideMode',),
    "PySide2.QtWidgets.QAbstractItemView.setVerticalScrollMode": ('PySide2.QtWidgets.QAbstractItemView.ScrollMode',),
    "PySide2.QtWidgets.QAbstractItemView.setVerticalStepsPerItem": ('int',),
    "PySide2.QtWidgets.QAbstractItemView.showDropIndicator": (),
    "PySide2.QtWidgets.QAbstractItemView.sizeHintForColumn": ('int',),
    "PySide2.QtWidgets.QAbstractItemView.sizeHintForIndex": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QAbstractItemView.sizeHintForRow": ('int',),
    "PySide2.QtWidgets.QAbstractItemView.startAutoScroll": (),
    "PySide2.QtWidgets.QAbstractItemView.startDrag": ('PySide2.QtCore.Qt.DropActions',),
    "PySide2.QtWidgets.QAbstractItemView.state": (),
    "PySide2.QtWidgets.QAbstractItemView.stopAutoScroll": (),
    "PySide2.QtWidgets.QAbstractItemView.tabKeyNavigation": (),
    "PySide2.QtWidgets.QAbstractItemView.textElideMode": (),
    "PySide2.QtWidgets.QAbstractItemView.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtWidgets.QAbstractItemView.update": [(), ('PySide2.QtCore.QModelIndex',)],
    "PySide2.QtWidgets.QAbstractItemView.updateEditorData": (),
    "PySide2.QtWidgets.QAbstractItemView.updateEditorGeometries": (),
    "PySide2.QtWidgets.QAbstractItemView.updateGeometries": (),
    "PySide2.QtWidgets.QAbstractItemView.verticalOffset": (),
    "PySide2.QtWidgets.QAbstractItemView.verticalScrollMode": (),
    "PySide2.QtWidgets.QAbstractItemView.verticalScrollbarAction": ('int',),
    "PySide2.QtWidgets.QAbstractItemView.verticalScrollbarValueChanged": ('int',),
    "PySide2.QtWidgets.QAbstractItemView.verticalStepsPerItem": (),
    "PySide2.QtWidgets.QAbstractItemView.viewOptions": (),
    "PySide2.QtWidgets.QAbstractItemView.viewportEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QAbstractItemView.viewportSizeHint": (),
    "PySide2.QtWidgets.QAbstractItemView.visualRect": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QAbstractItemView.visualRegionForSelection": ('PySide2.QtCore.QItemSelection',),

# class PySide2.QtWidgets.QAbstractScrollArea:

# class PySide2.QtWidgets.QAbstractScrollArea.SizeAdjustPolicy:
    "PySide2.QtWidgets.QAbstractScrollArea.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QAbstractScrollArea.addScrollBarWidget": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.Alignment'),
    "PySide2.QtWidgets.QAbstractScrollArea.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
    "PySide2.QtWidgets.QAbstractScrollArea.cornerWidget": (),
    "PySide2.QtWidgets.QAbstractScrollArea.dragEnterEvent": ('PySide2.QtGui.QDragEnterEvent',),
    "PySide2.QtWidgets.QAbstractScrollArea.dragLeaveEvent": ('PySide2.QtGui.QDragLeaveEvent',),
    "PySide2.QtWidgets.QAbstractScrollArea.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
    "PySide2.QtWidgets.QAbstractScrollArea.dropEvent": ('PySide2.QtGui.QDropEvent',),
    "PySide2.QtWidgets.QAbstractScrollArea.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QAbstractScrollArea.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QAbstractScrollArea.horizontalScrollBar": (),
    "PySide2.QtWidgets.QAbstractScrollArea.horizontalScrollBarPolicy": (),
    "PySide2.QtWidgets.QAbstractScrollArea.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QAbstractScrollArea.maximumViewportSize": (),
    "PySide2.QtWidgets.QAbstractScrollArea.minimumSizeHint": (),
    "PySide2.QtWidgets.QAbstractScrollArea.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QAbstractScrollArea.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QAbstractScrollArea.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QAbstractScrollArea.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QAbstractScrollArea.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QAbstractScrollArea.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QAbstractScrollArea.scrollBarWidgets": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtWidgets.QAbstractScrollArea.scrollContentsBy": ('int', 'int'),
    "PySide2.QtWidgets.QAbstractScrollArea.setCornerWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QAbstractScrollArea.setHorizontalScrollBar": ('PySide2.QtWidgets.QScrollBar',),
    "PySide2.QtWidgets.QAbstractScrollArea.setHorizontalScrollBarPolicy": ('PySide2.QtCore.Qt.ScrollBarPolicy',),
    "PySide2.QtWidgets.QAbstractScrollArea.setSizeAdjustPolicy": ('PySide2.QtWidgets.QAbstractScrollArea.SizeAdjustPolicy',),
    "PySide2.QtWidgets.QAbstractScrollArea.setVerticalScrollBar": ('PySide2.QtWidgets.QScrollBar',),
    "PySide2.QtWidgets.QAbstractScrollArea.setVerticalScrollBarPolicy": ('PySide2.QtCore.Qt.ScrollBarPolicy',),
    "PySide2.QtWidgets.QAbstractScrollArea.setViewport": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QAbstractScrollArea.setViewportMargins": [('PySide2.QtCore.QMargins',), ('int', 'int', 'int', 'int')],
    "PySide2.QtWidgets.QAbstractScrollArea.setupViewport": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QAbstractScrollArea.sizeAdjustPolicy": (),
    "PySide2.QtWidgets.QAbstractScrollArea.sizeHint": (),
    "PySide2.QtWidgets.QAbstractScrollArea.verticalScrollBar": (),
    "PySide2.QtWidgets.QAbstractScrollArea.verticalScrollBarPolicy": (),
    "PySide2.QtWidgets.QAbstractScrollArea.viewport": (),
    "PySide2.QtWidgets.QAbstractScrollArea.viewportEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QAbstractScrollArea.viewportMargins": (),
    "PySide2.QtWidgets.QAbstractScrollArea.viewportSizeHint": (),
    "PySide2.QtWidgets.QAbstractScrollArea.wheelEvent": ('PySide2.QtGui.QWheelEvent',),

# class PySide2.QtWidgets.QAbstractSlider:

# class PySide2.QtWidgets.QAbstractSlider.SliderAction:

# class PySide2.QtWidgets.QAbstractSlider.SliderChange:
    "PySide2.QtWidgets.QAbstractSlider.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QAbstractSlider.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QAbstractSlider.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QAbstractSlider.hasTracking": (),
    "PySide2.QtWidgets.QAbstractSlider.invertedAppearance": (),
    "PySide2.QtWidgets.QAbstractSlider.invertedControls": (),
    "PySide2.QtWidgets.QAbstractSlider.isSliderDown": (),
    "PySide2.QtWidgets.QAbstractSlider.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QAbstractSlider.maximum": (),
    "PySide2.QtWidgets.QAbstractSlider.minimum": (),
    "PySide2.QtWidgets.QAbstractSlider.orientation": (),
    "PySide2.QtWidgets.QAbstractSlider.pageStep": (),
    "PySide2.QtWidgets.QAbstractSlider.repeatAction": (),
    "PySide2.QtWidgets.QAbstractSlider.setInvertedAppearance": ('bool',),
    "PySide2.QtWidgets.QAbstractSlider.setInvertedControls": ('bool',),
    "PySide2.QtWidgets.QAbstractSlider.setMaximum": ('int',),
    "PySide2.QtWidgets.QAbstractSlider.setMinimum": ('int',),
    "PySide2.QtWidgets.QAbstractSlider.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
    "PySide2.QtWidgets.QAbstractSlider.setPageStep": ('int',),
    "PySide2.QtWidgets.QAbstractSlider.setRange": ('int', 'int'),
    "PySide2.QtWidgets.QAbstractSlider.setRepeatAction": ('PySide2.QtWidgets.QAbstractSlider.SliderAction', 'int', 'int'),
    "PySide2.QtWidgets.QAbstractSlider.setSingleStep": ('int',),
    "PySide2.QtWidgets.QAbstractSlider.setSliderDown": ('bool',),
    "PySide2.QtWidgets.QAbstractSlider.setSliderPosition": ('int',),
    "PySide2.QtWidgets.QAbstractSlider.setTracking": ('bool',),
    "PySide2.QtWidgets.QAbstractSlider.setValue": ('int',),
    "PySide2.QtWidgets.QAbstractSlider.singleStep": (),
    "PySide2.QtWidgets.QAbstractSlider.sliderChange": ('PySide2.QtWidgets.QAbstractSlider.SliderChange',),
    "PySide2.QtWidgets.QAbstractSlider.sliderPosition": (),
    "PySide2.QtWidgets.QAbstractSlider.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtWidgets.QAbstractSlider.triggerAction": ('PySide2.QtWidgets.QAbstractSlider.SliderAction',),
    "PySide2.QtWidgets.QAbstractSlider.value": (),
    "PySide2.QtWidgets.QAbstractSlider.wheelEvent": ('PySide2.QtGui.QWheelEvent',),

# class PySide2.QtWidgets.QAbstractSpinBox:

# class PySide2.QtWidgets.QAbstractSpinBox.ButtonSymbols:

# class PySide2.QtWidgets.QAbstractSpinBox.CorrectionMode:

# class PySide2.QtWidgets.QAbstractSpinBox.StepEnabled:

# class PySide2.QtWidgets.QAbstractSpinBox.StepEnabledFlag:

# class PySide2.QtWidgets.QAbstractSpinBox.StepType:
    "PySide2.QtWidgets.QAbstractSpinBox.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QAbstractSpinBox.alignment": (),
    "PySide2.QtWidgets.QAbstractSpinBox.buttonSymbols": (),
    "PySide2.QtWidgets.QAbstractSpinBox.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QAbstractSpinBox.clear": (),
    "PySide2.QtWidgets.QAbstractSpinBox.closeEvent": ('PySide2.QtGui.QCloseEvent',),
    "PySide2.QtWidgets.QAbstractSpinBox.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
    "PySide2.QtWidgets.QAbstractSpinBox.correctionMode": (),
    "PySide2.QtWidgets.QAbstractSpinBox.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QAbstractSpinBox.fixup": ('str',),
    "PySide2.QtWidgets.QAbstractSpinBox.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QAbstractSpinBox.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QAbstractSpinBox.hasAcceptableInput": (),
    "PySide2.QtWidgets.QAbstractSpinBox.hasFrame": (),
    "PySide2.QtWidgets.QAbstractSpinBox.hideEvent": ('PySide2.QtGui.QHideEvent',),
    "PySide2.QtWidgets.QAbstractSpinBox.initStyleOption": ('PySide2.QtWidgets.QStyleOptionSpinBox',),
    "PySide2.QtWidgets.QAbstractSpinBox.inputMethodQuery": ('PySide2.QtCore.Qt.InputMethodQuery',),
    "PySide2.QtWidgets.QAbstractSpinBox.interpretText": (),
    "PySide2.QtWidgets.QAbstractSpinBox.isAccelerated": (),
    "PySide2.QtWidgets.QAbstractSpinBox.isGroupSeparatorShown": (),
    "PySide2.QtWidgets.QAbstractSpinBox.isReadOnly": (),
    "PySide2.QtWidgets.QAbstractSpinBox.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QAbstractSpinBox.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QAbstractSpinBox.keyboardTracking": (),
    "PySide2.QtWidgets.QAbstractSpinBox.lineEdit": (),
    "PySide2.QtWidgets.QAbstractSpinBox.minimumSizeHint": (),
    "PySide2.QtWidgets.QAbstractSpinBox.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QAbstractSpinBox.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QAbstractSpinBox.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QAbstractSpinBox.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QAbstractSpinBox.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QAbstractSpinBox.selectAll": (),
    "PySide2.QtWidgets.QAbstractSpinBox.setAccelerated": ('bool',),
    "PySide2.QtWidgets.QAbstractSpinBox.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtWidgets.QAbstractSpinBox.setButtonSymbols": ('PySide2.QtWidgets.QAbstractSpinBox.ButtonSymbols',),
    "PySide2.QtWidgets.QAbstractSpinBox.setCorrectionMode": ('PySide2.QtWidgets.QAbstractSpinBox.CorrectionMode',),
    "PySide2.QtWidgets.QAbstractSpinBox.setFrame": ('bool',),
    "PySide2.QtWidgets.QAbstractSpinBox.setGroupSeparatorShown": ('bool',),
    "PySide2.QtWidgets.QAbstractSpinBox.setKeyboardTracking": ('bool',),
    "PySide2.QtWidgets.QAbstractSpinBox.setLineEdit": ('PySide2.QtWidgets.QLineEdit',),
    "PySide2.QtWidgets.QAbstractSpinBox.setReadOnly": ('bool',),
    "PySide2.QtWidgets.QAbstractSpinBox.setSpecialValueText": ('str',),
    "PySide2.QtWidgets.QAbstractSpinBox.setWrapping": ('bool',),
    "PySide2.QtWidgets.QAbstractSpinBox.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QAbstractSpinBox.sizeHint": (),
    "PySide2.QtWidgets.QAbstractSpinBox.specialValueText": (),
    "PySide2.QtWidgets.QAbstractSpinBox.stepBy": ('int',),
    "PySide2.QtWidgets.QAbstractSpinBox.stepDown": (),
    "PySide2.QtWidgets.QAbstractSpinBox.stepEnabled": (),
    "PySide2.QtWidgets.QAbstractSpinBox.stepUp": (),
    "PySide2.QtWidgets.QAbstractSpinBox.text": (),
    "PySide2.QtWidgets.QAbstractSpinBox.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtWidgets.QAbstractSpinBox.validate": ('str', 'int'),
    "PySide2.QtWidgets.QAbstractSpinBox.wheelEvent": ('PySide2.QtGui.QWheelEvent',),
    "PySide2.QtWidgets.QAbstractSpinBox.wrapping": (),

# class PySide2.QtWidgets.QAccessibleWidget:
    "PySide2.QtWidgets.QAccessibleWidget.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtGui.QAccessible.Role', 'str'),
    "PySide2.QtWidgets.QAccessibleWidget.actionNames": (),
    "PySide2.QtWidgets.QAccessibleWidget.addControllingSignal": ('str',),
    "PySide2.QtWidgets.QAccessibleWidget.backgroundColor": (),
    "PySide2.QtWidgets.QAccessibleWidget.child": ('int',),
    "PySide2.QtWidgets.QAccessibleWidget.childCount": (),
    "PySide2.QtWidgets.QAccessibleWidget.doAction": ('str',),
    "PySide2.QtWidgets.QAccessibleWidget.focusChild": (),
    "PySide2.QtWidgets.QAccessibleWidget.foregroundColor": (),
    "PySide2.QtWidgets.QAccessibleWidget.indexOfChild": ('PySide2.QtGui.QAccessibleInterface',),
    "PySide2.QtWidgets.QAccessibleWidget.interface_cast": ('PySide2.QtGui.QAccessible.InterfaceType',),
    "PySide2.QtWidgets.QAccessibleWidget.isValid": (),
    "PySide2.QtWidgets.QAccessibleWidget.keyBindingsForAction": ('str',),
    "PySide2.QtWidgets.QAccessibleWidget.parent": (),
    "PySide2.QtWidgets.QAccessibleWidget.parentObject": (),
    "PySide2.QtWidgets.QAccessibleWidget.rect": (),
    "PySide2.QtWidgets.QAccessibleWidget.relations": ('PySide2.QtGui.QAccessible.Relation',),
    "PySide2.QtWidgets.QAccessibleWidget.role": (),
    "PySide2.QtWidgets.QAccessibleWidget.state": (),
    "PySide2.QtWidgets.QAccessibleWidget.text": ('PySide2.QtGui.QAccessible.Text',),
    "PySide2.QtWidgets.QAccessibleWidget.widget": (),
    "PySide2.QtWidgets.QAccessibleWidget.window": (),

# class PySide2.QtWidgets.QAction:

# class PySide2.QtWidgets.QAction.ActionEvent:

# class PySide2.QtWidgets.QAction.MenuRole:

# class PySide2.QtWidgets.QAction.Priority:
    "PySide2.QtWidgets.QAction.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtGui.QIcon', 'str', 'PySide2.QtCore.QObject'), ('str', 'PySide2.QtCore.QObject')],
    "PySide2.QtWidgets.QAction.actionGroup": (),
    "PySide2.QtWidgets.QAction.activate": ('PySide2.QtWidgets.QAction.ActionEvent',),
    "PySide2.QtWidgets.QAction.associatedGraphicsWidgets": (),
    "PySide2.QtWidgets.QAction.associatedWidgets": (),
    "PySide2.QtWidgets.QAction.autoRepeat": (),
    "PySide2.QtWidgets.QAction.data": (),
    "PySide2.QtWidgets.QAction.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QAction.font": (),
    "PySide2.QtWidgets.QAction.hover": (),
    "PySide2.QtWidgets.QAction.icon": (),
    "PySide2.QtWidgets.QAction.iconText": (),
    "PySide2.QtWidgets.QAction.isCheckable": (),
    "PySide2.QtWidgets.QAction.isChecked": (),
    "PySide2.QtWidgets.QAction.isEnabled": (),
    "PySide2.QtWidgets.QAction.isIconVisibleInMenu": (),
    "PySide2.QtWidgets.QAction.isSeparator": (),
    "PySide2.QtWidgets.QAction.isShortcutVisibleInContextMenu": (),
    "PySide2.QtWidgets.QAction.isVisible": (),
    "PySide2.QtWidgets.QAction.menu": (),
    "PySide2.QtWidgets.QAction.menuRole": (),
    "PySide2.QtWidgets.QAction.parentWidget": (),
    "PySide2.QtWidgets.QAction.priority": (),
    "PySide2.QtWidgets.QAction.setActionGroup": ('PySide2.QtWidgets.QActionGroup',),
    "PySide2.QtWidgets.QAction.setAutoRepeat": ('bool',),
    "PySide2.QtWidgets.QAction.setCheckable": ('bool',),
    "PySide2.QtWidgets.QAction.setChecked": ('bool',),
    "PySide2.QtWidgets.QAction.setData": ('typing.Any',),
    "PySide2.QtWidgets.QAction.setDisabled": ('bool',),
    "PySide2.QtWidgets.QAction.setEnabled": ('bool',),
    "PySide2.QtWidgets.QAction.setFont": ('PySide2.QtGui.QFont',),
    "PySide2.QtWidgets.QAction.setIcon": ('PySide2.QtGui.QIcon',),
    "PySide2.QtWidgets.QAction.setIconText": ('str',),
    "PySide2.QtWidgets.QAction.setIconVisibleInMenu": ('bool',),
    "PySide2.QtWidgets.QAction.setMenu": ('PySide2.QtWidgets.QMenu',),
    "PySide2.QtWidgets.QAction.setMenuRole": ('PySide2.QtWidgets.QAction.MenuRole',),
    "PySide2.QtWidgets.QAction.setPriority": ('PySide2.QtWidgets.QAction.Priority',),
    "PySide2.QtWidgets.QAction.setSeparator": ('bool',),
    "PySide2.QtWidgets.QAction.setShortcut": ('PySide2.QtGui.QKeySequence',),
    "PySide2.QtWidgets.QAction.setShortcutContext": ('PySide2.QtCore.Qt.ShortcutContext',),
    "PySide2.QtWidgets.QAction.setShortcutVisibleInContextMenu": ('bool',),
    "PySide2.QtWidgets.QAction.setShortcuts": [('PySide2.QtGui.QKeySequence.StandardKey',), ('typing.Sequence',)],
    "PySide2.QtWidgets.QAction.setStatusTip": ('str',),
    "PySide2.QtWidgets.QAction.setText": ('str',),
    "PySide2.QtWidgets.QAction.setToolTip": ('str',),
    "PySide2.QtWidgets.QAction.setVisible": ('bool',),
    "PySide2.QtWidgets.QAction.setWhatsThis": ('str',),
    "PySide2.QtWidgets.QAction.shortcut": (),
    "PySide2.QtWidgets.QAction.shortcutContext": (),
    "PySide2.QtWidgets.QAction.shortcuts": (),
    "PySide2.QtWidgets.QAction.showStatusText": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QAction.statusTip": (),
    "PySide2.QtWidgets.QAction.text": (),
    "PySide2.QtWidgets.QAction.toggle": (),
    "PySide2.QtWidgets.QAction.toolTip": (),
    "PySide2.QtWidgets.QAction.trigger": (),
    "PySide2.QtWidgets.QAction.whatsThis": (),

# class PySide2.QtWidgets.QActionGroup:

# class PySide2.QtWidgets.QActionGroup.ExclusionPolicy:
    "PySide2.QtWidgets.QActionGroup.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QActionGroup.actions": (),
    "PySide2.QtWidgets.QActionGroup.addAction": [('PySide2.QtGui.QIcon', 'str'), ('PySide2.QtWidgets.QAction',), ('str',)],
    "PySide2.QtWidgets.QActionGroup.checkedAction": (),
    "PySide2.QtWidgets.QActionGroup.exclusionPolicy": (),
    "PySide2.QtWidgets.QActionGroup.isEnabled": (),
    "PySide2.QtWidgets.QActionGroup.isExclusive": (),
    "PySide2.QtWidgets.QActionGroup.isVisible": (),
    "PySide2.QtWidgets.QActionGroup.removeAction": ('PySide2.QtWidgets.QAction',),
    "PySide2.QtWidgets.QActionGroup.setDisabled": ('bool',),
    "PySide2.QtWidgets.QActionGroup.setEnabled": ('bool',),
    "PySide2.QtWidgets.QActionGroup.setExclusionPolicy": ('PySide2.QtWidgets.QActionGroup.ExclusionPolicy',),
    "PySide2.QtWidgets.QActionGroup.setExclusive": ('bool',),
    "PySide2.QtWidgets.QActionGroup.setVisible": ('bool',),

# class PySide2.QtWidgets.QApplication:

# class PySide2.QtWidgets.QApplication.ColorSpec:
    "PySide2.QtWidgets.QApplication.__init__": [(), ('typing.Sequence',)],
    "PySide2.QtWidgets.QApplication.aboutQt": (),
    "PySide2.QtWidgets.QApplication.activeModalWidget": (),
    "PySide2.QtWidgets.QApplication.activePopupWidget": (),
    "PySide2.QtWidgets.QApplication.activeWindow": (),
    "PySide2.QtWidgets.QApplication.alert": ('PySide2.QtWidgets.QWidget', 'int'),
    "PySide2.QtWidgets.QApplication.allWidgets": (),
    "PySide2.QtWidgets.QApplication.autoSipEnabled": (),
    "PySide2.QtWidgets.QApplication.beep": (),
    "PySide2.QtWidgets.QApplication.closeAllWindows": (),
    "PySide2.QtWidgets.QApplication.colorSpec": (),
    "PySide2.QtWidgets.QApplication.cursorFlashTime": (),
    "PySide2.QtWidgets.QApplication.desktop": (),
    "PySide2.QtWidgets.QApplication.doubleClickInterval": (),
    "PySide2.QtWidgets.QApplication.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QApplication.exec_": (),
    "PySide2.QtWidgets.QApplication.focusWidget": (),
    "PySide2.QtWidgets.QApplication.font": [(), ('PySide2.QtWidgets.QWidget',), ('bytes',)],
    "PySide2.QtWidgets.QApplication.fontMetrics": (),
    "PySide2.QtWidgets.QApplication.globalStrut": (),
    "PySide2.QtWidgets.QApplication.isEffectEnabled": ('PySide2.QtCore.Qt.UIEffect',),
    "PySide2.QtWidgets.QApplication.keyboardInputInterval": (),
    "PySide2.QtWidgets.QApplication.notify": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QApplication.palette": [(), ('PySide2.QtWidgets.QWidget',), ('bytes',)],
    "PySide2.QtWidgets.QApplication.setActiveWindow": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QApplication.setAutoSipEnabled": ('bool',),
    "PySide2.QtWidgets.QApplication.setColorSpec": ('int',),
    "PySide2.QtWidgets.QApplication.setCursorFlashTime": ('int',),
    "PySide2.QtWidgets.QApplication.setDoubleClickInterval": ('int',),
    "PySide2.QtWidgets.QApplication.setEffectEnabled": ('PySide2.QtCore.Qt.UIEffect', 'bool'),
    "PySide2.QtWidgets.QApplication.setFont": [('PySide2.QtGui.QFont',), ('PySide2.QtGui.QFont', 'bytes')],
    "PySide2.QtWidgets.QApplication.setGlobalStrut": ('PySide2.QtCore.QSize',),
    "PySide2.QtWidgets.QApplication.setKeyboardInputInterval": ('int',),
    "PySide2.QtWidgets.QApplication.setPalette": [('PySide2.QtGui.QPalette',), ('PySide2.QtGui.QPalette', 'bytes')],
    "PySide2.QtWidgets.QApplication.setStartDragDistance": ('int',),
    "PySide2.QtWidgets.QApplication.setStartDragTime": ('int',),
    "PySide2.QtWidgets.QApplication.setStyle": [('PySide2.QtWidgets.QStyle',), ('str',)],
    "PySide2.QtWidgets.QApplication.setStyleSheet": ('str',),
    "PySide2.QtWidgets.QApplication.setWheelScrollLines": ('int',),
    "PySide2.QtWidgets.QApplication.setWindowIcon": ('PySide2.QtGui.QIcon',),
    "PySide2.QtWidgets.QApplication.startDragDistance": (),
    "PySide2.QtWidgets.QApplication.startDragTime": (),
    "PySide2.QtWidgets.QApplication.style": (),
    "PySide2.QtWidgets.QApplication.styleSheet": (),
    "PySide2.QtWidgets.QApplication.topLevelAt": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtWidgets.QApplication.topLevelWidgets": (),
    "PySide2.QtWidgets.QApplication.wheelScrollLines": (),
    "PySide2.QtWidgets.QApplication.widgetAt": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtWidgets.QApplication.windowIcon": (),

# class PySide2.QtWidgets.QBoxLayout:

# class PySide2.QtWidgets.QBoxLayout.Direction:
    "PySide2.QtWidgets.QBoxLayout.__init__": ('PySide2.QtWidgets.QBoxLayout.Direction', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QBoxLayout.addItem": ('PySide2.QtWidgets.QLayoutItem',),
    "PySide2.QtWidgets.QBoxLayout.addLayout": ('PySide2.QtWidgets.QLayout', 'int'),
    "PySide2.QtWidgets.QBoxLayout.addSpacerItem": ('PySide2.QtWidgets.QSpacerItem',),
    "PySide2.QtWidgets.QBoxLayout.addSpacing": ('int',),
    "PySide2.QtWidgets.QBoxLayout.addStretch": ('int',),
    "PySide2.QtWidgets.QBoxLayout.addStrut": ('int',),
    "PySide2.QtWidgets.QBoxLayout.addWidget": [('PySide2.QtWidgets.QWidget',), ('PySide2.QtWidgets.QWidget', 'int', 'PySide2.QtCore.Qt.Alignment')],
    "PySide2.QtWidgets.QBoxLayout.count": (),
    "PySide2.QtWidgets.QBoxLayout.direction": (),
    "PySide2.QtWidgets.QBoxLayout.expandingDirections": (),
    "PySide2.QtWidgets.QBoxLayout.hasHeightForWidth": (),
    "PySide2.QtWidgets.QBoxLayout.heightForWidth": ('int',),
    "PySide2.QtWidgets.QBoxLayout.insertItem": ('int', 'PySide2.QtWidgets.QLayoutItem'),
    "PySide2.QtWidgets.QBoxLayout.insertLayout": ('int', 'PySide2.QtWidgets.QLayout', 'int'),
    "PySide2.QtWidgets.QBoxLayout.insertSpacerItem": ('int', 'PySide2.QtWidgets.QSpacerItem'),
    "PySide2.QtWidgets.QBoxLayout.insertSpacing": ('int', 'int'),
    "PySide2.QtWidgets.QBoxLayout.insertStretch": ('int', 'int'),
    "PySide2.QtWidgets.QBoxLayout.insertWidget": ('int', 'PySide2.QtWidgets.QWidget', 'int', 'PySide2.QtCore.Qt.Alignment'),
    "PySide2.QtWidgets.QBoxLayout.invalidate": (),
    "PySide2.QtWidgets.QBoxLayout.itemAt": ('int',),
    "PySide2.QtWidgets.QBoxLayout.maximumSize": (),
    "PySide2.QtWidgets.QBoxLayout.minimumHeightForWidth": ('int',),
    "PySide2.QtWidgets.QBoxLayout.minimumSize": (),
    "PySide2.QtWidgets.QBoxLayout.setDirection": ('PySide2.QtWidgets.QBoxLayout.Direction',),
    "PySide2.QtWidgets.QBoxLayout.setGeometry": ('PySide2.QtCore.QRect',),
    "PySide2.QtWidgets.QBoxLayout.setSpacing": ('int',),
    "PySide2.QtWidgets.QBoxLayout.setStretch": ('int', 'int'),
    "PySide2.QtWidgets.QBoxLayout.setStretchFactor": [('PySide2.QtWidgets.QLayout', 'int'), ('PySide2.QtWidgets.QWidget', 'int')],
    "PySide2.QtWidgets.QBoxLayout.sizeHint": (),
    "PySide2.QtWidgets.QBoxLayout.spacing": (),
    "PySide2.QtWidgets.QBoxLayout.stretch": ('int',),
    "PySide2.QtWidgets.QBoxLayout.takeAt": ('int',),

# class PySide2.QtWidgets.QButtonGroup:
    "PySide2.QtWidgets.QButtonGroup.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QButtonGroup.addButton": ('PySide2.QtWidgets.QAbstractButton', 'int'),
    "PySide2.QtWidgets.QButtonGroup.button": ('int',),
    "PySide2.QtWidgets.QButtonGroup.buttons": (),
    "PySide2.QtWidgets.QButtonGroup.checkedButton": (),
    "PySide2.QtWidgets.QButtonGroup.checkedId": (),
    "PySide2.QtWidgets.QButtonGroup.exclusive": (),
    "PySide2.QtWidgets.QButtonGroup.id": ('PySide2.QtWidgets.QAbstractButton',),
    "PySide2.QtWidgets.QButtonGroup.removeButton": ('PySide2.QtWidgets.QAbstractButton',),
    "PySide2.QtWidgets.QButtonGroup.setExclusive": ('bool',),
    "PySide2.QtWidgets.QButtonGroup.setId": ('PySide2.QtWidgets.QAbstractButton', 'int'),

# class PySide2.QtWidgets.QCalendarWidget:

# class PySide2.QtWidgets.QCalendarWidget.HorizontalHeaderFormat:

# class PySide2.QtWidgets.QCalendarWidget.SelectionMode:

# class PySide2.QtWidgets.QCalendarWidget.VerticalHeaderFormat:
    "PySide2.QtWidgets.QCalendarWidget.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QCalendarWidget.calendar": (),
    "PySide2.QtWidgets.QCalendarWidget.dateEditAcceptDelay": (),
    "PySide2.QtWidgets.QCalendarWidget.dateTextFormat": [(), ('PySide2.QtCore.QDate',)],
    "PySide2.QtWidgets.QCalendarWidget.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QCalendarWidget.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QCalendarWidget.firstDayOfWeek": (),
    "PySide2.QtWidgets.QCalendarWidget.headerTextFormat": (),
    "PySide2.QtWidgets.QCalendarWidget.horizontalHeaderFormat": (),
    "PySide2.QtWidgets.QCalendarWidget.isDateEditEnabled": (),
    "PySide2.QtWidgets.QCalendarWidget.isGridVisible": (),
    "PySide2.QtWidgets.QCalendarWidget.isNavigationBarVisible": (),
    "PySide2.QtWidgets.QCalendarWidget.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QCalendarWidget.maximumDate": (),
    "PySide2.QtWidgets.QCalendarWidget.minimumDate": (),
    "PySide2.QtWidgets.QCalendarWidget.minimumSizeHint": (),
    "PySide2.QtWidgets.QCalendarWidget.monthShown": (),
    "PySide2.QtWidgets.QCalendarWidget.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QCalendarWidget.paintCell": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'PySide2.QtCore.QDate'),
    "PySide2.QtWidgets.QCalendarWidget.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QCalendarWidget.selectedDate": (),
    "PySide2.QtWidgets.QCalendarWidget.selectionMode": (),
    "PySide2.QtWidgets.QCalendarWidget.setCalendar": ('PySide2.QtCore.QCalendar',),
    "PySide2.QtWidgets.QCalendarWidget.setCurrentPage": ('int', 'int'),
    "PySide2.QtWidgets.QCalendarWidget.setDateEditAcceptDelay": ('int',),
    "PySide2.QtWidgets.QCalendarWidget.setDateEditEnabled": ('bool',),
    "PySide2.QtWidgets.QCalendarWidget.setDateRange": ('PySide2.QtCore.QDate', 'PySide2.QtCore.QDate'),
    "PySide2.QtWidgets.QCalendarWidget.setDateTextFormat": ('PySide2.QtCore.QDate', 'PySide2.QtGui.QTextCharFormat'),
    "PySide2.QtWidgets.QCalendarWidget.setFirstDayOfWeek": ('PySide2.QtCore.Qt.DayOfWeek',),
    "PySide2.QtWidgets.QCalendarWidget.setGridVisible": ('bool',),
    "PySide2.QtWidgets.QCalendarWidget.setHeaderTextFormat": ('PySide2.QtGui.QTextCharFormat',),
    "PySide2.QtWidgets.QCalendarWidget.setHorizontalHeaderFormat": ('PySide2.QtWidgets.QCalendarWidget.HorizontalHeaderFormat',),
    "PySide2.QtWidgets.QCalendarWidget.setMaximumDate": ('PySide2.QtCore.QDate',),
    "PySide2.QtWidgets.QCalendarWidget.setMinimumDate": ('PySide2.QtCore.QDate',),
    "PySide2.QtWidgets.QCalendarWidget.setNavigationBarVisible": ('bool',),
    "PySide2.QtWidgets.QCalendarWidget.setSelectedDate": ('PySide2.QtCore.QDate',),
    "PySide2.QtWidgets.QCalendarWidget.setSelectionMode": ('PySide2.QtWidgets.QCalendarWidget.SelectionMode',),
    "PySide2.QtWidgets.QCalendarWidget.setVerticalHeaderFormat": ('PySide2.QtWidgets.QCalendarWidget.VerticalHeaderFormat',),
    "PySide2.QtWidgets.QCalendarWidget.setWeekdayTextFormat": ('PySide2.QtCore.Qt.DayOfWeek', 'PySide2.QtGui.QTextCharFormat'),
    "PySide2.QtWidgets.QCalendarWidget.showNextMonth": (),
    "PySide2.QtWidgets.QCalendarWidget.showNextYear": (),
    "PySide2.QtWidgets.QCalendarWidget.showPreviousMonth": (),
    "PySide2.QtWidgets.QCalendarWidget.showPreviousYear": (),
    "PySide2.QtWidgets.QCalendarWidget.showSelectedDate": (),
    "PySide2.QtWidgets.QCalendarWidget.showToday": (),
    "PySide2.QtWidgets.QCalendarWidget.sizeHint": (),
    "PySide2.QtWidgets.QCalendarWidget.updateCell": ('PySide2.QtCore.QDate',),
    "PySide2.QtWidgets.QCalendarWidget.updateCells": (),
    "PySide2.QtWidgets.QCalendarWidget.verticalHeaderFormat": (),
    "PySide2.QtWidgets.QCalendarWidget.weekdayTextFormat": ('PySide2.QtCore.Qt.DayOfWeek',),
    "PySide2.QtWidgets.QCalendarWidget.yearShown": (),

# class PySide2.QtWidgets.QCheckBox:
    "PySide2.QtWidgets.QCheckBox.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
    "PySide2.QtWidgets.QCheckBox.checkState": (),
    "PySide2.QtWidgets.QCheckBox.checkStateSet": (),
    "PySide2.QtWidgets.QCheckBox.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QCheckBox.hitButton": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QCheckBox.initStyleOption": ('PySide2.QtWidgets.QStyleOptionButton',),
    "PySide2.QtWidgets.QCheckBox.isTristate": (),
    "PySide2.QtWidgets.QCheckBox.minimumSizeHint": (),
    "PySide2.QtWidgets.QCheckBox.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QCheckBox.nextCheckState": (),
    "PySide2.QtWidgets.QCheckBox.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QCheckBox.setCheckState": ('PySide2.QtCore.Qt.CheckState',),
    "PySide2.QtWidgets.QCheckBox.setTristate": ('bool',),
    "PySide2.QtWidgets.QCheckBox.sizeHint": (),

# class PySide2.QtWidgets.QColorDialog:

# class PySide2.QtWidgets.QColorDialog.ColorDialogOption:

# class PySide2.QtWidgets.QColorDialog.ColorDialogOptions:
    "PySide2.QtWidgets.QColorDialog.__init__": [('PySide2.QtGui.QColor', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QColorDialog.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QColorDialog.currentColor": (),
    "PySide2.QtWidgets.QColorDialog.customColor": ('int',),
    "PySide2.QtWidgets.QColorDialog.customCount": (),
    "PySide2.QtWidgets.QColorDialog.done": ('int',),
    "PySide2.QtWidgets.QColorDialog.getColor": ('PySide2.QtGui.QColor', 'PySide2.QtWidgets.QWidget', 'str', 'PySide2.QtWidgets.QColorDialog.ColorDialogOptions'),
    "PySide2.QtWidgets.QColorDialog.open": [(), ('PySide2.QtCore.QObject', 'bytes')],
    "PySide2.QtWidgets.QColorDialog.options": (),
    "PySide2.QtWidgets.QColorDialog.selectedColor": (),
    "PySide2.QtWidgets.QColorDialog.setCurrentColor": ('PySide2.QtGui.QColor',),
    "PySide2.QtWidgets.QColorDialog.setCustomColor": ('int', 'PySide2.QtGui.QColor'),
    "PySide2.QtWidgets.QColorDialog.setOption": ('PySide2.QtWidgets.QColorDialog.ColorDialogOption', 'bool'),
    "PySide2.QtWidgets.QColorDialog.setOptions": ('PySide2.QtWidgets.QColorDialog.ColorDialogOptions',),
    "PySide2.QtWidgets.QColorDialog.setStandardColor": ('int', 'PySide2.QtGui.QColor'),
    "PySide2.QtWidgets.QColorDialog.setVisible": ('bool',),
    "PySide2.QtWidgets.QColorDialog.standardColor": ('int',),
    "PySide2.QtWidgets.QColorDialog.testOption": ('PySide2.QtWidgets.QColorDialog.ColorDialogOption',),

# class PySide2.QtWidgets.QColormap:

# class PySide2.QtWidgets.QColormap.Mode:
    "PySide2.QtWidgets.QColormap.__init__": ('PySide2.QtWidgets.QColormap',),
    "PySide2.QtWidgets.QColormap.__copy__": (),
    "PySide2.QtWidgets.QColormap.cleanup": (),
    "PySide2.QtWidgets.QColormap.colorAt": ('int',),
    "PySide2.QtWidgets.QColormap.colormap": (),
    "PySide2.QtWidgets.QColormap.depth": (),
    "PySide2.QtWidgets.QColormap.initialize": (),
    "PySide2.QtWidgets.QColormap.instance": ('int',),
    "PySide2.QtWidgets.QColormap.mode": (),
    "PySide2.QtWidgets.QColormap.pixel": ('PySide2.QtGui.QColor',),
    "PySide2.QtWidgets.QColormap.size": (),

# class PySide2.QtWidgets.QColumnView:
    "PySide2.QtWidgets.QColumnView.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QColumnView.columnWidths": (),
    "PySide2.QtWidgets.QColumnView.createColumn": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QColumnView.currentChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QColumnView.horizontalOffset": (),
    "PySide2.QtWidgets.QColumnView.indexAt": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QColumnView.initializeColumn": ('PySide2.QtWidgets.QAbstractItemView',),
    "PySide2.QtWidgets.QColumnView.isIndexHidden": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QColumnView.moveCursor": ('PySide2.QtWidgets.QAbstractItemView.CursorAction', 'PySide2.QtCore.Qt.KeyboardModifiers'),
    "PySide2.QtWidgets.QColumnView.previewWidget": (),
    "PySide2.QtWidgets.QColumnView.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QColumnView.resizeGripsVisible": (),
    "PySide2.QtWidgets.QColumnView.rowsInserted": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtWidgets.QColumnView.scrollContentsBy": ('int', 'int'),
    "PySide2.QtWidgets.QColumnView.scrollTo": ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
    "PySide2.QtWidgets.QColumnView.selectAll": (),
    "PySide2.QtWidgets.QColumnView.setColumnWidths": ('typing.Sequence',),
    "PySide2.QtWidgets.QColumnView.setModel": ('PySide2.QtCore.QAbstractItemModel',),
    "PySide2.QtWidgets.QColumnView.setPreviewWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QColumnView.setResizeGripsVisible": ('bool',),
    "PySide2.QtWidgets.QColumnView.setRootIndex": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QColumnView.setSelection": ('PySide2.QtCore.QRect', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'),
    "PySide2.QtWidgets.QColumnView.setSelectionModel": ('PySide2.QtCore.QItemSelectionModel',),
    "PySide2.QtWidgets.QColumnView.sizeHint": (),
    "PySide2.QtWidgets.QColumnView.verticalOffset": (),
    "PySide2.QtWidgets.QColumnView.visualRect": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QColumnView.visualRegionForSelection": ('PySide2.QtCore.QItemSelection',),

# class PySide2.QtWidgets.QComboBox:

# class PySide2.QtWidgets.QComboBox.InsertPolicy:

# class PySide2.QtWidgets.QComboBox.SizeAdjustPolicy:
    "PySide2.QtWidgets.QComboBox.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QComboBox.addItem": [('PySide2.QtGui.QIcon', 'str', 'typing.Any'), ('str', 'typing.Any')],
    "PySide2.QtWidgets.QComboBox.addItems": ('typing.Sequence',),
    "PySide2.QtWidgets.QComboBox.autoCompletion": (),
    "PySide2.QtWidgets.QComboBox.autoCompletionCaseSensitivity": (),
    "PySide2.QtWidgets.QComboBox.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QComboBox.clear": (),
    "PySide2.QtWidgets.QComboBox.clearEditText": (),
    "PySide2.QtWidgets.QComboBox.completer": (),
    "PySide2.QtWidgets.QComboBox.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
    "PySide2.QtWidgets.QComboBox.count": (),
    "PySide2.QtWidgets.QComboBox.currentData": ('int',),
    "PySide2.QtWidgets.QComboBox.currentIndex": (),
    "PySide2.QtWidgets.QComboBox.currentText": (),
    "PySide2.QtWidgets.QComboBox.duplicatesEnabled": (),
    "PySide2.QtWidgets.QComboBox.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QComboBox.findData": ('typing.Any', 'int', 'PySide2.QtCore.Qt.MatchFlags'),
    "PySide2.QtWidgets.QComboBox.findText": ('str', 'PySide2.QtCore.Qt.MatchFlags'),
    "PySide2.QtWidgets.QComboBox.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QComboBox.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QComboBox.hasFrame": (),
    "PySide2.QtWidgets.QComboBox.hideEvent": ('PySide2.QtGui.QHideEvent',),
    "PySide2.QtWidgets.QComboBox.hidePopup": (),
    "PySide2.QtWidgets.QComboBox.iconSize": (),
    "PySide2.QtWidgets.QComboBox.initStyleOption": ('PySide2.QtWidgets.QStyleOptionComboBox',),
    "PySide2.QtWidgets.QComboBox.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
    "PySide2.QtWidgets.QComboBox.inputMethodQuery": [('PySide2.QtCore.Qt.InputMethodQuery',), ('PySide2.QtCore.Qt.InputMethodQuery', 'typing.Any')],
    "PySide2.QtWidgets.QComboBox.insertItem": [('int', 'PySide2.QtGui.QIcon', 'str', 'typing.Any'), ('int', 'str', 'typing.Any')],
    "PySide2.QtWidgets.QComboBox.insertItems": ('int', 'typing.Sequence'),
    "PySide2.QtWidgets.QComboBox.insertPolicy": (),
    "PySide2.QtWidgets.QComboBox.insertSeparator": ('int',),
    "PySide2.QtWidgets.QComboBox.isEditable": (),
    "PySide2.QtWidgets.QComboBox.itemData": ('int', 'int'),
    "PySide2.QtWidgets.QComboBox.itemDelegate": (),
    "PySide2.QtWidgets.QComboBox.itemIcon": ('int',),
    "PySide2.QtWidgets.QComboBox.itemText": ('int',),
    "PySide2.QtWidgets.QComboBox.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QComboBox.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QComboBox.lineEdit": (),
    "PySide2.QtWidgets.QComboBox.maxCount": (),
    "PySide2.QtWidgets.QComboBox.maxVisibleItems": (),
    "PySide2.QtWidgets.QComboBox.minimumContentsLength": (),
    "PySide2.QtWidgets.QComboBox.minimumSizeHint": (),
    "PySide2.QtWidgets.QComboBox.model": (),
    "PySide2.QtWidgets.QComboBox.modelColumn": (),
    "PySide2.QtWidgets.QComboBox.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QComboBox.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QComboBox.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QComboBox.removeItem": ('int',),
    "PySide2.QtWidgets.QComboBox.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QComboBox.rootModelIndex": (),
    "PySide2.QtWidgets.QComboBox.setAutoCompletion": ('bool',),
    "PySide2.QtWidgets.QComboBox.setAutoCompletionCaseSensitivity": ('PySide2.QtCore.Qt.CaseSensitivity',),
    "PySide2.QtWidgets.QComboBox.setCompleter": ('PySide2.QtWidgets.QCompleter',),
    "PySide2.QtWidgets.QComboBox.setCurrentIndex": ('int',),
    "PySide2.QtWidgets.QComboBox.setCurrentText": ('str',),
    "PySide2.QtWidgets.QComboBox.setDuplicatesEnabled": ('bool',),
    "PySide2.QtWidgets.QComboBox.setEditText": ('str',),
    "PySide2.QtWidgets.QComboBox.setEditable": ('bool',),
    "PySide2.QtWidgets.QComboBox.setFrame": ('bool',),
    "PySide2.QtWidgets.QComboBox.setIconSize": ('PySide2.QtCore.QSize',),
    "PySide2.QtWidgets.QComboBox.setInsertPolicy": ('PySide2.QtWidgets.QComboBox.InsertPolicy',),
    "PySide2.QtWidgets.QComboBox.setItemData": ('int', 'typing.Any', 'int'),
    "PySide2.QtWidgets.QComboBox.setItemDelegate": ('PySide2.QtWidgets.QAbstractItemDelegate',),
    "PySide2.QtWidgets.QComboBox.setItemIcon": ('int', 'PySide2.QtGui.QIcon'),
    "PySide2.QtWidgets.QComboBox.setItemText": ('int', 'str'),
    "PySide2.QtWidgets.QComboBox.setLineEdit": ('PySide2.QtWidgets.QLineEdit',),
    "PySide2.QtWidgets.QComboBox.setMaxCount": ('int',),
    "PySide2.QtWidgets.QComboBox.setMaxVisibleItems": ('int',),
    "PySide2.QtWidgets.QComboBox.setMinimumContentsLength": ('int',),
    "PySide2.QtWidgets.QComboBox.setModel": ('PySide2.QtCore.QAbstractItemModel',),
    "PySide2.QtWidgets.QComboBox.setModelColumn": ('int',),
    "PySide2.QtWidgets.QComboBox.setRootModelIndex": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QComboBox.setSizeAdjustPolicy": ('PySide2.QtWidgets.QComboBox.SizeAdjustPolicy',),
    "PySide2.QtWidgets.QComboBox.setValidator": ('PySide2.QtGui.QValidator',),
    "PySide2.QtWidgets.QComboBox.setView": ('PySide2.QtWidgets.QAbstractItemView',),
    "PySide2.QtWidgets.QComboBox.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QComboBox.showPopup": (),
    "PySide2.QtWidgets.QComboBox.sizeAdjustPolicy": (),
    "PySide2.QtWidgets.QComboBox.sizeHint": (),
    "PySide2.QtWidgets.QComboBox.validator": (),
    "PySide2.QtWidgets.QComboBox.view": (),
    "PySide2.QtWidgets.QComboBox.wheelEvent": ('PySide2.QtGui.QWheelEvent',),

# class PySide2.QtWidgets.QCommandLinkButton:
    "PySide2.QtWidgets.QCommandLinkButton.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget'), ('str', 'str', 'PySide2.QtWidgets.QWidget')],
    "PySide2.QtWidgets.QCommandLinkButton.description": (),
    "PySide2.QtWidgets.QCommandLinkButton.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QCommandLinkButton.heightForWidth": ('int',),
    "PySide2.QtWidgets.QCommandLinkButton.minimumSizeHint": (),
    "PySide2.QtWidgets.QCommandLinkButton.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QCommandLinkButton.setDescription": ('str',),
    "PySide2.QtWidgets.QCommandLinkButton.sizeHint": (),

# class PySide2.QtWidgets.QCommonStyle:
    "PySide2.QtWidgets.QCommonStyle.__init__": (),
    "PySide2.QtWidgets.QCommonStyle.drawComplexControl": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QCommonStyle.drawControl": ('PySide2.QtWidgets.QStyle.ControlElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QCommonStyle.drawPrimitive": ('PySide2.QtWidgets.QStyle.PrimitiveElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QCommonStyle.generatedIconPixmap": ('PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QPixmap', 'PySide2.QtWidgets.QStyleOption'),
    "PySide2.QtWidgets.QCommonStyle.hitTestComplexControl": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtCore.QPoint', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QCommonStyle.layoutSpacing": ('PySide2.QtWidgets.QSizePolicy.ControlType', 'PySide2.QtWidgets.QSizePolicy.ControlType', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QCommonStyle.pixelMetric": ('PySide2.QtWidgets.QStyle.PixelMetric', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QCommonStyle.polish": [('PySide2.QtGui.QPalette',), ('PySide2.QtWidgets.QApplication',), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QCommonStyle.sizeFromContents": ('PySide2.QtWidgets.QStyle.ContentsType', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtCore.QSize', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QCommonStyle.standardIcon": ('PySide2.QtWidgets.QStyle.StandardPixmap', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QCommonStyle.standardPixmap": ('PySide2.QtWidgets.QStyle.StandardPixmap', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QCommonStyle.styleHint": ('PySide2.QtWidgets.QStyle.StyleHint', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleHintReturn'),
    "PySide2.QtWidgets.QCommonStyle.subControlRect": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtWidgets.QStyle.SubControl', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QCommonStyle.subElementRect": ('PySide2.QtWidgets.QStyle.SubElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QCommonStyle.unpolish": [('PySide2.QtWidgets.QApplication',), ('PySide2.QtWidgets.QWidget',)],

# class PySide2.QtWidgets.QCompleter:

# class PySide2.QtWidgets.QCompleter.CompletionMode:

# class PySide2.QtWidgets.QCompleter.ModelSorting:
    "PySide2.QtWidgets.QCompleter.__init__": [('PySide2.QtCore.QAbstractItemModel', 'PySide2.QtCore.QObject'), ('PySide2.QtCore.QObject',), ('typing.Sequence', 'PySide2.QtCore.QObject')],
    "PySide2.QtWidgets.QCompleter.caseSensitivity": (),
    "PySide2.QtWidgets.QCompleter.complete": ('PySide2.QtCore.QRect',),
    "PySide2.QtWidgets.QCompleter.completionColumn": (),
    "PySide2.QtWidgets.QCompleter.completionCount": (),
    "PySide2.QtWidgets.QCompleter.completionMode": (),
    "PySide2.QtWidgets.QCompleter.completionModel": (),
    "PySide2.QtWidgets.QCompleter.completionPrefix": (),
    "PySide2.QtWidgets.QCompleter.completionRole": (),
    "PySide2.QtWidgets.QCompleter.currentCompletion": (),
    "PySide2.QtWidgets.QCompleter.currentIndex": (),
    "PySide2.QtWidgets.QCompleter.currentRow": (),
    "PySide2.QtWidgets.QCompleter.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QCompleter.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QCompleter.filterMode": (),
    "PySide2.QtWidgets.QCompleter.maxVisibleItems": (),
    "PySide2.QtWidgets.QCompleter.model": (),
    "PySide2.QtWidgets.QCompleter.modelSorting": (),
    "PySide2.QtWidgets.QCompleter.pathFromIndex": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QCompleter.popup": (),
    "PySide2.QtWidgets.QCompleter.setCaseSensitivity": ('PySide2.QtCore.Qt.CaseSensitivity',),
    "PySide2.QtWidgets.QCompleter.setCompletionColumn": ('int',),
    "PySide2.QtWidgets.QCompleter.setCompletionMode": ('PySide2.QtWidgets.QCompleter.CompletionMode',),
    "PySide2.QtWidgets.QCompleter.setCompletionPrefix": ('str',),
    "PySide2.QtWidgets.QCompleter.setCompletionRole": ('int',),
    "PySide2.QtWidgets.QCompleter.setCurrentRow": ('int',),
    "PySide2.QtWidgets.QCompleter.setFilterMode": ('PySide2.QtCore.Qt.MatchFlags',),
    "PySide2.QtWidgets.QCompleter.setMaxVisibleItems": ('int',),
    "PySide2.QtWidgets.QCompleter.setModel": ('PySide2.QtCore.QAbstractItemModel',),
    "PySide2.QtWidgets.QCompleter.setModelSorting": ('PySide2.QtWidgets.QCompleter.ModelSorting',),
    "PySide2.QtWidgets.QCompleter.setPopup": ('PySide2.QtWidgets.QAbstractItemView',),
    "PySide2.QtWidgets.QCompleter.setWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QCompleter.setWrapAround": ('bool',),
    "PySide2.QtWidgets.QCompleter.splitPath": ('str',),
    "PySide2.QtWidgets.QCompleter.widget": (),
    "PySide2.QtWidgets.QCompleter.wrapAround": (),

# class PySide2.QtWidgets.QDataWidgetMapper:

# class PySide2.QtWidgets.QDataWidgetMapper.SubmitPolicy:
    "PySide2.QtWidgets.QDataWidgetMapper.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QDataWidgetMapper.addMapping": [('PySide2.QtWidgets.QWidget', 'int'), ('PySide2.QtWidgets.QWidget', 'int', 'PySide2.QtCore.QByteArray')],
    "PySide2.QtWidgets.QDataWidgetMapper.clearMapping": (),
    "PySide2.QtWidgets.QDataWidgetMapper.currentIndex": (),
    "PySide2.QtWidgets.QDataWidgetMapper.itemDelegate": (),
    "PySide2.QtWidgets.QDataWidgetMapper.mappedPropertyName": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QDataWidgetMapper.mappedSection": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QDataWidgetMapper.mappedWidgetAt": ('int',),
    "PySide2.QtWidgets.QDataWidgetMapper.model": (),
    "PySide2.QtWidgets.QDataWidgetMapper.orientation": (),
    "PySide2.QtWidgets.QDataWidgetMapper.removeMapping": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QDataWidgetMapper.revert": (),
    "PySide2.QtWidgets.QDataWidgetMapper.rootIndex": (),
    "PySide2.QtWidgets.QDataWidgetMapper.setCurrentIndex": ('int',),
    "PySide2.QtWidgets.QDataWidgetMapper.setCurrentModelIndex": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QDataWidgetMapper.setItemDelegate": ('PySide2.QtWidgets.QAbstractItemDelegate',),
    "PySide2.QtWidgets.QDataWidgetMapper.setModel": ('PySide2.QtCore.QAbstractItemModel',),
    "PySide2.QtWidgets.QDataWidgetMapper.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
    "PySide2.QtWidgets.QDataWidgetMapper.setRootIndex": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QDataWidgetMapper.setSubmitPolicy": ('PySide2.QtWidgets.QDataWidgetMapper.SubmitPolicy',),
    "PySide2.QtWidgets.QDataWidgetMapper.submit": (),
    "PySide2.QtWidgets.QDataWidgetMapper.submitPolicy": (),
    "PySide2.QtWidgets.QDataWidgetMapper.toFirst": (),
    "PySide2.QtWidgets.QDataWidgetMapper.toLast": (),
    "PySide2.QtWidgets.QDataWidgetMapper.toNext": (),
    "PySide2.QtWidgets.QDataWidgetMapper.toPrevious": (),

# class PySide2.QtWidgets.QDateEdit:
    "PySide2.QtWidgets.QDateEdit.__init__": [('PySide2.QtCore.QDate', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],

# class PySide2.QtWidgets.QDateTimeEdit:

# class PySide2.QtWidgets.QDateTimeEdit.Section:

# class PySide2.QtWidgets.QDateTimeEdit.Sections:
    "PySide2.QtWidgets.QDateTimeEdit.__init__": [('PySide2.QtCore.QDate', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtCore.QDateTime', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtCore.QTime', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',), ('typing.Any', 'type', 'PySide2.QtWidgets.QWidget')],
    "PySide2.QtWidgets.QDateTimeEdit.calendar": (),
    "PySide2.QtWidgets.QDateTimeEdit.calendarPopup": (),
    "PySide2.QtWidgets.QDateTimeEdit.calendarWidget": (),
    "PySide2.QtWidgets.QDateTimeEdit.clear": (),
    "PySide2.QtWidgets.QDateTimeEdit.clearMaximumDate": (),
    "PySide2.QtWidgets.QDateTimeEdit.clearMaximumDateTime": (),
    "PySide2.QtWidgets.QDateTimeEdit.clearMaximumTime": (),
    "PySide2.QtWidgets.QDateTimeEdit.clearMinimumDate": (),
    "PySide2.QtWidgets.QDateTimeEdit.clearMinimumDateTime": (),
    "PySide2.QtWidgets.QDateTimeEdit.clearMinimumTime": (),
    "PySide2.QtWidgets.QDateTimeEdit.currentSection": (),
    "PySide2.QtWidgets.QDateTimeEdit.currentSectionIndex": (),
    "PySide2.QtWidgets.QDateTimeEdit.date": (),
    "PySide2.QtWidgets.QDateTimeEdit.dateTime": (),
    "PySide2.QtWidgets.QDateTimeEdit.dateTimeFromText": ('str',),
    "PySide2.QtWidgets.QDateTimeEdit.displayFormat": (),
    "PySide2.QtWidgets.QDateTimeEdit.displayedSections": (),
    "PySide2.QtWidgets.QDateTimeEdit.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QDateTimeEdit.fixup": ('str',),
    "PySide2.QtWidgets.QDateTimeEdit.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QDateTimeEdit.focusNextPrevChild": ('bool',),
    "PySide2.QtWidgets.QDateTimeEdit.initStyleOption": ('PySide2.QtWidgets.QStyleOptionSpinBox',),
    "PySide2.QtWidgets.QDateTimeEdit.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QDateTimeEdit.maximumDate": (),
    "PySide2.QtWidgets.QDateTimeEdit.maximumDateTime": (),
    "PySide2.QtWidgets.QDateTimeEdit.maximumTime": (),
    "PySide2.QtWidgets.QDateTimeEdit.minimumDate": (),
    "PySide2.QtWidgets.QDateTimeEdit.minimumDateTime": (),
    "PySide2.QtWidgets.QDateTimeEdit.minimumTime": (),
    "PySide2.QtWidgets.QDateTimeEdit.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QDateTimeEdit.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QDateTimeEdit.sectionAt": ('int',),
    "PySide2.QtWidgets.QDateTimeEdit.sectionCount": (),
    "PySide2.QtWidgets.QDateTimeEdit.sectionText": ('PySide2.QtWidgets.QDateTimeEdit.Section',),
    "PySide2.QtWidgets.QDateTimeEdit.setCalendar": ('PySide2.QtCore.QCalendar',),
    "PySide2.QtWidgets.QDateTimeEdit.setCalendarPopup": ('bool',),
    "PySide2.QtWidgets.QDateTimeEdit.setCalendarWidget": ('PySide2.QtWidgets.QCalendarWidget',),
    "PySide2.QtWidgets.QDateTimeEdit.setCurrentSection": ('PySide2.QtWidgets.QDateTimeEdit.Section',),
    "PySide2.QtWidgets.QDateTimeEdit.setCurrentSectionIndex": ('int',),
    "PySide2.QtWidgets.QDateTimeEdit.setDate": ('PySide2.QtCore.QDate',),
    "PySide2.QtWidgets.QDateTimeEdit.setDateRange": ('PySide2.QtCore.QDate', 'PySide2.QtCore.QDate'),
    "PySide2.QtWidgets.QDateTimeEdit.setDateTime": ('PySide2.QtCore.QDateTime',),
    "PySide2.QtWidgets.QDateTimeEdit.setDateTimeRange": ('PySide2.QtCore.QDateTime', 'PySide2.QtCore.QDateTime'),
    "PySide2.QtWidgets.QDateTimeEdit.setDisplayFormat": ('str',),
    "PySide2.QtWidgets.QDateTimeEdit.setMaximumDate": ('PySide2.QtCore.QDate',),
    "PySide2.QtWidgets.QDateTimeEdit.setMaximumDateTime": ('PySide2.QtCore.QDateTime',),
    "PySide2.QtWidgets.QDateTimeEdit.setMaximumTime": ('PySide2.QtCore.QTime',),
    "PySide2.QtWidgets.QDateTimeEdit.setMinimumDate": ('PySide2.QtCore.QDate',),
    "PySide2.QtWidgets.QDateTimeEdit.setMinimumDateTime": ('PySide2.QtCore.QDateTime',),
    "PySide2.QtWidgets.QDateTimeEdit.setMinimumTime": ('PySide2.QtCore.QTime',),
    "PySide2.QtWidgets.QDateTimeEdit.setSelectedSection": ('PySide2.QtWidgets.QDateTimeEdit.Section',),
    "PySide2.QtWidgets.QDateTimeEdit.setTime": ('PySide2.QtCore.QTime',),
    "PySide2.QtWidgets.QDateTimeEdit.setTimeRange": ('PySide2.QtCore.QTime', 'PySide2.QtCore.QTime'),
    "PySide2.QtWidgets.QDateTimeEdit.setTimeSpec": ('PySide2.QtCore.Qt.TimeSpec',),
    "PySide2.QtWidgets.QDateTimeEdit.sizeHint": (),
    "PySide2.QtWidgets.QDateTimeEdit.stepBy": ('int',),
    "PySide2.QtWidgets.QDateTimeEdit.stepEnabled": (),
    "PySide2.QtWidgets.QDateTimeEdit.textFromDateTime": ('PySide2.QtCore.QDateTime',),
    "PySide2.QtWidgets.QDateTimeEdit.time": (),
    "PySide2.QtWidgets.QDateTimeEdit.timeSpec": (),
    "PySide2.QtWidgets.QDateTimeEdit.validate": ('str', 'int'),
    "PySide2.QtWidgets.QDateTimeEdit.wheelEvent": ('PySide2.QtGui.QWheelEvent',),

# class PySide2.QtWidgets.QDesktopWidget:
    "PySide2.QtWidgets.QDesktopWidget.__init__": (),
    "PySide2.QtWidgets.QDesktopWidget.availableGeometry": [('PySide2.QtCore.QPoint',), ('PySide2.QtWidgets.QWidget',), ('int',)],
    "PySide2.QtWidgets.QDesktopWidget.isVirtualDesktop": (),
    "PySide2.QtWidgets.QDesktopWidget.numScreens": (),
    "PySide2.QtWidgets.QDesktopWidget.primaryScreen": (),
    "PySide2.QtWidgets.QDesktopWidget.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QDesktopWidget.screen": [(), ('int',)],
    "PySide2.QtWidgets.QDesktopWidget.screenCount": (),
    "PySide2.QtWidgets.QDesktopWidget.screenGeometry": [('PySide2.QtCore.QPoint',), ('PySide2.QtWidgets.QWidget',), ('int',)],
    "PySide2.QtWidgets.QDesktopWidget.screenNumber": [('PySide2.QtCore.QPoint',), ('PySide2.QtWidgets.QWidget',)],

# class PySide2.QtWidgets.QDial:
    "PySide2.QtWidgets.QDial.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QDial.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QDial.initStyleOption": ('PySide2.QtWidgets.QStyleOptionSlider',),
    "PySide2.QtWidgets.QDial.minimumSizeHint": (),
    "PySide2.QtWidgets.QDial.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QDial.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QDial.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QDial.notchSize": (),
    "PySide2.QtWidgets.QDial.notchTarget": (),
    "PySide2.QtWidgets.QDial.notchesVisible": (),
    "PySide2.QtWidgets.QDial.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QDial.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QDial.setNotchTarget": ('float',),
    "PySide2.QtWidgets.QDial.setNotchesVisible": ('bool',),
    "PySide2.QtWidgets.QDial.setWrapping": ('bool',),
    "PySide2.QtWidgets.QDial.sizeHint": (),
    "PySide2.QtWidgets.QDial.sliderChange": ('PySide2.QtWidgets.QAbstractSlider.SliderChange',),
    "PySide2.QtWidgets.QDial.wrapping": (),

# class PySide2.QtWidgets.QDialog:

# class PySide2.QtWidgets.QDialog.DialogCode:
    "PySide2.QtWidgets.QDialog.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
    "PySide2.QtWidgets.QDialog.accept": (),
    "PySide2.QtWidgets.QDialog.adjustPosition": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QDialog.closeEvent": ('PySide2.QtGui.QCloseEvent',),
    "PySide2.QtWidgets.QDialog.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
    "PySide2.QtWidgets.QDialog.done": ('int',),
    "PySide2.QtWidgets.QDialog.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QDialog.exec_": (),
    "PySide2.QtWidgets.QDialog.extension": (),
    "PySide2.QtWidgets.QDialog.isSizeGripEnabled": (),
    "PySide2.QtWidgets.QDialog.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QDialog.minimumSizeHint": (),
    "PySide2.QtWidgets.QDialog.open": (),
    "PySide2.QtWidgets.QDialog.orientation": (),
    "PySide2.QtWidgets.QDialog.reject": (),
    "PySide2.QtWidgets.QDialog.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QDialog.result": (),
    "PySide2.QtWidgets.QDialog.setExtension": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QDialog.setModal": ('bool',),
    "PySide2.QtWidgets.QDialog.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
    "PySide2.QtWidgets.QDialog.setResult": ('int',),
    "PySide2.QtWidgets.QDialog.setSizeGripEnabled": ('bool',),
    "PySide2.QtWidgets.QDialog.setVisible": ('bool',),
    "PySide2.QtWidgets.QDialog.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QDialog.showExtension": ('bool',),
    "PySide2.QtWidgets.QDialog.sizeHint": (),

# class PySide2.QtWidgets.QDialogButtonBox:

# class PySide2.QtWidgets.QDialogButtonBox.ButtonLayout:

# class PySide2.QtWidgets.QDialogButtonBox.ButtonRole:

# class PySide2.QtWidgets.QDialogButtonBox.StandardButton:

# class PySide2.QtWidgets.QDialogButtonBox.StandardButtons:
    "PySide2.QtWidgets.QDialogButtonBox.__init__": [('PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QDialogButtonBox.StandardButtons', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QDialogButtonBox.StandardButtons', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QDialogButtonBox.addButton": [('PySide2.QtWidgets.QAbstractButton', 'PySide2.QtWidgets.QDialogButtonBox.ButtonRole'), ('PySide2.QtWidgets.QDialogButtonBox.StandardButton',), ('str', 'PySide2.QtWidgets.QDialogButtonBox.ButtonRole')],
    "PySide2.QtWidgets.QDialogButtonBox.button": ('PySide2.QtWidgets.QDialogButtonBox.StandardButton',),
    "PySide2.QtWidgets.QDialogButtonBox.buttonRole": ('PySide2.QtWidgets.QAbstractButton',),
    "PySide2.QtWidgets.QDialogButtonBox.buttons": (),
    "PySide2.QtWidgets.QDialogButtonBox.centerButtons": (),
    "PySide2.QtWidgets.QDialogButtonBox.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QDialogButtonBox.clear": (),
    "PySide2.QtWidgets.QDialogButtonBox.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QDialogButtonBox.orientation": (),
    "PySide2.QtWidgets.QDialogButtonBox.removeButton": ('PySide2.QtWidgets.QAbstractButton',),
    "PySide2.QtWidgets.QDialogButtonBox.setCenterButtons": ('bool',),
    "PySide2.QtWidgets.QDialogButtonBox.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
    "PySide2.QtWidgets.QDialogButtonBox.setStandardButtons": ('PySide2.QtWidgets.QDialogButtonBox.StandardButtons',),
    "PySide2.QtWidgets.QDialogButtonBox.standardButton": ('PySide2.QtWidgets.QAbstractButton',),
    "PySide2.QtWidgets.QDialogButtonBox.standardButtons": (),

# class PySide2.QtWidgets.QDirModel:

# class PySide2.QtWidgets.QDirModel.Roles:
    "PySide2.QtWidgets.QDirModel.__init__": [('PySide2.QtCore.QObject',), ('typing.Sequence', 'PySide2.QtCore.QDir.Filters', 'PySide2.QtCore.QDir.SortFlags', 'PySide2.QtCore.QObject')],
    "PySide2.QtWidgets.QDirModel.columnCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QDirModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtWidgets.QDirModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QDirModel.fileIcon": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QDirModel.fileInfo": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QDirModel.fileName": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QDirModel.filePath": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QDirModel.filter": (),
    "PySide2.QtWidgets.QDirModel.flags": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QDirModel.hasChildren": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QDirModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
    "PySide2.QtWidgets.QDirModel.iconProvider": (),
    "PySide2.QtWidgets.QDirModel.index": [('int', 'int', 'PySide2.QtCore.QModelIndex'), ('str', 'int')],
    "PySide2.QtWidgets.QDirModel.isDir": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QDirModel.isReadOnly": (),
    "PySide2.QtWidgets.QDirModel.lazyChildCount": (),
    "PySide2.QtWidgets.QDirModel.mimeData": ('typing.List',),
    "PySide2.QtWidgets.QDirModel.mimeTypes": (),
    "PySide2.QtWidgets.QDirModel.mkdir": ('PySide2.QtCore.QModelIndex', 'str'),
    "PySide2.QtWidgets.QDirModel.nameFilters": (),
    "PySide2.QtWidgets.QDirModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
    "PySide2.QtWidgets.QDirModel.refresh": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QDirModel.remove": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QDirModel.resolveSymlinks": (),
    "PySide2.QtWidgets.QDirModel.rmdir": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QDirModel.rowCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QDirModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
    "PySide2.QtWidgets.QDirModel.setFilter": ('PySide2.QtCore.QDir.Filters',),
    "PySide2.QtWidgets.QDirModel.setIconProvider": ('PySide2.QtWidgets.QFileIconProvider',),
    "PySide2.QtWidgets.QDirModel.setLazyChildCount": ('bool',),
    "PySide2.QtWidgets.QDirModel.setNameFilters": ('typing.Sequence',),
    "PySide2.QtWidgets.QDirModel.setReadOnly": ('bool',),
    "PySide2.QtWidgets.QDirModel.setResolveSymlinks": ('bool',),
    "PySide2.QtWidgets.QDirModel.setSorting": ('PySide2.QtCore.QDir.SortFlags',),
    "PySide2.QtWidgets.QDirModel.sort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
    "PySide2.QtWidgets.QDirModel.sorting": (),
    "PySide2.QtWidgets.QDirModel.supportedDropActions": (),

# class PySide2.QtWidgets.QDockWidget:

# class PySide2.QtWidgets.QDockWidget.DockWidgetFeature:

# class PySide2.QtWidgets.QDockWidget.DockWidgetFeatures:
    "PySide2.QtWidgets.QDockWidget.__init__": [('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'), ('str', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags')],
    "PySide2.QtWidgets.QDockWidget.allowedAreas": (),
    "PySide2.QtWidgets.QDockWidget.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QDockWidget.closeEvent": ('PySide2.QtGui.QCloseEvent',),
    "PySide2.QtWidgets.QDockWidget.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QDockWidget.features": (),
    "PySide2.QtWidgets.QDockWidget.initStyleOption": ('PySide2.QtWidgets.QStyleOptionDockWidget',),
    "PySide2.QtWidgets.QDockWidget.isAreaAllowed": ('PySide2.QtCore.Qt.DockWidgetArea',),
    "PySide2.QtWidgets.QDockWidget.isFloating": (),
    "PySide2.QtWidgets.QDockWidget.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QDockWidget.setAllowedAreas": ('PySide2.QtCore.Qt.DockWidgetAreas',),
    "PySide2.QtWidgets.QDockWidget.setFeatures": ('PySide2.QtWidgets.QDockWidget.DockWidgetFeatures',),
    "PySide2.QtWidgets.QDockWidget.setFloating": ('bool',),
    "PySide2.QtWidgets.QDockWidget.setTitleBarWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QDockWidget.setWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QDockWidget.titleBarWidget": (),
    "PySide2.QtWidgets.QDockWidget.toggleViewAction": (),
    "PySide2.QtWidgets.QDockWidget.widget": (),

# class PySide2.QtWidgets.QDoubleSpinBox:
    "PySide2.QtWidgets.QDoubleSpinBox.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QDoubleSpinBox.cleanText": (),
    "PySide2.QtWidgets.QDoubleSpinBox.decimals": (),
    "PySide2.QtWidgets.QDoubleSpinBox.fixup": ('str',),
    "PySide2.QtWidgets.QDoubleSpinBox.maximum": (),
    "PySide2.QtWidgets.QDoubleSpinBox.minimum": (),
    "PySide2.QtWidgets.QDoubleSpinBox.prefix": (),
    "PySide2.QtWidgets.QDoubleSpinBox.setDecimals": ('int',),
    "PySide2.QtWidgets.QDoubleSpinBox.setMaximum": ('float',),
    "PySide2.QtWidgets.QDoubleSpinBox.setMinimum": ('float',),
    "PySide2.QtWidgets.QDoubleSpinBox.setPrefix": ('str',),
    "PySide2.QtWidgets.QDoubleSpinBox.setRange": ('float', 'float'),
    "PySide2.QtWidgets.QDoubleSpinBox.setSingleStep": ('float',),
    "PySide2.QtWidgets.QDoubleSpinBox.setStepType": ('PySide2.QtWidgets.QAbstractSpinBox.StepType',),
    "PySide2.QtWidgets.QDoubleSpinBox.setSuffix": ('str',),
    "PySide2.QtWidgets.QDoubleSpinBox.setValue": ('float',),
    "PySide2.QtWidgets.QDoubleSpinBox.singleStep": (),
    "PySide2.QtWidgets.QDoubleSpinBox.stepType": (),
    "PySide2.QtWidgets.QDoubleSpinBox.suffix": (),
    "PySide2.QtWidgets.QDoubleSpinBox.textFromValue": ('float',),
    "PySide2.QtWidgets.QDoubleSpinBox.validate": ('str', 'int'),
    "PySide2.QtWidgets.QDoubleSpinBox.value": (),
    "PySide2.QtWidgets.QDoubleSpinBox.valueFromText": ('str',),

# class PySide2.QtWidgets.QErrorMessage:
    "PySide2.QtWidgets.QErrorMessage.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QErrorMessage.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QErrorMessage.done": ('int',),
    "PySide2.QtWidgets.QErrorMessage.qtHandler": (),
    "PySide2.QtWidgets.QErrorMessage.showMessage": [('str',), ('str', 'str')],

# class PySide2.QtWidgets.QFileDialog:

# class PySide2.QtWidgets.QFileDialog.AcceptMode:

# class PySide2.QtWidgets.QFileDialog.DialogLabel:

# class PySide2.QtWidgets.QFileDialog.FileMode:

# class PySide2.QtWidgets.QFileDialog.Option:

# class PySide2.QtWidgets.QFileDialog.Options:

# class PySide2.QtWidgets.QFileDialog.ViewMode:
    "PySide2.QtWidgets.QFileDialog.__init__": [('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'), ('PySide2.QtWidgets.QWidget', 'str', 'str', 'str')],
    "PySide2.QtWidgets.QFileDialog.accept": (),
    "PySide2.QtWidgets.QFileDialog.acceptMode": (),
    "PySide2.QtWidgets.QFileDialog.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QFileDialog.confirmOverwrite": (),
    "PySide2.QtWidgets.QFileDialog.defaultSuffix": (),
    "PySide2.QtWidgets.QFileDialog.directory": (),
    "PySide2.QtWidgets.QFileDialog.directoryUrl": (),
    "PySide2.QtWidgets.QFileDialog.done": ('int',),
    "PySide2.QtWidgets.QFileDialog.fileMode": (),
    "PySide2.QtWidgets.QFileDialog.filter": (),
    "PySide2.QtWidgets.QFileDialog.getExistingDirectory": ('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QFileDialog.Options'),
    "PySide2.QtWidgets.QFileDialog.getExistingDirectoryUrl": ('PySide2.QtWidgets.QWidget', 'str', 'PySide2.QtCore.QUrl', 'PySide2.QtWidgets.QFileDialog.Options', 'typing.Sequence'),
    "PySide2.QtWidgets.QFileDialog.getOpenFileName": ('PySide2.QtWidgets.QWidget', 'str', 'str', 'str', 'PySide2.QtWidgets.QFileDialog.Options'),
    "PySide2.QtWidgets.QFileDialog.getOpenFileNames": ('PySide2.QtWidgets.QWidget', 'str', 'str', 'str', 'PySide2.QtWidgets.QFileDialog.Options'),
    "PySide2.QtWidgets.QFileDialog.getOpenFileUrl": ('PySide2.QtWidgets.QWidget', 'str', 'PySide2.QtCore.QUrl', 'str', 'PySide2.QtWidgets.QFileDialog.Options', 'typing.Sequence'),
    "PySide2.QtWidgets.QFileDialog.getOpenFileUrls": ('PySide2.QtWidgets.QWidget', 'str', 'PySide2.QtCore.QUrl', 'str', 'PySide2.QtWidgets.QFileDialog.Options', 'typing.Sequence'),
    "PySide2.QtWidgets.QFileDialog.getSaveFileName": ('PySide2.QtWidgets.QWidget', 'str', 'str', 'str', 'PySide2.QtWidgets.QFileDialog.Options'),
    "PySide2.QtWidgets.QFileDialog.getSaveFileUrl": ('PySide2.QtWidgets.QWidget', 'str', 'PySide2.QtCore.QUrl', 'str', 'PySide2.QtWidgets.QFileDialog.Options', 'typing.Sequence'),
    "PySide2.QtWidgets.QFileDialog.history": (),
    "PySide2.QtWidgets.QFileDialog.iconProvider": (),
    "PySide2.QtWidgets.QFileDialog.isNameFilterDetailsVisible": (),
    "PySide2.QtWidgets.QFileDialog.isReadOnly": (),
    "PySide2.QtWidgets.QFileDialog.itemDelegate": (),
    "PySide2.QtWidgets.QFileDialog.labelText": ('PySide2.QtWidgets.QFileDialog.DialogLabel',),
    "PySide2.QtWidgets.QFileDialog.mimeTypeFilters": (),
    "PySide2.QtWidgets.QFileDialog.nameFilters": (),
    "PySide2.QtWidgets.QFileDialog.open": [(), ('PySide2.QtCore.QObject', 'bytes')],
    "PySide2.QtWidgets.QFileDialog.options": (),
    "PySide2.QtWidgets.QFileDialog.proxyModel": (),
    "PySide2.QtWidgets.QFileDialog.resolveSymlinks": (),
    "PySide2.QtWidgets.QFileDialog.restoreState": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtWidgets.QFileDialog.saveFileContent": ('PySide2.QtCore.QByteArray', 'str'),
    "PySide2.QtWidgets.QFileDialog.saveState": (),
    "PySide2.QtWidgets.QFileDialog.selectFile": ('str',),
    "PySide2.QtWidgets.QFileDialog.selectMimeTypeFilter": ('str',),
    "PySide2.QtWidgets.QFileDialog.selectNameFilter": ('str',),
    "PySide2.QtWidgets.QFileDialog.selectUrl": ('PySide2.QtCore.QUrl',),
    "PySide2.QtWidgets.QFileDialog.selectedFiles": (),
    "PySide2.QtWidgets.QFileDialog.selectedMimeTypeFilter": (),
    "PySide2.QtWidgets.QFileDialog.selectedNameFilter": (),
    "PySide2.QtWidgets.QFileDialog.selectedUrls": (),
    "PySide2.QtWidgets.QFileDialog.setAcceptMode": ('PySide2.QtWidgets.QFileDialog.AcceptMode',),
    "PySide2.QtWidgets.QFileDialog.setConfirmOverwrite": ('bool',),
    "PySide2.QtWidgets.QFileDialog.setDefaultSuffix": ('str',),
    "PySide2.QtWidgets.QFileDialog.setDirectory": [('PySide2.QtCore.QDir',), ('str',)],
    "PySide2.QtWidgets.QFileDialog.setDirectoryUrl": ('PySide2.QtCore.QUrl',),
    "PySide2.QtWidgets.QFileDialog.setFileMode": ('PySide2.QtWidgets.QFileDialog.FileMode',),
    "PySide2.QtWidgets.QFileDialog.setFilter": ('PySide2.QtCore.QDir.Filters',),
    "PySide2.QtWidgets.QFileDialog.setHistory": ('typing.Sequence',),
    "PySide2.QtWidgets.QFileDialog.setIconProvider": ('PySide2.QtWidgets.QFileIconProvider',),
    "PySide2.QtWidgets.QFileDialog.setItemDelegate": ('PySide2.QtWidgets.QAbstractItemDelegate',),
    "PySide2.QtWidgets.QFileDialog.setLabelText": ('PySide2.QtWidgets.QFileDialog.DialogLabel', 'str'),
    "PySide2.QtWidgets.QFileDialog.setMimeTypeFilters": ('typing.Sequence',),
    "PySide2.QtWidgets.QFileDialog.setNameFilter": ('str',),
    "PySide2.QtWidgets.QFileDialog.setNameFilterDetailsVisible": ('bool',),
    "PySide2.QtWidgets.QFileDialog.setNameFilters": ('typing.Sequence',),
    "PySide2.QtWidgets.QFileDialog.setOption": ('PySide2.QtWidgets.QFileDialog.Option', 'bool'),
    "PySide2.QtWidgets.QFileDialog.setOptions": ('PySide2.QtWidgets.QFileDialog.Options',),
    "PySide2.QtWidgets.QFileDialog.setProxyModel": ('PySide2.QtCore.QAbstractProxyModel',),
    "PySide2.QtWidgets.QFileDialog.setReadOnly": ('bool',),
    "PySide2.QtWidgets.QFileDialog.setResolveSymlinks": ('bool',),
    "PySide2.QtWidgets.QFileDialog.setSidebarUrls": ('typing.Sequence',),
    "PySide2.QtWidgets.QFileDialog.setSupportedSchemes": ('typing.Sequence',),
    "PySide2.QtWidgets.QFileDialog.setViewMode": ('PySide2.QtWidgets.QFileDialog.ViewMode',),
    "PySide2.QtWidgets.QFileDialog.setVisible": ('bool',),
    "PySide2.QtWidgets.QFileDialog.sidebarUrls": (),
    "PySide2.QtWidgets.QFileDialog.supportedSchemes": (),
    "PySide2.QtWidgets.QFileDialog.testOption": ('PySide2.QtWidgets.QFileDialog.Option',),
    "PySide2.QtWidgets.QFileDialog.viewMode": (),

# class PySide2.QtWidgets.QFileIconProvider:

# class PySide2.QtWidgets.QFileIconProvider.IconType:

# class PySide2.QtWidgets.QFileIconProvider.Option:

# class PySide2.QtWidgets.QFileIconProvider.Options:
    "PySide2.QtWidgets.QFileIconProvider.__init__": (),
    "PySide2.QtWidgets.QFileIconProvider.icon": [('PySide2.QtCore.QFileInfo',), ('PySide2.QtWidgets.QFileIconProvider.IconType',)],
    "PySide2.QtWidgets.QFileIconProvider.options": (),
    "PySide2.QtWidgets.QFileIconProvider.setOptions": ('PySide2.QtWidgets.QFileIconProvider.Options',),
    "PySide2.QtWidgets.QFileIconProvider.type": ('PySide2.QtCore.QFileInfo',),

# class PySide2.QtWidgets.QFileSystemModel:

# class PySide2.QtWidgets.QFileSystemModel.Option:

# class PySide2.QtWidgets.QFileSystemModel.Options:

# class PySide2.QtWidgets.QFileSystemModel.Roles:
    "PySide2.QtWidgets.QFileSystemModel.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QFileSystemModel.canFetchMore": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QFileSystemModel.columnCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QFileSystemModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtWidgets.QFileSystemModel.dropMimeData": ('PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction', 'int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QFileSystemModel.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QFileSystemModel.fetchMore": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QFileSystemModel.fileIcon": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QFileSystemModel.fileInfo": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QFileSystemModel.fileName": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QFileSystemModel.filePath": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QFileSystemModel.filter": (),
    "PySide2.QtWidgets.QFileSystemModel.flags": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QFileSystemModel.hasChildren": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QFileSystemModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
    "PySide2.QtWidgets.QFileSystemModel.iconProvider": (),
    "PySide2.QtWidgets.QFileSystemModel.index": [('int', 'int', 'PySide2.QtCore.QModelIndex'), ('str', 'int')],
    "PySide2.QtWidgets.QFileSystemModel.isDir": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QFileSystemModel.isReadOnly": (),
    "PySide2.QtWidgets.QFileSystemModel.lastModified": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QFileSystemModel.mimeData": ('typing.List',),
    "PySide2.QtWidgets.QFileSystemModel.mimeTypes": (),
    "PySide2.QtWidgets.QFileSystemModel.mkdir": ('PySide2.QtCore.QModelIndex', 'str'),
    "PySide2.QtWidgets.QFileSystemModel.myComputer": ('int',),
    "PySide2.QtWidgets.QFileSystemModel.nameFilterDisables": (),
    "PySide2.QtWidgets.QFileSystemModel.nameFilters": (),
    "PySide2.QtWidgets.QFileSystemModel.options": (),
    "PySide2.QtWidgets.QFileSystemModel.parent": [(), ('PySide2.QtCore.QModelIndex',)],
    "PySide2.QtWidgets.QFileSystemModel.remove": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QFileSystemModel.resolveSymlinks": (),
    "PySide2.QtWidgets.QFileSystemModel.rmdir": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QFileSystemModel.rootDirectory": (),
    "PySide2.QtWidgets.QFileSystemModel.rootPath": (),
    "PySide2.QtWidgets.QFileSystemModel.rowCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QFileSystemModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
    "PySide2.QtWidgets.QFileSystemModel.setFilter": ('PySide2.QtCore.QDir.Filters',),
    "PySide2.QtWidgets.QFileSystemModel.setIconProvider": ('PySide2.QtWidgets.QFileIconProvider',),
    "PySide2.QtWidgets.QFileSystemModel.setNameFilterDisables": ('bool',),
    "PySide2.QtWidgets.QFileSystemModel.setNameFilters": ('typing.Sequence',),
    "PySide2.QtWidgets.QFileSystemModel.setOption": ('PySide2.QtWidgets.QFileSystemModel.Option', 'bool'),
    "PySide2.QtWidgets.QFileSystemModel.setOptions": ('PySide2.QtWidgets.QFileSystemModel.Options',),
    "PySide2.QtWidgets.QFileSystemModel.setReadOnly": ('bool',),
    "PySide2.QtWidgets.QFileSystemModel.setResolveSymlinks": ('bool',),
    "PySide2.QtWidgets.QFileSystemModel.setRootPath": ('str',),
    "PySide2.QtWidgets.QFileSystemModel.sibling": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QFileSystemModel.size": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QFileSystemModel.sort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
    "PySide2.QtWidgets.QFileSystemModel.supportedDropActions": (),
    "PySide2.QtWidgets.QFileSystemModel.testOption": ('PySide2.QtWidgets.QFileSystemModel.Option',),
    "PySide2.QtWidgets.QFileSystemModel.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtWidgets.QFileSystemModel.type": ('PySide2.QtCore.QModelIndex',),

# class PySide2.QtWidgets.QFocusFrame:
    "PySide2.QtWidgets.QFocusFrame.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QFocusFrame.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QFocusFrame.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QFocusFrame.initStyleOption": ('PySide2.QtWidgets.QStyleOption',),
    "PySide2.QtWidgets.QFocusFrame.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QFocusFrame.setWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QFocusFrame.widget": (),

# class PySide2.QtWidgets.QFontComboBox:

# class PySide2.QtWidgets.QFontComboBox.FontFilter:

# class PySide2.QtWidgets.QFontComboBox.FontFilters:
    "PySide2.QtWidgets.QFontComboBox.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QFontComboBox.currentFont": (),
    "PySide2.QtWidgets.QFontComboBox.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QFontComboBox.fontFilters": (),
    "PySide2.QtWidgets.QFontComboBox.setCurrentFont": ('PySide2.QtGui.QFont',),
    "PySide2.QtWidgets.QFontComboBox.setFontFilters": ('PySide2.QtWidgets.QFontComboBox.FontFilters',),
    "PySide2.QtWidgets.QFontComboBox.setWritingSystem": ('PySide2.QtGui.QFontDatabase.WritingSystem',),
    "PySide2.QtWidgets.QFontComboBox.sizeHint": (),
    "PySide2.QtWidgets.QFontComboBox.writingSystem": (),

# class PySide2.QtWidgets.QFontDialog:

# class PySide2.QtWidgets.QFontDialog.FontDialogOption:

# class PySide2.QtWidgets.QFontDialog.FontDialogOptions:
    "PySide2.QtWidgets.QFontDialog.__init__": [('PySide2.QtGui.QFont', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QFontDialog.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QFontDialog.currentFont": (),
    "PySide2.QtWidgets.QFontDialog.done": ('int',),
    "PySide2.QtWidgets.QFontDialog.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QFontDialog.getFont": [('PySide2.QtGui.QFont', 'PySide2.QtWidgets.QWidget', 'str', 'PySide2.QtWidgets.QFontDialog.FontDialogOptions'), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QFontDialog.open": [(), ('PySide2.QtCore.QObject', 'bytes')],
    "PySide2.QtWidgets.QFontDialog.options": (),
    "PySide2.QtWidgets.QFontDialog.selectedFont": (),
    "PySide2.QtWidgets.QFontDialog.setCurrentFont": ('PySide2.QtGui.QFont',),
    "PySide2.QtWidgets.QFontDialog.setOption": ('PySide2.QtWidgets.QFontDialog.FontDialogOption', 'bool'),
    "PySide2.QtWidgets.QFontDialog.setOptions": ('PySide2.QtWidgets.QFontDialog.FontDialogOptions',),
    "PySide2.QtWidgets.QFontDialog.setVisible": ('bool',),
    "PySide2.QtWidgets.QFontDialog.testOption": ('PySide2.QtWidgets.QFontDialog.FontDialogOption',),

# class PySide2.QtWidgets.QFormLayout:

# class PySide2.QtWidgets.QFormLayout.FieldGrowthPolicy:

# class PySide2.QtWidgets.QFormLayout.ItemRole:

# class PySide2.QtWidgets.QFormLayout.RowWrapPolicy:
    "PySide2.QtWidgets.QFormLayout.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QFormLayout.addItem": ('PySide2.QtWidgets.QLayoutItem',),
    "PySide2.QtWidgets.QFormLayout.addRow": [('PySide2.QtWidgets.QLayout',), ('PySide2.QtWidgets.QWidget',), ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QLayout'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QWidget'), ('str', 'PySide2.QtWidgets.QLayout'), ('str', 'PySide2.QtWidgets.QWidget')],
    "PySide2.QtWidgets.QFormLayout.count": (),
    "PySide2.QtWidgets.QFormLayout.expandingDirections": (),
    "PySide2.QtWidgets.QFormLayout.fieldGrowthPolicy": (),
    "PySide2.QtWidgets.QFormLayout.formAlignment": (),
    "PySide2.QtWidgets.QFormLayout.getItemPosition": ('int', 'PySide2.QtWidgets.QFormLayout.ItemRole'),
    "PySide2.QtWidgets.QFormLayout.getLayoutPosition": ('PySide2.QtWidgets.QLayout', 'PySide2.QtWidgets.QFormLayout.ItemRole'),
    "PySide2.QtWidgets.QFormLayout.getWidgetPosition": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QFormLayout.ItemRole'),
    "PySide2.QtWidgets.QFormLayout.hasHeightForWidth": (),
    "PySide2.QtWidgets.QFormLayout.heightForWidth": ('int',),
    "PySide2.QtWidgets.QFormLayout.horizontalSpacing": (),
    "PySide2.QtWidgets.QFormLayout.insertRow": [('int', 'PySide2.QtWidgets.QLayout'), ('int', 'PySide2.QtWidgets.QWidget'), ('int', 'PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QLayout'), ('int', 'PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QWidget'), ('int', 'str', 'PySide2.QtWidgets.QLayout'), ('int', 'str', 'PySide2.QtWidgets.QWidget')],
    "PySide2.QtWidgets.QFormLayout.invalidate": (),
    "PySide2.QtWidgets.QFormLayout.itemAt": [('int',), ('int', 'PySide2.QtWidgets.QFormLayout.ItemRole')],
    "PySide2.QtWidgets.QFormLayout.labelAlignment": (),
    "PySide2.QtWidgets.QFormLayout.labelForField": [('PySide2.QtWidgets.QLayout',), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QFormLayout.minimumSize": (),
    "PySide2.QtWidgets.QFormLayout.removeRow": [('PySide2.QtWidgets.QLayout',), ('PySide2.QtWidgets.QWidget',), ('int',)],
    "PySide2.QtWidgets.QFormLayout.rowCount": (),
    "PySide2.QtWidgets.QFormLayout.rowWrapPolicy": (),
    "PySide2.QtWidgets.QFormLayout.setFieldGrowthPolicy": ('PySide2.QtWidgets.QFormLayout.FieldGrowthPolicy',),
    "PySide2.QtWidgets.QFormLayout.setFormAlignment": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtWidgets.QFormLayout.setGeometry": ('PySide2.QtCore.QRect',),
    "PySide2.QtWidgets.QFormLayout.setHorizontalSpacing": ('int',),
    "PySide2.QtWidgets.QFormLayout.setItem": ('int', 'PySide2.QtWidgets.QFormLayout.ItemRole', 'PySide2.QtWidgets.QLayoutItem'),
    "PySide2.QtWidgets.QFormLayout.setLabelAlignment": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtWidgets.QFormLayout.setLayout": ('int', 'PySide2.QtWidgets.QFormLayout.ItemRole', 'PySide2.QtWidgets.QLayout'),
    "PySide2.QtWidgets.QFormLayout.setRowWrapPolicy": ('PySide2.QtWidgets.QFormLayout.RowWrapPolicy',),
    "PySide2.QtWidgets.QFormLayout.setSpacing": ('int',),
    "PySide2.QtWidgets.QFormLayout.setVerticalSpacing": ('int',),
    "PySide2.QtWidgets.QFormLayout.setWidget": ('int', 'PySide2.QtWidgets.QFormLayout.ItemRole', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QFormLayout.sizeHint": (),
    "PySide2.QtWidgets.QFormLayout.spacing": (),
    "PySide2.QtWidgets.QFormLayout.takeAt": ('int',),
    "PySide2.QtWidgets.QFormLayout.verticalSpacing": (),

# class PySide2.QtWidgets.QFrame:

# class PySide2.QtWidgets.QFrame.Shadow:

# class PySide2.QtWidgets.QFrame.Shape:

# class PySide2.QtWidgets.QFrame.StyleMask:
    "PySide2.QtWidgets.QFrame.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
    "PySide2.QtWidgets.QFrame.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QFrame.drawFrame": ('PySide2.QtGui.QPainter',),
    "PySide2.QtWidgets.QFrame.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QFrame.frameRect": (),
    "PySide2.QtWidgets.QFrame.frameShadow": (),
    "PySide2.QtWidgets.QFrame.frameShape": (),
    "PySide2.QtWidgets.QFrame.frameStyle": (),
    "PySide2.QtWidgets.QFrame.frameWidth": (),
    "PySide2.QtWidgets.QFrame.initStyleOption": ('PySide2.QtWidgets.QStyleOptionFrame',),
    "PySide2.QtWidgets.QFrame.lineWidth": (),
    "PySide2.QtWidgets.QFrame.midLineWidth": (),
    "PySide2.QtWidgets.QFrame.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QFrame.setFrameRect": ('PySide2.QtCore.QRect',),
    "PySide2.QtWidgets.QFrame.setFrameShadow": ('PySide2.QtWidgets.QFrame.Shadow',),
    "PySide2.QtWidgets.QFrame.setFrameShape": ('PySide2.QtWidgets.QFrame.Shape',),
    "PySide2.QtWidgets.QFrame.setFrameStyle": ('int',),
    "PySide2.QtWidgets.QFrame.setLineWidth": ('int',),
    "PySide2.QtWidgets.QFrame.setMidLineWidth": ('int',),
    "PySide2.QtWidgets.QFrame.sizeHint": (),

# class PySide2.QtWidgets.QGesture:

# class PySide2.QtWidgets.QGesture.GestureCancelPolicy:
    "PySide2.QtWidgets.QGesture.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QGesture.gestureCancelPolicy": (),
    "PySide2.QtWidgets.QGesture.gestureType": (),
    "PySide2.QtWidgets.QGesture.hasHotSpot": (),
    "PySide2.QtWidgets.QGesture.hotSpot": (),
    "PySide2.QtWidgets.QGesture.setGestureCancelPolicy": ('PySide2.QtWidgets.QGesture.GestureCancelPolicy',),
    "PySide2.QtWidgets.QGesture.setHotSpot": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGesture.state": (),
    "PySide2.QtWidgets.QGesture.unsetHotSpot": (),

# class PySide2.QtWidgets.QGestureEvent:
    "PySide2.QtWidgets.QGestureEvent.__init__": ('typing.Sequence',),
    "PySide2.QtWidgets.QGestureEvent.accept": [(), ('PySide2.QtCore.Qt.GestureType',), ('PySide2.QtWidgets.QGesture',)],
    "PySide2.QtWidgets.QGestureEvent.activeGestures": (),
    "PySide2.QtWidgets.QGestureEvent.canceledGestures": (),
    "PySide2.QtWidgets.QGestureEvent.gesture": ('PySide2.QtCore.Qt.GestureType',),
    "PySide2.QtWidgets.QGestureEvent.gestures": (),
    "PySide2.QtWidgets.QGestureEvent.ignore": [(), ('PySide2.QtCore.Qt.GestureType',), ('PySide2.QtWidgets.QGesture',)],
    "PySide2.QtWidgets.QGestureEvent.isAccepted": [(), ('PySide2.QtCore.Qt.GestureType',), ('PySide2.QtWidgets.QGesture',)],
    "PySide2.QtWidgets.QGestureEvent.mapToGraphicsScene": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGestureEvent.setAccepted": [('PySide2.QtCore.Qt.GestureType', 'bool'), ('PySide2.QtWidgets.QGesture', 'bool'), ('bool',)],
    "PySide2.QtWidgets.QGestureEvent.setWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QGestureEvent.widget": (),

# class PySide2.QtWidgets.QGestureRecognizer:

# class PySide2.QtWidgets.QGestureRecognizer.Result:

# class PySide2.QtWidgets.QGestureRecognizer.ResultFlag:
    "PySide2.QtWidgets.QGestureRecognizer.__init__": (),
    "PySide2.QtWidgets.QGestureRecognizer.create": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QGestureRecognizer.recognize": ('PySide2.QtWidgets.QGesture', 'PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QGestureRecognizer.registerRecognizer": ('PySide2.QtWidgets.QGestureRecognizer',),
    "PySide2.QtWidgets.QGestureRecognizer.reset": ('PySide2.QtWidgets.QGesture',),
    "PySide2.QtWidgets.QGestureRecognizer.unregisterRecognizer": ('PySide2.QtCore.Qt.GestureType',),

# class PySide2.QtWidgets.QGraphicsAnchor:
    "PySide2.QtWidgets.QGraphicsAnchor.setSizePolicy": ('PySide2.QtWidgets.QSizePolicy.Policy',),
    "PySide2.QtWidgets.QGraphicsAnchor.setSpacing": ('float',),
    "PySide2.QtWidgets.QGraphicsAnchor.sizePolicy": (),
    "PySide2.QtWidgets.QGraphicsAnchor.spacing": (),
    "PySide2.QtWidgets.QGraphicsAnchor.unsetSpacing": (),

# class PySide2.QtWidgets.QGraphicsAnchorLayout:
    "PySide2.QtWidgets.QGraphicsAnchorLayout.__init__": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
    "PySide2.QtWidgets.QGraphicsAnchorLayout.addAnchor": ('PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.AnchorPoint', 'PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.AnchorPoint'),
    "PySide2.QtWidgets.QGraphicsAnchorLayout.addAnchors": ('PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.Orientations'),
    "PySide2.QtWidgets.QGraphicsAnchorLayout.addCornerAnchors": ('PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.Corner', 'PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.Corner'),
    "PySide2.QtWidgets.QGraphicsAnchorLayout.anchor": ('PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.AnchorPoint', 'PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.AnchorPoint'),
    "PySide2.QtWidgets.QGraphicsAnchorLayout.count": (),
    "PySide2.QtWidgets.QGraphicsAnchorLayout.horizontalSpacing": (),
    "PySide2.QtWidgets.QGraphicsAnchorLayout.invalidate": (),
    "PySide2.QtWidgets.QGraphicsAnchorLayout.itemAt": ('int',),
    "PySide2.QtWidgets.QGraphicsAnchorLayout.removeAt": ('int',),
    "PySide2.QtWidgets.QGraphicsAnchorLayout.setGeometry": ('PySide2.QtCore.QRectF',),
    "PySide2.QtWidgets.QGraphicsAnchorLayout.setHorizontalSpacing": ('float',),
    "PySide2.QtWidgets.QGraphicsAnchorLayout.setSpacing": ('float',),
    "PySide2.QtWidgets.QGraphicsAnchorLayout.setVerticalSpacing": ('float',),
    "PySide2.QtWidgets.QGraphicsAnchorLayout.sizeHint": ('PySide2.QtCore.Qt.SizeHint', 'PySide2.QtCore.QSizeF'),
    "PySide2.QtWidgets.QGraphicsAnchorLayout.verticalSpacing": (),

# class PySide2.QtWidgets.QGraphicsBlurEffect:

# class PySide2.QtWidgets.QGraphicsBlurEffect.BlurHint:

# class PySide2.QtWidgets.QGraphicsBlurEffect.BlurHints:
    "PySide2.QtWidgets.QGraphicsBlurEffect.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QGraphicsBlurEffect.blurHints": (),
    "PySide2.QtWidgets.QGraphicsBlurEffect.blurRadius": (),
    "PySide2.QtWidgets.QGraphicsBlurEffect.boundingRectFor": ('PySide2.QtCore.QRectF',),
    "PySide2.QtWidgets.QGraphicsBlurEffect.draw": ('PySide2.QtGui.QPainter',),
    "PySide2.QtWidgets.QGraphicsBlurEffect.setBlurHints": ('PySide2.QtWidgets.QGraphicsBlurEffect.BlurHints',),
    "PySide2.QtWidgets.QGraphicsBlurEffect.setBlurRadius": ('float',),

# class PySide2.QtWidgets.QGraphicsColorizeEffect:
    "PySide2.QtWidgets.QGraphicsColorizeEffect.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QGraphicsColorizeEffect.color": (),
    "PySide2.QtWidgets.QGraphicsColorizeEffect.draw": ('PySide2.QtGui.QPainter',),
    "PySide2.QtWidgets.QGraphicsColorizeEffect.setColor": ('PySide2.QtGui.QColor',),
    "PySide2.QtWidgets.QGraphicsColorizeEffect.setStrength": ('float',),
    "PySide2.QtWidgets.QGraphicsColorizeEffect.strength": (),

# class PySide2.QtWidgets.QGraphicsDropShadowEffect:
    "PySide2.QtWidgets.QGraphicsDropShadowEffect.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QGraphicsDropShadowEffect.blurRadius": (),
    "PySide2.QtWidgets.QGraphicsDropShadowEffect.boundingRectFor": ('PySide2.QtCore.QRectF',),
    "PySide2.QtWidgets.QGraphicsDropShadowEffect.color": (),
    "PySide2.QtWidgets.QGraphicsDropShadowEffect.draw": ('PySide2.QtGui.QPainter',),
    "PySide2.QtWidgets.QGraphicsDropShadowEffect.offset": (),
    "PySide2.QtWidgets.QGraphicsDropShadowEffect.setBlurRadius": ('float',),
    "PySide2.QtWidgets.QGraphicsDropShadowEffect.setColor": ('PySide2.QtGui.QColor',),
    "PySide2.QtWidgets.QGraphicsDropShadowEffect.setOffset": [('PySide2.QtCore.QPointF',), ('float',), ('float', 'float')],
    "PySide2.QtWidgets.QGraphicsDropShadowEffect.setXOffset": ('float',),
    "PySide2.QtWidgets.QGraphicsDropShadowEffect.setYOffset": ('float',),
    "PySide2.QtWidgets.QGraphicsDropShadowEffect.xOffset": (),
    "PySide2.QtWidgets.QGraphicsDropShadowEffect.yOffset": (),

# class PySide2.QtWidgets.QGraphicsEffect:

# class PySide2.QtWidgets.QGraphicsEffect.ChangeFlag:

# class PySide2.QtWidgets.QGraphicsEffect.ChangeFlags:

# class PySide2.QtWidgets.QGraphicsEffect.PixmapPadMode:
    "PySide2.QtWidgets.QGraphicsEffect.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QGraphicsEffect.boundingRect": (),
    "PySide2.QtWidgets.QGraphicsEffect.boundingRectFor": ('PySide2.QtCore.QRectF',),
    "PySide2.QtWidgets.QGraphicsEffect.draw": ('PySide2.QtGui.QPainter',),
    "PySide2.QtWidgets.QGraphicsEffect.drawSource": ('PySide2.QtGui.QPainter',),
    "PySide2.QtWidgets.QGraphicsEffect.isEnabled": (),
    "PySide2.QtWidgets.QGraphicsEffect.setEnabled": ('bool',),
    "PySide2.QtWidgets.QGraphicsEffect.sourceBoundingRect": ('PySide2.QtCore.Qt.CoordinateSystem',),
    "PySide2.QtWidgets.QGraphicsEffect.sourceChanged": ('PySide2.QtWidgets.QGraphicsEffect.ChangeFlags',),
    "PySide2.QtWidgets.QGraphicsEffect.sourceIsPixmap": (),
    "PySide2.QtWidgets.QGraphicsEffect.sourcePixmap": ('PySide2.QtCore.Qt.CoordinateSystem', 'PySide2.QtCore.QPoint', 'PySide2.QtWidgets.QGraphicsEffect.PixmapPadMode'),
    "PySide2.QtWidgets.QGraphicsEffect.update": (),
    "PySide2.QtWidgets.QGraphicsEffect.updateBoundingRect": (),

# class PySide2.QtWidgets.QGraphicsEllipseItem:
    "PySide2.QtWidgets.QGraphicsEllipseItem.__init__": [('PySide2.QtCore.QRectF', 'PySide2.QtWidgets.QGraphicsItem'), ('PySide2.QtWidgets.QGraphicsItem',), ('float', 'float', 'float', 'float', 'PySide2.QtWidgets.QGraphicsItem')],
    "PySide2.QtWidgets.QGraphicsEllipseItem.boundingRect": (),
    "PySide2.QtWidgets.QGraphicsEllipseItem.contains": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsEllipseItem.extension": ('typing.Any',),
    "PySide2.QtWidgets.QGraphicsEllipseItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsEllipseItem.opaqueArea": (),
    "PySide2.QtWidgets.QGraphicsEllipseItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QGraphicsEllipseItem.rect": (),
    "PySide2.QtWidgets.QGraphicsEllipseItem.setRect": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsEllipseItem.setSpanAngle": ('int',),
    "PySide2.QtWidgets.QGraphicsEllipseItem.setStartAngle": ('int',),
    "PySide2.QtWidgets.QGraphicsEllipseItem.shape": (),
    "PySide2.QtWidgets.QGraphicsEllipseItem.spanAngle": (),
    "PySide2.QtWidgets.QGraphicsEllipseItem.startAngle": (),
    "PySide2.QtWidgets.QGraphicsEllipseItem.type": (),

# class PySide2.QtWidgets.QGraphicsGridLayout:
    "PySide2.QtWidgets.QGraphicsGridLayout.__init__": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
    "PySide2.QtWidgets.QGraphicsGridLayout.addItem": [('PySide2.QtWidgets.QGraphicsLayoutItem', 'int', 'int', 'PySide2.QtCore.Qt.Alignment'), ('PySide2.QtWidgets.QGraphicsLayoutItem', 'int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.Alignment')],
    "PySide2.QtWidgets.QGraphicsGridLayout.alignment": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
    "PySide2.QtWidgets.QGraphicsGridLayout.columnAlignment": ('int',),
    "PySide2.QtWidgets.QGraphicsGridLayout.columnCount": (),
    "PySide2.QtWidgets.QGraphicsGridLayout.columnMaximumWidth": ('int',),
    "PySide2.QtWidgets.QGraphicsGridLayout.columnMinimumWidth": ('int',),
    "PySide2.QtWidgets.QGraphicsGridLayout.columnPreferredWidth": ('int',),
    "PySide2.QtWidgets.QGraphicsGridLayout.columnSpacing": ('int',),
    "PySide2.QtWidgets.QGraphicsGridLayout.columnStretchFactor": ('int',),
    "PySide2.QtWidgets.QGraphicsGridLayout.count": (),
    "PySide2.QtWidgets.QGraphicsGridLayout.horizontalSpacing": (),
    "PySide2.QtWidgets.QGraphicsGridLayout.invalidate": (),
    "PySide2.QtWidgets.QGraphicsGridLayout.itemAt": [('int',), ('int', 'int')],
    "PySide2.QtWidgets.QGraphicsGridLayout.removeAt": ('int',),
    "PySide2.QtWidgets.QGraphicsGridLayout.removeItem": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
    "PySide2.QtWidgets.QGraphicsGridLayout.rowAlignment": ('int',),
    "PySide2.QtWidgets.QGraphicsGridLayout.rowCount": (),
    "PySide2.QtWidgets.QGraphicsGridLayout.rowMaximumHeight": ('int',),
    "PySide2.QtWidgets.QGraphicsGridLayout.rowMinimumHeight": ('int',),
    "PySide2.QtWidgets.QGraphicsGridLayout.rowPreferredHeight": ('int',),
    "PySide2.QtWidgets.QGraphicsGridLayout.rowSpacing": ('int',),
    "PySide2.QtWidgets.QGraphicsGridLayout.rowStretchFactor": ('int',),
    "PySide2.QtWidgets.QGraphicsGridLayout.setAlignment": ('PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.Alignment'),
    "PySide2.QtWidgets.QGraphicsGridLayout.setColumnAlignment": ('int', 'PySide2.QtCore.Qt.Alignment'),
    "PySide2.QtWidgets.QGraphicsGridLayout.setColumnFixedWidth": ('int', 'float'),
    "PySide2.QtWidgets.QGraphicsGridLayout.setColumnMaximumWidth": ('int', 'float'),
    "PySide2.QtWidgets.QGraphicsGridLayout.setColumnMinimumWidth": ('int', 'float'),
    "PySide2.QtWidgets.QGraphicsGridLayout.setColumnPreferredWidth": ('int', 'float'),
    "PySide2.QtWidgets.QGraphicsGridLayout.setColumnSpacing": ('int', 'float'),
    "PySide2.QtWidgets.QGraphicsGridLayout.setColumnStretchFactor": ('int', 'int'),
    "PySide2.QtWidgets.QGraphicsGridLayout.setGeometry": ('PySide2.QtCore.QRectF',),
    "PySide2.QtWidgets.QGraphicsGridLayout.setHorizontalSpacing": ('float',),
    "PySide2.QtWidgets.QGraphicsGridLayout.setRowAlignment": ('int', 'PySide2.QtCore.Qt.Alignment'),
    "PySide2.QtWidgets.QGraphicsGridLayout.setRowFixedHeight": ('int', 'float'),
    "PySide2.QtWidgets.QGraphicsGridLayout.setRowMaximumHeight": ('int', 'float'),
    "PySide2.QtWidgets.QGraphicsGridLayout.setRowMinimumHeight": ('int', 'float'),
    "PySide2.QtWidgets.QGraphicsGridLayout.setRowPreferredHeight": ('int', 'float'),
    "PySide2.QtWidgets.QGraphicsGridLayout.setRowSpacing": ('int', 'float'),
    "PySide2.QtWidgets.QGraphicsGridLayout.setRowStretchFactor": ('int', 'int'),
    "PySide2.QtWidgets.QGraphicsGridLayout.setSpacing": ('float',),
    "PySide2.QtWidgets.QGraphicsGridLayout.setVerticalSpacing": ('float',),
    "PySide2.QtWidgets.QGraphicsGridLayout.sizeHint": ('PySide2.QtCore.Qt.SizeHint', 'PySide2.QtCore.QSizeF'),
    "PySide2.QtWidgets.QGraphicsGridLayout.verticalSpacing": (),

# class PySide2.QtWidgets.QGraphicsItem:

# class PySide2.QtWidgets.QGraphicsItem.CacheMode:

# class PySide2.QtWidgets.QGraphicsItem.Extension:

# class PySide2.QtWidgets.QGraphicsItem.GraphicsItemChange:

# class PySide2.QtWidgets.QGraphicsItem.GraphicsItemFlag:

# class PySide2.QtWidgets.QGraphicsItem.GraphicsItemFlags:

# class PySide2.QtWidgets.QGraphicsItem.PanelModality:
    "PySide2.QtWidgets.QGraphicsItem.__init__": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsItem.acceptDrops": (),
    "PySide2.QtWidgets.QGraphicsItem.acceptHoverEvents": (),
    "PySide2.QtWidgets.QGraphicsItem.acceptTouchEvents": (),
    "PySide2.QtWidgets.QGraphicsItem.acceptedMouseButtons": (),
    "PySide2.QtWidgets.QGraphicsItem.addToIndex": (),
    "PySide2.QtWidgets.QGraphicsItem.advance": ('int',),
    "PySide2.QtWidgets.QGraphicsItem.boundingRect": (),
    "PySide2.QtWidgets.QGraphicsItem.boundingRegion": ('PySide2.QtGui.QTransform',),
    "PySide2.QtWidgets.QGraphicsItem.boundingRegionGranularity": (),
    "PySide2.QtWidgets.QGraphicsItem.cacheMode": (),
    "PySide2.QtWidgets.QGraphicsItem.childItems": (),
    "PySide2.QtWidgets.QGraphicsItem.childrenBoundingRect": (),
    "PySide2.QtWidgets.QGraphicsItem.clearFocus": (),
    "PySide2.QtWidgets.QGraphicsItem.clipPath": (),
    "PySide2.QtWidgets.QGraphicsItem.collidesWithItem": ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.Qt.ItemSelectionMode'),
    "PySide2.QtWidgets.QGraphicsItem.collidesWithPath": ('PySide2.QtGui.QPainterPath', 'PySide2.QtCore.Qt.ItemSelectionMode'),
    "PySide2.QtWidgets.QGraphicsItem.collidingItems": ('PySide2.QtCore.Qt.ItemSelectionMode',),
    "PySide2.QtWidgets.QGraphicsItem.commonAncestorItem": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsItem.contains": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsItem.contextMenuEvent": ('PySide2.QtWidgets.QGraphicsSceneContextMenuEvent',),
    "PySide2.QtWidgets.QGraphicsItem.cursor": (),
    "PySide2.QtWidgets.QGraphicsItem.data": ('int',),
    "PySide2.QtWidgets.QGraphicsItem.deviceTransform": ('PySide2.QtGui.QTransform',),
    "PySide2.QtWidgets.QGraphicsItem.dragEnterEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
    "PySide2.QtWidgets.QGraphicsItem.dragLeaveEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
    "PySide2.QtWidgets.QGraphicsItem.dragMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
    "PySide2.QtWidgets.QGraphicsItem.dropEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
    "PySide2.QtWidgets.QGraphicsItem.effectiveOpacity": (),
    "PySide2.QtWidgets.QGraphicsItem.ensureVisible": [('PySide2.QtCore.QRectF', 'int', 'int'), ('float', 'float', 'float', 'float', 'int', 'int')],
    "PySide2.QtWidgets.QGraphicsItem.extension": ('typing.Any',),
    "PySide2.QtWidgets.QGraphicsItem.filtersChildEvents": (),
    "PySide2.QtWidgets.QGraphicsItem.flags": (),
    "PySide2.QtWidgets.QGraphicsItem.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QGraphicsItem.focusItem": (),
    "PySide2.QtWidgets.QGraphicsItem.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QGraphicsItem.focusProxy": (),
    "PySide2.QtWidgets.QGraphicsItem.focusScopeItem": (),
    "PySide2.QtWidgets.QGraphicsItem.grabKeyboard": (),
    "PySide2.QtWidgets.QGraphicsItem.grabMouse": (),
    "PySide2.QtWidgets.QGraphicsItem.graphicsEffect": (),
    "PySide2.QtWidgets.QGraphicsItem.group": (),
    "PySide2.QtWidgets.QGraphicsItem.handlesChildEvents": (),
    "PySide2.QtWidgets.QGraphicsItem.hasCursor": (),
    "PySide2.QtWidgets.QGraphicsItem.hasFocus": (),
    "PySide2.QtWidgets.QGraphicsItem.hide": (),
    "PySide2.QtWidgets.QGraphicsItem.hoverEnterEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
    "PySide2.QtWidgets.QGraphicsItem.hoverLeaveEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
    "PySide2.QtWidgets.QGraphicsItem.hoverMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
    "PySide2.QtWidgets.QGraphicsItem.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
    "PySide2.QtWidgets.QGraphicsItem.inputMethodHints": (),
    "PySide2.QtWidgets.QGraphicsItem.inputMethodQuery": ('PySide2.QtCore.Qt.InputMethodQuery',),
    "PySide2.QtWidgets.QGraphicsItem.installSceneEventFilter": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsItem.isActive": (),
    "PySide2.QtWidgets.QGraphicsItem.isAncestorOf": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsItem.isBlockedByModalPanel": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsItem.isClipped": (),
    "PySide2.QtWidgets.QGraphicsItem.isEnabled": (),
    "PySide2.QtWidgets.QGraphicsItem.isObscured": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsItem.isPanel": (),
    "PySide2.QtWidgets.QGraphicsItem.isSelected": (),
    "PySide2.QtWidgets.QGraphicsItem.isUnderMouse": (),
    "PySide2.QtWidgets.QGraphicsItem.isVisible": (),
    "PySide2.QtWidgets.QGraphicsItem.isVisibleTo": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsItem.isWidget": (),
    "PySide2.QtWidgets.QGraphicsItem.isWindow": (),
    "PySide2.QtWidgets.QGraphicsItem.itemChange": ('PySide2.QtWidgets.QGraphicsItem.GraphicsItemChange', 'typing.Any'),
    "PySide2.QtWidgets.QGraphicsItem.itemTransform": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsItem.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QGraphicsItem.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QGraphicsItem.mapFromItem": [('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.QPointF'), ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.QRectF'), ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtGui.QPainterPath'), ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtGui.QPolygonF'), ('PySide2.QtWidgets.QGraphicsItem', 'float', 'float'), ('PySide2.QtWidgets.QGraphicsItem', 'float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsItem.mapFromParent": [('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRectF',), ('PySide2.QtGui.QPainterPath',), ('PySide2.QtGui.QPolygonF',), ('float', 'float'), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsItem.mapFromScene": [('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRectF',), ('PySide2.QtGui.QPainterPath',), ('PySide2.QtGui.QPolygonF',), ('float', 'float'), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsItem.mapRectFromItem": [('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.QRectF'), ('PySide2.QtWidgets.QGraphicsItem', 'float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsItem.mapRectFromParent": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsItem.mapRectFromScene": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsItem.mapRectToItem": [('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.QRectF'), ('PySide2.QtWidgets.QGraphicsItem', 'float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsItem.mapRectToParent": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsItem.mapRectToScene": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsItem.mapToItem": [('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.QPointF'), ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.QRectF'), ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtGui.QPainterPath'), ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtGui.QPolygonF'), ('PySide2.QtWidgets.QGraphicsItem', 'float', 'float'), ('PySide2.QtWidgets.QGraphicsItem', 'float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsItem.mapToParent": [('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRectF',), ('PySide2.QtGui.QPainterPath',), ('PySide2.QtGui.QPolygonF',), ('float', 'float'), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsItem.mapToScene": [('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRectF',), ('PySide2.QtGui.QPainterPath',), ('PySide2.QtGui.QPolygonF',), ('float', 'float'), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsItem.matrix": (),
    "PySide2.QtWidgets.QGraphicsItem.mouseDoubleClickEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
    "PySide2.QtWidgets.QGraphicsItem.mouseMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
    "PySide2.QtWidgets.QGraphicsItem.mousePressEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
    "PySide2.QtWidgets.QGraphicsItem.mouseReleaseEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
    "PySide2.QtWidgets.QGraphicsItem.moveBy": ('float', 'float'),
    "PySide2.QtWidgets.QGraphicsItem.opacity": (),
    "PySide2.QtWidgets.QGraphicsItem.opaqueArea": (),
    "PySide2.QtWidgets.QGraphicsItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QGraphicsItem.panel": (),
    "PySide2.QtWidgets.QGraphicsItem.panelModality": (),
    "PySide2.QtWidgets.QGraphicsItem.parentItem": (),
    "PySide2.QtWidgets.QGraphicsItem.parentObject": (),
    "PySide2.QtWidgets.QGraphicsItem.parentWidget": (),
    "PySide2.QtWidgets.QGraphicsItem.pos": (),
    "PySide2.QtWidgets.QGraphicsItem.prepareGeometryChange": (),
    "PySide2.QtWidgets.QGraphicsItem.removeFromIndex": (),
    "PySide2.QtWidgets.QGraphicsItem.removeSceneEventFilter": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsItem.resetMatrix": (),
    "PySide2.QtWidgets.QGraphicsItem.resetTransform": (),
    "PySide2.QtWidgets.QGraphicsItem.rotation": (),
    "PySide2.QtWidgets.QGraphicsItem.scale": (),
    "PySide2.QtWidgets.QGraphicsItem.scene": (),
    "PySide2.QtWidgets.QGraphicsItem.sceneBoundingRect": (),
    "PySide2.QtWidgets.QGraphicsItem.sceneEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGraphicsItem.sceneEventFilter": ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QGraphicsItem.sceneMatrix": (),
    "PySide2.QtWidgets.QGraphicsItem.scenePos": (),
    "PySide2.QtWidgets.QGraphicsItem.sceneTransform": (),
    "PySide2.QtWidgets.QGraphicsItem.scroll": ('float', 'float', 'PySide2.QtCore.QRectF'),
    "PySide2.QtWidgets.QGraphicsItem.setAcceptDrops": ('bool',),
    "PySide2.QtWidgets.QGraphicsItem.setAcceptHoverEvents": ('bool',),
    "PySide2.QtWidgets.QGraphicsItem.setAcceptTouchEvents": ('bool',),
    "PySide2.QtWidgets.QGraphicsItem.setAcceptedMouseButtons": ('PySide2.QtCore.Qt.MouseButtons',),
    "PySide2.QtWidgets.QGraphicsItem.setActive": ('bool',),
    "PySide2.QtWidgets.QGraphicsItem.setBoundingRegionGranularity": ('float',),
    "PySide2.QtWidgets.QGraphicsItem.setCacheMode": ('PySide2.QtWidgets.QGraphicsItem.CacheMode', 'PySide2.QtCore.QSize'),
    "PySide2.QtWidgets.QGraphicsItem.setCursor": ('PySide2.QtGui.QCursor',),
    "PySide2.QtWidgets.QGraphicsItem.setData": ('int', 'typing.Any'),
    "PySide2.QtWidgets.QGraphicsItem.setEnabled": ('bool',),
    "PySide2.QtWidgets.QGraphicsItem.setFiltersChildEvents": ('bool',),
    "PySide2.QtWidgets.QGraphicsItem.setFlag": ('PySide2.QtWidgets.QGraphicsItem.GraphicsItemFlag', 'bool'),
    "PySide2.QtWidgets.QGraphicsItem.setFlags": ('PySide2.QtWidgets.QGraphicsItem.GraphicsItemFlags',),
    "PySide2.QtWidgets.QGraphicsItem.setFocus": ('PySide2.QtCore.Qt.FocusReason',),
    "PySide2.QtWidgets.QGraphicsItem.setFocusProxy": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsItem.setGraphicsEffect": ('PySide2.QtWidgets.QGraphicsEffect',),
    "PySide2.QtWidgets.QGraphicsItem.setGroup": ('PySide2.QtWidgets.QGraphicsItemGroup',),
    "PySide2.QtWidgets.QGraphicsItem.setHandlesChildEvents": ('bool',),
    "PySide2.QtWidgets.QGraphicsItem.setInputMethodHints": ('PySide2.QtCore.Qt.InputMethodHints',),
    "PySide2.QtWidgets.QGraphicsItem.setMatrix": ('PySide2.QtGui.QMatrix', 'bool'),
    "PySide2.QtWidgets.QGraphicsItem.setOpacity": ('float',),
    "PySide2.QtWidgets.QGraphicsItem.setPanelModality": ('PySide2.QtWidgets.QGraphicsItem.PanelModality',),
    "PySide2.QtWidgets.QGraphicsItem.setParentItem": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsItem.setPos": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtWidgets.QGraphicsItem.setRotation": ('float',),
    "PySide2.QtWidgets.QGraphicsItem.setScale": ('float',),
    "PySide2.QtWidgets.QGraphicsItem.setSelected": ('bool',),
    "PySide2.QtWidgets.QGraphicsItem.setToolTip": ('str',),
    "PySide2.QtWidgets.QGraphicsItem.setTransform": ('PySide2.QtGui.QTransform', 'bool'),
    "PySide2.QtWidgets.QGraphicsItem.setTransformOriginPoint": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtWidgets.QGraphicsItem.setTransformations": ('typing.Sequence',),
    "PySide2.QtWidgets.QGraphicsItem.setVisible": ('bool',),
    "PySide2.QtWidgets.QGraphicsItem.setX": ('float',),
    "PySide2.QtWidgets.QGraphicsItem.setY": ('float',),
    "PySide2.QtWidgets.QGraphicsItem.setZValue": ('float',),
    "PySide2.QtWidgets.QGraphicsItem.shape": (),
    "PySide2.QtWidgets.QGraphicsItem.show": (),
    "PySide2.QtWidgets.QGraphicsItem.stackBefore": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsItem.toGraphicsObject": (),
    "PySide2.QtWidgets.QGraphicsItem.toolTip": (),
    "PySide2.QtWidgets.QGraphicsItem.topLevelItem": (),
    "PySide2.QtWidgets.QGraphicsItem.topLevelWidget": (),
    "PySide2.QtWidgets.QGraphicsItem.transform": (),
    "PySide2.QtWidgets.QGraphicsItem.transformOriginPoint": (),
    "PySide2.QtWidgets.QGraphicsItem.transformations": (),
    "PySide2.QtWidgets.QGraphicsItem.type": (),
    "PySide2.QtWidgets.QGraphicsItem.ungrabKeyboard": (),
    "PySide2.QtWidgets.QGraphicsItem.ungrabMouse": (),
    "PySide2.QtWidgets.QGraphicsItem.unsetCursor": (),
    "PySide2.QtWidgets.QGraphicsItem.update": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsItem.updateMicroFocus": (),
    "PySide2.QtWidgets.QGraphicsItem.wheelEvent": ('PySide2.QtWidgets.QGraphicsSceneWheelEvent',),
    "PySide2.QtWidgets.QGraphicsItem.window": (),
    "PySide2.QtWidgets.QGraphicsItem.x": (),
    "PySide2.QtWidgets.QGraphicsItem.y": (),
    "PySide2.QtWidgets.QGraphicsItem.zValue": (),

# class PySide2.QtWidgets.QGraphicsItemAnimation:
    "PySide2.QtWidgets.QGraphicsItemAnimation.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QGraphicsItemAnimation.afterAnimationStep": ('float',),
    "PySide2.QtWidgets.QGraphicsItemAnimation.beforeAnimationStep": ('float',),
    "PySide2.QtWidgets.QGraphicsItemAnimation.clear": (),
    "PySide2.QtWidgets.QGraphicsItemAnimation.horizontalScaleAt": ('float',),
    "PySide2.QtWidgets.QGraphicsItemAnimation.horizontalShearAt": ('float',),
    "PySide2.QtWidgets.QGraphicsItemAnimation.item": (),
    "PySide2.QtWidgets.QGraphicsItemAnimation.matrixAt": ('float',),
    "PySide2.QtWidgets.QGraphicsItemAnimation.posAt": ('float',),
    "PySide2.QtWidgets.QGraphicsItemAnimation.posList": (),
    "PySide2.QtWidgets.QGraphicsItemAnimation.reset": (),
    "PySide2.QtWidgets.QGraphicsItemAnimation.rotationAt": ('float',),
    "PySide2.QtWidgets.QGraphicsItemAnimation.rotationList": (),
    "PySide2.QtWidgets.QGraphicsItemAnimation.scaleList": (),
    "PySide2.QtWidgets.QGraphicsItemAnimation.setItem": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsItemAnimation.setPosAt": ('float', 'PySide2.QtCore.QPointF'),
    "PySide2.QtWidgets.QGraphicsItemAnimation.setRotationAt": ('float', 'float'),
    "PySide2.QtWidgets.QGraphicsItemAnimation.setScaleAt": ('float', 'float', 'float'),
    "PySide2.QtWidgets.QGraphicsItemAnimation.setShearAt": ('float', 'float', 'float'),
    "PySide2.QtWidgets.QGraphicsItemAnimation.setStep": ('float',),
    "PySide2.QtWidgets.QGraphicsItemAnimation.setTimeLine": ('PySide2.QtCore.QTimeLine',),
    "PySide2.QtWidgets.QGraphicsItemAnimation.setTranslationAt": ('float', 'float', 'float'),
    "PySide2.QtWidgets.QGraphicsItemAnimation.shearList": (),
    "PySide2.QtWidgets.QGraphicsItemAnimation.timeLine": (),
    "PySide2.QtWidgets.QGraphicsItemAnimation.transformAt": ('float',),
    "PySide2.QtWidgets.QGraphicsItemAnimation.translationList": (),
    "PySide2.QtWidgets.QGraphicsItemAnimation.verticalScaleAt": ('float',),
    "PySide2.QtWidgets.QGraphicsItemAnimation.verticalShearAt": ('float',),
    "PySide2.QtWidgets.QGraphicsItemAnimation.xTranslationAt": ('float',),
    "PySide2.QtWidgets.QGraphicsItemAnimation.yTranslationAt": ('float',),

# class PySide2.QtWidgets.QGraphicsItemGroup:
    "PySide2.QtWidgets.QGraphicsItemGroup.__init__": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsItemGroup.addToGroup": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsItemGroup.boundingRect": (),
    "PySide2.QtWidgets.QGraphicsItemGroup.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsItemGroup.opaqueArea": (),
    "PySide2.QtWidgets.QGraphicsItemGroup.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QGraphicsItemGroup.removeFromGroup": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsItemGroup.type": (),

# class PySide2.QtWidgets.QGraphicsLayout:
    "PySide2.QtWidgets.QGraphicsLayout.__init__": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
    "PySide2.QtWidgets.QGraphicsLayout.activate": (),
    "PySide2.QtWidgets.QGraphicsLayout.addChildLayoutItem": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
    "PySide2.QtWidgets.QGraphicsLayout.count": (),
    "PySide2.QtWidgets.QGraphicsLayout.getContentsMargins": (),
    "PySide2.QtWidgets.QGraphicsLayout.instantInvalidatePropagation": (),
    "PySide2.QtWidgets.QGraphicsLayout.invalidate": (),
    "PySide2.QtWidgets.QGraphicsLayout.isActivated": (),
    "PySide2.QtWidgets.QGraphicsLayout.itemAt": ('int',),
    "PySide2.QtWidgets.QGraphicsLayout.removeAt": ('int',),
    "PySide2.QtWidgets.QGraphicsLayout.setContentsMargins": ('float', 'float', 'float', 'float'),
    "PySide2.QtWidgets.QGraphicsLayout.setInstantInvalidatePropagation": ('bool',),
    "PySide2.QtWidgets.QGraphicsLayout.updateGeometry": (),
    "PySide2.QtWidgets.QGraphicsLayout.widgetEvent": ('PySide2.QtCore.QEvent',),

# class PySide2.QtWidgets.QGraphicsLayoutItem:
    "PySide2.QtWidgets.QGraphicsLayoutItem.__init__": ('PySide2.QtWidgets.QGraphicsLayoutItem', 'bool'),
    "PySide2.QtWidgets.QGraphicsLayoutItem.contentsRect": (),
    "PySide2.QtWidgets.QGraphicsLayoutItem.effectiveSizeHint": ('PySide2.QtCore.Qt.SizeHint', 'PySide2.QtCore.QSizeF'),
    "PySide2.QtWidgets.QGraphicsLayoutItem.geometry": (),
    "PySide2.QtWidgets.QGraphicsLayoutItem.getContentsMargins": (),
    "PySide2.QtWidgets.QGraphicsLayoutItem.graphicsItem": (),
    "PySide2.QtWidgets.QGraphicsLayoutItem.isLayout": (),
    "PySide2.QtWidgets.QGraphicsLayoutItem.maximumHeight": (),
    "PySide2.QtWidgets.QGraphicsLayoutItem.maximumSize": (),
    "PySide2.QtWidgets.QGraphicsLayoutItem.maximumWidth": (),
    "PySide2.QtWidgets.QGraphicsLayoutItem.minimumHeight": (),
    "PySide2.QtWidgets.QGraphicsLayoutItem.minimumSize": (),
    "PySide2.QtWidgets.QGraphicsLayoutItem.minimumWidth": (),
    "PySide2.QtWidgets.QGraphicsLayoutItem.ownedByLayout": (),
    "PySide2.QtWidgets.QGraphicsLayoutItem.parentLayoutItem": (),
    "PySide2.QtWidgets.QGraphicsLayoutItem.preferredHeight": (),
    "PySide2.QtWidgets.QGraphicsLayoutItem.preferredSize": (),
    "PySide2.QtWidgets.QGraphicsLayoutItem.preferredWidth": (),
    "PySide2.QtWidgets.QGraphicsLayoutItem.setGeometry": ('PySide2.QtCore.QRectF',),
    "PySide2.QtWidgets.QGraphicsLayoutItem.setGraphicsItem": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsLayoutItem.setMaximumHeight": ('float',),
    "PySide2.QtWidgets.QGraphicsLayoutItem.setMaximumSize": [('PySide2.QtCore.QSizeF',), ('float', 'float')],
    "PySide2.QtWidgets.QGraphicsLayoutItem.setMaximumWidth": ('float',),
    "PySide2.QtWidgets.QGraphicsLayoutItem.setMinimumHeight": ('float',),
    "PySide2.QtWidgets.QGraphicsLayoutItem.setMinimumSize": [('PySide2.QtCore.QSizeF',), ('float', 'float')],
    "PySide2.QtWidgets.QGraphicsLayoutItem.setMinimumWidth": ('float',),
    "PySide2.QtWidgets.QGraphicsLayoutItem.setOwnedByLayout": ('bool',),
    "PySide2.QtWidgets.QGraphicsLayoutItem.setParentLayoutItem": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
    "PySide2.QtWidgets.QGraphicsLayoutItem.setPreferredHeight": ('float',),
    "PySide2.QtWidgets.QGraphicsLayoutItem.setPreferredSize": [('PySide2.QtCore.QSizeF',), ('float', 'float')],
    "PySide2.QtWidgets.QGraphicsLayoutItem.setPreferredWidth": ('float',),
    "PySide2.QtWidgets.QGraphicsLayoutItem.setSizePolicy": [('PySide2.QtWidgets.QSizePolicy',), ('PySide2.QtWidgets.QSizePolicy.Policy', 'PySide2.QtWidgets.QSizePolicy.Policy', 'PySide2.QtWidgets.QSizePolicy.ControlType')],
    "PySide2.QtWidgets.QGraphicsLayoutItem.sizeHint": ('PySide2.QtCore.Qt.SizeHint', 'PySide2.QtCore.QSizeF'),
    "PySide2.QtWidgets.QGraphicsLayoutItem.sizePolicy": (),
    "PySide2.QtWidgets.QGraphicsLayoutItem.updateGeometry": (),

# class PySide2.QtWidgets.QGraphicsLineItem:
    "PySide2.QtWidgets.QGraphicsLineItem.__init__": [('PySide2.QtCore.QLineF', 'PySide2.QtWidgets.QGraphicsItem'), ('PySide2.QtWidgets.QGraphicsItem',), ('float', 'float', 'float', 'float', 'PySide2.QtWidgets.QGraphicsItem')],
    "PySide2.QtWidgets.QGraphicsLineItem.boundingRect": (),
    "PySide2.QtWidgets.QGraphicsLineItem.contains": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsLineItem.extension": ('typing.Any',),
    "PySide2.QtWidgets.QGraphicsLineItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsLineItem.line": (),
    "PySide2.QtWidgets.QGraphicsLineItem.opaqueArea": (),
    "PySide2.QtWidgets.QGraphicsLineItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QGraphicsLineItem.pen": (),
    "PySide2.QtWidgets.QGraphicsLineItem.setLine": [('PySide2.QtCore.QLineF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsLineItem.setPen": ('PySide2.QtGui.QPen',),
    "PySide2.QtWidgets.QGraphicsLineItem.shape": (),
    "PySide2.QtWidgets.QGraphicsLineItem.type": (),

# class PySide2.QtWidgets.QGraphicsLinearLayout:
    "PySide2.QtWidgets.QGraphicsLinearLayout.__init__": [('PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QGraphicsLayoutItem'), ('PySide2.QtWidgets.QGraphicsLayoutItem',)],
    "PySide2.QtWidgets.QGraphicsLinearLayout.addItem": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
    "PySide2.QtWidgets.QGraphicsLinearLayout.addStretch": ('int',),
    "PySide2.QtWidgets.QGraphicsLinearLayout.alignment": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
    "PySide2.QtWidgets.QGraphicsLinearLayout.count": (),
    "PySide2.QtWidgets.QGraphicsLinearLayout.dump": ('int',),
    "PySide2.QtWidgets.QGraphicsLinearLayout.insertItem": ('int', 'PySide2.QtWidgets.QGraphicsLayoutItem'),
    "PySide2.QtWidgets.QGraphicsLinearLayout.insertStretch": ('int', 'int'),
    "PySide2.QtWidgets.QGraphicsLinearLayout.invalidate": (),
    "PySide2.QtWidgets.QGraphicsLinearLayout.itemAt": ('int',),
    "PySide2.QtWidgets.QGraphicsLinearLayout.itemSpacing": ('int',),
    "PySide2.QtWidgets.QGraphicsLinearLayout.orientation": (),
    "PySide2.QtWidgets.QGraphicsLinearLayout.removeAt": ('int',),
    "PySide2.QtWidgets.QGraphicsLinearLayout.removeItem": ('PySide2.QtWidgets.QGraphicsLayoutItem',),
    "PySide2.QtWidgets.QGraphicsLinearLayout.setAlignment": ('PySide2.QtWidgets.QGraphicsLayoutItem', 'PySide2.QtCore.Qt.Alignment'),
    "PySide2.QtWidgets.QGraphicsLinearLayout.setGeometry": ('PySide2.QtCore.QRectF',),
    "PySide2.QtWidgets.QGraphicsLinearLayout.setItemSpacing": ('int', 'float'),
    "PySide2.QtWidgets.QGraphicsLinearLayout.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
    "PySide2.QtWidgets.QGraphicsLinearLayout.setSpacing": ('float',),
    "PySide2.QtWidgets.QGraphicsLinearLayout.setStretchFactor": ('PySide2.QtWidgets.QGraphicsLayoutItem', 'int'),
    "PySide2.QtWidgets.QGraphicsLinearLayout.sizeHint": ('PySide2.QtCore.Qt.SizeHint', 'PySide2.QtCore.QSizeF'),
    "PySide2.QtWidgets.QGraphicsLinearLayout.spacing": (),
    "PySide2.QtWidgets.QGraphicsLinearLayout.stretchFactor": ('PySide2.QtWidgets.QGraphicsLayoutItem',),

# class PySide2.QtWidgets.QGraphicsObject:
    "PySide2.QtWidgets.QGraphicsObject.__init__": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsObject.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGraphicsObject.grabGesture": ('PySide2.QtCore.Qt.GestureType', 'PySide2.QtCore.Qt.GestureFlags'),
    "PySide2.QtWidgets.QGraphicsObject.ungrabGesture": ('PySide2.QtCore.Qt.GestureType',),
    "PySide2.QtWidgets.QGraphicsObject.updateMicroFocus": (),

# class PySide2.QtWidgets.QGraphicsOpacityEffect:
    "PySide2.QtWidgets.QGraphicsOpacityEffect.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QGraphicsOpacityEffect.draw": ('PySide2.QtGui.QPainter',),
    "PySide2.QtWidgets.QGraphicsOpacityEffect.opacity": (),
    "PySide2.QtWidgets.QGraphicsOpacityEffect.opacityMask": (),
    "PySide2.QtWidgets.QGraphicsOpacityEffect.setOpacity": ('float',),
    "PySide2.QtWidgets.QGraphicsOpacityEffect.setOpacityMask": ('PySide2.QtGui.QBrush',),

# class PySide2.QtWidgets.QGraphicsPathItem:
    "PySide2.QtWidgets.QGraphicsPathItem.__init__": [('PySide2.QtGui.QPainterPath', 'PySide2.QtWidgets.QGraphicsItem'), ('PySide2.QtWidgets.QGraphicsItem',)],
    "PySide2.QtWidgets.QGraphicsPathItem.boundingRect": (),
    "PySide2.QtWidgets.QGraphicsPathItem.contains": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsPathItem.extension": ('typing.Any',),
    "PySide2.QtWidgets.QGraphicsPathItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsPathItem.opaqueArea": (),
    "PySide2.QtWidgets.QGraphicsPathItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QGraphicsPathItem.path": (),
    "PySide2.QtWidgets.QGraphicsPathItem.setPath": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtWidgets.QGraphicsPathItem.shape": (),
    "PySide2.QtWidgets.QGraphicsPathItem.type": (),

# class PySide2.QtWidgets.QGraphicsPixmapItem:

# class PySide2.QtWidgets.QGraphicsPixmapItem.ShapeMode:
    "PySide2.QtWidgets.QGraphicsPixmapItem.__init__": [('PySide2.QtGui.QPixmap', 'PySide2.QtWidgets.QGraphicsItem'), ('PySide2.QtWidgets.QGraphicsItem',)],
    "PySide2.QtWidgets.QGraphicsPixmapItem.boundingRect": (),
    "PySide2.QtWidgets.QGraphicsPixmapItem.contains": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsPixmapItem.extension": ('typing.Any',),
    "PySide2.QtWidgets.QGraphicsPixmapItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsPixmapItem.offset": (),
    "PySide2.QtWidgets.QGraphicsPixmapItem.opaqueArea": (),
    "PySide2.QtWidgets.QGraphicsPixmapItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QGraphicsPixmapItem.pixmap": (),
    "PySide2.QtWidgets.QGraphicsPixmapItem.setOffset": [('PySide2.QtCore.QPointF',), ('float', 'float')],
    "PySide2.QtWidgets.QGraphicsPixmapItem.setPixmap": ('PySide2.QtGui.QPixmap',),
    "PySide2.QtWidgets.QGraphicsPixmapItem.setShapeMode": ('PySide2.QtWidgets.QGraphicsPixmapItem.ShapeMode',),
    "PySide2.QtWidgets.QGraphicsPixmapItem.setTransformationMode": ('PySide2.QtCore.Qt.TransformationMode',),
    "PySide2.QtWidgets.QGraphicsPixmapItem.shape": (),
    "PySide2.QtWidgets.QGraphicsPixmapItem.shapeMode": (),
    "PySide2.QtWidgets.QGraphicsPixmapItem.transformationMode": (),
    "PySide2.QtWidgets.QGraphicsPixmapItem.type": (),

# class PySide2.QtWidgets.QGraphicsPolygonItem:
    "PySide2.QtWidgets.QGraphicsPolygonItem.__init__": [('PySide2.QtGui.QPolygonF', 'PySide2.QtWidgets.QGraphicsItem'), ('PySide2.QtWidgets.QGraphicsItem',)],
    "PySide2.QtWidgets.QGraphicsPolygonItem.boundingRect": (),
    "PySide2.QtWidgets.QGraphicsPolygonItem.contains": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsPolygonItem.extension": ('typing.Any',),
    "PySide2.QtWidgets.QGraphicsPolygonItem.fillRule": (),
    "PySide2.QtWidgets.QGraphicsPolygonItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsPolygonItem.opaqueArea": (),
    "PySide2.QtWidgets.QGraphicsPolygonItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QGraphicsPolygonItem.polygon": (),
    "PySide2.QtWidgets.QGraphicsPolygonItem.setFillRule": ('PySide2.QtCore.Qt.FillRule',),
    "PySide2.QtWidgets.QGraphicsPolygonItem.setPolygon": ('PySide2.QtGui.QPolygonF',),
    "PySide2.QtWidgets.QGraphicsPolygonItem.shape": (),
    "PySide2.QtWidgets.QGraphicsPolygonItem.type": (),

# class PySide2.QtWidgets.QGraphicsProxyWidget:
    "PySide2.QtWidgets.QGraphicsProxyWidget.__init__": ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.Qt.WindowFlags'),
    "PySide2.QtWidgets.QGraphicsProxyWidget.contextMenuEvent": ('PySide2.QtWidgets.QGraphicsSceneContextMenuEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.createProxyForChildWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.dragEnterEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.dragLeaveEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.dragMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.dropEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QGraphicsProxyWidget.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.focusNextPrevChild": ('bool',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.grabMouseEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.hideEvent": ('PySide2.QtGui.QHideEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.hoverEnterEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.hoverLeaveEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.hoverMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.inputMethodQuery": ('PySide2.QtCore.Qt.InputMethodQuery',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.itemChange": ('PySide2.QtWidgets.QGraphicsItem.GraphicsItemChange', 'typing.Any'),
    "PySide2.QtWidgets.QGraphicsProxyWidget.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.mouseDoubleClickEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.mouseMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.mousePressEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.mouseReleaseEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.newProxyWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QGraphicsProxyWidget.resizeEvent": ('PySide2.QtWidgets.QGraphicsSceneResizeEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.setGeometry": ('PySide2.QtCore.QRectF',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.setWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.sizeHint": ('PySide2.QtCore.Qt.SizeHint', 'PySide2.QtCore.QSizeF'),
    "PySide2.QtWidgets.QGraphicsProxyWidget.subWidgetRect": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.type": (),
    "PySide2.QtWidgets.QGraphicsProxyWidget.ungrabMouseEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.wheelEvent": ('PySide2.QtWidgets.QGraphicsSceneWheelEvent',),
    "PySide2.QtWidgets.QGraphicsProxyWidget.widget": (),

# class PySide2.QtWidgets.QGraphicsRectItem:
    "PySide2.QtWidgets.QGraphicsRectItem.__init__": [('PySide2.QtCore.QRectF', 'PySide2.QtWidgets.QGraphicsItem'), ('PySide2.QtWidgets.QGraphicsItem',), ('float', 'float', 'float', 'float', 'PySide2.QtWidgets.QGraphicsItem')],
    "PySide2.QtWidgets.QGraphicsRectItem.boundingRect": (),
    "PySide2.QtWidgets.QGraphicsRectItem.contains": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsRectItem.extension": ('typing.Any',),
    "PySide2.QtWidgets.QGraphicsRectItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsRectItem.opaqueArea": (),
    "PySide2.QtWidgets.QGraphicsRectItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QGraphicsRectItem.rect": (),
    "PySide2.QtWidgets.QGraphicsRectItem.setRect": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsRectItem.shape": (),
    "PySide2.QtWidgets.QGraphicsRectItem.type": (),

# class PySide2.QtWidgets.QGraphicsRotation:
    "PySide2.QtWidgets.QGraphicsRotation.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QGraphicsRotation.angle": (),
    "PySide2.QtWidgets.QGraphicsRotation.applyTo": ('PySide2.QtGui.QMatrix4x4',),
    "PySide2.QtWidgets.QGraphicsRotation.axis": (),
    "PySide2.QtWidgets.QGraphicsRotation.origin": (),
    "PySide2.QtWidgets.QGraphicsRotation.setAngle": ('float',),
    "PySide2.QtWidgets.QGraphicsRotation.setAxis": [('PySide2.QtCore.Qt.Axis',), ('PySide2.QtGui.QVector3D',)],
    "PySide2.QtWidgets.QGraphicsRotation.setOrigin": ('PySide2.QtGui.QVector3D',),

# class PySide2.QtWidgets.QGraphicsScale:
    "PySide2.QtWidgets.QGraphicsScale.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QGraphicsScale.applyTo": ('PySide2.QtGui.QMatrix4x4',),
    "PySide2.QtWidgets.QGraphicsScale.origin": (),
    "PySide2.QtWidgets.QGraphicsScale.setOrigin": ('PySide2.QtGui.QVector3D',),
    "PySide2.QtWidgets.QGraphicsScale.setXScale": ('float',),
    "PySide2.QtWidgets.QGraphicsScale.setYScale": ('float',),
    "PySide2.QtWidgets.QGraphicsScale.setZScale": ('float',),
    "PySide2.QtWidgets.QGraphicsScale.xScale": (),
    "PySide2.QtWidgets.QGraphicsScale.yScale": (),
    "PySide2.QtWidgets.QGraphicsScale.zScale": (),

# class PySide2.QtWidgets.QGraphicsScene:

# class PySide2.QtWidgets.QGraphicsScene.ItemIndexMethod:

# class PySide2.QtWidgets.QGraphicsScene.SceneLayer:

# class PySide2.QtWidgets.QGraphicsScene.SceneLayers:
    "PySide2.QtWidgets.QGraphicsScene.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtCore.QRectF', 'PySide2.QtCore.QObject'), ('float', 'float', 'float', 'float', 'PySide2.QtCore.QObject')],
    "PySide2.QtWidgets.QGraphicsScene.activePanel": (),
    "PySide2.QtWidgets.QGraphicsScene.activeWindow": (),
    "PySide2.QtWidgets.QGraphicsScene.addEllipse": [('PySide2.QtCore.QRectF', 'PySide2.QtGui.QPen', 'PySide2.QtGui.QBrush'), ('float', 'float', 'float', 'float', 'PySide2.QtGui.QPen', 'PySide2.QtGui.QBrush')],
    "PySide2.QtWidgets.QGraphicsScene.addItem": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsScene.addLine": [('PySide2.QtCore.QLineF', 'PySide2.QtGui.QPen'), ('float', 'float', 'float', 'float', 'PySide2.QtGui.QPen')],
    "PySide2.QtWidgets.QGraphicsScene.addPath": ('PySide2.QtGui.QPainterPath', 'PySide2.QtGui.QPen', 'PySide2.QtGui.QBrush'),
    "PySide2.QtWidgets.QGraphicsScene.addPixmap": ('PySide2.QtGui.QPixmap',),
    "PySide2.QtWidgets.QGraphicsScene.addPolygon": ('PySide2.QtGui.QPolygonF', 'PySide2.QtGui.QPen', 'PySide2.QtGui.QBrush'),
    "PySide2.QtWidgets.QGraphicsScene.addRect": [('PySide2.QtCore.QRectF', 'PySide2.QtGui.QPen', 'PySide2.QtGui.QBrush'), ('float', 'float', 'float', 'float', 'PySide2.QtGui.QPen', 'PySide2.QtGui.QBrush')],
    "PySide2.QtWidgets.QGraphicsScene.addSimpleText": ('str', 'PySide2.QtGui.QFont'),
    "PySide2.QtWidgets.QGraphicsScene.addText": ('str', 'PySide2.QtGui.QFont'),
    "PySide2.QtWidgets.QGraphicsScene.addWidget": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
    "PySide2.QtWidgets.QGraphicsScene.advance": (),
    "PySide2.QtWidgets.QGraphicsScene.backgroundBrush": (),
    "PySide2.QtWidgets.QGraphicsScene.bspTreeDepth": (),
    "PySide2.QtWidgets.QGraphicsScene.clear": (),
    "PySide2.QtWidgets.QGraphicsScene.clearFocus": (),
    "PySide2.QtWidgets.QGraphicsScene.clearSelection": (),
    "PySide2.QtWidgets.QGraphicsScene.collidingItems": ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.Qt.ItemSelectionMode'),
    "PySide2.QtWidgets.QGraphicsScene.contextMenuEvent": ('PySide2.QtWidgets.QGraphicsSceneContextMenuEvent',),
    "PySide2.QtWidgets.QGraphicsScene.createItemGroup": ('typing.Sequence',),
    "PySide2.QtWidgets.QGraphicsScene.destroyItemGroup": ('PySide2.QtWidgets.QGraphicsItemGroup',),
    "PySide2.QtWidgets.QGraphicsScene.dragEnterEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
    "PySide2.QtWidgets.QGraphicsScene.dragLeaveEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
    "PySide2.QtWidgets.QGraphicsScene.dragMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
    "PySide2.QtWidgets.QGraphicsScene.drawBackground": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF'),
    "PySide2.QtWidgets.QGraphicsScene.drawForeground": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF'),
    "PySide2.QtWidgets.QGraphicsScene.dropEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
    "PySide2.QtWidgets.QGraphicsScene.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGraphicsScene.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QGraphicsScene.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QGraphicsScene.focusItem": (),
    "PySide2.QtWidgets.QGraphicsScene.focusNextPrevChild": ('bool',),
    "PySide2.QtWidgets.QGraphicsScene.focusOnTouch": (),
    "PySide2.QtWidgets.QGraphicsScene.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QGraphicsScene.font": (),
    "PySide2.QtWidgets.QGraphicsScene.foregroundBrush": (),
    "PySide2.QtWidgets.QGraphicsScene.hasFocus": (),
    "PySide2.QtWidgets.QGraphicsScene.height": (),
    "PySide2.QtWidgets.QGraphicsScene.helpEvent": ('PySide2.QtWidgets.QGraphicsSceneHelpEvent',),
    "PySide2.QtWidgets.QGraphicsScene.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
    "PySide2.QtWidgets.QGraphicsScene.inputMethodQuery": ('PySide2.QtCore.Qt.InputMethodQuery',),
    "PySide2.QtWidgets.QGraphicsScene.invalidate": [('PySide2.QtCore.QRectF', 'PySide2.QtWidgets.QGraphicsScene.SceneLayers'), ('float', 'float', 'float', 'float', 'PySide2.QtWidgets.QGraphicsScene.SceneLayers')],
    "PySide2.QtWidgets.QGraphicsScene.isActive": (),
    "PySide2.QtWidgets.QGraphicsScene.isSortCacheEnabled": (),
    "PySide2.QtWidgets.QGraphicsScene.itemAt": [('PySide2.QtCore.QPointF', 'PySide2.QtGui.QTransform'), ('float', 'float', 'PySide2.QtGui.QTransform')],
    "PySide2.QtWidgets.QGraphicsScene.itemIndexMethod": (),
    "PySide2.QtWidgets.QGraphicsScene.items": [('PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.ItemSelectionMode', 'PySide2.QtCore.Qt.SortOrder', 'PySide2.QtGui.QTransform'), ('PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.ItemSelectionMode', 'PySide2.QtCore.Qt.SortOrder', 'PySide2.QtGui.QTransform'), ('PySide2.QtCore.Qt.SortOrder',), ('PySide2.QtGui.QPainterPath', 'PySide2.QtCore.Qt.ItemSelectionMode', 'PySide2.QtCore.Qt.SortOrder', 'PySide2.QtGui.QTransform'), ('PySide2.QtGui.QPolygonF', 'PySide2.QtCore.Qt.ItemSelectionMode', 'PySide2.QtCore.Qt.SortOrder', 'PySide2.QtGui.QTransform'), ('float', 'float', 'float', 'float', 'PySide2.QtCore.Qt.ItemSelectionMode', 'PySide2.QtCore.Qt.SortOrder', 'PySide2.QtGui.QTransform')],
    "PySide2.QtWidgets.QGraphicsScene.itemsBoundingRect": (),
    "PySide2.QtWidgets.QGraphicsScene.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QGraphicsScene.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QGraphicsScene.minimumRenderSize": (),
    "PySide2.QtWidgets.QGraphicsScene.mouseDoubleClickEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
    "PySide2.QtWidgets.QGraphicsScene.mouseGrabberItem": (),
    "PySide2.QtWidgets.QGraphicsScene.mouseMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
    "PySide2.QtWidgets.QGraphicsScene.mousePressEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
    "PySide2.QtWidgets.QGraphicsScene.mouseReleaseEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
    "PySide2.QtWidgets.QGraphicsScene.palette": (),
    "PySide2.QtWidgets.QGraphicsScene.removeItem": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsScene.render": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF', 'PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.AspectRatioMode'),
    "PySide2.QtWidgets.QGraphicsScene.sceneRect": (),
    "PySide2.QtWidgets.QGraphicsScene.selectedItems": (),
    "PySide2.QtWidgets.QGraphicsScene.selectionArea": (),
    "PySide2.QtWidgets.QGraphicsScene.sendEvent": ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QGraphicsScene.setActivePanel": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsScene.setActiveWindow": ('PySide2.QtWidgets.QGraphicsWidget',),
    "PySide2.QtWidgets.QGraphicsScene.setBackgroundBrush": ('PySide2.QtGui.QBrush',),
    "PySide2.QtWidgets.QGraphicsScene.setBspTreeDepth": ('int',),
    "PySide2.QtWidgets.QGraphicsScene.setFocus": ('PySide2.QtCore.Qt.FocusReason',),
    "PySide2.QtWidgets.QGraphicsScene.setFocusItem": ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.Qt.FocusReason'),
    "PySide2.QtWidgets.QGraphicsScene.setFocusOnTouch": ('bool',),
    "PySide2.QtWidgets.QGraphicsScene.setFont": ('PySide2.QtGui.QFont',),
    "PySide2.QtWidgets.QGraphicsScene.setForegroundBrush": ('PySide2.QtGui.QBrush',),
    "PySide2.QtWidgets.QGraphicsScene.setItemIndexMethod": ('PySide2.QtWidgets.QGraphicsScene.ItemIndexMethod',),
    "PySide2.QtWidgets.QGraphicsScene.setMinimumRenderSize": ('float',),
    "PySide2.QtWidgets.QGraphicsScene.setPalette": ('PySide2.QtGui.QPalette',),
    "PySide2.QtWidgets.QGraphicsScene.setSceneRect": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsScene.setSelectionArea": [('PySide2.QtGui.QPainterPath', 'PySide2.QtCore.Qt.ItemSelectionMode', 'PySide2.QtGui.QTransform'), ('PySide2.QtGui.QPainterPath', 'PySide2.QtCore.Qt.ItemSelectionOperation', 'PySide2.QtCore.Qt.ItemSelectionMode', 'PySide2.QtGui.QTransform'), ('PySide2.QtGui.QPainterPath', 'PySide2.QtGui.QTransform')],
    "PySide2.QtWidgets.QGraphicsScene.setSortCacheEnabled": ('bool',),
    "PySide2.QtWidgets.QGraphicsScene.setStickyFocus": ('bool',),
    "PySide2.QtWidgets.QGraphicsScene.setStyle": ('PySide2.QtWidgets.QStyle',),
    "PySide2.QtWidgets.QGraphicsScene.stickyFocus": (),
    "PySide2.QtWidgets.QGraphicsScene.style": (),
    "PySide2.QtWidgets.QGraphicsScene.update": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsScene.views": (),
    "PySide2.QtWidgets.QGraphicsScene.wheelEvent": ('PySide2.QtWidgets.QGraphicsSceneWheelEvent',),
    "PySide2.QtWidgets.QGraphicsScene.width": (),

# class PySide2.QtWidgets.QGraphicsSceneContextMenuEvent:

# class PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.Reason:
    "PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.__init__": ('PySide2.QtCore.QEvent.Type',),
    "PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.modifiers": (),
    "PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.pos": (),
    "PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.reason": (),
    "PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.scenePos": (),
    "PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.screenPos": (),
    "PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.setModifiers": ('PySide2.QtCore.Qt.KeyboardModifiers',),
    "PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.setPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.setReason": ('PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.Reason',),
    "PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.setScenePos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.setScreenPos": ('PySide2.QtCore.QPoint',),

# class PySide2.QtWidgets.QGraphicsSceneDragDropEvent:
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.__init__": ('PySide2.QtCore.QEvent.Type',),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.acceptProposedAction": (),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.buttons": (),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.dropAction": (),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.mimeData": (),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.modifiers": (),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.pos": (),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.possibleActions": (),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.proposedAction": (),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.scenePos": (),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.screenPos": (),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setButtons": ('PySide2.QtCore.Qt.MouseButtons',),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setDropAction": ('PySide2.QtCore.Qt.DropAction',),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setModifiers": ('PySide2.QtCore.Qt.KeyboardModifiers',),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setPossibleActions": ('PySide2.QtCore.Qt.DropActions',),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setProposedAction": ('PySide2.QtCore.Qt.DropAction',),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setScenePos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setScreenPos": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.source": (),

# class PySide2.QtWidgets.QGraphicsSceneEvent:
    "PySide2.QtWidgets.QGraphicsSceneEvent.__init__": ('PySide2.QtCore.QEvent.Type',),
    "PySide2.QtWidgets.QGraphicsSceneEvent.widget": (),

# class PySide2.QtWidgets.QGraphicsSceneHelpEvent:
    "PySide2.QtWidgets.QGraphicsSceneHelpEvent.__init__": ('PySide2.QtCore.QEvent.Type',),
    "PySide2.QtWidgets.QGraphicsSceneHelpEvent.scenePos": (),
    "PySide2.QtWidgets.QGraphicsSceneHelpEvent.screenPos": (),
    "PySide2.QtWidgets.QGraphicsSceneHelpEvent.setScenePos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsSceneHelpEvent.setScreenPos": ('PySide2.QtCore.QPoint',),

# class PySide2.QtWidgets.QGraphicsSceneHoverEvent:
    "PySide2.QtWidgets.QGraphicsSceneHoverEvent.__init__": ('PySide2.QtCore.QEvent.Type',),
    "PySide2.QtWidgets.QGraphicsSceneHoverEvent.lastPos": (),
    "PySide2.QtWidgets.QGraphicsSceneHoverEvent.lastScenePos": (),
    "PySide2.QtWidgets.QGraphicsSceneHoverEvent.lastScreenPos": (),
    "PySide2.QtWidgets.QGraphicsSceneHoverEvent.modifiers": (),
    "PySide2.QtWidgets.QGraphicsSceneHoverEvent.pos": (),
    "PySide2.QtWidgets.QGraphicsSceneHoverEvent.scenePos": (),
    "PySide2.QtWidgets.QGraphicsSceneHoverEvent.screenPos": (),
    "PySide2.QtWidgets.QGraphicsSceneHoverEvent.setLastPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsSceneHoverEvent.setLastScenePos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsSceneHoverEvent.setLastScreenPos": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QGraphicsSceneHoverEvent.setModifiers": ('PySide2.QtCore.Qt.KeyboardModifiers',),
    "PySide2.QtWidgets.QGraphicsSceneHoverEvent.setPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsSceneHoverEvent.setScenePos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsSceneHoverEvent.setScreenPos": ('PySide2.QtCore.QPoint',),

# class PySide2.QtWidgets.QGraphicsSceneMouseEvent:
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.__init__": ('PySide2.QtCore.QEvent.Type',),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.button": (),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.buttonDownPos": ('PySide2.QtCore.Qt.MouseButton',),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.buttonDownScenePos": ('PySide2.QtCore.Qt.MouseButton',),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.buttonDownScreenPos": ('PySide2.QtCore.Qt.MouseButton',),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.buttons": (),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.flags": (),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.lastPos": (),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.lastScenePos": (),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.lastScreenPos": (),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.modifiers": (),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.pos": (),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.scenePos": (),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.screenPos": (),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.setButton": ('PySide2.QtCore.Qt.MouseButton',),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.setButtonDownPos": ('PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.QPointF'),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.setButtonDownScenePos": ('PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.QPointF'),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.setButtonDownScreenPos": ('PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.QPoint'),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.setButtons": ('PySide2.QtCore.Qt.MouseButtons',),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.setFlags": ('PySide2.QtCore.Qt.MouseEventFlags',),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.setLastPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.setLastScenePos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.setLastScreenPos": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.setModifiers": ('PySide2.QtCore.Qt.KeyboardModifiers',),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.setPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.setScenePos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.setScreenPos": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.setSource": ('PySide2.QtCore.Qt.MouseEventSource',),
    "PySide2.QtWidgets.QGraphicsSceneMouseEvent.source": (),

# class PySide2.QtWidgets.QGraphicsSceneMoveEvent:
    "PySide2.QtWidgets.QGraphicsSceneMoveEvent.__init__": (),
    "PySide2.QtWidgets.QGraphicsSceneMoveEvent.newPos": (),
    "PySide2.QtWidgets.QGraphicsSceneMoveEvent.oldPos": (),
    "PySide2.QtWidgets.QGraphicsSceneMoveEvent.setNewPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsSceneMoveEvent.setOldPos": ('PySide2.QtCore.QPointF',),

# class PySide2.QtWidgets.QGraphicsSceneResizeEvent:
    "PySide2.QtWidgets.QGraphicsSceneResizeEvent.__init__": (),
    "PySide2.QtWidgets.QGraphicsSceneResizeEvent.newSize": (),
    "PySide2.QtWidgets.QGraphicsSceneResizeEvent.oldSize": (),
    "PySide2.QtWidgets.QGraphicsSceneResizeEvent.setNewSize": ('PySide2.QtCore.QSizeF',),
    "PySide2.QtWidgets.QGraphicsSceneResizeEvent.setOldSize": ('PySide2.QtCore.QSizeF',),

# class PySide2.QtWidgets.QGraphicsSceneWheelEvent:
    "PySide2.QtWidgets.QGraphicsSceneWheelEvent.__init__": ('PySide2.QtCore.QEvent.Type',),
    "PySide2.QtWidgets.QGraphicsSceneWheelEvent.buttons": (),
    "PySide2.QtWidgets.QGraphicsSceneWheelEvent.delta": (),
    "PySide2.QtWidgets.QGraphicsSceneWheelEvent.modifiers": (),
    "PySide2.QtWidgets.QGraphicsSceneWheelEvent.orientation": (),
    "PySide2.QtWidgets.QGraphicsSceneWheelEvent.pos": (),
    "PySide2.QtWidgets.QGraphicsSceneWheelEvent.scenePos": (),
    "PySide2.QtWidgets.QGraphicsSceneWheelEvent.screenPos": (),
    "PySide2.QtWidgets.QGraphicsSceneWheelEvent.setButtons": ('PySide2.QtCore.Qt.MouseButtons',),
    "PySide2.QtWidgets.QGraphicsSceneWheelEvent.setDelta": ('int',),
    "PySide2.QtWidgets.QGraphicsSceneWheelEvent.setModifiers": ('PySide2.QtCore.Qt.KeyboardModifiers',),
    "PySide2.QtWidgets.QGraphicsSceneWheelEvent.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
    "PySide2.QtWidgets.QGraphicsSceneWheelEvent.setPos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsSceneWheelEvent.setScenePos": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsSceneWheelEvent.setScreenPos": ('PySide2.QtCore.QPoint',),

# class PySide2.QtWidgets.QGraphicsSimpleTextItem:
    "PySide2.QtWidgets.QGraphicsSimpleTextItem.__init__": [('PySide2.QtWidgets.QGraphicsItem',), ('str', 'PySide2.QtWidgets.QGraphicsItem')],
    "PySide2.QtWidgets.QGraphicsSimpleTextItem.boundingRect": (),
    "PySide2.QtWidgets.QGraphicsSimpleTextItem.contains": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsSimpleTextItem.extension": ('typing.Any',),
    "PySide2.QtWidgets.QGraphicsSimpleTextItem.font": (),
    "PySide2.QtWidgets.QGraphicsSimpleTextItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsSimpleTextItem.opaqueArea": (),
    "PySide2.QtWidgets.QGraphicsSimpleTextItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QGraphicsSimpleTextItem.setFont": ('PySide2.QtGui.QFont',),
    "PySide2.QtWidgets.QGraphicsSimpleTextItem.setText": ('str',),
    "PySide2.QtWidgets.QGraphicsSimpleTextItem.shape": (),
    "PySide2.QtWidgets.QGraphicsSimpleTextItem.text": (),
    "PySide2.QtWidgets.QGraphicsSimpleTextItem.type": (),

# class PySide2.QtWidgets.QGraphicsTextItem:
    "PySide2.QtWidgets.QGraphicsTextItem.__init__": [('PySide2.QtWidgets.QGraphicsItem',), ('str', 'PySide2.QtWidgets.QGraphicsItem')],
    "PySide2.QtWidgets.QGraphicsTextItem.adjustSize": (),
    "PySide2.QtWidgets.QGraphicsTextItem.boundingRect": (),
    "PySide2.QtWidgets.QGraphicsTextItem.contains": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsTextItem.contextMenuEvent": ('PySide2.QtWidgets.QGraphicsSceneContextMenuEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.defaultTextColor": (),
    "PySide2.QtWidgets.QGraphicsTextItem.document": (),
    "PySide2.QtWidgets.QGraphicsTextItem.dragEnterEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.dragLeaveEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.dragMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.dropEvent": ('PySide2.QtWidgets.QGraphicsSceneDragDropEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.extension": ('typing.Any',),
    "PySide2.QtWidgets.QGraphicsTextItem.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.font": (),
    "PySide2.QtWidgets.QGraphicsTextItem.hoverEnterEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.hoverLeaveEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.hoverMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.inputMethodQuery": ('PySide2.QtCore.Qt.InputMethodQuery',),
    "PySide2.QtWidgets.QGraphicsTextItem.isObscuredBy": ('PySide2.QtWidgets.QGraphicsItem',),
    "PySide2.QtWidgets.QGraphicsTextItem.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.mouseDoubleClickEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.mouseMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.mousePressEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.mouseReleaseEvent": ('PySide2.QtWidgets.QGraphicsSceneMouseEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.opaqueArea": (),
    "PySide2.QtWidgets.QGraphicsTextItem.openExternalLinks": (),
    "PySide2.QtWidgets.QGraphicsTextItem.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QGraphicsTextItem.sceneEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGraphicsTextItem.setDefaultTextColor": ('PySide2.QtGui.QColor',),
    "PySide2.QtWidgets.QGraphicsTextItem.setDocument": ('PySide2.QtGui.QTextDocument',),
    "PySide2.QtWidgets.QGraphicsTextItem.setFont": ('PySide2.QtGui.QFont',),
    "PySide2.QtWidgets.QGraphicsTextItem.setHtml": ('str',),
    "PySide2.QtWidgets.QGraphicsTextItem.setOpenExternalLinks": ('bool',),
    "PySide2.QtWidgets.QGraphicsTextItem.setPlainText": ('str',),
    "PySide2.QtWidgets.QGraphicsTextItem.setTabChangesFocus": ('bool',),
    "PySide2.QtWidgets.QGraphicsTextItem.setTextCursor": ('PySide2.QtGui.QTextCursor',),
    "PySide2.QtWidgets.QGraphicsTextItem.setTextInteractionFlags": ('PySide2.QtCore.Qt.TextInteractionFlags',),
    "PySide2.QtWidgets.QGraphicsTextItem.setTextWidth": ('float',),
    "PySide2.QtWidgets.QGraphicsTextItem.shape": (),
    "PySide2.QtWidgets.QGraphicsTextItem.tabChangesFocus": (),
    "PySide2.QtWidgets.QGraphicsTextItem.textCursor": (),
    "PySide2.QtWidgets.QGraphicsTextItem.textInteractionFlags": (),
    "PySide2.QtWidgets.QGraphicsTextItem.textWidth": (),
    "PySide2.QtWidgets.QGraphicsTextItem.toHtml": (),
    "PySide2.QtWidgets.QGraphicsTextItem.toPlainText": (),
    "PySide2.QtWidgets.QGraphicsTextItem.type": (),

# class PySide2.QtWidgets.QGraphicsTransform:
    "PySide2.QtWidgets.QGraphicsTransform.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QGraphicsTransform.applyTo": ('PySide2.QtGui.QMatrix4x4',),
    "PySide2.QtWidgets.QGraphicsTransform.update": (),

# class PySide2.QtWidgets.QGraphicsView:

# class PySide2.QtWidgets.QGraphicsView.CacheMode:

# class PySide2.QtWidgets.QGraphicsView.CacheModeFlag:

# class PySide2.QtWidgets.QGraphicsView.DragMode:

# class PySide2.QtWidgets.QGraphicsView.OptimizationFlag:

# class PySide2.QtWidgets.QGraphicsView.OptimizationFlags:

# class PySide2.QtWidgets.QGraphicsView.ViewportAnchor:

# class PySide2.QtWidgets.QGraphicsView.ViewportUpdateMode:
    "PySide2.QtWidgets.QGraphicsView.__init__": [('PySide2.QtWidgets.QGraphicsScene', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QGraphicsView.alignment": (),
    "PySide2.QtWidgets.QGraphicsView.backgroundBrush": (),
    "PySide2.QtWidgets.QGraphicsView.cacheMode": (),
    "PySide2.QtWidgets.QGraphicsView.centerOn": [('PySide2.QtCore.QPointF',), ('PySide2.QtWidgets.QGraphicsItem',), ('float', 'float')],
    "PySide2.QtWidgets.QGraphicsView.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
    "PySide2.QtWidgets.QGraphicsView.dragEnterEvent": ('PySide2.QtGui.QDragEnterEvent',),
    "PySide2.QtWidgets.QGraphicsView.dragLeaveEvent": ('PySide2.QtGui.QDragLeaveEvent',),
    "PySide2.QtWidgets.QGraphicsView.dragMode": (),
    "PySide2.QtWidgets.QGraphicsView.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
    "PySide2.QtWidgets.QGraphicsView.drawBackground": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF'),
    "PySide2.QtWidgets.QGraphicsView.drawForeground": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF'),
    "PySide2.QtWidgets.QGraphicsView.drawItems": ('PySide2.QtGui.QPainter', 'int', 'typing.Sequence', 'typing.Sequence'),
    "PySide2.QtWidgets.QGraphicsView.dropEvent": ('PySide2.QtGui.QDropEvent',),
    "PySide2.QtWidgets.QGraphicsView.ensureVisible": [('PySide2.QtCore.QRectF', 'int', 'int'), ('PySide2.QtWidgets.QGraphicsItem', 'int', 'int'), ('float', 'float', 'float', 'float', 'int', 'int')],
    "PySide2.QtWidgets.QGraphicsView.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGraphicsView.fitInView": [('PySide2.QtCore.QRectF', 'PySide2.QtCore.Qt.AspectRatioMode'), ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.Qt.AspectRatioMode'), ('float', 'float', 'float', 'float', 'PySide2.QtCore.Qt.AspectRatioMode')],
    "PySide2.QtWidgets.QGraphicsView.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QGraphicsView.focusNextPrevChild": ('bool',),
    "PySide2.QtWidgets.QGraphicsView.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QGraphicsView.foregroundBrush": (),
    "PySide2.QtWidgets.QGraphicsView.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
    "PySide2.QtWidgets.QGraphicsView.inputMethodQuery": ('PySide2.QtCore.Qt.InputMethodQuery',),
    "PySide2.QtWidgets.QGraphicsView.invalidateScene": ('PySide2.QtCore.QRectF', 'PySide2.QtWidgets.QGraphicsScene.SceneLayers'),
    "PySide2.QtWidgets.QGraphicsView.isInteractive": (),
    "PySide2.QtWidgets.QGraphicsView.isTransformed": (),
    "PySide2.QtWidgets.QGraphicsView.itemAt": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtWidgets.QGraphicsView.items": [(), ('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.ItemSelectionMode'), ('PySide2.QtGui.QPainterPath', 'PySide2.QtCore.Qt.ItemSelectionMode'), ('PySide2.QtGui.QPolygon', 'PySide2.QtCore.Qt.ItemSelectionMode'), ('int', 'int'), ('int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.ItemSelectionMode')],
    "PySide2.QtWidgets.QGraphicsView.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QGraphicsView.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QGraphicsView.mapFromScene": [('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QRectF',), ('PySide2.QtGui.QPainterPath',), ('PySide2.QtGui.QPolygonF',), ('float', 'float'), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsView.mapToScene": [('PySide2.QtCore.QPoint',), ('PySide2.QtCore.QRect',), ('PySide2.QtGui.QPainterPath',), ('PySide2.QtGui.QPolygon',), ('int', 'int'), ('int', 'int', 'int', 'int')],
    "PySide2.QtWidgets.QGraphicsView.matrix": (),
    "PySide2.QtWidgets.QGraphicsView.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QGraphicsView.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QGraphicsView.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QGraphicsView.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QGraphicsView.optimizationFlags": (),
    "PySide2.QtWidgets.QGraphicsView.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QGraphicsView.render": [('PySide2.QtGui.QPaintDevice', 'PySide2.QtCore.QPoint', 'PySide2.QtGui.QRegion', 'PySide2.QtWidgets.QWidget.RenderFlags'), ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRectF', 'PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.AspectRatioMode')],
    "PySide2.QtWidgets.QGraphicsView.renderHints": (),
    "PySide2.QtWidgets.QGraphicsView.resetCachedContent": (),
    "PySide2.QtWidgets.QGraphicsView.resetMatrix": (),
    "PySide2.QtWidgets.QGraphicsView.resetTransform": (),
    "PySide2.QtWidgets.QGraphicsView.resizeAnchor": (),
    "PySide2.QtWidgets.QGraphicsView.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QGraphicsView.rotate": ('float',),
    "PySide2.QtWidgets.QGraphicsView.rubberBandRect": (),
    "PySide2.QtWidgets.QGraphicsView.rubberBandSelectionMode": (),
    "PySide2.QtWidgets.QGraphicsView.scale": ('float', 'float'),
    "PySide2.QtWidgets.QGraphicsView.scene": (),
    "PySide2.QtWidgets.QGraphicsView.sceneRect": (),
    "PySide2.QtWidgets.QGraphicsView.scrollContentsBy": ('int', 'int'),
    "PySide2.QtWidgets.QGraphicsView.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtWidgets.QGraphicsView.setBackgroundBrush": ('PySide2.QtGui.QBrush',),
    "PySide2.QtWidgets.QGraphicsView.setCacheMode": ('PySide2.QtWidgets.QGraphicsView.CacheMode',),
    "PySide2.QtWidgets.QGraphicsView.setDragMode": ('PySide2.QtWidgets.QGraphicsView.DragMode',),
    "PySide2.QtWidgets.QGraphicsView.setForegroundBrush": ('PySide2.QtGui.QBrush',),
    "PySide2.QtWidgets.QGraphicsView.setInteractive": ('bool',),
    "PySide2.QtWidgets.QGraphicsView.setMatrix": ('PySide2.QtGui.QMatrix', 'bool'),
    "PySide2.QtWidgets.QGraphicsView.setOptimizationFlag": ('PySide2.QtWidgets.QGraphicsView.OptimizationFlag', 'bool'),
    "PySide2.QtWidgets.QGraphicsView.setOptimizationFlags": ('PySide2.QtWidgets.QGraphicsView.OptimizationFlags',),
    "PySide2.QtWidgets.QGraphicsView.setRenderHint": ('PySide2.QtGui.QPainter.RenderHint', 'bool'),
    "PySide2.QtWidgets.QGraphicsView.setRenderHints": ('PySide2.QtGui.QPainter.RenderHints',),
    "PySide2.QtWidgets.QGraphicsView.setResizeAnchor": ('PySide2.QtWidgets.QGraphicsView.ViewportAnchor',),
    "PySide2.QtWidgets.QGraphicsView.setRubberBandSelectionMode": ('PySide2.QtCore.Qt.ItemSelectionMode',),
    "PySide2.QtWidgets.QGraphicsView.setScene": ('PySide2.QtWidgets.QGraphicsScene',),
    "PySide2.QtWidgets.QGraphicsView.setSceneRect": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsView.setTransform": ('PySide2.QtGui.QTransform', 'bool'),
    "PySide2.QtWidgets.QGraphicsView.setTransformationAnchor": ('PySide2.QtWidgets.QGraphicsView.ViewportAnchor',),
    "PySide2.QtWidgets.QGraphicsView.setViewportUpdateMode": ('PySide2.QtWidgets.QGraphicsView.ViewportUpdateMode',),
    "PySide2.QtWidgets.QGraphicsView.setupViewport": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QGraphicsView.shear": ('float', 'float'),
    "PySide2.QtWidgets.QGraphicsView.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QGraphicsView.sizeHint": (),
    "PySide2.QtWidgets.QGraphicsView.transform": (),
    "PySide2.QtWidgets.QGraphicsView.transformationAnchor": (),
    "PySide2.QtWidgets.QGraphicsView.translate": ('float', 'float'),
    "PySide2.QtWidgets.QGraphicsView.updateScene": ('typing.Sequence',),
    "PySide2.QtWidgets.QGraphicsView.updateSceneRect": ('PySide2.QtCore.QRectF',),
    "PySide2.QtWidgets.QGraphicsView.viewportEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGraphicsView.viewportTransform": (),
    "PySide2.QtWidgets.QGraphicsView.viewportUpdateMode": (),
    "PySide2.QtWidgets.QGraphicsView.wheelEvent": ('PySide2.QtGui.QWheelEvent',),

# class PySide2.QtWidgets.QGraphicsWidget:
    "PySide2.QtWidgets.QGraphicsWidget.__init__": ('PySide2.QtWidgets.QGraphicsItem', 'PySide2.QtCore.Qt.WindowFlags'),
    "PySide2.QtWidgets.QGraphicsWidget.actions": (),
    "PySide2.QtWidgets.QGraphicsWidget.addAction": ('PySide2.QtWidgets.QAction',),
    "PySide2.QtWidgets.QGraphicsWidget.addActions": ('typing.Sequence',),
    "PySide2.QtWidgets.QGraphicsWidget.adjustSize": (),
    "PySide2.QtWidgets.QGraphicsWidget.autoFillBackground": (),
    "PySide2.QtWidgets.QGraphicsWidget.boundingRect": (),
    "PySide2.QtWidgets.QGraphicsWidget.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGraphicsWidget.close": (),
    "PySide2.QtWidgets.QGraphicsWidget.closeEvent": ('PySide2.QtGui.QCloseEvent',),
    "PySide2.QtWidgets.QGraphicsWidget.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGraphicsWidget.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QGraphicsWidget.focusNextPrevChild": ('bool',),
    "PySide2.QtWidgets.QGraphicsWidget.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QGraphicsWidget.focusPolicy": (),
    "PySide2.QtWidgets.QGraphicsWidget.focusWidget": (),
    "PySide2.QtWidgets.QGraphicsWidget.font": (),
    "PySide2.QtWidgets.QGraphicsWidget.getContentsMargins": (),
    "PySide2.QtWidgets.QGraphicsWidget.getWindowFrameMargins": (),
    "PySide2.QtWidgets.QGraphicsWidget.grabKeyboardEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGraphicsWidget.grabMouseEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGraphicsWidget.grabShortcut": ('PySide2.QtGui.QKeySequence', 'PySide2.QtCore.Qt.ShortcutContext'),
    "PySide2.QtWidgets.QGraphicsWidget.hideEvent": ('PySide2.QtGui.QHideEvent',),
    "PySide2.QtWidgets.QGraphicsWidget.hoverLeaveEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
    "PySide2.QtWidgets.QGraphicsWidget.hoverMoveEvent": ('PySide2.QtWidgets.QGraphicsSceneHoverEvent',),
    "PySide2.QtWidgets.QGraphicsWidget.initStyleOption": ('PySide2.QtWidgets.QStyleOption',),
    "PySide2.QtWidgets.QGraphicsWidget.insertAction": ('PySide2.QtWidgets.QAction', 'PySide2.QtWidgets.QAction'),
    "PySide2.QtWidgets.QGraphicsWidget.insertActions": ('PySide2.QtWidgets.QAction', 'typing.Sequence'),
    "PySide2.QtWidgets.QGraphicsWidget.isActiveWindow": (),
    "PySide2.QtWidgets.QGraphicsWidget.itemChange": ('PySide2.QtWidgets.QGraphicsItem.GraphicsItemChange', 'typing.Any'),
    "PySide2.QtWidgets.QGraphicsWidget.layout": (),
    "PySide2.QtWidgets.QGraphicsWidget.layoutDirection": (),
    "PySide2.QtWidgets.QGraphicsWidget.moveEvent": ('PySide2.QtWidgets.QGraphicsSceneMoveEvent',),
    "PySide2.QtWidgets.QGraphicsWidget.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QGraphicsWidget.paintWindowFrame": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionGraphicsItem', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QGraphicsWidget.palette": (),
    "PySide2.QtWidgets.QGraphicsWidget.polishEvent": (),
    "PySide2.QtWidgets.QGraphicsWidget.propertyChange": ('str', 'typing.Any'),
    "PySide2.QtWidgets.QGraphicsWidget.rect": (),
    "PySide2.QtWidgets.QGraphicsWidget.releaseShortcut": ('int',),
    "PySide2.QtWidgets.QGraphicsWidget.removeAction": ('PySide2.QtWidgets.QAction',),
    "PySide2.QtWidgets.QGraphicsWidget.resize": [('PySide2.QtCore.QSizeF',), ('float', 'float')],
    "PySide2.QtWidgets.QGraphicsWidget.resizeEvent": ('PySide2.QtWidgets.QGraphicsSceneResizeEvent',),
    "PySide2.QtWidgets.QGraphicsWidget.sceneEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGraphicsWidget.setAttribute": ('PySide2.QtCore.Qt.WidgetAttribute', 'bool'),
    "PySide2.QtWidgets.QGraphicsWidget.setAutoFillBackground": ('bool',),
    "PySide2.QtWidgets.QGraphicsWidget.setContentsMargins": [('PySide2.QtCore.QMarginsF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsWidget.setFocusPolicy": ('PySide2.QtCore.Qt.FocusPolicy',),
    "PySide2.QtWidgets.QGraphicsWidget.setFont": ('PySide2.QtGui.QFont',),
    "PySide2.QtWidgets.QGraphicsWidget.setGeometry": [('PySide2.QtCore.QRectF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsWidget.setLayout": ('PySide2.QtWidgets.QGraphicsLayout',),
    "PySide2.QtWidgets.QGraphicsWidget.setLayoutDirection": ('PySide2.QtCore.Qt.LayoutDirection',),
    "PySide2.QtWidgets.QGraphicsWidget.setPalette": ('PySide2.QtGui.QPalette',),
    "PySide2.QtWidgets.QGraphicsWidget.setShortcutAutoRepeat": ('int', 'bool'),
    "PySide2.QtWidgets.QGraphicsWidget.setShortcutEnabled": ('int', 'bool'),
    "PySide2.QtWidgets.QGraphicsWidget.setStyle": ('PySide2.QtWidgets.QStyle',),
    "PySide2.QtWidgets.QGraphicsWidget.setTabOrder": ('PySide2.QtWidgets.QGraphicsWidget', 'PySide2.QtWidgets.QGraphicsWidget'),
    "PySide2.QtWidgets.QGraphicsWidget.setWindowFlags": ('PySide2.QtCore.Qt.WindowFlags',),
    "PySide2.QtWidgets.QGraphicsWidget.setWindowFrameMargins": [('PySide2.QtCore.QMarginsF',), ('float', 'float', 'float', 'float')],
    "PySide2.QtWidgets.QGraphicsWidget.setWindowTitle": ('str',),
    "PySide2.QtWidgets.QGraphicsWidget.shape": (),
    "PySide2.QtWidgets.QGraphicsWidget.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QGraphicsWidget.size": (),
    "PySide2.QtWidgets.QGraphicsWidget.sizeHint": ('PySide2.QtCore.Qt.SizeHint', 'PySide2.QtCore.QSizeF'),
    "PySide2.QtWidgets.QGraphicsWidget.style": (),
    "PySide2.QtWidgets.QGraphicsWidget.testAttribute": ('PySide2.QtCore.Qt.WidgetAttribute',),
    "PySide2.QtWidgets.QGraphicsWidget.type": (),
    "PySide2.QtWidgets.QGraphicsWidget.ungrabKeyboardEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGraphicsWidget.ungrabMouseEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGraphicsWidget.unsetLayoutDirection": (),
    "PySide2.QtWidgets.QGraphicsWidget.unsetWindowFrameMargins": (),
    "PySide2.QtWidgets.QGraphicsWidget.updateGeometry": (),
    "PySide2.QtWidgets.QGraphicsWidget.windowFlags": (),
    "PySide2.QtWidgets.QGraphicsWidget.windowFrameEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGraphicsWidget.windowFrameGeometry": (),
    "PySide2.QtWidgets.QGraphicsWidget.windowFrameRect": (),
    "PySide2.QtWidgets.QGraphicsWidget.windowFrameSectionAt": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QGraphicsWidget.windowTitle": (),
    "PySide2.QtWidgets.QGraphicsWidget.windowType": (),

# class PySide2.QtWidgets.QGridLayout:
    "PySide2.QtWidgets.QGridLayout.__init__": [(), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QGridLayout.addItem": [('PySide2.QtWidgets.QLayoutItem',), ('PySide2.QtWidgets.QLayoutItem', 'int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.Alignment')],
    "PySide2.QtWidgets.QGridLayout.addLayout": [('PySide2.QtWidgets.QLayout', 'int', 'int', 'PySide2.QtCore.Qt.Alignment'), ('PySide2.QtWidgets.QLayout', 'int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.Alignment')],
    "PySide2.QtWidgets.QGridLayout.addWidget": [('PySide2.QtWidgets.QWidget',), ('PySide2.QtWidgets.QWidget', 'int', 'int', 'PySide2.QtCore.Qt.Alignment'), ('PySide2.QtWidgets.QWidget', 'int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.Alignment')],
    "PySide2.QtWidgets.QGridLayout.cellRect": ('int', 'int'),
    "PySide2.QtWidgets.QGridLayout.columnCount": (),
    "PySide2.QtWidgets.QGridLayout.columnMinimumWidth": ('int',),
    "PySide2.QtWidgets.QGridLayout.columnStretch": ('int',),
    "PySide2.QtWidgets.QGridLayout.count": (),
    "PySide2.QtWidgets.QGridLayout.expandingDirections": (),
    "PySide2.QtWidgets.QGridLayout.getItemPosition": ('int',),
    "PySide2.QtWidgets.QGridLayout.hasHeightForWidth": (),
    "PySide2.QtWidgets.QGridLayout.heightForWidth": ('int',),
    "PySide2.QtWidgets.QGridLayout.horizontalSpacing": (),
    "PySide2.QtWidgets.QGridLayout.invalidate": (),
    "PySide2.QtWidgets.QGridLayout.itemAt": ('int',),
    "PySide2.QtWidgets.QGridLayout.itemAtPosition": ('int', 'int'),
    "PySide2.QtWidgets.QGridLayout.maximumSize": (),
    "PySide2.QtWidgets.QGridLayout.minimumHeightForWidth": ('int',),
    "PySide2.QtWidgets.QGridLayout.minimumSize": (),
    "PySide2.QtWidgets.QGridLayout.originCorner": (),
    "PySide2.QtWidgets.QGridLayout.rowCount": (),
    "PySide2.QtWidgets.QGridLayout.rowMinimumHeight": ('int',),
    "PySide2.QtWidgets.QGridLayout.rowStretch": ('int',),
    "PySide2.QtWidgets.QGridLayout.setColumnMinimumWidth": ('int', 'int'),
    "PySide2.QtWidgets.QGridLayout.setColumnStretch": ('int', 'int'),
    "PySide2.QtWidgets.QGridLayout.setDefaultPositioning": ('int', 'PySide2.QtCore.Qt.Orientation'),
    "PySide2.QtWidgets.QGridLayout.setGeometry": ('PySide2.QtCore.QRect',),
    "PySide2.QtWidgets.QGridLayout.setHorizontalSpacing": ('int',),
    "PySide2.QtWidgets.QGridLayout.setOriginCorner": ('PySide2.QtCore.Qt.Corner',),
    "PySide2.QtWidgets.QGridLayout.setRowMinimumHeight": ('int', 'int'),
    "PySide2.QtWidgets.QGridLayout.setRowStretch": ('int', 'int'),
    "PySide2.QtWidgets.QGridLayout.setSpacing": ('int',),
    "PySide2.QtWidgets.QGridLayout.setVerticalSpacing": ('int',),
    "PySide2.QtWidgets.QGridLayout.sizeHint": (),
    "PySide2.QtWidgets.QGridLayout.spacing": (),
    "PySide2.QtWidgets.QGridLayout.takeAt": ('int',),
    "PySide2.QtWidgets.QGridLayout.verticalSpacing": (),

# class PySide2.QtWidgets.QGroupBox:
    "PySide2.QtWidgets.QGroupBox.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
    "PySide2.QtWidgets.QGroupBox.alignment": (),
    "PySide2.QtWidgets.QGroupBox.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGroupBox.childEvent": ('PySide2.QtCore.QChildEvent',),
    "PySide2.QtWidgets.QGroupBox.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QGroupBox.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QGroupBox.initStyleOption": ('PySide2.QtWidgets.QStyleOptionGroupBox',),
    "PySide2.QtWidgets.QGroupBox.isCheckable": (),
    "PySide2.QtWidgets.QGroupBox.isChecked": (),
    "PySide2.QtWidgets.QGroupBox.isFlat": (),
    "PySide2.QtWidgets.QGroupBox.minimumSizeHint": (),
    "PySide2.QtWidgets.QGroupBox.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QGroupBox.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QGroupBox.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QGroupBox.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QGroupBox.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QGroupBox.setAlignment": ('int',),
    "PySide2.QtWidgets.QGroupBox.setCheckable": ('bool',),
    "PySide2.QtWidgets.QGroupBox.setChecked": ('bool',),
    "PySide2.QtWidgets.QGroupBox.setFlat": ('bool',),
    "PySide2.QtWidgets.QGroupBox.setTitle": ('str',),
    "PySide2.QtWidgets.QGroupBox.title": (),

# class PySide2.QtWidgets.QHBoxLayout:
    "PySide2.QtWidgets.QHBoxLayout.__init__": [(), ('PySide2.QtWidgets.QWidget',)],

# class PySide2.QtWidgets.QHeaderView:

# class PySide2.QtWidgets.QHeaderView.ResizeMode:
    "PySide2.QtWidgets.QHeaderView.__init__": ('PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QHeaderView.cascadingSectionResizes": (),
    "PySide2.QtWidgets.QHeaderView.count": (),
    "PySide2.QtWidgets.QHeaderView.currentChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QHeaderView.dataChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex', 'typing.List'),
    "PySide2.QtWidgets.QHeaderView.defaultAlignment": (),
    "PySide2.QtWidgets.QHeaderView.defaultSectionSize": (),
    "PySide2.QtWidgets.QHeaderView.doItemsLayout": (),
    "PySide2.QtWidgets.QHeaderView.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QHeaderView.headerDataChanged": ('PySide2.QtCore.Qt.Orientation', 'int', 'int'),
    "PySide2.QtWidgets.QHeaderView.hiddenSectionCount": (),
    "PySide2.QtWidgets.QHeaderView.hideSection": ('int',),
    "PySide2.QtWidgets.QHeaderView.highlightSections": (),
    "PySide2.QtWidgets.QHeaderView.horizontalOffset": (),
    "PySide2.QtWidgets.QHeaderView.indexAt": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QHeaderView.initStyleOption": [('PySide2.QtWidgets.QStyleOptionFrame',), ('PySide2.QtWidgets.QStyleOptionHeader',)],
    "PySide2.QtWidgets.QHeaderView.initialize": (),
    "PySide2.QtWidgets.QHeaderView.initializeSections": [(), ('int', 'int')],
    "PySide2.QtWidgets.QHeaderView.isFirstSectionMovable": (),
    "PySide2.QtWidgets.QHeaderView.isIndexHidden": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QHeaderView.isSectionHidden": ('int',),
    "PySide2.QtWidgets.QHeaderView.isSortIndicatorShown": (),
    "PySide2.QtWidgets.QHeaderView.length": (),
    "PySide2.QtWidgets.QHeaderView.logicalIndex": ('int',),
    "PySide2.QtWidgets.QHeaderView.logicalIndexAt": [('PySide2.QtCore.QPoint',), ('int',), ('int', 'int')],
    "PySide2.QtWidgets.QHeaderView.maximumSectionSize": (),
    "PySide2.QtWidgets.QHeaderView.minimumSectionSize": (),
    "PySide2.QtWidgets.QHeaderView.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QHeaderView.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QHeaderView.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QHeaderView.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QHeaderView.moveCursor": ('PySide2.QtWidgets.QAbstractItemView.CursorAction', 'PySide2.QtCore.Qt.KeyboardModifiers'),
    "PySide2.QtWidgets.QHeaderView.moveSection": ('int', 'int'),
    "PySide2.QtWidgets.QHeaderView.offset": (),
    "PySide2.QtWidgets.QHeaderView.orientation": (),
    "PySide2.QtWidgets.QHeaderView.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QHeaderView.paintSection": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'int'),
    "PySide2.QtWidgets.QHeaderView.reset": (),
    "PySide2.QtWidgets.QHeaderView.resetDefaultSectionSize": (),
    "PySide2.QtWidgets.QHeaderView.resizeContentsPrecision": (),
    "PySide2.QtWidgets.QHeaderView.resizeSection": ('int', 'int'),
    "PySide2.QtWidgets.QHeaderView.resizeSections": [(), ('PySide2.QtWidgets.QHeaderView.ResizeMode',)],
    "PySide2.QtWidgets.QHeaderView.restoreState": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtWidgets.QHeaderView.rowsInserted": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtWidgets.QHeaderView.saveState": (),
    "PySide2.QtWidgets.QHeaderView.scrollContentsBy": ('int', 'int'),
    "PySide2.QtWidgets.QHeaderView.scrollTo": ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
    "PySide2.QtWidgets.QHeaderView.sectionPosition": ('int',),
    "PySide2.QtWidgets.QHeaderView.sectionResizeMode": ('int',),
    "PySide2.QtWidgets.QHeaderView.sectionSize": ('int',),
    "PySide2.QtWidgets.QHeaderView.sectionSizeFromContents": ('int',),
    "PySide2.QtWidgets.QHeaderView.sectionSizeHint": ('int',),
    "PySide2.QtWidgets.QHeaderView.sectionViewportPosition": ('int',),
    "PySide2.QtWidgets.QHeaderView.sectionsAboutToBeRemoved": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtWidgets.QHeaderView.sectionsClickable": (),
    "PySide2.QtWidgets.QHeaderView.sectionsHidden": (),
    "PySide2.QtWidgets.QHeaderView.sectionsInserted": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtWidgets.QHeaderView.sectionsMovable": (),
    "PySide2.QtWidgets.QHeaderView.sectionsMoved": (),
    "PySide2.QtWidgets.QHeaderView.setCascadingSectionResizes": ('bool',),
    "PySide2.QtWidgets.QHeaderView.setDefaultAlignment": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtWidgets.QHeaderView.setDefaultSectionSize": ('int',),
    "PySide2.QtWidgets.QHeaderView.setFirstSectionMovable": ('bool',),
    "PySide2.QtWidgets.QHeaderView.setHighlightSections": ('bool',),
    "PySide2.QtWidgets.QHeaderView.setMaximumSectionSize": ('int',),
    "PySide2.QtWidgets.QHeaderView.setMinimumSectionSize": ('int',),
    "PySide2.QtWidgets.QHeaderView.setModel": ('PySide2.QtCore.QAbstractItemModel',),
    "PySide2.QtWidgets.QHeaderView.setOffset": ('int',),
    "PySide2.QtWidgets.QHeaderView.setOffsetToLastSection": (),
    "PySide2.QtWidgets.QHeaderView.setOffsetToSectionPosition": ('int',),
    "PySide2.QtWidgets.QHeaderView.setResizeContentsPrecision": ('int',),
    "PySide2.QtWidgets.QHeaderView.setSectionHidden": ('int', 'bool'),
    "PySide2.QtWidgets.QHeaderView.setSectionResizeMode": [('PySide2.QtWidgets.QHeaderView.ResizeMode',), ('int', 'PySide2.QtWidgets.QHeaderView.ResizeMode')],
    "PySide2.QtWidgets.QHeaderView.setSectionsClickable": ('bool',),
    "PySide2.QtWidgets.QHeaderView.setSectionsMovable": ('bool',),
    "PySide2.QtWidgets.QHeaderView.setSelection": ('PySide2.QtCore.QRect', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'),
    "PySide2.QtWidgets.QHeaderView.setSortIndicator": ('int', 'PySide2.QtCore.Qt.SortOrder'),
    "PySide2.QtWidgets.QHeaderView.setSortIndicatorShown": ('bool',),
    "PySide2.QtWidgets.QHeaderView.setStretchLastSection": ('bool',),
    "PySide2.QtWidgets.QHeaderView.setVisible": ('bool',),
    "PySide2.QtWidgets.QHeaderView.showSection": ('int',),
    "PySide2.QtWidgets.QHeaderView.sizeHint": (),
    "PySide2.QtWidgets.QHeaderView.sortIndicatorOrder": (),
    "PySide2.QtWidgets.QHeaderView.sortIndicatorSection": (),
    "PySide2.QtWidgets.QHeaderView.stretchLastSection": (),
    "PySide2.QtWidgets.QHeaderView.stretchSectionCount": (),
    "PySide2.QtWidgets.QHeaderView.swapSections": ('int', 'int'),
    "PySide2.QtWidgets.QHeaderView.updateGeometries": (),
    "PySide2.QtWidgets.QHeaderView.updateSection": ('int',),
    "PySide2.QtWidgets.QHeaderView.verticalOffset": (),
    "PySide2.QtWidgets.QHeaderView.viewportEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QHeaderView.visualIndex": ('int',),
    "PySide2.QtWidgets.QHeaderView.visualIndexAt": ('int',),
    "PySide2.QtWidgets.QHeaderView.visualRect": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QHeaderView.visualRegionForSelection": ('PySide2.QtCore.QItemSelection',),

# class PySide2.QtWidgets.QInputDialog:

# class PySide2.QtWidgets.QInputDialog.InputDialogOption:

# class PySide2.QtWidgets.QInputDialog.InputMode:
    "PySide2.QtWidgets.QInputDialog.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
    "PySide2.QtWidgets.QInputDialog.cancelButtonText": (),
    "PySide2.QtWidgets.QInputDialog.comboBoxItems": (),
    "PySide2.QtWidgets.QInputDialog.done": ('int',),
    "PySide2.QtWidgets.QInputDialog.doubleDecimals": (),
    "PySide2.QtWidgets.QInputDialog.doubleMaximum": (),
    "PySide2.QtWidgets.QInputDialog.doubleMinimum": (),
    "PySide2.QtWidgets.QInputDialog.doubleStep": (),
    "PySide2.QtWidgets.QInputDialog.doubleValue": (),
    "PySide2.QtWidgets.QInputDialog.getDouble": [('PySide2.QtWidgets.QWidget', 'str', 'str', 'float', 'float', 'float', 'int', 'PySide2.QtCore.Qt.WindowFlags'), ('PySide2.QtWidgets.QWidget', 'str', 'str', 'float', 'float', 'float', 'int', 'PySide2.QtCore.Qt.WindowFlags', 'float')],
    "PySide2.QtWidgets.QInputDialog.getInt": ('PySide2.QtWidgets.QWidget', 'str', 'str', 'int', 'int', 'int', 'int', 'PySide2.QtCore.Qt.WindowFlags'),
    "PySide2.QtWidgets.QInputDialog.getItem": ('PySide2.QtWidgets.QWidget', 'str', 'str', 'typing.Sequence', 'int', 'bool', 'PySide2.QtCore.Qt.WindowFlags', 'PySide2.QtCore.Qt.InputMethodHints'),
    "PySide2.QtWidgets.QInputDialog.getMultiLineText": ('PySide2.QtWidgets.QWidget', 'str', 'str', 'str', 'PySide2.QtCore.Qt.WindowFlags', 'PySide2.QtCore.Qt.InputMethodHints'),
    "PySide2.QtWidgets.QInputDialog.getText": ('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QLineEdit.EchoMode', 'str', 'PySide2.QtCore.Qt.WindowFlags', 'PySide2.QtCore.Qt.InputMethodHints'),
    "PySide2.QtWidgets.QInputDialog.inputMode": (),
    "PySide2.QtWidgets.QInputDialog.intMaximum": (),
    "PySide2.QtWidgets.QInputDialog.intMinimum": (),
    "PySide2.QtWidgets.QInputDialog.intStep": (),
    "PySide2.QtWidgets.QInputDialog.intValue": (),
    "PySide2.QtWidgets.QInputDialog.isComboBoxEditable": (),
    "PySide2.QtWidgets.QInputDialog.labelText": (),
    "PySide2.QtWidgets.QInputDialog.minimumSizeHint": (),
    "PySide2.QtWidgets.QInputDialog.okButtonText": (),
    "PySide2.QtWidgets.QInputDialog.open": [(), ('PySide2.QtCore.QObject', 'bytes')],
    "PySide2.QtWidgets.QInputDialog.setCancelButtonText": ('str',),
    "PySide2.QtWidgets.QInputDialog.setComboBoxEditable": ('bool',),
    "PySide2.QtWidgets.QInputDialog.setComboBoxItems": ('typing.Sequence',),
    "PySide2.QtWidgets.QInputDialog.setDoubleDecimals": ('int',),
    "PySide2.QtWidgets.QInputDialog.setDoubleMaximum": ('float',),
    "PySide2.QtWidgets.QInputDialog.setDoubleMinimum": ('float',),
    "PySide2.QtWidgets.QInputDialog.setDoubleRange": ('float', 'float'),
    "PySide2.QtWidgets.QInputDialog.setDoubleStep": ('float',),
    "PySide2.QtWidgets.QInputDialog.setDoubleValue": ('float',),
    "PySide2.QtWidgets.QInputDialog.setInputMode": ('PySide2.QtWidgets.QInputDialog.InputMode',),
    "PySide2.QtWidgets.QInputDialog.setIntMaximum": ('int',),
    "PySide2.QtWidgets.QInputDialog.setIntMinimum": ('int',),
    "PySide2.QtWidgets.QInputDialog.setIntRange": ('int', 'int'),
    "PySide2.QtWidgets.QInputDialog.setIntStep": ('int',),
    "PySide2.QtWidgets.QInputDialog.setIntValue": ('int',),
    "PySide2.QtWidgets.QInputDialog.setLabelText": ('str',),
    "PySide2.QtWidgets.QInputDialog.setOkButtonText": ('str',),
    "PySide2.QtWidgets.QInputDialog.setOption": ('PySide2.QtWidgets.QInputDialog.InputDialogOption', 'bool'),
    "PySide2.QtWidgets.QInputDialog.setTextEchoMode": ('PySide2.QtWidgets.QLineEdit.EchoMode',),
    "PySide2.QtWidgets.QInputDialog.setTextValue": ('str',),
    "PySide2.QtWidgets.QInputDialog.setVisible": ('bool',),
    "PySide2.QtWidgets.QInputDialog.sizeHint": (),
    "PySide2.QtWidgets.QInputDialog.testOption": ('PySide2.QtWidgets.QInputDialog.InputDialogOption',),
    "PySide2.QtWidgets.QInputDialog.textEchoMode": (),
    "PySide2.QtWidgets.QInputDialog.textValue": (),

# class PySide2.QtWidgets.QItemDelegate:
    "PySide2.QtWidgets.QItemDelegate.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QItemDelegate.createEditor": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QItemDelegate.decoration": ('PySide2.QtWidgets.QStyleOptionViewItem', 'typing.Any'),
    "PySide2.QtWidgets.QItemDelegate.doCheck": ('PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QRect', 'typing.Any'),
    "PySide2.QtWidgets.QItemDelegate.drawBackground": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QItemDelegate.drawCheck": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QRect', 'PySide2.QtCore.Qt.CheckState'),
    "PySide2.QtWidgets.QItemDelegate.drawDecoration": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QRect', 'PySide2.QtGui.QPixmap'),
    "PySide2.QtWidgets.QItemDelegate.drawDisplay": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QRect', 'str'),
    "PySide2.QtWidgets.QItemDelegate.drawFocus": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QRect'),
    "PySide2.QtWidgets.QItemDelegate.editorEvent": ('PySide2.QtCore.QEvent', 'PySide2.QtCore.QAbstractItemModel', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QItemDelegate.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QItemDelegate.hasClipping": (),
    "PySide2.QtWidgets.QItemDelegate.itemEditorFactory": (),
    "PySide2.QtWidgets.QItemDelegate.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QItemDelegate.rect": ('PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtWidgets.QItemDelegate.selectedPixmap": ('PySide2.QtGui.QPixmap', 'PySide2.QtGui.QPalette', 'bool'),
    "PySide2.QtWidgets.QItemDelegate.setClipping": ('bool',),
    "PySide2.QtWidgets.QItemDelegate.setEditorData": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QItemDelegate.setItemEditorFactory": ('PySide2.QtWidgets.QItemEditorFactory',),
    "PySide2.QtWidgets.QItemDelegate.setModelData": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QAbstractItemModel', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QItemDelegate.setOptions": ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QStyleOptionViewItem'),
    "PySide2.QtWidgets.QItemDelegate.sizeHint": ('PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QItemDelegate.textRectangle": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'PySide2.QtGui.QFont', 'str'),
    "PySide2.QtWidgets.QItemDelegate.updateEditorGeometry": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),

# class PySide2.QtWidgets.QItemEditorCreatorBase:
    "PySide2.QtWidgets.QItemEditorCreatorBase.__init__": (),
    "PySide2.QtWidgets.QItemEditorCreatorBase.createWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QItemEditorCreatorBase.valuePropertyName": (),

# class PySide2.QtWidgets.QItemEditorFactory:
    "PySide2.QtWidgets.QItemEditorFactory.__init__": (),
    "PySide2.QtWidgets.QItemEditorFactory.createEditor": ('int', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QItemEditorFactory.defaultFactory": (),
    "PySide2.QtWidgets.QItemEditorFactory.registerEditor": ('int', 'PySide2.QtWidgets.QItemEditorCreatorBase'),
    "PySide2.QtWidgets.QItemEditorFactory.setDefaultFactory": ('PySide2.QtWidgets.QItemEditorFactory',),
    "PySide2.QtWidgets.QItemEditorFactory.valuePropertyName": ('int',),

# class PySide2.QtWidgets.QKeyEventTransition:
    "PySide2.QtWidgets.QKeyEventTransition.__init__": [('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent.Type', 'int', 'PySide2.QtCore.QState'), ('PySide2.QtCore.QState',)],
    "PySide2.QtWidgets.QKeyEventTransition.eventTest": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QKeyEventTransition.key": (),
    "PySide2.QtWidgets.QKeyEventTransition.modifierMask": (),
    "PySide2.QtWidgets.QKeyEventTransition.onTransition": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QKeyEventTransition.setKey": ('int',),
    "PySide2.QtWidgets.QKeyEventTransition.setModifierMask": ('PySide2.QtCore.Qt.KeyboardModifiers',),

# class PySide2.QtWidgets.QKeySequenceEdit:
    "PySide2.QtWidgets.QKeySequenceEdit.__init__": [('PySide2.QtGui.QKeySequence', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QKeySequenceEdit.clear": (),
    "PySide2.QtWidgets.QKeySequenceEdit.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QKeySequenceEdit.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QKeySequenceEdit.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QKeySequenceEdit.keySequence": (),
    "PySide2.QtWidgets.QKeySequenceEdit.setKeySequence": ('PySide2.QtGui.QKeySequence',),
    "PySide2.QtWidgets.QKeySequenceEdit.timerEvent": ('PySide2.QtCore.QTimerEvent',),

# class PySide2.QtWidgets.QLCDNumber:

# class PySide2.QtWidgets.QLCDNumber.Mode:

# class PySide2.QtWidgets.QLCDNumber.SegmentStyle:
    "PySide2.QtWidgets.QLCDNumber.__init__": [('PySide2.QtWidgets.QWidget',), ('int', 'PySide2.QtWidgets.QWidget')],
    "PySide2.QtWidgets.QLCDNumber.checkOverflow": [('float',), ('int',)],
    "PySide2.QtWidgets.QLCDNumber.digitCount": (),
    "PySide2.QtWidgets.QLCDNumber.display": [('float',), ('int',), ('str',)],
    "PySide2.QtWidgets.QLCDNumber.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QLCDNumber.intValue": (),
    "PySide2.QtWidgets.QLCDNumber.mode": (),
    "PySide2.QtWidgets.QLCDNumber.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QLCDNumber.segmentStyle": (),
    "PySide2.QtWidgets.QLCDNumber.setBinMode": (),
    "PySide2.QtWidgets.QLCDNumber.setDecMode": (),
    "PySide2.QtWidgets.QLCDNumber.setDigitCount": ('int',),
    "PySide2.QtWidgets.QLCDNumber.setHexMode": (),
    "PySide2.QtWidgets.QLCDNumber.setMode": ('PySide2.QtWidgets.QLCDNumber.Mode',),
    "PySide2.QtWidgets.QLCDNumber.setOctMode": (),
    "PySide2.QtWidgets.QLCDNumber.setSegmentStyle": ('PySide2.QtWidgets.QLCDNumber.SegmentStyle',),
    "PySide2.QtWidgets.QLCDNumber.setSmallDecimalPoint": ('bool',),
    "PySide2.QtWidgets.QLCDNumber.sizeHint": (),
    "PySide2.QtWidgets.QLCDNumber.smallDecimalPoint": (),
    "PySide2.QtWidgets.QLCDNumber.value": (),

# class PySide2.QtWidgets.QLabel:
    "PySide2.QtWidgets.QLabel.__init__": [('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'), ('str', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags')],
    "PySide2.QtWidgets.QLabel.alignment": (),
    "PySide2.QtWidgets.QLabel.buddy": (),
    "PySide2.QtWidgets.QLabel.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QLabel.clear": (),
    "PySide2.QtWidgets.QLabel.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
    "PySide2.QtWidgets.QLabel.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QLabel.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QLabel.focusNextPrevChild": ('bool',),
    "PySide2.QtWidgets.QLabel.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QLabel.hasScaledContents": (),
    "PySide2.QtWidgets.QLabel.hasSelectedText": (),
    "PySide2.QtWidgets.QLabel.heightForWidth": ('int',),
    "PySide2.QtWidgets.QLabel.indent": (),
    "PySide2.QtWidgets.QLabel.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QLabel.margin": (),
    "PySide2.QtWidgets.QLabel.minimumSizeHint": (),
    "PySide2.QtWidgets.QLabel.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QLabel.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QLabel.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QLabel.movie": (),
    "PySide2.QtWidgets.QLabel.openExternalLinks": (),
    "PySide2.QtWidgets.QLabel.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QLabel.picture": (),
    "PySide2.QtWidgets.QLabel.pixmap": (),
    "PySide2.QtWidgets.QLabel.selectedText": (),
    "PySide2.QtWidgets.QLabel.selectionStart": (),
    "PySide2.QtWidgets.QLabel.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtWidgets.QLabel.setBuddy": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QLabel.setIndent": ('int',),
    "PySide2.QtWidgets.QLabel.setMargin": ('int',),
    "PySide2.QtWidgets.QLabel.setMovie": ('PySide2.QtGui.QMovie',),
    "PySide2.QtWidgets.QLabel.setNum": [('float',), ('int',)],
    "PySide2.QtWidgets.QLabel.setOpenExternalLinks": ('bool',),
    "PySide2.QtWidgets.QLabel.setPicture": ('PySide2.QtGui.QPicture',),
    "PySide2.QtWidgets.QLabel.setPixmap": ('PySide2.QtGui.QPixmap',),
    "PySide2.QtWidgets.QLabel.setScaledContents": ('bool',),
    "PySide2.QtWidgets.QLabel.setSelection": ('int', 'int'),
    "PySide2.QtWidgets.QLabel.setText": ('str',),
    "PySide2.QtWidgets.QLabel.setTextFormat": ('PySide2.QtCore.Qt.TextFormat',),
    "PySide2.QtWidgets.QLabel.setTextInteractionFlags": ('PySide2.QtCore.Qt.TextInteractionFlags',),
    "PySide2.QtWidgets.QLabel.setWordWrap": ('bool',),
    "PySide2.QtWidgets.QLabel.sizeHint": (),
    "PySide2.QtWidgets.QLabel.text": (),
    "PySide2.QtWidgets.QLabel.textFormat": (),
    "PySide2.QtWidgets.QLabel.textInteractionFlags": (),
    "PySide2.QtWidgets.QLabel.wordWrap": (),

# class PySide2.QtWidgets.QLayout:

# class PySide2.QtWidgets.QLayout.SizeConstraint:
    "PySide2.QtWidgets.QLayout.__init__": [(), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QLayout.activate": (),
    "PySide2.QtWidgets.QLayout.addChildLayout": ('PySide2.QtWidgets.QLayout',),
    "PySide2.QtWidgets.QLayout.addChildWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QLayout.addItem": ('PySide2.QtWidgets.QLayoutItem',),
    "PySide2.QtWidgets.QLayout.addWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QLayout.adoptLayout": ('PySide2.QtWidgets.QLayout',),
    "PySide2.QtWidgets.QLayout.alignmentRect": ('PySide2.QtCore.QRect',),
    "PySide2.QtWidgets.QLayout.childEvent": ('PySide2.QtCore.QChildEvent',),
    "PySide2.QtWidgets.QLayout.closestAcceptableSize": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QSize'),
    "PySide2.QtWidgets.QLayout.contentsMargins": (),
    "PySide2.QtWidgets.QLayout.contentsRect": (),
    "PySide2.QtWidgets.QLayout.controlTypes": (),
    "PySide2.QtWidgets.QLayout.count": (),
    "PySide2.QtWidgets.QLayout.expandingDirections": (),
    "PySide2.QtWidgets.QLayout.geometry": (),
    "PySide2.QtWidgets.QLayout.getContentsMargins": (),
    "PySide2.QtWidgets.QLayout.indexOf": [('PySide2.QtWidgets.QLayoutItem',), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QLayout.invalidate": (),
    "PySide2.QtWidgets.QLayout.isEmpty": (),
    "PySide2.QtWidgets.QLayout.isEnabled": (),
    "PySide2.QtWidgets.QLayout.itemAt": ('int',),
    "PySide2.QtWidgets.QLayout.layout": (),
    "PySide2.QtWidgets.QLayout.margin": (),
    "PySide2.QtWidgets.QLayout.maximumSize": (),
    "PySide2.QtWidgets.QLayout.menuBar": (),
    "PySide2.QtWidgets.QLayout.minimumSize": (),
    "PySide2.QtWidgets.QLayout.parentWidget": (),
    "PySide2.QtWidgets.QLayout.removeItem": ('PySide2.QtWidgets.QLayoutItem',),
    "PySide2.QtWidgets.QLayout.removeWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QLayout.replaceWidget": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.FindChildOptions'),
    "PySide2.QtWidgets.QLayout.setAlignment": [('PySide2.QtCore.Qt.Alignment',), ('PySide2.QtWidgets.QLayout', 'PySide2.QtCore.Qt.Alignment'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.Alignment')],
    "PySide2.QtWidgets.QLayout.setContentsMargins": [('PySide2.QtCore.QMargins',), ('int', 'int', 'int', 'int')],
    "PySide2.QtWidgets.QLayout.setEnabled": ('bool',),
    "PySide2.QtWidgets.QLayout.setGeometry": ('PySide2.QtCore.QRect',),
    "PySide2.QtWidgets.QLayout.setMargin": ('int',),
    "PySide2.QtWidgets.QLayout.setMenuBar": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QLayout.setSizeConstraint": ('PySide2.QtWidgets.QLayout.SizeConstraint',),
    "PySide2.QtWidgets.QLayout.setSpacing": ('int',),
    "PySide2.QtWidgets.QLayout.sizeConstraint": (),
    "PySide2.QtWidgets.QLayout.spacing": (),
    "PySide2.QtWidgets.QLayout.takeAt": ('int',),
    "PySide2.QtWidgets.QLayout.totalHeightForWidth": ('int',),
    "PySide2.QtWidgets.QLayout.totalMaximumSize": (),
    "PySide2.QtWidgets.QLayout.totalMinimumSize": (),
    "PySide2.QtWidgets.QLayout.totalSizeHint": (),
    "PySide2.QtWidgets.QLayout.update": (),
    "PySide2.QtWidgets.QLayout.widgetEvent": ('PySide2.QtCore.QEvent',),

# class PySide2.QtWidgets.QLayoutItem:
    "PySide2.QtWidgets.QLayoutItem.__init__": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtWidgets.QLayoutItem.alignment": (),
    "PySide2.QtWidgets.QLayoutItem.controlTypes": (),
    "PySide2.QtWidgets.QLayoutItem.expandingDirections": (),
    "PySide2.QtWidgets.QLayoutItem.geometry": (),
    "PySide2.QtWidgets.QLayoutItem.hasHeightForWidth": (),
    "PySide2.QtWidgets.QLayoutItem.heightForWidth": ('int',),
    "PySide2.QtWidgets.QLayoutItem.invalidate": (),
    "PySide2.QtWidgets.QLayoutItem.isEmpty": (),
    "PySide2.QtWidgets.QLayoutItem.layout": (),
    "PySide2.QtWidgets.QLayoutItem.maximumSize": (),
    "PySide2.QtWidgets.QLayoutItem.minimumHeightForWidth": ('int',),
    "PySide2.QtWidgets.QLayoutItem.minimumSize": (),
    "PySide2.QtWidgets.QLayoutItem.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtWidgets.QLayoutItem.setGeometry": ('PySide2.QtCore.QRect',),
    "PySide2.QtWidgets.QLayoutItem.sizeHint": (),
    "PySide2.QtWidgets.QLayoutItem.spacerItem": (),
    "PySide2.QtWidgets.QLayoutItem.widget": (),

# class PySide2.QtWidgets.QLineEdit:

# class PySide2.QtWidgets.QLineEdit.ActionPosition:

# class PySide2.QtWidgets.QLineEdit.EchoMode:
    "PySide2.QtWidgets.QLineEdit.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
    "PySide2.QtWidgets.QLineEdit.addAction": [('PySide2.QtGui.QIcon', 'PySide2.QtWidgets.QLineEdit.ActionPosition'), ('PySide2.QtWidgets.QAction',), ('PySide2.QtWidgets.QAction', 'PySide2.QtWidgets.QLineEdit.ActionPosition')],
    "PySide2.QtWidgets.QLineEdit.alignment": (),
    "PySide2.QtWidgets.QLineEdit.backspace": (),
    "PySide2.QtWidgets.QLineEdit.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QLineEdit.clear": (),
    "PySide2.QtWidgets.QLineEdit.completer": (),
    "PySide2.QtWidgets.QLineEdit.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
    "PySide2.QtWidgets.QLineEdit.copy": (),
    "PySide2.QtWidgets.QLineEdit.createStandardContextMenu": (),
    "PySide2.QtWidgets.QLineEdit.cursorBackward": ('bool', 'int'),
    "PySide2.QtWidgets.QLineEdit.cursorForward": ('bool', 'int'),
    "PySide2.QtWidgets.QLineEdit.cursorMoveStyle": (),
    "PySide2.QtWidgets.QLineEdit.cursorPosition": (),
    "PySide2.QtWidgets.QLineEdit.cursorPositionAt": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QLineEdit.cursorRect": (),
    "PySide2.QtWidgets.QLineEdit.cursorWordBackward": ('bool',),
    "PySide2.QtWidgets.QLineEdit.cursorWordForward": ('bool',),
    "PySide2.QtWidgets.QLineEdit.cut": (),
    "PySide2.QtWidgets.QLineEdit.del_": (),
    "PySide2.QtWidgets.QLineEdit.deselect": (),
    "PySide2.QtWidgets.QLineEdit.displayText": (),
    "PySide2.QtWidgets.QLineEdit.dragEnabled": (),
    "PySide2.QtWidgets.QLineEdit.dragEnterEvent": ('PySide2.QtGui.QDragEnterEvent',),
    "PySide2.QtWidgets.QLineEdit.dragLeaveEvent": ('PySide2.QtGui.QDragLeaveEvent',),
    "PySide2.QtWidgets.QLineEdit.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
    "PySide2.QtWidgets.QLineEdit.dropEvent": ('PySide2.QtGui.QDropEvent',),
    "PySide2.QtWidgets.QLineEdit.echoMode": (),
    "PySide2.QtWidgets.QLineEdit.end": ('bool',),
    "PySide2.QtWidgets.QLineEdit.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QLineEdit.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QLineEdit.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QLineEdit.getTextMargins": (),
    "PySide2.QtWidgets.QLineEdit.hasAcceptableInput": (),
    "PySide2.QtWidgets.QLineEdit.hasFrame": (),
    "PySide2.QtWidgets.QLineEdit.hasSelectedText": (),
    "PySide2.QtWidgets.QLineEdit.home": ('bool',),
    "PySide2.QtWidgets.QLineEdit.initStyleOption": ('PySide2.QtWidgets.QStyleOptionFrame',),
    "PySide2.QtWidgets.QLineEdit.inputMask": (),
    "PySide2.QtWidgets.QLineEdit.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
    "PySide2.QtWidgets.QLineEdit.inputMethodQuery": [('PySide2.QtCore.Qt.InputMethodQuery',), ('PySide2.QtCore.Qt.InputMethodQuery', 'typing.Any')],
    "PySide2.QtWidgets.QLineEdit.insert": ('str',),
    "PySide2.QtWidgets.QLineEdit.isClearButtonEnabled": (),
    "PySide2.QtWidgets.QLineEdit.isModified": (),
    "PySide2.QtWidgets.QLineEdit.isReadOnly": (),
    "PySide2.QtWidgets.QLineEdit.isRedoAvailable": (),
    "PySide2.QtWidgets.QLineEdit.isUndoAvailable": (),
    "PySide2.QtWidgets.QLineEdit.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QLineEdit.maxLength": (),
    "PySide2.QtWidgets.QLineEdit.minimumSizeHint": (),
    "PySide2.QtWidgets.QLineEdit.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QLineEdit.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QLineEdit.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QLineEdit.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QLineEdit.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QLineEdit.paste": (),
    "PySide2.QtWidgets.QLineEdit.placeholderText": (),
    "PySide2.QtWidgets.QLineEdit.redo": (),
    "PySide2.QtWidgets.QLineEdit.selectAll": (),
    "PySide2.QtWidgets.QLineEdit.selectedText": (),
    "PySide2.QtWidgets.QLineEdit.selectionEnd": (),
    "PySide2.QtWidgets.QLineEdit.selectionLength": (),
    "PySide2.QtWidgets.QLineEdit.selectionStart": (),
    "PySide2.QtWidgets.QLineEdit.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtWidgets.QLineEdit.setClearButtonEnabled": ('bool',),
    "PySide2.QtWidgets.QLineEdit.setCompleter": ('PySide2.QtWidgets.QCompleter',),
    "PySide2.QtWidgets.QLineEdit.setCursorMoveStyle": ('PySide2.QtCore.Qt.CursorMoveStyle',),
    "PySide2.QtWidgets.QLineEdit.setCursorPosition": ('int',),
    "PySide2.QtWidgets.QLineEdit.setDragEnabled": ('bool',),
    "PySide2.QtWidgets.QLineEdit.setEchoMode": ('PySide2.QtWidgets.QLineEdit.EchoMode',),
    "PySide2.QtWidgets.QLineEdit.setFrame": ('bool',),
    "PySide2.QtWidgets.QLineEdit.setInputMask": ('str',),
    "PySide2.QtWidgets.QLineEdit.setMaxLength": ('int',),
    "PySide2.QtWidgets.QLineEdit.setModified": ('bool',),
    "PySide2.QtWidgets.QLineEdit.setPlaceholderText": ('str',),
    "PySide2.QtWidgets.QLineEdit.setReadOnly": ('bool',),
    "PySide2.QtWidgets.QLineEdit.setSelection": ('int', 'int'),
    "PySide2.QtWidgets.QLineEdit.setText": ('str',),
    "PySide2.QtWidgets.QLineEdit.setTextMargins": [('PySide2.QtCore.QMargins',), ('int', 'int', 'int', 'int')],
    "PySide2.QtWidgets.QLineEdit.setValidator": ('PySide2.QtGui.QValidator',),
    "PySide2.QtWidgets.QLineEdit.sizeHint": (),
    "PySide2.QtWidgets.QLineEdit.text": (),
    "PySide2.QtWidgets.QLineEdit.textMargins": (),
    "PySide2.QtWidgets.QLineEdit.undo": (),
    "PySide2.QtWidgets.QLineEdit.validator": (),

# class PySide2.QtWidgets.QListView:

# class PySide2.QtWidgets.QListView.Flow:

# class PySide2.QtWidgets.QListView.LayoutMode:

# class PySide2.QtWidgets.QListView.Movement:

# class PySide2.QtWidgets.QListView.ResizeMode:

# class PySide2.QtWidgets.QListView.ViewMode:
    "PySide2.QtWidgets.QListView.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QListView.batchSize": (),
    "PySide2.QtWidgets.QListView.clearPropertyFlags": (),
    "PySide2.QtWidgets.QListView.contentsSize": (),
    "PySide2.QtWidgets.QListView.currentChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QListView.dataChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex', 'typing.List'),
    "PySide2.QtWidgets.QListView.doItemsLayout": (),
    "PySide2.QtWidgets.QListView.dragLeaveEvent": ('PySide2.QtGui.QDragLeaveEvent',),
    "PySide2.QtWidgets.QListView.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
    "PySide2.QtWidgets.QListView.dropEvent": ('PySide2.QtGui.QDropEvent',),
    "PySide2.QtWidgets.QListView.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QListView.flow": (),
    "PySide2.QtWidgets.QListView.gridSize": (),
    "PySide2.QtWidgets.QListView.horizontalOffset": (),
    "PySide2.QtWidgets.QListView.indexAt": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QListView.isIndexHidden": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QListView.isRowHidden": ('int',),
    "PySide2.QtWidgets.QListView.isSelectionRectVisible": (),
    "PySide2.QtWidgets.QListView.isWrapping": (),
    "PySide2.QtWidgets.QListView.itemAlignment": (),
    "PySide2.QtWidgets.QListView.layoutMode": (),
    "PySide2.QtWidgets.QListView.modelColumn": (),
    "PySide2.QtWidgets.QListView.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QListView.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QListView.moveCursor": ('PySide2.QtWidgets.QAbstractItemView.CursorAction', 'PySide2.QtCore.Qt.KeyboardModifiers'),
    "PySide2.QtWidgets.QListView.movement": (),
    "PySide2.QtWidgets.QListView.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QListView.rectForIndex": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QListView.reset": (),
    "PySide2.QtWidgets.QListView.resizeContents": ('int', 'int'),
    "PySide2.QtWidgets.QListView.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QListView.resizeMode": (),
    "PySide2.QtWidgets.QListView.rowsAboutToBeRemoved": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtWidgets.QListView.rowsInserted": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtWidgets.QListView.scrollContentsBy": ('int', 'int'),
    "PySide2.QtWidgets.QListView.scrollTo": ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
    "PySide2.QtWidgets.QListView.selectedIndexes": (),
    "PySide2.QtWidgets.QListView.selectionChanged": ('PySide2.QtCore.QItemSelection', 'PySide2.QtCore.QItemSelection'),
    "PySide2.QtWidgets.QListView.setBatchSize": ('int',),
    "PySide2.QtWidgets.QListView.setFlow": ('PySide2.QtWidgets.QListView.Flow',),
    "PySide2.QtWidgets.QListView.setGridSize": ('PySide2.QtCore.QSize',),
    "PySide2.QtWidgets.QListView.setItemAlignment": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtWidgets.QListView.setLayoutMode": ('PySide2.QtWidgets.QListView.LayoutMode',),
    "PySide2.QtWidgets.QListView.setModelColumn": ('int',),
    "PySide2.QtWidgets.QListView.setMovement": ('PySide2.QtWidgets.QListView.Movement',),
    "PySide2.QtWidgets.QListView.setPositionForIndex": ('PySide2.QtCore.QPoint', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QListView.setResizeMode": ('PySide2.QtWidgets.QListView.ResizeMode',),
    "PySide2.QtWidgets.QListView.setRootIndex": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QListView.setRowHidden": ('int', 'bool'),
    "PySide2.QtWidgets.QListView.setSelection": ('PySide2.QtCore.QRect', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'),
    "PySide2.QtWidgets.QListView.setSelectionRectVisible": ('bool',),
    "PySide2.QtWidgets.QListView.setSpacing": ('int',),
    "PySide2.QtWidgets.QListView.setUniformItemSizes": ('bool',),
    "PySide2.QtWidgets.QListView.setViewMode": ('PySide2.QtWidgets.QListView.ViewMode',),
    "PySide2.QtWidgets.QListView.setWordWrap": ('bool',),
    "PySide2.QtWidgets.QListView.setWrapping": ('bool',),
    "PySide2.QtWidgets.QListView.spacing": (),
    "PySide2.QtWidgets.QListView.startDrag": ('PySide2.QtCore.Qt.DropActions',),
    "PySide2.QtWidgets.QListView.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtWidgets.QListView.uniformItemSizes": (),
    "PySide2.QtWidgets.QListView.updateGeometries": (),
    "PySide2.QtWidgets.QListView.verticalOffset": (),
    "PySide2.QtWidgets.QListView.viewMode": (),
    "PySide2.QtWidgets.QListView.viewOptions": (),
    "PySide2.QtWidgets.QListView.viewportSizeHint": (),
    "PySide2.QtWidgets.QListView.visualRect": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QListView.visualRegionForSelection": ('PySide2.QtCore.QItemSelection',),
    "PySide2.QtWidgets.QListView.wheelEvent": ('PySide2.QtGui.QWheelEvent',),
    "PySide2.QtWidgets.QListView.wordWrap": (),

# class PySide2.QtWidgets.QListWidget:
    "PySide2.QtWidgets.QListWidget.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QListWidget.addItem": [('PySide2.QtWidgets.QListWidgetItem',), ('str',)],
    "PySide2.QtWidgets.QListWidget.addItems": ('typing.Sequence',),
    "PySide2.QtWidgets.QListWidget.clear": (),
    "PySide2.QtWidgets.QListWidget.closePersistentEditor": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QListWidgetItem',)],
    "PySide2.QtWidgets.QListWidget.count": (),
    "PySide2.QtWidgets.QListWidget.currentItem": (),
    "PySide2.QtWidgets.QListWidget.currentRow": (),
    "PySide2.QtWidgets.QListWidget.dropEvent": ('PySide2.QtGui.QDropEvent',),
    "PySide2.QtWidgets.QListWidget.dropMimeData": ('int', 'PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction'),
    "PySide2.QtWidgets.QListWidget.editItem": ('PySide2.QtWidgets.QListWidgetItem',),
    "PySide2.QtWidgets.QListWidget.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QListWidget.findItems": ('str', 'PySide2.QtCore.Qt.MatchFlags'),
    "PySide2.QtWidgets.QListWidget.indexFromItem": ('PySide2.QtWidgets.QListWidgetItem',),
    "PySide2.QtWidgets.QListWidget.insertItem": [('int', 'PySide2.QtWidgets.QListWidgetItem'), ('int', 'str')],
    "PySide2.QtWidgets.QListWidget.insertItems": ('int', 'typing.Sequence'),
    "PySide2.QtWidgets.QListWidget.isItemHidden": ('PySide2.QtWidgets.QListWidgetItem',),
    "PySide2.QtWidgets.QListWidget.isItemSelected": ('PySide2.QtWidgets.QListWidgetItem',),
    "PySide2.QtWidgets.QListWidget.isPersistentEditorOpen": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QListWidgetItem',)],
    "PySide2.QtWidgets.QListWidget.isSortingEnabled": (),
    "PySide2.QtWidgets.QListWidget.item": ('int',),
    "PySide2.QtWidgets.QListWidget.itemAt": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtWidgets.QListWidget.itemFromIndex": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QListWidget.itemWidget": ('PySide2.QtWidgets.QListWidgetItem',),
    "PySide2.QtWidgets.QListWidget.items": ('PySide2.QtCore.QMimeData',),
    "PySide2.QtWidgets.QListWidget.mimeData": ('typing.Sequence',),
    "PySide2.QtWidgets.QListWidget.mimeTypes": (),
    "PySide2.QtWidgets.QListWidget.openPersistentEditor": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QListWidgetItem',)],
    "PySide2.QtWidgets.QListWidget.removeItemWidget": ('PySide2.QtWidgets.QListWidgetItem',),
    "PySide2.QtWidgets.QListWidget.row": ('PySide2.QtWidgets.QListWidgetItem',),
    "PySide2.QtWidgets.QListWidget.scrollToItem": ('PySide2.QtWidgets.QListWidgetItem', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
    "PySide2.QtWidgets.QListWidget.selectedItems": (),
    "PySide2.QtWidgets.QListWidget.setCurrentItem": [('PySide2.QtWidgets.QListWidgetItem',), ('PySide2.QtWidgets.QListWidgetItem', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags')],
    "PySide2.QtWidgets.QListWidget.setCurrentRow": [('int',), ('int', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags')],
    "PySide2.QtWidgets.QListWidget.setItemHidden": ('PySide2.QtWidgets.QListWidgetItem', 'bool'),
    "PySide2.QtWidgets.QListWidget.setItemSelected": ('PySide2.QtWidgets.QListWidgetItem', 'bool'),
    "PySide2.QtWidgets.QListWidget.setItemWidget": ('PySide2.QtWidgets.QListWidgetItem', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QListWidget.setModel": ('PySide2.QtCore.QAbstractItemModel',),
    "PySide2.QtWidgets.QListWidget.setSelectionModel": ('PySide2.QtCore.QItemSelectionModel',),
    "PySide2.QtWidgets.QListWidget.setSortingEnabled": ('bool',),
    "PySide2.QtWidgets.QListWidget.sortItems": ('PySide2.QtCore.Qt.SortOrder',),
    "PySide2.QtWidgets.QListWidget.supportedDropActions": (),
    "PySide2.QtWidgets.QListWidget.takeItem": ('int',),
    "PySide2.QtWidgets.QListWidget.visualItemRect": ('PySide2.QtWidgets.QListWidgetItem',),

# class PySide2.QtWidgets.QListWidgetItem:

# class PySide2.QtWidgets.QListWidgetItem.ItemType:
    "PySide2.QtWidgets.QListWidgetItem.__init__": [('PySide2.QtGui.QIcon', 'str', 'PySide2.QtWidgets.QListWidget', 'int'), ('PySide2.QtWidgets.QListWidget', 'int'), ('PySide2.QtWidgets.QListWidgetItem',), ('str', 'PySide2.QtWidgets.QListWidget', 'int')],
    "PySide2.QtWidgets.QListWidgetItem.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtWidgets.QListWidgetItem.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtWidgets.QListWidgetItem.background": (),
    "PySide2.QtWidgets.QListWidgetItem.backgroundColor": (),
    "PySide2.QtWidgets.QListWidgetItem.checkState": (),
    "PySide2.QtWidgets.QListWidgetItem.clone": (),
    "PySide2.QtWidgets.QListWidgetItem.data": ('int',),
    "PySide2.QtWidgets.QListWidgetItem.flags": (),
    "PySide2.QtWidgets.QListWidgetItem.font": (),
    "PySide2.QtWidgets.QListWidgetItem.foreground": (),
    "PySide2.QtWidgets.QListWidgetItem.icon": (),
    "PySide2.QtWidgets.QListWidgetItem.isHidden": (),
    "PySide2.QtWidgets.QListWidgetItem.isSelected": (),
    "PySide2.QtWidgets.QListWidgetItem.listWidget": (),
    "PySide2.QtWidgets.QListWidgetItem.read": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtWidgets.QListWidgetItem.setBackground": ('PySide2.QtGui.QBrush',),
    "PySide2.QtWidgets.QListWidgetItem.setBackgroundColor": ('PySide2.QtGui.QColor',),
    "PySide2.QtWidgets.QListWidgetItem.setCheckState": ('PySide2.QtCore.Qt.CheckState',),
    "PySide2.QtWidgets.QListWidgetItem.setData": ('int', 'typing.Any'),
    "PySide2.QtWidgets.QListWidgetItem.setFlags": ('PySide2.QtCore.Qt.ItemFlags',),
    "PySide2.QtWidgets.QListWidgetItem.setFont": ('PySide2.QtGui.QFont',),
    "PySide2.QtWidgets.QListWidgetItem.setForeground": ('PySide2.QtGui.QBrush',),
    "PySide2.QtWidgets.QListWidgetItem.setHidden": ('bool',),
    "PySide2.QtWidgets.QListWidgetItem.setIcon": ('PySide2.QtGui.QIcon',),
    "PySide2.QtWidgets.QListWidgetItem.setSelected": ('bool',),
    "PySide2.QtWidgets.QListWidgetItem.setSizeHint": ('PySide2.QtCore.QSize',),
    "PySide2.QtWidgets.QListWidgetItem.setStatusTip": ('str',),
    "PySide2.QtWidgets.QListWidgetItem.setText": ('str',),
    "PySide2.QtWidgets.QListWidgetItem.setTextAlignment": ('int',),
    "PySide2.QtWidgets.QListWidgetItem.setTextColor": ('PySide2.QtGui.QColor',),
    "PySide2.QtWidgets.QListWidgetItem.setToolTip": ('str',),
    "PySide2.QtWidgets.QListWidgetItem.setWhatsThis": ('str',),
    "PySide2.QtWidgets.QListWidgetItem.sizeHint": (),
    "PySide2.QtWidgets.QListWidgetItem.statusTip": (),
    "PySide2.QtWidgets.QListWidgetItem.text": (),
    "PySide2.QtWidgets.QListWidgetItem.textAlignment": (),
    "PySide2.QtWidgets.QListWidgetItem.textColor": (),
    "PySide2.QtWidgets.QListWidgetItem.toolTip": (),
    "PySide2.QtWidgets.QListWidgetItem.type": (),
    "PySide2.QtWidgets.QListWidgetItem.whatsThis": (),
    "PySide2.QtWidgets.QListWidgetItem.write": ('PySide2.QtCore.QDataStream',),

# class PySide2.QtWidgets.QMainWindow:

# class PySide2.QtWidgets.QMainWindow.DockOption:

# class PySide2.QtWidgets.QMainWindow.DockOptions:
    "PySide2.QtWidgets.QMainWindow.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
    "PySide2.QtWidgets.QMainWindow.addDockWidget": [('PySide2.QtCore.Qt.DockWidgetArea', 'PySide2.QtWidgets.QDockWidget'), ('PySide2.QtCore.Qt.DockWidgetArea', 'PySide2.QtWidgets.QDockWidget', 'PySide2.QtCore.Qt.Orientation')],
    "PySide2.QtWidgets.QMainWindow.addToolBar": [('PySide2.QtCore.Qt.ToolBarArea', 'PySide2.QtWidgets.QToolBar'), ('PySide2.QtWidgets.QToolBar',), ('str',)],
    "PySide2.QtWidgets.QMainWindow.addToolBarBreak": ('PySide2.QtCore.Qt.ToolBarArea',),
    "PySide2.QtWidgets.QMainWindow.centralWidget": (),
    "PySide2.QtWidgets.QMainWindow.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
    "PySide2.QtWidgets.QMainWindow.corner": ('PySide2.QtCore.Qt.Corner',),
    "PySide2.QtWidgets.QMainWindow.createPopupMenu": (),
    "PySide2.QtWidgets.QMainWindow.dockOptions": (),
    "PySide2.QtWidgets.QMainWindow.dockWidgetArea": ('PySide2.QtWidgets.QDockWidget',),
    "PySide2.QtWidgets.QMainWindow.documentMode": (),
    "PySide2.QtWidgets.QMainWindow.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QMainWindow.iconSize": (),
    "PySide2.QtWidgets.QMainWindow.insertToolBar": ('PySide2.QtWidgets.QToolBar', 'PySide2.QtWidgets.QToolBar'),
    "PySide2.QtWidgets.QMainWindow.insertToolBarBreak": ('PySide2.QtWidgets.QToolBar',),
    "PySide2.QtWidgets.QMainWindow.isAnimated": (),
    "PySide2.QtWidgets.QMainWindow.isDockNestingEnabled": (),
    "PySide2.QtWidgets.QMainWindow.isSeparator": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QMainWindow.menuBar": (),
    "PySide2.QtWidgets.QMainWindow.menuWidget": (),
    "PySide2.QtWidgets.QMainWindow.removeDockWidget": ('PySide2.QtWidgets.QDockWidget',),
    "PySide2.QtWidgets.QMainWindow.removeToolBar": ('PySide2.QtWidgets.QToolBar',),
    "PySide2.QtWidgets.QMainWindow.removeToolBarBreak": ('PySide2.QtWidgets.QToolBar',),
    "PySide2.QtWidgets.QMainWindow.resizeDocks": ('typing.Sequence', 'typing.Sequence', 'PySide2.QtCore.Qt.Orientation'),
    "PySide2.QtWidgets.QMainWindow.restoreDockWidget": ('PySide2.QtWidgets.QDockWidget',),
    "PySide2.QtWidgets.QMainWindow.restoreState": ('PySide2.QtCore.QByteArray', 'int'),
    "PySide2.QtWidgets.QMainWindow.saveState": ('int',),
    "PySide2.QtWidgets.QMainWindow.setAnimated": ('bool',),
    "PySide2.QtWidgets.QMainWindow.setCentralWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QMainWindow.setCorner": ('PySide2.QtCore.Qt.Corner', 'PySide2.QtCore.Qt.DockWidgetArea'),
    "PySide2.QtWidgets.QMainWindow.setDockNestingEnabled": ('bool',),
    "PySide2.QtWidgets.QMainWindow.setDockOptions": ('PySide2.QtWidgets.QMainWindow.DockOptions',),
    "PySide2.QtWidgets.QMainWindow.setDocumentMode": ('bool',),
    "PySide2.QtWidgets.QMainWindow.setIconSize": ('PySide2.QtCore.QSize',),
    "PySide2.QtWidgets.QMainWindow.setMenuBar": ('PySide2.QtWidgets.QMenuBar',),
    "PySide2.QtWidgets.QMainWindow.setMenuWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QMainWindow.setStatusBar": ('PySide2.QtWidgets.QStatusBar',),
    "PySide2.QtWidgets.QMainWindow.setTabPosition": ('PySide2.QtCore.Qt.DockWidgetAreas', 'PySide2.QtWidgets.QTabWidget.TabPosition'),
    "PySide2.QtWidgets.QMainWindow.setTabShape": ('PySide2.QtWidgets.QTabWidget.TabShape',),
    "PySide2.QtWidgets.QMainWindow.setToolButtonStyle": ('PySide2.QtCore.Qt.ToolButtonStyle',),
    "PySide2.QtWidgets.QMainWindow.setUnifiedTitleAndToolBarOnMac": ('bool',),
    "PySide2.QtWidgets.QMainWindow.splitDockWidget": ('PySide2.QtWidgets.QDockWidget', 'PySide2.QtWidgets.QDockWidget', 'PySide2.QtCore.Qt.Orientation'),
    "PySide2.QtWidgets.QMainWindow.statusBar": (),
    "PySide2.QtWidgets.QMainWindow.tabPosition": ('PySide2.QtCore.Qt.DockWidgetArea',),
    "PySide2.QtWidgets.QMainWindow.tabShape": (),
    "PySide2.QtWidgets.QMainWindow.tabifiedDockWidgets": ('PySide2.QtWidgets.QDockWidget',),
    "PySide2.QtWidgets.QMainWindow.tabifyDockWidget": ('PySide2.QtWidgets.QDockWidget', 'PySide2.QtWidgets.QDockWidget'),
    "PySide2.QtWidgets.QMainWindow.takeCentralWidget": (),
    "PySide2.QtWidgets.QMainWindow.toolBarArea": ('PySide2.QtWidgets.QToolBar',),
    "PySide2.QtWidgets.QMainWindow.toolBarBreak": ('PySide2.QtWidgets.QToolBar',),
    "PySide2.QtWidgets.QMainWindow.toolButtonStyle": (),
    "PySide2.QtWidgets.QMainWindow.unifiedTitleAndToolBarOnMac": (),

# class PySide2.QtWidgets.QMdiArea:

# class PySide2.QtWidgets.QMdiArea.AreaOption:

# class PySide2.QtWidgets.QMdiArea.AreaOptions:

# class PySide2.QtWidgets.QMdiArea.ViewMode:

# class PySide2.QtWidgets.QMdiArea.WindowOrder:
    "PySide2.QtWidgets.QMdiArea.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QMdiArea.activateNextSubWindow": (),
    "PySide2.QtWidgets.QMdiArea.activatePreviousSubWindow": (),
    "PySide2.QtWidgets.QMdiArea.activationOrder": (),
    "PySide2.QtWidgets.QMdiArea.activeSubWindow": (),
    "PySide2.QtWidgets.QMdiArea.addSubWindow": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
    "PySide2.QtWidgets.QMdiArea.background": (),
    "PySide2.QtWidgets.QMdiArea.cascadeSubWindows": (),
    "PySide2.QtWidgets.QMdiArea.childEvent": ('PySide2.QtCore.QChildEvent',),
    "PySide2.QtWidgets.QMdiArea.closeActiveSubWindow": (),
    "PySide2.QtWidgets.QMdiArea.closeAllSubWindows": (),
    "PySide2.QtWidgets.QMdiArea.currentSubWindow": (),
    "PySide2.QtWidgets.QMdiArea.documentMode": (),
    "PySide2.QtWidgets.QMdiArea.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QMdiArea.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QMdiArea.minimumSizeHint": (),
    "PySide2.QtWidgets.QMdiArea.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QMdiArea.removeSubWindow": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QMdiArea.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QMdiArea.scrollContentsBy": ('int', 'int'),
    "PySide2.QtWidgets.QMdiArea.setActivationOrder": ('PySide2.QtWidgets.QMdiArea.WindowOrder',),
    "PySide2.QtWidgets.QMdiArea.setActiveSubWindow": ('PySide2.QtWidgets.QMdiSubWindow',),
    "PySide2.QtWidgets.QMdiArea.setBackground": ('PySide2.QtGui.QBrush',),
    "PySide2.QtWidgets.QMdiArea.setDocumentMode": ('bool',),
    "PySide2.QtWidgets.QMdiArea.setOption": ('PySide2.QtWidgets.QMdiArea.AreaOption', 'bool'),
    "PySide2.QtWidgets.QMdiArea.setTabPosition": ('PySide2.QtWidgets.QTabWidget.TabPosition',),
    "PySide2.QtWidgets.QMdiArea.setTabShape": ('PySide2.QtWidgets.QTabWidget.TabShape',),
    "PySide2.QtWidgets.QMdiArea.setTabsClosable": ('bool',),
    "PySide2.QtWidgets.QMdiArea.setTabsMovable": ('bool',),
    "PySide2.QtWidgets.QMdiArea.setViewMode": ('PySide2.QtWidgets.QMdiArea.ViewMode',),
    "PySide2.QtWidgets.QMdiArea.setupViewport": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QMdiArea.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QMdiArea.sizeHint": (),
    "PySide2.QtWidgets.QMdiArea.subWindowList": ('PySide2.QtWidgets.QMdiArea.WindowOrder',),
    "PySide2.QtWidgets.QMdiArea.tabPosition": (),
    "PySide2.QtWidgets.QMdiArea.tabShape": (),
    "PySide2.QtWidgets.QMdiArea.tabsClosable": (),
    "PySide2.QtWidgets.QMdiArea.tabsMovable": (),
    "PySide2.QtWidgets.QMdiArea.testOption": ('PySide2.QtWidgets.QMdiArea.AreaOption',),
    "PySide2.QtWidgets.QMdiArea.tileSubWindows": (),
    "PySide2.QtWidgets.QMdiArea.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtWidgets.QMdiArea.viewMode": (),
    "PySide2.QtWidgets.QMdiArea.viewportEvent": ('PySide2.QtCore.QEvent',),

# class PySide2.QtWidgets.QMdiSubWindow:

# class PySide2.QtWidgets.QMdiSubWindow.SubWindowOption:

# class PySide2.QtWidgets.QMdiSubWindow.SubWindowOptions:
    "PySide2.QtWidgets.QMdiSubWindow.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
    "PySide2.QtWidgets.QMdiSubWindow.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.childEvent": ('PySide2.QtCore.QChildEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.closeEvent": ('PySide2.QtGui.QCloseEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QMdiSubWindow.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.hideEvent": ('PySide2.QtGui.QHideEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.isShaded": (),
    "PySide2.QtWidgets.QMdiSubWindow.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.keyboardPageStep": (),
    "PySide2.QtWidgets.QMdiSubWindow.keyboardSingleStep": (),
    "PySide2.QtWidgets.QMdiSubWindow.leaveEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.maximizedButtonsWidget": (),
    "PySide2.QtWidgets.QMdiSubWindow.maximizedSystemMenuIconWidget": (),
    "PySide2.QtWidgets.QMdiSubWindow.mdiArea": (),
    "PySide2.QtWidgets.QMdiSubWindow.minimumSizeHint": (),
    "PySide2.QtWidgets.QMdiSubWindow.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.moveEvent": ('PySide2.QtGui.QMoveEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.setKeyboardPageStep": ('int',),
    "PySide2.QtWidgets.QMdiSubWindow.setKeyboardSingleStep": ('int',),
    "PySide2.QtWidgets.QMdiSubWindow.setOption": ('PySide2.QtWidgets.QMdiSubWindow.SubWindowOption', 'bool'),
    "PySide2.QtWidgets.QMdiSubWindow.setSystemMenu": ('PySide2.QtWidgets.QMenu',),
    "PySide2.QtWidgets.QMdiSubWindow.setWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QMdiSubWindow.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.showShaded": (),
    "PySide2.QtWidgets.QMdiSubWindow.showSystemMenu": (),
    "PySide2.QtWidgets.QMdiSubWindow.sizeHint": (),
    "PySide2.QtWidgets.QMdiSubWindow.systemMenu": (),
    "PySide2.QtWidgets.QMdiSubWindow.testOption": ('PySide2.QtWidgets.QMdiSubWindow.SubWindowOption',),
    "PySide2.QtWidgets.QMdiSubWindow.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtWidgets.QMdiSubWindow.widget": (),

# class PySide2.QtWidgets.QMenu:
    "PySide2.QtWidgets.QMenu.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
    "PySide2.QtWidgets.QMenu.actionAt": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QMenu.actionEvent": ('PySide2.QtGui.QActionEvent',),
    "PySide2.QtWidgets.QMenu.actionGeometry": ('PySide2.QtWidgets.QAction',),
    "PySide2.QtWidgets.QMenu.activeAction": (),
    "PySide2.QtWidgets.QMenu.addAction": [('PySide2.QtGui.QIcon', 'str'), ('PySide2.QtGui.QIcon', 'str', 'PySide2.QtCore.QObject', 'bytes', 'PySide2.QtGui.QKeySequence'), ('PySide2.QtGui.QIcon', 'str', 'object', 'PySide2.QtGui.QKeySequence'), ('PySide2.QtWidgets.QAction',), ('str',), ('str', 'PySide2.QtCore.QObject', 'bytes', 'PySide2.QtGui.QKeySequence'), ('str', 'object', 'PySide2.QtGui.QKeySequence')],
    "PySide2.QtWidgets.QMenu.addMenu": [('PySide2.QtGui.QIcon', 'str'), ('PySide2.QtWidgets.QMenu',), ('str',)],
    "PySide2.QtWidgets.QMenu.addSection": [('PySide2.QtGui.QIcon', 'str'), ('str',)],
    "PySide2.QtWidgets.QMenu.addSeparator": (),
    "PySide2.QtWidgets.QMenu.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QMenu.clear": (),
    "PySide2.QtWidgets.QMenu.columnCount": (),
    "PySide2.QtWidgets.QMenu.defaultAction": (),
    "PySide2.QtWidgets.QMenu.enterEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QMenu.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QMenu.exec_": [(), ('PySide2.QtCore.QPoint', 'PySide2.QtWidgets.QAction'), ('typing.Sequence', 'PySide2.QtCore.QPoint', 'PySide2.QtWidgets.QAction', 'PySide2.QtWidgets.QWidget')],
    "PySide2.QtWidgets.QMenu.focusNextPrevChild": ('bool',),
    "PySide2.QtWidgets.QMenu.hideEvent": ('PySide2.QtGui.QHideEvent',),
    "PySide2.QtWidgets.QMenu.hideTearOffMenu": (),
    "PySide2.QtWidgets.QMenu.icon": (),
    "PySide2.QtWidgets.QMenu.initStyleOption": ('PySide2.QtWidgets.QStyleOptionMenuItem', 'PySide2.QtWidgets.QAction'),
    "PySide2.QtWidgets.QMenu.insertMenu": ('PySide2.QtWidgets.QAction', 'PySide2.QtWidgets.QMenu'),
    "PySide2.QtWidgets.QMenu.insertSection": [('PySide2.QtWidgets.QAction', 'PySide2.QtGui.QIcon', 'str'), ('PySide2.QtWidgets.QAction', 'str')],
    "PySide2.QtWidgets.QMenu.insertSeparator": ('PySide2.QtWidgets.QAction',),
    "PySide2.QtWidgets.QMenu.isEmpty": (),
    "PySide2.QtWidgets.QMenu.isTearOffEnabled": (),
    "PySide2.QtWidgets.QMenu.isTearOffMenuVisible": (),
    "PySide2.QtWidgets.QMenu.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QMenu.leaveEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QMenu.menuAction": (),
    "PySide2.QtWidgets.QMenu.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QMenu.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QMenu.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QMenu.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QMenu.popup": ('PySide2.QtCore.QPoint', 'PySide2.QtWidgets.QAction'),
    "PySide2.QtWidgets.QMenu.separatorsCollapsible": (),
    "PySide2.QtWidgets.QMenu.setActiveAction": ('PySide2.QtWidgets.QAction',),
    "PySide2.QtWidgets.QMenu.setDefaultAction": ('PySide2.QtWidgets.QAction',),
    "PySide2.QtWidgets.QMenu.setIcon": ('PySide2.QtGui.QIcon',),
    "PySide2.QtWidgets.QMenu.setSeparatorsCollapsible": ('bool',),
    "PySide2.QtWidgets.QMenu.setTearOffEnabled": ('bool',),
    "PySide2.QtWidgets.QMenu.setTitle": ('str',),
    "PySide2.QtWidgets.QMenu.setToolTipsVisible": ('bool',),
    "PySide2.QtWidgets.QMenu.showTearOffMenu": [(), ('PySide2.QtCore.QPoint',)],
    "PySide2.QtWidgets.QMenu.sizeHint": (),
    "PySide2.QtWidgets.QMenu.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtWidgets.QMenu.title": (),
    "PySide2.QtWidgets.QMenu.toolTipsVisible": (),
    "PySide2.QtWidgets.QMenu.wheelEvent": ('PySide2.QtGui.QWheelEvent',),

# class PySide2.QtWidgets.QMenuBar:
    "PySide2.QtWidgets.QMenuBar.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QMenuBar.actionAt": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QMenuBar.actionEvent": ('PySide2.QtGui.QActionEvent',),
    "PySide2.QtWidgets.QMenuBar.actionGeometry": ('PySide2.QtWidgets.QAction',),
    "PySide2.QtWidgets.QMenuBar.activeAction": (),
    "PySide2.QtWidgets.QMenuBar.addAction": [('PySide2.QtWidgets.QAction',), ('str',), ('str', 'PySide2.QtCore.QObject', 'bytes'), ('str', 'object')],
    "PySide2.QtWidgets.QMenuBar.addMenu": [('PySide2.QtGui.QIcon', 'str'), ('PySide2.QtWidgets.QMenu',), ('str',)],
    "PySide2.QtWidgets.QMenuBar.addSeparator": (),
    "PySide2.QtWidgets.QMenuBar.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QMenuBar.clear": (),
    "PySide2.QtWidgets.QMenuBar.cornerWidget": ('PySide2.QtCore.Qt.Corner',),
    "PySide2.QtWidgets.QMenuBar.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QMenuBar.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QMenuBar.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QMenuBar.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QMenuBar.heightForWidth": ('int',),
    "PySide2.QtWidgets.QMenuBar.initStyleOption": ('PySide2.QtWidgets.QStyleOptionMenuItem', 'PySide2.QtWidgets.QAction'),
    "PySide2.QtWidgets.QMenuBar.insertMenu": ('PySide2.QtWidgets.QAction', 'PySide2.QtWidgets.QMenu'),
    "PySide2.QtWidgets.QMenuBar.insertSeparator": ('PySide2.QtWidgets.QAction',),
    "PySide2.QtWidgets.QMenuBar.isDefaultUp": (),
    "PySide2.QtWidgets.QMenuBar.isNativeMenuBar": (),
    "PySide2.QtWidgets.QMenuBar.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QMenuBar.leaveEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QMenuBar.minimumSizeHint": (),
    "PySide2.QtWidgets.QMenuBar.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QMenuBar.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QMenuBar.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QMenuBar.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QMenuBar.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QMenuBar.setActiveAction": ('PySide2.QtWidgets.QAction',),
    "PySide2.QtWidgets.QMenuBar.setCornerWidget": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.Corner'),
    "PySide2.QtWidgets.QMenuBar.setDefaultUp": ('bool',),
    "PySide2.QtWidgets.QMenuBar.setNativeMenuBar": ('bool',),
    "PySide2.QtWidgets.QMenuBar.setVisible": ('bool',),
    "PySide2.QtWidgets.QMenuBar.sizeHint": (),
    "PySide2.QtWidgets.QMenuBar.timerEvent": ('PySide2.QtCore.QTimerEvent',),

# class PySide2.QtWidgets.QMessageBox:

# class PySide2.QtWidgets.QMessageBox.ButtonRole:

# class PySide2.QtWidgets.QMessageBox.Icon:

# class PySide2.QtWidgets.QMessageBox.StandardButton:

# class PySide2.QtWidgets.QMessageBox.StandardButtons:
    "PySide2.QtWidgets.QMessageBox.__init__": [('PySide2.QtWidgets.QMessageBox.Icon', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButtons', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QMessageBox.about": ('PySide2.QtWidgets.QWidget', 'str', 'str'),
    "PySide2.QtWidgets.QMessageBox.aboutQt": ('PySide2.QtWidgets.QWidget', 'str'),
    "PySide2.QtWidgets.QMessageBox.addButton": [('PySide2.QtWidgets.QAbstractButton', 'PySide2.QtWidgets.QMessageBox.ButtonRole'), ('PySide2.QtWidgets.QMessageBox.StandardButton',), ('str', 'PySide2.QtWidgets.QMessageBox.ButtonRole')],
    "PySide2.QtWidgets.QMessageBox.button": ('PySide2.QtWidgets.QMessageBox.StandardButton',),
    "PySide2.QtWidgets.QMessageBox.buttonRole": ('PySide2.QtWidgets.QAbstractButton',),
    "PySide2.QtWidgets.QMessageBox.buttonText": ('int',),
    "PySide2.QtWidgets.QMessageBox.buttons": (),
    "PySide2.QtWidgets.QMessageBox.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QMessageBox.checkBox": (),
    "PySide2.QtWidgets.QMessageBox.clickedButton": (),
    "PySide2.QtWidgets.QMessageBox.closeEvent": ('PySide2.QtGui.QCloseEvent',),
    "PySide2.QtWidgets.QMessageBox.critical": [('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButton', 'PySide2.QtWidgets.QMessageBox.StandardButton'), ('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButtons', 'PySide2.QtWidgets.QMessageBox.StandardButton')],
    "PySide2.QtWidgets.QMessageBox.defaultButton": (),
    "PySide2.QtWidgets.QMessageBox.detailedText": (),
    "PySide2.QtWidgets.QMessageBox.escapeButton": (),
    "PySide2.QtWidgets.QMessageBox.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QMessageBox.icon": (),
    "PySide2.QtWidgets.QMessageBox.iconPixmap": (),
    "PySide2.QtWidgets.QMessageBox.information": [('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButton', 'PySide2.QtWidgets.QMessageBox.StandardButton'), ('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButtons', 'PySide2.QtWidgets.QMessageBox.StandardButton')],
    "PySide2.QtWidgets.QMessageBox.informativeText": (),
    "PySide2.QtWidgets.QMessageBox.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QMessageBox.open": [(), ('PySide2.QtCore.QObject', 'bytes')],
    "PySide2.QtWidgets.QMessageBox.question": [('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButton', 'PySide2.QtWidgets.QMessageBox.StandardButton'), ('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButtons', 'PySide2.QtWidgets.QMessageBox.StandardButton')],
    "PySide2.QtWidgets.QMessageBox.removeButton": ('PySide2.QtWidgets.QAbstractButton',),
    "PySide2.QtWidgets.QMessageBox.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QMessageBox.setButtonText": ('int', 'str'),
    "PySide2.QtWidgets.QMessageBox.setCheckBox": ('PySide2.QtWidgets.QCheckBox',),
    "PySide2.QtWidgets.QMessageBox.setDefaultButton": [('PySide2.QtWidgets.QMessageBox.StandardButton',), ('PySide2.QtWidgets.QPushButton',)],
    "PySide2.QtWidgets.QMessageBox.setDetailedText": ('str',),
    "PySide2.QtWidgets.QMessageBox.setEscapeButton": [('PySide2.QtWidgets.QAbstractButton',), ('PySide2.QtWidgets.QMessageBox.StandardButton',)],
    "PySide2.QtWidgets.QMessageBox.setIcon": ('PySide2.QtWidgets.QMessageBox.Icon',),
    "PySide2.QtWidgets.QMessageBox.setIconPixmap": ('PySide2.QtGui.QPixmap',),
    "PySide2.QtWidgets.QMessageBox.setInformativeText": ('str',),
    "PySide2.QtWidgets.QMessageBox.setStandardButtons": ('PySide2.QtWidgets.QMessageBox.StandardButtons',),
    "PySide2.QtWidgets.QMessageBox.setText": ('str',),
    "PySide2.QtWidgets.QMessageBox.setTextFormat": ('PySide2.QtCore.Qt.TextFormat',),
    "PySide2.QtWidgets.QMessageBox.setTextInteractionFlags": ('PySide2.QtCore.Qt.TextInteractionFlags',),
    "PySide2.QtWidgets.QMessageBox.setWindowModality": ('PySide2.QtCore.Qt.WindowModality',),
    "PySide2.QtWidgets.QMessageBox.setWindowTitle": ('str',),
    "PySide2.QtWidgets.QMessageBox.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QMessageBox.standardButton": ('PySide2.QtWidgets.QAbstractButton',),
    "PySide2.QtWidgets.QMessageBox.standardButtons": (),
    "PySide2.QtWidgets.QMessageBox.standardIcon": ('PySide2.QtWidgets.QMessageBox.Icon',),
    "PySide2.QtWidgets.QMessageBox.text": (),
    "PySide2.QtWidgets.QMessageBox.textFormat": (),
    "PySide2.QtWidgets.QMessageBox.textInteractionFlags": (),
    "PySide2.QtWidgets.QMessageBox.warning": [('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButton', 'PySide2.QtWidgets.QMessageBox.StandardButton'), ('PySide2.QtWidgets.QWidget', 'str', 'str', 'PySide2.QtWidgets.QMessageBox.StandardButtons', 'PySide2.QtWidgets.QMessageBox.StandardButton')],

# class PySide2.QtWidgets.QMouseEventTransition:
    "PySide2.QtWidgets.QMouseEventTransition.__init__": [('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent.Type', 'PySide2.QtCore.Qt.MouseButton', 'PySide2.QtCore.QState'), ('PySide2.QtCore.QState',)],
    "PySide2.QtWidgets.QMouseEventTransition.button": (),
    "PySide2.QtWidgets.QMouseEventTransition.eventTest": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QMouseEventTransition.hitTestPath": (),
    "PySide2.QtWidgets.QMouseEventTransition.modifierMask": (),
    "PySide2.QtWidgets.QMouseEventTransition.onTransition": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QMouseEventTransition.setButton": ('PySide2.QtCore.Qt.MouseButton',),
    "PySide2.QtWidgets.QMouseEventTransition.setHitTestPath": ('PySide2.QtGui.QPainterPath',),
    "PySide2.QtWidgets.QMouseEventTransition.setModifierMask": ('PySide2.QtCore.Qt.KeyboardModifiers',),

# class PySide2.QtWidgets.QOpenGLWidget:

# class PySide2.QtWidgets.QOpenGLWidget.UpdateBehavior:
    "PySide2.QtWidgets.QOpenGLWidget.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
    "PySide2.QtWidgets.QOpenGLWidget.context": (),
    "PySide2.QtWidgets.QOpenGLWidget.defaultFramebufferObject": (),
    "PySide2.QtWidgets.QOpenGLWidget.doneCurrent": (),
    "PySide2.QtWidgets.QOpenGLWidget.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QOpenGLWidget.format": (),
    "PySide2.QtWidgets.QOpenGLWidget.grabFramebuffer": (),
    "PySide2.QtWidgets.QOpenGLWidget.initializeGL": (),
    "PySide2.QtWidgets.QOpenGLWidget.isValid": (),
    "PySide2.QtWidgets.QOpenGLWidget.makeCurrent": (),
    "PySide2.QtWidgets.QOpenGLWidget.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
    "PySide2.QtWidgets.QOpenGLWidget.paintEngine": (),
    "PySide2.QtWidgets.QOpenGLWidget.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QOpenGLWidget.paintGL": (),
    "PySide2.QtWidgets.QOpenGLWidget.redirected": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QOpenGLWidget.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QOpenGLWidget.resizeGL": ('int', 'int'),
    "PySide2.QtWidgets.QOpenGLWidget.setFormat": ('PySide2.QtGui.QSurfaceFormat',),
    "PySide2.QtWidgets.QOpenGLWidget.setTextureFormat": ('int',),
    "PySide2.QtWidgets.QOpenGLWidget.setUpdateBehavior": ('PySide2.QtWidgets.QOpenGLWidget.UpdateBehavior',),
    "PySide2.QtWidgets.QOpenGLWidget.textureFormat": (),
    "PySide2.QtWidgets.QOpenGLWidget.updateBehavior": (),

# class PySide2.QtWidgets.QPanGesture:
    "PySide2.QtWidgets.QPanGesture.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QPanGesture.acceleration": (),
    "PySide2.QtWidgets.QPanGesture.delta": (),
    "PySide2.QtWidgets.QPanGesture.lastOffset": (),
    "PySide2.QtWidgets.QPanGesture.offset": (),
    "PySide2.QtWidgets.QPanGesture.setAcceleration": ('float',),
    "PySide2.QtWidgets.QPanGesture.setLastOffset": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QPanGesture.setOffset": ('PySide2.QtCore.QPointF',),

# class PySide2.QtWidgets.QPinchGesture:

# class PySide2.QtWidgets.QPinchGesture.ChangeFlag:

# class PySide2.QtWidgets.QPinchGesture.ChangeFlags:
    "PySide2.QtWidgets.QPinchGesture.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QPinchGesture.centerPoint": (),
    "PySide2.QtWidgets.QPinchGesture.changeFlags": (),
    "PySide2.QtWidgets.QPinchGesture.lastCenterPoint": (),
    "PySide2.QtWidgets.QPinchGesture.lastRotationAngle": (),
    "PySide2.QtWidgets.QPinchGesture.lastScaleFactor": (),
    "PySide2.QtWidgets.QPinchGesture.rotationAngle": (),
    "PySide2.QtWidgets.QPinchGesture.scaleFactor": (),
    "PySide2.QtWidgets.QPinchGesture.setCenterPoint": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QPinchGesture.setChangeFlags": ('PySide2.QtWidgets.QPinchGesture.ChangeFlags',),
    "PySide2.QtWidgets.QPinchGesture.setLastCenterPoint": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QPinchGesture.setLastRotationAngle": ('float',),
    "PySide2.QtWidgets.QPinchGesture.setLastScaleFactor": ('float',),
    "PySide2.QtWidgets.QPinchGesture.setRotationAngle": ('float',),
    "PySide2.QtWidgets.QPinchGesture.setScaleFactor": ('float',),
    "PySide2.QtWidgets.QPinchGesture.setStartCenterPoint": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QPinchGesture.setTotalChangeFlags": ('PySide2.QtWidgets.QPinchGesture.ChangeFlags',),
    "PySide2.QtWidgets.QPinchGesture.setTotalRotationAngle": ('float',),
    "PySide2.QtWidgets.QPinchGesture.setTotalScaleFactor": ('float',),
    "PySide2.QtWidgets.QPinchGesture.startCenterPoint": (),
    "PySide2.QtWidgets.QPinchGesture.totalChangeFlags": (),
    "PySide2.QtWidgets.QPinchGesture.totalRotationAngle": (),
    "PySide2.QtWidgets.QPinchGesture.totalScaleFactor": (),

# class PySide2.QtWidgets.QPlainTextDocumentLayout:
    "PySide2.QtWidgets.QPlainTextDocumentLayout.__init__": ('PySide2.QtGui.QTextDocument',),
    "PySide2.QtWidgets.QPlainTextDocumentLayout.blockBoundingRect": ('PySide2.QtGui.QTextBlock',),
    "PySide2.QtWidgets.QPlainTextDocumentLayout.cursorWidth": (),
    "PySide2.QtWidgets.QPlainTextDocumentLayout.documentChanged": ('int', 'int', 'int'),
    "PySide2.QtWidgets.QPlainTextDocumentLayout.documentSize": (),
    "PySide2.QtWidgets.QPlainTextDocumentLayout.draw": ('PySide2.QtGui.QPainter', 'PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext'),
    "PySide2.QtWidgets.QPlainTextDocumentLayout.ensureBlockLayout": ('PySide2.QtGui.QTextBlock',),
    "PySide2.QtWidgets.QPlainTextDocumentLayout.frameBoundingRect": ('PySide2.QtGui.QTextFrame',),
    "PySide2.QtWidgets.QPlainTextDocumentLayout.hitTest": ('PySide2.QtCore.QPointF', 'PySide2.QtCore.Qt.HitTestAccuracy'),
    "PySide2.QtWidgets.QPlainTextDocumentLayout.pageCount": (),
    "PySide2.QtWidgets.QPlainTextDocumentLayout.requestUpdate": (),
    "PySide2.QtWidgets.QPlainTextDocumentLayout.setCursorWidth": ('int',),

# class PySide2.QtWidgets.QPlainTextEdit:

# class PySide2.QtWidgets.QPlainTextEdit.LineWrapMode:
    "PySide2.QtWidgets.QPlainTextEdit.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
    "PySide2.QtWidgets.QPlainTextEdit.anchorAt": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QPlainTextEdit.appendHtml": ('str',),
    "PySide2.QtWidgets.QPlainTextEdit.appendPlainText": ('str',),
    "PySide2.QtWidgets.QPlainTextEdit.backgroundVisible": (),
    "PySide2.QtWidgets.QPlainTextEdit.blockBoundingGeometry": ('PySide2.QtGui.QTextBlock',),
    "PySide2.QtWidgets.QPlainTextEdit.blockBoundingRect": ('PySide2.QtGui.QTextBlock',),
    "PySide2.QtWidgets.QPlainTextEdit.blockCount": (),
    "PySide2.QtWidgets.QPlainTextEdit.canInsertFromMimeData": ('PySide2.QtCore.QMimeData',),
    "PySide2.QtWidgets.QPlainTextEdit.canPaste": (),
    "PySide2.QtWidgets.QPlainTextEdit.centerCursor": (),
    "PySide2.QtWidgets.QPlainTextEdit.centerOnScroll": (),
    "PySide2.QtWidgets.QPlainTextEdit.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.clear": (),
    "PySide2.QtWidgets.QPlainTextEdit.contentOffset": (),
    "PySide2.QtWidgets.QPlainTextEdit.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.copy": (),
    "PySide2.QtWidgets.QPlainTextEdit.createMimeDataFromSelection": (),
    "PySide2.QtWidgets.QPlainTextEdit.createStandardContextMenu": [(), ('PySide2.QtCore.QPoint',)],
    "PySide2.QtWidgets.QPlainTextEdit.currentCharFormat": (),
    "PySide2.QtWidgets.QPlainTextEdit.cursorForPosition": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QPlainTextEdit.cursorRect": [(), ('PySide2.QtGui.QTextCursor',)],
    "PySide2.QtWidgets.QPlainTextEdit.cursorWidth": (),
    "PySide2.QtWidgets.QPlainTextEdit.cut": (),
    "PySide2.QtWidgets.QPlainTextEdit.doSetTextCursor": ('PySide2.QtGui.QTextCursor',),
    "PySide2.QtWidgets.QPlainTextEdit.document": (),
    "PySide2.QtWidgets.QPlainTextEdit.documentTitle": (),
    "PySide2.QtWidgets.QPlainTextEdit.dragEnterEvent": ('PySide2.QtGui.QDragEnterEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.dragLeaveEvent": ('PySide2.QtGui.QDragLeaveEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.dropEvent": ('PySide2.QtGui.QDropEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.ensureCursorVisible": (),
    "PySide2.QtWidgets.QPlainTextEdit.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.extraSelections": (),
    "PySide2.QtWidgets.QPlainTextEdit.find": [('PySide2.QtCore.QRegExp', 'PySide2.QtGui.QTextDocument.FindFlags'), ('PySide2.QtCore.QRegularExpression', 'PySide2.QtGui.QTextDocument.FindFlags'), ('str', 'PySide2.QtGui.QTextDocument.FindFlags')],
    "PySide2.QtWidgets.QPlainTextEdit.firstVisibleBlock": (),
    "PySide2.QtWidgets.QPlainTextEdit.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.focusNextPrevChild": ('bool',),
    "PySide2.QtWidgets.QPlainTextEdit.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.getPaintContext": (),
    "PySide2.QtWidgets.QPlainTextEdit.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.inputMethodQuery": [('PySide2.QtCore.Qt.InputMethodQuery',), ('PySide2.QtCore.Qt.InputMethodQuery', 'typing.Any')],
    "PySide2.QtWidgets.QPlainTextEdit.insertFromMimeData": ('PySide2.QtCore.QMimeData',),
    "PySide2.QtWidgets.QPlainTextEdit.insertPlainText": ('str',),
    "PySide2.QtWidgets.QPlainTextEdit.isReadOnly": (),
    "PySide2.QtWidgets.QPlainTextEdit.isUndoRedoEnabled": (),
    "PySide2.QtWidgets.QPlainTextEdit.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.lineWrapMode": (),
    "PySide2.QtWidgets.QPlainTextEdit.loadResource": ('int', 'PySide2.QtCore.QUrl'),
    "PySide2.QtWidgets.QPlainTextEdit.maximumBlockCount": (),
    "PySide2.QtWidgets.QPlainTextEdit.mergeCurrentCharFormat": ('PySide2.QtGui.QTextCharFormat',),
    "PySide2.QtWidgets.QPlainTextEdit.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.moveCursor": ('PySide2.QtGui.QTextCursor.MoveOperation', 'PySide2.QtGui.QTextCursor.MoveMode'),
    "PySide2.QtWidgets.QPlainTextEdit.overwriteMode": (),
    "PySide2.QtWidgets.QPlainTextEdit.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.paste": (),
    "PySide2.QtWidgets.QPlainTextEdit.placeholderText": (),
    "PySide2.QtWidgets.QPlainTextEdit.print_": ('PySide2.QtGui.QPagedPaintDevice',),
    "PySide2.QtWidgets.QPlainTextEdit.redo": (),
    "PySide2.QtWidgets.QPlainTextEdit.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.scrollContentsBy": ('int', 'int'),
    "PySide2.QtWidgets.QPlainTextEdit.selectAll": (),
    "PySide2.QtWidgets.QPlainTextEdit.setBackgroundVisible": ('bool',),
    "PySide2.QtWidgets.QPlainTextEdit.setCenterOnScroll": ('bool',),
    "PySide2.QtWidgets.QPlainTextEdit.setCurrentCharFormat": ('PySide2.QtGui.QTextCharFormat',),
    "PySide2.QtWidgets.QPlainTextEdit.setCursorWidth": ('int',),
    "PySide2.QtWidgets.QPlainTextEdit.setDocument": ('PySide2.QtGui.QTextDocument',),
    "PySide2.QtWidgets.QPlainTextEdit.setDocumentTitle": ('str',),
    "PySide2.QtWidgets.QPlainTextEdit.setExtraSelections": ('typing.Sequence',),
    "PySide2.QtWidgets.QPlainTextEdit.setLineWrapMode": ('PySide2.QtWidgets.QPlainTextEdit.LineWrapMode',),
    "PySide2.QtWidgets.QPlainTextEdit.setMaximumBlockCount": ('int',),
    "PySide2.QtWidgets.QPlainTextEdit.setOverwriteMode": ('bool',),
    "PySide2.QtWidgets.QPlainTextEdit.setPlaceholderText": ('str',),
    "PySide2.QtWidgets.QPlainTextEdit.setPlainText": ('str',),
    "PySide2.QtWidgets.QPlainTextEdit.setReadOnly": ('bool',),
    "PySide2.QtWidgets.QPlainTextEdit.setTabChangesFocus": ('bool',),
    "PySide2.QtWidgets.QPlainTextEdit.setTabStopDistance": ('float',),
    "PySide2.QtWidgets.QPlainTextEdit.setTabStopWidth": ('int',),
    "PySide2.QtWidgets.QPlainTextEdit.setTextCursor": ('PySide2.QtGui.QTextCursor',),
    "PySide2.QtWidgets.QPlainTextEdit.setTextInteractionFlags": ('PySide2.QtCore.Qt.TextInteractionFlags',),
    "PySide2.QtWidgets.QPlainTextEdit.setUndoRedoEnabled": ('bool',),
    "PySide2.QtWidgets.QPlainTextEdit.setWordWrapMode": ('PySide2.QtGui.QTextOption.WrapMode',),
    "PySide2.QtWidgets.QPlainTextEdit.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.tabChangesFocus": (),
    "PySide2.QtWidgets.QPlainTextEdit.tabStopDistance": (),
    "PySide2.QtWidgets.QPlainTextEdit.tabStopWidth": (),
    "PySide2.QtWidgets.QPlainTextEdit.textCursor": (),
    "PySide2.QtWidgets.QPlainTextEdit.textInteractionFlags": (),
    "PySide2.QtWidgets.QPlainTextEdit.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.toPlainText": (),
    "PySide2.QtWidgets.QPlainTextEdit.undo": (),
    "PySide2.QtWidgets.QPlainTextEdit.wheelEvent": ('PySide2.QtGui.QWheelEvent',),
    "PySide2.QtWidgets.QPlainTextEdit.wordWrapMode": (),
    "PySide2.QtWidgets.QPlainTextEdit.zoomIn": ('int',),
    "PySide2.QtWidgets.QPlainTextEdit.zoomInF": ('float',),
    "PySide2.QtWidgets.QPlainTextEdit.zoomOut": ('int',),

# class PySide2.QtWidgets.QProgressBar:

# class PySide2.QtWidgets.QProgressBar.Direction:
    "PySide2.QtWidgets.QProgressBar.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QProgressBar.alignment": (),
    "PySide2.QtWidgets.QProgressBar.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QProgressBar.format": (),
    "PySide2.QtWidgets.QProgressBar.initStyleOption": ('PySide2.QtWidgets.QStyleOptionProgressBar',),
    "PySide2.QtWidgets.QProgressBar.invertedAppearance": (),
    "PySide2.QtWidgets.QProgressBar.isTextVisible": (),
    "PySide2.QtWidgets.QProgressBar.maximum": (),
    "PySide2.QtWidgets.QProgressBar.minimum": (),
    "PySide2.QtWidgets.QProgressBar.minimumSizeHint": (),
    "PySide2.QtWidgets.QProgressBar.orientation": (),
    "PySide2.QtWidgets.QProgressBar.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QProgressBar.reset": (),
    "PySide2.QtWidgets.QProgressBar.resetFormat": (),
    "PySide2.QtWidgets.QProgressBar.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtWidgets.QProgressBar.setFormat": ('str',),
    "PySide2.QtWidgets.QProgressBar.setInvertedAppearance": ('bool',),
    "PySide2.QtWidgets.QProgressBar.setMaximum": ('int',),
    "PySide2.QtWidgets.QProgressBar.setMinimum": ('int',),
    "PySide2.QtWidgets.QProgressBar.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
    "PySide2.QtWidgets.QProgressBar.setRange": ('int', 'int'),
    "PySide2.QtWidgets.QProgressBar.setTextDirection": ('PySide2.QtWidgets.QProgressBar.Direction',),
    "PySide2.QtWidgets.QProgressBar.setTextVisible": ('bool',),
    "PySide2.QtWidgets.QProgressBar.setValue": ('int',),
    "PySide2.QtWidgets.QProgressBar.sizeHint": (),
    "PySide2.QtWidgets.QProgressBar.text": (),
    "PySide2.QtWidgets.QProgressBar.textDirection": (),
    "PySide2.QtWidgets.QProgressBar.value": (),

# class PySide2.QtWidgets.QProgressDialog:
    "PySide2.QtWidgets.QProgressDialog.__init__": [('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'), ('str', 'str', 'int', 'int', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags')],
    "PySide2.QtWidgets.QProgressDialog.autoClose": (),
    "PySide2.QtWidgets.QProgressDialog.autoReset": (),
    "PySide2.QtWidgets.QProgressDialog.cancel": (),
    "PySide2.QtWidgets.QProgressDialog.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QProgressDialog.closeEvent": ('PySide2.QtGui.QCloseEvent',),
    "PySide2.QtWidgets.QProgressDialog.forceShow": (),
    "PySide2.QtWidgets.QProgressDialog.labelText": (),
    "PySide2.QtWidgets.QProgressDialog.maximum": (),
    "PySide2.QtWidgets.QProgressDialog.minimum": (),
    "PySide2.QtWidgets.QProgressDialog.minimumDuration": (),
    "PySide2.QtWidgets.QProgressDialog.open": [(), ('PySide2.QtCore.QObject', 'bytes')],
    "PySide2.QtWidgets.QProgressDialog.reset": (),
    "PySide2.QtWidgets.QProgressDialog.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QProgressDialog.setAutoClose": ('bool',),
    "PySide2.QtWidgets.QProgressDialog.setAutoReset": ('bool',),
    "PySide2.QtWidgets.QProgressDialog.setBar": ('PySide2.QtWidgets.QProgressBar',),
    "PySide2.QtWidgets.QProgressDialog.setCancelButton": ('PySide2.QtWidgets.QPushButton',),
    "PySide2.QtWidgets.QProgressDialog.setCancelButtonText": ('str',),
    "PySide2.QtWidgets.QProgressDialog.setLabel": ('PySide2.QtWidgets.QLabel',),
    "PySide2.QtWidgets.QProgressDialog.setLabelText": ('str',),
    "PySide2.QtWidgets.QProgressDialog.setMaximum": ('int',),
    "PySide2.QtWidgets.QProgressDialog.setMinimum": ('int',),
    "PySide2.QtWidgets.QProgressDialog.setMinimumDuration": ('int',),
    "PySide2.QtWidgets.QProgressDialog.setRange": ('int', 'int'),
    "PySide2.QtWidgets.QProgressDialog.setValue": ('int',),
    "PySide2.QtWidgets.QProgressDialog.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QProgressDialog.sizeHint": (),
    "PySide2.QtWidgets.QProgressDialog.value": (),
    "PySide2.QtWidgets.QProgressDialog.wasCanceled": (),

# class PySide2.QtWidgets.QProxyStyle:
    "PySide2.QtWidgets.QProxyStyle.__init__": [('PySide2.QtWidgets.QStyle',), ('str',)],
    "PySide2.QtWidgets.QProxyStyle.baseStyle": (),
    "PySide2.QtWidgets.QProxyStyle.drawComplexControl": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QProxyStyle.drawControl": ('PySide2.QtWidgets.QStyle.ControlElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QProxyStyle.drawItemPixmap": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'int', 'PySide2.QtGui.QPixmap'),
    "PySide2.QtWidgets.QProxyStyle.drawItemText": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'int', 'PySide2.QtGui.QPalette', 'bool', 'str', 'PySide2.QtGui.QPalette.ColorRole'),
    "PySide2.QtWidgets.QProxyStyle.drawPrimitive": ('PySide2.QtWidgets.QStyle.PrimitiveElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QProxyStyle.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QProxyStyle.generatedIconPixmap": ('PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QPixmap', 'PySide2.QtWidgets.QStyleOption'),
    "PySide2.QtWidgets.QProxyStyle.hitTestComplexControl": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtCore.QPoint', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QProxyStyle.itemPixmapRect": ('PySide2.QtCore.QRect', 'int', 'PySide2.QtGui.QPixmap'),
    "PySide2.QtWidgets.QProxyStyle.itemTextRect": ('PySide2.QtGui.QFontMetrics', 'PySide2.QtCore.QRect', 'int', 'bool', 'str'),
    "PySide2.QtWidgets.QProxyStyle.layoutSpacing": ('PySide2.QtWidgets.QSizePolicy.ControlType', 'PySide2.QtWidgets.QSizePolicy.ControlType', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QProxyStyle.pixelMetric": ('PySide2.QtWidgets.QStyle.PixelMetric', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QProxyStyle.polish": [('PySide2.QtGui.QPalette',), ('PySide2.QtWidgets.QApplication',), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QProxyStyle.setBaseStyle": ('PySide2.QtWidgets.QStyle',),
    "PySide2.QtWidgets.QProxyStyle.sizeFromContents": ('PySide2.QtWidgets.QStyle.ContentsType', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtCore.QSize', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QProxyStyle.standardIcon": ('PySide2.QtWidgets.QStyle.StandardPixmap', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QProxyStyle.standardPalette": (),
    "PySide2.QtWidgets.QProxyStyle.standardPixmap": ('PySide2.QtWidgets.QStyle.StandardPixmap', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QProxyStyle.styleHint": ('PySide2.QtWidgets.QStyle.StyleHint', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleHintReturn'),
    "PySide2.QtWidgets.QProxyStyle.subControlRect": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtWidgets.QStyle.SubControl', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QProxyStyle.subElementRect": ('PySide2.QtWidgets.QStyle.SubElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QProxyStyle.unpolish": [('PySide2.QtWidgets.QApplication',), ('PySide2.QtWidgets.QWidget',)],

# class PySide2.QtWidgets.QPushButton:
    "PySide2.QtWidgets.QPushButton.__init__": [('PySide2.QtGui.QIcon', 'str', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
    "PySide2.QtWidgets.QPushButton.autoDefault": (),
    "PySide2.QtWidgets.QPushButton.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QPushButton.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QPushButton.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QPushButton.initStyleOption": ('PySide2.QtWidgets.QStyleOptionButton',),
    "PySide2.QtWidgets.QPushButton.isDefault": (),
    "PySide2.QtWidgets.QPushButton.isFlat": (),
    "PySide2.QtWidgets.QPushButton.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QPushButton.menu": (),
    "PySide2.QtWidgets.QPushButton.minimumSizeHint": (),
    "PySide2.QtWidgets.QPushButton.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QPushButton.setAutoDefault": ('bool',),
    "PySide2.QtWidgets.QPushButton.setDefault": ('bool',),
    "PySide2.QtWidgets.QPushButton.setFlat": ('bool',),
    "PySide2.QtWidgets.QPushButton.setMenu": ('PySide2.QtWidgets.QMenu',),
    "PySide2.QtWidgets.QPushButton.showMenu": (),
    "PySide2.QtWidgets.QPushButton.sizeHint": (),

# class PySide2.QtWidgets.QRadioButton:
    "PySide2.QtWidgets.QRadioButton.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
    "PySide2.QtWidgets.QRadioButton.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QRadioButton.hitButton": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QRadioButton.initStyleOption": ('PySide2.QtWidgets.QStyleOptionButton',),
    "PySide2.QtWidgets.QRadioButton.minimumSizeHint": (),
    "PySide2.QtWidgets.QRadioButton.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QRadioButton.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QRadioButton.sizeHint": (),

# class PySide2.QtWidgets.QRubberBand:

# class PySide2.QtWidgets.QRubberBand.Shape:
    "PySide2.QtWidgets.QRubberBand.__init__": ('PySide2.QtWidgets.QRubberBand.Shape', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QRubberBand.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QRubberBand.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QRubberBand.initStyleOption": ('PySide2.QtWidgets.QStyleOptionRubberBand',),
    "PySide2.QtWidgets.QRubberBand.move": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtWidgets.QRubberBand.moveEvent": ('PySide2.QtGui.QMoveEvent',),
    "PySide2.QtWidgets.QRubberBand.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QRubberBand.resize": [('PySide2.QtCore.QSize',), ('int', 'int')],
    "PySide2.QtWidgets.QRubberBand.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QRubberBand.setGeometry": [('PySide2.QtCore.QRect',), ('int', 'int', 'int', 'int')],
    "PySide2.QtWidgets.QRubberBand.shape": (),
    "PySide2.QtWidgets.QRubberBand.showEvent": ('PySide2.QtGui.QShowEvent',),

# class PySide2.QtWidgets.QScrollArea:
    "PySide2.QtWidgets.QScrollArea.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QScrollArea.alignment": (),
    "PySide2.QtWidgets.QScrollArea.ensureVisible": ('int', 'int', 'int', 'int'),
    "PySide2.QtWidgets.QScrollArea.ensureWidgetVisible": ('PySide2.QtWidgets.QWidget', 'int', 'int'),
    "PySide2.QtWidgets.QScrollArea.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QScrollArea.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QScrollArea.focusNextPrevChild": ('bool',),
    "PySide2.QtWidgets.QScrollArea.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QScrollArea.scrollContentsBy": ('int', 'int'),
    "PySide2.QtWidgets.QScrollArea.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtWidgets.QScrollArea.setWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QScrollArea.setWidgetResizable": ('bool',),
    "PySide2.QtWidgets.QScrollArea.sizeHint": (),
    "PySide2.QtWidgets.QScrollArea.takeWidget": (),
    "PySide2.QtWidgets.QScrollArea.viewportSizeHint": (),
    "PySide2.QtWidgets.QScrollArea.widget": (),
    "PySide2.QtWidgets.QScrollArea.widgetResizable": (),

# class PySide2.QtWidgets.QScrollBar:
    "PySide2.QtWidgets.QScrollBar.__init__": [('PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QScrollBar.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
    "PySide2.QtWidgets.QScrollBar.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QScrollBar.hideEvent": ('PySide2.QtGui.QHideEvent',),
    "PySide2.QtWidgets.QScrollBar.initStyleOption": ('PySide2.QtWidgets.QStyleOptionSlider',),
    "PySide2.QtWidgets.QScrollBar.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QScrollBar.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QScrollBar.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QScrollBar.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QScrollBar.sizeHint": (),
    "PySide2.QtWidgets.QScrollBar.sliderChange": ('PySide2.QtWidgets.QAbstractSlider.SliderChange',),
    "PySide2.QtWidgets.QScrollBar.wheelEvent": ('PySide2.QtGui.QWheelEvent',),

# class PySide2.QtWidgets.QScroller:

# class PySide2.QtWidgets.QScroller.Input:

# class PySide2.QtWidgets.QScroller.ScrollerGestureType:

# class PySide2.QtWidgets.QScroller.State:
    "PySide2.QtWidgets.QScroller.activeScrollers": (),
    "PySide2.QtWidgets.QScroller.ensureVisible": [('PySide2.QtCore.QRectF', 'float', 'float'), ('PySide2.QtCore.QRectF', 'float', 'float', 'int')],
    "PySide2.QtWidgets.QScroller.finalPosition": (),
    "PySide2.QtWidgets.QScroller.grabGesture": ('PySide2.QtCore.QObject', 'PySide2.QtWidgets.QScroller.ScrollerGestureType'),
    "PySide2.QtWidgets.QScroller.grabbedGesture": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QScroller.handleInput": ('PySide2.QtWidgets.QScroller.Input', 'PySide2.QtCore.QPointF', 'int'),
    "PySide2.QtWidgets.QScroller.hasScroller": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QScroller.pixelPerMeter": (),
    "PySide2.QtWidgets.QScroller.resendPrepareEvent": (),
    "PySide2.QtWidgets.QScroller.scrollTo": [('PySide2.QtCore.QPointF',), ('PySide2.QtCore.QPointF', 'int')],
    "PySide2.QtWidgets.QScroller.scroller": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QScroller.scrollerProperties": (),
    "PySide2.QtWidgets.QScroller.setScrollerProperties": ('PySide2.QtWidgets.QScrollerProperties',),
    "PySide2.QtWidgets.QScroller.setSnapPositionsX": [('float', 'float'), ('typing.Sequence',)],
    "PySide2.QtWidgets.QScroller.setSnapPositionsY": [('float', 'float'), ('typing.Sequence',)],
    "PySide2.QtWidgets.QScroller.state": (),
    "PySide2.QtWidgets.QScroller.stop": (),
    "PySide2.QtWidgets.QScroller.target": (),
    "PySide2.QtWidgets.QScroller.ungrabGesture": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QScroller.velocity": (),

# class PySide2.QtWidgets.QScrollerProperties:

# class PySide2.QtWidgets.QScrollerProperties.FrameRates:

# class PySide2.QtWidgets.QScrollerProperties.OvershootPolicy:

# class PySide2.QtWidgets.QScrollerProperties.ScrollMetric:
    "PySide2.QtWidgets.QScrollerProperties.__init__": [(), ('PySide2.QtWidgets.QScrollerProperties',)],
    "PySide2.QtWidgets.QScrollerProperties.__copy__": (),
    "PySide2.QtWidgets.QScrollerProperties.scrollMetric": ('PySide2.QtWidgets.QScrollerProperties.ScrollMetric',),
    "PySide2.QtWidgets.QScrollerProperties.setDefaultScrollerProperties": ('PySide2.QtWidgets.QScrollerProperties',),
    "PySide2.QtWidgets.QScrollerProperties.setScrollMetric": ('PySide2.QtWidgets.QScrollerProperties.ScrollMetric', 'typing.Any'),
    "PySide2.QtWidgets.QScrollerProperties.unsetDefaultScrollerProperties": (),

# class PySide2.QtWidgets.QShortcut:
    "PySide2.QtWidgets.QShortcut.__init__": [('PySide2.QtGui.QKeySequence', 'PySide2.QtWidgets.QWidget', 'bytes', 'bytes', 'PySide2.QtCore.Qt.ShortcutContext'), ('PySide2.QtGui.QKeySequence', 'PySide2.QtWidgets.QWidget', 'typing.Callable', 'PySide2.QtCore.Qt.ShortcutContext'), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QShortcut.autoRepeat": (),
    "PySide2.QtWidgets.QShortcut.context": (),
    "PySide2.QtWidgets.QShortcut.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QShortcut.id": (),
    "PySide2.QtWidgets.QShortcut.isEnabled": (),
    "PySide2.QtWidgets.QShortcut.key": (),
    "PySide2.QtWidgets.QShortcut.parentWidget": (),
    "PySide2.QtWidgets.QShortcut.setAutoRepeat": ('bool',),
    "PySide2.QtWidgets.QShortcut.setContext": ('PySide2.QtCore.Qt.ShortcutContext',),
    "PySide2.QtWidgets.QShortcut.setEnabled": ('bool',),
    "PySide2.QtWidgets.QShortcut.setKey": ('PySide2.QtGui.QKeySequence',),
    "PySide2.QtWidgets.QShortcut.setWhatsThis": ('str',),
    "PySide2.QtWidgets.QShortcut.whatsThis": (),

# class PySide2.QtWidgets.QSizeGrip:
    "PySide2.QtWidgets.QSizeGrip.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QSizeGrip.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QSizeGrip.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QSizeGrip.hideEvent": ('PySide2.QtGui.QHideEvent',),
    "PySide2.QtWidgets.QSizeGrip.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QSizeGrip.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QSizeGrip.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QSizeGrip.moveEvent": ('PySide2.QtGui.QMoveEvent',),
    "PySide2.QtWidgets.QSizeGrip.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QSizeGrip.setVisible": ('bool',),
    "PySide2.QtWidgets.QSizeGrip.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QSizeGrip.sizeHint": (),

# class PySide2.QtWidgets.QSizePolicy:

# class PySide2.QtWidgets.QSizePolicy.ControlType:

# class PySide2.QtWidgets.QSizePolicy.ControlTypes:

# class PySide2.QtWidgets.QSizePolicy.Policy:

# class PySide2.QtWidgets.QSizePolicy.PolicyFlag:
    "PySide2.QtWidgets.QSizePolicy.__init__": [(), ('PySide2.QtWidgets.QSizePolicy.Policy', 'PySide2.QtWidgets.QSizePolicy.Policy', 'PySide2.QtWidgets.QSizePolicy.ControlType')],
    "PySide2.QtWidgets.QSizePolicy.__copy__": (),
    "PySide2.QtWidgets.QSizePolicy.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtWidgets.QSizePolicy.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtWidgets.QSizePolicy.controlType": (),
    "PySide2.QtWidgets.QSizePolicy.expandingDirections": (),
    "PySide2.QtWidgets.QSizePolicy.hasHeightForWidth": (),
    "PySide2.QtWidgets.QSizePolicy.hasWidthForHeight": (),
    "PySide2.QtWidgets.QSizePolicy.horizontalPolicy": (),
    "PySide2.QtWidgets.QSizePolicy.horizontalStretch": (),
    "PySide2.QtWidgets.QSizePolicy.retainSizeWhenHidden": (),
    "PySide2.QtWidgets.QSizePolicy.setControlType": ('PySide2.QtWidgets.QSizePolicy.ControlType',),
    "PySide2.QtWidgets.QSizePolicy.setHeightForWidth": ('bool',),
    "PySide2.QtWidgets.QSizePolicy.setHorizontalPolicy": ('PySide2.QtWidgets.QSizePolicy.Policy',),
    "PySide2.QtWidgets.QSizePolicy.setHorizontalStretch": ('int',),
    "PySide2.QtWidgets.QSizePolicy.setRetainSizeWhenHidden": ('bool',),
    "PySide2.QtWidgets.QSizePolicy.setVerticalPolicy": ('PySide2.QtWidgets.QSizePolicy.Policy',),
    "PySide2.QtWidgets.QSizePolicy.setVerticalStretch": ('int',),
    "PySide2.QtWidgets.QSizePolicy.setWidthForHeight": ('bool',),
    "PySide2.QtWidgets.QSizePolicy.transpose": (),
    "PySide2.QtWidgets.QSizePolicy.transposed": (),
    "PySide2.QtWidgets.QSizePolicy.verticalPolicy": (),
    "PySide2.QtWidgets.QSizePolicy.verticalStretch": (),

# class PySide2.QtWidgets.QSlider:

# class PySide2.QtWidgets.QSlider.TickPosition:
    "PySide2.QtWidgets.QSlider.__init__": [('PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QSlider.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QSlider.initStyleOption": ('PySide2.QtWidgets.QStyleOptionSlider',),
    "PySide2.QtWidgets.QSlider.minimumSizeHint": (),
    "PySide2.QtWidgets.QSlider.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QSlider.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QSlider.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QSlider.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QSlider.setTickInterval": ('int',),
    "PySide2.QtWidgets.QSlider.setTickPosition": ('PySide2.QtWidgets.QSlider.TickPosition',),
    "PySide2.QtWidgets.QSlider.sizeHint": (),
    "PySide2.QtWidgets.QSlider.tickInterval": (),
    "PySide2.QtWidgets.QSlider.tickPosition": (),

# class PySide2.QtWidgets.QSpacerItem:
    "PySide2.QtWidgets.QSpacerItem.__init__": ('int', 'int', 'PySide2.QtWidgets.QSizePolicy.Policy', 'PySide2.QtWidgets.QSizePolicy.Policy'),
    "PySide2.QtWidgets.QSpacerItem.changeSize": ('int', 'int', 'PySide2.QtWidgets.QSizePolicy.Policy', 'PySide2.QtWidgets.QSizePolicy.Policy'),
    "PySide2.QtWidgets.QSpacerItem.expandingDirections": (),
    "PySide2.QtWidgets.QSpacerItem.geometry": (),
    "PySide2.QtWidgets.QSpacerItem.isEmpty": (),
    "PySide2.QtWidgets.QSpacerItem.maximumSize": (),
    "PySide2.QtWidgets.QSpacerItem.minimumSize": (),
    "PySide2.QtWidgets.QSpacerItem.setGeometry": ('PySide2.QtCore.QRect',),
    "PySide2.QtWidgets.QSpacerItem.sizeHint": (),
    "PySide2.QtWidgets.QSpacerItem.sizePolicy": (),
    "PySide2.QtWidgets.QSpacerItem.spacerItem": (),

# class PySide2.QtWidgets.QSpinBox:
    "PySide2.QtWidgets.QSpinBox.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QSpinBox.cleanText": (),
    "PySide2.QtWidgets.QSpinBox.displayIntegerBase": (),
    "PySide2.QtWidgets.QSpinBox.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QSpinBox.fixup": ('str',),
    "PySide2.QtWidgets.QSpinBox.maximum": (),
    "PySide2.QtWidgets.QSpinBox.minimum": (),
    "PySide2.QtWidgets.QSpinBox.prefix": (),
    "PySide2.QtWidgets.QSpinBox.setDisplayIntegerBase": ('int',),
    "PySide2.QtWidgets.QSpinBox.setMaximum": ('int',),
    "PySide2.QtWidgets.QSpinBox.setMinimum": ('int',),
    "PySide2.QtWidgets.QSpinBox.setPrefix": ('str',),
    "PySide2.QtWidgets.QSpinBox.setRange": ('int', 'int'),
    "PySide2.QtWidgets.QSpinBox.setSingleStep": ('int',),
    "PySide2.QtWidgets.QSpinBox.setStepType": ('PySide2.QtWidgets.QAbstractSpinBox.StepType',),
    "PySide2.QtWidgets.QSpinBox.setSuffix": ('str',),
    "PySide2.QtWidgets.QSpinBox.setValue": ('int',),
    "PySide2.QtWidgets.QSpinBox.singleStep": (),
    "PySide2.QtWidgets.QSpinBox.stepType": (),
    "PySide2.QtWidgets.QSpinBox.suffix": (),
    "PySide2.QtWidgets.QSpinBox.textFromValue": ('int',),
    "PySide2.QtWidgets.QSpinBox.validate": ('str', 'int'),
    "PySide2.QtWidgets.QSpinBox.value": (),
    "PySide2.QtWidgets.QSpinBox.valueFromText": ('str',),

# class PySide2.QtWidgets.QSplashScreen:
    "PySide2.QtWidgets.QSplashScreen.__init__": [('PySide2.QtGui.QPixmap', 'PySide2.QtCore.Qt.WindowFlags'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtGui.QPixmap', 'PySide2.QtCore.Qt.WindowFlags')],
    "PySide2.QtWidgets.QSplashScreen.clearMessage": (),
    "PySide2.QtWidgets.QSplashScreen.drawContents": ('PySide2.QtGui.QPainter',),
    "PySide2.QtWidgets.QSplashScreen.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QSplashScreen.finish": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QSplashScreen.message": (),
    "PySide2.QtWidgets.QSplashScreen.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QSplashScreen.pixmap": (),
    "PySide2.QtWidgets.QSplashScreen.setPixmap": ('PySide2.QtGui.QPixmap',),
    "PySide2.QtWidgets.QSplashScreen.showMessage": ('str', 'int', 'PySide2.QtGui.QColor'),

# class PySide2.QtWidgets.QSplitter:
    "PySide2.QtWidgets.QSplitter.__init__": [('PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QSplitter.__lshift__": ('PySide2.QtCore.QTextStream',),
    "PySide2.QtWidgets.QSplitter.__rshift__": ('PySide2.QtCore.QTextStream',),
    "PySide2.QtWidgets.QSplitter.addWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QSplitter.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QSplitter.childEvent": ('PySide2.QtCore.QChildEvent',),
    "PySide2.QtWidgets.QSplitter.childrenCollapsible": (),
    "PySide2.QtWidgets.QSplitter.closestLegalPosition": ('int', 'int'),
    "PySide2.QtWidgets.QSplitter.count": (),
    "PySide2.QtWidgets.QSplitter.createHandle": (),
    "PySide2.QtWidgets.QSplitter.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QSplitter.getRange": ('int',),
    "PySide2.QtWidgets.QSplitter.handle": ('int',),
    "PySide2.QtWidgets.QSplitter.handleWidth": (),
    "PySide2.QtWidgets.QSplitter.indexOf": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QSplitter.insertWidget": ('int', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QSplitter.isCollapsible": ('int',),
    "PySide2.QtWidgets.QSplitter.minimumSizeHint": (),
    "PySide2.QtWidgets.QSplitter.moveSplitter": ('int', 'int'),
    "PySide2.QtWidgets.QSplitter.opaqueResize": (),
    "PySide2.QtWidgets.QSplitter.orientation": (),
    "PySide2.QtWidgets.QSplitter.refresh": (),
    "PySide2.QtWidgets.QSplitter.replaceWidget": ('int', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QSplitter.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QSplitter.restoreState": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtWidgets.QSplitter.saveState": (),
    "PySide2.QtWidgets.QSplitter.setChildrenCollapsible": ('bool',),
    "PySide2.QtWidgets.QSplitter.setCollapsible": ('int', 'bool'),
    "PySide2.QtWidgets.QSplitter.setHandleWidth": ('int',),
    "PySide2.QtWidgets.QSplitter.setOpaqueResize": ('bool',),
    "PySide2.QtWidgets.QSplitter.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
    "PySide2.QtWidgets.QSplitter.setRubberBand": ('int',),
    "PySide2.QtWidgets.QSplitter.setSizes": ('typing.Sequence',),
    "PySide2.QtWidgets.QSplitter.setStretchFactor": ('int', 'int'),
    "PySide2.QtWidgets.QSplitter.sizeHint": (),
    "PySide2.QtWidgets.QSplitter.sizes": (),
    "PySide2.QtWidgets.QSplitter.widget": ('int',),

# class PySide2.QtWidgets.QSplitterHandle:
    "PySide2.QtWidgets.QSplitterHandle.__init__": ('PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QSplitter'),
    "PySide2.QtWidgets.QSplitterHandle.closestLegalPosition": ('int',),
    "PySide2.QtWidgets.QSplitterHandle.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QSplitterHandle.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QSplitterHandle.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QSplitterHandle.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QSplitterHandle.moveSplitter": ('int',),
    "PySide2.QtWidgets.QSplitterHandle.opaqueResize": (),
    "PySide2.QtWidgets.QSplitterHandle.orientation": (),
    "PySide2.QtWidgets.QSplitterHandle.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QSplitterHandle.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QSplitterHandle.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
    "PySide2.QtWidgets.QSplitterHandle.sizeHint": (),
    "PySide2.QtWidgets.QSplitterHandle.splitter": (),

# class PySide2.QtWidgets.QStackedLayout:

# class PySide2.QtWidgets.QStackedLayout.StackingMode:
    "PySide2.QtWidgets.QStackedLayout.__init__": [(), ('PySide2.QtWidgets.QLayout',), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QStackedLayout.addItem": ('PySide2.QtWidgets.QLayoutItem',),
    "PySide2.QtWidgets.QStackedLayout.addWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QStackedLayout.count": (),
    "PySide2.QtWidgets.QStackedLayout.currentIndex": (),
    "PySide2.QtWidgets.QStackedLayout.currentWidget": (),
    "PySide2.QtWidgets.QStackedLayout.hasHeightForWidth": (),
    "PySide2.QtWidgets.QStackedLayout.heightForWidth": ('int',),
    "PySide2.QtWidgets.QStackedLayout.insertWidget": ('int', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QStackedLayout.itemAt": ('int',),
    "PySide2.QtWidgets.QStackedLayout.minimumSize": (),
    "PySide2.QtWidgets.QStackedLayout.setCurrentIndex": ('int',),
    "PySide2.QtWidgets.QStackedLayout.setCurrentWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QStackedLayout.setGeometry": ('PySide2.QtCore.QRect',),
    "PySide2.QtWidgets.QStackedLayout.setStackingMode": ('PySide2.QtWidgets.QStackedLayout.StackingMode',),
    "PySide2.QtWidgets.QStackedLayout.sizeHint": (),
    "PySide2.QtWidgets.QStackedLayout.stackingMode": (),
    "PySide2.QtWidgets.QStackedLayout.takeAt": ('int',),
    "PySide2.QtWidgets.QStackedLayout.widget": [(), ('int',)],

# class PySide2.QtWidgets.QStackedWidget:
    "PySide2.QtWidgets.QStackedWidget.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QStackedWidget.addWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QStackedWidget.count": (),
    "PySide2.QtWidgets.QStackedWidget.currentIndex": (),
    "PySide2.QtWidgets.QStackedWidget.currentWidget": (),
    "PySide2.QtWidgets.QStackedWidget.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QStackedWidget.indexOf": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QStackedWidget.insertWidget": ('int', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QStackedWidget.removeWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QStackedWidget.setCurrentIndex": ('int',),
    "PySide2.QtWidgets.QStackedWidget.setCurrentWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QStackedWidget.widget": ('int',),

# class PySide2.QtWidgets.QStatusBar:
    "PySide2.QtWidgets.QStatusBar.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QStatusBar.addPermanentWidget": ('PySide2.QtWidgets.QWidget', 'int'),
    "PySide2.QtWidgets.QStatusBar.addWidget": ('PySide2.QtWidgets.QWidget', 'int'),
    "PySide2.QtWidgets.QStatusBar.clearMessage": (),
    "PySide2.QtWidgets.QStatusBar.currentMessage": (),
    "PySide2.QtWidgets.QStatusBar.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QStatusBar.hideOrShow": (),
    "PySide2.QtWidgets.QStatusBar.insertPermanentWidget": ('int', 'PySide2.QtWidgets.QWidget', 'int'),
    "PySide2.QtWidgets.QStatusBar.insertWidget": ('int', 'PySide2.QtWidgets.QWidget', 'int'),
    "PySide2.QtWidgets.QStatusBar.isSizeGripEnabled": (),
    "PySide2.QtWidgets.QStatusBar.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QStatusBar.reformat": (),
    "PySide2.QtWidgets.QStatusBar.removeWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QStatusBar.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QStatusBar.setSizeGripEnabled": ('bool',),
    "PySide2.QtWidgets.QStatusBar.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QStatusBar.showMessage": ('str', 'int'),

# class PySide2.QtWidgets.QStyle:

# class PySide2.QtWidgets.QStyle.ComplexControl:

# class PySide2.QtWidgets.QStyle.ContentsType:

# class PySide2.QtWidgets.QStyle.ControlElement:

# class PySide2.QtWidgets.QStyle.PixelMetric:

# class PySide2.QtWidgets.QStyle.PrimitiveElement:

# class PySide2.QtWidgets.QStyle.RequestSoftwareInputPanel:

# class PySide2.QtWidgets.QStyle.StandardPixmap:

# class PySide2.QtWidgets.QStyle.State:

# class PySide2.QtWidgets.QStyle.StateFlag:

# class PySide2.QtWidgets.QStyle.StyleHint:

# class PySide2.QtWidgets.QStyle.SubControl:

# class PySide2.QtWidgets.QStyle.SubControls:

# class PySide2.QtWidgets.QStyle.SubElement:
    "PySide2.QtWidgets.QStyle.__init__": (),
    "PySide2.QtWidgets.QStyle.alignedRect": ('PySide2.QtCore.Qt.LayoutDirection', 'PySide2.QtCore.Qt.Alignment', 'PySide2.QtCore.QSize', 'PySide2.QtCore.QRect'),
    "PySide2.QtWidgets.QStyle.combinedLayoutSpacing": ('PySide2.QtWidgets.QSizePolicy.ControlTypes', 'PySide2.QtWidgets.QSizePolicy.ControlTypes', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QStyle.drawComplexControl": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QStyle.drawControl": ('PySide2.QtWidgets.QStyle.ControlElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QStyle.drawItemPixmap": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'int', 'PySide2.QtGui.QPixmap'),
    "PySide2.QtWidgets.QStyle.drawItemText": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'int', 'PySide2.QtGui.QPalette', 'bool', 'str', 'PySide2.QtGui.QPalette.ColorRole'),
    "PySide2.QtWidgets.QStyle.drawPrimitive": ('PySide2.QtWidgets.QStyle.PrimitiveElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QStyle.generatedIconPixmap": ('PySide2.QtGui.QIcon.Mode', 'PySide2.QtGui.QPixmap', 'PySide2.QtWidgets.QStyleOption'),
    "PySide2.QtWidgets.QStyle.hitTestComplexControl": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtCore.QPoint', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QStyle.itemPixmapRect": ('PySide2.QtCore.QRect', 'int', 'PySide2.QtGui.QPixmap'),
    "PySide2.QtWidgets.QStyle.itemTextRect": ('PySide2.QtGui.QFontMetrics', 'PySide2.QtCore.QRect', 'int', 'bool', 'str'),
    "PySide2.QtWidgets.QStyle.layoutSpacing": ('PySide2.QtWidgets.QSizePolicy.ControlType', 'PySide2.QtWidgets.QSizePolicy.ControlType', 'PySide2.QtCore.Qt.Orientation', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QStyle.pixelMetric": ('PySide2.QtWidgets.QStyle.PixelMetric', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QStyle.polish": [('PySide2.QtGui.QPalette',), ('PySide2.QtWidgets.QApplication',), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QStyle.proxy": (),
    "PySide2.QtWidgets.QStyle.sizeFromContents": ('PySide2.QtWidgets.QStyle.ContentsType', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtCore.QSize', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QStyle.sliderPositionFromValue": ('int', 'int', 'int', 'int', 'bool'),
    "PySide2.QtWidgets.QStyle.sliderValueFromPosition": ('int', 'int', 'int', 'int', 'bool'),
    "PySide2.QtWidgets.QStyle.standardIcon": ('PySide2.QtWidgets.QStyle.StandardPixmap', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QStyle.standardPalette": (),
    "PySide2.QtWidgets.QStyle.standardPixmap": ('PySide2.QtWidgets.QStyle.StandardPixmap', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QStyle.styleHint": ('PySide2.QtWidgets.QStyle.StyleHint', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleHintReturn'),
    "PySide2.QtWidgets.QStyle.subControlRect": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex', 'PySide2.QtWidgets.QStyle.SubControl', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QStyle.subElementRect": ('PySide2.QtWidgets.QStyle.SubElement', 'PySide2.QtWidgets.QStyleOption', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QStyle.unpolish": [('PySide2.QtWidgets.QApplication',), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QStyle.visualAlignment": ('PySide2.QtCore.Qt.LayoutDirection', 'PySide2.QtCore.Qt.Alignment'),
    "PySide2.QtWidgets.QStyle.visualPos": ('PySide2.QtCore.Qt.LayoutDirection', 'PySide2.QtCore.QRect', 'PySide2.QtCore.QPoint'),
    "PySide2.QtWidgets.QStyle.visualRect": ('PySide2.QtCore.Qt.LayoutDirection', 'PySide2.QtCore.QRect', 'PySide2.QtCore.QRect'),

# class PySide2.QtWidgets.QStyleFactory:
    "PySide2.QtWidgets.QStyleFactory.__init__": (),
    "PySide2.QtWidgets.QStyleFactory.create": ('str',),
    "PySide2.QtWidgets.QStyleFactory.keys": (),

# class PySide2.QtWidgets.QStyleHintReturn:

# class PySide2.QtWidgets.QStyleHintReturn.HintReturnType:

# class PySide2.QtWidgets.QStyleHintReturn.StyleOptionType:

# class PySide2.QtWidgets.QStyleHintReturn.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleHintReturn.__init__": ('int', 'int'),

# class PySide2.QtWidgets.QStyleHintReturnMask:

# class PySide2.QtWidgets.QStyleHintReturnMask.StyleOptionType:

# class PySide2.QtWidgets.QStyleHintReturnMask.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleHintReturnMask.__init__": (),

# class PySide2.QtWidgets.QStyleHintReturnVariant:

# class PySide2.QtWidgets.QStyleHintReturnVariant.StyleOptionType:

# class PySide2.QtWidgets.QStyleHintReturnVariant.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleHintReturnVariant.__init__": (),

# class PySide2.QtWidgets.QStyleOption:

# class PySide2.QtWidgets.QStyleOption.OptionType:

# class PySide2.QtWidgets.QStyleOption.StyleOptionType:

# class PySide2.QtWidgets.QStyleOption.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOption.__init__": [('PySide2.QtWidgets.QStyleOption',), ('int', 'int')],
    "PySide2.QtWidgets.QStyleOption.init": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QStyleOption.initFrom": ('PySide2.QtWidgets.QWidget',),

# class PySide2.QtWidgets.QStyleOptionButton:

# class PySide2.QtWidgets.QStyleOptionButton.ButtonFeature:

# class PySide2.QtWidgets.QStyleOptionButton.ButtonFeatures:

# class PySide2.QtWidgets.QStyleOptionButton.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionButton.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionButton.__init__": [(), ('PySide2.QtWidgets.QStyleOptionButton',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionComboBox:

# class PySide2.QtWidgets.QStyleOptionComboBox.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionComboBox.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionComboBox.__init__": [(), ('PySide2.QtWidgets.QStyleOptionComboBox',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionComplex:

# class PySide2.QtWidgets.QStyleOptionComplex.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionComplex.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionComplex.__init__": [('PySide2.QtWidgets.QStyleOptionComplex',), ('int', 'int')],

# class PySide2.QtWidgets.QStyleOptionDockWidget:

# class PySide2.QtWidgets.QStyleOptionDockWidget.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionDockWidget.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionDockWidget.__init__": [(), ('PySide2.QtWidgets.QStyleOptionDockWidget',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionFocusRect:

# class PySide2.QtWidgets.QStyleOptionFocusRect.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionFocusRect.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionFocusRect.__init__": [(), ('PySide2.QtWidgets.QStyleOptionFocusRect',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionFrame:

# class PySide2.QtWidgets.QStyleOptionFrame.FrameFeature:

# class PySide2.QtWidgets.QStyleOptionFrame.FrameFeatures:

# class PySide2.QtWidgets.QStyleOptionFrame.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionFrame.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionFrame.__init__": [(), ('PySide2.QtWidgets.QStyleOptionFrame',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionGraphicsItem:

# class PySide2.QtWidgets.QStyleOptionGraphicsItem.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionGraphicsItem.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionGraphicsItem.__init__": [(), ('PySide2.QtWidgets.QStyleOptionGraphicsItem',), ('int',)],
    "PySide2.QtWidgets.QStyleOptionGraphicsItem.levelOfDetailFromTransform": ('PySide2.QtGui.QTransform',),

# class PySide2.QtWidgets.QStyleOptionGroupBox:

# class PySide2.QtWidgets.QStyleOptionGroupBox.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionGroupBox.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionGroupBox.__init__": [(), ('PySide2.QtWidgets.QStyleOptionGroupBox',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionHeader:

# class PySide2.QtWidgets.QStyleOptionHeader.SectionPosition:

# class PySide2.QtWidgets.QStyleOptionHeader.SelectedPosition:

# class PySide2.QtWidgets.QStyleOptionHeader.SortIndicator:

# class PySide2.QtWidgets.QStyleOptionHeader.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionHeader.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionHeader.__init__": [(), ('PySide2.QtWidgets.QStyleOptionHeader',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionMenuItem:

# class PySide2.QtWidgets.QStyleOptionMenuItem.CheckType:

# class PySide2.QtWidgets.QStyleOptionMenuItem.MenuItemType:

# class PySide2.QtWidgets.QStyleOptionMenuItem.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionMenuItem.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionMenuItem.__init__": [(), ('PySide2.QtWidgets.QStyleOptionMenuItem',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionProgressBar:

# class PySide2.QtWidgets.QStyleOptionProgressBar.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionProgressBar.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionProgressBar.__init__": [(), ('PySide2.QtWidgets.QStyleOptionProgressBar',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionRubberBand:

# class PySide2.QtWidgets.QStyleOptionRubberBand.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionRubberBand.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionRubberBand.__init__": [(), ('PySide2.QtWidgets.QStyleOptionRubberBand',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionSizeGrip:

# class PySide2.QtWidgets.QStyleOptionSizeGrip.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionSizeGrip.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionSizeGrip.__init__": [(), ('PySide2.QtWidgets.QStyleOptionSizeGrip',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionSlider:

# class PySide2.QtWidgets.QStyleOptionSlider.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionSlider.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionSlider.__init__": [(), ('PySide2.QtWidgets.QStyleOptionSlider',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionSpinBox:

# class PySide2.QtWidgets.QStyleOptionSpinBox.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionSpinBox.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionSpinBox.__init__": [(), ('PySide2.QtWidgets.QStyleOptionSpinBox',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionTab:

# class PySide2.QtWidgets.QStyleOptionTab.CornerWidget:

# class PySide2.QtWidgets.QStyleOptionTab.CornerWidgets:

# class PySide2.QtWidgets.QStyleOptionTab.SelectedPosition:

# class PySide2.QtWidgets.QStyleOptionTab.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionTab.StyleOptionVersion:

# class PySide2.QtWidgets.QStyleOptionTab.TabFeature:

# class PySide2.QtWidgets.QStyleOptionTab.TabFeatures:

# class PySide2.QtWidgets.QStyleOptionTab.TabPosition:
    "PySide2.QtWidgets.QStyleOptionTab.__init__": [(), ('PySide2.QtWidgets.QStyleOptionTab',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionTabBarBase:

# class PySide2.QtWidgets.QStyleOptionTabBarBase.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionTabBarBase.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionTabBarBase.__init__": [(), ('PySide2.QtWidgets.QStyleOptionTabBarBase',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionTabWidgetFrame:

# class PySide2.QtWidgets.QStyleOptionTabWidgetFrame.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionTabWidgetFrame.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionTabWidgetFrame.__init__": [(), ('PySide2.QtWidgets.QStyleOptionTabWidgetFrame',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionTitleBar:

# class PySide2.QtWidgets.QStyleOptionTitleBar.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionTitleBar.StyleOptionVersion:
    "PySide2.QtWidgets.QStyleOptionTitleBar.__init__": [(), ('PySide2.QtWidgets.QStyleOptionTitleBar',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionToolBar:

# class PySide2.QtWidgets.QStyleOptionToolBar.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionToolBar.StyleOptionVersion:

# class PySide2.QtWidgets.QStyleOptionToolBar.ToolBarFeature:

# class PySide2.QtWidgets.QStyleOptionToolBar.ToolBarFeatures:

# class PySide2.QtWidgets.QStyleOptionToolBar.ToolBarPosition:
    "PySide2.QtWidgets.QStyleOptionToolBar.__init__": [(), ('PySide2.QtWidgets.QStyleOptionToolBar',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionToolBox:

# class PySide2.QtWidgets.QStyleOptionToolBox.SelectedPosition:

# class PySide2.QtWidgets.QStyleOptionToolBox.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionToolBox.StyleOptionVersion:

# class PySide2.QtWidgets.QStyleOptionToolBox.TabPosition:
    "PySide2.QtWidgets.QStyleOptionToolBox.__init__": [(), ('PySide2.QtWidgets.QStyleOptionToolBox',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionToolButton:

# class PySide2.QtWidgets.QStyleOptionToolButton.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionToolButton.StyleOptionVersion:

# class PySide2.QtWidgets.QStyleOptionToolButton.ToolButtonFeature:

# class PySide2.QtWidgets.QStyleOptionToolButton.ToolButtonFeatures:
    "PySide2.QtWidgets.QStyleOptionToolButton.__init__": [(), ('PySide2.QtWidgets.QStyleOptionToolButton',), ('int',)],

# class PySide2.QtWidgets.QStyleOptionViewItem:

# class PySide2.QtWidgets.QStyleOptionViewItem.Position:

# class PySide2.QtWidgets.QStyleOptionViewItem.StyleOptionType:

# class PySide2.QtWidgets.QStyleOptionViewItem.StyleOptionVersion:

# class PySide2.QtWidgets.QStyleOptionViewItem.ViewItemFeature:

# class PySide2.QtWidgets.QStyleOptionViewItem.ViewItemFeatures:

# class PySide2.QtWidgets.QStyleOptionViewItem.ViewItemPosition:
    "PySide2.QtWidgets.QStyleOptionViewItem.__init__": [(), ('PySide2.QtWidgets.QStyleOptionViewItem',), ('int',)],
    "PySide2.QtWidgets.QStyleOptionViewItem.__copy__": (),

# class PySide2.QtWidgets.QStylePainter:
    "PySide2.QtWidgets.QStylePainter.__init__": [(), ('PySide2.QtGui.QPaintDevice', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QStylePainter.begin": [('PySide2.QtGui.QPaintDevice',), ('PySide2.QtGui.QPaintDevice', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QStylePainter.drawComplexControl": ('PySide2.QtWidgets.QStyle.ComplexControl', 'PySide2.QtWidgets.QStyleOptionComplex'),
    "PySide2.QtWidgets.QStylePainter.drawControl": ('PySide2.QtWidgets.QStyle.ControlElement', 'PySide2.QtWidgets.QStyleOption'),
    "PySide2.QtWidgets.QStylePainter.drawItemPixmap": ('PySide2.QtCore.QRect', 'int', 'PySide2.QtGui.QPixmap'),
    "PySide2.QtWidgets.QStylePainter.drawItemText": ('PySide2.QtCore.QRect', 'int', 'PySide2.QtGui.QPalette', 'bool', 'str', 'PySide2.QtGui.QPalette.ColorRole'),
    "PySide2.QtWidgets.QStylePainter.drawPrimitive": ('PySide2.QtWidgets.QStyle.PrimitiveElement', 'PySide2.QtWidgets.QStyleOption'),
    "PySide2.QtWidgets.QStylePainter.style": (),

# class PySide2.QtWidgets.QStyledItemDelegate:
    "PySide2.QtWidgets.QStyledItemDelegate.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QStyledItemDelegate.createEditor": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QStyledItemDelegate.displayText": ('typing.Any', 'PySide2.QtCore.QLocale'),
    "PySide2.QtWidgets.QStyledItemDelegate.editorEvent": ('PySide2.QtCore.QEvent', 'PySide2.QtCore.QAbstractItemModel', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QStyledItemDelegate.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QStyledItemDelegate.initStyleOption": ('PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QStyledItemDelegate.itemEditorFactory": (),
    "PySide2.QtWidgets.QStyledItemDelegate.paint": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QStyledItemDelegate.setEditorData": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QStyledItemDelegate.setItemEditorFactory": ('PySide2.QtWidgets.QItemEditorFactory',),
    "PySide2.QtWidgets.QStyledItemDelegate.setModelData": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QAbstractItemModel', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QStyledItemDelegate.sizeHint": ('PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QStyledItemDelegate.updateEditorGeometry": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),

# class PySide2.QtWidgets.QSwipeGesture:

# class PySide2.QtWidgets.QSwipeGesture.SwipeDirection:
    "PySide2.QtWidgets.QSwipeGesture.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QSwipeGesture.horizontalDirection": (),
    "PySide2.QtWidgets.QSwipeGesture.setSwipeAngle": ('float',),
    "PySide2.QtWidgets.QSwipeGesture.swipeAngle": (),
    "PySide2.QtWidgets.QSwipeGesture.verticalDirection": (),

# class PySide2.QtWidgets.QSystemTrayIcon:

# class PySide2.QtWidgets.QSystemTrayIcon.ActivationReason:

# class PySide2.QtWidgets.QSystemTrayIcon.MessageIcon:
    "PySide2.QtWidgets.QSystemTrayIcon.__init__": [('PySide2.QtCore.QObject',), ('PySide2.QtGui.QIcon', 'PySide2.QtCore.QObject')],
    "PySide2.QtWidgets.QSystemTrayIcon.contextMenu": (),
    "PySide2.QtWidgets.QSystemTrayIcon.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QSystemTrayIcon.geometry": (),
    "PySide2.QtWidgets.QSystemTrayIcon.hide": (),
    "PySide2.QtWidgets.QSystemTrayIcon.icon": (),
    "PySide2.QtWidgets.QSystemTrayIcon.isSystemTrayAvailable": (),
    "PySide2.QtWidgets.QSystemTrayIcon.isVisible": (),
    "PySide2.QtWidgets.QSystemTrayIcon.setContextMenu": ('PySide2.QtWidgets.QMenu',),
    "PySide2.QtWidgets.QSystemTrayIcon.setIcon": ('PySide2.QtGui.QIcon',),
    "PySide2.QtWidgets.QSystemTrayIcon.setToolTip": ('str',),
    "PySide2.QtWidgets.QSystemTrayIcon.setVisible": ('bool',),
    "PySide2.QtWidgets.QSystemTrayIcon.show": (),
    "PySide2.QtWidgets.QSystemTrayIcon.showMessage": [('str', 'str', 'PySide2.QtGui.QIcon', 'int'), ('str', 'str', 'PySide2.QtWidgets.QSystemTrayIcon.MessageIcon', 'int')],
    "PySide2.QtWidgets.QSystemTrayIcon.supportsMessages": (),
    "PySide2.QtWidgets.QSystemTrayIcon.toolTip": (),

# class PySide2.QtWidgets.QTabBar:

# class PySide2.QtWidgets.QTabBar.ButtonPosition:

# class PySide2.QtWidgets.QTabBar.SelectionBehavior:

# class PySide2.QtWidgets.QTabBar.Shape:
    "PySide2.QtWidgets.QTabBar.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QTabBar.accessibleTabName": ('int',),
    "PySide2.QtWidgets.QTabBar.addTab": [('PySide2.QtGui.QIcon', 'str'), ('str',)],
    "PySide2.QtWidgets.QTabBar.autoHide": (),
    "PySide2.QtWidgets.QTabBar.changeCurrentOnDrag": (),
    "PySide2.QtWidgets.QTabBar.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QTabBar.count": (),
    "PySide2.QtWidgets.QTabBar.currentIndex": (),
    "PySide2.QtWidgets.QTabBar.documentMode": (),
    "PySide2.QtWidgets.QTabBar.drawBase": (),
    "PySide2.QtWidgets.QTabBar.elideMode": (),
    "PySide2.QtWidgets.QTabBar.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QTabBar.expanding": (),
    "PySide2.QtWidgets.QTabBar.hideEvent": ('PySide2.QtGui.QHideEvent',),
    "PySide2.QtWidgets.QTabBar.iconSize": (),
    "PySide2.QtWidgets.QTabBar.initStyleOption": ('PySide2.QtWidgets.QStyleOptionTab', 'int'),
    "PySide2.QtWidgets.QTabBar.insertTab": [('int', 'PySide2.QtGui.QIcon', 'str'), ('int', 'str')],
    "PySide2.QtWidgets.QTabBar.isMovable": (),
    "PySide2.QtWidgets.QTabBar.isTabEnabled": ('int',),
    "PySide2.QtWidgets.QTabBar.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QTabBar.minimumSizeHint": (),
    "PySide2.QtWidgets.QTabBar.minimumTabSizeHint": ('int',),
    "PySide2.QtWidgets.QTabBar.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QTabBar.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QTabBar.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QTabBar.moveTab": ('int', 'int'),
    "PySide2.QtWidgets.QTabBar.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QTabBar.removeTab": ('int',),
    "PySide2.QtWidgets.QTabBar.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QTabBar.selectionBehaviorOnRemove": (),
    "PySide2.QtWidgets.QTabBar.setAccessibleTabName": ('int', 'str'),
    "PySide2.QtWidgets.QTabBar.setAutoHide": ('bool',),
    "PySide2.QtWidgets.QTabBar.setChangeCurrentOnDrag": ('bool',),
    "PySide2.QtWidgets.QTabBar.setCurrentIndex": ('int',),
    "PySide2.QtWidgets.QTabBar.setDocumentMode": ('bool',),
    "PySide2.QtWidgets.QTabBar.setDrawBase": ('bool',),
    "PySide2.QtWidgets.QTabBar.setElideMode": ('PySide2.QtCore.Qt.TextElideMode',),
    "PySide2.QtWidgets.QTabBar.setExpanding": ('bool',),
    "PySide2.QtWidgets.QTabBar.setIconSize": ('PySide2.QtCore.QSize',),
    "PySide2.QtWidgets.QTabBar.setMovable": ('bool',),
    "PySide2.QtWidgets.QTabBar.setSelectionBehaviorOnRemove": ('PySide2.QtWidgets.QTabBar.SelectionBehavior',),
    "PySide2.QtWidgets.QTabBar.setShape": ('PySide2.QtWidgets.QTabBar.Shape',),
    "PySide2.QtWidgets.QTabBar.setTabButton": ('int', 'PySide2.QtWidgets.QTabBar.ButtonPosition', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QTabBar.setTabData": ('int', 'typing.Any'),
    "PySide2.QtWidgets.QTabBar.setTabEnabled": ('int', 'bool'),
    "PySide2.QtWidgets.QTabBar.setTabIcon": ('int', 'PySide2.QtGui.QIcon'),
    "PySide2.QtWidgets.QTabBar.setTabText": ('int', 'str'),
    "PySide2.QtWidgets.QTabBar.setTabTextColor": ('int', 'PySide2.QtGui.QColor'),
    "PySide2.QtWidgets.QTabBar.setTabToolTip": ('int', 'str'),
    "PySide2.QtWidgets.QTabBar.setTabWhatsThis": ('int', 'str'),
    "PySide2.QtWidgets.QTabBar.setTabsClosable": ('bool',),
    "PySide2.QtWidgets.QTabBar.setUsesScrollButtons": ('bool',),
    "PySide2.QtWidgets.QTabBar.shape": (),
    "PySide2.QtWidgets.QTabBar.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QTabBar.sizeHint": (),
    "PySide2.QtWidgets.QTabBar.tabAt": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QTabBar.tabButton": ('int', 'PySide2.QtWidgets.QTabBar.ButtonPosition'),
    "PySide2.QtWidgets.QTabBar.tabData": ('int',),
    "PySide2.QtWidgets.QTabBar.tabIcon": ('int',),
    "PySide2.QtWidgets.QTabBar.tabInserted": ('int',),
    "PySide2.QtWidgets.QTabBar.tabLayoutChange": (),
    "PySide2.QtWidgets.QTabBar.tabRect": ('int',),
    "PySide2.QtWidgets.QTabBar.tabRemoved": ('int',),
    "PySide2.QtWidgets.QTabBar.tabSizeHint": ('int',),
    "PySide2.QtWidgets.QTabBar.tabText": ('int',),
    "PySide2.QtWidgets.QTabBar.tabTextColor": ('int',),
    "PySide2.QtWidgets.QTabBar.tabToolTip": ('int',),
    "PySide2.QtWidgets.QTabBar.tabWhatsThis": ('int',),
    "PySide2.QtWidgets.QTabBar.tabsClosable": (),
    "PySide2.QtWidgets.QTabBar.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtWidgets.QTabBar.usesScrollButtons": (),
    "PySide2.QtWidgets.QTabBar.wheelEvent": ('PySide2.QtGui.QWheelEvent',),

# class PySide2.QtWidgets.QTabWidget:

# class PySide2.QtWidgets.QTabWidget.TabPosition:

# class PySide2.QtWidgets.QTabWidget.TabShape:
    "PySide2.QtWidgets.QTabWidget.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QTabWidget.addTab": [('PySide2.QtWidgets.QWidget', 'PySide2.QtGui.QIcon', 'str'), ('PySide2.QtWidgets.QWidget', 'str')],
    "PySide2.QtWidgets.QTabWidget.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QTabWidget.clear": (),
    "PySide2.QtWidgets.QTabWidget.cornerWidget": ('PySide2.QtCore.Qt.Corner',),
    "PySide2.QtWidgets.QTabWidget.count": (),
    "PySide2.QtWidgets.QTabWidget.currentIndex": (),
    "PySide2.QtWidgets.QTabWidget.currentWidget": (),
    "PySide2.QtWidgets.QTabWidget.documentMode": (),
    "PySide2.QtWidgets.QTabWidget.elideMode": (),
    "PySide2.QtWidgets.QTabWidget.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QTabWidget.hasHeightForWidth": (),
    "PySide2.QtWidgets.QTabWidget.heightForWidth": ('int',),
    "PySide2.QtWidgets.QTabWidget.iconSize": (),
    "PySide2.QtWidgets.QTabWidget.indexOf": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QTabWidget.initStyleOption": ('PySide2.QtWidgets.QStyleOptionTabWidgetFrame',),
    "PySide2.QtWidgets.QTabWidget.insertTab": [('int', 'PySide2.QtWidgets.QWidget', 'PySide2.QtGui.QIcon', 'str'), ('int', 'PySide2.QtWidgets.QWidget', 'str')],
    "PySide2.QtWidgets.QTabWidget.isMovable": (),
    "PySide2.QtWidgets.QTabWidget.isTabEnabled": ('int',),
    "PySide2.QtWidgets.QTabWidget.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QTabWidget.minimumSizeHint": (),
    "PySide2.QtWidgets.QTabWidget.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QTabWidget.removeTab": ('int',),
    "PySide2.QtWidgets.QTabWidget.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QTabWidget.setCornerWidget": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.Corner'),
    "PySide2.QtWidgets.QTabWidget.setCurrentIndex": ('int',),
    "PySide2.QtWidgets.QTabWidget.setCurrentWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QTabWidget.setDocumentMode": ('bool',),
    "PySide2.QtWidgets.QTabWidget.setElideMode": ('PySide2.QtCore.Qt.TextElideMode',),
    "PySide2.QtWidgets.QTabWidget.setIconSize": ('PySide2.QtCore.QSize',),
    "PySide2.QtWidgets.QTabWidget.setMovable": ('bool',),
    "PySide2.QtWidgets.QTabWidget.setTabBar": ('PySide2.QtWidgets.QTabBar',),
    "PySide2.QtWidgets.QTabWidget.setTabBarAutoHide": ('bool',),
    "PySide2.QtWidgets.QTabWidget.setTabEnabled": ('int', 'bool'),
    "PySide2.QtWidgets.QTabWidget.setTabIcon": ('int', 'PySide2.QtGui.QIcon'),
    "PySide2.QtWidgets.QTabWidget.setTabPosition": ('PySide2.QtWidgets.QTabWidget.TabPosition',),
    "PySide2.QtWidgets.QTabWidget.setTabShape": ('PySide2.QtWidgets.QTabWidget.TabShape',),
    "PySide2.QtWidgets.QTabWidget.setTabText": ('int', 'str'),
    "PySide2.QtWidgets.QTabWidget.setTabToolTip": ('int', 'str'),
    "PySide2.QtWidgets.QTabWidget.setTabWhatsThis": ('int', 'str'),
    "PySide2.QtWidgets.QTabWidget.setTabsClosable": ('bool',),
    "PySide2.QtWidgets.QTabWidget.setUsesScrollButtons": ('bool',),
    "PySide2.QtWidgets.QTabWidget.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QTabWidget.sizeHint": (),
    "PySide2.QtWidgets.QTabWidget.tabBar": (),
    "PySide2.QtWidgets.QTabWidget.tabBarAutoHide": (),
    "PySide2.QtWidgets.QTabWidget.tabIcon": ('int',),
    "PySide2.QtWidgets.QTabWidget.tabInserted": ('int',),
    "PySide2.QtWidgets.QTabWidget.tabPosition": (),
    "PySide2.QtWidgets.QTabWidget.tabRemoved": ('int',),
    "PySide2.QtWidgets.QTabWidget.tabShape": (),
    "PySide2.QtWidgets.QTabWidget.tabText": ('int',),
    "PySide2.QtWidgets.QTabWidget.tabToolTip": ('int',),
    "PySide2.QtWidgets.QTabWidget.tabWhatsThis": ('int',),
    "PySide2.QtWidgets.QTabWidget.tabsClosable": (),
    "PySide2.QtWidgets.QTabWidget.usesScrollButtons": (),
    "PySide2.QtWidgets.QTabWidget.widget": ('int',),

# class PySide2.QtWidgets.QTableView:
    "PySide2.QtWidgets.QTableView.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QTableView.clearSpans": (),
    "PySide2.QtWidgets.QTableView.columnAt": ('int',),
    "PySide2.QtWidgets.QTableView.columnCountChanged": ('int', 'int'),
    "PySide2.QtWidgets.QTableView.columnMoved": ('int', 'int', 'int'),
    "PySide2.QtWidgets.QTableView.columnResized": ('int', 'int', 'int'),
    "PySide2.QtWidgets.QTableView.columnSpan": ('int', 'int'),
    "PySide2.QtWidgets.QTableView.columnViewportPosition": ('int',),
    "PySide2.QtWidgets.QTableView.columnWidth": ('int',),
    "PySide2.QtWidgets.QTableView.currentChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QTableView.doItemsLayout": (),
    "PySide2.QtWidgets.QTableView.gridStyle": (),
    "PySide2.QtWidgets.QTableView.hideColumn": ('int',),
    "PySide2.QtWidgets.QTableView.hideRow": ('int',),
    "PySide2.QtWidgets.QTableView.horizontalHeader": (),
    "PySide2.QtWidgets.QTableView.horizontalOffset": (),
    "PySide2.QtWidgets.QTableView.horizontalScrollbarAction": ('int',),
    "PySide2.QtWidgets.QTableView.indexAt": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QTableView.isColumnHidden": ('int',),
    "PySide2.QtWidgets.QTableView.isCornerButtonEnabled": (),
    "PySide2.QtWidgets.QTableView.isIndexHidden": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QTableView.isRowHidden": ('int',),
    "PySide2.QtWidgets.QTableView.isSortingEnabled": (),
    "PySide2.QtWidgets.QTableView.moveCursor": ('PySide2.QtWidgets.QAbstractItemView.CursorAction', 'PySide2.QtCore.Qt.KeyboardModifiers'),
    "PySide2.QtWidgets.QTableView.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QTableView.resizeColumnToContents": ('int',),
    "PySide2.QtWidgets.QTableView.resizeColumnsToContents": (),
    "PySide2.QtWidgets.QTableView.resizeRowToContents": ('int',),
    "PySide2.QtWidgets.QTableView.resizeRowsToContents": (),
    "PySide2.QtWidgets.QTableView.rowAt": ('int',),
    "PySide2.QtWidgets.QTableView.rowCountChanged": ('int', 'int'),
    "PySide2.QtWidgets.QTableView.rowHeight": ('int',),
    "PySide2.QtWidgets.QTableView.rowMoved": ('int', 'int', 'int'),
    "PySide2.QtWidgets.QTableView.rowResized": ('int', 'int', 'int'),
    "PySide2.QtWidgets.QTableView.rowSpan": ('int', 'int'),
    "PySide2.QtWidgets.QTableView.rowViewportPosition": ('int',),
    "PySide2.QtWidgets.QTableView.scrollContentsBy": ('int', 'int'),
    "PySide2.QtWidgets.QTableView.scrollTo": ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
    "PySide2.QtWidgets.QTableView.selectColumn": ('int',),
    "PySide2.QtWidgets.QTableView.selectRow": ('int',),
    "PySide2.QtWidgets.QTableView.selectedIndexes": (),
    "PySide2.QtWidgets.QTableView.selectionChanged": ('PySide2.QtCore.QItemSelection', 'PySide2.QtCore.QItemSelection'),
    "PySide2.QtWidgets.QTableView.setColumnHidden": ('int', 'bool'),
    "PySide2.QtWidgets.QTableView.setColumnWidth": ('int', 'int'),
    "PySide2.QtWidgets.QTableView.setCornerButtonEnabled": ('bool',),
    "PySide2.QtWidgets.QTableView.setGridStyle": ('PySide2.QtCore.Qt.PenStyle',),
    "PySide2.QtWidgets.QTableView.setHorizontalHeader": ('PySide2.QtWidgets.QHeaderView',),
    "PySide2.QtWidgets.QTableView.setModel": ('PySide2.QtCore.QAbstractItemModel',),
    "PySide2.QtWidgets.QTableView.setRootIndex": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QTableView.setRowHeight": ('int', 'int'),
    "PySide2.QtWidgets.QTableView.setRowHidden": ('int', 'bool'),
    "PySide2.QtWidgets.QTableView.setSelection": ('PySide2.QtCore.QRect', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'),
    "PySide2.QtWidgets.QTableView.setSelectionModel": ('PySide2.QtCore.QItemSelectionModel',),
    "PySide2.QtWidgets.QTableView.setShowGrid": ('bool',),
    "PySide2.QtWidgets.QTableView.setSortingEnabled": ('bool',),
    "PySide2.QtWidgets.QTableView.setSpan": ('int', 'int', 'int', 'int'),
    "PySide2.QtWidgets.QTableView.setVerticalHeader": ('PySide2.QtWidgets.QHeaderView',),
    "PySide2.QtWidgets.QTableView.setWordWrap": ('bool',),
    "PySide2.QtWidgets.QTableView.showColumn": ('int',),
    "PySide2.QtWidgets.QTableView.showGrid": (),
    "PySide2.QtWidgets.QTableView.showRow": ('int',),
    "PySide2.QtWidgets.QTableView.sizeHintForColumn": ('int',),
    "PySide2.QtWidgets.QTableView.sizeHintForRow": ('int',),
    "PySide2.QtWidgets.QTableView.sortByColumn": [('int',), ('int', 'PySide2.QtCore.Qt.SortOrder')],
    "PySide2.QtWidgets.QTableView.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtWidgets.QTableView.updateGeometries": (),
    "PySide2.QtWidgets.QTableView.verticalHeader": (),
    "PySide2.QtWidgets.QTableView.verticalOffset": (),
    "PySide2.QtWidgets.QTableView.verticalScrollbarAction": ('int',),
    "PySide2.QtWidgets.QTableView.viewOptions": (),
    "PySide2.QtWidgets.QTableView.viewportSizeHint": (),
    "PySide2.QtWidgets.QTableView.visualRect": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QTableView.visualRegionForSelection": ('PySide2.QtCore.QItemSelection',),
    "PySide2.QtWidgets.QTableView.wordWrap": (),

# class PySide2.QtWidgets.QTableWidget:
    "PySide2.QtWidgets.QTableWidget.__init__": [('PySide2.QtWidgets.QWidget',), ('int', 'int', 'PySide2.QtWidgets.QWidget')],
    "PySide2.QtWidgets.QTableWidget.cellWidget": ('int', 'int'),
    "PySide2.QtWidgets.QTableWidget.clear": (),
    "PySide2.QtWidgets.QTableWidget.clearContents": (),
    "PySide2.QtWidgets.QTableWidget.closePersistentEditor": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QTableWidgetItem',)],
    "PySide2.QtWidgets.QTableWidget.column": ('PySide2.QtWidgets.QTableWidgetItem',),
    "PySide2.QtWidgets.QTableWidget.columnCount": (),
    "PySide2.QtWidgets.QTableWidget.currentColumn": (),
    "PySide2.QtWidgets.QTableWidget.currentItem": (),
    "PySide2.QtWidgets.QTableWidget.currentRow": (),
    "PySide2.QtWidgets.QTableWidget.dropEvent": ('PySide2.QtGui.QDropEvent',),
    "PySide2.QtWidgets.QTableWidget.dropMimeData": ('int', 'int', 'PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction'),
    "PySide2.QtWidgets.QTableWidget.editItem": ('PySide2.QtWidgets.QTableWidgetItem',),
    "PySide2.QtWidgets.QTableWidget.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QTableWidget.findItems": ('str', 'PySide2.QtCore.Qt.MatchFlags'),
    "PySide2.QtWidgets.QTableWidget.horizontalHeaderItem": ('int',),
    "PySide2.QtWidgets.QTableWidget.indexFromItem": ('PySide2.QtWidgets.QTableWidgetItem',),
    "PySide2.QtWidgets.QTableWidget.insertColumn": ('int',),
    "PySide2.QtWidgets.QTableWidget.insertRow": ('int',),
    "PySide2.QtWidgets.QTableWidget.isItemSelected": ('PySide2.QtWidgets.QTableWidgetItem',),
    "PySide2.QtWidgets.QTableWidget.isPersistentEditorOpen": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QTableWidgetItem',)],
    "PySide2.QtWidgets.QTableWidget.isSortingEnabled": (),
    "PySide2.QtWidgets.QTableWidget.item": ('int', 'int'),
    "PySide2.QtWidgets.QTableWidget.itemAt": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtWidgets.QTableWidget.itemFromIndex": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QTableWidget.itemPrototype": (),
    "PySide2.QtWidgets.QTableWidget.items": ('PySide2.QtCore.QMimeData',),
    "PySide2.QtWidgets.QTableWidget.mimeData": ('typing.Sequence',),
    "PySide2.QtWidgets.QTableWidget.mimeTypes": (),
    "PySide2.QtWidgets.QTableWidget.openPersistentEditor": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QTableWidgetItem',)],
    "PySide2.QtWidgets.QTableWidget.removeCellWidget": ('int', 'int'),
    "PySide2.QtWidgets.QTableWidget.removeColumn": ('int',),
    "PySide2.QtWidgets.QTableWidget.removeRow": ('int',),
    "PySide2.QtWidgets.QTableWidget.row": ('PySide2.QtWidgets.QTableWidgetItem',),
    "PySide2.QtWidgets.QTableWidget.rowCount": (),
    "PySide2.QtWidgets.QTableWidget.scrollToItem": ('PySide2.QtWidgets.QTableWidgetItem', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
    "PySide2.QtWidgets.QTableWidget.selectedItems": (),
    "PySide2.QtWidgets.QTableWidget.selectedRanges": (),
    "PySide2.QtWidgets.QTableWidget.setCellWidget": ('int', 'int', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QTableWidget.setColumnCount": ('int',),
    "PySide2.QtWidgets.QTableWidget.setCurrentCell": [('int', 'int'), ('int', 'int', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags')],
    "PySide2.QtWidgets.QTableWidget.setCurrentItem": [('PySide2.QtWidgets.QTableWidgetItem',), ('PySide2.QtWidgets.QTableWidgetItem', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags')],
    "PySide2.QtWidgets.QTableWidget.setHorizontalHeaderItem": ('int', 'PySide2.QtWidgets.QTableWidgetItem'),
    "PySide2.QtWidgets.QTableWidget.setHorizontalHeaderLabels": ('typing.Sequence',),
    "PySide2.QtWidgets.QTableWidget.setItem": ('int', 'int', 'PySide2.QtWidgets.QTableWidgetItem'),
    "PySide2.QtWidgets.QTableWidget.setItemPrototype": ('PySide2.QtWidgets.QTableWidgetItem',),
    "PySide2.QtWidgets.QTableWidget.setItemSelected": ('PySide2.QtWidgets.QTableWidgetItem', 'bool'),
    "PySide2.QtWidgets.QTableWidget.setModel": ('PySide2.QtCore.QAbstractItemModel',),
    "PySide2.QtWidgets.QTableWidget.setRangeSelected": ('PySide2.QtWidgets.QTableWidgetSelectionRange', 'bool'),
    "PySide2.QtWidgets.QTableWidget.setRowCount": ('int',),
    "PySide2.QtWidgets.QTableWidget.setSortingEnabled": ('bool',),
    "PySide2.QtWidgets.QTableWidget.setVerticalHeaderItem": ('int', 'PySide2.QtWidgets.QTableWidgetItem'),
    "PySide2.QtWidgets.QTableWidget.setVerticalHeaderLabels": ('typing.Sequence',),
    "PySide2.QtWidgets.QTableWidget.sortItems": ('int', 'PySide2.QtCore.Qt.SortOrder'),
    "PySide2.QtWidgets.QTableWidget.supportedDropActions": (),
    "PySide2.QtWidgets.QTableWidget.takeHorizontalHeaderItem": ('int',),
    "PySide2.QtWidgets.QTableWidget.takeItem": ('int', 'int'),
    "PySide2.QtWidgets.QTableWidget.takeVerticalHeaderItem": ('int',),
    "PySide2.QtWidgets.QTableWidget.verticalHeaderItem": ('int',),
    "PySide2.QtWidgets.QTableWidget.visualColumn": ('int',),
    "PySide2.QtWidgets.QTableWidget.visualItemRect": ('PySide2.QtWidgets.QTableWidgetItem',),
    "PySide2.QtWidgets.QTableWidget.visualRow": ('int',),

# class PySide2.QtWidgets.QTableWidgetItem:

# class PySide2.QtWidgets.QTableWidgetItem.ItemType:
    "PySide2.QtWidgets.QTableWidgetItem.__init__": [('PySide2.QtGui.QIcon', 'str', 'int'), ('PySide2.QtWidgets.QTableWidgetItem',), ('int',), ('str', 'int')],
    "PySide2.QtWidgets.QTableWidgetItem.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtWidgets.QTableWidgetItem.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtWidgets.QTableWidgetItem.background": (),
    "PySide2.QtWidgets.QTableWidgetItem.backgroundColor": (),
    "PySide2.QtWidgets.QTableWidgetItem.checkState": (),
    "PySide2.QtWidgets.QTableWidgetItem.clone": (),
    "PySide2.QtWidgets.QTableWidgetItem.column": (),
    "PySide2.QtWidgets.QTableWidgetItem.data": ('int',),
    "PySide2.QtWidgets.QTableWidgetItem.flags": (),
    "PySide2.QtWidgets.QTableWidgetItem.font": (),
    "PySide2.QtWidgets.QTableWidgetItem.foreground": (),
    "PySide2.QtWidgets.QTableWidgetItem.icon": (),
    "PySide2.QtWidgets.QTableWidgetItem.isSelected": (),
    "PySide2.QtWidgets.QTableWidgetItem.read": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtWidgets.QTableWidgetItem.row": (),
    "PySide2.QtWidgets.QTableWidgetItem.setBackground": ('PySide2.QtGui.QBrush',),
    "PySide2.QtWidgets.QTableWidgetItem.setBackgroundColor": ('PySide2.QtGui.QColor',),
    "PySide2.QtWidgets.QTableWidgetItem.setCheckState": ('PySide2.QtCore.Qt.CheckState',),
    "PySide2.QtWidgets.QTableWidgetItem.setData": ('int', 'typing.Any'),
    "PySide2.QtWidgets.QTableWidgetItem.setFlags": ('PySide2.QtCore.Qt.ItemFlags',),
    "PySide2.QtWidgets.QTableWidgetItem.setFont": ('PySide2.QtGui.QFont',),
    "PySide2.QtWidgets.QTableWidgetItem.setForeground": ('PySide2.QtGui.QBrush',),
    "PySide2.QtWidgets.QTableWidgetItem.setIcon": ('PySide2.QtGui.QIcon',),
    "PySide2.QtWidgets.QTableWidgetItem.setSelected": ('bool',),
    "PySide2.QtWidgets.QTableWidgetItem.setSizeHint": ('PySide2.QtCore.QSize',),
    "PySide2.QtWidgets.QTableWidgetItem.setStatusTip": ('str',),
    "PySide2.QtWidgets.QTableWidgetItem.setText": ('str',),
    "PySide2.QtWidgets.QTableWidgetItem.setTextAlignment": ('int',),
    "PySide2.QtWidgets.QTableWidgetItem.setTextColor": ('PySide2.QtGui.QColor',),
    "PySide2.QtWidgets.QTableWidgetItem.setToolTip": ('str',),
    "PySide2.QtWidgets.QTableWidgetItem.setWhatsThis": ('str',),
    "PySide2.QtWidgets.QTableWidgetItem.sizeHint": (),
    "PySide2.QtWidgets.QTableWidgetItem.statusTip": (),
    "PySide2.QtWidgets.QTableWidgetItem.tableWidget": (),
    "PySide2.QtWidgets.QTableWidgetItem.text": (),
    "PySide2.QtWidgets.QTableWidgetItem.textAlignment": (),
    "PySide2.QtWidgets.QTableWidgetItem.textColor": (),
    "PySide2.QtWidgets.QTableWidgetItem.toolTip": (),
    "PySide2.QtWidgets.QTableWidgetItem.type": (),
    "PySide2.QtWidgets.QTableWidgetItem.whatsThis": (),
    "PySide2.QtWidgets.QTableWidgetItem.write": ('PySide2.QtCore.QDataStream',),

# class PySide2.QtWidgets.QTableWidgetSelectionRange:
    "PySide2.QtWidgets.QTableWidgetSelectionRange.__init__": [(), ('PySide2.QtWidgets.QTableWidgetSelectionRange',), ('int', 'int', 'int', 'int')],
    "PySide2.QtWidgets.QTableWidgetSelectionRange.__copy__": (),
    "PySide2.QtWidgets.QTableWidgetSelectionRange.bottomRow": (),
    "PySide2.QtWidgets.QTableWidgetSelectionRange.columnCount": (),
    "PySide2.QtWidgets.QTableWidgetSelectionRange.leftColumn": (),
    "PySide2.QtWidgets.QTableWidgetSelectionRange.rightColumn": (),
    "PySide2.QtWidgets.QTableWidgetSelectionRange.rowCount": (),
    "PySide2.QtWidgets.QTableWidgetSelectionRange.topRow": (),

# class PySide2.QtWidgets.QTapAndHoldGesture:
    "PySide2.QtWidgets.QTapAndHoldGesture.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QTapAndHoldGesture.position": (),
    "PySide2.QtWidgets.QTapAndHoldGesture.setPosition": ('PySide2.QtCore.QPointF',),
    "PySide2.QtWidgets.QTapAndHoldGesture.setTimeout": ('int',),
    "PySide2.QtWidgets.QTapAndHoldGesture.timeout": (),

# class PySide2.QtWidgets.QTapGesture:
    "PySide2.QtWidgets.QTapGesture.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QTapGesture.position": (),
    "PySide2.QtWidgets.QTapGesture.setPosition": ('PySide2.QtCore.QPointF',),

# class PySide2.QtWidgets.QTextBrowser:
    "PySide2.QtWidgets.QTextBrowser.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QTextBrowser.backward": (),
    "PySide2.QtWidgets.QTextBrowser.backwardHistoryCount": (),
    "PySide2.QtWidgets.QTextBrowser.clearHistory": (),
    "PySide2.QtWidgets.QTextBrowser.doSetSource": ('PySide2.QtCore.QUrl', 'PySide2.QtGui.QTextDocument.ResourceType'),
    "PySide2.QtWidgets.QTextBrowser.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QTextBrowser.focusNextPrevChild": ('bool',),
    "PySide2.QtWidgets.QTextBrowser.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QTextBrowser.forward": (),
    "PySide2.QtWidgets.QTextBrowser.forwardHistoryCount": (),
    "PySide2.QtWidgets.QTextBrowser.historyTitle": ('int',),
    "PySide2.QtWidgets.QTextBrowser.historyUrl": ('int',),
    "PySide2.QtWidgets.QTextBrowser.home": (),
    "PySide2.QtWidgets.QTextBrowser.isBackwardAvailable": (),
    "PySide2.QtWidgets.QTextBrowser.isForwardAvailable": (),
    "PySide2.QtWidgets.QTextBrowser.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QTextBrowser.loadResource": ('int', 'PySide2.QtCore.QUrl'),
    "PySide2.QtWidgets.QTextBrowser.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QTextBrowser.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QTextBrowser.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QTextBrowser.openExternalLinks": (),
    "PySide2.QtWidgets.QTextBrowser.openLinks": (),
    "PySide2.QtWidgets.QTextBrowser.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QTextBrowser.reload": (),
    "PySide2.QtWidgets.QTextBrowser.searchPaths": (),
    "PySide2.QtWidgets.QTextBrowser.setOpenExternalLinks": ('bool',),
    "PySide2.QtWidgets.QTextBrowser.setOpenLinks": ('bool',),
    "PySide2.QtWidgets.QTextBrowser.setSearchPaths": ('typing.Sequence',),
    "PySide2.QtWidgets.QTextBrowser.setSource": [('PySide2.QtCore.QUrl',), ('PySide2.QtCore.QUrl', 'PySide2.QtGui.QTextDocument.ResourceType')],
    "PySide2.QtWidgets.QTextBrowser.source": (),
    "PySide2.QtWidgets.QTextBrowser.sourceType": (),

# class PySide2.QtWidgets.QTextEdit:

# class PySide2.QtWidgets.QTextEdit.AutoFormatting:

# class PySide2.QtWidgets.QTextEdit.AutoFormattingFlag:

# class PySide2.QtWidgets.QTextEdit.ExtraSelection:
    "PySide2.QtWidgets.QTextEdit.ExtraSelection.__init__": [(), ('PySide2.QtWidgets.QTextEdit.ExtraSelection',)],
    "PySide2.QtWidgets.QTextEdit.ExtraSelection.__copy__": (),

# class PySide2.QtWidgets.QTextEdit.LineWrapMode:

    "PySide2.QtWidgets.QTextEdit.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
    "PySide2.QtWidgets.QTextEdit.acceptRichText": (),
    "PySide2.QtWidgets.QTextEdit.alignment": (),
    "PySide2.QtWidgets.QTextEdit.anchorAt": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QTextEdit.append": ('str',),
    "PySide2.QtWidgets.QTextEdit.autoFormatting": (),
    "PySide2.QtWidgets.QTextEdit.canInsertFromMimeData": ('PySide2.QtCore.QMimeData',),
    "PySide2.QtWidgets.QTextEdit.canPaste": (),
    "PySide2.QtWidgets.QTextEdit.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QTextEdit.clear": (),
    "PySide2.QtWidgets.QTextEdit.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
    "PySide2.QtWidgets.QTextEdit.copy": (),
    "PySide2.QtWidgets.QTextEdit.createMimeDataFromSelection": (),
    "PySide2.QtWidgets.QTextEdit.createStandardContextMenu": [(), ('PySide2.QtCore.QPoint',)],
    "PySide2.QtWidgets.QTextEdit.currentCharFormat": (),
    "PySide2.QtWidgets.QTextEdit.currentFont": (),
    "PySide2.QtWidgets.QTextEdit.cursorForPosition": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QTextEdit.cursorRect": [(), ('PySide2.QtGui.QTextCursor',)],
    "PySide2.QtWidgets.QTextEdit.cursorWidth": (),
    "PySide2.QtWidgets.QTextEdit.cut": (),
    "PySide2.QtWidgets.QTextEdit.doSetTextCursor": ('PySide2.QtGui.QTextCursor',),
    "PySide2.QtWidgets.QTextEdit.document": (),
    "PySide2.QtWidgets.QTextEdit.documentTitle": (),
    "PySide2.QtWidgets.QTextEdit.dragEnterEvent": ('PySide2.QtGui.QDragEnterEvent',),
    "PySide2.QtWidgets.QTextEdit.dragLeaveEvent": ('PySide2.QtGui.QDragLeaveEvent',),
    "PySide2.QtWidgets.QTextEdit.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
    "PySide2.QtWidgets.QTextEdit.dropEvent": ('PySide2.QtGui.QDropEvent',),
    "PySide2.QtWidgets.QTextEdit.ensureCursorVisible": (),
    "PySide2.QtWidgets.QTextEdit.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QTextEdit.extraSelections": (),
    "PySide2.QtWidgets.QTextEdit.find": [('PySide2.QtCore.QRegExp', 'PySide2.QtGui.QTextDocument.FindFlags'), ('PySide2.QtCore.QRegularExpression', 'PySide2.QtGui.QTextDocument.FindFlags'), ('str', 'PySide2.QtGui.QTextDocument.FindFlags')],
    "PySide2.QtWidgets.QTextEdit.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QTextEdit.focusNextPrevChild": ('bool',),
    "PySide2.QtWidgets.QTextEdit.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QTextEdit.fontFamily": (),
    "PySide2.QtWidgets.QTextEdit.fontItalic": (),
    "PySide2.QtWidgets.QTextEdit.fontPointSize": (),
    "PySide2.QtWidgets.QTextEdit.fontUnderline": (),
    "PySide2.QtWidgets.QTextEdit.fontWeight": (),
    "PySide2.QtWidgets.QTextEdit.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
    "PySide2.QtWidgets.QTextEdit.inputMethodQuery": [('PySide2.QtCore.Qt.InputMethodQuery',), ('PySide2.QtCore.Qt.InputMethodQuery', 'typing.Any')],
    "PySide2.QtWidgets.QTextEdit.insertFromMimeData": ('PySide2.QtCore.QMimeData',),
    "PySide2.QtWidgets.QTextEdit.insertHtml": ('str',),
    "PySide2.QtWidgets.QTextEdit.insertPlainText": ('str',),
    "PySide2.QtWidgets.QTextEdit.isReadOnly": (),
    "PySide2.QtWidgets.QTextEdit.isUndoRedoEnabled": (),
    "PySide2.QtWidgets.QTextEdit.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QTextEdit.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QTextEdit.lineWrapColumnOrWidth": (),
    "PySide2.QtWidgets.QTextEdit.lineWrapMode": (),
    "PySide2.QtWidgets.QTextEdit.loadResource": ('int', 'PySide2.QtCore.QUrl'),
    "PySide2.QtWidgets.QTextEdit.mergeCurrentCharFormat": ('PySide2.QtGui.QTextCharFormat',),
    "PySide2.QtWidgets.QTextEdit.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QTextEdit.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QTextEdit.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QTextEdit.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QTextEdit.moveCursor": ('PySide2.QtGui.QTextCursor.MoveOperation', 'PySide2.QtGui.QTextCursor.MoveMode'),
    "PySide2.QtWidgets.QTextEdit.overwriteMode": (),
    "PySide2.QtWidgets.QTextEdit.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QTextEdit.paste": (),
    "PySide2.QtWidgets.QTextEdit.placeholderText": (),
    "PySide2.QtWidgets.QTextEdit.print_": ('PySide2.QtGui.QPagedPaintDevice',),
    "PySide2.QtWidgets.QTextEdit.redo": (),
    "PySide2.QtWidgets.QTextEdit.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QTextEdit.scrollContentsBy": ('int', 'int'),
    "PySide2.QtWidgets.QTextEdit.scrollToAnchor": ('str',),
    "PySide2.QtWidgets.QTextEdit.selectAll": (),
    "PySide2.QtWidgets.QTextEdit.setAcceptRichText": ('bool',),
    "PySide2.QtWidgets.QTextEdit.setAlignment": ('PySide2.QtCore.Qt.Alignment',),
    "PySide2.QtWidgets.QTextEdit.setAutoFormatting": ('PySide2.QtWidgets.QTextEdit.AutoFormatting',),
    "PySide2.QtWidgets.QTextEdit.setCurrentCharFormat": ('PySide2.QtGui.QTextCharFormat',),
    "PySide2.QtWidgets.QTextEdit.setCurrentFont": ('PySide2.QtGui.QFont',),
    "PySide2.QtWidgets.QTextEdit.setCursorWidth": ('int',),
    "PySide2.QtWidgets.QTextEdit.setDocument": ('PySide2.QtGui.QTextDocument',),
    "PySide2.QtWidgets.QTextEdit.setDocumentTitle": ('str',),
    "PySide2.QtWidgets.QTextEdit.setExtraSelections": ('typing.Sequence',),
    "PySide2.QtWidgets.QTextEdit.setFontFamily": ('str',),
    "PySide2.QtWidgets.QTextEdit.setFontItalic": ('bool',),
    "PySide2.QtWidgets.QTextEdit.setFontPointSize": ('float',),
    "PySide2.QtWidgets.QTextEdit.setFontUnderline": ('bool',),
    "PySide2.QtWidgets.QTextEdit.setFontWeight": ('int',),
    "PySide2.QtWidgets.QTextEdit.setHtml": ('str',),
    "PySide2.QtWidgets.QTextEdit.setLineWrapColumnOrWidth": ('int',),
    "PySide2.QtWidgets.QTextEdit.setLineWrapMode": ('PySide2.QtWidgets.QTextEdit.LineWrapMode',),
    "PySide2.QtWidgets.QTextEdit.setMarkdown": ('str',),
    "PySide2.QtWidgets.QTextEdit.setOverwriteMode": ('bool',),
    "PySide2.QtWidgets.QTextEdit.setPlaceholderText": ('str',),
    "PySide2.QtWidgets.QTextEdit.setPlainText": ('str',),
    "PySide2.QtWidgets.QTextEdit.setReadOnly": ('bool',),
    "PySide2.QtWidgets.QTextEdit.setTabChangesFocus": ('bool',),
    "PySide2.QtWidgets.QTextEdit.setTabStopDistance": ('float',),
    "PySide2.QtWidgets.QTextEdit.setTabStopWidth": ('int',),
    "PySide2.QtWidgets.QTextEdit.setText": ('str',),
    "PySide2.QtWidgets.QTextEdit.setTextBackgroundColor": ('PySide2.QtGui.QColor',),
    "PySide2.QtWidgets.QTextEdit.setTextColor": ('PySide2.QtGui.QColor',),
    "PySide2.QtWidgets.QTextEdit.setTextCursor": ('PySide2.QtGui.QTextCursor',),
    "PySide2.QtWidgets.QTextEdit.setTextInteractionFlags": ('PySide2.QtCore.Qt.TextInteractionFlags',),
    "PySide2.QtWidgets.QTextEdit.setUndoRedoEnabled": ('bool',),
    "PySide2.QtWidgets.QTextEdit.setWordWrapMode": ('PySide2.QtGui.QTextOption.WrapMode',),
    "PySide2.QtWidgets.QTextEdit.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QTextEdit.tabChangesFocus": (),
    "PySide2.QtWidgets.QTextEdit.tabStopDistance": (),
    "PySide2.QtWidgets.QTextEdit.tabStopWidth": (),
    "PySide2.QtWidgets.QTextEdit.textBackgroundColor": (),
    "PySide2.QtWidgets.QTextEdit.textColor": (),
    "PySide2.QtWidgets.QTextEdit.textCursor": (),
    "PySide2.QtWidgets.QTextEdit.textInteractionFlags": (),
    "PySide2.QtWidgets.QTextEdit.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtWidgets.QTextEdit.toHtml": (),
    "PySide2.QtWidgets.QTextEdit.toMarkdown": ('PySide2.QtGui.QTextDocument.MarkdownFeatures',),
    "PySide2.QtWidgets.QTextEdit.toPlainText": (),
    "PySide2.QtWidgets.QTextEdit.undo": (),
    "PySide2.QtWidgets.QTextEdit.wheelEvent": ('PySide2.QtGui.QWheelEvent',),
    "PySide2.QtWidgets.QTextEdit.wordWrapMode": (),
    "PySide2.QtWidgets.QTextEdit.zoomIn": ('int',),
    "PySide2.QtWidgets.QTextEdit.zoomInF": ('float',),
    "PySide2.QtWidgets.QTextEdit.zoomOut": ('int',),

# class PySide2.QtWidgets.QTileRules:
    "PySide2.QtWidgets.QTileRules.__init__": [('PySide2.QtCore.Qt.TileRule',), ('PySide2.QtCore.Qt.TileRule', 'PySide2.QtCore.Qt.TileRule'), ('PySide2.QtWidgets.QTileRules',)],
    "PySide2.QtWidgets.QTileRules.__copy__": (),

# class PySide2.QtWidgets.QTimeEdit:
    "PySide2.QtWidgets.QTimeEdit.__init__": [('PySide2.QtCore.QTime', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],

# class PySide2.QtWidgets.QToolBar:
    "PySide2.QtWidgets.QToolBar.__init__": [('PySide2.QtWidgets.QWidget',), ('str', 'PySide2.QtWidgets.QWidget')],
    "PySide2.QtWidgets.QToolBar.actionAt": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtWidgets.QToolBar.actionEvent": ('PySide2.QtGui.QActionEvent',),
    "PySide2.QtWidgets.QToolBar.actionGeometry": ('PySide2.QtWidgets.QAction',),
    "PySide2.QtWidgets.QToolBar.addAction": [('PySide2.QtGui.QIcon', 'str'), ('PySide2.QtGui.QIcon', 'str', 'PySide2.QtCore.QObject', 'bytes'), ('PySide2.QtWidgets.QAction',), ('str',), ('str', 'PySide2.QtCore.QObject', 'bytes')],
    "PySide2.QtWidgets.QToolBar.addSeparator": (),
    "PySide2.QtWidgets.QToolBar.addWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QToolBar.allowedAreas": (),
    "PySide2.QtWidgets.QToolBar.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QToolBar.clear": (),
    "PySide2.QtWidgets.QToolBar.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QToolBar.iconSize": (),
    "PySide2.QtWidgets.QToolBar.initStyleOption": ('PySide2.QtWidgets.QStyleOptionToolBar',),
    "PySide2.QtWidgets.QToolBar.insertSeparator": ('PySide2.QtWidgets.QAction',),
    "PySide2.QtWidgets.QToolBar.insertWidget": ('PySide2.QtWidgets.QAction', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QToolBar.isAreaAllowed": ('PySide2.QtCore.Qt.ToolBarArea',),
    "PySide2.QtWidgets.QToolBar.isFloatable": (),
    "PySide2.QtWidgets.QToolBar.isFloating": (),
    "PySide2.QtWidgets.QToolBar.isMovable": (),
    "PySide2.QtWidgets.QToolBar.orientation": (),
    "PySide2.QtWidgets.QToolBar.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QToolBar.setAllowedAreas": ('PySide2.QtCore.Qt.ToolBarAreas',),
    "PySide2.QtWidgets.QToolBar.setFloatable": ('bool',),
    "PySide2.QtWidgets.QToolBar.setIconSize": ('PySide2.QtCore.QSize',),
    "PySide2.QtWidgets.QToolBar.setMovable": ('bool',),
    "PySide2.QtWidgets.QToolBar.setOrientation": ('PySide2.QtCore.Qt.Orientation',),
    "PySide2.QtWidgets.QToolBar.setToolButtonStyle": ('PySide2.QtCore.Qt.ToolButtonStyle',),
    "PySide2.QtWidgets.QToolBar.toggleViewAction": (),
    "PySide2.QtWidgets.QToolBar.toolButtonStyle": (),
    "PySide2.QtWidgets.QToolBar.widgetForAction": ('PySide2.QtWidgets.QAction',),

# class PySide2.QtWidgets.QToolBox:
    "PySide2.QtWidgets.QToolBox.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
    "PySide2.QtWidgets.QToolBox.addItem": [('PySide2.QtWidgets.QWidget', 'PySide2.QtGui.QIcon', 'str'), ('PySide2.QtWidgets.QWidget', 'str')],
    "PySide2.QtWidgets.QToolBox.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QToolBox.count": (),
    "PySide2.QtWidgets.QToolBox.currentIndex": (),
    "PySide2.QtWidgets.QToolBox.currentWidget": (),
    "PySide2.QtWidgets.QToolBox.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QToolBox.indexOf": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QToolBox.insertItem": [('int', 'PySide2.QtWidgets.QWidget', 'PySide2.QtGui.QIcon', 'str'), ('int', 'PySide2.QtWidgets.QWidget', 'str')],
    "PySide2.QtWidgets.QToolBox.isItemEnabled": ('int',),
    "PySide2.QtWidgets.QToolBox.itemIcon": ('int',),
    "PySide2.QtWidgets.QToolBox.itemInserted": ('int',),
    "PySide2.QtWidgets.QToolBox.itemRemoved": ('int',),
    "PySide2.QtWidgets.QToolBox.itemText": ('int',),
    "PySide2.QtWidgets.QToolBox.itemToolTip": ('int',),
    "PySide2.QtWidgets.QToolBox.removeItem": ('int',),
    "PySide2.QtWidgets.QToolBox.setCurrentIndex": ('int',),
    "PySide2.QtWidgets.QToolBox.setCurrentWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QToolBox.setItemEnabled": ('int', 'bool'),
    "PySide2.QtWidgets.QToolBox.setItemIcon": ('int', 'PySide2.QtGui.QIcon'),
    "PySide2.QtWidgets.QToolBox.setItemText": ('int', 'str'),
    "PySide2.QtWidgets.QToolBox.setItemToolTip": ('int', 'str'),
    "PySide2.QtWidgets.QToolBox.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QToolBox.widget": ('int',),

# class PySide2.QtWidgets.QToolButton:

# class PySide2.QtWidgets.QToolButton.ToolButtonPopupMode:
    "PySide2.QtWidgets.QToolButton.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QToolButton.actionEvent": ('PySide2.QtGui.QActionEvent',),
    "PySide2.QtWidgets.QToolButton.arrowType": (),
    "PySide2.QtWidgets.QToolButton.autoRaise": (),
    "PySide2.QtWidgets.QToolButton.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QToolButton.defaultAction": (),
    "PySide2.QtWidgets.QToolButton.enterEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QToolButton.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QToolButton.hitButton": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QToolButton.initStyleOption": ('PySide2.QtWidgets.QStyleOptionToolButton',),
    "PySide2.QtWidgets.QToolButton.leaveEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QToolButton.menu": (),
    "PySide2.QtWidgets.QToolButton.minimumSizeHint": (),
    "PySide2.QtWidgets.QToolButton.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QToolButton.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QToolButton.nextCheckState": (),
    "PySide2.QtWidgets.QToolButton.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QToolButton.popupMode": (),
    "PySide2.QtWidgets.QToolButton.setArrowType": ('PySide2.QtCore.Qt.ArrowType',),
    "PySide2.QtWidgets.QToolButton.setAutoRaise": ('bool',),
    "PySide2.QtWidgets.QToolButton.setDefaultAction": ('PySide2.QtWidgets.QAction',),
    "PySide2.QtWidgets.QToolButton.setMenu": ('PySide2.QtWidgets.QMenu',),
    "PySide2.QtWidgets.QToolButton.setPopupMode": ('PySide2.QtWidgets.QToolButton.ToolButtonPopupMode',),
    "PySide2.QtWidgets.QToolButton.setToolButtonStyle": ('PySide2.QtCore.Qt.ToolButtonStyle',),
    "PySide2.QtWidgets.QToolButton.showMenu": (),
    "PySide2.QtWidgets.QToolButton.sizeHint": (),
    "PySide2.QtWidgets.QToolButton.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtWidgets.QToolButton.toolButtonStyle": (),

# class PySide2.QtWidgets.QToolTip:
    "PySide2.QtWidgets.QToolTip.font": (),
    "PySide2.QtWidgets.QToolTip.hideText": (),
    "PySide2.QtWidgets.QToolTip.isVisible": (),
    "PySide2.QtWidgets.QToolTip.palette": (),
    "PySide2.QtWidgets.QToolTip.setFont": ('PySide2.QtGui.QFont',),
    "PySide2.QtWidgets.QToolTip.setPalette": ('PySide2.QtGui.QPalette',),
    "PySide2.QtWidgets.QToolTip.showText": [('PySide2.QtCore.QPoint', 'str', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtCore.QPoint', 'str', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QRect'), ('PySide2.QtCore.QPoint', 'str', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QRect', 'int')],
    "PySide2.QtWidgets.QToolTip.text": (),

# class PySide2.QtWidgets.QTreeView:
    "PySide2.QtWidgets.QTreeView.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QTreeView.allColumnsShowFocus": (),
    "PySide2.QtWidgets.QTreeView.autoExpandDelay": (),
    "PySide2.QtWidgets.QTreeView.collapse": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QTreeView.collapseAll": (),
    "PySide2.QtWidgets.QTreeView.columnAt": ('int',),
    "PySide2.QtWidgets.QTreeView.columnCountChanged": ('int', 'int'),
    "PySide2.QtWidgets.QTreeView.columnMoved": (),
    "PySide2.QtWidgets.QTreeView.columnResized": ('int', 'int', 'int'),
    "PySide2.QtWidgets.QTreeView.columnViewportPosition": ('int',),
    "PySide2.QtWidgets.QTreeView.columnWidth": ('int',),
    "PySide2.QtWidgets.QTreeView.currentChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QTreeView.dataChanged": ('PySide2.QtCore.QModelIndex', 'PySide2.QtCore.QModelIndex', 'typing.List'),
    "PySide2.QtWidgets.QTreeView.doItemsLayout": (),
    "PySide2.QtWidgets.QTreeView.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
    "PySide2.QtWidgets.QTreeView.drawBranches": ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QRect', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QTreeView.drawRow": ('PySide2.QtGui.QPainter', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QTreeView.drawTree": ('PySide2.QtGui.QPainter', 'PySide2.QtGui.QRegion'),
    "PySide2.QtWidgets.QTreeView.expand": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QTreeView.expandAll": (),
    "PySide2.QtWidgets.QTreeView.expandRecursively": ('PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtWidgets.QTreeView.expandToDepth": ('int',),
    "PySide2.QtWidgets.QTreeView.expandsOnDoubleClick": (),
    "PySide2.QtWidgets.QTreeView.header": (),
    "PySide2.QtWidgets.QTreeView.hideColumn": ('int',),
    "PySide2.QtWidgets.QTreeView.horizontalOffset": (),
    "PySide2.QtWidgets.QTreeView.horizontalScrollbarAction": ('int',),
    "PySide2.QtWidgets.QTreeView.indentation": (),
    "PySide2.QtWidgets.QTreeView.indexAbove": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QTreeView.indexAt": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QTreeView.indexBelow": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QTreeView.indexRowSizeHint": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QTreeView.isAnimated": (),
    "PySide2.QtWidgets.QTreeView.isColumnHidden": ('int',),
    "PySide2.QtWidgets.QTreeView.isExpanded": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QTreeView.isFirstColumnSpanned": ('int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QTreeView.isHeaderHidden": (),
    "PySide2.QtWidgets.QTreeView.isIndexHidden": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QTreeView.isRowHidden": ('int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtWidgets.QTreeView.isSortingEnabled": (),
    "PySide2.QtWidgets.QTreeView.itemsExpandable": (),
    "PySide2.QtWidgets.QTreeView.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QTreeView.keyboardSearch": ('str',),
    "PySide2.QtWidgets.QTreeView.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QTreeView.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QTreeView.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QTreeView.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QTreeView.moveCursor": ('PySide2.QtWidgets.QAbstractItemView.CursorAction', 'PySide2.QtCore.Qt.KeyboardModifiers'),
    "PySide2.QtWidgets.QTreeView.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QTreeView.reexpand": (),
    "PySide2.QtWidgets.QTreeView.reset": (),
    "PySide2.QtWidgets.QTreeView.resetIndentation": (),
    "PySide2.QtWidgets.QTreeView.resizeColumnToContents": ('int',),
    "PySide2.QtWidgets.QTreeView.rootIsDecorated": (),
    "PySide2.QtWidgets.QTreeView.rowHeight": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QTreeView.rowsAboutToBeRemoved": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtWidgets.QTreeView.rowsInserted": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtWidgets.QTreeView.rowsRemoved": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtWidgets.QTreeView.scrollContentsBy": ('int', 'int'),
    "PySide2.QtWidgets.QTreeView.scrollTo": ('PySide2.QtCore.QModelIndex', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
    "PySide2.QtWidgets.QTreeView.selectAll": (),
    "PySide2.QtWidgets.QTreeView.selectedIndexes": (),
    "PySide2.QtWidgets.QTreeView.selectionChanged": ('PySide2.QtCore.QItemSelection', 'PySide2.QtCore.QItemSelection'),
    "PySide2.QtWidgets.QTreeView.setAllColumnsShowFocus": ('bool',),
    "PySide2.QtWidgets.QTreeView.setAnimated": ('bool',),
    "PySide2.QtWidgets.QTreeView.setAutoExpandDelay": ('int',),
    "PySide2.QtWidgets.QTreeView.setColumnHidden": ('int', 'bool'),
    "PySide2.QtWidgets.QTreeView.setColumnWidth": ('int', 'int'),
    "PySide2.QtWidgets.QTreeView.setExpanded": ('PySide2.QtCore.QModelIndex', 'bool'),
    "PySide2.QtWidgets.QTreeView.setExpandsOnDoubleClick": ('bool',),
    "PySide2.QtWidgets.QTreeView.setFirstColumnSpanned": ('int', 'PySide2.QtCore.QModelIndex', 'bool'),
    "PySide2.QtWidgets.QTreeView.setHeader": ('PySide2.QtWidgets.QHeaderView',),
    "PySide2.QtWidgets.QTreeView.setHeaderHidden": ('bool',),
    "PySide2.QtWidgets.QTreeView.setIndentation": ('int',),
    "PySide2.QtWidgets.QTreeView.setItemsExpandable": ('bool',),
    "PySide2.QtWidgets.QTreeView.setModel": ('PySide2.QtCore.QAbstractItemModel',),
    "PySide2.QtWidgets.QTreeView.setRootIndex": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QTreeView.setRootIsDecorated": ('bool',),
    "PySide2.QtWidgets.QTreeView.setRowHidden": ('int', 'PySide2.QtCore.QModelIndex', 'bool'),
    "PySide2.QtWidgets.QTreeView.setSelection": ('PySide2.QtCore.QRect', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags'),
    "PySide2.QtWidgets.QTreeView.setSelectionModel": ('PySide2.QtCore.QItemSelectionModel',),
    "PySide2.QtWidgets.QTreeView.setSortingEnabled": ('bool',),
    "PySide2.QtWidgets.QTreeView.setTreePosition": ('int',),
    "PySide2.QtWidgets.QTreeView.setUniformRowHeights": ('bool',),
    "PySide2.QtWidgets.QTreeView.setWordWrap": ('bool',),
    "PySide2.QtWidgets.QTreeView.showColumn": ('int',),
    "PySide2.QtWidgets.QTreeView.sizeHintForColumn": ('int',),
    "PySide2.QtWidgets.QTreeView.sortByColumn": [('int',), ('int', 'PySide2.QtCore.Qt.SortOrder')],
    "PySide2.QtWidgets.QTreeView.timerEvent": ('PySide2.QtCore.QTimerEvent',),
    "PySide2.QtWidgets.QTreeView.treePosition": (),
    "PySide2.QtWidgets.QTreeView.uniformRowHeights": (),
    "PySide2.QtWidgets.QTreeView.updateGeometries": (),
    "PySide2.QtWidgets.QTreeView.verticalOffset": (),
    "PySide2.QtWidgets.QTreeView.verticalScrollbarValueChanged": ('int',),
    "PySide2.QtWidgets.QTreeView.viewportEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QTreeView.viewportSizeHint": (),
    "PySide2.QtWidgets.QTreeView.visualRect": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QTreeView.visualRegionForSelection": ('PySide2.QtCore.QItemSelection',),
    "PySide2.QtWidgets.QTreeView.wordWrap": (),

# class PySide2.QtWidgets.QTreeWidget:
    "PySide2.QtWidgets.QTreeWidget.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QTreeWidget.addTopLevelItem": ('PySide2.QtWidgets.QTreeWidgetItem',),
    "PySide2.QtWidgets.QTreeWidget.addTopLevelItems": ('typing.Sequence',),
    "PySide2.QtWidgets.QTreeWidget.clear": (),
    "PySide2.QtWidgets.QTreeWidget.closePersistentEditor": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QTreeWidgetItem', 'int')],
    "PySide2.QtWidgets.QTreeWidget.collapseItem": ('PySide2.QtWidgets.QTreeWidgetItem',),
    "PySide2.QtWidgets.QTreeWidget.columnCount": (),
    "PySide2.QtWidgets.QTreeWidget.currentColumn": (),
    "PySide2.QtWidgets.QTreeWidget.currentItem": (),
    "PySide2.QtWidgets.QTreeWidget.dropEvent": ('PySide2.QtGui.QDropEvent',),
    "PySide2.QtWidgets.QTreeWidget.dropMimeData": ('PySide2.QtWidgets.QTreeWidgetItem', 'int', 'PySide2.QtCore.QMimeData', 'PySide2.QtCore.Qt.DropAction'),
    "PySide2.QtWidgets.QTreeWidget.editItem": ('PySide2.QtWidgets.QTreeWidgetItem', 'int'),
    "PySide2.QtWidgets.QTreeWidget.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QTreeWidget.expandItem": ('PySide2.QtWidgets.QTreeWidgetItem',),
    "PySide2.QtWidgets.QTreeWidget.findItems": ('str', 'PySide2.QtCore.Qt.MatchFlags', 'int'),
    "PySide2.QtWidgets.QTreeWidget.headerItem": (),
    "PySide2.QtWidgets.QTreeWidget.indexFromItem": ('PySide2.QtWidgets.QTreeWidgetItem', 'int'),
    "PySide2.QtWidgets.QTreeWidget.indexOfTopLevelItem": ('PySide2.QtWidgets.QTreeWidgetItem',),
    "PySide2.QtWidgets.QTreeWidget.insertTopLevelItem": ('int', 'PySide2.QtWidgets.QTreeWidgetItem'),
    "PySide2.QtWidgets.QTreeWidget.insertTopLevelItems": ('int', 'typing.Sequence'),
    "PySide2.QtWidgets.QTreeWidget.invisibleRootItem": (),
    "PySide2.QtWidgets.QTreeWidget.isFirstItemColumnSpanned": ('PySide2.QtWidgets.QTreeWidgetItem',),
    "PySide2.QtWidgets.QTreeWidget.isItemExpanded": ('PySide2.QtWidgets.QTreeWidgetItem',),
    "PySide2.QtWidgets.QTreeWidget.isItemHidden": ('PySide2.QtWidgets.QTreeWidgetItem',),
    "PySide2.QtWidgets.QTreeWidget.isItemSelected": ('PySide2.QtWidgets.QTreeWidgetItem',),
    "PySide2.QtWidgets.QTreeWidget.isPersistentEditorOpen": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QTreeWidgetItem', 'int')],
    "PySide2.QtWidgets.QTreeWidget.itemAbove": ('PySide2.QtWidgets.QTreeWidgetItem',),
    "PySide2.QtWidgets.QTreeWidget.itemAt": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtWidgets.QTreeWidget.itemBelow": ('PySide2.QtWidgets.QTreeWidgetItem',),
    "PySide2.QtWidgets.QTreeWidget.itemFromIndex": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtWidgets.QTreeWidget.itemWidget": ('PySide2.QtWidgets.QTreeWidgetItem', 'int'),
    "PySide2.QtWidgets.QTreeWidget.items": ('PySide2.QtCore.QMimeData',),
    "PySide2.QtWidgets.QTreeWidget.mimeData": ('typing.Sequence',),
    "PySide2.QtWidgets.QTreeWidget.mimeTypes": (),
    "PySide2.QtWidgets.QTreeWidget.openPersistentEditor": [('PySide2.QtCore.QModelIndex',), ('PySide2.QtWidgets.QTreeWidgetItem', 'int')],
    "PySide2.QtWidgets.QTreeWidget.removeItemWidget": ('PySide2.QtWidgets.QTreeWidgetItem', 'int'),
    "PySide2.QtWidgets.QTreeWidget.scrollToItem": ('PySide2.QtWidgets.QTreeWidgetItem', 'PySide2.QtWidgets.QAbstractItemView.ScrollHint'),
    "PySide2.QtWidgets.QTreeWidget.selectedItems": (),
    "PySide2.QtWidgets.QTreeWidget.setColumnCount": ('int',),
    "PySide2.QtWidgets.QTreeWidget.setCurrentItem": [('PySide2.QtWidgets.QTreeWidgetItem',), ('PySide2.QtWidgets.QTreeWidgetItem', 'int'), ('PySide2.QtWidgets.QTreeWidgetItem', 'int', 'PySide2.QtCore.QItemSelectionModel.SelectionFlags')],
    "PySide2.QtWidgets.QTreeWidget.setFirstItemColumnSpanned": ('PySide2.QtWidgets.QTreeWidgetItem', 'bool'),
    "PySide2.QtWidgets.QTreeWidget.setHeaderItem": ('PySide2.QtWidgets.QTreeWidgetItem',),
    "PySide2.QtWidgets.QTreeWidget.setHeaderLabel": ('str',),
    "PySide2.QtWidgets.QTreeWidget.setHeaderLabels": ('typing.Sequence',),
    "PySide2.QtWidgets.QTreeWidget.setItemExpanded": ('PySide2.QtWidgets.QTreeWidgetItem', 'bool'),
    "PySide2.QtWidgets.QTreeWidget.setItemHidden": ('PySide2.QtWidgets.QTreeWidgetItem', 'bool'),
    "PySide2.QtWidgets.QTreeWidget.setItemSelected": ('PySide2.QtWidgets.QTreeWidgetItem', 'bool'),
    "PySide2.QtWidgets.QTreeWidget.setItemWidget": ('PySide2.QtWidgets.QTreeWidgetItem', 'int', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QTreeWidget.setModel": ('PySide2.QtCore.QAbstractItemModel',),
    "PySide2.QtWidgets.QTreeWidget.setSelectionModel": ('PySide2.QtCore.QItemSelectionModel',),
    "PySide2.QtWidgets.QTreeWidget.sortColumn": (),
    "PySide2.QtWidgets.QTreeWidget.sortItems": ('int', 'PySide2.QtCore.Qt.SortOrder'),
    "PySide2.QtWidgets.QTreeWidget.supportedDropActions": (),
    "PySide2.QtWidgets.QTreeWidget.takeTopLevelItem": ('int',),
    "PySide2.QtWidgets.QTreeWidget.topLevelItem": ('int',),
    "PySide2.QtWidgets.QTreeWidget.topLevelItemCount": (),
    "PySide2.QtWidgets.QTreeWidget.visualItemRect": ('PySide2.QtWidgets.QTreeWidgetItem',),

# class PySide2.QtWidgets.QTreeWidgetItem:

# class PySide2.QtWidgets.QTreeWidgetItem.ChildIndicatorPolicy:

# class PySide2.QtWidgets.QTreeWidgetItem.ItemType:
    "PySide2.QtWidgets.QTreeWidgetItem.__init__": [('PySide2.QtWidgets.QTreeWidget', 'PySide2.QtWidgets.QTreeWidgetItem', 'int'), ('PySide2.QtWidgets.QTreeWidget', 'int'), ('PySide2.QtWidgets.QTreeWidget', 'typing.Sequence', 'int'), ('PySide2.QtWidgets.QTreeWidgetItem',), ('PySide2.QtWidgets.QTreeWidgetItem', 'PySide2.QtWidgets.QTreeWidgetItem', 'int'), ('PySide2.QtWidgets.QTreeWidgetItem', 'int'), ('PySide2.QtWidgets.QTreeWidgetItem', 'typing.Sequence', 'int'), ('int',), ('typing.Sequence', 'int')],
    "PySide2.QtWidgets.QTreeWidgetItem.__lshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtWidgets.QTreeWidgetItem.__rshift__": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtWidgets.QTreeWidgetItem.addChild": ('PySide2.QtWidgets.QTreeWidgetItem',),
    "PySide2.QtWidgets.QTreeWidgetItem.addChildren": ('typing.Sequence',),
    "PySide2.QtWidgets.QTreeWidgetItem.background": ('int',),
    "PySide2.QtWidgets.QTreeWidgetItem.backgroundColor": ('int',),
    "PySide2.QtWidgets.QTreeWidgetItem.checkState": ('int',),
    "PySide2.QtWidgets.QTreeWidgetItem.child": ('int',),
    "PySide2.QtWidgets.QTreeWidgetItem.childCount": (),
    "PySide2.QtWidgets.QTreeWidgetItem.childIndicatorPolicy": (),
    "PySide2.QtWidgets.QTreeWidgetItem.clone": (),
    "PySide2.QtWidgets.QTreeWidgetItem.columnCount": (),
    "PySide2.QtWidgets.QTreeWidgetItem.data": ('int', 'int'),
    "PySide2.QtWidgets.QTreeWidgetItem.emitDataChanged": (),
    "PySide2.QtWidgets.QTreeWidgetItem.flags": (),
    "PySide2.QtWidgets.QTreeWidgetItem.font": ('int',),
    "PySide2.QtWidgets.QTreeWidgetItem.foreground": ('int',),
    "PySide2.QtWidgets.QTreeWidgetItem.icon": ('int',),
    "PySide2.QtWidgets.QTreeWidgetItem.indexOfChild": ('PySide2.QtWidgets.QTreeWidgetItem',),
    "PySide2.QtWidgets.QTreeWidgetItem.insertChild": ('int', 'PySide2.QtWidgets.QTreeWidgetItem'),
    "PySide2.QtWidgets.QTreeWidgetItem.insertChildren": ('int', 'typing.Sequence'),
    "PySide2.QtWidgets.QTreeWidgetItem.isDisabled": (),
    "PySide2.QtWidgets.QTreeWidgetItem.isExpanded": (),
    "PySide2.QtWidgets.QTreeWidgetItem.isFirstColumnSpanned": (),
    "PySide2.QtWidgets.QTreeWidgetItem.isHidden": (),
    "PySide2.QtWidgets.QTreeWidgetItem.isSelected": (),
    "PySide2.QtWidgets.QTreeWidgetItem.parent": (),
    "PySide2.QtWidgets.QTreeWidgetItem.read": ('PySide2.QtCore.QDataStream',),
    "PySide2.QtWidgets.QTreeWidgetItem.removeChild": ('PySide2.QtWidgets.QTreeWidgetItem',),
    "PySide2.QtWidgets.QTreeWidgetItem.setBackground": ('int', 'PySide2.QtGui.QBrush'),
    "PySide2.QtWidgets.QTreeWidgetItem.setBackgroundColor": ('int', 'PySide2.QtGui.QColor'),
    "PySide2.QtWidgets.QTreeWidgetItem.setCheckState": ('int', 'PySide2.QtCore.Qt.CheckState'),
    "PySide2.QtWidgets.QTreeWidgetItem.setChildIndicatorPolicy": ('PySide2.QtWidgets.QTreeWidgetItem.ChildIndicatorPolicy',),
    "PySide2.QtWidgets.QTreeWidgetItem.setData": ('int', 'int', 'typing.Any'),
    "PySide2.QtWidgets.QTreeWidgetItem.setDisabled": ('bool',),
    "PySide2.QtWidgets.QTreeWidgetItem.setExpanded": ('bool',),
    "PySide2.QtWidgets.QTreeWidgetItem.setFirstColumnSpanned": ('bool',),
    "PySide2.QtWidgets.QTreeWidgetItem.setFlags": ('PySide2.QtCore.Qt.ItemFlags',),
    "PySide2.QtWidgets.QTreeWidgetItem.setFont": ('int', 'PySide2.QtGui.QFont'),
    "PySide2.QtWidgets.QTreeWidgetItem.setForeground": ('int', 'PySide2.QtGui.QBrush'),
    "PySide2.QtWidgets.QTreeWidgetItem.setHidden": ('bool',),
    "PySide2.QtWidgets.QTreeWidgetItem.setIcon": ('int', 'PySide2.QtGui.QIcon'),
    "PySide2.QtWidgets.QTreeWidgetItem.setSelected": ('bool',),
    "PySide2.QtWidgets.QTreeWidgetItem.setSizeHint": ('int', 'PySide2.QtCore.QSize'),
    "PySide2.QtWidgets.QTreeWidgetItem.setStatusTip": ('int', 'str'),
    "PySide2.QtWidgets.QTreeWidgetItem.setText": ('int', 'str'),
    "PySide2.QtWidgets.QTreeWidgetItem.setTextAlignment": ('int', 'int'),
    "PySide2.QtWidgets.QTreeWidgetItem.setTextColor": ('int', 'PySide2.QtGui.QColor'),
    "PySide2.QtWidgets.QTreeWidgetItem.setToolTip": ('int', 'str'),
    "PySide2.QtWidgets.QTreeWidgetItem.setWhatsThis": ('int', 'str'),
    "PySide2.QtWidgets.QTreeWidgetItem.sizeHint": ('int',),
    "PySide2.QtWidgets.QTreeWidgetItem.sortChildren": ('int', 'PySide2.QtCore.Qt.SortOrder'),
    "PySide2.QtWidgets.QTreeWidgetItem.statusTip": ('int',),
    "PySide2.QtWidgets.QTreeWidgetItem.takeChild": ('int',),
    "PySide2.QtWidgets.QTreeWidgetItem.takeChildren": (),
    "PySide2.QtWidgets.QTreeWidgetItem.text": ('int',),
    "PySide2.QtWidgets.QTreeWidgetItem.textAlignment": ('int',),
    "PySide2.QtWidgets.QTreeWidgetItem.textColor": ('int',),
    "PySide2.QtWidgets.QTreeWidgetItem.toolTip": ('int',),
    "PySide2.QtWidgets.QTreeWidgetItem.treeWidget": (),
    "PySide2.QtWidgets.QTreeWidgetItem.type": (),
    "PySide2.QtWidgets.QTreeWidgetItem.whatsThis": ('int',),
    "PySide2.QtWidgets.QTreeWidgetItem.write": ('PySide2.QtCore.QDataStream',),

# class PySide2.QtWidgets.QTreeWidgetItemIterator:

# class PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlag:

# class PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlags:
    "PySide2.QtWidgets.QTreeWidgetItemIterator.__init__": [('PySide2.QtWidgets.QTreeWidget', 'PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlags'), ('PySide2.QtWidgets.QTreeWidgetItem', 'PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlags'), ('PySide2.QtWidgets.QTreeWidgetItemIterator',)],
    "PySide2.QtWidgets.QTreeWidgetItemIterator.__copy__": (),
    "PySide2.QtWidgets.QTreeWidgetItemIterator.__iadd__": ('int',),
    "PySide2.QtWidgets.QTreeWidgetItemIterator.__isub__": ('int',),
    "PySide2.QtWidgets.QTreeWidgetItemIterator.__iter__": (),
    "PySide2.QtWidgets.QTreeWidgetItemIterator.value": (),

# class PySide2.QtWidgets.QUndoCommand:
    "PySide2.QtWidgets.QUndoCommand.__init__": [('PySide2.QtWidgets.QUndoCommand',), ('str', 'PySide2.QtWidgets.QUndoCommand')],
    "PySide2.QtWidgets.QUndoCommand.actionText": (),
    "PySide2.QtWidgets.QUndoCommand.child": ('int',),
    "PySide2.QtWidgets.QUndoCommand.childCount": (),
    "PySide2.QtWidgets.QUndoCommand.id": (),
    "PySide2.QtWidgets.QUndoCommand.isObsolete": (),
    "PySide2.QtWidgets.QUndoCommand.mergeWith": ('PySide2.QtWidgets.QUndoCommand',),
    "PySide2.QtWidgets.QUndoCommand.redo": (),
    "PySide2.QtWidgets.QUndoCommand.setObsolete": ('bool',),
    "PySide2.QtWidgets.QUndoCommand.setText": ('str',),
    "PySide2.QtWidgets.QUndoCommand.text": (),
    "PySide2.QtWidgets.QUndoCommand.undo": (),

# class PySide2.QtWidgets.QUndoGroup:
    "PySide2.QtWidgets.QUndoGroup.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QUndoGroup.activeStack": (),
    "PySide2.QtWidgets.QUndoGroup.addStack": ('PySide2.QtWidgets.QUndoStack',),
    "PySide2.QtWidgets.QUndoGroup.canRedo": (),
    "PySide2.QtWidgets.QUndoGroup.canUndo": (),
    "PySide2.QtWidgets.QUndoGroup.createRedoAction": ('PySide2.QtCore.QObject', 'str'),
    "PySide2.QtWidgets.QUndoGroup.createUndoAction": ('PySide2.QtCore.QObject', 'str'),
    "PySide2.QtWidgets.QUndoGroup.isClean": (),
    "PySide2.QtWidgets.QUndoGroup.redo": (),
    "PySide2.QtWidgets.QUndoGroup.redoText": (),
    "PySide2.QtWidgets.QUndoGroup.removeStack": ('PySide2.QtWidgets.QUndoStack',),
    "PySide2.QtWidgets.QUndoGroup.setActiveStack": ('PySide2.QtWidgets.QUndoStack',),
    "PySide2.QtWidgets.QUndoGroup.stacks": (),
    "PySide2.QtWidgets.QUndoGroup.undo": (),
    "PySide2.QtWidgets.QUndoGroup.undoText": (),

# class PySide2.QtWidgets.QUndoStack:
    "PySide2.QtWidgets.QUndoStack.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QUndoStack.beginMacro": ('str',),
    "PySide2.QtWidgets.QUndoStack.canRedo": (),
    "PySide2.QtWidgets.QUndoStack.canUndo": (),
    "PySide2.QtWidgets.QUndoStack.cleanIndex": (),
    "PySide2.QtWidgets.QUndoStack.clear": (),
    "PySide2.QtWidgets.QUndoStack.command": ('int',),
    "PySide2.QtWidgets.QUndoStack.count": (),
    "PySide2.QtWidgets.QUndoStack.createRedoAction": ('PySide2.QtCore.QObject', 'str'),
    "PySide2.QtWidgets.QUndoStack.createUndoAction": ('PySide2.QtCore.QObject', 'str'),
    "PySide2.QtWidgets.QUndoStack.endMacro": (),
    "PySide2.QtWidgets.QUndoStack.index": (),
    "PySide2.QtWidgets.QUndoStack.isActive": (),
    "PySide2.QtWidgets.QUndoStack.isClean": (),
    "PySide2.QtWidgets.QUndoStack.push": ('PySide2.QtWidgets.QUndoCommand',),
    "PySide2.QtWidgets.QUndoStack.redo": (),
    "PySide2.QtWidgets.QUndoStack.redoText": (),
    "PySide2.QtWidgets.QUndoStack.resetClean": (),
    "PySide2.QtWidgets.QUndoStack.setActive": ('bool',),
    "PySide2.QtWidgets.QUndoStack.setClean": (),
    "PySide2.QtWidgets.QUndoStack.setIndex": ('int',),
    "PySide2.QtWidgets.QUndoStack.setUndoLimit": ('int',),
    "PySide2.QtWidgets.QUndoStack.text": ('int',),
    "PySide2.QtWidgets.QUndoStack.undo": (),
    "PySide2.QtWidgets.QUndoStack.undoLimit": (),
    "PySide2.QtWidgets.QUndoStack.undoText": (),

# class PySide2.QtWidgets.QUndoView:
    "PySide2.QtWidgets.QUndoView.__init__": [('PySide2.QtWidgets.QUndoGroup', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QUndoStack', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtWidgets.QUndoView.cleanIcon": (),
    "PySide2.QtWidgets.QUndoView.emptyLabel": (),
    "PySide2.QtWidgets.QUndoView.group": (),
    "PySide2.QtWidgets.QUndoView.setCleanIcon": ('PySide2.QtGui.QIcon',),
    "PySide2.QtWidgets.QUndoView.setEmptyLabel": ('str',),
    "PySide2.QtWidgets.QUndoView.setGroup": ('PySide2.QtWidgets.QUndoGroup',),
    "PySide2.QtWidgets.QUndoView.setStack": ('PySide2.QtWidgets.QUndoStack',),
    "PySide2.QtWidgets.QUndoView.stack": (),

# class PySide2.QtWidgets.QVBoxLayout:
    "PySide2.QtWidgets.QVBoxLayout.__init__": [(), ('PySide2.QtWidgets.QWidget',)],

# class PySide2.QtWidgets.QWhatsThis:
    "PySide2.QtWidgets.QWhatsThis.createAction": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QWhatsThis.enterWhatsThisMode": (),
    "PySide2.QtWidgets.QWhatsThis.hideText": (),
    "PySide2.QtWidgets.QWhatsThis.inWhatsThisMode": (),
    "PySide2.QtWidgets.QWhatsThis.leaveWhatsThisMode": (),
    "PySide2.QtWidgets.QWhatsThis.showText": ('PySide2.QtCore.QPoint', 'str', 'PySide2.QtWidgets.QWidget'),

# class PySide2.QtWidgets.QWidget:

# class PySide2.QtWidgets.QWidget.RenderFlag:

# class PySide2.QtWidgets.QWidget.RenderFlags:
    "PySide2.QtWidgets.QWidget.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
    "PySide2.QtWidgets.QWidget.acceptDrops": (),
    "PySide2.QtWidgets.QWidget.accessibleDescription": (),
    "PySide2.QtWidgets.QWidget.accessibleName": (),
    "PySide2.QtWidgets.QWidget.actionEvent": ('PySide2.QtGui.QActionEvent',),
    "PySide2.QtWidgets.QWidget.actions": (),
    "PySide2.QtWidgets.QWidget.activateWindow": (),
    "PySide2.QtWidgets.QWidget.addAction": ('PySide2.QtWidgets.QAction',),
    "PySide2.QtWidgets.QWidget.addActions": ('typing.Sequence',),
    "PySide2.QtWidgets.QWidget.adjustSize": (),
    "PySide2.QtWidgets.QWidget.autoFillBackground": (),
    "PySide2.QtWidgets.QWidget.backgroundRole": (),
    "PySide2.QtWidgets.QWidget.backingStore": (),
    "PySide2.QtWidgets.QWidget.baseSize": (),
    "PySide2.QtWidgets.QWidget.changeEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QWidget.childAt": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtWidgets.QWidget.childrenRect": (),
    "PySide2.QtWidgets.QWidget.childrenRegion": (),
    "PySide2.QtWidgets.QWidget.clearFocus": (),
    "PySide2.QtWidgets.QWidget.clearMask": (),
    "PySide2.QtWidgets.QWidget.close": (),
    "PySide2.QtWidgets.QWidget.closeEvent": ('PySide2.QtGui.QCloseEvent',),
    "PySide2.QtWidgets.QWidget.contentsMargins": (),
    "PySide2.QtWidgets.QWidget.contentsRect": (),
    "PySide2.QtWidgets.QWidget.contextMenuEvent": ('PySide2.QtGui.QContextMenuEvent',),
    "PySide2.QtWidgets.QWidget.contextMenuPolicy": (),
    "PySide2.QtWidgets.QWidget.create": ('int', 'bool', 'bool'),
    "PySide2.QtWidgets.QWidget.createWinId": (),
    "PySide2.QtWidgets.QWidget.createWindowContainer": ('PySide2.QtGui.QWindow', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
    "PySide2.QtWidgets.QWidget.cursor": (),
    "PySide2.QtWidgets.QWidget.destroy": ('bool', 'bool'),
    "PySide2.QtWidgets.QWidget.devType": (),
    "PySide2.QtWidgets.QWidget.dragEnterEvent": ('PySide2.QtGui.QDragEnterEvent',),
    "PySide2.QtWidgets.QWidget.dragLeaveEvent": ('PySide2.QtGui.QDragLeaveEvent',),
    "PySide2.QtWidgets.QWidget.dragMoveEvent": ('PySide2.QtGui.QDragMoveEvent',),
    "PySide2.QtWidgets.QWidget.dropEvent": ('PySide2.QtGui.QDropEvent',),
    "PySide2.QtWidgets.QWidget.effectiveWinId": (),
    "PySide2.QtWidgets.QWidget.ensurePolished": (),
    "PySide2.QtWidgets.QWidget.enterEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QWidget.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QWidget.find": ('int',),
    "PySide2.QtWidgets.QWidget.focusInEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QWidget.focusNextChild": (),
    "PySide2.QtWidgets.QWidget.focusNextPrevChild": ('bool',),
    "PySide2.QtWidgets.QWidget.focusOutEvent": ('PySide2.QtGui.QFocusEvent',),
    "PySide2.QtWidgets.QWidget.focusPolicy": (),
    "PySide2.QtWidgets.QWidget.focusPreviousChild": (),
    "PySide2.QtWidgets.QWidget.focusProxy": (),
    "PySide2.QtWidgets.QWidget.focusWidget": (),
    "PySide2.QtWidgets.QWidget.font": (),
    "PySide2.QtWidgets.QWidget.fontInfo": (),
    "PySide2.QtWidgets.QWidget.fontMetrics": (),
    "PySide2.QtWidgets.QWidget.foregroundRole": (),
    "PySide2.QtWidgets.QWidget.frameGeometry": (),
    "PySide2.QtWidgets.QWidget.frameSize": (),
    "PySide2.QtWidgets.QWidget.geometry": (),
    "PySide2.QtWidgets.QWidget.getContentsMargins": (),
    "PySide2.QtWidgets.QWidget.grab": ('PySide2.QtCore.QRect',),
    "PySide2.QtWidgets.QWidget.grabGesture": ('PySide2.QtCore.Qt.GestureType', 'PySide2.QtCore.Qt.GestureFlags'),
    "PySide2.QtWidgets.QWidget.grabKeyboard": (),
    "PySide2.QtWidgets.QWidget.grabMouse": [(), ('PySide2.QtGui.QCursor',)],
    "PySide2.QtWidgets.QWidget.grabShortcut": ('PySide2.QtGui.QKeySequence', 'PySide2.QtCore.Qt.ShortcutContext'),
    "PySide2.QtWidgets.QWidget.graphicsEffect": (),
    "PySide2.QtWidgets.QWidget.graphicsProxyWidget": (),
    "PySide2.QtWidgets.QWidget.hasFocus": (),
    "PySide2.QtWidgets.QWidget.hasHeightForWidth": (),
    "PySide2.QtWidgets.QWidget.hasMouseTracking": (),
    "PySide2.QtWidgets.QWidget.hasTabletTracking": (),
    "PySide2.QtWidgets.QWidget.height": (),
    "PySide2.QtWidgets.QWidget.heightForWidth": ('int',),
    "PySide2.QtWidgets.QWidget.hide": (),
    "PySide2.QtWidgets.QWidget.hideEvent": ('PySide2.QtGui.QHideEvent',),
    "PySide2.QtWidgets.QWidget.initPainter": ('PySide2.QtGui.QPainter',),
    "PySide2.QtWidgets.QWidget.inputMethodEvent": ('PySide2.QtGui.QInputMethodEvent',),
    "PySide2.QtWidgets.QWidget.inputMethodHints": (),
    "PySide2.QtWidgets.QWidget.inputMethodQuery": ('PySide2.QtCore.Qt.InputMethodQuery',),
    "PySide2.QtWidgets.QWidget.insertAction": ('PySide2.QtWidgets.QAction', 'PySide2.QtWidgets.QAction'),
    "PySide2.QtWidgets.QWidget.insertActions": ('PySide2.QtWidgets.QAction', 'typing.Sequence'),
    "PySide2.QtWidgets.QWidget.internalWinId": (),
    "PySide2.QtWidgets.QWidget.isActiveWindow": (),
    "PySide2.QtWidgets.QWidget.isAncestorOf": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QWidget.isEnabled": (),
    "PySide2.QtWidgets.QWidget.isEnabledTo": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QWidget.isEnabledToTLW": (),
    "PySide2.QtWidgets.QWidget.isFullScreen": (),
    "PySide2.QtWidgets.QWidget.isHidden": (),
    "PySide2.QtWidgets.QWidget.isLeftToRight": (),
    "PySide2.QtWidgets.QWidget.isMaximized": (),
    "PySide2.QtWidgets.QWidget.isMinimized": (),
    "PySide2.QtWidgets.QWidget.isModal": (),
    "PySide2.QtWidgets.QWidget.isRightToLeft": (),
    "PySide2.QtWidgets.QWidget.isTopLevel": (),
    "PySide2.QtWidgets.QWidget.isVisible": (),
    "PySide2.QtWidgets.QWidget.isVisibleTo": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QWidget.isWindow": (),
    "PySide2.QtWidgets.QWidget.isWindowModified": (),
    "PySide2.QtWidgets.QWidget.keyPressEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QWidget.keyReleaseEvent": ('PySide2.QtGui.QKeyEvent',),
    "PySide2.QtWidgets.QWidget.keyboardGrabber": (),
    "PySide2.QtWidgets.QWidget.layout": (),
    "PySide2.QtWidgets.QWidget.layoutDirection": (),
    "PySide2.QtWidgets.QWidget.leaveEvent": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QWidget.locale": (),
    "PySide2.QtWidgets.QWidget.lower": (),
    "PySide2.QtWidgets.QWidget.mapFrom": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QPoint'),
    "PySide2.QtWidgets.QWidget.mapFromGlobal": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QWidget.mapFromParent": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QWidget.mapTo": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QPoint'),
    "PySide2.QtWidgets.QWidget.mapToGlobal": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QWidget.mapToParent": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QWidget.mask": (),
    "PySide2.QtWidgets.QWidget.maximumHeight": (),
    "PySide2.QtWidgets.QWidget.maximumSize": (),
    "PySide2.QtWidgets.QWidget.maximumWidth": (),
    "PySide2.QtWidgets.QWidget.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
    "PySide2.QtWidgets.QWidget.minimumHeight": (),
    "PySide2.QtWidgets.QWidget.minimumSize": (),
    "PySide2.QtWidgets.QWidget.minimumSizeHint": (),
    "PySide2.QtWidgets.QWidget.minimumWidth": (),
    "PySide2.QtWidgets.QWidget.mouseDoubleClickEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QWidget.mouseGrabber": (),
    "PySide2.QtWidgets.QWidget.mouseMoveEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QWidget.mousePressEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QWidget.mouseReleaseEvent": ('PySide2.QtGui.QMouseEvent',),
    "PySide2.QtWidgets.QWidget.move": [('PySide2.QtCore.QPoint',), ('int', 'int')],
    "PySide2.QtWidgets.QWidget.moveEvent": ('PySide2.QtGui.QMoveEvent',),
    "PySide2.QtWidgets.QWidget.nativeEvent": ('PySide2.QtCore.QByteArray', 'int'),
    "PySide2.QtWidgets.QWidget.nativeParentWidget": (),
    "PySide2.QtWidgets.QWidget.nextInFocusChain": (),
    "PySide2.QtWidgets.QWidget.normalGeometry": (),
    "PySide2.QtWidgets.QWidget.overrideWindowFlags": ('PySide2.QtCore.Qt.WindowFlags',),
    "PySide2.QtWidgets.QWidget.overrideWindowState": ('PySide2.QtCore.Qt.WindowStates',),
    "PySide2.QtWidgets.QWidget.paintEngine": (),
    "PySide2.QtWidgets.QWidget.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QWidget.palette": (),
    "PySide2.QtWidgets.QWidget.parentWidget": (),
    "PySide2.QtWidgets.QWidget.pos": (),
    "PySide2.QtWidgets.QWidget.previousInFocusChain": (),
    "PySide2.QtWidgets.QWidget.raise_": (),
    "PySide2.QtWidgets.QWidget.rect": (),
    "PySide2.QtWidgets.QWidget.redirected": ('PySide2.QtCore.QPoint',),
    "PySide2.QtWidgets.QWidget.releaseKeyboard": (),
    "PySide2.QtWidgets.QWidget.releaseMouse": (),
    "PySide2.QtWidgets.QWidget.releaseShortcut": ('int',),
    "PySide2.QtWidgets.QWidget.removeAction": ('PySide2.QtWidgets.QAction',),
    "PySide2.QtWidgets.QWidget.render": [('PySide2.QtGui.QPaintDevice', 'PySide2.QtCore.QPoint', 'PySide2.QtGui.QRegion', 'PySide2.QtWidgets.QWidget.RenderFlags'), ('PySide2.QtGui.QPainter', 'PySide2.QtCore.QPoint', 'PySide2.QtGui.QRegion', 'PySide2.QtWidgets.QWidget.RenderFlags')],
    "PySide2.QtWidgets.QWidget.repaint": [(), ('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',), ('int', 'int', 'int', 'int')],
    "PySide2.QtWidgets.QWidget.resize": [('PySide2.QtCore.QSize',), ('int', 'int')],
    "PySide2.QtWidgets.QWidget.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QWidget.restoreGeometry": ('PySide2.QtCore.QByteArray',),
    "PySide2.QtWidgets.QWidget.saveGeometry": (),
    "PySide2.QtWidgets.QWidget.screen": (),
    "PySide2.QtWidgets.QWidget.scroll": [('int', 'int'), ('int', 'int', 'PySide2.QtCore.QRect')],
    "PySide2.QtWidgets.QWidget.setAcceptDrops": ('bool',),
    "PySide2.QtWidgets.QWidget.setAccessibleDescription": ('str',),
    "PySide2.QtWidgets.QWidget.setAccessibleName": ('str',),
    "PySide2.QtWidgets.QWidget.setAttribute": ('PySide2.QtCore.Qt.WidgetAttribute', 'bool'),
    "PySide2.QtWidgets.QWidget.setAutoFillBackground": ('bool',),
    "PySide2.QtWidgets.QWidget.setBackgroundRole": ('PySide2.QtGui.QPalette.ColorRole',),
    "PySide2.QtWidgets.QWidget.setBaseSize": [('PySide2.QtCore.QSize',), ('int', 'int')],
    "PySide2.QtWidgets.QWidget.setContentsMargins": [('PySide2.QtCore.QMargins',), ('int', 'int', 'int', 'int')],
    "PySide2.QtWidgets.QWidget.setContextMenuPolicy": ('PySide2.QtCore.Qt.ContextMenuPolicy',),
    "PySide2.QtWidgets.QWidget.setCursor": ('PySide2.QtGui.QCursor',),
    "PySide2.QtWidgets.QWidget.setDisabled": ('bool',),
    "PySide2.QtWidgets.QWidget.setEnabled": ('bool',),
    "PySide2.QtWidgets.QWidget.setFixedHeight": ('int',),
    "PySide2.QtWidgets.QWidget.setFixedSize": [('PySide2.QtCore.QSize',), ('int', 'int')],
    "PySide2.QtWidgets.QWidget.setFixedWidth": ('int',),
    "PySide2.QtWidgets.QWidget.setFocus": [(), ('PySide2.QtCore.Qt.FocusReason',)],
    "PySide2.QtWidgets.QWidget.setFocusPolicy": ('PySide2.QtCore.Qt.FocusPolicy',),
    "PySide2.QtWidgets.QWidget.setFocusProxy": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QWidget.setFont": ('PySide2.QtGui.QFont',),
    "PySide2.QtWidgets.QWidget.setForegroundRole": ('PySide2.QtGui.QPalette.ColorRole',),
    "PySide2.QtWidgets.QWidget.setGeometry": [('PySide2.QtCore.QRect',), ('int', 'int', 'int', 'int')],
    "PySide2.QtWidgets.QWidget.setGraphicsEffect": ('PySide2.QtWidgets.QGraphicsEffect',),
    "PySide2.QtWidgets.QWidget.setHidden": ('bool',),
    "PySide2.QtWidgets.QWidget.setInputMethodHints": ('PySide2.QtCore.Qt.InputMethodHints',),
    "PySide2.QtWidgets.QWidget.setLayout": ('PySide2.QtWidgets.QLayout',),
    "PySide2.QtWidgets.QWidget.setLayoutDirection": ('PySide2.QtCore.Qt.LayoutDirection',),
    "PySide2.QtWidgets.QWidget.setLocale": ('PySide2.QtCore.QLocale',),
    "PySide2.QtWidgets.QWidget.setMask": [('PySide2.QtGui.QBitmap',), ('PySide2.QtGui.QRegion',)],
    "PySide2.QtWidgets.QWidget.setMaximumHeight": ('int',),
    "PySide2.QtWidgets.QWidget.setMaximumSize": [('PySide2.QtCore.QSize',), ('int', 'int')],
    "PySide2.QtWidgets.QWidget.setMaximumWidth": ('int',),
    "PySide2.QtWidgets.QWidget.setMinimumHeight": ('int',),
    "PySide2.QtWidgets.QWidget.setMinimumSize": [('PySide2.QtCore.QSize',), ('int', 'int')],
    "PySide2.QtWidgets.QWidget.setMinimumWidth": ('int',),
    "PySide2.QtWidgets.QWidget.setMouseTracking": ('bool',),
    "PySide2.QtWidgets.QWidget.setPalette": ('PySide2.QtGui.QPalette',),
    "PySide2.QtWidgets.QWidget.setParent": [('PySide2.QtWidgets.QWidget',), ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags')],
    "PySide2.QtWidgets.QWidget.setShortcutAutoRepeat": ('int', 'bool'),
    "PySide2.QtWidgets.QWidget.setShortcutEnabled": ('int', 'bool'),
    "PySide2.QtWidgets.QWidget.setSizeIncrement": [('PySide2.QtCore.QSize',), ('int', 'int')],
    "PySide2.QtWidgets.QWidget.setSizePolicy": [('PySide2.QtWidgets.QSizePolicy',), ('PySide2.QtWidgets.QSizePolicy.Policy', 'PySide2.QtWidgets.QSizePolicy.Policy')],
    "PySide2.QtWidgets.QWidget.setStatusTip": ('str',),
    "PySide2.QtWidgets.QWidget.setStyle": ('PySide2.QtWidgets.QStyle',),
    "PySide2.QtWidgets.QWidget.setStyleSheet": ('str',),
    "PySide2.QtWidgets.QWidget.setTabOrder": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtWidgets.QWidget.setTabletTracking": ('bool',),
    "PySide2.QtWidgets.QWidget.setToolTip": ('str',),
    "PySide2.QtWidgets.QWidget.setToolTipDuration": ('int',),
    "PySide2.QtWidgets.QWidget.setUpdatesEnabled": ('bool',),
    "PySide2.QtWidgets.QWidget.setVisible": ('bool',),
    "PySide2.QtWidgets.QWidget.setWhatsThis": ('str',),
    "PySide2.QtWidgets.QWidget.setWindowFilePath": ('str',),
    "PySide2.QtWidgets.QWidget.setWindowFlag": ('PySide2.QtCore.Qt.WindowType', 'bool'),
    "PySide2.QtWidgets.QWidget.setWindowFlags": ('PySide2.QtCore.Qt.WindowFlags',),
    "PySide2.QtWidgets.QWidget.setWindowIcon": ('PySide2.QtGui.QIcon',),
    "PySide2.QtWidgets.QWidget.setWindowIconText": ('str',),
    "PySide2.QtWidgets.QWidget.setWindowModality": ('PySide2.QtCore.Qt.WindowModality',),
    "PySide2.QtWidgets.QWidget.setWindowModified": ('bool',),
    "PySide2.QtWidgets.QWidget.setWindowOpacity": ('float',),
    "PySide2.QtWidgets.QWidget.setWindowRole": ('str',),
    "PySide2.QtWidgets.QWidget.setWindowState": ('PySide2.QtCore.Qt.WindowStates',),
    "PySide2.QtWidgets.QWidget.setWindowTitle": ('str',),
    "PySide2.QtWidgets.QWidget.sharedPainter": (),
    "PySide2.QtWidgets.QWidget.show": (),
    "PySide2.QtWidgets.QWidget.showEvent": ('PySide2.QtGui.QShowEvent',),
    "PySide2.QtWidgets.QWidget.showFullScreen": (),
    "PySide2.QtWidgets.QWidget.showMaximized": (),
    "PySide2.QtWidgets.QWidget.showMinimized": (),
    "PySide2.QtWidgets.QWidget.showNormal": (),
    "PySide2.QtWidgets.QWidget.size": (),
    "PySide2.QtWidgets.QWidget.sizeHint": (),
    "PySide2.QtWidgets.QWidget.sizeIncrement": (),
    "PySide2.QtWidgets.QWidget.sizePolicy": (),
    "PySide2.QtWidgets.QWidget.stackUnder": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QWidget.statusTip": (),
    "PySide2.QtWidgets.QWidget.style": (),
    "PySide2.QtWidgets.QWidget.styleSheet": (),
    "PySide2.QtWidgets.QWidget.tabletEvent": ('PySide2.QtGui.QTabletEvent',),
    "PySide2.QtWidgets.QWidget.testAttribute": ('PySide2.QtCore.Qt.WidgetAttribute',),
    "PySide2.QtWidgets.QWidget.toolTip": (),
    "PySide2.QtWidgets.QWidget.toolTipDuration": (),
    "PySide2.QtWidgets.QWidget.topLevelWidget": (),
    "PySide2.QtWidgets.QWidget.underMouse": (),
    "PySide2.QtWidgets.QWidget.ungrabGesture": ('PySide2.QtCore.Qt.GestureType',),
    "PySide2.QtWidgets.QWidget.unsetCursor": (),
    "PySide2.QtWidgets.QWidget.unsetLayoutDirection": (),
    "PySide2.QtWidgets.QWidget.unsetLocale": (),
    "PySide2.QtWidgets.QWidget.update": [(), ('PySide2.QtCore.QRect',), ('PySide2.QtGui.QRegion',), ('int', 'int', 'int', 'int')],
    "PySide2.QtWidgets.QWidget.updateGeometry": (),
    "PySide2.QtWidgets.QWidget.updateMicroFocus": (),
    "PySide2.QtWidgets.QWidget.updatesEnabled": (),
    "PySide2.QtWidgets.QWidget.visibleRegion": (),
    "PySide2.QtWidgets.QWidget.whatsThis": (),
    "PySide2.QtWidgets.QWidget.wheelEvent": ('PySide2.QtGui.QWheelEvent',),
    "PySide2.QtWidgets.QWidget.width": (),
    "PySide2.QtWidgets.QWidget.winId": (),
    "PySide2.QtWidgets.QWidget.window": (),
    "PySide2.QtWidgets.QWidget.windowFilePath": (),
    "PySide2.QtWidgets.QWidget.windowFlags": (),
    "PySide2.QtWidgets.QWidget.windowHandle": (),
    "PySide2.QtWidgets.QWidget.windowIcon": (),
    "PySide2.QtWidgets.QWidget.windowIconText": (),
    "PySide2.QtWidgets.QWidget.windowModality": (),
    "PySide2.QtWidgets.QWidget.windowOpacity": (),
    "PySide2.QtWidgets.QWidget.windowRole": (),
    "PySide2.QtWidgets.QWidget.windowState": (),
    "PySide2.QtWidgets.QWidget.windowTitle": (),
    "PySide2.QtWidgets.QWidget.windowType": (),
    "PySide2.QtWidgets.QWidget.x": (),
    "PySide2.QtWidgets.QWidget.y": (),

# class PySide2.QtWidgets.QWidgetAction:
    "PySide2.QtWidgets.QWidgetAction.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtWidgets.QWidgetAction.createWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QWidgetAction.createdWidgets": (),
    "PySide2.QtWidgets.QWidgetAction.defaultWidget": (),
    "PySide2.QtWidgets.QWidgetAction.deleteWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QWidgetAction.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QWidgetAction.eventFilter": ('PySide2.QtCore.QObject', 'PySide2.QtCore.QEvent'),
    "PySide2.QtWidgets.QWidgetAction.releaseWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QWidgetAction.requestWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QWidgetAction.setDefaultWidget": ('PySide2.QtWidgets.QWidget',),

# class PySide2.QtWidgets.QWidgetItem:
    "PySide2.QtWidgets.QWidgetItem.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QWidgetItem.controlTypes": (),
    "PySide2.QtWidgets.QWidgetItem.expandingDirections": (),
    "PySide2.QtWidgets.QWidgetItem.geometry": (),
    "PySide2.QtWidgets.QWidgetItem.hasHeightForWidth": (),
    "PySide2.QtWidgets.QWidgetItem.heightForWidth": ('int',),
    "PySide2.QtWidgets.QWidgetItem.isEmpty": (),
    "PySide2.QtWidgets.QWidgetItem.maximumSize": (),
    "PySide2.QtWidgets.QWidgetItem.minimumSize": (),
    "PySide2.QtWidgets.QWidgetItem.setGeometry": ('PySide2.QtCore.QRect',),
    "PySide2.QtWidgets.QWidgetItem.sizeHint": (),
    "PySide2.QtWidgets.QWidgetItem.widget": (),

# class PySide2.QtWidgets.QWizard:

# class PySide2.QtWidgets.QWizard.WizardButton:

# class PySide2.QtWidgets.QWizard.WizardOption:

# class PySide2.QtWidgets.QWizard.WizardOptions:

# class PySide2.QtWidgets.QWizard.WizardPixmap:

# class PySide2.QtWidgets.QWizard.WizardStyle:
    "PySide2.QtWidgets.QWizard.__init__": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'),
    "PySide2.QtWidgets.QWizard.addPage": ('PySide2.QtWidgets.QWizardPage',),
    "PySide2.QtWidgets.QWizard.back": (),
    "PySide2.QtWidgets.QWizard.button": ('PySide2.QtWidgets.QWizard.WizardButton',),
    "PySide2.QtWidgets.QWizard.buttonText": ('PySide2.QtWidgets.QWizard.WizardButton',),
    "PySide2.QtWidgets.QWizard.cleanupPage": ('int',),
    "PySide2.QtWidgets.QWizard.currentId": (),
    "PySide2.QtWidgets.QWizard.currentPage": (),
    "PySide2.QtWidgets.QWizard.done": ('int',),
    "PySide2.QtWidgets.QWizard.event": ('PySide2.QtCore.QEvent',),
    "PySide2.QtWidgets.QWizard.field": ('str',),
    "PySide2.QtWidgets.QWizard.hasVisitedPage": ('int',),
    "PySide2.QtWidgets.QWizard.initializePage": ('int',),
    "PySide2.QtWidgets.QWizard.nativeEvent": ('PySide2.QtCore.QByteArray', 'int'),
    "PySide2.QtWidgets.QWizard.nextId": (),
    "PySide2.QtWidgets.QWizard.options": (),
    "PySide2.QtWidgets.QWizard.page": ('int',),
    "PySide2.QtWidgets.QWizard.pageIds": (),
    "PySide2.QtWidgets.QWizard.paintEvent": ('PySide2.QtGui.QPaintEvent',),
    "PySide2.QtWidgets.QWizard.pixmap": ('PySide2.QtWidgets.QWizard.WizardPixmap',),
    "PySide2.QtWidgets.QWizard.removePage": ('int',),
    "PySide2.QtWidgets.QWizard.resizeEvent": ('PySide2.QtGui.QResizeEvent',),
    "PySide2.QtWidgets.QWizard.restart": (),
    "PySide2.QtWidgets.QWizard.setButton": ('PySide2.QtWidgets.QWizard.WizardButton', 'PySide2.QtWidgets.QAbstractButton'),
    "PySide2.QtWidgets.QWizard.setButtonLayout": ('typing.Sequence',),
    "PySide2.QtWidgets.QWizard.setButtonText": ('PySide2.QtWidgets.QWizard.WizardButton', 'str'),
    "PySide2.QtWidgets.QWizard.setDefaultProperty": ('bytes', 'bytes', 'bytes'),
    "PySide2.QtWidgets.QWizard.setField": ('str', 'typing.Any'),
    "PySide2.QtWidgets.QWizard.setOption": ('PySide2.QtWidgets.QWizard.WizardOption', 'bool'),
    "PySide2.QtWidgets.QWizard.setOptions": ('PySide2.QtWidgets.QWizard.WizardOptions',),
    "PySide2.QtWidgets.QWizard.setPage": ('int', 'PySide2.QtWidgets.QWizardPage'),
    "PySide2.QtWidgets.QWizard.setPixmap": ('PySide2.QtWidgets.QWizard.WizardPixmap', 'PySide2.QtGui.QPixmap'),
    "PySide2.QtWidgets.QWizard.setSideWidget": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QWizard.setStartId": ('int',),
    "PySide2.QtWidgets.QWizard.setSubTitleFormat": ('PySide2.QtCore.Qt.TextFormat',),
    "PySide2.QtWidgets.QWizard.setTitleFormat": ('PySide2.QtCore.Qt.TextFormat',),
    "PySide2.QtWidgets.QWizard.setVisible": ('bool',),
    "PySide2.QtWidgets.QWizard.setWizardStyle": ('PySide2.QtWidgets.QWizard.WizardStyle',),
    "PySide2.QtWidgets.QWizard.sideWidget": (),
    "PySide2.QtWidgets.QWizard.sizeHint": (),
    "PySide2.QtWidgets.QWizard.startId": (),
    "PySide2.QtWidgets.QWizard.subTitleFormat": (),
    "PySide2.QtWidgets.QWizard.testOption": ('PySide2.QtWidgets.QWizard.WizardOption',),
    "PySide2.QtWidgets.QWizard.titleFormat": (),
    "PySide2.QtWidgets.QWizard.validateCurrentPage": (),
    "PySide2.QtWidgets.QWizard.visitedPages": (),
    "PySide2.QtWidgets.QWizard.wizardStyle": (),

# class PySide2.QtWidgets.QWizardPage:
    "PySide2.QtWidgets.QWizardPage.__init__": ('PySide2.QtWidgets.QWidget',),
    "PySide2.QtWidgets.QWizardPage.buttonText": ('PySide2.QtWidgets.QWizard.WizardButton',),
    "PySide2.QtWidgets.QWizardPage.cleanupPage": (),
    "PySide2.QtWidgets.QWizardPage.field": ('str',),
    "PySide2.QtWidgets.QWizardPage.initializePage": (),
    "PySide2.QtWidgets.QWizardPage.isCommitPage": (),
    "PySide2.QtWidgets.QWizardPage.isComplete": (),
    "PySide2.QtWidgets.QWizardPage.isFinalPage": (),
    "PySide2.QtWidgets.QWizardPage.nextId": (),
    "PySide2.QtWidgets.QWizardPage.pixmap": ('PySide2.QtWidgets.QWizard.WizardPixmap',),
    "PySide2.QtWidgets.QWizardPage.registerField": ('str', 'PySide2.QtWidgets.QWidget', 'bytes', 'bytes'),
    "PySide2.QtWidgets.QWizardPage.setButtonText": ('PySide2.QtWidgets.QWizard.WizardButton', 'str'),
    "PySide2.QtWidgets.QWizardPage.setCommitPage": ('bool',),
    "PySide2.QtWidgets.QWizardPage.setField": ('str', 'typing.Any'),
    "PySide2.QtWidgets.QWizardPage.setFinalPage": ('bool',),
    "PySide2.QtWidgets.QWizardPage.setPixmap": ('PySide2.QtWidgets.QWizard.WizardPixmap', 'PySide2.QtGui.QPixmap'),
    "PySide2.QtWidgets.QWizardPage.setSubTitle": ('str',),
    "PySide2.QtWidgets.QWizardPage.setTitle": ('str',),
    "PySide2.QtWidgets.QWizardPage.subTitle": (),
    "PySide2.QtWidgets.QWizardPage.title": (),
    "PySide2.QtWidgets.QWizardPage.validatePage": (),
    "PySide2.QtWidgets.QWizardPage.wizard": (),
    }) if "PySide2.QtWidgets" in sys.modules else None

# Module PySide2.QtPrintSupport
sig_dict.update({

# class PySide2.QtPrintSupport.QAbstractPrintDialog:

# class PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption:

# class PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOptions:

# class PySide2.QtPrintSupport.QAbstractPrintDialog.PrintRange:
    "PySide2.QtPrintSupport.QAbstractPrintDialog.__init__": ('PySide2.QtPrintSupport.QPrinter', 'PySide2.QtWidgets.QWidget'),
    "PySide2.QtPrintSupport.QAbstractPrintDialog.addEnabledOption": ('PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption',),
    "PySide2.QtPrintSupport.QAbstractPrintDialog.enabledOptions": (),
    "PySide2.QtPrintSupport.QAbstractPrintDialog.fromPage": (),
    "PySide2.QtPrintSupport.QAbstractPrintDialog.isOptionEnabled": ('PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption',),
    "PySide2.QtPrintSupport.QAbstractPrintDialog.maxPage": (),
    "PySide2.QtPrintSupport.QAbstractPrintDialog.minPage": (),
    "PySide2.QtPrintSupport.QAbstractPrintDialog.printRange": (),
    "PySide2.QtPrintSupport.QAbstractPrintDialog.printer": (),
    "PySide2.QtPrintSupport.QAbstractPrintDialog.setEnabledOptions": ('PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOptions',),
    "PySide2.QtPrintSupport.QAbstractPrintDialog.setFromTo": ('int', 'int'),
    "PySide2.QtPrintSupport.QAbstractPrintDialog.setMinMax": ('int', 'int'),
    "PySide2.QtPrintSupport.QAbstractPrintDialog.setOptionTabs": ('typing.Sequence',),
    "PySide2.QtPrintSupport.QAbstractPrintDialog.setPrintRange": ('PySide2.QtPrintSupport.QAbstractPrintDialog.PrintRange',),
    "PySide2.QtPrintSupport.QAbstractPrintDialog.toPage": (),

# class PySide2.QtPrintSupport.QPageSetupDialog:
    "PySide2.QtPrintSupport.QPageSetupDialog.__init__": [('PySide2.QtPrintSupport.QPrinter', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtPrintSupport.QPageSetupDialog.done": ('int',),
    "PySide2.QtPrintSupport.QPageSetupDialog.exec_": (),
    "PySide2.QtPrintSupport.QPageSetupDialog.open": [(), ('PySide2.QtCore.QObject', 'bytes')],
    "PySide2.QtPrintSupport.QPageSetupDialog.printer": (),
    "PySide2.QtPrintSupport.QPageSetupDialog.setVisible": ('bool',),

# class PySide2.QtPrintSupport.QPrintDialog:
    "PySide2.QtPrintSupport.QPrintDialog.__init__": [('PySide2.QtPrintSupport.QPrinter', 'PySide2.QtWidgets.QWidget'), ('PySide2.QtWidgets.QWidget',)],
    "PySide2.QtPrintSupport.QPrintDialog.done": ('int',),
    "PySide2.QtPrintSupport.QPrintDialog.exec_": (),
    "PySide2.QtPrintSupport.QPrintDialog.open": [(), ('PySide2.QtCore.QObject', 'bytes')],
    "PySide2.QtPrintSupport.QPrintDialog.options": (),
    "PySide2.QtPrintSupport.QPrintDialog.setOption": ('PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption', 'bool'),
    "PySide2.QtPrintSupport.QPrintDialog.setOptions": ('PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOptions',),
    "PySide2.QtPrintSupport.QPrintDialog.setVisible": ('bool',),
    "PySide2.QtPrintSupport.QPrintDialog.testOption": ('PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption',),

# class PySide2.QtPrintSupport.QPrintEngine:

# class PySide2.QtPrintSupport.QPrintEngine.PrintEnginePropertyKey:
    "PySide2.QtPrintSupport.QPrintEngine.__init__": (),
    "PySide2.QtPrintSupport.QPrintEngine.abort": (),
    "PySide2.QtPrintSupport.QPrintEngine.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
    "PySide2.QtPrintSupport.QPrintEngine.newPage": (),
    "PySide2.QtPrintSupport.QPrintEngine.printerState": (),
    "PySide2.QtPrintSupport.QPrintEngine.property": ('PySide2.QtPrintSupport.QPrintEngine.PrintEnginePropertyKey',),
    "PySide2.QtPrintSupport.QPrintEngine.setProperty": ('PySide2.QtPrintSupport.QPrintEngine.PrintEnginePropertyKey', 'typing.Any'),

# class PySide2.QtPrintSupport.QPrintPreviewDialog:
    "PySide2.QtPrintSupport.QPrintPreviewDialog.__init__": [('PySide2.QtPrintSupport.QPrinter', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags')],
    "PySide2.QtPrintSupport.QPrintPreviewDialog.done": ('int',),
    "PySide2.QtPrintSupport.QPrintPreviewDialog.open": [(), ('PySide2.QtCore.QObject', 'bytes')],
    "PySide2.QtPrintSupport.QPrintPreviewDialog.printer": (),
    "PySide2.QtPrintSupport.QPrintPreviewDialog.setVisible": ('bool',),

# class PySide2.QtPrintSupport.QPrintPreviewWidget:

# class PySide2.QtPrintSupport.QPrintPreviewWidget.ViewMode:

# class PySide2.QtPrintSupport.QPrintPreviewWidget.ZoomMode:
    "PySide2.QtPrintSupport.QPrintPreviewWidget.__init__": [('PySide2.QtPrintSupport.QPrinter', 'PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags'), ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.Qt.WindowFlags')],
    "PySide2.QtPrintSupport.QPrintPreviewWidget.currentPage": (),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.fitInView": (),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.fitToWidth": (),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.orientation": (),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.pageCount": (),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.print_": (),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.setAllPagesViewMode": (),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.setCurrentPage": ('int',),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.setFacingPagesViewMode": (),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.setLandscapeOrientation": (),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.setOrientation": ('PySide2.QtPrintSupport.QPrinter.Orientation',),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.setPortraitOrientation": (),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.setSinglePageViewMode": (),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.setViewMode": ('PySide2.QtPrintSupport.QPrintPreviewWidget.ViewMode',),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.setVisible": ('bool',),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.setZoomFactor": ('float',),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.setZoomMode": ('PySide2.QtPrintSupport.QPrintPreviewWidget.ZoomMode',),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.updatePreview": (),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.viewMode": (),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.zoomFactor": (),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.zoomIn": ('float',),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.zoomMode": (),
    "PySide2.QtPrintSupport.QPrintPreviewWidget.zoomOut": ('float',),

# class PySide2.QtPrintSupport.QPrinter:

# class PySide2.QtPrintSupport.QPrinter.ColorMode:

# class PySide2.QtPrintSupport.QPrinter.DuplexMode:

# class PySide2.QtPrintSupport.QPrinter.Orientation:

# class PySide2.QtPrintSupport.QPrinter.OutputFormat:

# class PySide2.QtPrintSupport.QPrinter.PageOrder:

# class PySide2.QtPrintSupport.QPrinter.PaperSource:

# class PySide2.QtPrintSupport.QPrinter.PrintRange:

# class PySide2.QtPrintSupport.QPrinter.PrinterMode:

# class PySide2.QtPrintSupport.QPrinter.PrinterState:

# class PySide2.QtPrintSupport.QPrinter.Unit:
    "PySide2.QtPrintSupport.QPrinter.__init__": [('PySide2.QtPrintSupport.QPrinter.PrinterMode',), ('PySide2.QtPrintSupport.QPrinterInfo', 'PySide2.QtPrintSupport.QPrinter.PrinterMode')],
    "PySide2.QtPrintSupport.QPrinter.abort": (),
    "PySide2.QtPrintSupport.QPrinter.actualNumCopies": (),
    "PySide2.QtPrintSupport.QPrinter.collateCopies": (),
    "PySide2.QtPrintSupport.QPrinter.colorMode": (),
    "PySide2.QtPrintSupport.QPrinter.copyCount": (),
    "PySide2.QtPrintSupport.QPrinter.creator": (),
    "PySide2.QtPrintSupport.QPrinter.devType": (),
    "PySide2.QtPrintSupport.QPrinter.docName": (),
    "PySide2.QtPrintSupport.QPrinter.doubleSidedPrinting": (),
    "PySide2.QtPrintSupport.QPrinter.duplex": (),
    "PySide2.QtPrintSupport.QPrinter.fontEmbeddingEnabled": (),
    "PySide2.QtPrintSupport.QPrinter.fromPage": (),
    "PySide2.QtPrintSupport.QPrinter.fullPage": (),
    "PySide2.QtPrintSupport.QPrinter.getPageMargins": ('PySide2.QtPrintSupport.QPrinter.Unit',),
    "PySide2.QtPrintSupport.QPrinter.isValid": (),
    "PySide2.QtPrintSupport.QPrinter.metric": ('PySide2.QtGui.QPaintDevice.PaintDeviceMetric',),
    "PySide2.QtPrintSupport.QPrinter.newPage": (),
    "PySide2.QtPrintSupport.QPrinter.numCopies": (),
    "PySide2.QtPrintSupport.QPrinter.orientation": (),
    "PySide2.QtPrintSupport.QPrinter.outputFileName": (),
    "PySide2.QtPrintSupport.QPrinter.outputFormat": (),
    "PySide2.QtPrintSupport.QPrinter.pageOrder": (),
    "PySide2.QtPrintSupport.QPrinter.pageRect": [(), ('PySide2.QtPrintSupport.QPrinter.Unit',)],
    "PySide2.QtPrintSupport.QPrinter.pageSize": (),
    "PySide2.QtPrintSupport.QPrinter.paintEngine": (),
    "PySide2.QtPrintSupport.QPrinter.paperName": (),
    "PySide2.QtPrintSupport.QPrinter.paperRect": [(), ('PySide2.QtPrintSupport.QPrinter.Unit',)],
    "PySide2.QtPrintSupport.QPrinter.paperSize": [(), ('PySide2.QtPrintSupport.QPrinter.Unit',)],
    "PySide2.QtPrintSupport.QPrinter.paperSource": (),
    "PySide2.QtPrintSupport.QPrinter.pdfVersion": (),
    "PySide2.QtPrintSupport.QPrinter.printEngine": (),
    "PySide2.QtPrintSupport.QPrinter.printProgram": (),
    "PySide2.QtPrintSupport.QPrinter.printRange": (),
    "PySide2.QtPrintSupport.QPrinter.printerName": (),
    "PySide2.QtPrintSupport.QPrinter.printerState": (),
    "PySide2.QtPrintSupport.QPrinter.resolution": (),
    "PySide2.QtPrintSupport.QPrinter.setCollateCopies": ('bool',),
    "PySide2.QtPrintSupport.QPrinter.setColorMode": ('PySide2.QtPrintSupport.QPrinter.ColorMode',),
    "PySide2.QtPrintSupport.QPrinter.setCopyCount": ('int',),
    "PySide2.QtPrintSupport.QPrinter.setCreator": ('str',),
    "PySide2.QtPrintSupport.QPrinter.setDocName": ('str',),
    "PySide2.QtPrintSupport.QPrinter.setDoubleSidedPrinting": ('bool',),
    "PySide2.QtPrintSupport.QPrinter.setDuplex": ('PySide2.QtPrintSupport.QPrinter.DuplexMode',),
    "PySide2.QtPrintSupport.QPrinter.setEngines": ('PySide2.QtPrintSupport.QPrintEngine', 'PySide2.QtGui.QPaintEngine'),
    "PySide2.QtPrintSupport.QPrinter.setFontEmbeddingEnabled": ('bool',),
    "PySide2.QtPrintSupport.QPrinter.setFromTo": ('int', 'int'),
    "PySide2.QtPrintSupport.QPrinter.setFullPage": ('bool',),
    "PySide2.QtPrintSupport.QPrinter.setMargins": ('PySide2.QtGui.QPagedPaintDevice.Margins',),
    "PySide2.QtPrintSupport.QPrinter.setNumCopies": ('int',),
    "PySide2.QtPrintSupport.QPrinter.setOrientation": ('PySide2.QtPrintSupport.QPrinter.Orientation',),
    "PySide2.QtPrintSupport.QPrinter.setOutputFileName": ('str',),
    "PySide2.QtPrintSupport.QPrinter.setOutputFormat": ('PySide2.QtPrintSupport.QPrinter.OutputFormat',),
    "PySide2.QtPrintSupport.QPrinter.setPageMargins": [('PySide2.QtCore.QMarginsF',), ('float', 'float', 'float', 'float', 'PySide2.QtPrintSupport.QPrinter.Unit')],
    "PySide2.QtPrintSupport.QPrinter.setPageOrder": ('PySide2.QtPrintSupport.QPrinter.PageOrder',),
    "PySide2.QtPrintSupport.QPrinter.setPageSize": [('PySide2.QtGui.QPageSize',), ('PySide2.QtGui.QPagedPaintDevice.PageSize',)],
    "PySide2.QtPrintSupport.QPrinter.setPageSizeMM": ('PySide2.QtCore.QSizeF',),
    "PySide2.QtPrintSupport.QPrinter.setPaperName": ('str',),
    "PySide2.QtPrintSupport.QPrinter.setPaperSize": [('PySide2.QtCore.QSizeF', 'PySide2.QtPrintSupport.QPrinter.Unit'), ('PySide2.QtGui.QPagedPaintDevice.PageSize',)],
    "PySide2.QtPrintSupport.QPrinter.setPaperSource": ('PySide2.QtPrintSupport.QPrinter.PaperSource',),
    "PySide2.QtPrintSupport.QPrinter.setPdfVersion": ('PySide2.QtGui.QPagedPaintDevice.PdfVersion',),
    "PySide2.QtPrintSupport.QPrinter.setPrintProgram": ('str',),
    "PySide2.QtPrintSupport.QPrinter.setPrintRange": ('PySide2.QtPrintSupport.QPrinter.PrintRange',),
    "PySide2.QtPrintSupport.QPrinter.setPrinterName": ('str',),
    "PySide2.QtPrintSupport.QPrinter.setResolution": ('int',),
    "PySide2.QtPrintSupport.QPrinter.setWinPageSize": ('int',),
    "PySide2.QtPrintSupport.QPrinter.supportedPaperSources": (),
    "PySide2.QtPrintSupport.QPrinter.supportedResolutions": (),
    "PySide2.QtPrintSupport.QPrinter.supportsMultipleCopies": (),
    "PySide2.QtPrintSupport.QPrinter.toPage": (),
    "PySide2.QtPrintSupport.QPrinter.winPageSize": (),

# class PySide2.QtPrintSupport.QPrinterInfo:
    "PySide2.QtPrintSupport.QPrinterInfo.__init__": [(), ('PySide2.QtPrintSupport.QPrinter',), ('PySide2.QtPrintSupport.QPrinterInfo',)],
    "PySide2.QtPrintSupport.QPrinterInfo.__copy__": (),
    "PySide2.QtPrintSupport.QPrinterInfo.availablePrinterNames": (),
    "PySide2.QtPrintSupport.QPrinterInfo.availablePrinters": (),
    "PySide2.QtPrintSupport.QPrinterInfo.defaultColorMode": (),
    "PySide2.QtPrintSupport.QPrinterInfo.defaultDuplexMode": (),
    "PySide2.QtPrintSupport.QPrinterInfo.defaultPageSize": (),
    "PySide2.QtPrintSupport.QPrinterInfo.defaultPrinter": (),
    "PySide2.QtPrintSupport.QPrinterInfo.defaultPrinterName": (),
    "PySide2.QtPrintSupport.QPrinterInfo.description": (),
    "PySide2.QtPrintSupport.QPrinterInfo.isDefault": (),
    "PySide2.QtPrintSupport.QPrinterInfo.isNull": (),
    "PySide2.QtPrintSupport.QPrinterInfo.isRemote": (),
    "PySide2.QtPrintSupport.QPrinterInfo.location": (),
    "PySide2.QtPrintSupport.QPrinterInfo.makeAndModel": (),
    "PySide2.QtPrintSupport.QPrinterInfo.maximumPhysicalPageSize": (),
    "PySide2.QtPrintSupport.QPrinterInfo.minimumPhysicalPageSize": (),
    "PySide2.QtPrintSupport.QPrinterInfo.printerInfo": ('str',),
    "PySide2.QtPrintSupport.QPrinterInfo.printerName": (),
    "PySide2.QtPrintSupport.QPrinterInfo.state": (),
    "PySide2.QtPrintSupport.QPrinterInfo.supportedColorModes": (),
    "PySide2.QtPrintSupport.QPrinterInfo.supportedDuplexModes": (),
    "PySide2.QtPrintSupport.QPrinterInfo.supportedPageSizes": (),
    "PySide2.QtPrintSupport.QPrinterInfo.supportedPaperSizes": (),
    "PySide2.QtPrintSupport.QPrinterInfo.supportedResolutions": (),
    "PySide2.QtPrintSupport.QPrinterInfo.supportedSizesWithNames": (),
    "PySide2.QtPrintSupport.QPrinterInfo.supportsCustomPageSizes": (),
    }) if "PySide2.QtPrintSupport" in sys.modules else None

# Module PySide2.QtSql
sig_dict.update({

# class PySide2.QtSql.QSql:

# class PySide2.QtSql.QSql.Location:

# class PySide2.QtSql.QSql.NumericalPrecisionPolicy:

# class PySide2.QtSql.QSql.ParamType:

# class PySide2.QtSql.QSql.ParamTypeFlag:

# class PySide2.QtSql.QSql.TableType:

# class PySide2.QtSql.QSqlDatabase:
    "PySide2.QtSql.QSqlDatabase.__init__": [(), ('PySide2.QtSql.QSqlDatabase',), ('PySide2.QtSql.QSqlDriver',), ('str',)],
    "PySide2.QtSql.QSqlDatabase.__copy__": (),
    "PySide2.QtSql.QSqlDatabase.addDatabase": [('PySide2.QtSql.QSqlDriver', 'str'), ('str', 'str')],
    "PySide2.QtSql.QSqlDatabase.cloneDatabase": [('PySide2.QtSql.QSqlDatabase', 'str'), ('str', 'str')],
    "PySide2.QtSql.QSqlDatabase.close": (),
    "PySide2.QtSql.QSqlDatabase.commit": (),
    "PySide2.QtSql.QSqlDatabase.connectOptions": (),
    "PySide2.QtSql.QSqlDatabase.connectionName": (),
    "PySide2.QtSql.QSqlDatabase.connectionNames": (),
    "PySide2.QtSql.QSqlDatabase.contains": ('str',),
    "PySide2.QtSql.QSqlDatabase.database": ('str', 'bool'),
    "PySide2.QtSql.QSqlDatabase.databaseName": (),
    "PySide2.QtSql.QSqlDatabase.driver": (),
    "PySide2.QtSql.QSqlDatabase.driverName": (),
    "PySide2.QtSql.QSqlDatabase.drivers": (),
    "PySide2.QtSql.QSqlDatabase.exec_": ('str',),
    "PySide2.QtSql.QSqlDatabase.hostName": (),
    "PySide2.QtSql.QSqlDatabase.isDriverAvailable": ('str',),
    "PySide2.QtSql.QSqlDatabase.isOpen": (),
    "PySide2.QtSql.QSqlDatabase.isOpenError": (),
    "PySide2.QtSql.QSqlDatabase.isValid": (),
    "PySide2.QtSql.QSqlDatabase.lastError": (),
    "PySide2.QtSql.QSqlDatabase.numericalPrecisionPolicy": (),
    "PySide2.QtSql.QSqlDatabase.open": [(), ('str', 'str')],
    "PySide2.QtSql.QSqlDatabase.password": (),
    "PySide2.QtSql.QSqlDatabase.port": (),
    "PySide2.QtSql.QSqlDatabase.primaryIndex": ('str',),
    "PySide2.QtSql.QSqlDatabase.record": ('str',),
    "PySide2.QtSql.QSqlDatabase.registerSqlDriver": ('str', 'PySide2.QtSql.QSqlDriverCreatorBase'),
    "PySide2.QtSql.QSqlDatabase.removeDatabase": ('str',),
    "PySide2.QtSql.QSqlDatabase.rollback": (),
    "PySide2.QtSql.QSqlDatabase.setConnectOptions": ('str',),
    "PySide2.QtSql.QSqlDatabase.setDatabaseName": ('str',),
    "PySide2.QtSql.QSqlDatabase.setHostName": ('str',),
    "PySide2.QtSql.QSqlDatabase.setNumericalPrecisionPolicy": ('PySide2.QtSql.QSql.NumericalPrecisionPolicy',),
    "PySide2.QtSql.QSqlDatabase.setPassword": ('str',),
    "PySide2.QtSql.QSqlDatabase.setPort": ('int',),
    "PySide2.QtSql.QSqlDatabase.setUserName": ('str',),
    "PySide2.QtSql.QSqlDatabase.tables": ('PySide2.QtSql.QSql.TableType',),
    "PySide2.QtSql.QSqlDatabase.transaction": (),
    "PySide2.QtSql.QSqlDatabase.userName": (),

# class PySide2.QtSql.QSqlDriver:

# class PySide2.QtSql.QSqlDriver.DbmsType:

# class PySide2.QtSql.QSqlDriver.DriverFeature:

# class PySide2.QtSql.QSqlDriver.IdentifierType:

# class PySide2.QtSql.QSqlDriver.NotificationSource:

# class PySide2.QtSql.QSqlDriver.StatementType:
    "PySide2.QtSql.QSqlDriver.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtSql.QSqlDriver.beginTransaction": (),
    "PySide2.QtSql.QSqlDriver.cancelQuery": (),
    "PySide2.QtSql.QSqlDriver.close": (),
    "PySide2.QtSql.QSqlDriver.commitTransaction": (),
    "PySide2.QtSql.QSqlDriver.createResult": (),
    "PySide2.QtSql.QSqlDriver.dbmsType": (),
    "PySide2.QtSql.QSqlDriver.escapeIdentifier": ('str', 'PySide2.QtSql.QSqlDriver.IdentifierType'),
    "PySide2.QtSql.QSqlDriver.formatValue": ('PySide2.QtSql.QSqlField', 'bool'),
    "PySide2.QtSql.QSqlDriver.hasFeature": ('PySide2.QtSql.QSqlDriver.DriverFeature',),
    "PySide2.QtSql.QSqlDriver.isIdentifierEscaped": ('str', 'PySide2.QtSql.QSqlDriver.IdentifierType'),
    "PySide2.QtSql.QSqlDriver.isOpen": (),
    "PySide2.QtSql.QSqlDriver.isOpenError": (),
    "PySide2.QtSql.QSqlDriver.lastError": (),
    "PySide2.QtSql.QSqlDriver.numericalPrecisionPolicy": (),
    "PySide2.QtSql.QSqlDriver.open": ('str', 'str', 'str', 'str', 'int', 'str'),
    "PySide2.QtSql.QSqlDriver.primaryIndex": ('str',),
    "PySide2.QtSql.QSqlDriver.record": ('str',),
    "PySide2.QtSql.QSqlDriver.rollbackTransaction": (),
    "PySide2.QtSql.QSqlDriver.setLastError": ('PySide2.QtSql.QSqlError',),
    "PySide2.QtSql.QSqlDriver.setNumericalPrecisionPolicy": ('PySide2.QtSql.QSql.NumericalPrecisionPolicy',),
    "PySide2.QtSql.QSqlDriver.setOpen": ('bool',),
    "PySide2.QtSql.QSqlDriver.setOpenError": ('bool',),
    "PySide2.QtSql.QSqlDriver.sqlStatement": ('PySide2.QtSql.QSqlDriver.StatementType', 'str', 'PySide2.QtSql.QSqlRecord', 'bool'),
    "PySide2.QtSql.QSqlDriver.stripDelimiters": ('str', 'PySide2.QtSql.QSqlDriver.IdentifierType'),
    "PySide2.QtSql.QSqlDriver.subscribeToNotification": ('str',),
    "PySide2.QtSql.QSqlDriver.subscribedToNotifications": (),
    "PySide2.QtSql.QSqlDriver.tables": ('PySide2.QtSql.QSql.TableType',),
    "PySide2.QtSql.QSqlDriver.unsubscribeFromNotification": ('str',),

# class PySide2.QtSql.QSqlDriverCreatorBase:
    "PySide2.QtSql.QSqlDriverCreatorBase.__init__": (),
    "PySide2.QtSql.QSqlDriverCreatorBase.createObject": (),

# class PySide2.QtSql.QSqlError:

# class PySide2.QtSql.QSqlError.ErrorType:
    "PySide2.QtSql.QSqlError.__init__": [('PySide2.QtSql.QSqlError',), ('str', 'str', 'PySide2.QtSql.QSqlError.ErrorType', 'int'), ('str', 'str', 'PySide2.QtSql.QSqlError.ErrorType', 'str')],
    "PySide2.QtSql.QSqlError.__copy__": (),
    "PySide2.QtSql.QSqlError.databaseText": (),
    "PySide2.QtSql.QSqlError.driverText": (),
    "PySide2.QtSql.QSqlError.isValid": (),
    "PySide2.QtSql.QSqlError.nativeErrorCode": (),
    "PySide2.QtSql.QSqlError.number": (),
    "PySide2.QtSql.QSqlError.setDatabaseText": ('str',),
    "PySide2.QtSql.QSqlError.setDriverText": ('str',),
    "PySide2.QtSql.QSqlError.setNumber": ('int',),
    "PySide2.QtSql.QSqlError.setType": ('PySide2.QtSql.QSqlError.ErrorType',),
    "PySide2.QtSql.QSqlError.swap": ('PySide2.QtSql.QSqlError',),
    "PySide2.QtSql.QSqlError.text": (),
    "PySide2.QtSql.QSqlError.type": (),

# class PySide2.QtSql.QSqlField:

# class PySide2.QtSql.QSqlField.RequiredStatus:
    "PySide2.QtSql.QSqlField.__init__": [('PySide2.QtSql.QSqlField',), ('str', 'type'), ('str', 'type', 'str')],
    "PySide2.QtSql.QSqlField.__copy__": (),
    "PySide2.QtSql.QSqlField.clear": (),
    "PySide2.QtSql.QSqlField.defaultValue": (),
    "PySide2.QtSql.QSqlField.isAutoValue": (),
    "PySide2.QtSql.QSqlField.isGenerated": (),
    "PySide2.QtSql.QSqlField.isNull": (),
    "PySide2.QtSql.QSqlField.isReadOnly": (),
    "PySide2.QtSql.QSqlField.isValid": (),
    "PySide2.QtSql.QSqlField.length": (),
    "PySide2.QtSql.QSqlField.name": (),
    "PySide2.QtSql.QSqlField.precision": (),
    "PySide2.QtSql.QSqlField.requiredStatus": (),
    "PySide2.QtSql.QSqlField.setAutoValue": ('bool',),
    "PySide2.QtSql.QSqlField.setDefaultValue": ('typing.Any',),
    "PySide2.QtSql.QSqlField.setGenerated": ('bool',),
    "PySide2.QtSql.QSqlField.setLength": ('int',),
    "PySide2.QtSql.QSqlField.setName": ('str',),
    "PySide2.QtSql.QSqlField.setPrecision": ('int',),
    "PySide2.QtSql.QSqlField.setReadOnly": ('bool',),
    "PySide2.QtSql.QSqlField.setRequired": ('bool',),
    "PySide2.QtSql.QSqlField.setRequiredStatus": ('PySide2.QtSql.QSqlField.RequiredStatus',),
    "PySide2.QtSql.QSqlField.setSqlType": ('int',),
    "PySide2.QtSql.QSqlField.setTableName": ('str',),
    "PySide2.QtSql.QSqlField.setType": ('type',),
    "PySide2.QtSql.QSqlField.setValue": ('typing.Any',),
    "PySide2.QtSql.QSqlField.tableName": (),
    "PySide2.QtSql.QSqlField.type": (),
    "PySide2.QtSql.QSqlField.typeID": (),
    "PySide2.QtSql.QSqlField.value": (),

# class PySide2.QtSql.QSqlIndex:
    "PySide2.QtSql.QSqlIndex.__init__": [('PySide2.QtSql.QSqlIndex',), ('str', 'str')],
    "PySide2.QtSql.QSqlIndex.__copy__": (),
    "PySide2.QtSql.QSqlIndex.append": [('PySide2.QtSql.QSqlField',), ('PySide2.QtSql.QSqlField', 'bool')],
    "PySide2.QtSql.QSqlIndex.cursorName": (),
    "PySide2.QtSql.QSqlIndex.isDescending": ('int',),
    "PySide2.QtSql.QSqlIndex.name": (),
    "PySide2.QtSql.QSqlIndex.setCursorName": ('str',),
    "PySide2.QtSql.QSqlIndex.setDescending": ('int', 'bool'),
    "PySide2.QtSql.QSqlIndex.setName": ('str',),

# class PySide2.QtSql.QSqlQuery:

# class PySide2.QtSql.QSqlQuery.BatchExecutionMode:
    "PySide2.QtSql.QSqlQuery.__init__": [('PySide2.QtSql.QSqlDatabase',), ('PySide2.QtSql.QSqlQuery',), ('PySide2.QtSql.QSqlResult',), ('str', 'PySide2.QtSql.QSqlDatabase')],
    "PySide2.QtSql.QSqlQuery.__copy__": (),
    "PySide2.QtSql.QSqlQuery.addBindValue": ('typing.Any', 'PySide2.QtSql.QSql.ParamType'),
    "PySide2.QtSql.QSqlQuery.at": (),
    "PySide2.QtSql.QSqlQuery.bindValue": [('int', 'typing.Any', 'PySide2.QtSql.QSql.ParamType'), ('str', 'typing.Any', 'PySide2.QtSql.QSql.ParamType')],
    "PySide2.QtSql.QSqlQuery.boundValue": [('int',), ('str',)],
    "PySide2.QtSql.QSqlQuery.boundValues": (),
    "PySide2.QtSql.QSqlQuery.clear": (),
    "PySide2.QtSql.QSqlQuery.driver": (),
    "PySide2.QtSql.QSqlQuery.execBatch": ('PySide2.QtSql.QSqlQuery.BatchExecutionMode',),
    "PySide2.QtSql.QSqlQuery.exec_": [(), ('str',)],
    "PySide2.QtSql.QSqlQuery.executedQuery": (),
    "PySide2.QtSql.QSqlQuery.finish": (),
    "PySide2.QtSql.QSqlQuery.first": (),
    "PySide2.QtSql.QSqlQuery.isActive": (),
    "PySide2.QtSql.QSqlQuery.isForwardOnly": (),
    "PySide2.QtSql.QSqlQuery.isNull": [('int',), ('str',)],
    "PySide2.QtSql.QSqlQuery.isSelect": (),
    "PySide2.QtSql.QSqlQuery.isValid": (),
    "PySide2.QtSql.QSqlQuery.last": (),
    "PySide2.QtSql.QSqlQuery.lastError": (),
    "PySide2.QtSql.QSqlQuery.lastInsertId": (),
    "PySide2.QtSql.QSqlQuery.lastQuery": (),
    "PySide2.QtSql.QSqlQuery.nextResult": (),
    "PySide2.QtSql.QSqlQuery.numRowsAffected": (),
    "PySide2.QtSql.QSqlQuery.numericalPrecisionPolicy": (),
    "PySide2.QtSql.QSqlQuery.prepare": ('str',),
    "PySide2.QtSql.QSqlQuery.previous": (),
    "PySide2.QtSql.QSqlQuery.record": (),
    "PySide2.QtSql.QSqlQuery.result": (),
    "PySide2.QtSql.QSqlQuery.seek": ('int', 'bool'),
    "PySide2.QtSql.QSqlQuery.setForwardOnly": ('bool',),
    "PySide2.QtSql.QSqlQuery.setNumericalPrecisionPolicy": ('PySide2.QtSql.QSql.NumericalPrecisionPolicy',),
    "PySide2.QtSql.QSqlQuery.size": (),
    "PySide2.QtSql.QSqlQuery.value": [('int',), ('str',)],

# class PySide2.QtSql.QSqlQueryModel:
    "PySide2.QtSql.QSqlQueryModel.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtSql.QSqlQueryModel.beginInsertColumns": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtSql.QSqlQueryModel.beginInsertRows": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtSql.QSqlQueryModel.beginRemoveColumns": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtSql.QSqlQueryModel.beginRemoveRows": ('PySide2.QtCore.QModelIndex', 'int', 'int'),
    "PySide2.QtSql.QSqlQueryModel.beginResetModel": (),
    "PySide2.QtSql.QSqlQueryModel.canFetchMore": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtSql.QSqlQueryModel.clear": (),
    "PySide2.QtSql.QSqlQueryModel.columnCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtSql.QSqlQueryModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtSql.QSqlQueryModel.endInsertColumns": (),
    "PySide2.QtSql.QSqlQueryModel.endInsertRows": (),
    "PySide2.QtSql.QSqlQueryModel.endRemoveColumns": (),
    "PySide2.QtSql.QSqlQueryModel.endRemoveRows": (),
    "PySide2.QtSql.QSqlQueryModel.endResetModel": (),
    "PySide2.QtSql.QSqlQueryModel.fetchMore": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtSql.QSqlQueryModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
    "PySide2.QtSql.QSqlQueryModel.indexInQuery": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtSql.QSqlQueryModel.insertColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtSql.QSqlQueryModel.lastError": (),
    "PySide2.QtSql.QSqlQueryModel.query": (),
    "PySide2.QtSql.QSqlQueryModel.queryChange": (),
    "PySide2.QtSql.QSqlQueryModel.record": [(), ('int',)],
    "PySide2.QtSql.QSqlQueryModel.removeColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtSql.QSqlQueryModel.roleNames": (),
    "PySide2.QtSql.QSqlQueryModel.rowCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtSql.QSqlQueryModel.setHeaderData": ('int', 'PySide2.QtCore.Qt.Orientation', 'typing.Any', 'int'),
    "PySide2.QtSql.QSqlQueryModel.setLastError": ('PySide2.QtSql.QSqlError',),
    "PySide2.QtSql.QSqlQueryModel.setQuery": [('PySide2.QtSql.QSqlQuery',), ('str', 'PySide2.QtSql.QSqlDatabase')],

# class PySide2.QtSql.QSqlRecord:
    "PySide2.QtSql.QSqlRecord.__init__": [(), ('PySide2.QtSql.QSqlRecord',)],
    "PySide2.QtSql.QSqlRecord.__copy__": (),
    "PySide2.QtSql.QSqlRecord.append": ('PySide2.QtSql.QSqlField',),
    "PySide2.QtSql.QSqlRecord.clear": (),
    "PySide2.QtSql.QSqlRecord.clearValues": (),
    "PySide2.QtSql.QSqlRecord.contains": ('str',),
    "PySide2.QtSql.QSqlRecord.count": (),
    "PySide2.QtSql.QSqlRecord.field": [('int',), ('str',)],
    "PySide2.QtSql.QSqlRecord.fieldName": ('int',),
    "PySide2.QtSql.QSqlRecord.indexOf": ('str',),
    "PySide2.QtSql.QSqlRecord.insert": ('int', 'PySide2.QtSql.QSqlField'),
    "PySide2.QtSql.QSqlRecord.isEmpty": (),
    "PySide2.QtSql.QSqlRecord.isGenerated": [('int',), ('str',)],
    "PySide2.QtSql.QSqlRecord.isNull": [('int',), ('str',)],
    "PySide2.QtSql.QSqlRecord.keyValues": ('PySide2.QtSql.QSqlRecord',),
    "PySide2.QtSql.QSqlRecord.remove": ('int',),
    "PySide2.QtSql.QSqlRecord.replace": ('int', 'PySide2.QtSql.QSqlField'),
    "PySide2.QtSql.QSqlRecord.setGenerated": [('int', 'bool'), ('str', 'bool')],
    "PySide2.QtSql.QSqlRecord.setNull": [('int',), ('str',)],
    "PySide2.QtSql.QSqlRecord.setValue": [('int', 'typing.Any'), ('str', 'typing.Any')],
    "PySide2.QtSql.QSqlRecord.value": [('int',), ('str',)],

# class PySide2.QtSql.QSqlRelation:
    "PySide2.QtSql.QSqlRelation.__init__": [(), ('PySide2.QtSql.QSqlRelation',), ('str', 'str', 'str')],
    "PySide2.QtSql.QSqlRelation.__copy__": (),
    "PySide2.QtSql.QSqlRelation.displayColumn": (),
    "PySide2.QtSql.QSqlRelation.indexColumn": (),
    "PySide2.QtSql.QSqlRelation.isValid": (),
    "PySide2.QtSql.QSqlRelation.swap": ('PySide2.QtSql.QSqlRelation',),
    "PySide2.QtSql.QSqlRelation.tableName": (),

# class PySide2.QtSql.QSqlRelationalDelegate:
    "PySide2.QtSql.QSqlRelationalDelegate.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtSql.QSqlRelationalDelegate.createEditor": ('PySide2.QtWidgets.QWidget', 'PySide2.QtWidgets.QStyleOptionViewItem', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtSql.QSqlRelationalDelegate.setEditorData": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtSql.QSqlRelationalDelegate.setModelData": ('PySide2.QtWidgets.QWidget', 'PySide2.QtCore.QAbstractItemModel', 'PySide2.QtCore.QModelIndex'),

# class PySide2.QtSql.QSqlRelationalTableModel:

# class PySide2.QtSql.QSqlRelationalTableModel.JoinMode:
    "PySide2.QtSql.QSqlRelationalTableModel.__init__": ('PySide2.QtCore.QObject', 'PySide2.QtSql.QSqlDatabase'),
    "PySide2.QtSql.QSqlRelationalTableModel.clear": (),
    "PySide2.QtSql.QSqlRelationalTableModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtSql.QSqlRelationalTableModel.insertRowIntoTable": ('PySide2.QtSql.QSqlRecord',),
    "PySide2.QtSql.QSqlRelationalTableModel.orderByClause": (),
    "PySide2.QtSql.QSqlRelationalTableModel.relation": ('int',),
    "PySide2.QtSql.QSqlRelationalTableModel.relationModel": ('int',),
    "PySide2.QtSql.QSqlRelationalTableModel.removeColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtSql.QSqlRelationalTableModel.revertRow": ('int',),
    "PySide2.QtSql.QSqlRelationalTableModel.select": (),
    "PySide2.QtSql.QSqlRelationalTableModel.selectStatement": (),
    "PySide2.QtSql.QSqlRelationalTableModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
    "PySide2.QtSql.QSqlRelationalTableModel.setJoinMode": ('PySide2.QtSql.QSqlRelationalTableModel.JoinMode',),
    "PySide2.QtSql.QSqlRelationalTableModel.setRelation": ('int', 'PySide2.QtSql.QSqlRelation'),
    "PySide2.QtSql.QSqlRelationalTableModel.setTable": ('str',),
    "PySide2.QtSql.QSqlRelationalTableModel.updateRowInTable": ('int', 'PySide2.QtSql.QSqlRecord'),

# class PySide2.QtSql.QSqlResult:

# class PySide2.QtSql.QSqlResult.BindingSyntax:
    "PySide2.QtSql.QSqlResult.__init__": ('PySide2.QtSql.QSqlDriver',),
    "PySide2.QtSql.QSqlResult.addBindValue": ('typing.Any', 'PySide2.QtSql.QSql.ParamType'),
    "PySide2.QtSql.QSqlResult.at": (),
    "PySide2.QtSql.QSqlResult.bindValue": [('int', 'typing.Any', 'PySide2.QtSql.QSql.ParamType'), ('str', 'typing.Any', 'PySide2.QtSql.QSql.ParamType')],
    "PySide2.QtSql.QSqlResult.bindValueType": [('int',), ('str',)],
    "PySide2.QtSql.QSqlResult.bindingSyntax": (),
    "PySide2.QtSql.QSqlResult.boundValue": [('int',), ('str',)],
    "PySide2.QtSql.QSqlResult.boundValueCount": (),
    "PySide2.QtSql.QSqlResult.boundValueName": ('int',),
    "PySide2.QtSql.QSqlResult.boundValues": (),
    "PySide2.QtSql.QSqlResult.clear": (),
    "PySide2.QtSql.QSqlResult.data": ('int',),
    "PySide2.QtSql.QSqlResult.detachFromResultSet": (),
    "PySide2.QtSql.QSqlResult.driver": (),
    "PySide2.QtSql.QSqlResult.execBatch": ('bool',),
    "PySide2.QtSql.QSqlResult.exec_": (),
    "PySide2.QtSql.QSqlResult.executedQuery": (),
    "PySide2.QtSql.QSqlResult.fetch": ('int',),
    "PySide2.QtSql.QSqlResult.fetchFirst": (),
    "PySide2.QtSql.QSqlResult.fetchLast": (),
    "PySide2.QtSql.QSqlResult.fetchNext": (),
    "PySide2.QtSql.QSqlResult.fetchPrevious": (),
    "PySide2.QtSql.QSqlResult.handle": (),
    "PySide2.QtSql.QSqlResult.hasOutValues": (),
    "PySide2.QtSql.QSqlResult.isActive": (),
    "PySide2.QtSql.QSqlResult.isForwardOnly": (),
    "PySide2.QtSql.QSqlResult.isNull": ('int',),
    "PySide2.QtSql.QSqlResult.isSelect": (),
    "PySide2.QtSql.QSqlResult.isValid": (),
    "PySide2.QtSql.QSqlResult.lastError": (),
    "PySide2.QtSql.QSqlResult.lastInsertId": (),
    "PySide2.QtSql.QSqlResult.lastQuery": (),
    "PySide2.QtSql.QSqlResult.nextResult": (),
    "PySide2.QtSql.QSqlResult.numRowsAffected": (),
    "PySide2.QtSql.QSqlResult.numericalPrecisionPolicy": (),
    "PySide2.QtSql.QSqlResult.prepare": ('str',),
    "PySide2.QtSql.QSqlResult.record": (),
    "PySide2.QtSql.QSqlResult.reset": ('str',),
    "PySide2.QtSql.QSqlResult.resetBindCount": (),
    "PySide2.QtSql.QSqlResult.savePrepare": ('str',),
    "PySide2.QtSql.QSqlResult.setActive": ('bool',),
    "PySide2.QtSql.QSqlResult.setAt": ('int',),
    "PySide2.QtSql.QSqlResult.setForwardOnly": ('bool',),
    "PySide2.QtSql.QSqlResult.setLastError": ('PySide2.QtSql.QSqlError',),
    "PySide2.QtSql.QSqlResult.setNumericalPrecisionPolicy": ('PySide2.QtSql.QSql.NumericalPrecisionPolicy',),
    "PySide2.QtSql.QSqlResult.setQuery": ('str',),
    "PySide2.QtSql.QSqlResult.setSelect": ('bool',),
    "PySide2.QtSql.QSqlResult.size": (),

# class PySide2.QtSql.QSqlTableModel:

# class PySide2.QtSql.QSqlTableModel.EditStrategy:
    "PySide2.QtSql.QSqlTableModel.__init__": ('PySide2.QtCore.QObject', 'PySide2.QtSql.QSqlDatabase'),
    "PySide2.QtSql.QSqlTableModel.clear": (),
    "PySide2.QtSql.QSqlTableModel.data": ('PySide2.QtCore.QModelIndex', 'int'),
    "PySide2.QtSql.QSqlTableModel.database": (),
    "PySide2.QtSql.QSqlTableModel.deleteRowFromTable": ('int',),
    "PySide2.QtSql.QSqlTableModel.editStrategy": (),
    "PySide2.QtSql.QSqlTableModel.fieldIndex": ('str',),
    "PySide2.QtSql.QSqlTableModel.filter": (),
    "PySide2.QtSql.QSqlTableModel.flags": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtSql.QSqlTableModel.headerData": ('int', 'PySide2.QtCore.Qt.Orientation', 'int'),
    "PySide2.QtSql.QSqlTableModel.indexInQuery": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtSql.QSqlTableModel.insertRecord": ('int', 'PySide2.QtSql.QSqlRecord'),
    "PySide2.QtSql.QSqlTableModel.insertRowIntoTable": ('PySide2.QtSql.QSqlRecord',),
    "PySide2.QtSql.QSqlTableModel.insertRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtSql.QSqlTableModel.isDirty": [(), ('PySide2.QtCore.QModelIndex',)],
    "PySide2.QtSql.QSqlTableModel.orderByClause": (),
    "PySide2.QtSql.QSqlTableModel.primaryKey": (),
    "PySide2.QtSql.QSqlTableModel.primaryValues": ('int',),
    "PySide2.QtSql.QSqlTableModel.record": [(), ('int',)],
    "PySide2.QtSql.QSqlTableModel.removeColumns": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtSql.QSqlTableModel.removeRows": ('int', 'int', 'PySide2.QtCore.QModelIndex'),
    "PySide2.QtSql.QSqlTableModel.revert": (),
    "PySide2.QtSql.QSqlTableModel.revertAll": (),
    "PySide2.QtSql.QSqlTableModel.revertRow": ('int',),
    "PySide2.QtSql.QSqlTableModel.rowCount": ('PySide2.QtCore.QModelIndex',),
    "PySide2.QtSql.QSqlTableModel.select": (),
    "PySide2.QtSql.QSqlTableModel.selectRow": ('int',),
    "PySide2.QtSql.QSqlTableModel.selectStatement": (),
    "PySide2.QtSql.QSqlTableModel.setData": ('PySide2.QtCore.QModelIndex', 'typing.Any', 'int'),
    "PySide2.QtSql.QSqlTableModel.setEditStrategy": ('PySide2.QtSql.QSqlTableModel.EditStrategy',),
    "PySide2.QtSql.QSqlTableModel.setFilter": ('str',),
    "PySide2.QtSql.QSqlTableModel.setPrimaryKey": ('PySide2.QtSql.QSqlIndex',),
    "PySide2.QtSql.QSqlTableModel.setQuery": ('PySide2.QtSql.QSqlQuery',),
    "PySide2.QtSql.QSqlTableModel.setRecord": ('int', 'PySide2.QtSql.QSqlRecord'),
    "PySide2.QtSql.QSqlTableModel.setSort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
    "PySide2.QtSql.QSqlTableModel.setTable": ('str',),
    "PySide2.QtSql.QSqlTableModel.sort": ('int', 'PySide2.QtCore.Qt.SortOrder'),
    "PySide2.QtSql.QSqlTableModel.submit": (),
    "PySide2.QtSql.QSqlTableModel.submitAll": (),
    "PySide2.QtSql.QSqlTableModel.tableName": (),
    "PySide2.QtSql.QSqlTableModel.updateRowInTable": ('int', 'PySide2.QtSql.QSqlRecord'),
    }) if "PySide2.QtSql" in sys.modules else None

# Module PySide2.QtNetwork
sig_dict.update({

# class PySide2.QtNetwork.QAbstractNetworkCache:
    "PySide2.QtNetwork.QAbstractNetworkCache.__init__": ('PySide2.QtCore.QObject',),
    "PySide2.QtNetwork.QAbstractNetworkCache.cacheSize": (),
    "PySide2.QtNetwork.QAbstractNetworkCache.clear": (),
    "PySide2.QtNetwork.QAbstractNetworkCache.data": ('PySide2.QtCore.QUrl',),
    "PySide2.QtNetwork.QAbstractNetworkCache.insert": ('PySide2.QtCore.QIODevice',),
    "PySide2.QtNetwork.QAbstractNetworkCache.metaData": ('PySide2.QtCore.QUrl',),
    "PySide2.QtNetwork.QAbstractNetworkCache.prepare": ('PySide2.QtNetwork.QNetworkCacheMetaData',),
    "PySide2.QtNetwork.QAbstractNetworkCache.remove": ('PySide2.QtCore.QUrl',),
    "PySide2.QtNetwork.QAbstractNetworkCache.updateMetaData": ('PySide2.QtNetwork.QNetworkCacheMetaData',),

# class PySide2.QtNetwork.QAbstractSocket:

# class PySide2.QtNetwork.QAbstractSocket.BindFlag:

# class PySide2.QtNetwork.QAbstractSocket.BindMode:

# class PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol:

# class PySide2.QtNetwork.QAbstractSocket.PauseMode:

# class PySide2.QtNetwork.QAbstractSocket.PauseModes:

# class PySide2.QtNetwork.QAbstractSocket.SocketError:

# class PySide2.QtNetwork.QAbstractSocket.SocketOption:

# class PySide2.QtNetwork.QAbstractSocket.SocketState:

# class PySide2.QtNetwork.QAbstractSocket.SocketType:
    "PySide2.QtNetwork.QAbstractSocket.__init__": ('PySide2.QtNetwork.QAbstractSocket.SocketType', 'PySide2.QtCore.QObject'),
    "PySide2.QtNetwork.QAbstractSocket.abort": (),
    "PySide2.QtNetwork.QAbstractSocket.atEnd": (),
    "PySide2.QtNetwork.QAbstractSocket.bind": [('PySide2.QtNetwork.QHostAddress', 'int', 'PySide2.QtNetwork.QAbstractSocket.BindMode'), ('int', 'PySide2.QtNetwork.QAbstractSocket.BindMode')],
    "PySide2.QtNetwork.QAbstractSocket.bytesAvailable": (),
    "PySide2.QtNetwork.QAbstractSocket.bytesToWrite": (),
    "PySide2.QtNetwork.QAbstractSocket.canReadLine": (),
    "PySide2.QtNetwork.QAbstractSocket.close": (),
    "PySide2.QtNetwork.QAbstractSocket.connectToHost": [('PySide2.QtNetwork.QHostAddress', 'int', 'PySide2.QtCore.QIODevice.OpenMode'), ('str', 'int', 'PySide2.QtCore.QIODevice.OpenMode', 'PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol')],
    "PySide2.QtNetwork.QAbstractSocket.disconnectFromHost": (),
    "PySide2.QtNetwork.QAbstractSocket.error": (),
    "PySide2.QtNetwork.QAbstractSocket.flush": (),
    "PySide2.QtNetwork.QAbstractSocket.isSequential": (),
    "PySide2.QtNetwork.QAbstractSocket.isValid": (),
    "PySide2.QtNetwork.QAbstractSocket.localAddress": (),
    "PySide2.QtNetwork.QAbstractSocket.localPort": (),
    "PySide2.QtNetwork.QAbstractSocket.pauseMode": (),
    "PySide2.QtNetwork.QAbstractSocket.peerAddress": (),
    "PySide2.QtNetwork.QAbstractSocket.peerName": (),
    "PySide2.QtNetwork.QAbstractSocket.peerPort": (),
    "PySide2.QtNetwork.QAbstractSocket.protocolTag": (),
    "PySide2.QtNetwork.QAbstractSocket.proxy": (),
    "PySide2.QtNetwork.QAbstractSocket.readBufferSize": (),
    "PySide2.QtNetwork.QAbstractSocket.readData": ('bytes', 'int'),
    "PySide2.QtNetwork.QAbstractSocket.readLineData": ('bytes', 'int'),
    "PySide2.QtNetwork.QAbstractSocket.resume": (),
    "PySide2.QtNetwork.QAbstractSocket.setLocalAddress": ('PySide2.QtNetwork.QHostAddress',),
    "PySide2.QtNetwork.QAbstractSocket.setLocalPort": ('int',),
    "PySide2.QtNetwork.QAbstractSocket.setPauseMode": ('PySide2.QtNetwork.QAbstractSocket.PauseModes',),
    "PySide2.QtNetwork.QAbstractSocket.setPeerAddress": ('PySide2.QtNetwork.QHostAddress',),
    "PySide2.QtNetwork.QAbstractSocket.setPeerName": ('str',),
    "PySide2.QtNetwork.QAbstractSocket.setPeerPort": ('int',),
    "PySide2.QtNetwork.QAbstractSocket.setProtocolTag": ('str',),
    "PySide2.QtNetwork.QAbstractSocket.setProxy": ('PySide2.QtNetwork.QNetworkProxy',),
    "PySide2.QtNetwork.QAbstractSocket.setReadBufferSize": ('int',),
    "PySide2.QtNetwork.QAbstractSocket.setSocketDescriptor": ('int', 'PySide2.QtNetwork.QAbstractSocket.SocketState', 'PySide2.QtCore.QIODevice.OpenMode'),
    "PySide2.QtNetwork.QAbstractSocket.setSocketError": ('PySide2.QtNetwork.QAbstractSocket.SocketError',),
    "PySide2.QtNetwork.QAbstractSocket.setSocketOption": ('PySide2.QtNetwork.QAbstractSocket.SocketOption', 'typing.Any'),
    "PySide2.QtNetwork.QAbstractSocket.setSocketState": ('PySide2.QtNetwork.QAbstractSocket.SocketState',),
    "PySide2.QtNetwork.QAbstractSocket.socketDescriptor": (),
    "PySide2.QtNetwork.QAbstractSocket.socketOption": ('PySide2.QtNetwork.QAbstractSocket.SocketOption',),
    "PySide2.QtNetwork.QAbstractSocket.socketType": (),
    "PySide2.QtNetwork.QAbstractSocket.state": (),
    "PySide2.QtNetwork.QAbstractSocket.waitForBytesWritten": ('int',),
    "PySide2.QtNetwork.QAbstractSocket.waitForConnected": ('int',),
    "PySide2.QtNetwork.QAbstractSocket.waitForDisconnected": ('int',),
    "PySide2.QtNetwork.QAbstractSocket.waitForReadyRead": ('int',),
    "PySide2.QtNetwork.QAbstractSocket.writeData": ('bytes', 'int'),

# class PySide2.QtNetwork.QAuthenticator:
    "PySide2.QtNetwork.QAuthenticator.__init__": [(), ('PySide2.QtNetwork.QAuthenticator',)],
    "PySide2.QtNetwork.QAuthenticator.__copy__": (),
    "PySide2.QtNetwork.QAuthenticator.isNull": (),
    "PySide2.QtNetwork.QAuthenticator.option": ('str',),
    "PySide2.QtNetwork.QAuthenticator.options": (),
    "PySide2.QtNetwork.QAuthenticator.password": (),
    "PySide2.QtNetwork.QAuthenticator.realm": (),
    "PySide2.QtNetwork.QAuthenticator.setOption": ('str', 'typing.Any'),
    "PySide2.QtNetwork.QAuthenticator.setPassword": ('str',),
    "PySide2.QtNetwork.QAuthenticator.setRealm": ('str',),
    "PySide2.QtNetwork.QAuthenticator.setUser": ('str',),
    "PySide2.QtNetwork.QAuthenticator.user": (),

# class PySide2.QtNetwork.QDnsDomainNameRecord:
    "PySide2.QtNetwork.QDnsDomainNameRecord.__init__": [(), ('PySide2.QtNetwork.QDnsDomainNameRecord',)],
    "PySide2.QtNetwork.QDnsDomainNameRecord.__copy__": (),
    "PySide2.QtNetwork.QDnsDomainNameRecord.name": (),
    "PySide2.QtNetwork.QDnsDomainNameRecord.swap": ('PySide2.QtNetwork.QDnsDomainNameRecord',),
    "PySide2.QtNetwork.QDnsDomainNameRecord.timeToLive": (),
    "PySide2.QtNetwork.QDnsDomainNameRecord.value": (),

# class PySide2.QtNetwork.QDnsHostAddressRecord:
    "PySide2.QtNetwork.QDnsHostAddressRecord.__init__": [(), ('PySide2.QtNetwork.QDnsHostAddressRecord',)],
    "PySide2.QtNetwork.QDnsHostAddressRec