# -*- coding: utf-8 -*-
# PYLang 0.0.4 http://launchpad.net/pylang
# Copyright (C) 2008-2013 Marcos Alvarez Costales https://launchpad.net/~costales
#
# PYLang is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# PYLang is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with PYLang; if not, see http://www.gnu.org/licenses for more
# information.

import os, ConfigParser


class Utils:
    def __init__(self):
        self.path = os.path.join(os.path.expanduser("~"), '.config/pylang')
        self.file = 'pylang.cfg'
        self.cfg_file = os.path.join(self.path, self.file)
    
    def get_config_value(self, attribute):
        cfg = ConfigParser.ConfigParser()
        try:
            if not cfg.read([self.cfg_file]):
                return ''
        except:
            os.remove(self.cfg_file)
            return ''
        
        if not cfg.has_option('PYLangConfiguration', attribute):
            return ''
            
        return cfg.get('PYLangConfiguration', attribute)

    def set_config_value(self, attr, value):
        if not os.path.exists(self.cfg_file):
            try:
              os.mkdir(self.path)
            except:
                return
        
            try:
                f = open(self.cfg_file, 'w')  
            except:
                return
            cfg = ConfigParser.ConfigParser()
            cfg.add_section("PYLangConfiguration")  
            cfg.write(f)  
            f.close()  
        
        cfg = ConfigParser.ConfigParser()
        cfg.read(self.cfg_file)
        cfg.set('PYLangConfiguration', attr, value)
        f = open(self.cfg_file, 'w')  
        cfg.write(f)  
        f.close()  
