import os
try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

with open('README.md') as f:
    readme = f.read()
with open(os.path.join('docs', 'release-notes.rst')) as f:
    history = f.read()

setup(
    name="pykwalify",
    version="1.7.0",
    description='Python lib/cli for JSON/YAML schema validation',
    long_description=readme + '\n\n' + history,
    long_description_content_type='text/markdown',
    author="Johan Andersson",
    author_email="Grokzen@gmail.com",
    maintainer='Johan Andersson',
    maintainer_email='Grokzen@gmail.com',
    license='MIT',
    packages=['pykwalify'],
    url='http://github.com/grokzen/pykwalify',
    extras_require={
        'ruamel': ["ruamel.yaml>=0.11.0,<0.16.0"],
    },
    entry_points={
        'console_scripts': [
            'pykwalify = pykwalify.cli:cli_entrypoint',
        ],
    },
    install_requires=[
        'docopt>=0.6.2',
        'PyYAML>=3.11',
        'python-dateutil>=2.4.2',
    ],
    classifiers=[
        # 'Development Status :: 1 - Planning',
        # 'Development Status :: 2 - Pre-Alpha',
        # 'Development Status :: 3 - Alpha',
        # 'Development Status :: 4 - Beta',
        'Development Status :: 5 - Production/Stable',
        # 'Development Status :: 6 - Mature',
        # 'Development Status :: 7 - Inactive',
        'Intended Audience :: Developers',
        'Operating System :: OS Independent',
        'License :: OSI Approved :: MIT License',
        'Environment :: Console',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
    ],
)
