# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`archive`](#archive): Manages archive module's dependencies.
* [`archive::staging`](#archive--staging): Backwards-compatibility class for staging module

#### Private Classes

* `archive::params`: OS specific `archive` settings such as default user and file mode.

### Defined types

* [`archive::artifactory`](#archive--artifactory): Archive wrapper for downloading files from artifactory
* [`archive::download`](#archive--download): Archive downloader with integrity verification
* [`archive::go`](#archive--go): download from go
* [`archive::nexus`](#archive--nexus): define: archive::nexus ======================  archive wrapper for downloading files from Nexus using REST API. Nexus API: https://repository

### Resource types

* [`archive`](#archive): Manage archive file download, extraction, and cleanup.

### Functions

#### Public Functions

* [`archive::artifactory_checksum`](#archive--artifactory_checksum): A function that returns the checksum value of an artifact stored in Artifactory
* [`archive::artifactory_latest_url`](#archive--artifactory_latest_url)
* [`archive::parse_artifactory_url`](#archive--parse_artifactory_url): A function to parse an Artifactory maven 2 repository URL

#### Private Functions

* `archive::assemble_nexus_url`: Assembles a complete nexus URL from the base url and query parameters
* `archive::go_md5`: Retrieves and returns specific file's md5 from GoCD server md5 checksum file

## Classes

### <a name="archive"></a>`archive`

Manages archive module's dependencies.

#### Examples

##### On Windows, ensure 7zip is installed using the default `chocolatey` provider.

```puppet
include archive
```

##### On Windows, install a 7zip MSI with the native `windows` package provider.

```puppet
class { 'archive':
  seven_zip_name     => '7-Zip 9.20 (x64 edition)',
  seven_zip_source   => 'C:/Windows/Temp/7z920-x64.msi',
  seven_zip_provider => 'windows',
}
```

##### Install the AWS CLI tool. (Not supported on Windows).

```puppet
class { 'archive':
  aws_cli_install => true,
}
```

##### Deploy a specific archive

```puppet
class { 'archive':
  archives => { '/tmp/jta-1.1.jar' => {
                  'ensure' => 'present',
                  'source'  => 'http://central.maven.org/maven2/javax/transaction/jta/1.1/jta-1.1.jar',
                  }, }
}
```

#### Parameters

The following parameters are available in the `archive` class:

* [`seven_zip_name`](#-archive--seven_zip_name)
* [`seven_zip_provider`](#-archive--seven_zip_provider)
* [`seven_zip_source`](#-archive--seven_zip_source)
* [`aws_cli_install`](#-archive--aws_cli_install)
* [`gsutil_install`](#-archive--gsutil_install)
* [`archives`](#-archive--archives)

##### <a name="-archive--seven_zip_name"></a>`seven_zip_name`

Data type: `Optional[String[1]]`

7zip package name.  This parameter only applies to Windows.

Default value: `$archive::params::seven_zip_name`

##### <a name="-archive--seven_zip_provider"></a>`seven_zip_provider`

Data type: `Optional[Enum['chocolatey','windows','']]`

7zip package provider.  This parameter only applies to Windows where it defaults to `chocolatey`. Can be set to an empty string, (or `undef` via hiera), if you don't want this module to manage 7zip.

Default value: `$archive::params::seven_zip_provider`

##### <a name="-archive--seven_zip_source"></a>`seven_zip_source`

Data type: `Optional[String[1]]`

Alternative package source for 7zip.  This parameter only applies to Windows.

Default value: `undef`

##### <a name="-archive--aws_cli_install"></a>`aws_cli_install`

Data type: `Boolean`

Installs the AWS CLI command needed for downloading from S3 buckets.  This parameter is currently not implemented on Windows.

Default value: `false`

##### <a name="-archive--gsutil_install"></a>`gsutil_install`

Data type: `Boolean`

Installs the GSUtil CLI command needed for downloading from GS buckets.  This parameter is currently not implemented on Windows.

Default value: `false`

##### <a name="-archive--archives"></a>`archives`

Data type: `Hash`

A hash of archive resources this module should create.

Default value: `{}`

### <a name="archive--staging"></a>`archive::staging`

Backwards-compatibility class for staging module

#### Parameters

The following parameters are available in the `archive::staging` class:

* [`path`](#-archive--staging--path)
* [`owner`](#-archive--staging--owner)
* [`group`](#-archive--staging--group)
* [`mode`](#-archive--staging--mode)

##### <a name="-archive--staging--path"></a>`path`

Data type: `String`

Absolute path of staging directory to create

Default value: `$archive::params::path`

##### <a name="-archive--staging--owner"></a>`owner`

Data type: `String`

Username of directory owner

Default value: `$archive::params::owner`

##### <a name="-archive--staging--group"></a>`group`

Data type: `String`

Group of directory owner

Default value: `$archive::params::group`

##### <a name="-archive--staging--mode"></a>`mode`

Data type: `String`

Mode (permissions) on staging directory

Default value: `$archive::params::mode`

## Defined types

### <a name="archive--artifactory"></a>`archive::artifactory`

Archive wrapper for downloading files from artifactory

#### Examples

##### 

```puppet
archive::artifactory { '/tmp/logo.png':
  url   => 'https://repo.jfrog.org/artifactory/distributions/images/Artifactory_120x75.png',
  owner => 'root',
  group => 'root',
  mode  => '0644',
}
```

##### 

```puppet
$dirname = 'gradle-1.0-milestone-4-20110723151213+0300'
$filename = "${dirname}-bin.zip"

archive::artifactory { $filename:
  archive_path => '/tmp',
  url          => "http://repo.jfrog.org/artifactory/distributions/org/gradle/${filename}",
  extract      => true,
  extract_path => '/opt',
  creates      => "/opt/${dirname}",
  cleanup      => true,
}
```

#### Parameters

The following parameters are available in the `archive::artifactory` defined type:

* [`url`](#-archive--artifactory--url)
* [`headers`](#-archive--artifactory--headers)
* [`path`](#-archive--artifactory--path)
* [`ensure`](#-archive--artifactory--ensure)
* [`cleanup`](#-archive--artifactory--cleanup)
* [`extract`](#-archive--artifactory--extract)
* [`archive_path`](#-archive--artifactory--archive_path)
* [`creates`](#-archive--artifactory--creates)
* [`extract_path`](#-archive--artifactory--extract_path)
* [`group`](#-archive--artifactory--group)
* [`mode`](#-archive--artifactory--mode)
* [`owner`](#-archive--artifactory--owner)
* [`password`](#-archive--artifactory--password)
* [`username`](#-archive--artifactory--username)

##### <a name="-archive--artifactory--url"></a>`url`

Data type: `Stdlib::HTTPUrl`

artifactory download URL

##### <a name="-archive--artifactory--headers"></a>`headers`

Data type: `Array`

HTTP header(s) to pass to source

Default value: `[]`

##### <a name="-archive--artifactory--path"></a>`path`

Data type: `String`

absolute path for the download file (or use archive_path and only supply filename)

Default value: `$name`

##### <a name="-archive--artifactory--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

ensure download file present/absent

Default value: `'present'`

##### <a name="-archive--artifactory--cleanup"></a>`cleanup`

Data type: `Boolean`

remove archive after file extraction

Default value: `false`

##### <a name="-archive--artifactory--extract"></a>`extract`

Data type: `Boolean`

whether to extract the files

Default value: `false`

##### <a name="-archive--artifactory--archive_path"></a>`archive_path`

Data type: `Optional[Stdlib::Absolutepath]`

parent directory to download archive into

Default value: `undef`

##### <a name="-archive--artifactory--creates"></a>`creates`

Data type: `Optional[String]`

the file created when the archive is extracted

Default value: `undef`

##### <a name="-archive--artifactory--extract_path"></a>`extract_path`

Data type: `Optional[String]`

absolute path to extract archive into

Default value: `undef`

##### <a name="-archive--artifactory--group"></a>`group`

Data type: `Optional[String]`

file group (see archive params for defaults)

Default value: `undef`

##### <a name="-archive--artifactory--mode"></a>`mode`

Data type: `Optional[String]`

file mode (see archive params for defaults)

Default value: `undef`

##### <a name="-archive--artifactory--owner"></a>`owner`

Data type: `Optional[String]`

file owner (see archive params for defaults)

Default value: `undef`

##### <a name="-archive--artifactory--password"></a>`password`

Data type: `Optional[String]`

Password to authenticate with

Default value: `undef`

##### <a name="-archive--artifactory--username"></a>`username`

Data type: `Optional[String]`

User to authenticate as

Default value: `undef`

### <a name="archive--download"></a>`archive::download`

Archive downloader with integrity verification

#### Examples

##### 

```puppet
archive::download {"apache-tomcat-6.0.26.tar.gz":
  ensure => present,
  url    => "http://archive.apache.org/dist/tomcat/tomcat-6/v6.0.26/bin/apache-tomcat-6.0.26.tar.gz",
}
```

##### 

```puppet
archive::download {"apache-tomcat-6.0.26.tar.gz":
  ensure        => present,
  digest_string => "f9eafa9bfd620324d1270ae8f09a8c89",
  url           => "http://archive.apache.org/dist/tomcat/tomcat-6/v6.0.26/bin/apache-tomcat-6.0.26.tar.gz",
}
```

#### Parameters

The following parameters are available in the `archive::download` defined type:

* [`url`](#-archive--download--url)
* [`headers`](#-archive--download--headers)
* [`allow_insecure`](#-archive--download--allow_insecure)
* [`checksum`](#-archive--download--checksum)
* [`digest_type`](#-archive--download--digest_type)
* [`ensure`](#-archive--download--ensure)
* [`src_target`](#-archive--download--src_target)
* [`digest_string`](#-archive--download--digest_string)
* [`digest_url`](#-archive--download--digest_url)
* [`proxy_server`](#-archive--download--proxy_server)
* [`user`](#-archive--download--user)

##### <a name="-archive--download--url"></a>`url`

Data type: `String`

source

##### <a name="-archive--download--headers"></a>`headers`

Data type: `Array`

HTTP (s) to pass to source

Default value: `[]`

##### <a name="-archive--download--allow_insecure"></a>`allow_insecure`

Data type: `Boolean`

Allow self-signed certificate on source?

Default value: `false`

##### <a name="-archive--download--checksum"></a>`checksum`

Data type: `Boolean`

Should checksum be validated?

Default value: `true`

##### <a name="-archive--download--digest_type"></a>`digest_type`

Data type: `Enum['none', 'md5', 'sha1', 'sha2','sha256', 'sha384', 'sha512']`

Digest to use for calculating checksum

Default value: `'md5'`

##### <a name="-archive--download--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

ensure file present/absent

Default value: `'present'`

##### <a name="-archive--download--src_target"></a>`src_target`

Data type: `Stdlib::Absolutepath`

Absolute path to staging location

Default value: `'/usr/src'`

##### <a name="-archive--download--digest_string"></a>`digest_string`

Data type: `Optional[String]`

Value  expected checksum

Default value: `undef`

##### <a name="-archive--download--digest_url"></a>`digest_url`

Data type: `Optional[String]`

URL  expected checksum value

Default value: `undef`

##### <a name="-archive--download--proxy_server"></a>`proxy_server`

Data type: `Optional[String]`

FQDN of proxy server

Default value: `undef`

##### <a name="-archive--download--user"></a>`user`

Data type: `Optional[String]`

User used to download the archive

Default value: `undef`

### <a name="archive--go"></a>`archive::go`

download from go

#### Parameters

The following parameters are available in the `archive::go` defined type:

* [`server`](#-archive--go--server)
* [`port`](#-archive--go--port)
* [`url_path`](#-archive--go--url_path)
* [`md5_url_path`](#-archive--go--md5_url_path)
* [`username`](#-archive--go--username)
* [`password`](#-archive--go--password)
* [`ensure`](#-archive--go--ensure)
* [`path`](#-archive--go--path)
* [`owner`](#-archive--go--owner)
* [`group`](#-archive--go--group)
* [`mode`](#-archive--go--mode)
* [`extract`](#-archive--go--extract)
* [`extract_path`](#-archive--go--extract_path)
* [`creates`](#-archive--go--creates)
* [`cleanup`](#-archive--go--cleanup)
* [`archive_path`](#-archive--go--archive_path)

##### <a name="-archive--go--server"></a>`server`

Data type: `String`



##### <a name="-archive--go--port"></a>`port`

Data type: `Integer`



##### <a name="-archive--go--url_path"></a>`url_path`

Data type: `String`



##### <a name="-archive--go--md5_url_path"></a>`md5_url_path`

Data type: `String`



##### <a name="-archive--go--username"></a>`username`

Data type: `String`



##### <a name="-archive--go--password"></a>`password`

Data type: `String`



##### <a name="-archive--go--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`



Default value: `present`

##### <a name="-archive--go--path"></a>`path`

Data type: `String`



Default value: `$name`

##### <a name="-archive--go--owner"></a>`owner`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--go--group"></a>`group`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--go--mode"></a>`mode`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--go--extract"></a>`extract`

Data type: `Optional[Boolean]`



Default value: `undef`

##### <a name="-archive--go--extract_path"></a>`extract_path`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--go--creates"></a>`creates`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--go--cleanup"></a>`cleanup`

Data type: `Optional[Boolean]`



Default value: `undef`

##### <a name="-archive--go--archive_path"></a>`archive_path`

Data type: `Optional[Stdlib::Absolutepath]`



Default value: `undef`

### <a name="archive--nexus"></a>`archive::nexus`

define: archive::nexus
======================

archive wrapper for downloading files from Nexus using REST API. Nexus API:
https://repository.sonatype.org/nexus-restlet1x-plugin/default/docs/path__artifact_maven_content.html

Parameters
----------

Examples
--------

archive::nexus { '/tmp/jtstand-ui-0.98.jar':
  url        => 'https://oss.sonatype.org',
  gav        => 'org.codehaus.jtstand:jtstand-ui:0.98',
  repository => 'codehaus-releases',
  packaging  => 'jar',
  extract    => false,
}

#### Parameters

The following parameters are available in the `archive::nexus` defined type:

* [`url`](#-archive--nexus--url)
* [`gav`](#-archive--nexus--gav)
* [`repository`](#-archive--nexus--repository)
* [`ensure`](#-archive--nexus--ensure)
* [`checksum_type`](#-archive--nexus--checksum_type)
* [`checksum_verify`](#-archive--nexus--checksum_verify)
* [`packaging`](#-archive--nexus--packaging)
* [`use_nexus3_urls`](#-archive--nexus--use_nexus3_urls)
* [`classifier`](#-archive--nexus--classifier)
* [`extension`](#-archive--nexus--extension)
* [`username`](#-archive--nexus--username)
* [`password`](#-archive--nexus--password)
* [`user`](#-archive--nexus--user)
* [`owner`](#-archive--nexus--owner)
* [`group`](#-archive--nexus--group)
* [`mode`](#-archive--nexus--mode)
* [`extract`](#-archive--nexus--extract)
* [`extract_path`](#-archive--nexus--extract_path)
* [`extract_flags`](#-archive--nexus--extract_flags)
* [`extract_command`](#-archive--nexus--extract_command)
* [`creates`](#-archive--nexus--creates)
* [`cleanup`](#-archive--nexus--cleanup)
* [`proxy_server`](#-archive--nexus--proxy_server)
* [`proxy_type`](#-archive--nexus--proxy_type)
* [`allow_insecure`](#-archive--nexus--allow_insecure)
* [`temp_dir`](#-archive--nexus--temp_dir)

##### <a name="-archive--nexus--url"></a>`url`

Data type: `String`



##### <a name="-archive--nexus--gav"></a>`gav`

Data type: `String`



##### <a name="-archive--nexus--repository"></a>`repository`

Data type: `String`



##### <a name="-archive--nexus--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`



Default value: `present`

##### <a name="-archive--nexus--checksum_type"></a>`checksum_type`

Data type: `Enum['none', 'md5', 'sha1', 'sha2','sha256', 'sha384', 'sha512']`



Default value: `'md5'`

##### <a name="-archive--nexus--checksum_verify"></a>`checksum_verify`

Data type: `Boolean`



Default value: `true`

##### <a name="-archive--nexus--packaging"></a>`packaging`

Data type: `String`



Default value: `'jar'`

##### <a name="-archive--nexus--use_nexus3_urls"></a>`use_nexus3_urls`

Data type: `Boolean`



Default value: `false`

##### <a name="-archive--nexus--classifier"></a>`classifier`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--nexus--extension"></a>`extension`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--nexus--username"></a>`username`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--nexus--password"></a>`password`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--nexus--user"></a>`user`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--nexus--owner"></a>`owner`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--nexus--group"></a>`group`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--nexus--mode"></a>`mode`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--nexus--extract"></a>`extract`

Data type: `Optional[Boolean]`



Default value: `undef`

##### <a name="-archive--nexus--extract_path"></a>`extract_path`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--nexus--extract_flags"></a>`extract_flags`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--nexus--extract_command"></a>`extract_command`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--nexus--creates"></a>`creates`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--nexus--cleanup"></a>`cleanup`

Data type: `Optional[Boolean]`



Default value: `undef`

##### <a name="-archive--nexus--proxy_server"></a>`proxy_server`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--nexus--proxy_type"></a>`proxy_type`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-archive--nexus--allow_insecure"></a>`allow_insecure`

Data type: `Optional[Boolean]`



Default value: `undef`

##### <a name="-archive--nexus--temp_dir"></a>`temp_dir`

Data type: `Optional[Stdlib::Absolutepath]`



Default value: `undef`

## Resource types

### <a name="archive"></a>`archive`

Manage archive file download, extraction, and cleanup.

#### Properties

The following properties are available in the `archive` type.

##### `creates`

if file/directory exists, will not download/extract archive.

##### `ensure`

Valid values: `present`, `absent`

whether archive file should be present/absent (default: present)

Default value: `present`

#### Parameters

The following parameters are available in the `archive` type.

* [`allow_insecure`](#-archive--allow_insecure)
* [`checksum`](#-archive--checksum)
* [`checksum_type`](#-archive--checksum_type)
* [`checksum_url`](#-archive--checksum_url)
* [`checksum_verify`](#-archive--checksum_verify)
* [`cleanup`](#-archive--cleanup)
* [`cookie`](#-archive--cookie)
* [`digest_string`](#-archive--digest_string)
* [`digest_type`](#-archive--digest_type)
* [`digest_url`](#-archive--digest_url)
* [`download_options`](#-archive--download_options)
* [`extract`](#-archive--extract)
* [`extract_command`](#-archive--extract_command)
* [`extract_flags`](#-archive--extract_flags)
* [`extract_path`](#-archive--extract_path)
* [`filename`](#-archive--filename)
* [`group`](#-archive--group)
* [`headers`](#-archive--headers)
* [`password`](#-archive--password)
* [`path`](#-archive--path)
* [`provider`](#-archive--provider)
* [`proxy_server`](#-archive--proxy_server)
* [`proxy_type`](#-archive--proxy_type)
* [`source`](#-archive--source)
* [`target`](#-archive--target)
* [`temp_dir`](#-archive--temp_dir)
* [`url`](#-archive--url)
* [`user`](#-archive--user)
* [`username`](#-archive--username)

##### <a name="-archive--allow_insecure"></a>`allow_insecure`

Valid values: `true`, `false`, `yes`, `no`

ignore HTTPS certificate errors

Default value: `false`

##### <a name="-archive--checksum"></a>`checksum`

Valid values: `%r{\b[0-9a-f]{5,128}\b}`, `true`, `false`, `undef`, `nil`, `''`

archive file checksum (match checksum_type).

##### <a name="-archive--checksum_type"></a>`checksum_type`

Valid values: `none`, `md5`, `sha1`, `sha2`, `sha256`, `sha384`, `sha512`

archive file checksum type (none|md5|sha1|sha2|sha256|sha384|sha512).

Default value: `none`

##### <a name="-archive--checksum_url"></a>`checksum_url`

archive file checksum source (instead of specifying checksum)

##### <a name="-archive--checksum_verify"></a>`checksum_verify`

Valid values: `true`, `false`

whether checksum wil be verified (true|false).

Default value: `true`

##### <a name="-archive--cleanup"></a>`cleanup`

Valid values: `true`, `false`

whether archive file will be removed after extraction (true|false).

Default value: `true`

##### <a name="-archive--cookie"></a>`cookie`

archive file download cookie.

##### <a name="-archive--digest_string"></a>`digest_string`

Valid values: `%r{\b[0-9a-f]{5,128}\b}`

archive file checksum (match checksum_type)
(this parameter is for camptocamp/archive compatibility).

##### <a name="-archive--digest_type"></a>`digest_type`

Valid values: `none`, `md5`, `sha1`, `sha2`, `sha256`, `sha384`, `sha512`

archive file checksum type (none|md5|sha1|sha2|sha256|sha384|sha512)
(this parameter is camptocamp/archive compatibility).

##### <a name="-archive--digest_url"></a>`digest_url`

archive file checksum source (instead of specifying checksum)
(this parameter is for camptocamp/archive compatibility)

##### <a name="-archive--download_options"></a>`download_options`

provider download options (affects curl, wget, gs, and only s3 downloads for ruby provider)

##### <a name="-archive--extract"></a>`extract`

Valid values: `true`, `false`

whether archive will be extracted after download (true|false).

Default value: `false`

##### <a name="-archive--extract_command"></a>`extract_command`

custom extraction command ('tar xvf example.tar.gz'), also support sprintf format ('tar xvf %s') which will be processed
with the filename: sprintf('tar xvf %s', filename)

##### <a name="-archive--extract_flags"></a>`extract_flags`

custom extraction options, this replaces the default flags. A string such as 'xvf' for a tar file would replace the
default xf flag. A hash is useful when custom flags are needed for different platforms. {'tar' => 'xzf', '7z' => 'x
-aot'}.

Default value: `undef`

##### <a name="-archive--extract_path"></a>`extract_path`

target folder path to extract archive.

##### <a name="-archive--filename"></a>`filename`

archive file name (derived from path).

##### <a name="-archive--group"></a>`group`

extract command group (using this option will configure the archive file permisison to 0644 so the user can read the
file).

##### <a name="-archive--headers"></a>`headers`

optional header(s) to pass.

##### <a name="-archive--password"></a>`password`

password to download source file.

##### <a name="-archive--path"></a>`path`

namevar, archive file fully qualified file path.

##### <a name="-archive--provider"></a>`provider`

The specific backend to use for this `archive` resource. You will seldom need to specify this --- Puppet will usually
discover the appropriate provider for your platform.

##### <a name="-archive--proxy_server"></a>`proxy_server`

proxy address to use when accessing source

##### <a name="-archive--proxy_type"></a>`proxy_type`

Valid values: `none`, `ftp`, `http`, `https`

proxy type (none|ftp|http|https)

##### <a name="-archive--source"></a>`source`

archive file source, supports puppet|http|https|ftp|file|s3|gs uri.

##### <a name="-archive--target"></a>`target`

target folder path to extract archive. (this parameter is for camptocamp/archive compatibility)

##### <a name="-archive--temp_dir"></a>`temp_dir`

Specify an alternative temporary directory to use for copying files, if unset then the operating system default will be
used.

##### <a name="-archive--url"></a>`url`

archive file source, supports http|https|ftp|file uri.
(for camptocamp/archive compatibility)

##### <a name="-archive--user"></a>`user`

extract command user (using this option will configure the archive file permission to 0644 so the user can read the
file).

##### <a name="-archive--username"></a>`username`

username to download source file.

## Functions

### <a name="archive--artifactory_checksum"></a>`archive::artifactory_checksum`

Type: Ruby 4.x API

A function that returns the checksum value of an artifact stored in Artifactory

#### `archive::artifactory_checksum(Stdlib::HTTPUrl $url, Optional[Enum['sha1','sha256','md5']] $checksum_type)`

The archive::artifactory_checksum function.

Returns: `String` Returns the checksum.

##### `url`

Data type: `Stdlib::HTTPUrl`

The URL of the artifact.

##### `checksum_type`

Data type: `Optional[Enum['sha1','sha256','md5']]`

The checksum type.
Note the function will raise an error if you ask for sha256 but your artifactory instance doesn't have the sha256 value calculated.

### <a name="archive--artifactory_latest_url"></a>`archive::artifactory_latest_url`

Type: Ruby 4.x API

The archive::artifactory_latest_url function.

#### `archive::artifactory_latest_url(Variant[Stdlib::HTTPUrl, Stdlib::HTTPSUrl] $url, Hash $maven_data)`

The archive::artifactory_latest_url function.

Returns: `Any`

##### `url`

Data type: `Variant[Stdlib::HTTPUrl, Stdlib::HTTPSUrl]`



##### `maven_data`

Data type: `Hash`



### <a name="archive--parse_artifactory_url"></a>`archive::parse_artifactory_url`

Type: Ruby 4.x API

A function to parse an Artifactory maven 2 repository URL

#### `archive::parse_artifactory_url(Variant[Stdlib::HTTPUrl, Stdlib::HTTPSUrl] $url)`

A function to parse an Artifactory maven 2 repository URL

Returns: `Any`

##### `url`

Data type: `Variant[Stdlib::HTTPUrl, Stdlib::HTTPSUrl]`



