/*
 *@BEGIN LICENSE
 *
 * PSI4: an ab initio quantum chemistry software package
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *@END LICENSE
 */

/*! \file
    \ingroup DPD
    \brief Enter brief description of file here
*/
#include "dpd.h"

namespace psi {

int DPD::file2_mat_close(dpdfile2 *File)
{
    int h, my_irrep;

    my_irrep = File->my_irrep;

    if(File->incore) return 0;  /* We need to keep the memory */

    for(h=0; h < File->params->nirreps; h++)
        if(File->params->rowtot[h] && File->params->coltot[h^my_irrep])
            free_dpd_block(File->matrix[h], File->params->rowtot[h],
                       File->params->coltot[h^my_irrep]);


    return 0;
}

}
