------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                               C O M M O N                                --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--         Copyright (C) 2004-2008, Free Software Foundation, Inc.          --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with Output;

package body Common is

   use Output;

   --------------------------------
   -- Output_Address_Information --
   --------------------------------

   procedure Output_Address_Information
     (Addr : PolyORB.Utils.Sockets.Socket_Name)
   is
   begin
      Put_Line ("Address", PolyORB.Utils.Sockets.Image (Addr));
   end Output_Address_Information;

   -------------------------------
   -- Output_Object_Information --
   -------------------------------

   procedure Output_Object_Information (Obj : PolyORB.Objects.Object_Id) is
   begin
      Put_Line ("Object_Id", PolyORB.Objects.Image (Obj));
   end Output_Object_Information;

end Common;
