------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--             C O S T I M E . T I M E S E R V I C E . I M P L              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2001-2008, Free Software Foundation, Inc.          --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
--                                                                          --
--                 PolyORB is maintained by AdaCore                         --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with CosTime.TIO;
with TimeBase;
with CosTime.UTO;
with PortableServer;

package CosTime.TimeService.Impl is

   type Object is
     new PortableServer.Servant_Base with null record;

   function universal_time
     (Self : access Object)
     return CosTime.UTO.Ref;

   function secure_universal_time
     (Self : access Object)
     return CosTime.UTO.Ref;

   function new_universal_time
     (Self : access Object;
      time : TimeBase.TimeT;
      inaccuracy : TimeBase.InaccuracyT;
      tdf : TimeBase.TdfT)
     return CosTime.UTO.Ref;

   function uto_from_utc
     (Self : access Object;
      utc : TimeBase.UtcT)
     return CosTime.UTO.Ref;

   function new_interval
     (Self : access Object;
      lower : TimeBase.TimeT;
      upper : TimeBase.TimeT)
     return CosTime.TIO.Ref;

end CosTime.TimeService.Impl;
