/***********************************************************************************
* Smooth Tasks
* Copyright (C) 2012 Toni Dietze <smooth-tasks@derflupp.e4ward.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#ifndef ANIMATIONTHROWRECT_H
#define ANIMATIONTHROWRECT_H

#include <SmoothTasks/Animation/AnimationThrow.h>

class QRectF;

namespace SmoothTasks {

class AnimationThrowRect : public AnimationThrow<4, QRectF>
{
	Q_OBJECT

public:
	AnimationThrowRect(QObject* parent = 0);
	AnimationThrowRect(QObject* target, const QByteArray& propertyName, QObject* parent = 0);
	virtual ~AnimationThrowRect();

	/* implement */ virtual QRectF convert(const qreal src[]) const;
	/* implement */ virtual void   convert(const QRectF& src, qreal dst[]) const;
};

} // namespace SmoothTasks

#endif // ANIMATIONTHROWRECT_H
