/*	AbstractCellEditor

PIRL CVS ID: AbstractCellEditor.java,v 1.2 2012/04/14 01:38:05 castalia Exp
*/
package	PIRL.TreeTable;

import java.awt.Component;
import java.awt.event.*;
import java.awt.AWTEvent;
import javax.swing.*;
import javax.swing.event.*;
import java.util.EventObject;
import java.io.Serializable;

public class AbstractCellEditor
	implements CellEditor
{
protected EventListenerList
	listenerList = new EventListenerList ();

public Object getCellEditorValue ()
{return null;}

public boolean isCellEditable
	(
	EventObject	event
	)
{return true;}

public boolean shouldSelectCell
	(
	EventObject	event
	)
{return false;}

public boolean stopCellEditing ()
{return true;}

public void cancelCellEditing () {}

public void addCellEditorListener
	(
	CellEditorListener	listener
	)
{listenerList.add (CellEditorListener.class, listener);}

public void removeCellEditorListener
	(
	CellEditorListener	listener
	) 
{listenerList.remove (CellEditorListener.class, listener);}

/*	Notify all listeners that have registered interest for
	notification on this event type.  
*/
protected void fireEditingStopped ()
{
//	Guaranteed to return a non-null array.
Object[]
	listeners = listenerList.getListenerList ();

/*	Process the listeners last to first,
	notifying those that are interested in this event.
*/
for (int listener = listeners.length - 2;
		 listener >= 0;
		 listener -= 2)
	if (listeners[listener] == CellEditorListener.class)
		((CellEditorListener)listeners[listener + 1])
			.editingStopped (new ChangeEvent (this));
}


/*	Notify all listeners that have registered interest for
	notification on this event type.  
*/
protected void fireEditingCanceled ()
{
//	Guaranteed to return a non-null array.
Object[]
	listeners = listenerList.getListenerList ();

/*	Process the listeners last to first,
	notifying those that are interested in this event.
*/
for (int listener = listeners.length - 2;
		 listener >= 0;
		 listener -= 2)
	if (listeners[listener] == CellEditorListener.class)
		((CellEditorListener)listeners[listener + 1])
			.editingCanceled (new ChangeEvent (this));
}


}	//	class AbstractCellEditor.
