#ifndef PINBA_LIMITS_H
# define PINBA_LIMITS_H

/* max index string length */
#define PINBA_MAX_LINE_LEN 8192

/* these must not be greater than 255! */
#define PINBA_HOSTNAME_SIZE 33
#define PINBA_SERVER_NAME_SIZE 33
#define PINBA_SCRIPT_NAME_SIZE 129
#define PINBA_STATUS_SIZE 33
#define PINBA_SCHEMA_SIZE 17

#define PINBA_TAG_NAME_SIZE 65
#define PINBA_TAG_VALUE_SIZE 65
#define PINBA_DICTIONARY_ENTRY_SIZE 65 /* must be equal to the greater of the two above */

#define PINBA_ERR_BUFFER 2048

#define PINBA_UDP_BUFFER_SIZE 65536

#define PINBA_DICTIONARY_GROW_SIZE 32
#define PINBA_TIMER_POOL_GROW_SIZE 2621440
#define PINBA_TIMER_POOL_SHRINK_SIZE PINBA_TIMER_POOL_GROW_SIZE*5

#define PINBA_THREAD_POOL_DEFAULT_SIZE 8
#define PINBA_THREAD_POOL_THRESHOLD_AMOUNT 16
#define PINBA_MIN_TAG_VALUES_CNT_MAGIC_NUMBER 8
#define PINBA_PER_THREAD_POOL_GROW_SIZE 1024
#define PINBA_TEMP_DICTIONARY_SIZE 1024

#define PINBA_HISTOGRAM_SIZE 512

#endif
