/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL plugin
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifndef __PGM_GLX_BACKEND_H__
#define __PGM_GLX_BACKEND_H__

#include <X11/Xlib.h>
#include <X11/Xutil.h>

/* NVIDIA has glXGetProcAddressARB guarded by GLX_GLXEXT_PROTOTYPES */
#define GLX_GLXEXT_PROTOTYPES
#include <GL/glx.h>
#undef GLX_GLXEXT_PROTOTYPES

#include "pgmbackend.h"

G_BEGIN_DECLS

#define PGM_TYPE_GLX_BACKEND (pgm_glx_backend_get_type ())
#define PGM_GLX_BACKEND(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_GLX_BACKEND, PgmGlxBackend))
#define PGM_GLX_BACKEND_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_GLX_BACKEND, PgmGlxBackendClass))
#define PGM_IS_GLX_BACKEND(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_GLX_BACKEND))
#define PGM_IS_GLX_BACKEND_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_GLX_BACKEND))
#define PGM_GLX_BACKEND_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), PGM_TYPE_GLX_BACKEND, PgmGlxBackendClass))

typedef struct _PgmGlxBackend            PgmGlxBackend;
typedef struct _PgmGlxBackendClass       PgmGlxBackendClass;
typedef struct _PgmGlxBackendSource      PgmGlxBackendSource;
typedef struct _PgmGlxBackendProcAddress PgmGlxBackendProcAddress;

/* Feature flags */
typedef enum {
  PGM_GLX_FEAT_FBCONFIG            = (1 << 0),
  PGM_GLX_FEAT_VIDEO_SYNC          = (1 << 1),
  PGM_GLX_FEAT_SWAP_CONTROL        = (1 << 2),
  PGM_GLX_FEAT_DIRECT_RENDERING    = (1 << 3),
  PGM_GLX_FEAT_ARGB_VISUAL         = (1 << 4),
  PGM_GLX_FEAT_TEXTURE_FROM_PIXMAP = (1 << 5)
} PgmGlxBackendFeature;

/* VBlank modes */
typedef enum {
  PGM_VBLANK_NONE,
  PGM_VBLANK_SWAP_CONTROL,
  PGM_VBLANK_VIDEO_SYNC
} PgmGlxBackendVBlank;

struct _PgmGlxBackend {
  PgmBackend parent;

  /* X connection and window management */
  Display *dpy;
  Window   win;
  gint     screen;
  gint     root;

  /* X protocols */
  Atom   *atom;
  gchar  *startup_notification_id;
  Window  embedder;

  /* X drag and drop */
  Window     drag_source;
  gboolean   drag_data_has_uri;
  gboolean   drag_data_received;
  gfloat     drag_x, drag_y;
  gchar    **drag_uri;

  /* OpenGL context handling */
  PgmGlxBackendProcAddress *glx;
  GLXFBConfig              *fbconfig;
  gint                      fbconfig_index;
  XVisualInfo              *visual;
  GLXContext                ctx;

  /* GLX informations */
  const gchar *vendor;
  const gchar *extensions;
  gfloat       version;
  guint        feature_mask;

  /* Event handling source id */
  guint event_id;

  /* Display lists to rasterize X fonts (for debugging purpose) */
  guint text_lists;

  /* None cursor */
  Cursor none_cursor;

  /* Screen informations */
  gint resolution_width;
  gint resolution_height;
  gint size_mm_width;
  gint size_mm_height;

  /* Backed up window size */
  gint windowed_width;
  gint windowed_height;

  /* Vertical blanking mode */
  PgmGlxBackendVBlank vblank_mode;

  /* States */
  PgmViewportState state;
  gboolean created;
  gboolean mapped;
  gboolean fullscreen;
  gboolean drag_status;
};

struct _PgmGlxBackendClass {
  PgmBackendClass parent_class;
};

/* Event source */
struct _PgmGlxBackendSource {
  GSource source;
  GPollFD poll_fd;

  /* Keep track of the backend */
  PgmGlxBackend *glxbackend;
};

/* GLX function pointers definitions */
typedef GLXFBConfig* (*PgmGlxChooseFbconfigFunc)        (Display *dpy,
                                                         gint screen,
                                                         const gint *attrib_list,
                                                         gint *nelements);
typedef gint         (*PgmGlxGetFbconfigAttribFunc)     (Display *dpy,
                                                         GLXFBConfig config,
                                                         gint attribute,
                                                         gint *value);
typedef XVisualInfo* (*PgmGlxGetVisualFromFbconfigFunc) (Display *dpy,
                                                         GLXFBConfig config);
typedef GLXContext   (*PgmGlxCreateNewContextFunc)      (Display *dpy,
                                                         GLXFBConfig config,
                                                         gint render_type,
                                                         GLXContext share_list,
                                                         gboolean direct);
typedef gint         (*PgmGlxGetVideoSyncFunc)          (guint *count);
typedef gint         (*PgmGlxWaitVideoSyncFunc)         (gint divisor,
                                                         gint remainder,
                                                         guint *count);
typedef gint         (*PgmGlxSwapIntervalFunc)          (gint interval);
typedef void         (*PgmGlxBindTexImageFunc)          (Display *dpy,
                                                         GLXDrawable drawable,
                                                         int buffer,
                                                         const int *attrib_list);
typedef void         (*PgmGlxReleaseTexImageFunc)       (Display *dpy,
                                                         GLXDrawable drawable,
                                                         int buffer);


/* GLX function pointers used for extensions loading */
struct _PgmGlxBackendProcAddress {
  PgmGlxChooseFbconfigFunc        choose_fbconfig;
  PgmGlxGetFbconfigAttribFunc     get_fbconfig_attrib;
  PgmGlxGetVisualFromFbconfigFunc get_visual_from_fbconfig;
  PgmGlxCreateNewContextFunc      create_new_context;
  PgmGlxGetVideoSyncFunc          get_video_sync;
  PgmGlxWaitVideoSyncFunc         wait_video_sync;
  PgmGlxSwapIntervalFunc          swap_interval;
  PgmGlxBindTexImageFunc          bind_tex_image;
  PgmGlxReleaseTexImageFunc       release_tex_image;
};

GType       pgm_glx_backend_get_type (void) G_GNUC_CONST;

PgmBackend *pgm_glx_backend_new      (PgmContext *context);
void        pgm_glx_backend_register (GTypeModule *module);

G_END_DECLS

#endif /* __PGM_GLX_BACKEND_H__ */
