Working with Flavors
====================

A *flavor* is a named definition of certain server parameters such as the
amount of RAM and disk space available. (There are other parameters set via
the flavor, such as the amount of disk space and the number of virtual CPUs,
but a discussion of those is too in-depth for a simple Getting Started Guide
like this one.)

A `Flavor` object is generated from the `Flavor()`
method on the `Compute` object:

    $flavor = $compute->Flavor();

This is an empty flavor, and not very useful by itself. Normally, you'll retrieve
a flavor by its ID:

    $flavor = $compute->Flavor(2);

The ID can be either a full UUID or simply an integer (as shown above). The
actual format will depend upon your cloud provider.

A list of flavors is provided by the `FlavorList` [Collection](collections.md) object,
which is generated by the `FlavorList()` method:

    $flavors = $compute->FlavorList();
    while($flavor = $flavors->Next())
        printf("Flavor %s has %dMB of RAM and %dGB of disk\n",
            $flavor->name, $flavor->ram, $flavor->disk);

### Flavor details

By default, the `FlavorList()` method returns full details on all flavors.
However, because of the overhead involved in retrieving all the details,
this function can be slower than expected. You can supply an optional
boolean parameter to the `FlavorList()` method to determine whether or not
the flavor details are included:

    $fastlist = $compute->FlavorList(FALSE); // name + id only
    $slowlist = $compute->FlavorList(TRUE);  // include all details

### Filtering flavors

The (optional) second parameter to the `FlavorList()` method is an
associative array of filter parameters. See the 
[List Flavors API call](http://docs.rackspace.com/servers/api/v2/cs-devguide/content/List_Flavors-d1e4188.html)
in the Next Generation Cloud Servers Developer Guide for a list of the available
parameters. 

For example, you may be only interested in flavors that have at least 4GB of
memory:

    $biglist = $compute->FlavorList(TRUE, array('minRam'=>4096));

Or perhaps only flavors that have at least 200GB of disk:

    $biglist = $compute->FlavorList(TRUE, array('minDisk'=>200));

These filters can, of course, be combined:

    $mylist = $compute->FlavorList(
        TRUE,
        array('minRam'=>4000, 'minDisk'=>200));

### Examples

The file `samples/compute/flavors.php` has some examples of working with
flavors.

## What next?

Return to the [Table of Contents](toc.md)
