--TEST--
Decimal::toString
--SKIPIF--
<?php
if (!extension_loaded("decimal")) echo "skip";
?>
--FILE--
<?php
use Decimal\Decimal;

/**
 * Shortcut to construct a new decimal.
 */
function decimal(...$args) { return new Decimal(...$args); }

$tests = [
    [0,             "0"],
    ["0",           "0"],
    ["+0",          "0"],
    ["-0",         "-0"],
    ["0.0",         "0.0"],
    ["1",           "1"],
    ["1.5",         "1.5"],
    ["0.1",         "0.1"],
    ["+0.1",        "0.1"],
    ["-0.1",       "-0.1"],
    [123,           "123"],
    [-123,         "-123"],

    ["0.00000000123",   "1.23E-9"],
    ["0.0000000123",    "1.23E-8"],
    ["0.000000123",     "1.23E-7"],
    ["0.00000123",      "0.00000123"],
    ["0.0000123",       "0.0000123"],
    ["0.000123",        "0.000123"],
    ["0.00123",         "0.00123"],
    ["0.0123",          "0.0123"],
    ["0.123",           "0.123"],
    ["1.23",            "1.23"],
    ["12.3",            "12.3"],
    ["123",             "123"],
    ["1230",            "1230"],
    ["12300",           "12300"],
    ["123000",          "123000"],
    ["1230000",         "1230000"],
    ["12300000",        "12300000"],
    ["123000000",       "123000000"],
    ["1230000000",      "1230000000"],

    // Uppercase E
    ["1.5E20",      "1.5E+20"],
    ["1.5E+20",     "1.5E+20"],
    ["1.5E-20",     "1.5E-20"],

    ["+1.5E20",     "1.5E+20"],
    ["+1.5E+20",    "1.5E+20"],
    ["+1.5E-20",    "1.5E-20"],

    ["-1.5E20",     "-1.5E+20"],
    ["-1.5E+20",    "-1.5E+20"],
    ["-1.5E-20",    "-1.5E-20"],

    // Lowercase e
    ["1.5e20",      "1.5E+20"],
    ["1.5e+20",     "1.5E+20"],
    ["1.5e-20",     "1.5E-20"],

    ["+1.5e20",     "1.5E+20"],
    ["+1.5e+20",    "1.5E+20"],
    ["+1.5e-20",    "1.5E-20"],

    ["-1.5e20",     "-1.5E+20"],
    ["-1.5e+20",    "-1.5E+20"],
    ["-1.5e-20",    "-1.5E-20"],

    // Special numbers
    [ "NAN",        "NAN"],
    [ "INF",        "INF"],
    ["+INF",        "INF"],
    ["-INF",       "-INF"],
    [ "nan",        "NAN"],
    [ "inf",        "INF"],
    ["+inf",        "INF"],
    ["-inf",       "-INF"],
    [ "NaN",        "NAN"],
    [ "Inf",        "INF"],
    ["+Inf",        "INF"],
    ["-Inf",       "-INF"],

    // Nested
    [decimal("0.1"), "0.1"],
];

foreach ($tests as $test) {
    $number = $test[0];
    $expect = $test[1];

    $results = [
        (string) decimal($number),
        decimal($number)->toString(),
        decimal($number)->__toString(),
    ];

    foreach ($results as $result) {
        if ($result !== $expect) {
            print_r(compact("number", "result", "expect"));
            break;
        }
    }
}

?>
--EXPECT--
