#include "Suma.hpp"

#include <new>
#include <Properties.hpp>
#include <Configuration.hpp>

Suma::Suma(const Configuration & conf) :
  SimulatedBlock(SUMA, conf),
  c_nodes(c_nodePool)
{
  BLOCK_CONSTRUCTOR(Suma);
  
  c_nodePool.setSize(MAX_NDB_NODES);
  c_masterNodeId = getOwnNodeId();
  
  // Add received signals
  addRecSignal(GSN_STTOR, &Suma::execSTTOR);
  addRecSignal(GSN_NDB_STTOR, &Suma::execNDB_STTOR);
  addRecSignal(GSN_DUMP_STATE_ORD, &Suma::execDUMP_STATE_ORD);
  addRecSignal(GSN_READ_NODESCONF, &Suma::execREAD_NODESCONF);
  addRecSignal(GSN_NODE_FAILREP, &Suma::execNODE_FAILREP);
  addRecSignal(GSN_INCL_NODEREQ, &Suma::execINCL_NODEREQ);
  addRecSignal(GSN_CONTINUEB, &Suma::execCONTINUEB);
}
  
Suma::~Suma()
{
}

BLOCK_FUNCTIONS(Suma);

