//=======================================================================
// baseconfig.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef LIBPACO_BASE_CONFIG_H
#define LIBPACO_BASE_CONFIG_H

#include <string>

namespace Paco {

class BaseConfig
{
	public:
	
	static void init();

	// Accessors
	static std::string const& logdir()	{ return sLogdir; }
	static std::string const& include()	{ return sInclude; }
	static std::string const& exclude()	{ return sExclude; }
	static bool logIgnoreErrors()		{ return sLogIgnoreErrors; }
	static bool logIgnoreShared()		{ return sLogIgnoreShared; }
	static bool caseSensitive()			{ return sCaseSensitive; }
	static int blockSize()				{ return sBlockSize; }
	static int maxDbAge()				{ return sMaxDbAge; }
	static std::string const stamp() 	{ return sLogdir + "/.updated"; }
	static bool logdirWritable()		{ return !access(sLogdir.c_str(), W_OK); }
	
	static bool checkLogdir();

	static void logdir(std::string const& __logdir)	{ sLogdir = __logdir; }

	// Public static member functions
	static void touchStamp();
	static std::string version();

	protected:

	static int const DEFAULT_BLOCK_SIZE	= 0;
	static int const DEFAULT_MAX_DB_AGE	= 7;	// one week

	// Protected static member data
	static std::string sLogdir;
	static std::string sInclude;
	static std::string sExclude;
	static bool sLogIgnoreErrors;
	static bool sLogIgnoreShared;
	static bool sCaseSensitive;
	static int sBlockSize;
	static int sMaxDbAge;

	BaseConfig();
	~BaseConfig();

	private:

	// Prevent copies
	BaseConfig(BaseConfig&);
	BaseConfig& operator=(BaseConfig&);

};	// class BaseConfig

}	// namespace Paco

#endif  // LIBPACO_BASE_CONFIG_H

