#!/bin/sh

if test "$CONFIGURE " != "YES "
then
	echo
	echo Error: Wrong usage
	echo
	echo You must run `dirname $0`/configure instead of $0
	exit 1
fi

if test "`ls .` " != " "
then
	echo Error: Current directory must be empty
	exit 1
fi

if test "`uname -p`" = "sparc"
then
KERNEL32=sparc
KERNEL64=sparcv9
KERNEL32FLAGS=-U
KERNEL64FLAGS=-K
else
if test "`uname -r`" = "5.9"
then
KERNEL32=i386
KERNEL64=NULL
KERNEL32FLAGS=
KERNEL64FLAGS=
else
KERNEL32=i386
KERNEL64=amd64
KERNEL32FLAGS=
KERNEL64FLAGS=-K
fi
fi

ln -s $SRCDIR/setup/SunOS/build.sh build.sh
ln -s $SRCDIR origdir
ln -s $SRCDIR/misc/samples/ddksample .
echo SRCDIR=$SRCDIR>.directories
echo > .nocopy

# Check if SADA headers are present in the system.

if test -f /usr/include/sys/audiovar.h
then
  HAVE_SADA=1
  export HAVE_SADA
else
  echo
  echo Warning! oss_sadasupport cannot be compiled in systems that have
  echo          Boomer installed.
  echo
fi

# Make the 32bit kernel drivers
mkdir $KERNEL32
echo "cd $KERNEL32;sh $SRCDIR/setup/setupdir.sh -A$KERNEL32 $KERNEL32FLAGS"
(cd $KERNEL32;sh $SRCDIR/setup/setupdir.sh -A$KERNEL32 $KERNEL32FLAGS)

# If KERNEL64 is specified then do both 32 and 64bit
if test "$KERNEL64" != "NULL"
then
	mkdir $KERNEL64
	echo "cd $KERNEL64;sh $SRCDIR/setup/setupdir.sh -A$KERNEL64 $KERNEL64FLAGS"
	(cd $KERNEL64;sh $SRCDIR/setup/setupdir.sh -A$KERNEL64 $KERNEL64FLAGS)

	# Make sure both 32 and 64 bit versions share the same timestamp.h file.
	cp $KERNEL32/kernel/framework/include/timestamp.h $KERNEL64/kernel/framework/include/timestamp.h 

	cat > Makefile <<THE_END_IS_NEAR
# Autogenerated file - do not edit

all:	$KERNEL32/kernel/framework/include/buildid.h subdirs build

install:	all
	rm -f prototype/kernel/drv/*.conf
	cp -R prototype/* /
	sync
	soundoff
	sync
	soundon
	sync

subdirs:
	cd $KERNEL32;make
	cd $KERNEL64;make

build:
	sh build.sh

copy:	all
	rm -f prototype/kernel/drv/*.conf
	cp -R prototype/* /

package:	all
	sh $KERNEL32/setup/SunOS/mkpkg.sh

clean:
	cd $KERNEL32;make clean
	cd $KERNEL64;make clean
	rm -f *.pkg
	rm -rf prototype

config:
	cd $KERNEL32;make config CONFIG_FLAGS=-A$KERNEL32
	cd $KERNEL64;make config CONFIG_FLAGS="-A$KERNEL64 -K"

THE_END_IS_NEAR

else	# Do just the 32bit kernel

cat > Makefile <<THE_END_IS_NEAR
# Autogenerated file - do not edit

all:    $KERNEL32/kernel/framework/include/buildid.h subdirs build

install:        all
	rm -f prototype/kernel/drv/*.conf
	cp -R prototype/* /
	sync
	soundoff
	sync
	soundon
	sync

subdirs:
	cd $KERNEL32;make

build:
	sh build.sh

copy:   all
	rm -f prototype/kernel/drv/*.conf
	cp -R prototype/* /

package:        all
	sh $KERNEL32/setup/SunOS/mkpkg.sh

clean:
	cd $KERNEL32;make clean
	rm -f *.pkg
	rm -rf prototype

config:
	cd $KERNEL32;make config CONFIG_FLAGS=-A$KERNEL32

THE_END_IS_NEAR
fi

rm -f .nocopy

#
# Check if some mandatory Solaris packages have been installed
#
MISSING=""
for n in SUNWgcc SUNWaudh SUNWusbu
do
  if pkginfo -q $n
  then
    OK=1
  else
    MISSING="$MISSING $n"
  fi
done

if test "$MISSING " != " "
then
	echo
	echo Some required Solaris packages may be missing. You can install them
	echo by doing:
	echo
	
	for n in $MISSING
	do
		echo pkg install $n
	done
fi

exit 0
