# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-866-1 (gnome-screensaver)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(66464);
 script_version ("$Revision$");
 script_tag(name:"risk_factor", value:"High");
 script_name("Ubuntu USN-866-1 (gnome-screensaver)");

 desc = "The remote host is missing an update to gnome-screensaver
announced via advisory USN-866-1.

Details follow:

It was discovered that gnome-screensaver did not always re-enable itself
after applications requested it to ignore idle timers. This may result in the
screen not being automatically locked after the inactivity timeout is
reached, permitting an attacker with physical access to gain access to an
unlocked session.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 9.10:
  gnome-screensaver               2.28.0-0ubuntu3.1

After a standard system upgrade you need to restart your session to effect
the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-866-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-866-1 (gnome-screensaver)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gnome-screensaver", ver:"2.28.0-0ubuntu3.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
