###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_wireshark_daintree_sna_dos_vuln_lin.nasl 6340 2009-12-23 12:52:09Z dec $
#
# Wireshark Daintree SNA File Parser Denial of Service Vulnerability (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900989);
  script_version("$Revision: 8289 $: 1.0");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-4376");
  script_bugtraq_id(37407);
  script_name("Wireshark Daintree SNA File Parser Denial of Service Vulnerability (Linux)");
  desc = "
  Overview: This host is installed with Wireshark and is prone to Denial of
  Service vulnerability.

  Vulnerability Insight:
  A boundary error occurs in the 'daintree_sna_read()' function in the Daintree
  SNA file parser while processing malformed captured pcap files.

  Impact:
  Successful exploitation will allow attackers to cause Denial of Serivce
  condition by tricking the user into opening a malformed packet trace file
  through Wireshark.

  Impact Level: System/Application.

  Affected Software/OS:
  Wireshark version 1.2.0 to 1.2.4 on Linux.

  Fix: Upgrade to Wireshark version 1.2.5,
  http://www.wireshark.org/download.html

  References:
  http://secunia.com/advisories/37842
  http://www.vupen.com/english/advisories/2009/3596
  http://www.wireshark.org/security/wnpa-sec-2009-09.html
  https://bugs.wireshark.org/bugzilla/show_bug.cgi?id=4294

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Wireshark");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_wireshark_detect_lin.nasl");
  script_require_keys("Wireshark/Linux/Ver");
  exit(0);
}


include("version_func.inc");

sharkVer = get_kb_item("Wireshark/Linux/Ver");
if(!sharkVer){
  exit(0);
}

# Grep for Wireshark version 1.2.0 to 1.2.4
if(version_in_range(version:sharkVer, test_version:"1.2.0",
                                     test_version2:"1.2.4")){
  security_hole(0);
}
