###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_vuplayer_asx_playlist_bof_vuln.nasl 872 2009-01-22 11:42:29Z jan $
#
# VUPlayer .asx Playlist File Buffer Overflow Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900193);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0174", "CVE-2009-0181", "CVE-2009-0182");
  script_bugtraq_id(33185);
  script_name("VUPlayer .asx Playlist File Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is installed with VUPlayer and is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  Certain .asx and .pls files fails to perform adequate boundary checks in
  HREF attribute of a REF element via long .asf file. This can also be
  exploited by a file composed entirely of 'A' characters.

  Impact:
  Attackers may leverage this issue by executing arbitrary code in the context
  of an affected application and can cause denial of service condition.

  Impact Level: Application

  Affected Software/OS:
  VUPlayer version 2.49 (2.4.9.0) and prior on Windows.

  Fix: No solution or patch is available as on 23nd January 2009, Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.vuplayer.com/vuplayer.php

  References:
  http://www.milw0rm.com/exploits/7709
  http://www.milw0rm.com/exploits/7713
  http://www.milw0rm.com/exploits/7714
  http://www.milw0rm.com/exploits/7715
  http://www.milw0rm.com/exploits/7695

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of VUPlayer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_vuplayer_detect.nasl");
  script_require_keys("VUPlayer/Version");
  exit(0);
}


include("version_func.inc");

vuplayerVer = get_kb_item("VUPlayer/Version");
if(!vuplayerVer){
  exit(0);
}

if(version_is_less_equal(version:vuplayerVer, test_version:"2.4.9.0")){
  security_hole(0);
}
