###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_pango_bof_vuln.nasl 2243 2009-05-20 15:05:27Z may $
#
# Pango Integer Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900644);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-1194");
  script_bugtraq_id(34870);
  script_name("Pango Integer Buffer Overflow Vulnerability");
  desc = "

  Overview: This host has installed with Pango and is prone to Integer Buffer
  Overflow vulnerability

  Vulnerability Insight:
  Error in pango_glyph_string_set_size function in pango/glyphstring.c file,
  which fails to perform adequate boundary checks on user-supplied data before
  using the data to allocate memory buffers.

  Impact:
  Successful exploitation will let the attacker to execute arbitrary code via
  a long glyph string, and can cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  Pango version prior to 1.24.0

  Fix:
  Upgrade to pango version 1.24.0 or later
  http://ftp.acc.umu.se/pub/GNOME/sources/pango/

  References:
  http://secunia.com/advisories/35018
  http://www.debian.org/security/2009/dsa-1798
  http://www.openwall.com/lists/oss-security/2009/05/07/1

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Pango");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_pango_detect.nasl");
  script_require_keys("Pango/Ver");
  exit(0);
}


include("version_func.inc");

pangoVer = get_kb_item("Pango/Ver");
if(!pangoVer){
  exit(0);
}

if(version_is_less(version:pangoVer, test_version:"1.24.0")){
  security_hole(0);
}
