##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mahara_detect.nasl 3100 2009-06-24 16:04:29Z jun $
#
# Mahara Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(900381);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Mahara Version Detection");
  desc = "

  Overview: This script detects the installed version of Mahara and
  sets the result in KB.

  Risk factor:None";

  script_description(desc);
  script_summary("Set KB for the Version of Mahara");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

maharaPort = get_http_port(default:80);
if(!maharaPort){
  maharaPort = 80;
}

if(!get_port_state(maharaPort)){
  exit(0);
}

foreach dir (make_list("/mahara" , "/", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/htdocs/index.php"), port:maharaPort);
  rcvRes = http_send_recv(port:maharaPort, data:sndReq);
  if("Welcome to Mahara" >< rcvRes)
  {
    sndReq = http_get(item:string(dir, "/htdocs/admin/index.php"),
                      port:maharaPort);
    rcvRes = http_send_recv(port:maharaPort, data:sndReq);
  }

  # Check for Welcome page and Login Page with proper Response
  if(("Log in to Mahara" >< rcvRes || "Welcome to Mahara" >< rcvRes)
     && egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    foreach path (make_list("/Changelog", "/debian/Changelog"))
    {
      # sndReq2 = string("GET ", dir, path, " \r\n\r\n");
      sndReq2 = string("GET ", dir, path, " \r\n\r\n");
      rcvRes2 = http_send_recv(port:maharaPort, data:sndReq2);
      if("mahara" >< rcvRes2)
      {
        # For greping the version line
        ver = egrep(pattern:"([0-9]\.[0-9]\.[0-9]+)", string:rcvRes2);
        # For matching the version
        ver = eregmatch(pattern:"^(mahara\ )?\(?(([0-9]\.[0-9]\.[0-9]+)(\~" +
                                "(beta|alpha)([0-9]))?\-?([0-9])?)\)?([^0-9]"+
                                "|$)", string:ver);
        # For replacing '~' or '-' with '.'
          maharaVer = ereg_replace(pattern:string("[~|-]"), replace:string("."),
                    string:ver[2]);
      }

      if(maharaVer != NULL)
      {
        set_kb_item(name:"www/"+ maharaPort + "/Mahara",
                    value:maharaVer + " under " + dir);
        security_note(data:"Mahara version " + maharaVer +
                 " running at location " + dir +  " was detected on the host");
        break;
      }
    }
  }
}
