###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for network-manager-applet vulnerabilities USN-883-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840367);
  script_version("$Revision: 7480 $: 1.0");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "883-1");
  script_cve_id("CVE-2009-4144", "CVE-2009-4145");
  script_name("Ubuntu Update for network-manager-applet vulnerabilities USN-883-1");
  desc = "

  Vulnerability Insight:

  It was discovered that NetworkManager did not ensure that the Certification
  Authority (CA) certificate file remained present when using WPA Enterprise
  or 802.1x networks. A remote attacker could use this flaw to spoof the
  identity of a wireless network and view sensitive information.
  (CVE-2009-4144)
  
  It was discovered that the connection editor GUI would incorrectly export
  objects over D-Bus. A local user could read D-Bus signals to view other
  users' network connection passwords and pre-shared keys. (CVE-2009-4145)

  Affected Software/OS:
  network-manager-applet vulnerabilities on Ubuntu 8.10 ,
  Ubuntu 9.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-January/001025.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of network-manager-applet vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"network-manager-gnome", ver:"0.7.1~rc4.1-0ubuntu2.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"network-manager-gnome", ver:"0.7~~svn20081020t000444-0ubuntu1.8.10.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}