###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_ie_xss_vuln_jul09.nasl 3327 2009-07-08 11:36:05Z jul $
#
# Microsoft Internet Explorer XSS Vulnerability - July09
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800902);
  script_version("$Revision: 1.0");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2350");
  script_bugtraq_id(35570);
  script_name("Microsoft Internet Explorer XSS Vulnerability - July09");
  desc = "

  Overview:
  The host is installed with Internet Explorer and is prone to Cross-Site
  Scripting vulnerability.

  Vulnerability Insight:
  The flaw occurs because IE does not block Javascript URIs in Refresh headers
  in HTTP responses which may be exploited via vectors related to injecting a
  Refresh header or specifying the content of a Refresh header.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code in
  the context of the application and to steal cookie-based authentication
  credentials and other sensitive data.

  Impact Level: Application

  Affected Software/OS:
  Internet Explorer 6.0.2900.2180 and prior.

  Fix: No solution or patch is available as on 08th July, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.microsoft.com/windows/products/default.aspx

  References:
  http://websecurity.com.ua/3275
  http://www.securityfocus.com/archive/1/504718/100/0/threaded
  http://www.securityfocus.com/archive/1/504723/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Windows");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  exit(0);
}


include("version_func.inc");

ieVer = get_kb_item("MS/IE/Version");
if(!ieVer){
  exit(0);
}

# Check for Internet Explorer 6.0.2900.2180 and prior
if(version_is_less_equal(version:ieVer, test_version:"6.0.2900.2180")){
  security_warning(0);
}
