###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for spamassassin MDVA-2010:014 (spamassassin)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830785);
  script_version("$Revision: 7452 $: 1.0");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDVA", value: "2010:014");
  script_name("Mandriva Update for spamassassin MDVA-2010:014 (spamassassin)");
  desc = "

  Vulnerability Insight:

  A bug was discovered in the FH_DATE_PAST_20XX rules that affects
  vanilla spamassassin 3.2 installations after the first of January 2010
  (aka. the y2k10 rule bug).
  
  This update fixes this issue.

  Affected Software/OS:
  spamassassin on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64,
  Mandriva Linux 2009.1,
  Mandriva Linux 2009.1/X86_64,
  Mandriva Linux 2010.0,
  Mandriva Linux 2010.0/X86_64,
  Mandriva Enterprise Server 5,
  Mandriva Enterprise Server 5/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-01/msg00019.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of spamassassin");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"perl-Mail-SpamAssassin", rpm:"perl-Mail-SpamAssassin~3.2.3~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin", rpm:"spamassassin~3.2.3~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-spamc", rpm:"spamassassin-spamc~3.2.3~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-spamd", rpm:"spamassassin-spamd~3.2.3~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-tools", rpm:"spamassassin-tools~3.2.3~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_mes5")
{

  if(isrpmvuln(pkg:"perl-Mail-SpamAssassin", rpm:"perl-Mail-SpamAssassin~3.2.5~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-Mail-SpamAssassin-Spamd", rpm:"perl-Mail-SpamAssassin-Spamd~3.2.5~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin", rpm:"spamassassin~3.2.5~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-sa-compile", rpm:"spamassassin-sa-compile~3.2.5~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-spamc", rpm:"spamassassin-spamc~3.2.5~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-spamd", rpm:"spamassassin-spamd~3.2.5~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-tools", rpm:"spamassassin-tools~3.2.5~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2010.0")
{

  if(isrpmvuln(pkg:"perl-Mail-SpamAssassin", rpm:"perl-Mail-SpamAssassin~3.2.5~11.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-Mail-SpamAssassin-Spamd", rpm:"perl-Mail-SpamAssassin-Spamd~3.2.5~11.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin", rpm:"spamassassin~3.2.5~11.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-sa-compile", rpm:"spamassassin-sa-compile~3.2.5~11.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-spamc", rpm:"spamassassin-spamc~3.2.5~11.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-spamd", rpm:"spamassassin-spamd~3.2.5~11.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-tools", rpm:"spamassassin-tools~3.2.5~11.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.1")
{

  if(isrpmvuln(pkg:"perl-Mail-SpamAssassin", rpm:"perl-Mail-SpamAssassin~3.2.5~10.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-Mail-SpamAssassin-Spamd", rpm:"perl-Mail-SpamAssassin-Spamd~3.2.5~10.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin", rpm:"spamassassin~3.2.5~10.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-sa-compile", rpm:"spamassassin-sa-compile~3.2.5~10.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-spamc", rpm:"spamassassin-spamc~3.2.5~10.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-spamd", rpm:"spamassassin-spamd~3.2.5~10.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-tools", rpm:"spamassassin-tools~3.2.5~10.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"perl-Mail-SpamAssassin", rpm:"perl-Mail-SpamAssassin~3.2.5~5.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-Mail-SpamAssassin-Spamd", rpm:"perl-Mail-SpamAssassin-Spamd~3.2.5~5.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin", rpm:"spamassassin~3.2.5~5.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-sa-compile", rpm:"spamassassin-sa-compile~3.2.5~5.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-spamc", rpm:"spamassassin-spamc~3.2.5~5.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-spamd", rpm:"spamassassin-spamd~3.2.5~5.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-tools", rpm:"spamassassin-tools~3.2.5~5.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}