###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for rpmdrake MDVA-2008:063 (rpmdrake)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830556);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDVA", value: "2008:063");
  script_name( "Mandriva Update for rpmdrake MDVA-2008:063 (rpmdrake)");
  desc = "

  Vulnerability Insight:

  This update fixes several minor issues in rpmdrake:
  
  - it prevents crashing if the RPM database is locked when trying to
  install some packages (bug #40244)
  - it fixes a crash when the default view is unknown (bug #39626)
  - it enables searching also with the numeric pad's Enter key (bug
  #40659)
  - it makes rpmdrake not list backports as (unselected) updates,
  like MandrivaUpdate does
  
  It also makes MandrivaUpdate fit in laptops screen (eg when resolution
  only has 480 horizontal lines)

  Affected Software/OS:
  rpmdrake on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-05/msg00016.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of rpmdrake");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"rpmdrake", rpm:"rpmdrake~4.9.13.1~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}