###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for tar FEDORA-2007-735
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861470);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-735");
  script_cve_id("CVE-2007-4476");
  script_name( "Fedora Update for tar FEDORA-2007-735");
  desc = "

  Vulnerability Insight:
  The GNU tar program saves many files together in one archive and can
  restore individual files (or all of the files) from that archive. Tar
  can also be used to add supplemental files to an archive and to update
  or list files in the archive. Tar includes multivolume support,
  automatic archive compression/decompression, the ability to perform
  remote archives, and the ability to perform incremental and full
  backups.
  
  If you want to use tar for remote backups, you also need to install
  the rmt package


  Affected Software/OS:
  tar on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00073.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of tar");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"tar", rpm:"tar~1.15.1~27.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/tar-debuginfo", rpm:"x86_64/debug/tar-debuginfo~1.15.1~27.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/tar", rpm:"x86_64/tar~1.15.1~27.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/tar", rpm:"i386/tar~1.15.1~27.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/tar-debuginfo", rpm:"i386/debug/tar-debuginfo~1.15.1~27.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}